/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.operator.stream.sql;

import com.alibaba.alink.common.MLEnvironment;
import com.alibaba.alink.common.MLEnvironmentFactory;
import com.alibaba.alink.common.sql.builtin.AlinkRegisterBuiltinFunctions;
import com.alibaba.alink.operator.stream.StreamOperator;
import com.alibaba.alink.params.sql.SqlCmdParams;
import java.util.HashSet;
import org.apache.flink.ml.api.misc.param.Params;
import org.apache.flink.table.api.TableEnvironment;

public final class SqlCmdStreamOp
extends StreamOperator<SqlCmdStreamOp>
implements SqlCmdParams<SqlCmdStreamOp> {
    public static final Integer INPUT_NUM = 5;
    private String[] alias;

    public SqlCmdStreamOp() {
        this(new Params());
    }

    public SqlCmdStreamOp(Params params) {
        super(params);
    }

    public SqlCmdStreamOp(String[] alias, String command) {
        this(new Params().set("alias", (Object)alias).set(COMMAND, (Object)command));
    }

    public SqlCmdStreamOp(String command) {
        this(new Params().set(COMMAND, (Object)command));
    }

    private boolean isDuplicated() {
        HashSet<String> nameSet = new HashSet<String>();
        for (int i = 0; i < this.alias.length; ++i) {
            if (this.alias[i] != null && nameSet.contains(this.alias[i])) {
                return true;
            }
            nameSet.add(this.alias[i]);
        }
        return false;
    }

    public SqlCmdStreamOp linkFrom(StreamOperator<?> ... inputs) {
        SqlCmdStreamOp.checkMinOpSize((int)1, inputs);
        if (this.getParams().contains("alias")) {
            this.alias = this.getParams().getStringArray("alias");
            if (this.isDuplicated()) {
                throw new RuntimeException("alias are duplicated.");
            }
            long sessionId = this.getMLEnvironmentId();
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] == null || i >= this.alias.length || this.alias[i] == null || this.alias[i].isEmpty()) continue;
                inputs[i].registerTableName(this.alias[i]);
                if (sessionId == inputs[i].getMLEnvironmentId()) continue;
                sessionId = inputs[i].getMLEnvironmentId();
            }
            if (this.getMLEnvironmentId() != sessionId) {
                this.setMLEnvironmentId(sessionId);
            }
            MLEnvironment env = MLEnvironmentFactory.get((Long)sessionId);
            AlinkRegisterBuiltinFunctions.RegisterFunctions((TableEnvironment)env.getStreamTableEnvironment());
            this.setOutputTable(((StreamOperator)env.streamSQL(this.getCommand()).setMLEnvironmentId(Long.valueOf(sessionId))).getOutputTable());
            return this;
        }
        long sessionId = this.getMLEnvironmentId();
        String cmd = this.getCommand();
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            cmd = cmd.replace("${t" + i + "}", inputs[i].getTableName());
            if (sessionId == inputs[i].getMLEnvironmentId()) continue;
            sessionId = inputs[i].getMLEnvironmentId();
        }
        if (this.getMLEnvironmentId() != sessionId) {
            this.setMLEnvironmentId(sessionId);
        }
        MLEnvironment env = MLEnvironmentFactory.get((Long)sessionId);
        AlinkRegisterBuiltinFunctions.RegisterFunctions((TableEnvironment)env.getStreamTableEnvironment());
        this.setOutputTable(((StreamOperator)env.streamSQL(cmd).setMLEnvironmentId(Long.valueOf(sessionId))).getOutputTable());
        return this;
    }
}

