/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.operator.common.similarity;

import com.alibaba.alink.common.linalg.Vector;
import com.alibaba.alink.common.linalg.VectorUtil;
import com.alibaba.alink.operator.common.distance.CosineDistance;
import com.alibaba.alink.operator.common.distance.EuclideanDistance;
import com.alibaba.alink.operator.common.distance.ManHattanDistance;
import org.apache.flink.table.functions.ScalarFunction;

public class VectorDistanceUDF
extends ScalarFunction {
    public Double eval(String d1, String d2) {
        return this.eval(d1, d2, "euclidean");
    }

    public Double eval(String d1, String d2, String method) {
        double v;
        if (d1 == null || d2 == null || d1.length() == 0 || d2.length() == 0) {
            return 0.0;
        }
        Vector v1 = VectorUtil.getVector((Object)d1);
        Vector v2 = VectorUtil.getVector((Object)d2);
        switch (method) {
            case "euclidean": {
                v = new EuclideanDistance().calc(v1, v2);
                break;
            }
            case "manhattan": {
                v = new ManHattanDistance().calc(v1, v2);
                break;
            }
            case "cosine": {
                v = new CosineDistance().calc(v1, v2);
                break;
            }
            default: {
                v = 0.0;
            }
        }
        return v;
    }
}

