/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import org.apache.flink.ml.api.misc.param.Params;

public class JsonUtil {
    private static Gson zipGson = new GsonBuilder().disableHtmlEscaping().create();
    public static Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    public static Params convertToAlinkParameter(Map<String, String> m) {
        return Params.fromJson((String)gson.toJson(m));
    }

    public static String[] GetJsonValues(JsonObject json, String[] keys, boolean ignoreError) {
        String[] ret = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            if (json.has(keys[i])) {
                ret[i] = json.get(keys[i]).getAsString();
                continue;
            }
            if (ignoreError) {
                ret[i] = null;
                continue;
            }
            throw new RuntimeException("Parameter[" + keys[i] + "] is required");
        }
        return ret;
    }

    public static String[] GetJsonValues(JsonObject json, String[] keys) {
        return JsonUtil.GetJsonValues(json, keys, false);
    }

    public static String[] GetJsonValues(String config, String[] keys) {
        return JsonUtil.GetJsonValues(new JsonParser().parse(config).getAsJsonObject(), keys);
    }

    public static String[] GetJsonValues(String config, String[] keys, boolean ignoreError) {
        return JsonUtil.GetJsonValues(new JsonParser().parse(config).getAsJsonObject(), keys, ignoreError);
    }

    public static <T> T GetJsonValueWithDefault(String config, String key, Class<T> type, T defaultValue) {
        try {
            JsonObject j = new JsonParser().parse(config).getAsJsonObject();
            return (T)(j.has(key) ? gson.fromJson(j.get(key), type) : defaultValue);
        }
        catch (JsonSyntaxException ex) {
            return defaultValue;
        }
    }

    public static JsonObject makeJsonObject(String key, Object val, Object ... args) {
        JsonObject j = new JsonObject();
        j.add(key, zipGson.toJsonTree(val));
        for (int i = 0; i < args.length; i += 2) {
            j.add((String)args[i], zipGson.toJsonTree(args[i + 1]));
        }
        return j;
    }
}

