#!/usr/bin/env python3
###############################################################################
#
# MIT License
#
# Copyright (c) 2022 Advanced Micro Devices, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#
###############################################################################
"""Module to export find_db to txt file"""
import sqlite3
import json
import os
import argparse

from tuna.utils.logger import setup_logger

# Setup logging
LOGGER = setup_logger('BuildFDB')


def parse_args():
  """Function to parse arguments"""
  parser = argparse.ArgumentParser(
      'Create a pruned version of the perf_db using a json error file')
  parser.add_argument('-i',
                      '--input_db',
                      dest='perf_db',
                      help='perf db to prune',
                      default='')
  parser.add_argument(
      '-j',
      '--err_json',
      dest='err_json',
      help=
      'json file with perf db deserialization errors. '\
      'This is generated by the fin perf_db_test command',
      default='')
  args = parser.parse_args()
  return args


def prune_copy_pdb(perf_db, err_json):
  """ export perf db from mysql to sqlite """
  filename = os.path.basename(perf_db)
  outpath = "{}/{}".format(os.getcwd(), filename)
  f_out = open(perf_db, 'rb')
  f_in = open(outpath, 'wb')
  f_in.write(f_out.read())
  f_out.close()
  f_in.close()

  json_imp = None
  with open(err_json) as out_file:
    json_imp = json.load(out_file)

  cnx = sqlite3.connect(outpath)
  cur = cnx.cursor()

  num_del = 0
  db_err_nm = "{}_errors".format(filename)
  for elem in json_imp:
    if db_err_nm in elem.keys():
      for ser_err in elem[db_err_nm]:
        deletion = "DELETE from perf_db where id={}".format(
            ser_err['perfdb_id'])
        LOGGER.warning(deletion)
        cur.execute(deletion)
        num_del += 1

  cnx.commit()

  cur.execute('VACUUM;')

  cur.close()
  cnx.commit()

  LOGGER.warning("Number of entries pruned from perf_db: %s", num_del)

  return outpath


def main():
  """Main module function"""
  args = parse_args()
  result_file = ''
  result_file = prune_copy_pdb(args.perf_db, args.err_json)
  print(result_file)


if __name__ == '__main__':
  main()
