# polyanalyst6api

[![PyPI package](https://img.shields.io/pypi/v/polyanalyst6api.svg?)](https://pypi.org/project/polyanalyst6api)
[![Supported Python versions](https://img.shields.io/pypi/pyversions/polyanalyst6api.svg?)](https://pypi.org/project/polyanalyst6api/)
[![MIT License](https://img.shields.io/apm/l/atomic-design-ui.svg?)](https://github.com/Megaputer/polyanalyst6api-python/blob/master/LICENSE)

`polyanalyst6api` is a Python library for interacting with PolyAnalyst APIs.

This package provides easy to use wrappers for PolyAnalyst `Analytical Client`, `Scheduler` and `Drive`.
With it you can execute nodes, view datasets, run tasks, download/upload files and so on.

## Installation

Python 3.6+ is required. Install, upgrade and uninstall `polyanalyst6api-python` with these commands:

```
$ pip install polyanalyst6api
$ pip install --upgrade polyanalyst6api
$ pip uninstall polyanalyst6api
```

## Documentation

See [API Reference](https://megaputer.github.io/polyanalyst6api-python/) for the library methods.

Refer to **PolyAnalyst User Manual** at **Application Programming Interfaces** > **Version 01** for
REST API specification.

## Usage

### Authentication

Use `API` context manager to automatically log in and log out of PolyAnalyst server:
```python
from polyanalyst6api import API

with API(POLYANALIST_URL, USERNAME, PASSWORD) as api:
    ...
```

### Working with project

Instantiate project wrapper by calling with existing project ID:
```python
prj = api.project(PROJECT_UUID)
```

Set `Python` node code using parent `Parameters` node.
```python
prj.parameters('Parameters (1)').set('Dataset/Python', {'Script': 'result = pandas.DataFrame([{"val": 42}])'})
```

Execute `Python` node and wait to complete execution
```python
prj.execute('Python', wait=True)
```

Check node results:
```python
ds = prj.dataset('Python').preview()
assert ds[0]['val'] == 42
```

Save project:
```python
prj.save()
```

### Downloading file from user home folder using PA Drive API

```python
content = api.drive.download_file('README.txt')
with open(r'C:\README.txt', mode='wb+') as local_file:
    local_file.write(content)
```

See [polyanalyst6api-python/examples](https://github.com/Megaputer/polyanalyst6api-python/tree/master/examples) for more complex examples.

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details
