"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcEndpointServiceAttachment = exports.VpcEndpointServiceAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const privatelink_generated_1 = require("./privatelink.generated");
Object.defineProperty(exports, "VpcEndpointServiceAttachmentProperty", { enumerable: true, get: function () { return privatelink_generated_1.RosVpcEndpointServiceAttachment; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PrivateLink::VpcEndpointServiceAttachment`, which is used to add a service resource to an endpoint service.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosVpcEndpointServiceAttachment`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-privatelink-vpcendpointserviceattachment
 */
class VpcEndpointServiceAttachment extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosVpcEndpointServiceAttachment = new privatelink_generated_1.RosVpcEndpointServiceAttachment(this, id, {
            resourceId: props.resourceId,
            resourceType: props.resourceType,
            serviceId: props.serviceId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosVpcEndpointServiceAttachment;
        this.attrResourceId = rosVpcEndpointServiceAttachment.attrResourceId;
        this.attrResourceType = rosVpcEndpointServiceAttachment.attrResourceType;
        this.attrServiceId = rosVpcEndpointServiceAttachment.attrServiceId;
    }
}
exports.VpcEndpointServiceAttachment = VpcEndpointServiceAttachment;
//# sourceMappingURL=data:application/json;base64,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