"""
Django settings for web project.

Generated by 'django-admin startproject' using Django 1.11.3.

For more information on this file, see
https://docs.djangoproject.com/en/1.11/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.11/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.11/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '@@n624%u@h@jcfrjkl9_me_#_k$a^e9w@=pjcui#z--djvqh9n'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['*']


# Application definition

INSTALLED_APPS = [
    'example.apps.ExampleConfig',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

# this is the portal domain
PORTAL_DOMAIN = os.environ.get('DOMAIN', 'my.solarlux.com')

# used for menu generation - if unset a local menu is used
# e.g. https://my.solarlux.com/menu/rest/portal-config
PORTAL_CONFIG_URL = os.environ.get('PORTAL_CONFIG_URL', 'https://%s/menu/rest/portal-config' % PORTAL_DOMAIN)

OAUTH_ENABLED = bool(os.environ.get('OAUTH_ENABLED', False))
OAUTH_URL = os.environ.get('OAUTH_URL', 'https://%s/auth/oauth' % PORTAL_DOMAIN)
OAUTH_COOKIE_DOMAIN = os.environ.get('OAUTH_COOKIE_DOMAIN', '')
OAUTH_CLIENT_ID = os.environ.get('OAUTH_CLIENT_ID', 'my-client-with-registered-redirect')
OAUTH_CLIENT_SECRET = os.environ.get('OAUTH_CLIENT_SECRET', 'secret')
OAUTH_PUBLIC_KEY = os.environ.get('OAUTH_PUBLIC_KEY', 'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiahLhO5+1bWfqSQhdCR7RJLpveU0OICX5rPb4N5AMx6uGhwCgO9U44kkg1Z/K+atcokYJUW72pij0TjFpz9XOAIR1BbpzpsSE/ixe1cRx2kDG1ABiCvWBsldnuuW/KhZi9FtQGnVBysKiXT/0Y87MtJo63ZQwKOK9DSdQWiz/zWgij9oR4Q2Cl3iBrQ3h8HMYEswhKrZfO+GEz8BKUgLeUMr6TJtJQX85Z+ulWcTsxbAZZPzAiNlnBbbd8MV3rimEcfE/0vbRoFXZ/yfQ8PlD09MdrCXjCGnr1WKrKkse9HgTDjnBiewMZiHswYfHHiEqSCw4o3U2XtjGGXWSZiv5wIDAQAB')
OAUTH_ROLES_REQUIRED = os.environ.get('OAUTH_ROLES_REQUIRED', '').split()
OAUTH_ROLES_STAFF = os.environ.get('OAUTH_ROLES_STAFF', 'ROLE_SOLARLUX_ADMIN').split()
OAUTH_ROLES_SUPERUSER = os.environ.get('OAUTH_ROLES_SUPERUSER', 'ROLE_SOLARLUX_ADMIN').split()

if OAUTH_ENABLED:
    MIDDLEWARE += [
        'slxauth.middleware.TokenAuthMiddleware',
    ]


# Logging
# https://docs.djangoproject.com/en/1.11/topics/logging/

LOGGING = {
    'version': 1,
    'disable_existing_loggers': True,
    'formatters': {
        'standard': {
            'format': '%(asctime)s [%(levelname)s] %(name)s: %(message)s'
        },
    },
    'handlers': {
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
            'formatter': 'standard'
        }
    },
    'loggers': {
        'django': {
            'handlers': ['console',],
            'level': 'INFO',
            'propagate': True,
        },
        'slxauth': {
            'handlers': ['console',],
            'level': 'INFO',
            'propagate': True,
        },
        'portal_ui': {
            'handlers': ['console',],
            'level': 'INFO',
            'propagate': True,
        },
        'app': {
            'handlers': ['console',],
            'level': 'INFO',
            'propagate': True,
        },
    }
}

if DEBUG:
    LOGGING['loggers']['django']['level'] = 'DEBUG'
    LOGGING['loggers']['slxauth']['level'] = 'DEBUG'
    LOGGING['loggers']['portal_ui']['level'] = 'DEBUG'
    LOGGING['loggers']['app']['level'] = 'DEBUG'

LOGSTASH_ENABLED = bool(os.environ.get('LOGSTASH_ENABLED', False))
LOGSTASH_HOST = os.environ.get('LOGSTASH_HOST', 'srv-appmetrics.slx.de')
LOGSTASH_PORT = int(os.environ.get('LOGSTASH_PORT', 5959))
LOGSTASH_TAGS = os.environ.get('LOGSTASH_TAGS', '').split()
if LOGSTASH_ENABLED:
    LOGGING['handlers']['logstash'] = {
        'level': 'INFO',
        'class': 'logstash.LogstashHandler',
        'host': LOGSTASH_HOST,
        'port': LOGSTASH_PORT,
        'version': 1,
        'message_type': 'logstash',
        'fqdn': False,
        'tags': LOGSTASH_TAGS,
    }
    LOGGING['loggers']['django']['handlers'].append('logstash')
    LOGGING['loggers']['slxauth']['handlers'].append('logstash')
    LOGGING['loggers']['portal_ui']['handlers'].append('logstash')
    LOGGING['loggers']['app']['handlers'].append('logstash')

ROOT_URLCONF = 'web.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'web.wsgi.application'


# Database
# https://docs.djangoproject.com/en/1.11/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}


# Password validation
# https://docs.djangoproject.com/en/1.11/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/1.11/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.11/howto/static-files/

SCRIPT_NAME = os.environ.get('SCRIPT_NAME', '')
LOGIN_URL = '%s/accounts/login' % SCRIPT_NAME

STATIC_URL = '%s/static/' % SCRIPT_NAME
MEDIA_URL = '%s/media/' % SCRIPT_NAME

LOGOUT_REDIRECT_URL = '%s/' % SCRIPT_NAME

AUTH_USER_MODEL = 'example.MyUser'
