# coding: utf-8

"""
    Qase.io TestOps API v1

    Qase TestOps API v1 Specification.

    The version of the OpenAPI document: 1.0.0
    Contact: support@qase.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from qase.api_client_v1.models.defect_query import DefectQuery
from qase.api_client_v1.models.plan_query import PlanQuery
from qase.api_client_v1.models.requirement import Requirement
from qase.api_client_v1.models.result import Result
from qase.api_client_v1.models.run import Run
from qase.api_client_v1.models.test_case_query import TestCaseQuery
from pydantic import StrictStr, Field
from typing import Union, List, Optional, Dict
from typing_extensions import Literal, Self

SEARCHRESPONSEALLOFRESULTENTITIES_ONE_OF_SCHEMAS = ["DefectQuery", "PlanQuery", "Requirement", "Result", "Run", "TestCaseQuery"]

class SearchResponseAllOfResultEntities(BaseModel):
    """
    SearchResponseAllOfResultEntities
    """
    # data type: Run
    oneof_schema_1_validator: Optional[Run] = None
    # data type: Result
    oneof_schema_2_validator: Optional[Result] = None
    # data type: Requirement
    oneof_schema_3_validator: Optional[Requirement] = None
    # data type: TestCaseQuery
    oneof_schema_4_validator: Optional[TestCaseQuery] = None
    # data type: DefectQuery
    oneof_schema_5_validator: Optional[DefectQuery] = None
    # data type: PlanQuery
    oneof_schema_6_validator: Optional[PlanQuery] = None
    actual_instance: Optional[Union[DefectQuery, PlanQuery, Requirement, Result, Run, TestCaseQuery]] = None
    one_of_schemas: List[str] = Field(default=Literal["DefectQuery", "PlanQuery", "Requirement", "Result", "Run", "TestCaseQuery"])

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = SearchResponseAllOfResultEntities.model_construct()
        error_messages = []
        match = 0
        # validate data type: Run
        if not isinstance(v, Run):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Run`")
        else:
            match += 1
        # validate data type: Result
        if not isinstance(v, Result):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Result`")
        else:
            match += 1
        # validate data type: Requirement
        if not isinstance(v, Requirement):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Requirement`")
        else:
            match += 1
        # validate data type: TestCaseQuery
        if not isinstance(v, TestCaseQuery):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TestCaseQuery`")
        else:
            match += 1
        # validate data type: DefectQuery
        if not isinstance(v, DefectQuery):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DefectQuery`")
        else:
            match += 1
        # validate data type: PlanQuery
        if not isinstance(v, PlanQuery):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PlanQuery`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in SearchResponseAllOfResultEntities with oneOf schemas: DefectQuery, PlanQuery, Requirement, Result, Run, TestCaseQuery. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in SearchResponseAllOfResultEntities with oneOf schemas: DefectQuery, PlanQuery, Requirement, Result, Run, TestCaseQuery. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into Run
        try:
            instance.actual_instance = Run.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Result
        try:
            instance.actual_instance = Result.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Requirement
        try:
            instance.actual_instance = Requirement.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TestCaseQuery
        try:
            instance.actual_instance = TestCaseQuery.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DefectQuery
        try:
            instance.actual_instance = DefectQuery.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PlanQuery
        try:
            instance.actual_instance = PlanQuery.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into SearchResponseAllOfResultEntities with oneOf schemas: DefectQuery, PlanQuery, Requirement, Result, Run, TestCaseQuery. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into SearchResponseAllOfResultEntities with oneOf schemas: DefectQuery, PlanQuery, Requirement, Result, Run, TestCaseQuery. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], DefectQuery, PlanQuery, Requirement, Result, Run, TestCaseQuery]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


