# coding: utf-8

"""
    Qase.io TestOps API v1

    Qase TestOps API v1 Specification.

    The version of the OpenAPI document: 1.0.0
    Contact: support@qase.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ResultCreateCase(BaseModel):
    """
    Could be used instead of `case_id`.
    """ # noqa: E501
    title: Optional[StrictStr] = None
    suite_title: Optional[StrictStr] = Field(default=None, description="Nested suites should be separated with `TAB` symbol.")
    description: Optional[StrictStr] = None
    preconditions: Optional[StrictStr] = None
    postconditions: Optional[StrictStr] = None
    layer: Optional[StrictStr] = Field(default=None, description="Slug of the layer. You can get it in the System Field settings.")
    severity: Optional[StrictStr] = Field(default=None, description="Slug of the severity. You can get it in the System Field settings.")
    priority: Optional[StrictStr] = Field(default=None, description="Slug of the priority. You can get it in the System Field settings.")
    __properties: ClassVar[List[str]] = ["title", "suite_title", "description", "preconditions", "postconditions", "layer", "severity", "priority"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResultCreateCase from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if suite_title (nullable) is None
        # and model_fields_set contains the field
        if self.suite_title is None and "suite_title" in self.model_fields_set:
            _dict['suite_title'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if preconditions (nullable) is None
        # and model_fields_set contains the field
        if self.preconditions is None and "preconditions" in self.model_fields_set:
            _dict['preconditions'] = None

        # set to None if postconditions (nullable) is None
        # and model_fields_set contains the field
        if self.postconditions is None and "postconditions" in self.model_fields_set:
            _dict['postconditions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResultCreateCase from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "suite_title": obj.get("suite_title"),
            "description": obj.get("description"),
            "preconditions": obj.get("preconditions"),
            "postconditions": obj.get("postconditions"),
            "layer": obj.get("layer"),
            "severity": obj.get("severity"),
            "priority": obj.get("priority")
        })
        return _obj


