# coding: utf-8

"""
    Qase.io TestOps API v1

    Qase TestOps API v1 Specification.

    The version of the OpenAPI document: 1.0.0
    Contact: support@qase.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from qase.api_client_v1.models.project_counts_defects import ProjectCountsDefects
from qase.api_client_v1.models.project_counts_runs import ProjectCountsRuns
from typing import Optional, Set
from typing_extensions import Self

class ProjectCounts(BaseModel):
    """
    ProjectCounts
    """ # noqa: E501
    cases: Optional[StrictInt] = None
    suites: Optional[StrictInt] = None
    milestones: Optional[StrictInt] = None
    runs: Optional[ProjectCountsRuns] = None
    defects: Optional[ProjectCountsDefects] = None
    __properties: ClassVar[List[str]] = ["cases", "suites", "milestones", "runs", "defects"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectCounts from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of runs
        if self.runs:
            _dict['runs'] = self.runs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of defects
        if self.defects:
            _dict['defects'] = self.defects.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectCounts from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cases": obj.get("cases"),
            "suites": obj.get("suites"),
            "milestones": obj.get("milestones"),
            "runs": ProjectCountsRuns.from_dict(obj["runs"]) if obj.get("runs") is not None else None,
            "defects": ProjectCountsDefects.from_dict(obj["defects"]) if obj.get("defects") is not None else None
        })
        return _obj


