# coding: utf-8

"""
    Qase.io TestOps API v1

    Qase TestOps API v1 Specification.

    The version of the OpenAPI document: 1.0.0
    Contact: support@qase.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from qase.api_client_v1.models.plan_detailed_all_of_cases import PlanDetailedAllOfCases
from typing import Optional, Set
from typing_extensions import Self

class PlanDetailed(BaseModel):
    """
    PlanDetailed
    """ # noqa: E501
    id: Optional[StrictInt] = None
    title: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    cases_count: Optional[StrictInt] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    created: Optional[StrictStr] = Field(default=None, description="Deprecated, use the `created_at` property instead.")
    updated: Optional[StrictStr] = Field(default=None, description="Deprecated, use the `updated_at` property instead.")
    average_time: Optional[Union[StrictFloat, StrictInt]] = None
    cases: Optional[List[PlanDetailedAllOfCases]] = None
    __properties: ClassVar[List[str]] = ["id", "title", "description", "cases_count", "created_at", "updated_at", "created", "updated", "average_time", "cases"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlanDetailed from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cases (list)
        _items = []
        if self.cases:
            for _item in self.cases:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cases'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlanDetailed from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "cases_count": obj.get("cases_count"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "created": obj.get("created"),
            "updated": obj.get("updated"),
            "average_time": obj.get("average_time"),
            "cases": [PlanDetailedAllOfCases.from_dict(_item) for _item in obj["cases"]] if obj.get("cases") is not None else None
        })
        return _obj


