"""
    CryptoAPIs

    Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: developers@cryptoapis.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cryptoapis.api_client import ApiClient, Endpoint as _Endpoint
from cryptoapis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cryptoapis.model.get_latest_mined_xrp_ripple_block_r import GetLatestMinedXRPRippleBlockR
from cryptoapis.model.get_xrp_ripple_address_details_r import GetXRPRippleAddressDetailsR
from cryptoapis.model.get_xrp_ripple_block_details_by_block_hash_r import GetXRPRippleBlockDetailsByBlockHashR
from cryptoapis.model.get_xrp_ripple_block_details_by_block_height_r import GetXRPRippleBlockDetailsByBlockHeightR
from cryptoapis.model.get_xrp_ripple_transaction_details_by_transaction_idr import GetXRPRippleTransactionDetailsByTransactionIDR
from cryptoapis.model.inline_response40011 import InlineResponse40011
from cryptoapis.model.inline_response40016 import InlineResponse40016
from cryptoapis.model.inline_response40019 import InlineResponse40019
from cryptoapis.model.inline_response4002 import InlineResponse4002
from cryptoapis.model.inline_response40024 import InlineResponse40024
from cryptoapis.model.inline_response40028 import InlineResponse40028
from cryptoapis.model.inline_response40032 import InlineResponse40032
from cryptoapis.model.inline_response40042 import InlineResponse40042
from cryptoapis.model.inline_response4006 import InlineResponse4006
from cryptoapis.model.inline_response40111 import InlineResponse40111
from cryptoapis.model.inline_response40116 import InlineResponse40116
from cryptoapis.model.inline_response40119 import InlineResponse40119
from cryptoapis.model.inline_response4012 import InlineResponse4012
from cryptoapis.model.inline_response40124 import InlineResponse40124
from cryptoapis.model.inline_response40128 import InlineResponse40128
from cryptoapis.model.inline_response40132 import InlineResponse40132
from cryptoapis.model.inline_response40142 import InlineResponse40142
from cryptoapis.model.inline_response4016 import InlineResponse4016
from cryptoapis.model.inline_response402 import InlineResponse402
from cryptoapis.model.inline_response40311 import InlineResponse40311
from cryptoapis.model.inline_response40316 import InlineResponse40316
from cryptoapis.model.inline_response40319 import InlineResponse40319
from cryptoapis.model.inline_response4032 import InlineResponse4032
from cryptoapis.model.inline_response40324 import InlineResponse40324
from cryptoapis.model.inline_response40328 import InlineResponse40328
from cryptoapis.model.inline_response40332 import InlineResponse40332
from cryptoapis.model.inline_response40342 import InlineResponse40342
from cryptoapis.model.inline_response4036 import InlineResponse4036
from cryptoapis.model.inline_response4041 import InlineResponse4041
from cryptoapis.model.inline_response409 import InlineResponse409
from cryptoapis.model.inline_response415 import InlineResponse415
from cryptoapis.model.inline_response422 import InlineResponse422
from cryptoapis.model.inline_response429 import InlineResponse429
from cryptoapis.model.inline_response500 import InlineResponse500
from cryptoapis.model.list_xrp_ripple_transactions_by_address_and_time_range_r import ListXRPRippleTransactionsByAddressAndTimeRangeR
from cryptoapis.model.list_xrp_ripple_transactions_by_address_r import ListXRPRippleTransactionsByAddressR
from cryptoapis.model.list_xrp_ripple_transactions_by_block_hash_r import ListXRPRippleTransactionsByBlockHashR
from cryptoapis.model.list_xrp_ripple_transactions_by_block_height_r import ListXRPRippleTransactionsByBlockHeightR


class XRPRippleApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_latest_mined_xrp__ripple_block_endpoint = _Endpoint(
            settings={
                'response_type': (GetLatestMinedXRPRippleBlockR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/xrp-specific/{network}/blocks/last',
                'operation_id': 'get_latest_mined_xrp__ripple_block',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'context',
                ],
                'required': [
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'context': 'context',
                },
                'location_map': {
                    'network': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_xrp__ripple_address_details_endpoint = _Endpoint(
            settings={
                'response_type': (GetXRPRippleAddressDetailsR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/xrp-specific/{network}/addresses/{address}',
                'operation_id': 'get_xrp__ripple_address_details',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'address',
                    'context',
                ],
                'required': [
                    'network',
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'address': 'address',
                    'context': 'context',
                },
                'location_map': {
                    'network': 'path',
                    'address': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_xrp__ripple_block_details_by_block_hash_endpoint = _Endpoint(
            settings={
                'response_type': (GetXRPRippleBlockDetailsByBlockHashR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/xrp-specific/{network}/blocks/hash/{blockHash}',
                'operation_id': 'get_xrp__ripple_block_details_by_block_hash',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'block_hash',
                    'context',
                ],
                'required': [
                    'network',
                    'block_hash',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'block_hash':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'block_hash': 'blockHash',
                    'context': 'context',
                },
                'location_map': {
                    'network': 'path',
                    'block_hash': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_xrp__ripple_block_details_by_block_height_endpoint = _Endpoint(
            settings={
                'response_type': (GetXRPRippleBlockDetailsByBlockHeightR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/xrp-specific/{network}/blocks/height/{blockHeight}',
                'operation_id': 'get_xrp__ripple_block_details_by_block_height',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'block_height',
                    'context',
                ],
                'required': [
                    'network',
                    'block_height',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'block_height':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'block_height': 'blockHeight',
                    'context': 'context',
                },
                'location_map': {
                    'network': 'path',
                    'block_height': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_xrp__ripple_transaction_details_by_transaction_id_endpoint = _Endpoint(
            settings={
                'response_type': (GetXRPRippleTransactionDetailsByTransactionIDR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/xrp-specific/{network}/transactions/{transactionHash}',
                'operation_id': 'get_xrp__ripple_transaction_details_by_transaction_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'transaction_hash',
                    'context',
                ],
                'required': [
                    'network',
                    'transaction_hash',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'transaction_hash':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'transaction_hash': 'transactionHash',
                    'context': 'context',
                },
                'location_map': {
                    'network': 'path',
                    'transaction_hash': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_xrp__ripple_transactions_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (ListXRPRippleTransactionsByAddressR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/xrp-specific/{network}/addresses/{address}/transactions',
                'operation_id': 'list_xrp__ripple_transactions_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'address',
                    'context',
                    'limit',
                    'offset',
                    'transaction_type',
                ],
                'required': [
                    'network',
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                    'transaction_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                    ('transaction_type',): {

                        "ACCOUNT-SET": "account-set",
                        "ACCOUNT-DELETE": "account-delete",
                        "CHECK-CANCEL": "check-cancel",
                        "CHECK-CASH": "check-cash",
                        "CHECK-CREATE": "check-create",
                        "DEPOSIT-PREAUTH": "deposit-preauth",
                        "ESCROW-CANCEL": "escrow-cancel",
                        "ESCROW-CREATE": "escrow-create",
                        "ESCROW-FINISH": "escrow-finish",
                        "OFFER-CANCEL": "offer-cancel",
                        "OFFER-CREATE": "offer-create",
                        "PAYMENT": "payment",
                        "PAYMENT-CHANNEL-CLAIM": "payment-channel-claim",
                        "PAYMENT-CHANNEL-CREATE": "payment-channel-create",
                        "PAYMENT-CHANNEL-FUND": "payment-channel-fund",
                        "SET-REGULAR-KEY": "set-regular-key",
                        "SIGNER-LIST-SET": "signer-list-set",
                        "TICKET-CREATE": "ticket-create",
                        "TRUST-SET": "trust-set"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                    'transaction_type':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'address': 'address',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                    'transaction_type': 'transactionType',
                },
                'location_map': {
                    'network': 'path',
                    'address': 'path',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                    'transaction_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_xrp__ripple_transactions_by_address_and_time_range_endpoint = _Endpoint(
            settings={
                'response_type': (ListXRPRippleTransactionsByAddressAndTimeRangeR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/xrp-specific/{network}/addresses/{address}/transactions-by-time-range',
                'operation_id': 'list_xrp__ripple_transactions_by_address_and_time_range',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'address',
                    'from_timestamp',
                    'to_timestamp',
                    'context',
                    'limit',
                    'offset',
                    'transaction_type',
                ],
                'required': [
                    'network',
                    'address',
                    'from_timestamp',
                    'to_timestamp',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                    'transaction_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                    ('transaction_type',): {

                        "ACCOUNT-SET": "account-set",
                        "ACCOUNT-DELETE": "account-delete",
                        "CHECK-CANCEL": "check-cancel",
                        "CHECK-CASH": "check-cash",
                        "CHECK-CREATE": "check-create",
                        "DEPOSIT-PREAUTH": "deposit-preauth",
                        "ESCROW-CANCEL": "escrow-cancel",
                        "ESCROW-CREATE": "escrow-create",
                        "ESCROW-FINISH": "escrow-finish",
                        "OFFER-CANCEL": "offer-cancel",
                        "OFFER-CREATE": "offer-create",
                        "PAYMENT": "payment",
                        "PAYMENT-CHANNEL-CLAIM": "payment-channel-claim",
                        "PAYMENT-CHANNEL-CREATE": "payment-channel-create",
                        "PAYMENT-CHANNEL-FUND": "payment-channel-fund",
                        "SET-REGULAR-KEY": "set-regular-key",
                        "SIGNER-LIST-SET": "signer-list-set",
                        "TICKET-CREATE": "ticket-create",
                        "TRUST-SET": "trust-set"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'from_timestamp':
                        (int,),
                    'to_timestamp':
                        (int,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                    'transaction_type':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'address': 'address',
                    'from_timestamp': 'fromTimestamp',
                    'to_timestamp': 'toTimestamp',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                    'transaction_type': 'transactionType',
                },
                'location_map': {
                    'network': 'path',
                    'address': 'path',
                    'from_timestamp': 'query',
                    'to_timestamp': 'query',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                    'transaction_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_xrp__ripple_transactions_by_block_hash_endpoint = _Endpoint(
            settings={
                'response_type': (ListXRPRippleTransactionsByBlockHashR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/xrp-specific/{network}/blocks/hash/{blockHash}/transactions',
                'operation_id': 'list_xrp__ripple_transactions_by_block_hash',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'block_hash',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'network',
                    'block_hash',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'block_hash':
                        (str,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'network': 'network',
                    'block_hash': 'blockHash',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'network': 'path',
                    'block_hash': 'path',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_xrp__ripple_transactions_by_block_height_endpoint = _Endpoint(
            settings={
                'response_type': (ListXRPRippleTransactionsByBlockHeightR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/xrp-specific/{network}/blocks/height/{blockHeight}/transactions',
                'operation_id': 'list_xrp__ripple_transactions_by_block_height',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'block_height',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'network',
                    'block_height',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'block_height':
                        (int,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'network': 'network',
                    'block_height': 'blockHeight',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'network': 'path',
                    'block_height': 'path',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_latest_mined_xrp__ripple_block(
        self,
        network,
        **kwargs
    ):
        """Get Latest Mined XRP (Ripple) Block  # noqa: E501

        Through this endpoint customers can fetch the last mined XRP block in the blockchain, along with its details. These could include the hash of the specific, the previous and the next block, its transactions count, its height, etc.     Since XRP is a different blockchain than Bitcoin and Ethereum, it isn't unified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_latest_mined_xrp__ripple_block(network, async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetLatestMinedXRPRippleBlockR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        return self.get_latest_mined_xrp__ripple_block_endpoint.call_with_http_info(**kwargs)

    def get_xrp__ripple_address_details(
        self,
        network,
        address,
        **kwargs
    ):
        """Get XRP (Ripple) Address Details  # noqa: E501

        Through this endpoint the customer can receive basic information about a given XRP address based on confirmed/synced blocks only. In the case where there are any incoming or outgoing **unconfirmed** transactions for the specific address, they **will not** be counted or calculated here.    Since XRP is a different blockchain than Bitcoin and Ethereum, it isn't unified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_xrp__ripple_address_details(network, address, async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\",  are test networks.
            address (str): Represents the public address, which is a compressed and shortened form of a public key.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetXRPRippleAddressDetailsR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        return self.get_xrp__ripple_address_details_endpoint.call_with_http_info(**kwargs)

    def get_xrp__ripple_block_details_by_block_hash(
        self,
        network,
        block_hash,
        **kwargs
    ):
        """Get XRP (Ripple) Block Details By Block Hash  # noqa: E501

        Through this endpoint customers can obtain basic information about a given XRP block (a block on the XRP blockchain), specifically by using the `hash` parameter. These block details could include the hash of the specific, the previous and the next block, the number of included transactions, etc.     Since XRP is a different blockchain than Bitcoin and Ethereum, it isn't unified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_xrp__ripple_block_details_by_block_hash(network, block_hash, async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            block_hash (str): Represents the hash of the block, which is its unique identifier. It represents a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetXRPRippleBlockDetailsByBlockHashR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['block_hash'] = \
            block_hash
        return self.get_xrp__ripple_block_details_by_block_hash_endpoint.call_with_http_info(**kwargs)

    def get_xrp__ripple_block_details_by_block_height(
        self,
        network,
        block_height,
        **kwargs
    ):
        """Get XRP (Ripple) Block Details By Block Height  # noqa: E501

        Through this endpoint customers can obtain basic information about a given XRP block (a block on the XRP blockchain), specifically by using the `height` parameter. These block details could include the hash of the specific, the previous and the next block, its transactions count, etc.    Since XRP is a different blockchain than Bitcoin and Ethereum, it isn't unified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_xrp__ripple_block_details_by_block_height(network, block_height, async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\",  are test networks.
            block_height (str): Represents the number of blocks in the blockchain preceding this specific block. Block numbers have no gaps. A blockchain usually starts with block 0 called the \"Genesis block\".

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetXRPRippleBlockDetailsByBlockHeightR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['block_height'] = \
            block_height
        return self.get_xrp__ripple_block_details_by_block_height_endpoint.call_with_http_info(**kwargs)

    def get_xrp__ripple_transaction_details_by_transaction_id(
        self,
        network,
        transaction_hash,
        **kwargs
    ):
        """Get XRP (Ripple) Transaction Details By Transaction ID  # noqa: E501

        Through this endpoint customers can obtain details about a XRP transaction by the transaction's unique identifier.     Since XRP is a different blockchain than Bitcoin and Ethereum, it isn't unified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_xrp__ripple_transaction_details_by_transaction_id(network, transaction_hash, async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            transaction_hash (str): Represents the same as `transactionId` for account-based protocols like Ethereum, while it could be different in UTXO-based protocols like Bitcoin. E.g., in UTXO-based protocols `hash` is different from `transactionId` for SegWit transactions.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetXRPRippleTransactionDetailsByTransactionIDR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['transaction_hash'] = \
            transaction_hash
        return self.get_xrp__ripple_transaction_details_by_transaction_id_endpoint.call_with_http_info(**kwargs)

    def list_xrp__ripple_transactions_by_address(
        self,
        network,
        address,
        **kwargs
    ):
        """List XRP (Ripple) Transactions by Address  # noqa: E501

        This endpoint will list XRP transactions by a attribute `address`. The transactions listed will detail additional information such as hash, height, time of creation in Unix timestamp, etc.    Since XRP is a different blockchain than Bitcoin and Ethereum, it isn't unified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_xrp__ripple_transactions_by_address(network, address, async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            address (str): Represents the public address, which is a compressed and shortened form of a public key.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            transaction_type (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListXRPRippleTransactionsByAddressR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        return self.list_xrp__ripple_transactions_by_address_endpoint.call_with_http_info(**kwargs)

    def list_xrp__ripple_transactions_by_address_and_time_range(
        self,
        network,
        address,
        from_timestamp,
        to_timestamp,
        **kwargs
    ):
        """List XRP (Ripple) Transactions By Address And Time Range  # noqa: E501

        Тhis endpoint lists XRP transactions by the attribute `address` and the query parameters `fromTimestamp` and `toTimestamp`  which gives customers the opportunity to filter the results by a specified time period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_xrp__ripple_transactions_by_address_and_time_range(network, address, from_timestamp, to_timestamp, async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            address (str): Represents the public address, which is a compressed and shortened form of a public key.
            from_timestamp (int): Defines the specific time/date from which the results will start being listed.
            to_timestamp (int): Defines the specific time/date to which the results will be listed.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            transaction_type (str): Defines the transaction type.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListXRPRippleTransactionsByAddressAndTimeRangeR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        kwargs['from_timestamp'] = \
            from_timestamp
        kwargs['to_timestamp'] = \
            to_timestamp
        return self.list_xrp__ripple_transactions_by_address_and_time_range_endpoint.call_with_http_info(**kwargs)

    def list_xrp__ripple_transactions_by_block_hash(
        self,
        network,
        block_hash,
        **kwargs
    ):
        """List XRP (Ripple) Transactions By Block Hash  # noqa: E501

        This endpoint will list transactions by an attribute `blockHash`. The transactions listed will detail additional information such as hash, addresses, time of creation in Unix timestamp, etc.    Since XRP is a different blockchain than Bitcoin and Ethereum, it isn't unified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_xrp__ripple_transactions_by_block_hash(network, block_hash, async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            block_hash (str): Represents the hash of the block, which is its unique identifier. It represents a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListXRPRippleTransactionsByBlockHashR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['block_hash'] = \
            block_hash
        return self.list_xrp__ripple_transactions_by_block_hash_endpoint.call_with_http_info(**kwargs)

    def list_xrp__ripple_transactions_by_block_height(
        self,
        network,
        block_height,
        **kwargs
    ):
        """List XRP (Ripple) Transactions By Block Height  # noqa: E501

        This endpoint will list transactions by an attribute `blockHeight`. The transactions listed will detail additional information such as hash, addresses, time of creation in Unix timestamp, etc.    Since XRP is a different blockchain than Bitcoin and Ethereum, it isn't unified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_xrp__ripple_transactions_by_block_height(network, block_height, async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            block_height (int):

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListXRPRippleTransactionsByBlockHeightR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['block_height'] = \
            block_height
        return self.list_xrp__ripple_transactions_by_block_height_endpoint.call_with_http_info(**kwargs)

