"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, 'test-apigateway-kinesis-overwrite');
stack.templateOptions.description = 'Integration Test for aws-apigateway-kinesis';
// Definitions
const props = {
    apiGatewayProps: {
        restApiName: 'my-api',
        deployOptions: {
            methodOptions: {
                '/*/*': {
                    throttlingRateLimit: 100,
                    throttlingBurstLimit: 25
                }
            }
        }
    },
    kinesisStreamProps: {
        shardCount: 1,
        retentionPeriod: core_1.Duration.days(4)
    },
    putRecordRequestTemplate: `{ "StreamName": "\${StreamName}", "Data": "$util.base64Encode($input.json('$.foo'))", "PartitionKey": "$input.path('$.bar')" }`,
    putRecordRequestModel: { schema: {} },
    putRecordsRequestTemplate: `{ "StreamName": "\${StreamName}", "Records": [ #foreach($elem in $input.path('$.records')) { "Data": "$util.base64Encode($elem.foo)", "PartitionKey": "$elem.bar"}#if($foreach.hasNext),#end #end ] }`,
    putRecordsRequestModel: { schema: {} }
};
new lib_1.ApiGatewayToKinesisStreams(stack, 'test-apigateway-kinesis-overwrite', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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