/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  var define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"ed583be1cf": function _(e,s,o){Object.defineProperty(o,"__esModule",{value:!0});const t=e("tslib").__importStar(e("318e14e5ba"));o.AwesomePanelExtensions=t,e("@bokehjs/base").register_models(t)},
"318e14e5ba": function _(e,o,r){Object.defineProperty(r,"__esModule",{value:!0});var a=e("5c604c9068");r.WebComponent=a.WebComponent;var t=e("e2e34597ee");r.TabulatorModel=t.TabulatorModel;var n=e("59f7dfa54f");r.PerspectiveViewer=n.PerspectiveViewer},
"5c604c9068": function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e("tslib"),s=e("@bokehjs/core/dom"),i=o.__importStar(e("@bokehjs/core/properties")),r=e("@bokehjs/models/layouts/html_box"),a=e("@bokehjs/styles/widgets/inputs");function l(e){return(new DOMParser).parseFromString(e,"text/html").documentElement.textContent}class h extends r.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>this.handleNameChange()),this.connect(this.model.properties.innerHTML.change,()=>this.render()),this.connect(this.model.properties.attributesLastChange.change,()=>this.handleAttributesLastChangeChange()),this.connect(this.model.properties.propertiesLastChange.change,()=>this.handlePropertiesLastChangeChange()),this.connect(this.model.properties.columnDataSource.change,()=>this.handleColumnDataSourceChange())}handleNameChange(){this.label_el&&(this.label_el.textContent=this.model.name)}render(){super.render(),this.el.innerHTML!==this.model.innerHTML&&this.createOrUpdateWebComponentElement()}after_layout(){"after_layout"in this.webComponentElement&&this.webComponentElement.after_layout()}createOrUpdateWebComponentElement(){this.webComponentElement&&(this.webComponentElement.onchange=null);const e=this.model.name;"inputgroup"===this.model.componentType&&e?(this.group_el=s.div({class:a.bk_input_group},this.label_el),this.group_el.innerHTML=l(this.model.innerHTML),this.webComponentElement=this.group_el.firstElementChild,this.label_el=s.label({style:{display:0==e.length?"none":""}},e),this.group_el.insertBefore(this.label_el,this.webComponentElement),this.el.appendChild(this.group_el)):(this.el.innerHTML=l(this.model.innerHTML),this.webComponentElement=this.el.firstElementChild),this.activate_scripts(this.webComponentElement.parentNode),this.initPropertyValues(),this.handlePropertiesLastChangeChange(),this.handleColumnDataSourceChange(),this.webComponentElement.onchange=e=>this.handlePropertiesChange(e),this.addEventListeners(),this.addAttributesMutationObserver()}addAttributesMutationObserver(){if(!this.model.attributesToWatch)return;let e={childList:!1,attributes:!0,characterData:!1,subtree:!1,attributeFilter:Object.keys(this.model.attributesToWatch),attributeOldValue:!1,characterDataOldValue:!1};new MutationObserver(e=>{let t=new Object;for(let e in this.model.attributesToWatch){const n=this.webComponentElement.getAttribute(e);t[e]=n}this.model.attributesLastChange!==t&&(this.model.attributesLastChange=t)}).observe(this.webComponentElement,e)}addEventListeners(){this.eventsCount={};for(let e in this.model.eventsToWatch)this.eventsCount[e]=0,this.webComponentElement.addEventListener(e,e=>this.eventHandler(e),!1)}transform_cds_to_records(e){const t=[],n=e.columns(),o=e.get_length();if(0===n.length||null===o)return[];for(let s=0;s<o;s++){const o={};for(const t of n){let n=e.get_array(t);const i=null==n[0].shape?null:n[0].shape;null!=i&&i.length>1&&"number"==typeof i[0]?o[t]=n.slice(s*i[1],s*i[1]+i[1]):o[t]=n[s]}t.push(o)}return t}isFunction(e){if(e){const t={}.toString.call(e);return"[object Function]"===t||"[object AsyncFunction]"===t}return!1}handleColumnDataSourceChange(){if(this.model.columnDataSource){let e;e="records"===this.model.columnDataSourceOrient?this.transform_cds_to_records(this.model.columnDataSource):this.model.columnDataSource.data;const t=this.model.columnDataSourceLoadFunction.toString(),n=this.webComponentElement[t];this.isFunction(n)?this.webComponentElement[t](e):this.webComponentElement[t]=e}}activate_scripts(e){Array.from(e.querySelectorAll("script")).forEach(e=>{const t=document.createElement("script");Array.from(e.attributes).forEach(e=>t.setAttribute(e.name,e.value)),t.appendChild(document.createTextNode(e.innerHTML)),e.parentNode&&e.parentNode.replaceChild(t,e)})}get_nested_property(e,t){let n=(t=(t=t.replace(/\[(\w+)\]/g,".$1")).replace(/^\./,"")).split(".");for(let t=0,o=n.length;t<o;++t){let o=n[t];if(!(o in e))return"";e=e[o]}return e}set_nested_property(e,t,n){const o=t.split(".");if(1===o.length)e[t]=n;else{const t=o.length;for(let n=0;n<t-1;n++){const t=o[n];e[t]||(e[t]={}),e=e[t]}e[o[t-1]]=n}}eventHandler(e){let t=e.type;this.eventsCount[t]+=1;let n={};n[t]=this.eventsCount[t],this.model.eventsCountLastChange=n,this.checkIfPropertiesChanged()}checkIfPropertiesChanged(){const e={};for(const t in this.model.propertiesToWatch){const n=this.propertyValues[t],o=this.get_nested_property(this.webComponentElement,t);n!=o&&(e[t]=o,this.propertyValues[t]=o)}Object.keys(e).length&&(this.model.propertiesLastChange=e)}handlePropertiesChange(e){const t=new Object;for(const n in this.model.propertiesToWatch)e.detail&&n in e.detail?(t[n]=e.detail[n],this.propertyValues[n]=e.detail[n]):e.target&&n in e.target&&(t[n]=e.target[n],this.propertyValues[n]=e.target[n]);Object.keys(t).length&&(this.model.propertiesLastChange=t)}initPropertyValues(){if(this.propertyValues=new Object,this.webComponentElement)for(let e in this.model.propertiesToWatch){let t=this.propertyValues[e],n=this.get_nested_property(this.webComponentElement,e);n!==t&&(this.propertyValues[e]=n)}}handleAttributesLastChangeChange(){if(!this.webComponentElement)return;let e=this.model.attributesLastChange;for(let t in this.model.attributesLastChange)if(t in this.model.attributesToWatch){let n=this.webComponentElement.getAttribute(t),o=e[t];n!==o&&(null===o?this.webComponentElement.removeAttribute(t):this.webComponentElement.setAttribute(t,o))}}handlePropertiesLastChangeChange(){if(!this.webComponentElement)return;let e=this.model.propertiesLastChange;for(let t in this.model.propertiesLastChange)if(t in this.model.propertiesToWatch){let n=e[t];this.set_nested_property(this.webComponentElement,t,n)}}}n.WebComponentView=h,h.__name__="WebComponentView";class p extends r.HTMLBox{constructor(e){super(e)}static init_WebComponent(){this.prototype.default_view=h,this.define({componentType:[i.String,"htmlbox"],innerHTML:[i.String,""],attributesToWatch:[i.Any],attributesLastChange:[i.Any],propertiesToWatch:[i.Any],propertiesLastChange:[i.Any],eventsToWatch:[i.Any],eventsCountLastChange:[i.Any],columnDataSource:[i.Any],columnDataSourceOrient:[i.Any],columnDataSourceLoadFunction:[i.Any]})}}n.WebComponent=p,p.__name__="WebComponent",p.__module__="awesome_panel_extensions.bokeh_extensions.web_component",p.init_WebComponent()},
"e2e34597ee": function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const l=e("tslib"),a=e("@bokehjs/models/layouts/html_box"),s=e("@bokehjs/core/dom"),i=l.__importStar(e("@bokehjs/core/properties"));function n(e,t){let o=null!=t.width?"fixed":"fit",l=null!=t.height?"fixed":"fit";const{sizing_mode:a}=t;if(null!=a)if("fixed"==a)o=l="fixed";else if("stretch_both"==a)o=l="max";else if("stretch_width"==a)o="max";else if("stretch_height"==a)l="max";else switch(a){case"scale_width":o="max",l="min";break;case"scale_height":o="min",l="max";break;case"scale_both":o="max",l="max";break;default:throw new Error("unreachable")}"fixed"==o&&t.width?e.style.width=t.width+"px":"max"==o&&(e.style.width="100%"),"fixed"==l&&t.height?e.style.height=t.height+"px":"max"==l&&(e.style.height="100%")}function c(e){const t=[],o=e.columns(),l=e.get_length();if(0===o.length||null===l)return[];for(let a=0;a<l;a++){const l={};for(const t of o){let o=e.get_array(t);const s=null==o[0].shape?null:o[0].shape;null!=s&&s.length>1&&"number"==typeof s[0]?l[t]=o.slice(a*s[1],a*s[1]+s[1]):l[t]=o[a]}t.push(l)}return t}o.set_size=n;class r extends a.HTMLBoxView{constructor(){super(...arguments),this._tabulator_cell_updating=!1}connect_signals(){super.connect_signals(),this.connect(this.model.properties.configuration.change,()=>{this.render()}),this.connect(this.model.source.properties.data.change,()=>{this.setData()}),this.connect(this.model.source.streaming,()=>this.addData()),this.connect(this.model.source.patching,()=>this.updateOrAddData()),this.connect(this.model.source.selected.properties.indices.change,()=>this.updateSelection())}render(){super.render(),console.log("render");const e=s.div({class:"pnx-tabulator"});n(e,this.model);let t=this.getConfiguration();"undefined"==typeof Tabulator&&console.log("Tabulator not loaded. See https://github.com/holoviz/panel/issues/15299"),console.log(Tabulator),this.tabulator=new Tabulator(e,t),this.el.appendChild(e)}getConfiguration(){let e=this;let t={rowSelectionChanged:function(t,o){console.log("rowSelectionChanged");let l=t.map(e=>e.index);e.model.source.selected.indices=l},cellEdited:function(t){console.log("cellEdited");const o=t._cell.column.field,l=t._cell.row.data.index,a=t._cell.value;e._tabulator_cell_updating=!0,e.model.source.patch({[o]:[[l,a]]}),e.model._cell_change={c:o,i:l,v:a},e._tabulator_cell_updating=!1},index:"index"},o=Object.assign(Object.assign({},this.model.configuration),t),l=this.model.source;return null===l||0===Object.keys(l.data).length?o:(console.log("adding data to configuration"),l=c(l),Object.assign(Object.assign({},o),{data:l}))}after_layout(){console.log("after_layout"),super.after_layout(),this.tabulator.redraw(!0)}setData(){console.log("setData");let e=c(this.model.source);this.tabulator.setData(e)}addData(){console.log("addData");let e=c(this.model.source);this.tabulator.setData(e)}updateOrAddData(){if(!0===this._tabulator_cell_updating)return;console.log("updateData");let e=c(this.model.source);this.tabulator.setData(e)}updateSelection(){if(console.log("updateSelection"),null==this.tabulator)return;let e=this.model.source.selected.indices,t=this.tabulator.getSelectedRows();for(let o of t)e.includes(o.getData().index)||o.toggleSelect();for(let t of e)this.tabulator.selectRow(t)}}o.TabulatorModelView=r,r.__name__="TabulatorModelView";class d extends a.HTMLBox{constructor(e){super(e)}static init_TabulatorModel(){this.prototype.default_view=r,this.define({configuration:[i.Any],source:[i.Any],_cell_change:[i.Any]})}}o.TabulatorModel=d,d.__name__="TabulatorModel",d.__module__="awesome_panel_extensions.bokeh_extensions.tabulator_model",d.init_TabulatorModel()},
"59f7dfa54f": function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e("tslib"),o=e("@bokehjs/models/layouts/html_box"),r=e("@bokehjs/core/dom"),p=i.__importStar(e("@bokehjs/core/properties")),u=e("88538263fa"),n=["perspective-viewer-material","perspective-viewer-material-dark","perspective-viewer-material-dense","perspective-viewer-material-dense-dark","perspective-viewer-vaporwave"];function a(e){return!n.includes(e)}function l(e){return"perspective-viewer-"+e}class c extends o.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.source.properties.data.change,this.setData),this.connect(this.model.source_stream.properties.data.change,this.addData),this.connect(this.model.source_patch.properties.data.change,this.updateOrAddData),this.connect(this.model.properties.columns.change,this.updateColumns),this.connect(this.model.properties.parsed_computed_columns.change,this.updateParsedComputedColumns),this.connect(this.model.properties.computed_columns.change,this.updateComputedColumns),this.connect(this.model.properties.column_pivots.change,this.updateColumnPivots),this.connect(this.model.properties.row_pivots.change,this.updateRowPivots),this.connect(this.model.properties.aggregates.change,this.updateAggregates),this.connect(this.model.properties.filters.change,this.updateFilters),this.connect(this.model.properties.plugin.change,this.updatePlugin),this.connect(this.model.properties.theme.change,this.updateTheme)}render(){super.render();const e=r.div({class:"pnx-perspective-viewer"});e.innerHTML=this.getInnerHTML(),this.perspective_element=e.children[0],u.set_size(e,this.model),this.el.appendChild(e),this.setData();let t=this;this.perspective_element.addEventListener("perspective-config-update",(function(){t.model.columns=this.columns,t.model.column_pivots=JSON.parse(this.getAttribute("column-pivots")),t.model.parsed_computed_columns=JSON.parse(this.getAttribute("parsed-computed-columns")),t.model.computed_columns=JSON.parse(this.getAttribute("computed-columns")),t.model.row_pivots=JSON.parse(this.getAttribute("row-pivots")),t.model.aggregates=JSON.parse(this.getAttribute("aggregates")),t.model.sort=JSON.parse(this.getAttribute("sort")),t.model.filters=JSON.parse(this.getAttribute("filters")),"debug"!==this.getAttribute("plugin")&&(t.model.plugin=this.getAttribute("plugin"))}))}getInnerHTML(){let e="<perspective-viewer style='height:100%;width:100%;'";return e+=u.toAttribute("class",l(this.model.theme)),e+=u.toAttribute("columns",this.model.columns),e+=u.toAttribute("column-pivots",this.model.column_pivots),e+=u.toAttribute("computed-columns",this.model.computed_columns),e+=u.toAttribute("row-pivots",this.model.row_pivots),e+=u.toAttribute("aggregates",this.model.aggregates),e+=u.toAttribute("sort",this.model.sort),e+=u.toAttribute("filters",this.model.filters),e+=u.toAttribute("plugin",this.model.plugin),e+="></perspective-viewer>",e}setData(){console.log("setData"),console.log(this.model.source.data);let e=u.transform_cds_to_records(this.model.source);this.perspective_element.load(e)}addData(){console.log("addData"),this.setData()}updateOrAddData(){console.log("updateOrAddData"),this.setData()}updateAttribute(e,t,s){if(null==t||t===[])return;const i=this.perspective_element.getAttribute(e);s&&(t=JSON.stringify(t)),i!==t&&this.perspective_element.setAttribute(e,t)}updateColumns(){this.updateAttribute("columns",this.model.columns,!0)}updateParsedComputedColumns(){this.updateAttribute("parsed-computed-columns",this.model.parsed_computed_columns,!0)}updateComputedColumns(){this.updateAttribute("computed-columns",this.model.computed_columns,!0)}updateColumnPivots(){this.updateAttribute("column-pivots",this.model.column_pivots,!0)}updateRowPivots(){this.updateAttribute("row-pivots",this.model.row_pivots,!0)}updateAggregates(){this.updateAttribute("aggregates",this.model.row_pivots,!0)}updateSort(){this.updateAttribute("sort",this.model.sort,!0)}updateFilters(){this.updateAttribute("sort",this.model.filters,!0)}updatePlugin(){this.updateAttribute("plugin",this.model.plugin,!1)}updateTheme(){let e=this.perspective_element.getAttribute("class"),t=this.toNewClassAttribute(e,this.model.theme);this.perspective_element.setAttribute("class",t)}toNewClassAttribute(e,t){let s=[];return null!=e&&(s=e.split(" ").filter(a)),s.push(l(t)),s.join(" ")}}s.PerspectiveViewerView=c,c.__name__="PerspectiveViewerView";class d extends o.HTMLBox{constructor(e){super(e)}static init_PerspectiveViewer(){this.prototype.default_view=c,this.define({source:[p.Any],source_stream:[p.Any],source_patch:[p.Any],columns:[p.Array],parsed_computed_columns:[p.Array,[]],computed_columns:[p.Array],column_pivots:[p.Array],row_pivots:[p.Array],aggregates:[p.Any],sort:[p.Array],filters:[p.Array],plugin:[p.String],theme:[p.String]})}}s.PerspectiveViewer=d,d.__name__="PerspectiveViewer",d.__module__="awesome_panel_extensions.bokeh_extensions.perspective_viewer",d.init_PerspectiveViewer()},
"88538263fa": function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0}),i.set_size=function(e,t){let i=null!=t.width?"fixed":"fit",l=null!=t.height?"fixed":"fit";const{sizing_mode:n}=t;if(null!=n)if("fixed"==n)i=l="fixed";else if("stretch_both"==n)i=l="max";else if("stretch_width"==n)i="max";else if("stretch_height"==n)l="max";else switch(n){case"scale_width":i="max",l="min";break;case"scale_height":i="min",l="max";break;case"scale_both":i="max",l="max";break;default:throw new Error("unreachable")}"fixed"==i&&t.width?e.style.width=t.width+"px":"max"==i&&(e.style.width="100%"),"fixed"==l&&t.height?e.style.height=t.height+"px":"max"==l&&(e.style.height="100%")},i.transform_cds_to_records=function(e){const t=[],i=e.columns(),l=e.get_length();if(0===i.length||null===l)return[];for(let n=0;n<l;n++){const l={};for(const t of i){let i=e.get_array(t);const s=null==i[0].shape?null:i[0].shape;null!=s&&s.length>1&&"number"==typeof s[0]?l[t]=i.slice(n*s[1],n*s[1]+s[1]):l[t]=i[n]}t.push(l)}return t},i.toAttribute=function(e,t){return null===t?"":("string"!=typeof t&&(t=JSON.stringify(t))," "+e+"='"+t+"'")}},
}, "ed583be1cf", {"index":"ed583be1cf","bokeh_extensions/index":"318e14e5ba","bokeh_extensions/web_component":"5c604c9068","bokeh_extensions/tabulator_model":"e2e34597ee","bokeh_extensions/perspective_viewer":"59f7dfa54f","bokeh_extensions/shared":"88538263fa"}, {});
})

