import os
from dataclasses import dataclass, field
from pathlib import Path
from time import gmtime, strftime

import typer

pth: Path = Path(os.getcwd())
app = typer.Typer()
now = strftime(r"%Y-%m-%d", gmtime())
log = pth / "log" / (now + ".log")


@dataclass
class Config:
    """Config"""

    gen_list: list[str] = field(default_factory=list)
    """Generator list"""
    accept_list: list[str] = field(default_factory=list)
    """Accept code list"""
    wrong_list: list[str] = field(default_factory=list)
    """Wrong code list"""
    gen_link_code: dict[str, list[str]] = field(default_factory=dict)
    """{"make":["wa", "ac"]}"""
    gen_data_num: dict[str, int] = field(default_factory=dict)
    """Number of data sets generated by the generator."""
    time_limit: float = 2
    """Time limit for code."""
    max_time_limit: float = 10
    """Time limit for all programs."""
    std: str = "std"
    """Required"""
    checker: str = "checker"
    """Optional. Default strategy is comparing line by line."""
    interactor: str = "interactor"
    validator: str = "validator"
    gcc_version: int = 17


gen_path = pth / "generator"
ac_code_path = pth / "accept"
wa_code_path = pth / "wrong"
exec_path = pth / "exec"
data_auto_in = pth / "data/auto/in"
data_auto_out = pth / "data/auto/out"
data_save_in = pth / "data/save/in"
data_save_out = pth / "data/save/out"
log_path = pth / "log"
temp_path = pth / "temp"
outp_path = pth / "output"

new_dir = [
    gen_path,
    ac_code_path,
    wa_code_path,
    exec_path,
    data_auto_in,
    data_auto_out,
    data_save_in,
    data_save_out,
    log_path,
    temp_path,
    outp_path,
]

file = Path(__file__)
default_path = file.parent / "default"
