"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OraclepaasProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/oraclepaas oraclepaas}
*/
class OraclepaasProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/oraclepaas oraclepaas} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OraclepaasProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'oraclepaas',
            terraformGeneratorMetadata: {
                providerName: 'oraclepaas',
                providerVersion: '1.5.3',
                providerVersionConstraint: '~> 1.5'
            },
            terraformProviderSource: 'oraclepaas'
        });
        this._applicationEndpoint = config.applicationEndpoint;
        this._databaseEndpoint = config.databaseEndpoint;
        this._identityDomain = config.identityDomain;
        this._insecure = config.insecure;
        this._javaEndpoint = config.javaEndpoint;
        this._maxRetries = config.maxRetries;
        this._mysqlEndpoint = config.mysqlEndpoint;
        this._password = config.password;
        this._user = config.user;
        this._alias = config.alias;
    }
    get applicationEndpoint() {
        return this._applicationEndpoint;
    }
    set applicationEndpoint(value) {
        this._applicationEndpoint = value;
    }
    resetApplicationEndpoint() {
        this._applicationEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get applicationEndpointInput() {
        return this._applicationEndpoint;
    }
    get databaseEndpoint() {
        return this._databaseEndpoint;
    }
    set databaseEndpoint(value) {
        this._databaseEndpoint = value;
    }
    resetDatabaseEndpoint() {
        this._databaseEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get databaseEndpointInput() {
        return this._databaseEndpoint;
    }
    get identityDomain() {
        return this._identityDomain;
    }
    set identityDomain(value) {
        this._identityDomain = value;
    }
    // Temporarily expose input value. Use with caution.
    get identityDomainInput() {
        return this._identityDomain;
    }
    get insecure() {
        return this._insecure;
    }
    set insecure(value) {
        this._insecure = value;
    }
    resetInsecure() {
        this._insecure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureInput() {
        return this._insecure;
    }
    get javaEndpoint() {
        return this._javaEndpoint;
    }
    set javaEndpoint(value) {
        this._javaEndpoint = value;
    }
    resetJavaEndpoint() {
        this._javaEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get javaEndpointInput() {
        return this._javaEndpoint;
    }
    get maxRetries() {
        return this._maxRetries;
    }
    set maxRetries(value) {
        this._maxRetries = value;
    }
    resetMaxRetries() {
        this._maxRetries = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxRetriesInput() {
        return this._maxRetries;
    }
    get mysqlEndpoint() {
        return this._mysqlEndpoint;
    }
    set mysqlEndpoint(value) {
        this._mysqlEndpoint = value;
    }
    resetMysqlEndpoint() {
        this._mysqlEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mysqlEndpointInput() {
        return this._mysqlEndpoint;
    }
    get password() {
        return this._password;
    }
    set password(value) {
        this._password = value;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get user() {
        return this._user;
    }
    set user(value) {
        this._user = value;
    }
    // Temporarily expose input value. Use with caution.
    get userInput() {
        return this._user;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            application_endpoint: cdktf.stringToTerraform(this._applicationEndpoint),
            database_endpoint: cdktf.stringToTerraform(this._databaseEndpoint),
            identity_domain: cdktf.stringToTerraform(this._identityDomain),
            insecure: cdktf.booleanToTerraform(this._insecure),
            java_endpoint: cdktf.stringToTerraform(this._javaEndpoint),
            max_retries: cdktf.numberToTerraform(this._maxRetries),
            mysql_endpoint: cdktf.stringToTerraform(this._mysqlEndpoint),
            password: cdktf.stringToTerraform(this._password),
            user: cdktf.stringToTerraform(this._user),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.OraclepaasProvider = OraclepaasProvider;
_a = JSII_RTTI_SYMBOL_1;
OraclepaasProvider[_a] = { fqn: "@cdktf/provider-oraclepaas.provider.OraclepaasProvider", version: "1.0.1" };
// =================
// STATIC PROPERTIES
// =================
OraclepaasProvider.tfResourceType = "oraclepaas";
//# sourceMappingURL=data:application/json;base64,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