import collections

ORG_MGLAND = "MGLAND"
APP_NAME = "IUTest"

TEST_RESULT_NONE = 0
TEST_RESULT_RUNNING = 1
TEST_RESULT_SKIP = 2
TEST_RESULT_PASS = 3
TEST_RESULT_EXPECTED_FAIL = 4
TEST_RESULT_UNEXPECTED_PASS = 5
TEST_RESULT_FAIL = 6
TEST_RESULT_ERROR = 7

RUN_TEST_SETUP_ONLY = 0
RUN_TEST_NO_TEAR_DOWN = 1
RUN_TEST_FULL = 2

ITEM_CATEGORY_ALL = 0
ITEM_CATEGORY_PACKAGE = 1
ITEM_CATEGORY_MODULE = 2
ITEM_CATEGORY_SUITE = 3
ITEM_CATEGORY_TEST = 4


KEYWORD_TEST_STATE_NONE = ":normal"
KEYWORD_TEST_STATE_RUN = ":ran"
KEYWORD_TEST_STATE_SKIPPED = ":skipped"
KEYWORD_TEST_STATE_SUCCESS = ":success"
KEYWORD_TEST_STATE_EXPECTED_FAIL = ":error"
KEYWORD_TEST_STATE_UNEXPECTED_PASS= ":error"
KEYWORD_TEST_STATE_FAILED = ":failed"
KEYWORD_TEST_STATE_ERROR = ":error"
KEYWORD_TEST_STATES = collections.OrderedDict(
    [
        (KEYWORD_TEST_STATE_NONE, TEST_RESULT_NONE),
        (KEYWORD_TEST_STATE_RUN, -1),
        (KEYWORD_TEST_STATE_SKIPPED, TEST_RESULT_SKIP),
        (KEYWORD_TEST_STATE_SUCCESS, TEST_RESULT_PASS),
        (KEYWORD_TEST_STATE_EXPECTED_FAIL, TEST_RESULT_EXPECTED_FAIL),
        (KEYWORD_TEST_STATE_UNEXPECTED_PASS, TEST_RESULT_UNEXPECTED_PASS),
        (KEYWORD_TEST_STATE_FAILED, TEST_RESULT_EXPECTED_FAIL),
        (KEYWORD_TEST_STATE_ERROR, TEST_RESULT_ERROR),
    ]
)

TEST_ICON_NONE_SUFFIX = ""
TEST_ICON_RUNNING_SUFFIX = "_running"
TEST_ICON_SKIP_SUFFIX = "_skipped"
TEST_ICON_SUCCESS_SUFFIX = "_success"
TEST_ICON_EXPECTED_FAIL_SUFFIX = "_expectedFailure"
TEST_ICON_UNEXPECTED_PASS_SUFFIX = "_unepectedSuccess"
TEST_ICON_FAILED_SUFFIX = "_failed"
TEST_ICON_ERROR_SUFFIX = "_error"
TEST_ICON_SUFFIXES = (
    TEST_ICON_NONE_SUFFIX,
    TEST_ICON_RUNNING_SUFFIX,
    TEST_ICON_SKIP_SUFFIX,
    TEST_ICON_SUCCESS_SUFFIX,
    TEST_ICON_EXPECTED_FAIL_SUFFIX,
    TEST_ICON_UNEXPECTED_PASS_SUFFIX,
    TEST_ICON_FAILED_SUFFIX,
    TEST_ICON_ERROR_SUFFIX,
)


PANEL_VIS_STATE_RIGHT_ON = 0
PANEL_VIS_STATE_LEFT_ON = 1
PANEL_VIS_STATE_BOTH_ON = 2
PANEL_VIS_STATE_ICON_SUFFIXES = ("_right", "_left", "_both")


# Config Keys --------------------------------------------
CONFIG_KEY_SAVED_TEST_DIR = "testDirs"
CONFIG_KEY_TEST_TOP_DER = "topDir"
CONFIG_KEY_TEST_START_DER = "testRootDir"

CONFIG_KEY_LAST_TEST_ROOT_DIR = "lastTestRootDir"
CONFIG_KEY_LAST_TOP_DIR = "lastTopDir"

CONFIG_KEY_PANEL_VIS_STATE = "panelVisState"
CONFIG_KEY_AUTO_FILTERING_STATE = "autoFiltering"
CONFIG_KEY_AUTO_CLEAR_LOG_STATE = "autoClearLog"

CONFIG_KEY_STOP_ON_ERROR = "stopOnError"

CONFIG_KEY_CODE_EDITOR = "codeEditor"
CODE_FILE_VAR = "$file"
CODE_LINE_VAR = "$line"
CONFIG_KEY_CODE_EDITOR_DEFAULT = 'code --goto "{}":{}'.format(
    CODE_FILE_VAR, CODE_LINE_VAR
)

CONFIG_KEY_LAST_RUNNER_MODE = "lastRunnerMode"
