import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type Stackery::Open::Bastion::MODULE.
 *
 * @schema CfnBastionModuleProps
 */
export interface CfnBastionModuleProps {
    /**
     * @schema CfnBastionModuleProps#Parameters
     */
    readonly parameters?: CfnBastionModulePropsParameters;
    /**
     * @schema CfnBastionModuleProps#Resources
     */
    readonly resources?: CfnBastionModulePropsResources;
}
/**
 * Converts an object of type 'CfnBastionModuleProps' to JSON representation.
 */
export declare function toJson_CfnBastionModuleProps(obj: CfnBastionModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBastionModulePropsParameters
 */
export interface CfnBastionModulePropsParameters {
    /**
     * VPC to run bastion server in.
     *
     * @schema CfnBastionModulePropsParameters#VPCId
     */
    readonly vpcId?: CfnBastionModulePropsParametersVpcId;
    /**
     * Subnets to pick from to run a bastion server in.
     *
     * @schema CfnBastionModulePropsParameters#VPCSubnets
     */
    readonly vpcSubnets?: CfnBastionModulePropsParametersVpcSubnets;
    /**
     * EC2 instance class to provision.
     *
     * @schema CfnBastionModulePropsParameters#InstanceClass
     */
    readonly instanceClass?: CfnBastionModulePropsParametersInstanceClass;
}
/**
 * Converts an object of type 'CfnBastionModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsParameters(obj: CfnBastionModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBastionModulePropsResources
 */
export interface CfnBastionModulePropsResources {
    /**
     * @schema CfnBastionModulePropsResources#AutoScalingGroup
     */
    readonly autoScalingGroup?: CfnBastionModulePropsResourcesAutoScalingGroup;
    /**
     * @schema CfnBastionModulePropsResources#IAMRole
     */
    readonly iamRole?: CfnBastionModulePropsResourcesIamRole;
    /**
     * @schema CfnBastionModulePropsResources#IAMInstanceProfile
     */
    readonly iamInstanceProfile?: CfnBastionModulePropsResourcesIamInstanceProfile;
    /**
     * @schema CfnBastionModulePropsResources#InstancesSecurityGroup
     */
    readonly instancesSecurityGroup?: CfnBastionModulePropsResourcesInstancesSecurityGroup;
    /**
     * @schema CfnBastionModulePropsResources#LaunchConfiguration
     */
    readonly launchConfiguration?: CfnBastionModulePropsResourcesLaunchConfiguration;
    /**
     * @schema CfnBastionModulePropsResources#SSMAgentAutoUpdate
     */
    readonly ssmAgentAutoUpdate?: CfnBastionModulePropsResourcesSsmAgentAutoUpdate;
    /**
     * @schema CfnBastionModulePropsResources#CloudWatchAgentUpdateAndStart
     */
    readonly cloudWatchAgentUpdateAndStart?: CfnBastionModulePropsResourcesCloudWatchAgentUpdateAndStart;
    /**
     * @schema CfnBastionModulePropsResources#CloudWatchAgentAutoUpdate
     */
    readonly cloudWatchAgentAutoUpdate?: CfnBastionModulePropsResourcesCloudWatchAgentAutoUpdate;
}
/**
 * Converts an object of type 'CfnBastionModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsResources(obj: CfnBastionModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * VPC to run bastion server in.
 *
 * @schema CfnBastionModulePropsParametersVpcId
 */
export interface CfnBastionModulePropsParametersVpcId {
    /**
     * @schema CfnBastionModulePropsParametersVpcId#Type
     */
    readonly type: string;
    /**
     * @schema CfnBastionModulePropsParametersVpcId#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnBastionModulePropsParametersVpcId' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsParametersVpcId(obj: CfnBastionModulePropsParametersVpcId | undefined): Record<string, any> | undefined;
/**
 * Subnets to pick from to run a bastion server in.
 *
 * @schema CfnBastionModulePropsParametersVpcSubnets
 */
export interface CfnBastionModulePropsParametersVpcSubnets {
    /**
     * @schema CfnBastionModulePropsParametersVpcSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnBastionModulePropsParametersVpcSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnBastionModulePropsParametersVpcSubnets' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsParametersVpcSubnets(obj: CfnBastionModulePropsParametersVpcSubnets | undefined): Record<string, any> | undefined;
/**
 * EC2 instance class to provision.
 *
 * @schema CfnBastionModulePropsParametersInstanceClass
 */
export interface CfnBastionModulePropsParametersInstanceClass {
    /**
     * @schema CfnBastionModulePropsParametersInstanceClass#Type
     */
    readonly type: string;
    /**
     * @schema CfnBastionModulePropsParametersInstanceClass#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnBastionModulePropsParametersInstanceClass' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsParametersInstanceClass(obj: CfnBastionModulePropsParametersInstanceClass | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBastionModulePropsResourcesAutoScalingGroup
 */
export interface CfnBastionModulePropsResourcesAutoScalingGroup {
    /**
     * @schema CfnBastionModulePropsResourcesAutoScalingGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnBastionModulePropsResourcesAutoScalingGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnBastionModulePropsResourcesAutoScalingGroup' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsResourcesAutoScalingGroup(obj: CfnBastionModulePropsResourcesAutoScalingGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBastionModulePropsResourcesIamRole
 */
export interface CfnBastionModulePropsResourcesIamRole {
    /**
     * @schema CfnBastionModulePropsResourcesIamRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnBastionModulePropsResourcesIamRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnBastionModulePropsResourcesIamRole' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsResourcesIamRole(obj: CfnBastionModulePropsResourcesIamRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBastionModulePropsResourcesIamInstanceProfile
 */
export interface CfnBastionModulePropsResourcesIamInstanceProfile {
    /**
     * @schema CfnBastionModulePropsResourcesIamInstanceProfile#Type
     */
    readonly type?: string;
    /**
     * @schema CfnBastionModulePropsResourcesIamInstanceProfile#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnBastionModulePropsResourcesIamInstanceProfile' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsResourcesIamInstanceProfile(obj: CfnBastionModulePropsResourcesIamInstanceProfile | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBastionModulePropsResourcesInstancesSecurityGroup
 */
export interface CfnBastionModulePropsResourcesInstancesSecurityGroup {
    /**
     * @schema CfnBastionModulePropsResourcesInstancesSecurityGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnBastionModulePropsResourcesInstancesSecurityGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnBastionModulePropsResourcesInstancesSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsResourcesInstancesSecurityGroup(obj: CfnBastionModulePropsResourcesInstancesSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBastionModulePropsResourcesLaunchConfiguration
 */
export interface CfnBastionModulePropsResourcesLaunchConfiguration {
    /**
     * @schema CfnBastionModulePropsResourcesLaunchConfiguration#Type
     */
    readonly type?: string;
    /**
     * @schema CfnBastionModulePropsResourcesLaunchConfiguration#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnBastionModulePropsResourcesLaunchConfiguration' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsResourcesLaunchConfiguration(obj: CfnBastionModulePropsResourcesLaunchConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBastionModulePropsResourcesSsmAgentAutoUpdate
 */
export interface CfnBastionModulePropsResourcesSsmAgentAutoUpdate {
    /**
     * @schema CfnBastionModulePropsResourcesSsmAgentAutoUpdate#Type
     */
    readonly type?: string;
    /**
     * @schema CfnBastionModulePropsResourcesSsmAgentAutoUpdate#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnBastionModulePropsResourcesSsmAgentAutoUpdate' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsResourcesSsmAgentAutoUpdate(obj: CfnBastionModulePropsResourcesSsmAgentAutoUpdate | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBastionModulePropsResourcesCloudWatchAgentUpdateAndStart
 */
export interface CfnBastionModulePropsResourcesCloudWatchAgentUpdateAndStart {
    /**
     * @schema CfnBastionModulePropsResourcesCloudWatchAgentUpdateAndStart#Type
     */
    readonly type?: string;
    /**
     * @schema CfnBastionModulePropsResourcesCloudWatchAgentUpdateAndStart#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnBastionModulePropsResourcesCloudWatchAgentUpdateAndStart' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsResourcesCloudWatchAgentUpdateAndStart(obj: CfnBastionModulePropsResourcesCloudWatchAgentUpdateAndStart | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBastionModulePropsResourcesCloudWatchAgentAutoUpdate
 */
export interface CfnBastionModulePropsResourcesCloudWatchAgentAutoUpdate {
    /**
     * @schema CfnBastionModulePropsResourcesCloudWatchAgentAutoUpdate#Type
     */
    readonly type?: string;
    /**
     * @schema CfnBastionModulePropsResourcesCloudWatchAgentAutoUpdate#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnBastionModulePropsResourcesCloudWatchAgentAutoUpdate' to JSON representation.
 */
export declare function toJson_CfnBastionModulePropsResourcesCloudWatchAgentAutoUpdate(obj: CfnBastionModulePropsResourcesCloudWatchAgentAutoUpdate | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Stackery::Open::Bastion::MODULE`.
 *
 * @external
 * @cloudformationResource Stackery::Open::Bastion::MODULE
 * @link http://unknown-url
 */
export declare class CfnBastionModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "Stackery::Open::Bastion::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnBastionModuleProps;
    /**
     * Create a new `Stackery::Open::Bastion::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBastionModuleProps);
}
