# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ilpyt',
 'ilpyt.agents',
 'ilpyt.algos',
 'ilpyt.envs',
 'ilpyt.nets',
 'ilpyt.runners',
 'ilpyt.utils']

package_data = \
{'': ['*']}

install_requires = \
['Box2D==2.3.10',
 'Markdown==3.3.4',
 'Pillow==7.2.0',
 'PyYAML==5.3.1',
 'Werkzeug==1.0.1',
 'absl-py==0.11.0',
 'aiohttp==3.7.4.post0',
 'aiohttp_cors==0.7.0',
 'aioredis==1.3.1',
 'async-timeout==3.0.1',
 'atari-py==0.2.5',
 'attrs==19.3.0',
 'blessings==1.7',
 'blinker==1.4',
 'cachetools==4.2.1',
 'certifi==2019.11.28',
 'chardet==3.0.4',
 'click==7.1.2',
 'cloudpickle==1.6.0',
 'colorama==0.4.4',
 'coloredlogs==15.0',
 'colorful==0.5.4',
 'cryptography==2.8',
 'decorator==4.4.2',
 'entrypoints==0.3',
 'filelock==3.0.12',
 'flake8==3.7.9',
 'future==0.18.2',
 'google-api-core==1.26.1',
 'google-auth-oauthlib==0.4.2',
 'google-auth==1.27.0',
 'googleapis-common-protos==1.53.0',
 'gpustat==0.6.0',
 'grpcio==1.32.0',
 'gym==0.18.0',
 'hiredis==1.1.0',
 'humanfriendly==9.1',
 'idna==2.8',
 'imageio==2.9.0',
 'iniconfig==1.1.1',
 'jsonschema==3.2.0',
 'mccabe==0.6.1',
 'msgpack==1.0.2',
 'multidict==5.1.0',
 'numpy==1.19.5',
 'nvidia-ml-py3==7.352.0',
 'oauthlib==3.1.0',
 'opencensus-context==0.1.2',
 'opencensus==0.7.12',
 'opencv-python==4.5.1.48',
 'packaging==20.9',
 'pandas==1.2.3',
 'pluggy==0.13.1',
 'prometheus-client==0.9.0',
 'protobuf==3.15.4',
 'psutil==5.8.0',
 'py-spy==0.3.5',
 'py==1.10.0',
 'pyasn1-modules==0.2.8',
 'pyasn1==0.4.8',
 'pycodestyle==2.5.0',
 'pyflakes==2.1.1',
 'pyglet==1.5.0',
 'pyparsing==2.4.7',
 'pyrsistent==0.15.5',
 'pytest==6.2.2',
 'python-dateutil==2.8.1',
 'pytz==2021.1',
 'ray==1.2.0',
 'redis==3.5.3',
 'requests-oauthlib==1.3.0',
 'requests==2.22.0',
 'rsa==4.7.2',
 'scipy==1.6.1',
 'six==1.15.0',
 'tabulate==0.8.9',
 'tensorboard-plugin-wit==1.8.0',
 'tensorboard==2.4.1',
 'toml==0.10.2',
 'torch==1.8.1',
 'typing-extensions==3.7.4.3',
 'urllib3==1.25.8',
 'wcwidth==0.1.8',
 'yarl==1.6.3']

setup_kwargs = {
    'name': 'ilpyt',
    'version': '0.1.0',
    'description': 'The imitation learning toolbox (ilpyt) is an open-source Python code library developed at MITRE. The toolbox contains modular, optimized implementations of common deep imitation learning algorithms in PyTorch, with unified infrastructure supporting key imitation learning and reinforcement learning algorithms.',
    'long_description': None,
    'author': 'Amanda Vu',
    'author_email': 'amandavu@mitre.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mitre/ilpyt',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
