from rtctools_heat_network.pycml import Variable

from ._internal import HeatComponent
from .heat_port import HeatPort


class Node(HeatComponent):
    def __init__(self, name, **modifiers):
        super().__init__(name, **modifiers)

        self.component_type = "node"

        self.n = 2
        assert self.n >= 2

        self.add_variable(HeatPort, "HeatConn", self.n)
        self.add_variable(Variable, "H")

        # Because the orientation of the connected pipes are important to
        # setup the heat conservation, these constraints are added in the
        # mixin.

        for i in range(1, self.n + 1):
            self.add_equation(self.HeatConn[i].H - self.H)
            # Q and Heat to be set in the mixin
