# OpenSTARLab Event Modeling package
[![Documentation Status](https://readthedocs.org/projects/openstarlab/badge/?version=latest)](https://openstarlab.readthedocs.io/en/latest/?badge=latest)
[![dm](https://img.shields.io/pypi/dm/openstarlab-event)](https://pypi.org/project/openstarlab-event/)

## Introduction
The OpenSTARLab Event package is the fundamental package for event modeling. It is designed to provide a simple and efficient way to train, inference, and simulate events. This package supports the data preprocessed by the OpenSTARLab PreProcessing package.

This package is continuously evolving to support future OpenSTARLab projects. If you have any suggestions or encounter any bugs, please feel free to open an issue.

## Installation
- Install [pytorch](https://pytorch.org/get-started/locally/) (recommended version 2.4.0 linux pip python3.8 cuda12.1)
```
pip install torch torchvision torchaudio
```
- To install this package via PyPI
```
pip install openstarlab-event
```
- To install manually
```
git clone git@github.com:open-starlab/Event.git
cd ./Event
pip install -e .
```

## Current Features
### Sports
- [Event Model in Football/Soccer ⚽](https://openstarlab.readthedocs.io/en/latest/Event_Modeling/Sports/Soccer/index.html)

## RoadMap
- [x] Release the package
- [ ] Provide pre-trained models

## Other Information
Development torch version
```
version 2.4.0 linux pip python3.8 cuda12.1 
```

## Developer
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
<!-- [![All Contributors](https://img.shields.io/badge/all_contributors-2-orange.svg?style=flat-square)](#contributors-) -->
<!-- ALL-CONTRIBUTORS-BADGE:END -->

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/calvinyeungck"><img src="https://github.com/calvinyeungck.png" width="100px;" alt="Calvin Yeung"/><br /><sub><b>Calvin Yeung</b></sub></a><br /><a href="#Developer-CalvinYeung" title="Lead Developer">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/keisuke198619"><img src="https://github.com/keisuke198619.png" width="100px;" alt="Keisuke Fujii"/><br /><sub><b>Keisuke Fujii</b></sub></a><br /><a href="#lead-KeisukeFujii" title="Team Leader">🧑‍💻</a></td>
    </tr>
  </tbody>
</table>