# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['CACertificateArgs', 'CACertificate']

@pulumi.input_type
class CACertificateArgs:
    def __init__(__self__, *,
                 c_a_certificate_pem: pulumi.Input[str],
                 status: pulumi.Input['CACertificateStatus'],
                 auto_registration_status: Optional[pulumi.Input['CACertificateAutoRegistrationStatus']] = None,
                 certificate_mode: Optional[pulumi.Input['CACertificateCertificateMode']] = None,
                 registration_config: Optional[pulumi.Input['CACertificateRegistrationConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['CACertificateTagArgs']]]] = None,
                 verification_certificate_pem: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CACertificate resource.
        :param pulumi.Input[Sequence[pulumi.Input['CACertificateTagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[str] verification_certificate_pem: The private key verification certificate.
        """
        pulumi.set(__self__, "c_a_certificate_pem", c_a_certificate_pem)
        pulumi.set(__self__, "status", status)
        if auto_registration_status is not None:
            pulumi.set(__self__, "auto_registration_status", auto_registration_status)
        if certificate_mode is not None:
            pulumi.set(__self__, "certificate_mode", certificate_mode)
        if registration_config is not None:
            pulumi.set(__self__, "registration_config", registration_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if verification_certificate_pem is not None:
            pulumi.set(__self__, "verification_certificate_pem", verification_certificate_pem)

    @property
    @pulumi.getter(name="cACertificatePem")
    def c_a_certificate_pem(self) -> pulumi.Input[str]:
        return pulumi.get(self, "c_a_certificate_pem")

    @c_a_certificate_pem.setter
    def c_a_certificate_pem(self, value: pulumi.Input[str]):
        pulumi.set(self, "c_a_certificate_pem", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input['CACertificateStatus']:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input['CACertificateStatus']):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="autoRegistrationStatus")
    def auto_registration_status(self) -> Optional[pulumi.Input['CACertificateAutoRegistrationStatus']]:
        return pulumi.get(self, "auto_registration_status")

    @auto_registration_status.setter
    def auto_registration_status(self, value: Optional[pulumi.Input['CACertificateAutoRegistrationStatus']]):
        pulumi.set(self, "auto_registration_status", value)

    @property
    @pulumi.getter(name="certificateMode")
    def certificate_mode(self) -> Optional[pulumi.Input['CACertificateCertificateMode']]:
        return pulumi.get(self, "certificate_mode")

    @certificate_mode.setter
    def certificate_mode(self, value: Optional[pulumi.Input['CACertificateCertificateMode']]):
        pulumi.set(self, "certificate_mode", value)

    @property
    @pulumi.getter(name="registrationConfig")
    def registration_config(self) -> Optional[pulumi.Input['CACertificateRegistrationConfigArgs']]:
        return pulumi.get(self, "registration_config")

    @registration_config.setter
    def registration_config(self, value: Optional[pulumi.Input['CACertificateRegistrationConfigArgs']]):
        pulumi.set(self, "registration_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CACertificateTagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CACertificateTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="verificationCertificatePem")
    def verification_certificate_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The private key verification certificate.
        """
        return pulumi.get(self, "verification_certificate_pem")

    @verification_certificate_pem.setter
    def verification_certificate_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verification_certificate_pem", value)


class CACertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_registration_status: Optional[pulumi.Input['CACertificateAutoRegistrationStatus']] = None,
                 c_a_certificate_pem: Optional[pulumi.Input[str]] = None,
                 certificate_mode: Optional[pulumi.Input['CACertificateCertificateMode']] = None,
                 registration_config: Optional[pulumi.Input[pulumi.InputType['CACertificateRegistrationConfigArgs']]] = None,
                 status: Optional[pulumi.Input['CACertificateStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CACertificateTagArgs']]]]] = None,
                 verification_certificate_pem: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Registers a CA Certificate in IoT.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CACertificateTagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[str] verification_certificate_pem: The private key verification certificate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CACertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Registers a CA Certificate in IoT.

        :param str resource_name: The name of the resource.
        :param CACertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CACertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_registration_status: Optional[pulumi.Input['CACertificateAutoRegistrationStatus']] = None,
                 c_a_certificate_pem: Optional[pulumi.Input[str]] = None,
                 certificate_mode: Optional[pulumi.Input['CACertificateCertificateMode']] = None,
                 registration_config: Optional[pulumi.Input[pulumi.InputType['CACertificateRegistrationConfigArgs']]] = None,
                 status: Optional[pulumi.Input['CACertificateStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CACertificateTagArgs']]]]] = None,
                 verification_certificate_pem: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CACertificateArgs.__new__(CACertificateArgs)

            __props__.__dict__["auto_registration_status"] = auto_registration_status
            if c_a_certificate_pem is None and not opts.urn:
                raise TypeError("Missing required property 'c_a_certificate_pem'")
            __props__.__dict__["c_a_certificate_pem"] = c_a_certificate_pem
            __props__.__dict__["certificate_mode"] = certificate_mode
            __props__.__dict__["registration_config"] = registration_config
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["verification_certificate_pem"] = verification_certificate_pem
            __props__.__dict__["arn"] = None
        super(CACertificate, __self__).__init__(
            'aws-native:iot:CACertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CACertificate':
        """
        Get an existing CACertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CACertificateArgs.__new__(CACertificateArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["auto_registration_status"] = None
        __props__.__dict__["c_a_certificate_pem"] = None
        __props__.__dict__["certificate_mode"] = None
        __props__.__dict__["registration_config"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["verification_certificate_pem"] = None
        return CACertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoRegistrationStatus")
    def auto_registration_status(self) -> pulumi.Output[Optional['CACertificateAutoRegistrationStatus']]:
        return pulumi.get(self, "auto_registration_status")

    @property
    @pulumi.getter(name="cACertificatePem")
    def c_a_certificate_pem(self) -> pulumi.Output[str]:
        return pulumi.get(self, "c_a_certificate_pem")

    @property
    @pulumi.getter(name="certificateMode")
    def certificate_mode(self) -> pulumi.Output[Optional['CACertificateCertificateMode']]:
        return pulumi.get(self, "certificate_mode")

    @property
    @pulumi.getter(name="registrationConfig")
    def registration_config(self) -> pulumi.Output[Optional['outputs.CACertificateRegistrationConfig']]:
        return pulumi.get(self, "registration_config")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['CACertificateStatus']:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.CACertificateTag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="verificationCertificatePem")
    def verification_certificate_pem(self) -> pulumi.Output[Optional[str]]:
        """
        The private key verification certificate.
        """
        return pulumi.get(self, "verification_certificate_pem")

