## Local Testing
Run `make html` (`.\make.bat html` on Windows) to generate the HTML pages
The generated webpages can then be viewed using a web browser

## RTD Dependencies

Python packages for local testing are handled by the Pipfile/Pipfile.lock files.

These are used to generate the requirements.txt used by RTD: `pipenv lock --requirements > requirements.txt`

## runway-example.gif

**Changes to the gif should be a rare occurrence. It should only be considered when big UI/UX changes occur.**

This gif is generated by [terminalizer](https://github.com/faressoft/terminalizer).
To record or render a new gif, terminalizer must be installed (globally is fine).

### Recording

It is not recommended to record a new gif as it will require a new runway project to be setup.
If absolutely needed, use as many module types as possible in the new recording.

Create a new, local config using the config from the previous recoding that is included in the current yaml.
This will ensure the same settings used for the old recording are used for the new recording.
The `cwd` value will need to be changed.

AWS credentials should be saved to `~/.aws/credentials` under a `runway-example` profile.
This profile is selected using an environment variable in the recording shell.

To begin recording, run `terminalizer record runway-example --config <copied-config> --skip-sharing`.

After recording has completed, remove any identifying information and excess lines from the beginning and end.
Then, adjust the delays between each item. Delays should be no longer than `300` except for the last item before looping.

### Rendering

To render a new copy of the gif, just run `terminalizer render runway-example.yml --output runway-example.gif`.
This will take some time to complete.
