# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aionotion']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.7.4post0,<4.0.0']

setup_kwargs = {
    'name': 'aionotion',
    'version': '2021.10.0',
    'description': 'A simple Python 3 library for Notion Home Monitoring',
    'long_description': '# 📟 aionotion: a Python3, asyncio-friendly library for Notion® Home Monitoring\n\n[![CI](https://github.com/bachya/aionotion/workflows/CI/badge.svg)](https://github.com/bachya/aionotion/actions)\n[![PyPi](https://img.shields.io/pypi/v/aionotion.svg)](https://pypi.python.org/pypi/aionotion)\n[![Version](https://img.shields.io/pypi/pyversions/aionotion.svg)](https://pypi.python.org/pypi/aionotion)\n[![License](https://img.shields.io/pypi/l/aionotion.svg)](https://github.com/bachya/aionotion/blob/master/LICENSE)\n[![Code Coverage](https://codecov.io/gh/bachya/aionotion/branch/master/graph/badge.svg)](https://codecov.io/gh/bachya/aionotion)\n[![Maintainability](https://api.codeclimate.com/v1/badges/bd79edca07c8e4529cba/maintainability)](https://codeclimate.com/github/bachya/aionotion/maintainability)\n[![Say Thanks](https://img.shields.io/badge/SayThanks-!-1EAEDB.svg)](https://saythanks.io/to/bachya)\n\n`aionotion` is a Python 3, asyncio-friendly library for interacting with\n[Notion](https://getnotion.com) home monitoring sensors.\n\n# Python Versions\n\n`aionotion` is currently supported on:\n\n* Python 3.6\n* Python 3.7\n* Python 3.8\n* Python 3.9\n* Python 3.10\n\n# Installation\n\n```python\npip install aionotion\n```\n\n# Usage\n\n```python\nimport asyncio\n\nfrom aiohttp import ClientSession\n\nfrom aionotion import async_get_client\n\n\nasync def main() -> None:\n    """Create the aiohttp session and run the example."""\n    client = await async_get_client("<EMAIL>", "<PASSWORD>", session=session)\n\n    # Get all "households" associated with the account:\n    systems = await client.system.async_all()\n\n    # Get a system by ID:\n    system = await client.system.async_get(12345)\n\n    # Create a system (with associated parameters):\n    await client.system.async_create({"system_id": 12345, "name": "Test"})\n\n    # Update a system with new parameters:\n    await client.system.async_update(12345, {"name": "Test"})\n\n    # Delete a system by ID:\n    await client.system.async_delete(12345)\n\n    # Get all bridges associated with the account:\n    bridges = await client.bridge.async_all()\n\n    # Get a bridge by ID:\n    bridge = await client.bridge.async_get(12345)\n\n    # Create a bridge (with associated parameters):\n    await client.bridge.async_create({"system_id": 12345, "name": "Test"})\n\n    # Update a bridge with new parameters:\n    await client.bridge.async_update(12345, {"name": "Test"})\n\n    # Reset a bridge (deprovision its WiFi credentials):\n    await client.bridge.async_reset(12345)\n\n    # Delete a bridge by ID:\n    await client.bridge.async_delete(12345)\n\n    # Get all devices associated with the account:\n    devices = await client.device.async_all()\n\n    # Get a device by ID:\n    device = await client.device.async_get(12345)\n\n    # Create a device (with associated parameters):\n    await client.device.async_create({"id": 12345})\n\n    # Delete a device by ID:\n    await client.device.async_delete(12345)\n\n    # Get all sensors:\n    sensors = await client.sensor.async_all()\n\n    # Get a sensor by ID:\n    sensor = await client.sensor.async_get(12345)\n\n    # Create a sensor (with associated parameters):\n    await client.sensor.async_create({"sensor_id": 12345, "name": "Test"})\n\n    # Update a sensor with new parameters:\n    await client.sensor.async_update(12345, {"name": "Test"})\n\n    # Delete a sensor by ID:\n    await client.sensor.async_delete(12345)\n\n    # Get all "tasks" (conditions monitored by sensors) associated with the account:\n    tasks = await client.task.async_all()\n\n    # Get a task by ID:\n    task = await client.task.async_get("xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx")\n\n    # Get a task\'s value history between two datetimes:\n    import datetime\n\n    history = await client.task.async_history(\n        "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",\n        data_before=datetime.datetime.now(),\n        data_after=datetime.datetime.now() - datetime.timedelta(days=3),\n    )\n\n    # Create a list of tasks for a particular sensor (e.g., sensor # 12345):\n    await client.task.async_create(\n        12345, [{"id": "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx", "type": "missing"}]\n    )\n\n    # Delete a task for a particular sensor (e.g., sensor # 12345):\n    await client.task.async_delete(12345, "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx")\n\n\nasyncio.run(main())\n```\n\nBy default, the library creates a new connection to Notion with each coroutine. If you\nare calling a large number of coroutines (or merely want to squeeze out every second of\nruntime savings possible), an\n[`aiohttp`](https://github.com/aio-libs/aiohttp) `ClientSession` can be used for connection\npooling:\n\n```python\nimport asyncio\n\nfrom aiohttp import ClientSession\n\nfrom aionotion import async_get_client\n\n\nasync def main() -> None:\n    """Create the aiohttp session and run the example."""\n    async with ClientSession() as session:\n        # Create a Notion API client:\n        client = await async_get_client("<EMAIL>", "<PASSWORD>", session=session)\n\n        # Get to work...\n\n\nasyncio.run(main())\n```\n\nCheck out the examples, the tests, and the source files themselves for method\nsignatures and more examples.\n\n# Contributing\n\n1. [Check for open features/bugs](https://github.com/bachya/aionotion/issues)\n  or [initiate a discussion on one](https://github.com/bachya/aionotion/issues/new).\n2. [Fork the repository](https://github.com/bachya/aionotion/fork).\n3. (_optional, but highly recommended_) Create a virtual environment: `python3 -m venv .venv`\n4. (_optional, but highly recommended_) Enter the virtual environment: `source ./venv/bin/activate`\n5. Install the dev environment: `script/setup`\n6. Code your new feature or bug fix.\n7. Write tests that cover your new functionality.\n8. Run tests and ensure 100% code coverage: `script/test`\n9. Update `README.md` with any new documentation.\n10. Add yourself to `AUTHORS.md`.\n11. Submit a pull request!\n',
    'author': 'Aaron Bach',
    'author_email': 'bachya1208@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/bachya/aionotion',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.0,<4.0.0',
}


setup(**setup_kwargs)
