//ϵͳ
#ifdef WIN32
//#include "stdafx.h"
#endif

#include "vnemt.h"
#include "pybind11/pybind11.h"
#include "emt/emt_trader_api.h"


using namespace pybind11;
using namespace EMT::API;


///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class TdApi : public TraderSpi
{
private:
	TraderApi* api = NULL;            //API
	bool active = false;       //״̬

public:
	TdApi()
	{
	};

	~TdApi()
	{
		if (this->active)
		{
			this->exit();
		}
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

    ///ӳɹ֪ͨ
            ///@remark ͻ뽻׺̨ɹʱ÷ãOnConnectedӿڽӳɹ֪ͨҪٷأûڴ˺⴦
    virtual void OnConnected();

    ///֪ͨ
    ///@param reason ԭӦ
    ///@remark ͻ뽻׺̨ͨӶϿʱ÷ãapiڲ֧ԶƣOnDisconnectedӿڽ֪ͨҪٷأûڴ˺⴦
    virtual void OnDisconnected(int reason);

    ///Ӧ
    ///@param error_info ӦʱľĴʹϢ,error_infoΪգerror_info.error_idΪ0ʱûд
    ///@remark ˺ֻڷʱŻãһû
    virtual void OnError(EMTRI* error_info);

    ///֪ͨ
    ///@param order_info ӦϢûͨorder_info.order_emt_idͨGetClientIDByEMTID() == client_idԼĶorder_info.qty_leftֶڶΪδɽɡȫɡϵ״̬ʱʾ˶ûгɽڲȫ״̬ʱʾ˶order_info.order_cancel_emt_idΪӦĳIDΪ0ʱʾ˵ɹ
    ///@param error_info ܾ߷ʱʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ÿζ״̬ʱᱻãҪٷأϢʱᴥߣڶδɽȫɽȫֳѾܾЩ״̬ʱӦڲֳɽɶĳɽرȷϡе¼˴ûĿͻ˶յûĶӦ
    virtual void OnOrderEvent(EMTOrderInfo* order_info, EMTRI* error_info, uint64_t session_id);

    ///ɽ֪ͨ
    ///@param trade_info ɽرľϢûͨtrade_info.order_emt_idͨGetClientIDByEMTID() == client_idԼĶϽexec_idΨһʶһʳɽ2ʳɽرӵͬexec_idΪ˱ʽԳɽˡexec_idΨһģʱ޴жϻơreport_index+marketֶοΨһʶʾɽر
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark гɽʱ򣬻ᱻãҪٷأϢʱᴥߡе¼˴ûĿͻ˶յûĳɽرضΪ״̬ҪûͨɽرĳɽȷOnOrderEvent()Ͳ״̬
    virtual void OnTradeEvent(EMTTradeReport* trade_info, uint64_t session_id);

    ///Ӧ
    ///@param cancel_info Ϣorder_cancel_emt_idʹorder_emt_id
    ///@param error_info ܾ߷ʱʹϢҪٷأϢʱᴥߣerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark Ӧֻڳʱص
    virtual void OnCancelOrderError(EMTOrderCancelInfo* cancel_info, EMTRI* error_info, uint64_t session_id);

    ///ѯӦ
    ///@param order_info ѯһ
    ///@param error_info ѯʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥ
    virtual void OnQueryOrder(EMTQueryOrderRsp* order_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ҳѯӦ
    ///@param order_info ѯһ
    ///@param req_count 󵽵
    ///@param order_sequence ҳĵǰر
    ///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark order_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱorder_sequencereq_countôʾбԽһηҳѯȣʾбѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryOrderByPage(EMTQueryOrderRsp* order_info, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

    ///ѯɽӦ
    ///@param trade_info ѯһɽر
    ///@param error_info ѯɽرʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥ
    virtual void OnQueryTrade(EMTQueryTradeRsp* trade_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ҳѯɽӦ
    ///@param trade_info ѯһɽϢ
    ///@param req_count 󵽵
    ///@param trade_sequence ҳĵǰر
    ///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark trade_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱtrade_sequencereq_countôʾлرԽһηҳѯȣʾлرѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryTradeByPage(EMTQueryTradeRsp* trade_info, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

    ///ѯͶֲ߳Ӧ
    ///@param position ѯһֻƱĳֲ
    ///@param error_info ѯ˻ֲַʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ûܳжƱһѯܶӦӦҪٷأϢʱᴥ
    virtual void OnQueryPosition(EMTQueryStkPositionRsp* position, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ҳѯֲӦ
    ///@param trade_info ѯһֲϢ
    ///@param req_count 󵽵
    ///@param trade_sequence ҳĵǰر
    ///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark trade_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱtrade_sequencereq_countôʾлرԽһηҳѯȣʾлرѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryPositionByPage(EMTQueryStkPositionRsp* trade_info, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

    ///ѯʽ˻ӦҪٷأϢʱᴥ
    ///@param asset ѯʽ˻
    ///@param error_info ѯʽ˻ʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryAsset(EMTQueryAssetRsp* asset, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯʽ𻮲ӦҪٷأϢʱᴥ
    ///@param fund_transfer_info ѯʽ˻
    ///@param error_info ѯʽ˻ʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryFundTransfer(EMTFundTransferNotice* fund_transfer_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ʽ𻮲֪ͨ
    ///@param fund_transfer_info ʽ𻮲֪ͨľϢûͨfund_transfer_info.serial_idͨGetClientIDByEMTID() == client_idԼĶ
    ///@param error_info ʽ𻮲ܾ߷ʱʹϢerror_infoΪգerror_info.error_idΪ0ʱûд󡣵ʽ𻮲ΪһĽڵ֮仮error_info.error_id=11000384ʱerror_info.error_msgΪпڻʽΪ׼ûstringToIntתɾݴдʵʽٴη𻮲
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ʽ𻮲״̬仯ʱ򣬻ᱻãҪٷأϢʱᴥߡе¼˴ûĿͻ˶յûʽ𻮲֪ͨ
    virtual void OnFundTransfer(EMTFundTransferNotice* fund_transfer_info, EMTRI* error_info, uint64_t session_id);

    ///ѯڵʽӦҪٷأϢʱᴥ
    ///@param fund_info ѯڵʽ
    ///@param error_info ѯڵʽʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryOtherServerFund(EMTFundQueryRsp* fund_info, EMTRI* error_info, int request_id, uint64_t session_id);

    ///ѯETF嵥ļӦҪٷأϢʱᴥ
    ///@param etf_info ѯETF嵥ļ
    ///@param error_info ѯETF嵥ļʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryETF(EMTQueryETFBaseRsp* etf_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯETFƱӦҪٷأϢʱᴥ
    ///@param etf_component_info ѯETFԼسɷֹϢ
    ///@param error_info ѯETFƱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryETFBasket(EMTQueryETFComponentRsp* etf_component_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯ¹깺ϢбӦҪٷأϢʱᴥ
    ///@param ipo_info ѯĽ¹깺һֻƱϢ
    ///@param error_info ѯ¹깺ϢбʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryIPOInfoList(EMTQueryIPOTickerRsp* ipo_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯû¹깺ϢӦҪٷأϢʱᴥ
    ///@param quota_info ѯûĳгĽ¹깺Ϣ
    ///@param error_info ѯû¹깺ϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryIPOQuotaInfo(EMTQueryIPOQuotaRsp* quota_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯȨԼӦҪٷأϢʱᴥ
    ///@param option_info ѯȨԼ
    ///@param error_info ѯȨԼʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryOptionAuctionInfo(EMTQueryOptionAuctionInfoRsp* option_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ȯҵֱֽӻӦ
    ///@param cash_repay_info ֱֽӻ֪ͨľϢûͨcash_repay_info.emt_idͨGetClientIDByEMTID() == client_idԼĶ
    ///@param error_info ֽ𻹿ʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnCreditCashRepay(EMTCrdCashRepayRsp* cash_repay_info, EMTRI* error_info, uint64_t session_id);

    ///ȯҵֽϢӦ
    ///@param cash_repay_info ֽϢ֪ͨľϢûͨcash_repay_info.emt_idͨGetClientIDByEMTID() == client_idԼĶ
    ///@param error_info ֽϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnCreditCashRepayDebtInterestFee(EMTCrdCashRepayDebtInterestFeeRsp* cash_repay_info, EMTRI* error_info, uint64_t session_id);

    ///ѯȯҵеֱֽӻӦ
    ///@param cash_repay_info ѯĳһֱֽӻ֪ͨľϢ
    ///@param error_info ѯֱֽӱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryCreditCashRepayInfo(EMTCrdCashRepayInfo* cash_repay_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯ˻ϢӦҪٷأϢʱᴥ
    ///@param fund_info ѯ˻Ϣ
    ///@param error_info ѯ˻ϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryCreditFundInfo(EMTCrdFundInfo* fund_info, EMTRI* error_info, int request_id, uint64_t session_id);

    ///ѯ˻ծϢӦҪٷأϢʱᴥ
    ///@param debt_info ѯ˻Լծ
    ///@param error_info ѯ˻ծϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryCreditDebtInfo(EMTCrdDebtInfo* debt_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ҳѯծϢӦ
    ///@param debt_info ѯһծϢ
    ///@param req_count 󵽵
    ///@param order_sequence ҳĵǰر
    ///@param query_reference ǰծϢϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark order_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱorder_sequencereq_countôʾиծϢԽһηҳѯȣʾиծϢѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryCreditDebtInfoByPage(EMTCrdDebtInfo* debt_info, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

    ///ѯ˻ָ֤ȯծδϢӦҪٷأϢʱᴥ
    ///@param debt_info ѯ˻ָ֤ȯծδϢ
    ///@param error_info ѯ˻ָ֤ȯծδϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryCreditTickerDebtInfo(EMTCrdDebtStockInfo* debt_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯ˻ʽӦҪٷأϢʱᴥ
    ///@param remain_amount ѯ˻ʽ
    ///@param error_info ѯ˻ʽʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryCreditAssetDebtInfo(double remain_amount, EMTRI* error_info, int request_id, uint64_t session_id);

    ///ѯ˻ȯͷϢӦҪٷأϢʱᴥ
    ///@param assign_info ѯ˻ȯͷϢ
    ///@param error_info ѯ˻ȯͷϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryCreditTickerAssignInfo(EMTClientQueryCrdPositionStkInfo* assign_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ҳѯ֤ȯͷϢӦ
    ///@param debt_info ѯһ֤ȯͷϢ
    ///@param req_count 󵽵
    ///@param order_sequence ҳĵǰر
    ///@param query_reference ǰ֤ȯͷϢϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark order_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱorder_sequencereq_countôʾ֤ȯͷϢԽһηҳѯȣʾ֤ȯͷϢѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryCreditTickerAssignInfoByPage(EMTClientQueryCrdPositionStkInfo* debt_info, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

    ///ȯҵѯָȯϢӦҪٷأϢʱᴥ
    ///@param stock_info ѯȯϢ
    ///@param error_info ѯ˻ȯϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryCreditExcessStock(EMTClientQueryCrdSurplusStkRspInfo* stock_info, EMTRI* error_info, int request_id, uint64_t session_id);

    ///ȯҵѯȯϢӦҪٷأϢʱᴥ
    ///@param stock_info ѯȯϢ
    ///@param error_info ѯ˻ȯϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryMulCreditExcessStock(EMTClientQueryCrdSurplusStkRspInfo* stock_info, EMTRI* error_info, int request_id, uint64_t session_id, bool is_last);

    ///ȯҵиծԼչڵ֪ͨ
    ///@param debt_extend_info ծԼչ֪ͨľϢûͨdebt_extend_info.emtidͨGetClientIDByEMTID() == client_idԼĶ
    ///@param error_info ծԼչڶܾ߷ʱʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ծԼչڶ״̬仯ʱ򣬻ᱻãҪٷأϢʱᴥߡе¼˴ûĿͻ˶յûĸծԼչ֪ͨ
    virtual void OnCreditExtendDebtDate(EMTCreditDebtExtendNotice* debt_extend_info, EMTRI* error_info, uint64_t session_id);

    ///ѯȯҵиծԼչڶӦҪٷأϢʱᴥ
    ///@param debt_extend_info ѯĸծԼչ
    ///@param error_info ѯծԼչڷʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд󡣵error_info.error_id=11000350ʱûм¼Ϊ0ֵʱԼܵʱĴԭ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryCreditExtendDebtDateOrders(EMTCreditDebtExtendNotice* debt_extend_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯȯҵ˻ϢӦҪٷأϢʱᴥ
    ///@param fund_info ˻Ϣ
    ///@param error_info ѯ˻ϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryCreditFundExtraInfo(EMTCrdFundExtraInfo* fund_info, EMTRI* error_info, int request_id, uint64_t session_id);

    ///ѯȯҵ˻ָ֤ȯĸϢӦҪٷأϢʱᴥ
    ///@param fund_info ˻ָ֤ȯĸϢ
    ///@param error_info ѯ˻ϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryCreditPositionExtraInfo(EMTCrdPositionExtraInfo* fund_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ȨϲԱ֪ͨ
    ///@param order_info ӦϢûͨorder_info.order_emt_idͨGetClientIDByEMTID() == client_idԼĶorder_info.qty_leftֶڶΪδɽɡȫɡϵ״̬ʱʾ˶ûгɽڲȫ״̬ʱʾ˶order_info.order_cancel_emt_idΪӦĳIDΪ0ʱʾ˵ɹ
    ///@param error_info ܾ߷ʱʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ÿζ״̬ʱᱻãҪٷأϢʱᴥߣڶδɽȫɽȫֳѾܾЩ״̬ʱӦڲֳɽɶĳɽرȷϡе¼˴ûĿͻ˶յûĶӦ
    virtual void OnOptionCombinedOrderEvent(EMTOptCombOrderInfo* order_info, EMTRI* error_info, uint64_t session_id);

    ///ȨϲԳɽ֪ͨ
    ///@param trade_info ɽرľϢûͨtrade_info.order_emt_idͨGetClientIDByEMTID() == client_idԼĶϽexec_idΨһʶһʳɽ2ʳɽرӵͬexec_idΪ˱ʽԳɽˡexec_idΨһģʱ޴жϻơreport_index+marketֶοΨһʶʾɽر
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark гɽʱ򣬻ᱻãҪٷأϢʱᴥߡе¼˴ûĿͻ˶յûĳɽرضΪ״̬ҪûͨɽرĳɽȷOnOrderEvent()Ͳ״̬
    virtual void OnOptionCombinedTradeEvent(EMTOptCombTradeReport* trade_info, uint64_t session_id);

    ///ȨϲԳӦ
    ///@param cancel_info Ϣorder_cancel_emt_idʹorder_emt_id
    ///@param error_info ܾ߷ʱʹϢҪٷأϢʱᴥߣerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark Ӧֻڳʱص
    virtual void OnCancelOptionCombinedOrderError(EMTOptCombOrderCancelInfo* cancel_info, EMTRI* error_info, uint64_t session_id);

    ///ѯȨϲԱӦ
    ///@param order_info ѯһ
    ///@param error_info ѯʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥߡ˶Ӧѯʹãʱû·ӵ£api
    virtual void OnQueryOptionCombinedOrders(EMTQueryOptCombOrderRsp* order_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ҳѯȨϲԱӦ
    ///@param order_info ѯһ
    ///@param req_count 󵽵
    ///@param order_sequence ҳĵǰر
    ///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark order_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱorder_sequencereq_countôʾбԽһηҳѯȣʾбѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryOptionCombinedOrdersByPage(EMTQueryOptCombOrderRsp* order_info, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

    ///ѯȨϲԳɽӦ
    ///@param trade_info ѯһɽر
    ///@param error_info ѯɽرʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥߡ˶Ӧѯʹãʱû·ӵ£api
    virtual void OnQueryOptionCombinedTrades(EMTQueryOptCombTradeRsp* trade_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ҳѯȨϲԳɽӦ
    ///@param trade_info ѯһɽϢ
    ///@param req_count 󵽵
    ///@param trade_sequence ҳĵǰر
    ///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark trade_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱtrade_sequencereq_countôʾлرԽһηҳѯȣʾлرѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryOptionCombinedTradesByPage(EMTQueryOptCombTradeRsp* trade_info, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

    ///ѯȨϲԳֲӦ
    ///@param position_info ѯһֲϢ
    ///@param error_info ѯֲַʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark һѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryOptionCombinedPosition(EMTQueryOptCombPositionRsp* position_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯȨϲϢӦ
    ///@param strategy_info ѯһϲϢ
    ///@param error_info ѯɽرʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark һѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryOptionCombinedStrategyInfo(EMTQueryCombineStrategyInfoRsp* strategy_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯȯҵеƷʵӦ
    ///@param pledge_stk_rate_info ƷϢѯʱؿ
    ///@param error_info ѯƷʷʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    virtual void OnQueryCreditPledgeStkRate(EMTClientQueryCreditPledgeStkRateRsp* pledge_stk_rate_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯȨȨϲͷӦ
    ///@param position_info ѯһȨϲͷϢ
    ///@param error_info ѯֲַʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    virtual void OnQueryOptionCombinedExecPosition(EMTQueryOptCombExecPosRsp* position_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯȯ֤Ӧ
    ///@param margin_rate_info ȯ֤Ϣѯʱؿ
    ///@param error_info ѯȯ֤ʷʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    virtual void OnQueryCreditMarginRate(EMTClientQueryCreditMarginRateRsp* margin_rate_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯȯͷȫռ÷Ӧ
    ///@param position_fullrate_info ȯͷȫռ÷Ϣѯʱؿ
    ///@param error_info ѯȯͷȫռ÷ʷʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    virtual void OnQueryCreditPositionFullRate(EMTClientQueryCreditPositionFullRateRsp* position_fullrate_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ȯɵ֤ȯҳѯӦ
    ///@param pledge_stk_info ȯɵ֤ȯϢѯʱؿ
    ///@param error_info ȯɵ֤ȯҳѯʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    virtual void OnQueryCreditPledgeStkPagination(EMTClientQueryCreditPledgeStkPaginationRsp* pledge_stk_info, EMTRI* error_info, int request_id, uint64_t session_id);

    ///ȯ֤ȯҳѯӦ
    ///@param target_stk_info ȯ֤ȯϢѯʱؿ
    ///@param error_info ȯ֤ȯҳѯʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    virtual void OnQueryCreditTargetStkPagination(EMTClientQueryCreditTargetStkPaginationRsp* target_stk_info, EMTRI* error_info, int request_id, uint64_t session_id);

    ///ѯҵϢбӦҪٷأϢʱᴥ
    ///@param issue_info ѯĽɵһֻƱϢ
    ///@param error_info ѯϢбʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryIssueInfoList(EMTQueryIssueTickerRsp* issue_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯSecurityϢӦ
    ///@param security ѯһֻ֤ȯϸϢ
    ///@param error_info ѯ֤ȯϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ûܲѯƱϢһѯܶӦӦҪٷأϢʱᴥ
    virtual void OnQuerySecurityInfo(EMTQuerySecurityInfoRsp* security, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ȯطֲöȵ֪ͨ
    ///@param quota_transfer_info öȵ֪ͨľϢûͨquota_transfer_info.serial_idͨGetClientIDByEMTID() == client_idԼĶ
    ///@param error_info öȵܾ߷ʱʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark öȵ״̬仯ʱ򣬻ᱻãҪٷأϢʱᴥߡе¼˴ûĿͻ˶յûĶȵ֪ͨ
    virtual void OnCreditQuotaTransfer(EMTQuotaTransferNotice* quota_transfer_info, EMTRI* error_info, uint64_t session_id);

    ///ѯȯطֲöȵӦҪٷأϢʱᴥ
    ///@param quota_transfer_info öȵ֪ͨľϢ
    ///@param error_info ѯöȷʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryCreditQuotaTransfer(EMTQuotaTransferNotice* quota_transfer_info, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///ѯʲӦҪٷأϢʱᴥ
    ///@param yesterday_asset ѯʲ            
    ///@param error_info ѯʲʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    virtual void OnQueryYesterdayAsset(EMTQueryYesterdayAssetRsp* yesterday_asset, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///OtcҳѯֲӦ
    ///@param position_info ѯһֲϢ
    ///@param req_count 󵽵
    ///@param trade_sequence ҳĵǰر
    ///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark trade_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱtrade_sequencereq_countôʾлرԽһηҳѯȣʾлرѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    ///virtual void OnQueryOtcPositionByPage(EMTOtcPositionInfo* position_info, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

    ///Otcѯʽ˻ӦҪٷأϢʱᴥ
    ///@param asset ѯʽ˻
    ///@param error_info ѯʽ˻ʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark ҪٷأϢʱᴥ
    ///virtual void OnQueryOtcAsset(EMTOtcAssetInfo* asset, EMTRI* error_info, int request_id, bool is_last, uint64_t session_id);

    ///OtcҳѯίӦ
    ///@param order_info ѯһ
    ///@param req_count 󵽵
    ///@param order_sequence ҳĵǰر
    ///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark order_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱorder_sequencereq_countôʾлرԽһηҳѯȣʾлرѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryOtcOrderByPage(EMTQueryOrderRsp* order_info, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

    ///OtcҳѯɽӦ
    ///@param trade_info ѯһ
    ///@param req_count 󵽵
    ///@param trade_sequence ҳĵǰر
    ///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark trade_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱtrade_sequencereq_countôʾлرԽһηҳѯȣʾлرѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryOtcTradeByPage(EMTQueryTradeRsp* trade_info, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

    ///ҳѯETF嵥ļӦ
    ///@param etf_info ѯһETFϢ
    ///@param req_count 󵽵
    ///@param rsp_sequence ҳĵǰر
    ///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark rsp_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱrsp_sequencereq_countôʾϢԽһηҳѯȣʾнѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQueryETFByPage(EMTQueryETFBaseRsp* etf_info, int64_t req_count, int64_t rsp_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

    ///ҳѯĻϢӦ
    ///@param security_info ѯһϢ
    ///@param req_count 󵽵
    ///@param rsp_sequence ҳĵǰر
    ///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
    ///@param request_id ϢӦӦID
    ///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
    ///@param session_id ʽ˻Ӧsession_id¼ʱõ
    ///@remark rsp_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱrsp_sequencereq_countôʾбԽһηҳѯȣʾбѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
    virtual void OnQuerySecurityByPage(EMTQuerySecurityByPageRsp* security_info, int64_t req_count, int64_t rsp_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//-------------------------------------------------------------------------------------

    virtual void onConnected() {};

    virtual void onDisconnected(int reason) {};

    virtual void onError(const dict& error) {};

    virtual void onOrderEvent(const dict& data, const dict& error, uint64_t session_id) {};

    virtual void onTradeEvent(const dict& data, uint64_t session_id) {};

    virtual void onCancelOrderError(const dict& data, const dict& error, uint64_t session_id) {};

    virtual void onQueryOrder(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOrderByPage(const dict& data, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryTrade(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryTradeByPage(const dict& data, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryPosition(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryPositionByPage(const dict& data, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryAsset(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryFundTransfer(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onFundTransfer(const dict& data, const dict& error, uint64_t session_id) {};

    virtual void onQueryOtherServerFund(const dict& data, const dict& error, int request_id, uint64_t session_id) {};

    virtual void onQueryETF(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryETFBasket(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryIPOInfoList(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryIPOQuotaInfo(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOptionAuctionInfo(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onCreditCashRepay(const dict& data, const dict& error, uint64_t session_id) {};

    virtual void onCreditCashRepayDebtInterestFee(const dict& data, const dict& error, uint64_t session_id) {};

    virtual void onQueryCreditCashRepayInfo(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryCreditFundInfo(const dict& data, const dict& error, int request_id, uint64_t session_id) {};

    virtual void onQueryCreditDebtInfo(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryCreditDebtInfoByPage(const dict& data, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryCreditTickerDebtInfo(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryCreditAssetDebtInfo(double remain_amount, const dict& error, int request_id, uint64_t session_id) {};

    virtual void onQueryCreditTickerAssignInfo(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryCreditTickerAssignInfoByPage(const dict& data, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryCreditExcessStock(const dict& data, const dict& error, int request_id, uint64_t session_id) {};

    virtual void onQueryMulCreditExcessStock(const dict& data, const dict& error, int request_id, uint64_t session_id, bool is_last) {};

    virtual void onCreditExtendDebtDate(const dict& data, const dict& error, uint64_t session_id) {};

    virtual void onQueryCreditExtendDebtDateOrders(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryCreditFundExtraInfo(const dict& data, const dict& error, int request_id, uint64_t session_id) {};

    virtual void onQueryCreditPositionExtraInfo(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onOptionCombinedOrderEvent(const dict& data, const dict& error, uint64_t session_id) {};

    virtual void onOptionCombinedTradeEvent(const dict& data, uint64_t session_id) {};

    virtual void onCancelOptionCombinedOrderError(const dict& data, const dict& error, uint64_t session_id) {};

    virtual void onQueryOptionCombinedOrders(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOptionCombinedOrdersByPage(const dict& data, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOptionCombinedTrades(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOptionCombinedTradesByPage(const dict& data, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOptionCombinedPosition(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOptionCombinedStrategyInfo(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryCreditPledgeStkRate(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOptionCombinedExecPosition(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryCreditMarginRate(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryCreditPositionFullRate(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryCreditPledgeStkPagination(const dict& data, const dict& error, int request_id, uint64_t session_id) {};

    virtual void onQueryCreditTargetStkPagination(const dict& data, const dict& error, int request_id, uint64_t session_id) {};

    virtual void onQueryIssueInfoList(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQuerySecurityInfo(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onCreditQuotaTransfer(const dict& data, const dict& error, uint64_t session_id) {};

    virtual void onQueryCreditQuotaTransfer(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryYesterdayAsset(const dict& data, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOtcPositionByPage(EMTOtcPositionInfo position_info, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOtcAsset(EMTOtcAssetInfo asset, const dict& error, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOtcOrderByPage(const dict& data, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryOtcTradeByPage(const dict& data, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQueryETFByPage(const dict& data, int64_t req_count, int64_t rsp_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

    virtual void onQuerySecurityByPage(const dict& data, int64_t req_count, int64_t rsp_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};




	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void createTraderApi(int client_id, string save_file_path, int log_level);

	void release();

	void init();

	int exit();

	string getTradingDay();

	string getApiVersion();

	dict getApiLastError();

	int getClientIDByXTPID(uint64_t order_xtp_id);

	string getAccountByXTPID(uint64_t order_xtp_id);

	void subscribePublicTopic(int resume_type);

	void setSoftwareVersion(string version);

	///void setSoftwareKey(string key);

	void setHeartBeatInterval(int interval);

	uint64_t login(string ip, int port, string user, string password, int sock_type);

	int logout(uint64_t session_id);

	bool isServerRestart(uint64_t session_id);

	///int modifyUserTerminalInfo(const dict &req, uint64_t session_id);

	uint64_t insertOrder(const dict &req, uint64_t session_id);

	uint64_t cancelOrder(uint64_t order_xtp_id, uint64_t session_id);

    int queryOrderByEMTID(uint64_t order_emt_id, uint64_t session_id, int request_id);

    int queryOrders(const dict& req, uint64_t session_id, int request_id);

    int queryUnfinishedOrders(uint64_t session_id, int request_id);

    int queryOrdersByPage(const dict& req, uint64_t session_id, int request_id);

    int queryTradesByEMTID(uint64_t order_emt_id, uint64_t session_id, int request_id);

    int queryTrades(const dict& req, uint64_t session_id, int request_id);

    int queryTradesByPage(const dict& req, uint64_t session_id, int request_id);

    int queryPosition(string ticker, uint64_t session_id, int request_id, int market);

    int queryPositionByPage(const dict& req, uint64_t session_id, int request_id);

    int queryAsset(uint64_t session_id, int request_id);

    int queryFundTransfer(const dict& req, uint64_t session_id, int request_id);

    int queryOtherServerFund(const dict& req, uint64_t session_id, int request_id);

    int queryETF(const dict& req, uint64_t session_id, int request_id);

    int queryETFTickerBasket(const dict& req, uint64_t session_id, int request_id);

    int queryIPOInfoList(uint64_t session_id, int request_id);

    int queryIPOQuotaInfo(uint64_t session_id, int request_id);

    int queryOptionAuctionInfo(const dict& req, uint64_t session_id, int request_id);

    int queryCreditCashRepayInfo(uint64_t session_id, int request_id);

    int queryCreditFundInfo(uint64_t session_id, int request_id);

    int queryCreditDebtInfo(uint64_t session_id, int request_id);

    ///int queryCreditDebtInfoByPage(const dict& req, uint64_t session_id, int request_id);

    int queryCreditTickerDebtInfo(const dict& req, uint64_t session_id, int request_id);

    int queryCreditAssetDebtInfo(uint64_t session_id, int request_id);

    int queryCreditTickerAssignInfo(const dict& req, uint64_t session_id, int request_id);

    int queryCreditTickerAssignInfoByPage(const dict& req, uint64_t session_id, int request_id);

    int queryCreditExcessStock(const dict& req, uint64_t session_id, int request_id);

    int queryMulCreditExcessStock(const dict& req, uint64_t session_id, int request_id);

    int queryCreditExtendDebtDateOrders(uint64_t emt_id, uint64_t session_id, int request_id);

    int queryCreditFundExtraInfo(uint64_t session_id, int request_id);

    int queryCreditPositionExtraInfo(const dict& req, uint64_t session_id, int request_id);

    int queryOptionCombinedUnfinishedOrders(uint64_t session_id, int request_id);

    int queryOptionCombinedOrderByEMTID(uint64_t order_emt_id, uint64_t session_id, int request_id);

    int queryOptionCombinedOrders(const dict& req, uint64_t session_id, int request_id);

    int queryOptionCombinedOrdersByPage(const dict& req, uint64_t session_id, int request_id);

    int queryOptionCombinedTradesByEMTID(uint64_t order_emt_id, uint64_t session_id, int request_id);

    int queryOptionCombinedTrades(const dict& req, uint64_t session_id, int request_id);

    int queryOptionCombinedTradesByPage(const dict& req, uint64_t session_id, int request_id);

    int queryOptionCombinedPosition(const dict& req, uint64_t session_id, int request_id);

    int queryOptionCombinedStrategyInfo(uint64_t session_id, int request_id);

    int queryCreditPledgeStkRate(const dict& req, uint64_t session_id, int request_id);

    int queryOptionCombinedExecPosition(const dict& req, uint64_t session_id, int request_id);

    int queryCreditMarginRate(const dict& req, uint64_t session_id, int request_id);

    int queryCreditPositionFullRate(const dict& req, uint64_t session_id, int request_id);

    int queryCreditPledgeStkPagination(const dict& req, uint64_t session_id, int request_id);

    int queryCreditTargetStkPagination(const dict& req, uint64_t session_id, int request_id);

    int queryIssueInfoList(uint64_t session_id, int request_id);

    int querySecurityInfo(const dict& req, uint64_t session_id, int request_id);

    int queryCreditQuotaTransfer(const dict& req, uint64_t session_id, int request_id);

    int queryYesterdayAsset(uint64_t session_id, int request_id);

    int queryOtcPositionByPage(const dict& req, uint64_t session_id, int request_id);

    int queryOtcAsset(uint64_t session_id, int request_id);

    int queryOtcOrdersByPage(const dict& req, uint64_t session_id, int request_id);

    int queryOtcTradesByPage(const dict& req, uint64_t session_id, int request_id);

    int queryETFByPage(const dict& req, uint64_t session_id, int request_id);

    int querySecurityByPage(const dict& req, uint64_t session_id, int request_id);

};
