//ϵͳ
#ifdef WIN32
//#include "stdafx.h"
#endif

#include "vnemt.h"
#include "pybind11/pybind11.h"
#include "emt/emt_quote_api.h"


using namespace pybind11;
using namespace EMT::API;


///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class MdApi : public QuoteSpi
{
private:
	QuoteApi* api = NULL;				//API
	bool active = false;		//״̬

public:
	MdApi()
	{
	};

	~MdApi()
	{
		if (this->active)
		{
			this->exit();
		}
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

	///ͻ̨ͨӶϿʱ÷á
	///@param reason ԭӦ
	///@remark apiԶ߷ʱûѡڴ˺еLoginµ¼עûµ¼Ҫ¶
	virtual void OnDisconnected(int reason);

	/**
	*   Ӧ
	*   @attention					˺ֻڷʱŻãһû
	*   @param error_info			Ӧʱľ
	*   @return						úΪvoid
	*/
	virtual void OnError(EMTRspInfoStruct* error_info);

	/**
	*   ָ֪ͨ
	*   @attention					ҪٷأϢʱʱᴥ
	*   @param index_data			ָݣֶָֻ
	*/
	virtual void OnIndexData(EMTIndexDataStruct* index_data);

	/**
	*   ֪ͨһһ
	*   @attention					ҪٷأϢʱᴥ
	*   @param market_data			
	*   @param bid1_qty				һ
	*   @param bid1_count			һеЧίб
	*   @param max_bid1_count		һίб
	*   @param ask1_qty				һ
	*   @param ask1_count			һеЧίб
	*   @param max_ask1_count		һίб
	*/
	virtual void OnDepthMarketData(EMTMarketDataStruct* market_data, int64_t bid1_qty[], int32_t bid1_count, int32_t max_bid1_count, int64_t ask1_qty[], int32_t ask1_count, int32_t max_ask1_count);

	/**
	*   ֪ͨƱȨ֤ծȯѺʽع
	*   @attention					ÿĵĺԼӦһӦҪٷأϢʱᴥ
	*   @param tbt_data				ݣίкʳɽΪýṹ壬Ҫtypeίлʳɽ
	*/
	virtual void OnTickByTick(EMTTickByTickStruct* tbt_data);

	/**
	*   鶩֪ͨ
	*   @param order_book			鶩ݣҪٷأϢʱᴥ
	*/
	virtual void OnOrderBook(EMTOrderBookStruct* order_book);

	/**
	*   ʱ֪ͨ
	*   @param minute_info			ʱݣҪٷأϢʱᴥ
	*/
	virtual void OnMinuteInfo(EMTMinuteInfo* minute_info);

	/**
	*   ȫгָӦ
	*   @attention					Ҫٷ
	*   @param exchange_id			룬EMT_EXCHANGE_SHʾΪϺȫгEMT_EXCHANGE_SZʾΪȫг
	*	@param error_info			ĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*/
	virtual void OnSubscribeAllIndexData(EMT_EXCHANGE_TYPE exchange_id, EMTRspInfoStruct* error_info);

	/**
	*   ˶ȫгָӦ
	*   @attention					Ҫٷ
	*   @param exchange_id			룬EMT_EXCHANGE_SHʾΪϺȫгEMT_EXCHANGE_SZʾΪȫг
	*	@param error_info			ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*/
	virtual void OnUnSubscribeAllIndexData(EMT_EXCHANGE_TYPE exchange_id, EMTRspInfoStruct* error_info);

	/**
	*   ָӦ
	*   @attention					ÿĵĺԼӦһӦҪٷأϢʱᴥ
	*   @param ticker				ĵĺԼŴ
	*   @param error_info			ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*	@param is_last				Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnSubIndexData(EMTSpecificTickerStruct* ticker, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ˶ָӦ
	*   @attention					ÿĵĺԼӦһ˶ӦҪٷأϢʱᴥ
	*   @param ticker				ĵĺԼŴ
	*   @param error_info			ȡĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*	@param is_last				Ƿ˴ȡĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnUnSubIndexData(EMTSpecificTickerStruct* ticker, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ȫгƱӦ
	*   @attention					Ҫٷ
	*   @param exchange_id			룬EMT_EXCHANGE_SHʾΪϺȫгEMT_EXCHANGE_SZʾΪȫг
	*	@param error_info			ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*/
	virtual void OnSubscribeAllMarketData(EMT_EXCHANGE_TYPE exchange_id, EMTRspInfoStruct* error_info);

	/**
	*   ˶ȫгĹƱӦ
	*   @attention					Ҫٷ
	*   @param exchange_id			룬EMT_EXCHANGE_SHʾΪϺȫгEMT_EXCHANGE_SZʾΪȫг
	*	@param error_info			ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*/
	virtual void OnUnSubscribeAllMarketData(EMT_EXCHANGE_TYPE exchange_id, EMTRspInfoStruct* error_info);

	/**
	*   ĿӦ𣬰ƱծȯȨ֤Ѻʽع
	*   @attention					ÿĵĺԼӦһӦҪٷأϢʱᴥ
	*   @param ticker				ĵĺԼŴ
	*   @param error_info			ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*	@param is_last				Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnSubMarketData(EMTSpecificTickerStruct* ticker, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ˶Ӧ𣬰ƱծȯȨ֤Ѻʽع
	*   @attention					ÿĵĺԼӦһӦҪٷأϢʱᴥ
	*   @param ticker				ĵĺԼŴ
	*   @param error_info			ȡĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*	@param is_last				Ƿ˴ȡĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnUnSubMarketData(EMTSpecificTickerStruct* ticker, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ȫгӦ
	*   @attention					Ҫٷ
	*   @param exchange_id			룬EMT_EXCHANGE_SHʾΪϺȫгEMT_EXCHANGE_SZʾΪȫг
	*	@param error_info			ĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*/
	virtual void OnSubscribeAllTickByTick(EMT_EXCHANGE_TYPE exchange_id, EMTRspInfoStruct* error_info);

	/**
	*   ˶ȫгӦ
	*   @attention					Ҫٷ
	*   @param exchange_id			룬EMT_EXCHANGE_SHʾΪϺȫгEMT_EXCHANGE_SZʾΪȫг
	*	@param error_info			ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*/
	virtual void OnUnSubscribeAllTickByTick(EMT_EXCHANGE_TYPE exchange_id, EMTRspInfoStruct* error_info);

	/**
	*   Ӧ𣬰ƱծȯȨ֤
	*   @attention					ÿĵĺԼӦһӦҪٷأϢʱᴥ
	*   @param ticker				ĵĺԼ
	*   @param error_info			ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*	@param is_last				Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnSubTickByTick(EMTSpecificTickerStruct* ticker, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ˶Ӧ𣬰ƱծȯȨ֤
	*   @attention					ÿĵĺԼӦһӦҪٷأϢʱᴥ
	*   @param ticker				ĵĺԼ
	*   @param error_info			ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*	@param is_last				Ƿ˴ȡĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnUnSubTickByTick(EMTSpecificTickerStruct* ticker, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   鶩Ӧ
	*   @attention                  Ҫٷ
	*   @param exchange_id          룬EMT_EXCHANGE_SHʾΪϺȫгEMT_EXCHANGE_SZʾΪȫг
	*   @param error_info           ĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд*/
	virtual void OnSubscribeAllOrderBook(EMT_EXCHANGE_TYPE exchange_id, EMTRspInfoStruct* error_info);

	/**
	*   ˶ȫгĹƱ鶩Ӧ
	*   @attention                  Ҫٷ
	*   @param exchange_id          룬EMT_EXCHANGE_SHʾΪϺȫгEMT_EXCHANGE_SZʾΪȫг
	*   @param error_info           ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*/
	virtual void OnUnSubscribeAllOrderBook(EMT_EXCHANGE_TYPE exchange_id, EMTRspInfoStruct* error_info);

	/**
	*   鶩Ӧ
	*   @attention                  Ҫٷ
	*   @param ticker               ĵĺԼ
	*   @param error_info           ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*   @param is_last              Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnSubOrderBook(EMTSpecificTickerStruct* ticker, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ˶鶩Ӧ
	*   @attention                  Ҫٷ
	*   @param ticker               ĵĺԼŴ
	*   @param error_info           ȡĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*   @param is_last              Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnUnSubOrderBook(EMTSpecificTickerStruct* ticker, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ȫгʱ
	*   @attention                  Ҫٷ
	*   @param exchange_id          룬EMT_EXCHANGE_SHʾΪϺȫгEMT_EXCHANGE_SZʾΪȫг
	*   @param error_info           ĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*/
	virtual void OnSubscribeAllMinuteInfo(EMT_EXCHANGE_TYPE exchange_id, EMTRspInfoStruct* error_info);

	/**
	*   ˶ȫгʱ
	*   @attention                  Ҫٷ
	*   @param exchange_id          룬EMT_EXCHANGE_SHʾΪϺȫгEMT_EXCHANGE_SZʾΪȫг
	*   @param error_info           ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*/
	virtual void OnUnSubscribeAllMinuteInfo(EMT_EXCHANGE_TYPE exchange_id, EMTRspInfoStruct* error_info);

	/**
	*   ķʱ
	*   @attention                  Ҫٷ
	*   @param ticker               ĵĺԼ
	*   @param error_info           ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*   @param is_last              Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnSubMinuteInfo(EMTSpecificTickerStruct* ticker, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ˶ʱ
	*   @attention                  Ҫٷ
	*   @param ticker               ĵĺԼ
	*   @param error_info           ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*   @param is_last              Ƿ˴ȡĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnUnSubMinuteInfo(EMTSpecificTickerStruct* ticker, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ѯȫгԼ־̬ϢӦ
	*   @attention					ҪʹúԼ־̬ϢṹEMTQuoteStaticInfo
	*   @param qsi					Լ־̬Ϣṹ
	*   @param error_info			ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*   @param is_last				Ƿ˴˶һӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnQueryAllTickers(EMTQuoteStaticInfo* qsi, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ѯȫгԼ̬ϢӦ
	*   @attention					ҪʹúԼ̬ϢṹEMTQutoFullInfo
	*   @param qfi					Լ̬Ϣṹ
	*   @param error_info			ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*   @param is_last				Ƿ˴˶һӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnQueryAllTickersFullInfo(EMTQuoteFullInfo* qfi, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ѯԼָӦ
	*   @attention					ҪʹݽṹEMTIndexDataStruct
	*   @param index_data			ָ
	*   @param error_info			ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*   @param is_last				Ƿ˴˶һӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnQueryLatestIndexData(EMTIndexDataStruct* index_data, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ѯԼֻյӦ
	*   @attention					ҪʹݽṹEMTIndexDataStruct
	*   @param market_data			ֻ
	*   @param error_info			ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*   @param is_last				Ƿ˴˶һӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnQueryLatestMarketData(EMTMarketDataStruct* market_data, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ѯʱݵӦ
	*   @attention					Ҫʹ÷ʱṹEMTMinuteInfo
	*   @param minute_info			·ʱ
	*   @param error_info			ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*   @param is_last				Ƿ˴˶һӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnQueryMinuteInfo(EMTMinuteInfo* minute_info, EMTRspInfoStruct* error_info, bool is_last);

	/**
	*   ѯʷʱݵӦ
	*   @attention					Ҫʹ÷ʱṹEMTMinuteInfo
	*   @param minute_info			ʷʱ
	*   @param error_info			ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	*   @param is_last				Ƿ˴˶һӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnQueryMinHistoryInfo(EMTMinuteInfo* minute_info, EMTRspInfoStruct* error_info, bool is_last);

	/*
	* ѯ¼
	* @attention					Ҫʹ¼۽ṹEMTTickerPriceInfo
	* @param price_info				¼۸
	* @param error_info				ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	* @param is_last				Ƿ˴˶һӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	*/
	virtual void OnQueryTickersPriceInfo(EMTTickerPriceInfo* price_info, EMTRspInfoStruct* error_info, bool is_last);

	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//ԭ
	//-------------------------------------------------------------------------------------

	virtual void onDisconnected(int reason) {};

	virtual void onError(const dict& data) {};

	virtual void onIndexData(const dict& data) {};

	virtual void onDepthMarketData(const dict& data) {};

	virtual void onTickByTick(const dict& data) {};

	virtual void onOrderBook(const dict& data) {};

	virtual void onMinuteInfo(const dict& data) {};

	virtual void onSubscribeAllIndexData(int exchange_id, const dict& data) {};

	virtual void onUnSubscribeAllIndexData(int exchange_id, const dict& data) {};

	virtual void onSubIndexData(const dict& data, const dict& error, bool is_last) {};

	virtual void onUnSubIndexData(const dict& data, const dict& error, bool is_last) {};

	virtual void onSubscribeAllMarketData(int exchange_id, const dict& data) {};

	virtual void onUnSubscribeAllMarketData(int exchange_id, const dict& data) {};

	virtual void onSubMarketData(const dict& data, const dict& error, bool is_last) {};

	virtual void onUnSubMarketData(const dict& data, const dict& error, bool is_last) {};

	virtual void onSubscribeAllTickByTick(int exchange_id, const dict& data) {};

	virtual void onUnSubscribeAllTickByTick(int exchange_id, const dict& data) {};

	virtual void onSubTickByTick(const dict& data, const dict& error, bool is_last) {};

	virtual void onUnSubTickByTick(const dict& data, const dict& error, bool is_last) {};

	virtual void onSubscribeAllOrderBook(int exchange_id, const dict& data) {};

	virtual void onUnSubscribeAllOrderBook(int exchange_id, const dict& data) {};

	virtual void onSubOrderBook(const dict& data, const dict& error, bool is_last) {};

	virtual void onUnSubOrderBook(const dict& data, const dict& error, bool is_last) {};

	virtual void onSubscribeAllMinuteInfo(int exchange_id, const dict& data) {};

	virtual void onUnSubscribeAllMinuteInfo(int exchange_id, const dict& data) {};

	virtual void onSubMinuteInfo(const dict& data, const dict& error, bool is_last) {};

	virtual void onUnSubMinuteInfo(const dict& data, const dict& error, bool is_last) {};

	virtual void onQueryAllTickers(const dict& data, const dict& error, bool is_last) {};

	virtual void onQueryAllTickersFullInfo(const dict& data, const dict& error, bool is_last) {};

	virtual void onQueryLatestIndexData(const dict& data, const dict& error, bool is_last) {};

	virtual void onQueryLatestMarketData(const dict& data, const dict& error, bool is_last) {};

	virtual void onQueryMinuteInfo(const dict& data, const dict& error, bool is_last) {};

	virtual void onQueryMinHistoryInfo(const dict& data, const dict& error, bool is_last) {};

	virtual void onQueryTickersPriceInfo(const dict& data, const dict& error, bool is_last) {};


	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void createQuoteApi(int client_id, string save_file_path, int data_type, int log_level);

	void release();

	void init();

	int exit();

	//string getTradingDay();ڽAPI

	string getApiVersion();

	dict getApiLastError();

	void setUDPBufferSize(int buff_size);

	void setHeartBeatInterval(int interval);

	int subscribeMarketData(string ticker, int count, int exchange_id);

	int unSubscribeMarketData(string ticker, int count, int exchange_id);

	int subscribeOrderBook(string ticker, int count, int exchange_id);

	int unSubscribeOrderBook(string ticker, int count, int exchange_id);

	int subscribeTickByTick(string ticker, int count, int exchange_id);

	int unSubscribeTickByTick(string ticker, int count, int exchange_id);

	int subscribeAllMarketData(int exchange_id);

	int unSubscribeAllMarketData(int exchange_id);

	int subscribeAllOrderBook(int exchange_id);

	int unSubscribeAllOrderBook(int exchange_id);

	int subscribeAllTickByTick(int exchange_id);

	int unSubscribeAllTickByTick(int exchange_id);

	int login(string ip, int port, string user, string password, int sock_type, string local_ip);

	int logout();

	int queryAllTickers(int exchange_id);

	int queryAllTickersFullInfo(int exchange_id);

	int queryLatestInfo(string ticker, int ticker_type, int exchange_id);

	int queryMinuteInfo(string tickers, int count, int ticker_type, int exchange_id);

	int queryMinHistoryInfo(string tickers, int count, int datetime, int ticker_type, int exchange_id);

	int queryTickersPriceInfo(string tickers, int count, int exchange_id);


};
