﻿/////////////////////////////////////////////////////////////////////////
///@author 东方财富证券股份有限公司
///@file eoms_api_fund_struct.h
///@brief 定义资金划拨相关结构体类型
/////////////////////////////////////////////////////////////////////////
#ifndef XOMS_API_FUND_STRUCT_H_
#define XOMS_API_FUND_STRUCT_H_

#include "emt_api_data_type.h"
#include "eoms_api_struct.h"
#include "emt_api_struct_common.h"

#pragma pack(1)

/// 用户资金账户的密码字符串长度
#define EMT_ACCOUNT_PASSWORD_LEN 64
/////////////////////////////////////////////////////////////////////////
///两地分仓信用额度划拨请求
/////////////////////////////////////////////////////////////////////////
struct EMTQuotaTransferReq
{
    ///资金内转编号，无需用户填写，类似于emt_id
    uint64_t	serial_id;
	///资金账户代码
	char        fund_account[EMT_ACCOUNT_NAME_LEN];
	///金额
	double	    amount;
	///内转类型
	EMT_QUOTA_TRANSFER_TYPE	transfer_type;
};

/////////////////////////////////////////////////////////////////////////
///用户资金请求
/////////////////////////////////////////////////////////////////////////
struct EMTFundTransferReq
{
    ///资金内转编号，无需用户填写，类似于emt_id
    uint64_t	serial_id;
	///资金账户代码
	char        fund_account[EMT_ACCOUNT_NAME_LEN];
	///资金账户密码
	char	    password[EMT_ACCOUNT_PASSWORD_LEN];
	///金额
	double	    amount;
	///内转类型
	EMT_FUND_TRANSFER_TYPE	transfer_type;

};

/////////////////////////////////////////////////////////////////////////
///用户资金查询请求结构体
/////////////////////////////////////////////////////////////////////////
 struct EMTFundQueryReq
 {
     ///资金账户代码
     char        fund_account[EMT_ACCOUNT_NAME_LEN];
     ///资金账户密码
     char        password[EMT_ACCOUNT_PASSWORD_LEN];
     ///资金查询类型
     EMT_FUND_QUERY_TYPE query_type;
     ///预留字段
     uint64_t    unknown[4];
 
 };
 
 /////////////////////////////////////////////////////////////////////////
///用户资金查询响应结构体
/////////////////////////////////////////////////////////////////////////
 struct EMTFundQueryRsp
 {
     ///金额
     double        amount;
    ///资金查询类型
     EMT_FUND_QUERY_TYPE query_type;
    ///预留字段
     uint64_t    unknown[4];
 
 };

/////////////////////////////////////////////////////////////////////////
///用户资金划转请求的响应-复用资金通知结构体
/////////////////////////////////////////////////////////////////////////
typedef struct EMTFundTransferNotice EMTFundTransferAck ;
/////////////////////////////////////////////////////////////////////////
///两地分仓融券额度划转请求的响应-复用额度通知结构体
/////////////////////////////////////////////////////////////////////////
typedef struct EMTQuotaTransferNotice EMTQuotaTransferAck ;

#pragma pack()

#endif