# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from tensorflow.core.protobuf import coordination_service_pb2 as tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2


class CoordinationServiceStub(object):
    """Coordination Service defines a TensorFlow service that controls and
    coordinates distributed execution in a cluster of multiple tasks.

    The service keeps track of the cluster configuration and the state of cluster
    members or the leader depending on the role of the current task. The
    distributed runtime leverages this service to coordinate and perform cluster
    initialization, check the healthiness of tasks, and propagate error
    messages to the cluster.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.RegisterTask = channel.unary_unary(
                '/tensorflow.CoordinationService/RegisterTask',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.RegisterTaskRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.RegisterTaskResponse.FromString,
                )
        self.Heartbeat = channel.unary_unary(
                '/tensorflow.CoordinationService/Heartbeat',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.HeartbeatRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.HeartbeatResponse.FromString,
                )
        self.WaitForAllTasks = channel.unary_unary(
                '/tensorflow.CoordinationService/WaitForAllTasks',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.WaitForAllTasksRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.WaitForAllTasksResponse.FromString,
                )
        self.ShutdownTask = channel.unary_unary(
                '/tensorflow.CoordinationService/ShutdownTask',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ShutdownTaskRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ShutdownTaskResponse.FromString,
                )
        self.ResetTask = channel.unary_unary(
                '/tensorflow.CoordinationService/ResetTask',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ResetTaskRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ResetTaskResponse.FromString,
                )
        self.ReportErrorToTask = channel.unary_unary(
                '/tensorflow.CoordinationService/ReportErrorToTask',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToTaskRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToTaskResponse.FromString,
                )
        self.ReportErrorToService = channel.unary_unary(
                '/tensorflow.CoordinationService/ReportErrorToService',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToServiceRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToServiceResponse.FromString,
                )
        self.GetTaskState = channel.unary_unary(
                '/tensorflow.CoordinationService/GetTaskState',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetTaskStateRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetTaskStateResponse.FromString,
                )
        self.InsertKeyValue = channel.unary_unary(
                '/tensorflow.CoordinationService/InsertKeyValue',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.InsertKeyValueRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.InsertKeyValueResponse.FromString,
                )
        self.GetKeyValue = channel.unary_unary(
                '/tensorflow.CoordinationService/GetKeyValue',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueResponse.FromString,
                )
        self.TryGetKeyValue = channel.unary_unary(
                '/tensorflow.CoordinationService/TryGetKeyValue',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.TryGetKeyValueRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.TryGetKeyValueResponse.FromString,
                )
        self.GetKeyValueDir = channel.unary_unary(
                '/tensorflow.CoordinationService/GetKeyValueDir',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueDirRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueDirResponse.FromString,
                )
        self.DeleteKeyValue = channel.unary_unary(
                '/tensorflow.CoordinationService/DeleteKeyValue',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.DeleteKeyValueRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.DeleteKeyValueResponse.FromString,
                )
        self.Barrier = channel.unary_unary(
                '/tensorflow.CoordinationService/Barrier',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.BarrierRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.BarrierResponse.FromString,
                )
        self.CancelBarrier = channel.unary_unary(
                '/tensorflow.CoordinationService/CancelBarrier',
                request_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.CancelBarrierRequest.SerializeToString,
                response_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.CancelBarrierResponse.FromString,
                )


class CoordinationServiceServicer(object):
    """Coordination Service defines a TensorFlow service that controls and
    coordinates distributed execution in a cluster of multiple tasks.

    The service keeps track of the cluster configuration and the state of cluster
    members or the leader depending on the role of the current task. The
    distributed runtime leverages this service to coordinate and perform cluster
    initialization, check the healthiness of tasks, and propagate error
    messages to the cluster.
    """

    def RegisterTask(self, request, context):
        """Register task to coordination service so that the service starts to track
        liveness of the task. RPC blocks and returns only when it registers to
        the service successfully, or error happens in the registering process.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Heartbeat(self, request, context):
        """Heartbeat message from task to coordination service. Heartbeat is sent from
        a task to refresh its timestamp on leader to avoid it becoming stale.
        RPC responds immediately after refreshing the timestamp on leader.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def WaitForAllTasks(self, request, context):
        """Wait for all tasks in the cluster to be up and running. The RPC request
        only gets responded when all tasks have registered, or some error occurs.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ShutdownTask(self, request, context):
        """Disconnects task from the service. If `shutdown_barrier_timeout_in_ms` is
        specified in the config, blocks until all tasks reach the barrier before
        disconnecting together. If the barrier times out, tasks at the barrier will
        still disconnect, while an error is reported to tasks that did not reach
        the barrier on time.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ResetTask(self, request, context):
        """Disconnects task from the service if it is in an ERROR state, thereby
        allowing it to reconnect via RegisterTask() in the future.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ReportErrorToTask(self, request, context):
        """Report error to the task. RPC sets the receiving instance of coordination
        service agent to error state permanently.
        TODO(b/195990880): Consider splitting this into a different RPC service.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ReportErrorToService(self, request, context):
        """Report task error to coordination service. RPC sets the service-side task
        state to error, and propagate the error to other tasks in the cluster.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTaskState(self, request, context):
        """Get the state of a remote task. Specifically, RPC returns a
        CoordinatedTaskState, and if the task is in an error status, returns a
        non-OK error code, non-empty error message and error payload.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def InsertKeyValue(self, request, context):
        """Insert configuration key-value that will be accessible to all cluster
        tasks. The key can be formatted as Unix file path with hierarchy. The
        coordination service key-value store should only be used for cluster
        configuration data.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetKeyValue(self, request, context):
        """Get configuration key-value. The request blocks until the key-value data
        becomes available (i.e., set by a task in the cluster).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def TryGetKeyValue(self, request, context):
        """Get configuration key-value. The request does not block, but returns an
        error if the requested key does not exist.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetKeyValueDir(self, request, context):
        """Same as GetKeyValue, but returns all values that have keys which are
        prefixed with the directory key.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeleteKeyValue(self, request, context):
        """Delete configuration key-value. If is_directory is set in request,
        recursively clean up all key-values under the path specified by `key`.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Barrier(self, request, context):
        """Blocks until all (or a subset of) tasks are at the barrier or the barrier
        fails.

        `barrier_id` should be unique across barriers. Once the barrier has passed
        or failed, subsequent calls will not block, and immediately respond with
        the previous response.

        The first WaitAtBarrier() call received by the service for a particular
        barrier id is special in that it determines the barrier deadline based on
        timeout duration.
        However, if subsequent calls by different agents specify a different set of
        `tasks` for the same `barrier_id`, the barrier will fail instantly.

        If no tasks are specified (default), the barrier will block for all the
        connected tasks.

        Possible service errors:
        - DeadlineExceeded: Timed out waiting for specified tasks at the barrier.
        Deadline is determined by the server timestamp when it receives the
        first WaitAtBarrier() + timeout duration.
        - Cancelled: One of the tasks called CancelBarrier().
        - Aborted: Service is shutting down.
        - Internal: Any participating task is in ERROR state.
        - InvalidArgument: (1) Conflicting tasks specified by different agents
        for the same barrier, (2) one of the participating tasks is not in
        the cluster, or (3) task making the request is not included in the
        list of participating tasks.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CancelBarrier(self, request, context):
        """Aborts the barrier if it is ongoing.
        Current and future WaitAtBarrier() calls with the same id will return a
        CANCELLED error status.
        Possible service errors:
        - FailedPrecondition: Barrier has already been passed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_CoordinationServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'RegisterTask': grpc.unary_unary_rpc_method_handler(
                    servicer.RegisterTask,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.RegisterTaskRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.RegisterTaskResponse.SerializeToString,
            ),
            'Heartbeat': grpc.unary_unary_rpc_method_handler(
                    servicer.Heartbeat,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.HeartbeatRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.HeartbeatResponse.SerializeToString,
            ),
            'WaitForAllTasks': grpc.unary_unary_rpc_method_handler(
                    servicer.WaitForAllTasks,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.WaitForAllTasksRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.WaitForAllTasksResponse.SerializeToString,
            ),
            'ShutdownTask': grpc.unary_unary_rpc_method_handler(
                    servicer.ShutdownTask,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ShutdownTaskRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ShutdownTaskResponse.SerializeToString,
            ),
            'ResetTask': grpc.unary_unary_rpc_method_handler(
                    servicer.ResetTask,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ResetTaskRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ResetTaskResponse.SerializeToString,
            ),
            'ReportErrorToTask': grpc.unary_unary_rpc_method_handler(
                    servicer.ReportErrorToTask,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToTaskRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToTaskResponse.SerializeToString,
            ),
            'ReportErrorToService': grpc.unary_unary_rpc_method_handler(
                    servicer.ReportErrorToService,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToServiceRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToServiceResponse.SerializeToString,
            ),
            'GetTaskState': grpc.unary_unary_rpc_method_handler(
                    servicer.GetTaskState,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetTaskStateRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetTaskStateResponse.SerializeToString,
            ),
            'InsertKeyValue': grpc.unary_unary_rpc_method_handler(
                    servicer.InsertKeyValue,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.InsertKeyValueRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.InsertKeyValueResponse.SerializeToString,
            ),
            'GetKeyValue': grpc.unary_unary_rpc_method_handler(
                    servicer.GetKeyValue,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueResponse.SerializeToString,
            ),
            'TryGetKeyValue': grpc.unary_unary_rpc_method_handler(
                    servicer.TryGetKeyValue,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.TryGetKeyValueRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.TryGetKeyValueResponse.SerializeToString,
            ),
            'GetKeyValueDir': grpc.unary_unary_rpc_method_handler(
                    servicer.GetKeyValueDir,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueDirRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueDirResponse.SerializeToString,
            ),
            'DeleteKeyValue': grpc.unary_unary_rpc_method_handler(
                    servicer.DeleteKeyValue,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.DeleteKeyValueRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.DeleteKeyValueResponse.SerializeToString,
            ),
            'Barrier': grpc.unary_unary_rpc_method_handler(
                    servicer.Barrier,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.BarrierRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.BarrierResponse.SerializeToString,
            ),
            'CancelBarrier': grpc.unary_unary_rpc_method_handler(
                    servicer.CancelBarrier,
                    request_deserializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.CancelBarrierRequest.FromString,
                    response_serializer=tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.CancelBarrierResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'tensorflow.CoordinationService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class CoordinationService(object):
    """Coordination Service defines a TensorFlow service that controls and
    coordinates distributed execution in a cluster of multiple tasks.

    The service keeps track of the cluster configuration and the state of cluster
    members or the leader depending on the role of the current task. The
    distributed runtime leverages this service to coordinate and perform cluster
    initialization, check the healthiness of tasks, and propagate error
    messages to the cluster.
    """

    @staticmethod
    def RegisterTask(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/RegisterTask',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.RegisterTaskRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.RegisterTaskResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Heartbeat(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/Heartbeat',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.HeartbeatRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.HeartbeatResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def WaitForAllTasks(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/WaitForAllTasks',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.WaitForAllTasksRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.WaitForAllTasksResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ShutdownTask(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/ShutdownTask',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ShutdownTaskRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ShutdownTaskResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ResetTask(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/ResetTask',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ResetTaskRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ResetTaskResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ReportErrorToTask(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/ReportErrorToTask',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToTaskRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToTaskResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ReportErrorToService(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/ReportErrorToService',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToServiceRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.ReportErrorToServiceResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetTaskState(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/GetTaskState',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetTaskStateRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetTaskStateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def InsertKeyValue(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/InsertKeyValue',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.InsertKeyValueRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.InsertKeyValueResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetKeyValue(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/GetKeyValue',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def TryGetKeyValue(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/TryGetKeyValue',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.TryGetKeyValueRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.TryGetKeyValueResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetKeyValueDir(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/GetKeyValueDir',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueDirRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.GetKeyValueDirResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeleteKeyValue(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/DeleteKeyValue',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.DeleteKeyValueRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.DeleteKeyValueResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Barrier(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/Barrier',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.BarrierRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.BarrierResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def CancelBarrier(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/tensorflow.CoordinationService/CancelBarrier',
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.CancelBarrierRequest.SerializeToString,
            tensorflow_dot_core_dot_protobuf_dot_coordination__service__pb2.CancelBarrierResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
