# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AddDcdnDomainRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of a tag. Valid values of N: **1 to 20**.
        self.key = key  # type: str
        # The value of a tag. Valid values of N: **1 to 20**.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDcdnDomainRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddDcdnDomainRequest(TeaModel):
    def __init__(self, check_url=None, domain_name=None, owner_account=None, owner_id=None, resource_group_id=None,
                 scope=None, security_token=None, sources=None, tag=None, top_level_domain=None):
        # The URL that is used to check the accessibility of the origin server.
        self.check_url = check_url  # type: str
        # The domain name that you want to add. You can specify only one domain name in each request.
        # 
        # Wildcard domain names are supported. A wildcard domain name must start with a period (.), such as .example.com.
        self.domain_name = domain_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
        self.resource_group_id = resource_group_id  # type: str
        # The acceleration region. Valid values:
        # 
        # *   **domestic**: Chinese mainland
        # *   **overseas**: global (excluding the Chinese mainland)
        # *   **global**: global
        # 
        # Default value: **domestic**.
        self.scope = scope  # type: str
        self.security_token = security_token  # type: str
        # The information about the addresses of origin servers.
        self.sources = sources  # type: str
        # The information about the tags.
        self.tag = tag  # type: list[AddDcdnDomainRequestTag]
        # The top-level domain.
        self.top_level_domain = top_level_domain  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddDcdnDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_url is not None:
            result['CheckUrl'] = self.check_url
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.sources is not None:
            result['Sources'] = self.sources
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.top_level_domain is not None:
            result['TopLevelDomain'] = self.top_level_domain
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckUrl') is not None:
            self.check_url = m.get('CheckUrl')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('Sources') is not None:
            self.sources = m.get('Sources')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddDcdnDomainRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TopLevelDomain') is not None:
            self.top_level_domain = m.get('TopLevelDomain')
        return self


class AddDcdnDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDcdnDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDcdnDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddDcdnDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddDcdnDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDcdnDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDcdnIpaDomainRequest(TeaModel):
    def __init__(self, check_url=None, domain_name=None, owner_account=None, owner_id=None, protocol=None,
                 resource_group_id=None, scope=None, security_token=None, sources=None, top_level_domain=None):
        # The URL that is used to check the accessibility of the origin server.
        self.check_url = check_url  # type: str
        # The domain name to be added to IPA.
        # 
        # A wildcard domain that starts with a period (.) is supported, such as .example.com.
        self.domain_name = domain_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The protocol. Valid values:
        # 
        # *   **udp**\
        # *   **tcp**\
        # 
        # >  Example: `{"protocol":"udp"}`.
        self.protocol = protocol  # type: str
        # The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
        self.resource_group_id = resource_group_id  # type: str
        # The acceleration region. Valid values:
        # 
        # *   **domestic**: Chinese mainland
        # *   **overseas**: global (excluding the Chinese mainland)
        # *   **global**: global
        self.scope = scope  # type: str
        self.security_token = security_token  # type: str
        # The information about the addresses of origin servers.
        self.sources = sources  # type: str
        # The top-level domain name.
        self.top_level_domain = top_level_domain  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDcdnIpaDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_url is not None:
            result['CheckUrl'] = self.check_url
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.sources is not None:
            result['Sources'] = self.sources
        if self.top_level_domain is not None:
            result['TopLevelDomain'] = self.top_level_domain
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckUrl') is not None:
            self.check_url = m.get('CheckUrl')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('Sources') is not None:
            self.sources = m.get('Sources')
        if m.get('TopLevelDomain') is not None:
            self.top_level_domain = m.get('TopLevelDomain')
        return self


class AddDcdnIpaDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddDcdnIpaDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDcdnIpaDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddDcdnIpaDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddDcdnIpaDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDcdnIpaDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchAddDcdnDomainRequest(TeaModel):
    def __init__(self, check_url=None, domain_name=None, owner_account=None, owner_id=None, resource_group_id=None,
                 scope=None, security_token=None, sources=None, top_level_domain=None):
        # The URL that is used to check whether the origin server can be accessed.
        self.check_url = check_url  # type: str
        # You can add up to 50 domain names to DCDN for each of your Alibaba Cloud account. Separate multiple domain names with commas (,).
        self.domain_name = domain_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
        self.resource_group_id = resource_group_id  # type: str
        # The accelerated region. Default value: domestic. Valid values:
        # 
        # *   domestic: Chinese mainland
        # *   overseas: global (excluding the Chinese mainland)
        # *   global: global
        self.scope = scope  # type: str
        self.security_token = security_token  # type: str
        # The information about the addresses of origin servers.
        self.sources = sources  # type: str
        # The top-level domain name.
        self.top_level_domain = top_level_domain  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddDcdnDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_url is not None:
            result['CheckUrl'] = self.check_url
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.sources is not None:
            result['Sources'] = self.sources
        if self.top_level_domain is not None:
            result['TopLevelDomain'] = self.top_level_domain
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckUrl') is not None:
            self.check_url = m.get('CheckUrl')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('Sources') is not None:
            self.sources = m.get('Sources')
        if m.get('TopLevelDomain') is not None:
            self.top_level_domain = m.get('TopLevelDomain')
        return self


class BatchAddDcdnDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddDcdnDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchAddDcdnDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchAddDcdnDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchAddDcdnDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchAddDcdnDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateDcdnWafRulesRequest(TeaModel):
    def __init__(self, policy_id=None, rule_configs=None):
        # The ID of the protection policy.
        self.policy_id = policy_id  # type: long
        # The configurations of the protection rule.
        self.rule_configs = rule_configs  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCreateDcdnWafRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.rule_configs is not None:
            result['RuleConfigs'] = self.rule_configs
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RuleConfigs') is not None:
            self.rule_configs = m.get('RuleConfigs')
        return self


class BatchCreateDcdnWafRulesResponseBodyRuleIds(TeaModel):
    def __init__(self, rule_id=None):
        self.rule_id = rule_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCreateDcdnWafRulesResponseBodyRuleIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class BatchCreateDcdnWafRulesResponseBody(TeaModel):
    def __init__(self, request_id=None, rule_ids=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The IDs of created rules.
        self.rule_ids = rule_ids  # type: BatchCreateDcdnWafRulesResponseBodyRuleIds

    def validate(self):
        if self.rule_ids:
            self.rule_ids.validate()

    def to_map(self):
        _map = super(BatchCreateDcdnWafRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleIds') is not None:
            temp_model = BatchCreateDcdnWafRulesResponseBodyRuleIds()
            self.rule_ids = temp_model.from_map(m['RuleIds'])
        return self


class BatchCreateDcdnWafRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchCreateDcdnWafRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchCreateDcdnWafRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateDcdnWafRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteDcdnDomainConfigsRequest(TeaModel):
    def __init__(self, domain_names=None, function_names=None, owner_account=None, owner_id=None,
                 security_token=None):
        # The accelerated domain names whose configurations you want to delete. Separate multiple accelerated domain names with commas (,).
        self.domain_names = domain_names  # type: str
        # The names of the features that you want to delete. Separate multiple feature names with commas (,). For more information about feature names, see [Feature settings for a domain name](~~410622~~).
        self.function_names = function_names  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteDcdnDomainConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.function_names is not None:
            result['FunctionNames'] = self.function_names
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('FunctionNames') is not None:
            self.function_names = m.get('FunctionNames')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class BatchDeleteDcdnDomainConfigsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteDcdnDomainConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchDeleteDcdnDomainConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchDeleteDcdnDomainConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchDeleteDcdnDomainConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchDeleteDcdnDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteDcdnWafRulesRequest(TeaModel):
    def __init__(self, rule_ids=None):
        # The IDs of the protection rules that you want to delete. Separate multiple IDs with commas (,).
        self.rule_ids = rule_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteDcdnWafRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        return self


class BatchDeleteDcdnWafRulesResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteDcdnWafRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchDeleteDcdnWafRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchDeleteDcdnWafRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchDeleteDcdnWafRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchDeleteDcdnWafRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchModifyDcdnWafRulesRequest(TeaModel):
    def __init__(self, policy_id=None, rule_configs=None):
        # The ID of the protection policy.
        self.policy_id = policy_id  # type: long
        # The configurations of the protection rule.
        self.rule_configs = rule_configs  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchModifyDcdnWafRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.rule_configs is not None:
            result['RuleConfigs'] = self.rule_configs
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RuleConfigs') is not None:
            self.rule_configs = m.get('RuleConfigs')
        return self


class BatchModifyDcdnWafRulesResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchModifyDcdnWafRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchModifyDcdnWafRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchModifyDcdnWafRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchModifyDcdnWafRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchModifyDcdnWafRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetDcdnDomainCertificateRequest(TeaModel):
    def __init__(self, cert_name=None, cert_type=None, domain_name=None, owner_id=None, region=None, sslpri=None,
                 sslprotocol=None, sslpub=None, security_token=None):
        # The name of the certificate.
        self.cert_name = cert_name  # type: str
        # The type of the certificate. Valid values:
        # 
        # *   **upload**: a custom certificate that you upload.
        # *   **cas**: a certificate that is purchased from Alibaba Cloud SSL Certificates Service
        self.cert_type = cert_type  # type: str
        # The name of the accelerated domain for which you want to configure the HTTPS certificate. The accelerated domain must have HTTPS acceleration enabled. You can specify multiple domain names and separate them with commas (,).
        # 
        # >  You can configure up to 10 domain names at a time.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region.
        self.region = region  # type: str
        # The private key. This parameter is required only if you enable the certificate.
        self.sslpri = sslpri  # type: str
        # Specifies whether to enable the HTTPS certificate. Valid values:
        # 
        # *   **on:**\
        # *   **off**\
        # 
        # The default value is **off**.
        self.sslprotocol = sslprotocol  # type: str
        # The content of the certificate. This parameter is required only if you enable the certificate.
        self.sslpub = sslpub  # type: str
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetDcdnDomainCertificateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cert_type is not None:
            result['CertType'] = self.cert_type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region is not None:
            result['Region'] = self.region
        if self.sslpri is not None:
            result['SSLPri'] = self.sslpri
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.sslpub is not None:
            result['SSLPub'] = self.sslpub
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('CertType') is not None:
            self.cert_type = m.get('CertType')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SSLPri') is not None:
            self.sslpri = m.get('SSLPri')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('SSLPub') is not None:
            self.sslpub = m.get('SSLPub')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class BatchSetDcdnDomainCertificateResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetDcdnDomainCertificateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchSetDcdnDomainCertificateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchSetDcdnDomainCertificateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchSetDcdnDomainCertificateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchSetDcdnDomainCertificateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetDcdnDomainConfigsRequest(TeaModel):
    def __init__(self, domain_names=None, functions=None, owner_account=None, owner_id=None, security_token=None):
        # The accelerated domain names. Specify multiple accelerated domain names with commas (,).
        self.domain_names = domain_names  # type: str
        # The features that you want to configure. Format:
        # 
        # > 
        # *   **functionName**: The name of the feature. Separate multiple values with commas (,). For more information, see [A list of features](~~410622~~).
        # *   **argName**: The feature parameters for **functionName**.
        # *   **argValue**: The parameter values set for **functionName**.
        # 
        #         [
        #          {
        #            "functionArgs": [
        #             {
        #              "argName": "Parameter A", 
        #              "argValue": "Parameter value"
        #             }, 
        #           {
        #             "argName": "Parameter B", 
        #             "argValue": "Parameter value"
        #              }
        #          ], 
        #          "functionName": "Feature name"
        #             }
        #         ]
        self.functions = functions  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetDcdnDomainConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.functions is not None:
            result['Functions'] = self.functions
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('Functions') is not None:
            self.functions = m.get('Functions')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class BatchSetDcdnDomainConfigsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetDcdnDomainConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchSetDcdnDomainConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchSetDcdnDomainConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchSetDcdnDomainConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchSetDcdnDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetDcdnIpaDomainConfigsRequest(TeaModel):
    def __init__(self, domain_names=None, functions=None, owner_account=None, owner_id=None, security_token=None):
        # The domain names accelerated by IPA. Separate multiple domain names with commas (,).
        self.domain_names = domain_names  # type: str
        # The list of features.
        # 
        #     [{"functionArgs":[{"argName":"Parameter name","argValue":"Parameter value"}],"functionName":"Feature name"}]
        self.functions = functions  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetDcdnIpaDomainConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.functions is not None:
            result['Functions'] = self.functions
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('Functions') is not None:
            self.functions = m.get('Functions')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class BatchSetDcdnIpaDomainConfigsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetDcdnIpaDomainConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchSetDcdnIpaDomainConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchSetDcdnIpaDomainConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchSetDcdnIpaDomainConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchSetDcdnIpaDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetDcdnWafDomainConfigsRequest(TeaModel):
    def __init__(self, client_ip_tag=None, defense_status=None, domain_names=None):
        # Specifies the header that records the IP address to be obtained. If the default header is selected, the value of this parameter is empty. If a custom header is selected, the value of this parameter is the value specified by the user. Separate multiple values with commas (,). You can specify a maximum of five values.
        self.client_ip_tag = client_ip_tag  # type: str
        # The protection status of the domain name. Valid values: on, off, and empty string.
        # 
        # *   When you add a domain name, the value of this parameter is **on**, and the value of ClientIpTag takes effect.
        # *   When you delete a domain name, the value of this parameter is **off**, and the value of ClientIpTag does not take effect.
        # *   When you only modify the value of ClientIpTag, the value of DefenseStatus is an empty string.
        self.defense_status = defense_status  # type: str
        # The protected domain names for which you want to change the protection status. You can specify up to 50 domain names. Separate multiple domain names with commas (,).
        self.domain_names = domain_names  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetDcdnWafDomainConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip_tag is not None:
            result['ClientIpTag'] = self.client_ip_tag
        if self.defense_status is not None:
            result['DefenseStatus'] = self.defense_status
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientIpTag') is not None:
            self.client_ip_tag = m.get('ClientIpTag')
        if m.get('DefenseStatus') is not None:
            self.defense_status = m.get('DefenseStatus')
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        return self


class BatchSetDcdnWafDomainConfigsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetDcdnWafDomainConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchSetDcdnWafDomainConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchSetDcdnWafDomainConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchSetDcdnWafDomainConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchSetDcdnWafDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckDcdnProjectExistRequest(TeaModel):
    def __init__(self, project_name=None):
        # The name of a real-time log delivery project.
        self.project_name = project_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckDcdnProjectExistRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class CheckDcdnProjectExistResponseBodyContent(TeaModel):
    def __init__(self, exist=None):
        # Indicates whether the real-time log delivery project exists. Valid values:
        # 
        # *   **false**: The real-time log delivery project does not exist.
        # *   **true**: The real-time log delivery project exists.
        self.exist = exist  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckDcdnProjectExistResponseBodyContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exist is not None:
            result['Exist'] = self.exist
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Exist') is not None:
            self.exist = m.get('Exist')
        return self


class CheckDcdnProjectExistResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The returned results.
        self.content = content  # type: CheckDcdnProjectExistResponseBodyContent
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super(CheckDcdnProjectExistResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = CheckDcdnProjectExistResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckDcdnProjectExistResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckDcdnProjectExistResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckDcdnProjectExistResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckDcdnProjectExistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommitStagingRoutineCodeRequest(TeaModel):
    def __init__(self, code_description=None, name=None):
        # The description of the code version.
        self.code_description = code_description  # type: str
        # The name of the routine. The name must be unique among the routines that belong to the same Alibaba Cloud account.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommitStagingRoutineCodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code_description is not None:
            result['CodeDescription'] = self.code_description
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CodeDescription') is not None:
            self.code_description = m.get('CodeDescription')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CommitStagingRoutineCodeResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The version number of the code.
        self.content = content  # type: dict[str, any]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommitStagingRoutineCodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CommitStagingRoutineCodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CommitStagingRoutineCodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CommitStagingRoutineCodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CommitStagingRoutineCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDcdnDeliverTaskRequest(TeaModel):
    def __init__(self, deliver=None, domain_name=None, name=None, reports=None, schedule=None):
        # The method that is used to send operations reports. Operations reports are sent to you only by email. The settings must be escaped in JSON.
        self.deliver = deliver  # type: str
        # The domain names to be tracked. Separate multiple domain names with commas (,). You can specify up to 500 domain names. If you want to specify more than 500 domain names, [submit a ticket](https://workorder-intl.console.aliyun.com/?spm=5176.2020520001.aliyun_topbar.18.dbd44bd3e4f845#/ticket/createIndex).
        # 
        # >  If you do not specify a domain name, the custom operations reports are created for all domain names that belong to your Alibaba Cloud account.
        self.domain_name = domain_name  # type: str
        # The name of the tracking task.
        self.name = name  # type: str
        # The operations reports that are tracked by the task. The data must be escaped in JSON.
        self.reports = reports  # type: str
        # The parameters of the tracking task. The settings must be escaped in JSON.
        self.schedule = schedule  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDcdnDeliverTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deliver is not None:
            result['Deliver'] = self.deliver
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.name is not None:
            result['Name'] = self.name
        if self.reports is not None:
            result['Reports'] = self.reports
        if self.schedule is not None:
            result['Schedule'] = self.schedule
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Deliver') is not None:
            self.deliver = m.get('Deliver')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Reports') is not None:
            self.reports = m.get('Reports')
        if m.get('Schedule') is not None:
            self.schedule = m.get('Schedule')
        return self


class CreateDcdnDeliverTaskResponseBody(TeaModel):
    def __init__(self, deliver_id=None, request_id=None):
        # The ID of the change tracking task.
        self.deliver_id = deliver_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDcdnDeliverTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deliver_id is not None:
            result['DeliverId'] = self.deliver_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeliverId') is not None:
            self.deliver_id = m.get('DeliverId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDcdnDeliverTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDcdnDeliverTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDcdnDeliverTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDcdnDeliverTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDcdnSLSRealTimeLogDeliveryRequest(TeaModel):
    def __init__(self, business_type=None, data_center=None, domain_name=None, project_name=None, slslog_store=None,
                 slsproject=None, slsregion=None, sampling_rate=None):
        # The type of the collected logs. Default value: cdn_log_access_l1. Valid values:
        # 
        # *   **cdn_log_access_l1**: access logs of L1 Dynamic Route for CDN (DCDN) points of presence (POPs)
        # *   **cdn_log_origin**: back-to-origin logs
        # *   **cdn_log_er**: EdgeRoutine logs
        self.business_type = business_type  # type: str
        # The data center. Valid values:
        # 
        # *   cn: China
        # *   sg: Singapore
        # *   in: India
        # *   eu: Europe
        # *   us: United States
        self.data_center = data_center  # type: str
        # The domain names from which logs were collected. You can specify one or more domain names. Separate multiple domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The name of a real-time log delivery project.
        self.project_name = project_name  # type: str
        # The name of the Log Service Logstore.
        self.slslog_store = slslog_store  # type: str
        # The name of the Log Service project.
        self.slsproject = slsproject  # type: str
        # The region to which real-time logs are delivered.
        self.slsregion = slsregion  # type: str
        # The sampling rate.
        self.sampling_rate = sampling_rate  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDcdnSLSRealTimeLogDeliveryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.slslog_store is not None:
            result['SLSLogStore'] = self.slslog_store
        if self.slsproject is not None:
            result['SLSProject'] = self.slsproject
        if self.slsregion is not None:
            result['SLSRegion'] = self.slsregion
        if self.sampling_rate is not None:
            result['SamplingRate'] = self.sampling_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('SLSLogStore') is not None:
            self.slslog_store = m.get('SLSLogStore')
        if m.get('SLSProject') is not None:
            self.slsproject = m.get('SLSProject')
        if m.get('SLSRegion') is not None:
            self.slsregion = m.get('SLSRegion')
        if m.get('SamplingRate') is not None:
            self.sampling_rate = m.get('SamplingRate')
        return self


class CreateDcdnSLSRealTimeLogDeliveryResponseBodyContentDomains(TeaModel):
    def __init__(self, desc=None, domain_name=None, region=None, status=None):
        # The description of the returned result.
        self.desc = desc  # type: str
        # The domain name from which real-time logs were collected.
        self.domain_name = domain_name  # type: str
        # The region to which real-time logs were delivered.
        self.region = region  # type: str
        # The status of real-time logs.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDcdnSLSRealTimeLogDeliveryResponseBodyContentDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.region is not None:
            result['Region'] = self.region
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateDcdnSLSRealTimeLogDeliveryResponseBodyContent(TeaModel):
    def __init__(self, domains=None):
        self.domains = domains  # type: list[CreateDcdnSLSRealTimeLogDeliveryResponseBodyContentDomains]

    def validate(self):
        if self.domains:
            for k in self.domains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDcdnSLSRealTimeLogDeliveryResponseBodyContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Domains'] = []
        if self.domains is not None:
            for k in self.domains:
                result['Domains'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domains = []
        if m.get('Domains') is not None:
            for k in m.get('Domains'):
                temp_model = CreateDcdnSLSRealTimeLogDeliveryResponseBodyContentDomains()
                self.domains.append(temp_model.from_map(k))
        return self


class CreateDcdnSLSRealTimeLogDeliveryResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The configuration results of the domain name.
        self.content = content  # type: CreateDcdnSLSRealTimeLogDeliveryResponseBodyContent
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super(CreateDcdnSLSRealTimeLogDeliveryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = CreateDcdnSLSRealTimeLogDeliveryResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDcdnSLSRealTimeLogDeliveryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDcdnSLSRealTimeLogDeliveryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDcdnSLSRealTimeLogDeliveryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDcdnSLSRealTimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDcdnSubTaskRequest(TeaModel):
    def __init__(self, domain_name=None, report_ids=None):
        # The domain names for which you want to create a custom operations report. Separate multiple domain names with commas (,). You can specify up to 500 domain names. If you want to specify more than 500 domain names, [submit a ticket](https://workorder-intl.console.aliyun.com/?spm=5176.2020520001.aliyun_topbar.18.dbd44bd3e4f845#/ticket/createIndex).
        # 
        # >  If you do not specify a domain name, the custom operations reports are created for all domain names that belong to your Alibaba Cloud account.
        self.domain_name = domain_name  # type: str
        # The IDs of the metrics that you want to include in the report. Separate multiple IDs with commas (,). Valid values:
        # 
        # *   **2**: Popular URLs by Request
        # *   **4**: Popular URLs by Traffic
        # *   **6**: Popular Referer by Request
        # *   **8**: Popular Referer by Traffic
        # *   **10**: Popular Back-to-origin URLs by Request
        # *   **12**: Popular Back-to-origin URLs by Traffic
        # *   **14**: Top Client IPs by Request
        # *   **16**: Top Client IPs by Traffic
        # *   **18**: Popular Domain Names by Traffic
        # *   **20**: PV/UV
        # *   **22**: Visit Distribution by Region
        # *   **24**: Distribution of ISPs
        self.report_ids = report_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDcdnSubTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.report_ids is not None:
            result['ReportIds'] = self.report_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ReportIds') is not None:
            self.report_ids = m.get('ReportIds')
        return self


class CreateDcdnSubTaskResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDcdnSubTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDcdnSubTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDcdnSubTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDcdnSubTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDcdnSubTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDcdnWafPolicyRequest(TeaModel):
    def __init__(self, defense_scene=None, policy_name=None, policy_status=None, policy_type=None):
        # The type of the WAF protection policy. Valid values:
        # 
        # *   waf_group: basic web protection
        # *   custom_acl: custom protection
        # *   whitelist: IP address whitelist
        # *   ip_blacklist: IP address blacklist
        # *   region_block: region blacklist
        # *   bot: bot management
        self.defense_scene = defense_scene  # type: str
        # The name of the protection policy. The name can be up to 64 characters in length and can contain letters, digits, and underscores (\_).
        self.policy_name = policy_name  # type: str
        # The status of the protection policy. Valid values:
        # 
        # *   on: enabled
        # *   off: disabled
        self.policy_status = policy_status  # type: str
        # Specifies whether to set the current policy as the default policy. Valid values:
        # 
        # *   default: sets the current policy as the default policy.
        # *   custom: does not set the current policy as the default policy.
        self.policy_type = policy_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDcdnWafPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defense_scene is not None:
            result['DefenseScene'] = self.defense_scene
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.policy_status is not None:
            result['PolicyStatus'] = self.policy_status
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenseScene') is not None:
            self.defense_scene = m.get('DefenseScene')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('PolicyStatus') is not None:
            self.policy_status = m.get('PolicyStatus')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        return self


class CreateDcdnWafPolicyResponseBody(TeaModel):
    def __init__(self, policy_id=None, request_id=None):
        # The ID of the protection policy that you created.
        self.policy_id = policy_id  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDcdnWafPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDcdnWafPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDcdnWafPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDcdnWafPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDcdnWafPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRoutineRequest(TeaModel):
    def __init__(self, description=None, env_conf=None, name=None):
        # The description of the routine.
        self.description = description  # type: str
        # The configurations of the specified environment.
        self.env_conf = env_conf  # type: dict[str, any]
        # The name of the routine. The name must be unique among the routines that belong to the same Alibaba Cloud account.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRoutineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateRoutineShrinkRequest(TeaModel):
    def __init__(self, description=None, env_conf_shrink=None, name=None):
        # The description of the routine.
        self.description = description  # type: str
        # The configurations of the specified environment.
        self.env_conf_shrink = env_conf_shrink  # type: str
        # The name of the routine. The name must be unique among the routines that belong to the same Alibaba Cloud account.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRoutineShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.env_conf_shrink is not None:
            result['EnvConf'] = self.env_conf_shrink
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnvConf') is not None:
            self.env_conf_shrink = m.get('EnvConf')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateRoutineResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The message returned, such as ""Status": "OK"".
        self.content = content  # type: dict[str, any]
        # The ID of the region.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRoutineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRoutineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateRoutineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateRoutineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRoutineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSlrAndSlsProjectRequest(TeaModel):
    def __init__(self, business_type=None, region=None):
        # The type of the collected logs. Default value: cdn_log_access_l1. Valid values:
        # 
        # *   **cdn_log_access_l1**: access logs of L1 Dynamic Route for CDN (DCDN) points of presence (POPs)
        # *   **cdn_log_origin**: back-to-origin logs
        # *   **cdn_log_er**: EdgeRoutine logs
        self.business_type = business_type  # type: str
        # The region where Log Service resides. Valid values:
        # 
        # *   **cn-hangzhou**\
        # *   **cn-shanghai**\
        # *   **cn-qingdao**\
        # *   **cn-beijing**\
        # *   **cn-zhangjiakou**\
        # *   **cn-shenzhen**\
        # *   **eu-central-1**\
        # *   **us-west-1**\
        # *   **ap-south-1**\
        # *   **ap-southeast-1**\
        self.region = region  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSlrAndSlsProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class CreateSlrAndSlsProjectResponseBodySlsInfo(TeaModel):
    def __init__(self, end_point=None, log_store=None, project=None, region=None):
        # The endpoint of Log Service.
        self.end_point = end_point  # type: str
        # The Logstore of Log Service.
        self.log_store = log_store  # type: str
        # The project of Log Service.
        self.project = project  # type: str
        # The region where Log Service resides.
        self.region = region  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSlrAndSlsProjectResponseBodySlsInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_point is not None:
            result['EndPoint'] = self.end_point
        if self.log_store is not None:
            result['LogStore'] = self.log_store
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndPoint') is not None:
            self.end_point = m.get('EndPoint')
        if m.get('LogStore') is not None:
            self.log_store = m.get('LogStore')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class CreateSlrAndSlsProjectResponseBody(TeaModel):
    def __init__(self, request_id=None, sls_info=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about Log Service.
        self.sls_info = sls_info  # type: CreateSlrAndSlsProjectResponseBodySlsInfo

    def validate(self):
        if self.sls_info:
            self.sls_info.validate()

    def to_map(self):
        _map = super(CreateSlrAndSlsProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sls_info is not None:
            result['SlsInfo'] = self.sls_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SlsInfo') is not None:
            temp_model = CreateSlrAndSlsProjectResponseBodySlsInfo()
            self.sls_info = temp_model.from_map(m['SlsInfo'])
        return self


class CreateSlrAndSlsProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSlrAndSlsProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSlrAndSlsProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSlrAndSlsProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDcdnDeliverTaskRequest(TeaModel):
    def __init__(self, deliver_id=None):
        # The IDs of the tracking tasks that you want to delete. You can call the [DescribeCdnDeliverList](~~270043~~) operation to query task IDs.
        self.deliver_id = deliver_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnDeliverTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deliver_id is not None:
            result['DeliverId'] = self.deliver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeliverId') is not None:
            self.deliver_id = m.get('DeliverId')
        return self


class DeleteDcdnDeliverTaskResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnDeliverTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDcdnDeliverTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDcdnDeliverTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDcdnDeliverTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDcdnDeliverTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDcdnDomainRequest(TeaModel):
    def __init__(self, domain_name=None, owner_account=None, owner_id=None, security_token=None):
        # The accelerated domain name to be deleted. You can specify only one domain name.
        self.domain_name = domain_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteDcdnDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDcdnDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDcdnDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDcdnDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDcdnDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDcdnIpaDomainRequest(TeaModel):
    def __init__(self, domain_name=None, owner_account=None, owner_id=None, security_token=None):
        # The name of the accelerated domain name to be deleted. You can specify only one domain name.
        self.domain_name = domain_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnIpaDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteDcdnIpaDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnIpaDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDcdnIpaDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDcdnIpaDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDcdnIpaDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDcdnIpaDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDcdnIpaSpecificConfigRequest(TeaModel):
    def __init__(self, config_id=None, domain_name=None, owner_id=None, security_token=None):
        # The ID of the configuration. You can call the [DescribeDcdnDomainConfigs](~~130625~~) operation to query configuration IDs.
        self.config_id = config_id  # type: str
        # The accelerated domain name. You can specify only one domain name in each call.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnIpaSpecificConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteDcdnIpaSpecificConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnIpaSpecificConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDcdnIpaSpecificConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDcdnIpaSpecificConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDcdnIpaSpecificConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDcdnIpaSpecificConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDcdnKvRequest(TeaModel):
    def __init__(self, key=None, namespace=None):
        # The name of the key that you want to delete.
        self.key = key  # type: str
        # The namespace that you specify when you call the PutDcdnKvNamespace operation.
        self.namespace = namespace  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnKvRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class DeleteDcdnKvResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnKvResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDcdnKvResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDcdnKvResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDcdnKvResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDcdnKvResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDcdnRealTimeLogProjectRequest(TeaModel):
    def __init__(self, project_name=None):
        # The name of a real-time log delivery project.
        self.project_name = project_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnRealTimeLogProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class DeleteDcdnRealTimeLogProjectResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnRealTimeLogProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDcdnRealTimeLogProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDcdnRealTimeLogProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDcdnRealTimeLogProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDcdnRealTimeLogProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDcdnSpecificConfigRequest(TeaModel):
    def __init__(self, config_id=None, domain_name=None, owner_id=None, security_token=None):
        # The ID of the configuration. Separate multiple configuration IDs with commas (,). For more information about ConfigId, see [Usage notes on ConfigId](~~410558~~).
        self.config_id = config_id  # type: str
        # The accelerated domain name. You can specify only one domain name.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnSpecificConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteDcdnSpecificConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnSpecificConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDcdnSpecificConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDcdnSpecificConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDcdnSpecificConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDcdnSpecificConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDcdnSpecificStagingConfigRequest(TeaModel):
    def __init__(self, config_id=None, domain_name=None, owner_id=None, security_token=None):
        # The ID of the configuration to be deleted. You can specify multiple configuration IDs and separate them with commas (,).
        # 
        # You can call the DescribeDcdnDomainStagingConfig operation to query the environment configuration.
        self.config_id = config_id  # type: str
        # The name of the accelerated domain. You can specify only one domain name.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnSpecificStagingConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteDcdnSpecificStagingConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnSpecificStagingConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDcdnSpecificStagingConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDcdnSpecificStagingConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDcdnSpecificStagingConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDcdnSpecificStagingConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDcdnSubTaskResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnSubTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDcdnSubTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDcdnSubTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDcdnSubTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDcdnSubTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDcdnWafPolicyRequest(TeaModel):
    def __init__(self, policy_id=None):
        # The ID of the protection policy that you want to delete. You can specify only one ID in each request.
        self.policy_id = policy_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnWafPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        return self


class DeleteDcdnWafPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDcdnWafPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDcdnWafPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDcdnWafPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDcdnWafPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDcdnWafPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRoutineRequest(TeaModel):
    def __init__(self, name=None):
        # The name of the routine. The name must be unique among the routines that belong to the same Alibaba Cloud account.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRoutineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DeleteRoutineResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # Returns ""Status": "OK"".
        self.content = content  # type: dict[str, any]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRoutineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRoutineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteRoutineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRoutineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRoutineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRoutineCodeRevisionRequest(TeaModel):
    def __init__(self, name=None, select_code_revision=None):
        # The name of the routine. The name must be unique among the routines that belong to the same Alibaba Cloud account.
        self.name = name  # type: str
        # The number of the version that you want to delete.
        self.select_code_revision = select_code_revision  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRoutineCodeRevisionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.select_code_revision is not None:
            result['SelectCodeRevision'] = self.select_code_revision
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SelectCodeRevision') is not None:
            self.select_code_revision = m.get('SelectCodeRevision')
        return self


class DeleteRoutineCodeRevisionResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # Returns “"Status": "OK"".
        self.content = content  # type: dict[str, any]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRoutineCodeRevisionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRoutineCodeRevisionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteRoutineCodeRevisionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRoutineCodeRevisionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRoutineCodeRevisionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRoutineConfEnvsRequest(TeaModel):
    def __init__(self, envs=None, name=None):
        # The custom canary release environments that you want to delete.
        self.envs = envs  # type: dict[str, any]
        # The name of the routine. The name must be unique among the routines that belong to the same Alibaba Cloud account.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRoutineConfEnvsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.envs is not None:
            result['Envs'] = self.envs
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Envs') is not None:
            self.envs = m.get('Envs')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DeleteRoutineConfEnvsShrinkRequest(TeaModel):
    def __init__(self, envs_shrink=None, name=None):
        # The custom canary release environments that you want to delete.
        self.envs_shrink = envs_shrink  # type: str
        # The name of the routine. The name must be unique among the routines that belong to the same Alibaba Cloud account.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRoutineConfEnvsShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.envs_shrink is not None:
            result['Envs'] = self.envs_shrink
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Envs') is not None:
            self.envs_shrink = m.get('Envs')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DeleteRoutineConfEnvsResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The message returned, such as ""Status": "OK"".
        self.content = content  # type: dict[str, any]
        # The ID of the region.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRoutineConfEnvsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRoutineConfEnvsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteRoutineConfEnvsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRoutineConfEnvsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRoutineConfEnvsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnAclFieldsRequest(TeaModel):
    def __init__(self, lang=None):
        # The access language. Default value: en. Valid values:
        # 
        # *   **en**: English
        # *   **zh**: Chinese
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnAclFieldsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeDcdnAclFieldsResponseBodyContent(TeaModel):
    def __init__(self, fields=None):
        # The rules and policies that were configured. The JSON string must be decoded.
        self.fields = fields  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnAclFieldsResponseBodyContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fields is not None:
            result['Fields'] = self.fields
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Fields') is not None:
            self.fields = m.get('Fields')
        return self


class DescribeDcdnAclFieldsResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The details about the rules.
        self.content = content  # type: list[DescribeDcdnAclFieldsResponseBodyContent]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnAclFieldsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Content'] = []
        if self.content is not None:
            for k in self.content:
                result['Content'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.content = []
        if m.get('Content') is not None:
            for k in m.get('Content'):
                temp_model = DescribeDcdnAclFieldsResponseBodyContent()
                self.content.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnAclFieldsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnAclFieldsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnAclFieldsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnAclFieldsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnBgpBpsDataRequest(TeaModel):
    def __init__(self, device_name=None, device_port=None, end_time=None, interval=None, isp=None, start_time=None):
        # The name of the device. If you specify this parameter, the data of the device is returned. Otherwise, the data of all devices is returned.
        self.device_name = device_name  # type: str
        # The port of the device. If you specify this parameter, the data of the port is returned. Otherwise, the data of all ports is returned. This parameter takes effect only when the **DeviceName** parameter is specified.
        self.device_port = device_port  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The data collection interval. Unit: seconds. Valid values: 300 and 3600. Default value: 300. The default value of 300 seconds is equal to 5 minutes. The value of this parameter varies based on the time range from the specified start time to the specified end time.
        self.interval = interval  # type: str
        # The ISPs. If you need to specify multiple ISPs, separate them with commas (,). If you specify multiple ISPs, the data for the ISPs is aggregated. If you do not specify this parameter, the operation returns the data for all the ISPs.
        # 
        # Valid values:
        # 
        # *   cu: China Unicom
        # *   cmi: China Mobile
        # *   ct: China Telecom
        self.isp = isp  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The minimum data collection interval is an hour.
        # 
        # If you do not set this parameter, data collected in the last 24 hours is queried.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnBgpBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_port is not None:
            result['DevicePort'] = self.device_port
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DevicePort') is not None:
            self.device_port = m.get('DevicePort')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnBgpBpsDataResponseBodyBgpDataInterval(TeaModel):
    def __init__(self, in_=None, out=None, time_stamp=None):
        # The inbound bandwidth. Unit: bit/s.
        self.in_ = in_  # type: float
        # The outbound bandwidth. Unit: bit/s.
        self.out = out  # type: float
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnBgpBpsDataResponseBodyBgpDataInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.in_ is not None:
            result['In'] = self.in_
        if self.out is not None:
            result['Out'] = self.out
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnBgpBpsDataResponseBody(TeaModel):
    def __init__(self, bgp_data_interval=None, end_time=None, request_id=None, start_time=None):
        # The BGP bandwidth data that is collected for each interval.
        self.bgp_data_interval = bgp_data_interval  # type: list[DescribeDcdnBgpBpsDataResponseBodyBgpDataInterval]
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The start of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.bgp_data_interval:
            for k in self.bgp_data_interval:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnBgpBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BgpDataInterval'] = []
        if self.bgp_data_interval is not None:
            for k in self.bgp_data_interval:
                result['BgpDataInterval'].append(k.to_map() if k else None)
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bgp_data_interval = []
        if m.get('BgpDataInterval') is not None:
            for k in m.get('BgpDataInterval'):
                temp_model = DescribeDcdnBgpBpsDataResponseBodyBgpDataInterval()
                self.bgp_data_interval.append(temp_model.from_map(k))
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnBgpBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnBgpBpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnBgpBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnBgpBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnBgpTrafficDataRequest(TeaModel):
    def __init__(self, end_time=None, interval=None, isp=None, start_time=None):
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The data collection interval. Unit: seconds. Valid values: 300 and 3600. Default value: 300. The default value of 300 seconds is equal to 5 minutes. The value of this parameter varies based on the time range from the specified start time to the specified end time.
        self.interval = interval  # type: str
        # The ISPs. If you need to specify multiple ISPs, separate them with commas (,). If you specify multiple ISPs, the data for the ISPs is aggregated. If you do not specify this parameter, the operation returns the data for all the ISPs.
        # 
        # Valid values:
        # 
        # *   cu: China Unicom
        # *   cmi: China Mobile
        # *   ct: China Telecom
        self.isp = isp  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The minimum data collection interval is an hour.
        # 
        # If you do not set this parameter, data collected in the last 24 hours is queried.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnBgpTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnBgpTrafficDataResponseBodyBgpDataInterval(TeaModel):
    def __init__(self, in_=None, out=None, time_stamp=None):
        # The inbound traffic. Unit: bytes.
        self.in_ = in_  # type: long
        # The outbound traffic. Unit: bytes.
        self.out = out  # type: long
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnBgpTrafficDataResponseBodyBgpDataInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.in_ is not None:
            result['In'] = self.in_
        if self.out is not None:
            result['Out'] = self.out
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('In') is not None:
            self.in_ = m.get('In')
        if m.get('Out') is not None:
            self.out = m.get('Out')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnBgpTrafficDataResponseBody(TeaModel):
    def __init__(self, bgp_data_interval=None, end_time=None, request_id=None, start_time=None):
        # The BGP traffic data that is collected for each interval.
        self.bgp_data_interval = bgp_data_interval  # type: list[DescribeDcdnBgpTrafficDataResponseBodyBgpDataInterval]
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The start of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.bgp_data_interval:
            for k in self.bgp_data_interval:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnBgpTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BgpDataInterval'] = []
        if self.bgp_data_interval is not None:
            for k in self.bgp_data_interval:
                result['BgpDataInterval'].append(k.to_map() if k else None)
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bgp_data_interval = []
        if m.get('BgpDataInterval') is not None:
            for k in m.get('BgpDataInterval'):
                temp_model = DescribeDcdnBgpTrafficDataResponseBodyBgpDataInterval()
                self.bgp_data_interval.append(temp_model.from_map(k))
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnBgpTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnBgpTrafficDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnBgpTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnBgpTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnBlockedRegionsRequest(TeaModel):
    def __init__(self, language=None):
        # The language. Valid values: zh, en, and jp.
        self.language = language  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnBlockedRegionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.language is not None:
            result['Language'] = self.language
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Language') is not None:
            self.language = m.get('Language')
        return self


class DescribeDcdnBlockedRegionsResponseBodyInfoListInfoItem(TeaModel):
    def __init__(self, continent=None, countries_and_regions=None, countries_and_regions_name=None):
        # The district to which the country or region belongs.
        self.continent = continent  # type: str
        # The abbreviation of the name of the country or region.
        self.countries_and_regions = countries_and_regions  # type: str
        # The name of the country or region.
        self.countries_and_regions_name = countries_and_regions_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnBlockedRegionsResponseBodyInfoListInfoItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.continent is not None:
            result['Continent'] = self.continent
        if self.countries_and_regions is not None:
            result['CountriesAndRegions'] = self.countries_and_regions
        if self.countries_and_regions_name is not None:
            result['CountriesAndRegionsName'] = self.countries_and_regions_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Continent') is not None:
            self.continent = m.get('Continent')
        if m.get('CountriesAndRegions') is not None:
            self.countries_and_regions = m.get('CountriesAndRegions')
        if m.get('CountriesAndRegionsName') is not None:
            self.countries_and_regions_name = m.get('CountriesAndRegionsName')
        return self


class DescribeDcdnBlockedRegionsResponseBodyInfoList(TeaModel):
    def __init__(self, info_item=None):
        self.info_item = info_item  # type: list[DescribeDcdnBlockedRegionsResponseBodyInfoListInfoItem]

    def validate(self):
        if self.info_item:
            for k in self.info_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnBlockedRegionsResponseBodyInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InfoItem'] = []
        if self.info_item is not None:
            for k in self.info_item:
                result['InfoItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.info_item = []
        if m.get('InfoItem') is not None:
            for k in m.get('InfoItem'):
                temp_model = DescribeDcdnBlockedRegionsResponseBodyInfoListInfoItem()
                self.info_item.append(temp_model.from_map(k))
        return self


class DescribeDcdnBlockedRegionsResponseBody(TeaModel):
    def __init__(self, info_list=None, request_id=None):
        # The information about the country or region.
        self.info_list = info_list  # type: DescribeDcdnBlockedRegionsResponseBodyInfoList
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.info_list:
            self.info_list.validate()

    def to_map(self):
        _map = super(DescribeDcdnBlockedRegionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info_list is not None:
            result['InfoList'] = self.info_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InfoList') is not None:
            temp_model = DescribeDcdnBlockedRegionsResponseBodyInfoList()
            self.info_list = temp_model.from_map(m['InfoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnBlockedRegionsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnBlockedRegionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnBlockedRegionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnBlockedRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnCertificateDetailRequest(TeaModel):
    def __init__(self, cert_name=None, owner_id=None, security_token=None):
        # The name of the certificate.
        self.cert_name = cert_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnCertificateDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnCertificateDetailResponseBody(TeaModel):
    def __init__(self, cert=None, cert_id=None, cert_name=None, key=None, request_id=None):
        # The content of the certificate.
        self.cert = cert  # type: str
        # The ID of the certificate.
        self.cert_id = cert_id  # type: long
        # The name of the certificate.
        self.cert_name = cert_name  # type: str
        # The key of the certificate.
        self.key = key  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnCertificateDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert is not None:
            result['Cert'] = self.cert
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.key is not None:
            result['Key'] = self.key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cert') is not None:
            self.cert = m.get('Cert')
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnCertificateDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnCertificateDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnCertificateDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnCertificateDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnCertificateListRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        # The accelerated domain name. If you need to specify multiple accelerated domain names, separate them with commas (,).
        # 
        # By default, this operation queries the certificates of all accelerated domain names.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnCertificateListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnCertificateListResponseBodyCertificateListModelCertListCert(TeaModel):
    def __init__(self, cert_id=None, cert_name=None, common=None, fingerprint=None, issuer=None, last_time=None):
        # The ID of the certificate.
        self.cert_id = cert_id  # type: long
        # The name of the certificate.
        self.cert_name = cert_name  # type: str
        # The Common Name (CN) attribute of the certificate. In most cases, the CN is a domain name.
        self.common = common  # type: str
        # The fingerprint of the certificate.
        self.fingerprint = fingerprint  # type: str
        # The certificate authority (CA) that issued the certificate.
        self.issuer = issuer  # type: str
        # The timestamp.
        self.last_time = last_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnCertificateListResponseBodyCertificateListModelCertListCert, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.common is not None:
            result['Common'] = self.common
        if self.fingerprint is not None:
            result['Fingerprint'] = self.fingerprint
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Common') is not None:
            self.common = m.get('Common')
        if m.get('Fingerprint') is not None:
            self.fingerprint = m.get('Fingerprint')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        return self


class DescribeDcdnCertificateListResponseBodyCertificateListModelCertList(TeaModel):
    def __init__(self, cert=None):
        self.cert = cert  # type: list[DescribeDcdnCertificateListResponseBodyCertificateListModelCertListCert]

    def validate(self):
        if self.cert:
            for k in self.cert:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnCertificateListResponseBodyCertificateListModelCertList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Cert'] = []
        if self.cert is not None:
            for k in self.cert:
                result['Cert'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cert = []
        if m.get('Cert') is not None:
            for k in m.get('Cert'):
                temp_model = DescribeDcdnCertificateListResponseBodyCertificateListModelCertListCert()
                self.cert.append(temp_model.from_map(k))
        return self


class DescribeDcdnCertificateListResponseBodyCertificateListModel(TeaModel):
    def __init__(self, cert_list=None, count=None):
        # Details about each certificate.
        self.cert_list = cert_list  # type: DescribeDcdnCertificateListResponseBodyCertificateListModelCertList
        # The number of certificates.
        self.count = count  # type: int

    def validate(self):
        if self.cert_list:
            self.cert_list.validate()

    def to_map(self):
        _map = super(DescribeDcdnCertificateListResponseBodyCertificateListModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_list is not None:
            result['CertList'] = self.cert_list.to_map()
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertList') is not None:
            temp_model = DescribeDcdnCertificateListResponseBodyCertificateListModelCertList()
            self.cert_list = temp_model.from_map(m['CertList'])
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeDcdnCertificateListResponseBody(TeaModel):
    def __init__(self, certificate_list_model=None, request_id=None):
        # Details about certificates.
        self.certificate_list_model = certificate_list_model  # type: DescribeDcdnCertificateListResponseBodyCertificateListModel
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.certificate_list_model:
            self.certificate_list_model.validate()

    def to_map(self):
        _map = super(DescribeDcdnCertificateListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.certificate_list_model is not None:
            result['CertificateListModel'] = self.certificate_list_model.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertificateListModel') is not None:
            temp_model = DescribeDcdnCertificateListResponseBodyCertificateListModel()
            self.certificate_list_model = temp_model.from_map(m['CertificateListModel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnCertificateListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnCertificateListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnCertificateListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnCertificateListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDeletedDomainsRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None):
        # The number of the page to return. Valid values: **1** to **100000**. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of domain names to return per page. Valid values: an integer between **1** and **500**. Default value: **20**.
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDeletedDomainsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDcdnDeletedDomainsResponseBodyDomainsPageData(TeaModel):
    def __init__(self, domain_name=None, gmt_modified=None):
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The time when the accelerated domain name was last modified. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC+0.
        self.gmt_modified = gmt_modified  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDeletedDomainsResponseBodyDomainsPageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class DescribeDcdnDeletedDomainsResponseBodyDomains(TeaModel):
    def __init__(self, page_data=None):
        self.page_data = page_data  # type: list[DescribeDcdnDeletedDomainsResponseBodyDomainsPageData]

    def validate(self):
        if self.page_data:
            for k in self.page_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDeletedDomainsResponseBodyDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PageData'] = []
        if self.page_data is not None:
            for k in self.page_data:
                result['PageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.page_data = []
        if m.get('PageData') is not None:
            for k in m.get('PageData'):
                temp_model = DescribeDcdnDeletedDomainsResponseBodyDomainsPageData()
                self.page_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnDeletedDomainsResponseBody(TeaModel):
    def __init__(self, domains=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The list of accelerated domain names and the time each domain name was last modified.
        self.domains = domains  # type: DescribeDcdnDeletedDomainsResponseBodyDomains
        # The page number of the returned page, which is the same as the **PageNumber** parameter in request parameters.
        self.page_number = page_number  # type: long
        # The number of domain names returned per page, which is the same as the **PageSize** parameter in request parameters.
        self.page_size = page_size  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of domain names returned.
        self.total_count = total_count  # type: long

    def validate(self):
        if self.domains:
            self.domains.validate()

    def to_map(self):
        _map = super(DescribeDcdnDeletedDomainsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['Domains'] = self.domains.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Domains') is not None:
            temp_model = DescribeDcdnDeletedDomainsResponseBodyDomains()
            self.domains = temp_model.from_map(m['Domains'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnDeletedDomainsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDeletedDomainsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDeletedDomainsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDeletedDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDeliverListRequest(TeaModel):
    def __init__(self, deliver_id=None):
        # The ID of the tracking task that you want to query. If you do not specify an ID, all tracking tasks are queried.
        self.deliver_id = deliver_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDeliverListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deliver_id is not None:
            result['DeliverId'] = self.deliver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeliverId') is not None:
            self.deliver_id = m.get('DeliverId')
        return self


class DescribeDcdnDeliverListResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The information about the tracking task.
        self.content = content  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDeliverListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDeliverListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDeliverListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDeliverListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDeliverListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 start_time=None):
        # The accelerated domain name.
        # 
        # Separate multiple domain names with commas (,). If you do not specify a value for this parameter, bandwidth data of all accelerated domain names is queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # > The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time granularity for a query. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Usage notes**.
        self.interval = interval  # type: str
        # The name of the Internet service provider (ISP).
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainBpsDataResponseBodyBpsDataPerIntervalDataModule(TeaModel):
    def __init__(self, bps=None, dynamic_http_bps=None, dynamic_https_bps=None, static_http_bps=None,
                 static_https_bps=None, time_stamp=None):
        # The bandwidth value. Unit: bit/s.
        self.bps = bps  # type: float
        # The bandwidth that was consumed to deliver dynamic content over HTTP, in bit/s.
        self.dynamic_http_bps = dynamic_http_bps  # type: float
        # The bandwidth that was consumed to deliver dynamic content over HTTPS, in bit/s.
        self.dynamic_https_bps = dynamic_https_bps  # type: float
        # The bandwidth that was consumed to deliver static content over HTTP, in bit/s.
        self.static_http_bps = static_http_bps  # type: float
        # The bandwidth that was consumed to deliver static content over HTTPS, in bit/s.
        self.static_https_bps = static_https_bps  # type: float
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainBpsDataResponseBodyBpsDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps is not None:
            result['Bps'] = self.bps
        if self.dynamic_http_bps is not None:
            result['DynamicHttpBps'] = self.dynamic_http_bps
        if self.dynamic_https_bps is not None:
            result['DynamicHttpsBps'] = self.dynamic_https_bps
        if self.static_http_bps is not None:
            result['StaticHttpBps'] = self.static_http_bps
        if self.static_https_bps is not None:
            result['StaticHttpsBps'] = self.static_https_bps
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bps') is not None:
            self.bps = m.get('Bps')
        if m.get('DynamicHttpBps') is not None:
            self.dynamic_http_bps = m.get('DynamicHttpBps')
        if m.get('DynamicHttpsBps') is not None:
            self.dynamic_https_bps = m.get('DynamicHttpsBps')
        if m.get('StaticHttpBps') is not None:
            self.static_http_bps = m.get('StaticHttpBps')
        if m.get('StaticHttpsBps') is not None:
            self.static_https_bps = m.get('StaticHttpsBps')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainBpsDataResponseBodyBpsDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainBpsDataResponseBodyBpsDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainBpsDataResponseBodyBpsDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainBpsDataResponseBodyBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainBpsDataResponseBody(TeaModel):
    def __init__(self, bps_data_per_interval=None, data_interval=None, domain_name=None, end_time=None,
                 request_id=None, start_time=None):
        # The bandwidth data returned at each interval.
        self.bps_data_per_interval = bps_data_per_interval  # type: DescribeDcdnDomainBpsDataResponseBodyBpsDataPerInterval
        # The time interval between the data entries returned.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The start of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.bps_data_per_interval:
            self.bps_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps_data_per_interval is not None:
            result['BpsDataPerInterval'] = self.bps_data_per_interval.to_map()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BpsDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainBpsDataResponseBodyBpsDataPerInterval()
            self.bps_data_per_interval = temp_model.from_map(m['BpsDataPerInterval'])
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainBpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainBpsDataByLayerRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, layer=None,
                 location_name_en=None, start_time=None):
        # The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated.
        # 
        # If you do not specify a domain name, data of all domain names is queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time interval between the data entries to return. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Description**.
        self.interval = interval  # type: str
        # The name of the Internet service provider (ISP). You can call the DescribeDcdnRegionAndIsp operation to query the ISP name. If you do not specify a value for this parameter, all ISPs are queried.
        self.isp_name_en = isp_name_en  # type: str
        # The layer at which you want to query the bandwidth data. The network layer supports IPv4 and IPv6. The application layer supports http, https, and quic. You can also set the value to all.
        # 
        # Default value: all.
        self.layer = layer  # type: str
        # The name of the region. You can call the DescribeDcdnRegionAndIsp operation to query the region name. If you do not specify a value for this parameter, all regions are queried.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The minimum data granularity is 5 minutes.
        # 
        # If you do not set this parameter, data in the last 24 hours is queried.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainBpsDataByLayerRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainBpsDataByLayerResponseBodyBpsDataIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, traffic_value=None, value=None):
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str
        # The total amount of network traffic. Unit: bytes.
        self.traffic_value = traffic_value  # type: str
        # The total bandwidth. Unit: bit/s.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainBpsDataByLayerResponseBodyBpsDataIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.traffic_value is not None:
            result['TrafficValue'] = self.traffic_value
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('TrafficValue') is not None:
            self.traffic_value = m.get('TrafficValue')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnDomainBpsDataByLayerResponseBodyBpsDataInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainBpsDataByLayerResponseBodyBpsDataIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainBpsDataByLayerResponseBodyBpsDataInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainBpsDataByLayerResponseBodyBpsDataIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainBpsDataByLayerResponseBody(TeaModel):
    def __init__(self, bps_data_interval=None, data_interval=None, request_id=None):
        # The bandwidth returned at each time interval.
        self.bps_data_interval = bps_data_interval  # type: DescribeDcdnDomainBpsDataByLayerResponseBodyBpsDataInterval
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.bps_data_interval:
            self.bps_data_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainBpsDataByLayerResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps_data_interval is not None:
            result['BpsDataInterval'] = self.bps_data_interval.to_map()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BpsDataInterval') is not None:
            temp_model = DescribeDcdnDomainBpsDataByLayerResponseBodyBpsDataInterval()
            self.bps_data_interval = temp_model.from_map(m['BpsDataInterval'])
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainBpsDataByLayerResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainBpsDataByLayerResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainBpsDataByLayerResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainBpsDataByLayerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainByCertificateRequest(TeaModel):
    def __init__(self, sslpub=None, sslstatus=None):
        # The public key of the certificate.
        # 
        # You must use Base64 encoding schemes and then the encodeURIComponent method to encode the public key. PEM files are supported.
        self.sslpub = sslpub  # type: str
        # Indicates the returned domain name list contains only domain names with HTTPS enabled or disabled.
        # 
        # *   true: The list contains only domain names with HTTPS enabled.
        # *   false: The list contains only domain names with HTTPS disabled..
        self.sslstatus = sslstatus  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainByCertificateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sslpub is not None:
            result['SSLPub'] = self.sslpub
        if self.sslstatus is not None:
            result['SSLStatus'] = self.sslstatus
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SSLPub') is not None:
            self.sslpub = m.get('SSLPub')
        if m.get('SSLStatus') is not None:
            self.sslstatus = m.get('SSLStatus')
        return self


class DescribeDcdnDomainByCertificateResponseBodyCertInfosCertInfo(TeaModel):
    def __init__(self, cert_ca_is_legacy=None, cert_expire_time=None, cert_expired=None, cert_start_time=None,
                 cert_subject_common_name=None, cert_type=None, domain_list=None, domain_names=None, issuer=None):
        # Indicates whether the CA certificate has been revoked. Valid values:
        # 
        # *   **yes**: The certificate has been revoked.
        # *   **no**: The certificate is normal.
        self.cert_ca_is_legacy = cert_ca_is_legacy  # type: str
        # The time when the certificate expires.
        self.cert_expire_time = cert_expire_time  # type: str
        # Indicates whether the certificate is expired. Valid values:
        # 
        # *   **yes**: The certificate is expired.
        # *   **no**: The certificate is not expired.
        self.cert_expired = cert_expired  # type: str
        # The time at which the certificate started to take effect.
        self.cert_start_time = cert_start_time  # type: str
        # The name of the SSL certificate owner.
        self.cert_subject_common_name = cert_subject_common_name  # type: str
        # The type of the certificate. **RSA**, **DSA**, and **ECDSA**.
        self.cert_type = cert_type  # type: str
        # The list of domain names that use the certificate.
        # 
        # If one or more domain names are returned, the domain names are matched with the specified certificate. Multiple domain names are separated with commas (,).
        self.domain_list = domain_list  # type: str
        # The domain names (DNS fields) that match the certificate. Multiple domain names are separated with commas (,).
        self.domain_names = domain_names  # type: str
        # The certificate authority CA that issued the certificate.
        self.issuer = issuer  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainByCertificateResponseBodyCertInfosCertInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_ca_is_legacy is not None:
            result['CertCaIsLegacy'] = self.cert_ca_is_legacy
        if self.cert_expire_time is not None:
            result['CertExpireTime'] = self.cert_expire_time
        if self.cert_expired is not None:
            result['CertExpired'] = self.cert_expired
        if self.cert_start_time is not None:
            result['CertStartTime'] = self.cert_start_time
        if self.cert_subject_common_name is not None:
            result['CertSubjectCommonName'] = self.cert_subject_common_name
        if self.cert_type is not None:
            result['CertType'] = self.cert_type
        if self.domain_list is not None:
            result['DomainList'] = self.domain_list
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertCaIsLegacy') is not None:
            self.cert_ca_is_legacy = m.get('CertCaIsLegacy')
        if m.get('CertExpireTime') is not None:
            self.cert_expire_time = m.get('CertExpireTime')
        if m.get('CertExpired') is not None:
            self.cert_expired = m.get('CertExpired')
        if m.get('CertStartTime') is not None:
            self.cert_start_time = m.get('CertStartTime')
        if m.get('CertSubjectCommonName') is not None:
            self.cert_subject_common_name = m.get('CertSubjectCommonName')
        if m.get('CertType') is not None:
            self.cert_type = m.get('CertType')
        if m.get('DomainList') is not None:
            self.domain_list = m.get('DomainList')
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        return self


class DescribeDcdnDomainByCertificateResponseBodyCertInfos(TeaModel):
    def __init__(self, cert_info=None):
        self.cert_info = cert_info  # type: list[DescribeDcdnDomainByCertificateResponseBodyCertInfosCertInfo]

    def validate(self):
        if self.cert_info:
            for k in self.cert_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainByCertificateResponseBodyCertInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CertInfo'] = []
        if self.cert_info is not None:
            for k in self.cert_info:
                result['CertInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cert_info = []
        if m.get('CertInfo') is not None:
            for k in m.get('CertInfo'):
                temp_model = DescribeDcdnDomainByCertificateResponseBodyCertInfosCertInfo()
                self.cert_info.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainByCertificateResponseBody(TeaModel):
    def __init__(self, cert_infos=None, request_id=None):
        # The certificate information of the domain name.
        self.cert_infos = cert_infos  # type: DescribeDcdnDomainByCertificateResponseBodyCertInfos
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.cert_infos:
            self.cert_infos.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainByCertificateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_infos is not None:
            result['CertInfos'] = self.cert_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertInfos') is not None:
            temp_model = DescribeDcdnDomainByCertificateResponseBodyCertInfos()
            self.cert_infos = temp_model.from_map(m['CertInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainByCertificateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainByCertificateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainByCertificateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainByCertificateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainCcActivityLogRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, page_number=None, page_size=None, rule_name=None,
                 start_time=None, trigger_object=None, value=None):
        # The accelerated domain name. You can specify one or more domain names. Separate multiple domain names with commas (,).
        # 
        # If you leave this parameter empty, the data of all domain names is queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: long
        # The number of entries to return on each page. Default value: **30**.
        self.page_size = page_size  # type: long
        # The name of the rule. Valid values
        # 
        # *   default_normal in normal mode
        # *   default_attack in emergency mode
        # *   A custom rule name in custom mode. Example: test2.
        # 
        # If you leave this parameter empty, all events that triggered rate limiting are queried.
        self.rule_name = rule_name  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The resolution of the queried data is 5 minutes.
        # 
        # If you leave this parameter empty, the data collected over the last 24 hours is queried.
        self.start_time = start_time  # type: str
        # The object that triggered rate limiting.
        # 
        # If you leave this parameter empty, all events that triggered rate limiting are queried.
        self.trigger_object = trigger_object  # type: str
        # The value of the object that triggered rate limiting.
        # 
        # If you leave this parameter empty, all events that triggered rate limiting are queried.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainCcActivityLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.trigger_object is not None:
            result['TriggerObject'] = self.trigger_object
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TriggerObject') is not None:
            self.trigger_object = m.get('TriggerObject')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnDomainCcActivityLogResponseBodyActivityLog(TeaModel):
    def __init__(self, action=None, domain_name=None, rule_name=None, time_stamp=None, trigger_object=None, ttl=None,
                 value=None):
        # The action that was triggered.
        self.action = action  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The name of the rule that was triggered.
        self.rule_name = rule_name  # type: str
        # The timestamp of the data.
        self.time_stamp = time_stamp  # type: str
        # The object that triggered rate limiting.
        self.trigger_object = trigger_object  # type: str
        # The period of time during which rate limiting remains effective.
        self.ttl = ttl  # type: long
        # The value of the object that triggered rate limiting.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainCcActivityLogResponseBodyActivityLog, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.trigger_object is not None:
            result['TriggerObject'] = self.trigger_object
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('TriggerObject') is not None:
            self.trigger_object = m.get('TriggerObject')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnDomainCcActivityLogResponseBody(TeaModel):
    def __init__(self, activity_log=None, page_index=None, page_size=None, request_id=None, total=None):
        # The log data of the event that triggered rate limiting.
        self.activity_log = activity_log  # type: list[DescribeDcdnDomainCcActivityLogResponseBodyActivityLog]
        # The page number of the returned page.
        self.page_index = page_index  # type: long
        # The number of entries returned per page.
        self.page_size = page_size  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total = total  # type: long

    def validate(self):
        if self.activity_log:
            for k in self.activity_log:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainCcActivityLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ActivityLog'] = []
        if self.activity_log is not None:
            for k in self.activity_log:
                result['ActivityLog'].append(k.to_map() if k else None)
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.activity_log = []
        if m.get('ActivityLog') is not None:
            for k in m.get('ActivityLog'):
                temp_model = DescribeDcdnDomainCcActivityLogResponseBodyActivityLog()
                self.activity_log.append(temp_model.from_map(k))
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDcdnDomainCcActivityLogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainCcActivityLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainCcActivityLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainCcActivityLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainCertificateInfoRequest(TeaModel):
    def __init__(self, domain_name=None):
        # The accelerated domain name. You can specify only one domain name in each request.
        self.domain_name = domain_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainCertificateInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeDcdnDomainCertificateInfoResponseBodyCertInfosCertInfo(TeaModel):
    def __init__(self, cert_domain_name=None, cert_expire_time=None, cert_id=None, cert_life=None, cert_name=None,
                 cert_org=None, cert_region=None, cert_type=None, domain_name=None, sslprotocol=None, sslpub=None,
                 status=None):
        # The domain name that matches the certificate.
        self.cert_domain_name = cert_domain_name  # type: str
        # The expiration time of the certificate.
        self.cert_expire_time = cert_expire_time  # type: str
        self.cert_id = cert_id  # type: str
        # The validity period of the certificate. Unit: **months** or **years**.
        self.cert_life = cert_life  # type: str
        # The name of the certificate.
        self.cert_name = cert_name  # type: str
        # The certificate authority (CA) that issued the certificate.
        self.cert_org = cert_org  # type: str
        self.cert_region = cert_region  # type: str
        # The type of the certificate. Valid values:
        # 
        # *   **free**: a free certificate
        # *   **cas**: a certificate that is purchased from Alibaba Cloud SSL Certificates Service
        # *   **upload**: a certificate that is uploaded by the user
        self.cert_type = cert_type  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The status of HTTPS. Valid values:
        # 
        # *   **on**: enabled
        # *   **off**: disabled
        self.sslprotocol = sslprotocol  # type: str
        # The public key of the certificate.
        self.sslpub = sslpub  # type: str
        # The status of the certificate. Valid values:
        # 
        # *   **success**: The certificate has taken effect.
        # *   **checking**: The system is checking whether the domain name is using Dynamic Route for CDN (DCDN).
        # *   **cname_error**: The domain name is not using DCDN.
        # *   **domain_invalid**: The domain name contains invalid characters.
        # *   **unsupport_wildcard**: The wildcard domain name is not supported.
        # *   **applying**: Certificate application is in progress.
        # *   **get_token_timeout**: The certificate application request has timed out.
        # *   **check_token_timeout**: The verification has timed out.
        # *   **get_cert_timeout**: The request to obtain the certificate has timed out.
        # *   **failed**: The certificate application request failed.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainCertificateInfoResponseBodyCertInfosCertInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_domain_name is not None:
            result['CertDomainName'] = self.cert_domain_name
        if self.cert_expire_time is not None:
            result['CertExpireTime'] = self.cert_expire_time
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.cert_life is not None:
            result['CertLife'] = self.cert_life
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cert_org is not None:
            result['CertOrg'] = self.cert_org
        if self.cert_region is not None:
            result['CertRegion'] = self.cert_region
        if self.cert_type is not None:
            result['CertType'] = self.cert_type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.sslpub is not None:
            result['SSLPub'] = self.sslpub
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertDomainName') is not None:
            self.cert_domain_name = m.get('CertDomainName')
        if m.get('CertExpireTime') is not None:
            self.cert_expire_time = m.get('CertExpireTime')
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('CertLife') is not None:
            self.cert_life = m.get('CertLife')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('CertOrg') is not None:
            self.cert_org = m.get('CertOrg')
        if m.get('CertRegion') is not None:
            self.cert_region = m.get('CertRegion')
        if m.get('CertType') is not None:
            self.cert_type = m.get('CertType')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('SSLPub') is not None:
            self.sslpub = m.get('SSLPub')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDcdnDomainCertificateInfoResponseBodyCertInfos(TeaModel):
    def __init__(self, cert_info=None):
        self.cert_info = cert_info  # type: list[DescribeDcdnDomainCertificateInfoResponseBodyCertInfosCertInfo]

    def validate(self):
        if self.cert_info:
            for k in self.cert_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainCertificateInfoResponseBodyCertInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CertInfo'] = []
        if self.cert_info is not None:
            for k in self.cert_info:
                result['CertInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cert_info = []
        if m.get('CertInfo') is not None:
            for k in m.get('CertInfo'):
                temp_model = DescribeDcdnDomainCertificateInfoResponseBodyCertInfosCertInfo()
                self.cert_info.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainCertificateInfoResponseBody(TeaModel):
    def __init__(self, cert_infos=None, request_id=None):
        # The certificate information of the domain name.
        self.cert_infos = cert_infos  # type: DescribeDcdnDomainCertificateInfoResponseBodyCertInfos
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.cert_infos:
            self.cert_infos.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainCertificateInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_infos is not None:
            result['CertInfos'] = self.cert_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertInfos') is not None:
            temp_model = DescribeDcdnDomainCertificateInfoResponseBodyCertInfos()
            self.cert_infos = temp_model.from_map(m['CertInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainCertificateInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainCertificateInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainCertificateInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainCertificateInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainCnameRequest(TeaModel):
    def __init__(self, domain_name=None):
        # The names of the accelerated domains. If you need to specify multiple accelerated domain names, separate them with commas (,).
        self.domain_name = domain_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainCnameRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeDcdnDomainCnameResponseBodyCnameDatasData(TeaModel):
    def __init__(self, cname=None, domain=None, status=None):
        # The CNAME.
        self.cname = cname  # type: str
        # The name of the accelerated domain returned.
        self.domain = domain  # type: str
        # The configuration status of the CNAME record. If the operations returns 0 for the parameter, the configuration was successful. Otherwise, the configuration failed.
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainCnameResponseBodyCnameDatasData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDcdnDomainCnameResponseBodyCnameDatas(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[DescribeDcdnDomainCnameResponseBodyCnameDatasData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainCnameResponseBodyCnameDatas, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeDcdnDomainCnameResponseBodyCnameDatasData()
                self.data.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainCnameResponseBody(TeaModel):
    def __init__(self, cname_datas=None, request_id=None):
        # The CNAME information.
        self.cname_datas = cname_datas  # type: DescribeDcdnDomainCnameResponseBodyCnameDatas
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.cname_datas:
            self.cname_datas.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainCnameResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cname_datas is not None:
            result['CnameDatas'] = self.cname_datas.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CnameDatas') is not None:
            temp_model = DescribeDcdnDomainCnameResponseBodyCnameDatas()
            self.cname_datas = temp_model.from_map(m['CnameDatas'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainCnameResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainCnameResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainCnameResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainCnameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainConfigsRequest(TeaModel):
    def __init__(self, config_id=None, domain_name=None, function_names=None, owner_id=None, security_token=None):
        # The ID of the configuration.
        self.config_id = config_id  # type: str
        # The accelerated domain name. You can specify only one domain name in each call.
        self.domain_name = domain_name  # type: str
        # The names of the features to query. Separate features with commas (,).
        self.function_names = function_names  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.function_names is not None:
            result['FunctionNames'] = self.function_names
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('FunctionNames') is not None:
            self.function_names = m.get('FunctionNames')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg(TeaModel):
    def __init__(self, arg_name=None, arg_value=None):
        # The name of the configuration.
        self.arg_name = arg_name  # type: str
        # The value of the configuration.
        self.arg_value = arg_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg_name is not None:
            result['ArgName'] = self.arg_name
        if self.arg_value is not None:
            result['ArgValue'] = self.arg_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArgName') is not None:
            self.arg_name = m.get('ArgName')
        if m.get('ArgValue') is not None:
            self.arg_value = m.get('ArgValue')
        return self


class DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs(TeaModel):
    def __init__(self, function_arg=None):
        self.function_arg = function_arg  # type: list[DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg]

    def validate(self):
        if self.function_arg:
            for k in self.function_arg:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FunctionArg'] = []
        if self.function_arg is not None:
            for k in self.function_arg:
                result['FunctionArg'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.function_arg = []
        if m.get('FunctionArg') is not None:
            for k in m.get('FunctionArg'):
                temp_model = DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg()
                self.function_arg.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfig(TeaModel):
    def __init__(self, config_id=None, function_args=None, function_name=None, parent_id=None, status=None):
        # The ID of the configuration.
        self.config_id = config_id  # type: str
        # The configurations of the features.
        self.function_args = function_args  # type: DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs
        # The name of the feature.
        self.function_name = function_name  # type: str
        # The ID of the advanced condition configuration.
        self.parent_id = parent_id  # type: str
        # The status of the configuration. Valid values:
        # 
        # *   **success**\
        # *   **testing**\
        # *   **failed**\
        # *   **configuring**\
        self.status = status  # type: str

    def validate(self):
        if self.function_args:
            self.function_args.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.function_args is not None:
            result['FunctionArgs'] = self.function_args.to_map()
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('FunctionArgs') is not None:
            temp_model = DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs()
            self.function_args = temp_model.from_map(m['FunctionArgs'])
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDcdnDomainConfigsResponseBodyDomainConfigs(TeaModel):
    def __init__(self, domain_config=None):
        self.domain_config = domain_config  # type: list[DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfig]

    def validate(self):
        if self.domain_config:
            for k in self.domain_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainConfigsResponseBodyDomainConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainConfig'] = []
        if self.domain_config is not None:
            for k in self.domain_config:
                result['DomainConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_config = []
        if m.get('DomainConfig') is not None:
            for k in m.get('DomainConfig'):
                temp_model = DescribeDcdnDomainConfigsResponseBodyDomainConfigsDomainConfig()
                self.domain_config.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainConfigsResponseBody(TeaModel):
    def __init__(self, domain_configs=None, request_id=None):
        # The configurations of the domain name.
        self.domain_configs = domain_configs  # type: DescribeDcdnDomainConfigsResponseBodyDomainConfigs
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_configs:
            self.domain_configs.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_configs is not None:
            result['DomainConfigs'] = self.domain_configs.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainConfigs') is not None:
            temp_model = DescribeDcdnDomainConfigsResponseBodyDomainConfigs()
            self.domain_configs = temp_model.from_map(m['DomainConfigs'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainDetailRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        # The accelerated domain name. You can specify only one domain name.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnDomainDetailResponseBodyDomainDetailSourcesSource(TeaModel):
    def __init__(self, content=None, enabled=None, port=None, priority=None, type=None, weight=None):
        # The origin address.
        self.content = content  # type: str
        # The status of the origin server.
        self.enabled = enabled  # type: str
        # The port over which back-to-origin requests are transmitted. Ports 443 and 80 are supported.
        self.port = port  # type: int
        # The priority of the origin server.
        self.priority = priority  # type: str
        # The type of origin server. Valid values:
        # 
        # *   **ipaddr**: the IP address of the origin server.
        # *   **domain**: the domain name of the origin server.
        # *   **oss**: the URL of an Object Storage Service (OSS) bucket.
        self.type = type  # type: str
        # The weight of the origin server if multiple origin servers have been specified.
        self.weight = weight  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainDetailResponseBodyDomainDetailSourcesSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.type is not None:
            result['Type'] = self.type
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeDcdnDomainDetailResponseBodyDomainDetailSources(TeaModel):
    def __init__(self, source=None):
        self.source = source  # type: list[DescribeDcdnDomainDetailResponseBodyDomainDetailSourcesSource]

    def validate(self):
        if self.source:
            for k in self.source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainDetailResponseBodyDomainDetailSources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Source'] = []
        if self.source is not None:
            for k in self.source:
                result['Source'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.source = []
        if m.get('Source') is not None:
            for k in m.get('Source'):
                temp_model = DescribeDcdnDomainDetailResponseBodyDomainDetailSourcesSource()
                self.source.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainDetailResponseBodyDomainDetail(TeaModel):
    def __init__(self, cname=None, description=None, domain_name=None, domain_status=None, gmt_created=None,
                 gmt_modified=None, resource_group_id=None, sslprotocol=None, sslpub=None, scope=None, sources=None):
        # The CNAME that is assigned to the accelerated domain name. You must add the CNAME record to the system of your Domain Name System (DNS) provider to map the accelerated domain name to the CNAME.
        self.cname = cname  # type: str
        # The information about the Internet content provider (ICP) filing of the domain name.
        self.description = description  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The status of the accelerated domain name. Valid values:
        # 
        # *   **online**: The domain name is enabled.
        # *   **offline**: The domain name is disabled.
        # *   **configuring**: The domain name is being configured.
        # *   **configure_failed**: The domain name has failed to be configured.
        # *   **checking**: The domain name is under review.
        # *   **check_failed**: The domain name has failed the review.
        self.domain_status = domain_status  # type: str
        # The time when the accelerated domain name was created.
        self.gmt_created = gmt_created  # type: str
        # The time when the accelerated domain name was last modified.
        self.gmt_modified = gmt_modified  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # Indicates whether the Security Socket Layer (SSL) certificate is enabled. Valid values:
        # 
        # *   **on**: **enabled**.
        # *   **off**: **disabled**.
        self.sslprotocol = sslprotocol  # type: str
        # Indicates the public key of the certificate if the HTTPS protocol is enabled.
        self.sslpub = sslpub  # type: str
        # The region where your acceleration service is deployed.
        # 
        # *   **domestic**: Chinese mainland. This is the default value.
        # *   **overseas**: outside the Chinese mainland.
        # *   **global**: all the countries in the world.
        self.scope = scope  # type: str
        # The information about the origin server.
        self.sources = sources  # type: DescribeDcdnDomainDetailResponseBodyDomainDetailSources

    def validate(self):
        if self.sources:
            self.sources.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainDetailResponseBodyDomainDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.sslpub is not None:
            result['SSLPub'] = self.sslpub
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.sources is not None:
            result['Sources'] = self.sources.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('SSLPub') is not None:
            self.sslpub = m.get('SSLPub')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('Sources') is not None:
            temp_model = DescribeDcdnDomainDetailResponseBodyDomainDetailSources()
            self.sources = temp_model.from_map(m['Sources'])
        return self


class DescribeDcdnDomainDetailResponseBody(TeaModel):
    def __init__(self, domain_detail=None, request_id=None):
        # The detailed information about the accelerated domain name.
        self.domain_detail = domain_detail  # type: DescribeDcdnDomainDetailResponseBodyDomainDetail
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_detail:
            self.domain_detail.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_detail is not None:
            result['DomainDetail'] = self.domain_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainDetail') is not None:
            temp_model = DescribeDcdnDomainDetailResponseBodyDomainDetail()
            self.domain_detail = temp_model.from_map(m['DomainDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainHitRateDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, start_time=None):
        # The accelerated domain name. You can specify only one domain name.
        # 
        # If you do not specify a value for this parameter, all domain names are queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time interval between the data entries to return. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Description**.
        self.interval = interval  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainHitRateDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainHitRateDataResponseBodyHitRatePerIntervalDataModule(TeaModel):
    def __init__(self, byte_hit_rate=None, req_hit_rate=None, time_stamp=None):
        # The byte hit ratio.
        self.byte_hit_rate = byte_hit_rate  # type: float
        # The request hit ratio.
        self.req_hit_rate = req_hit_rate  # type: float
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainHitRateDataResponseBodyHitRatePerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.byte_hit_rate is not None:
            result['ByteHitRate'] = self.byte_hit_rate
        if self.req_hit_rate is not None:
            result['ReqHitRate'] = self.req_hit_rate
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ByteHitRate') is not None:
            self.byte_hit_rate = m.get('ByteHitRate')
        if m.get('ReqHitRate') is not None:
            self.req_hit_rate = m.get('ReqHitRate')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainHitRateDataResponseBodyHitRatePerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainHitRateDataResponseBodyHitRatePerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainHitRateDataResponseBodyHitRatePerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainHitRateDataResponseBodyHitRatePerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainHitRateDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, hit_rate_per_interval=None,
                 request_id=None, start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The byte hit ratio at each time interval. The byte hit ratio is measured in percentage.
        self.hit_rate_per_interval = hit_rate_per_interval  # type: DescribeDcdnDomainHitRateDataResponseBodyHitRatePerInterval
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.hit_rate_per_interval:
            self.hit_rate_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainHitRateDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.hit_rate_per_interval is not None:
            result['HitRatePerInterval'] = self.hit_rate_per_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('HitRatePerInterval') is not None:
            temp_model = DescribeDcdnDomainHitRateDataResponseBodyHitRatePerInterval()
            self.hit_rate_per_interval = temp_model.from_map(m['HitRatePerInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainHitRateDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainHitRateDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainHitRateDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainHitRateDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainHttpCodeDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # > The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time granularity for a query. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Usage notes**.
        self.interval = interval  # type: str
        # The name of the ISP.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModuleHttpCodeDataPerIntervalHttpCodeDataModule(TeaModel):
    def __init__(self, code=None, count=None, proportion=None):
        # The HTTP status code returned.
        self.code = code  # type: int
        # The total number of entries.
        self.count = count  # type: float
        # The proportion of the HTTP status code.
        self.proportion = proportion  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModuleHttpCodeDataPerIntervalHttpCodeDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.count is not None:
            result['Count'] = self.count
        if self.proportion is not None:
            result['Proportion'] = self.proportion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Proportion') is not None:
            self.proportion = m.get('Proportion')
        return self


class DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModuleHttpCodeDataPerInterval(TeaModel):
    def __init__(self, http_code_data_module=None):
        self.http_code_data_module = http_code_data_module  # type: list[DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModuleHttpCodeDataPerIntervalHttpCodeDataModule]

    def validate(self):
        if self.http_code_data_module:
            for k in self.http_code_data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModuleHttpCodeDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HttpCodeDataModule'] = []
        if self.http_code_data_module is not None:
            for k in self.http_code_data_module:
                result['HttpCodeDataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.http_code_data_module = []
        if m.get('HttpCodeDataModule') is not None:
            for k in m.get('HttpCodeDataModule'):
                temp_model = DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModuleHttpCodeDataPerIntervalHttpCodeDataModule()
                self.http_code_data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModule(TeaModel):
    def __init__(self, http_code_data_per_interval=None, time_stamp=None):
        # The proportions of the HTTP status codes.
        self.http_code_data_per_interval = http_code_data_per_interval  # type: DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModuleHttpCodeDataPerInterval
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        if self.http_code_data_per_interval:
            self.http_code_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_code_data_per_interval is not None:
            result['HttpCodeDataPerInterval'] = self.http_code_data_per_interval.to_map()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpCodeDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModuleHttpCodeDataPerInterval()
            self.http_code_data_per_interval = temp_model.from_map(m['HttpCodeDataPerInterval'])
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainHttpCodeDataResponseBodyDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataResponseBodyDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainHttpCodeDataResponseBodyDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainHttpCodeDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, data_per_interval=None, domain_name=None, end_time=None, request_id=None,
                 start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The proportions of HTTP status codes at each time interval.
        self.data_per_interval = data_per_interval  # type: DescribeDcdnDomainHttpCodeDataResponseBodyDataPerInterval
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The start of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.data_per_interval:
            self.data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.data_per_interval is not None:
            result['DataPerInterval'] = self.data_per_interval.to_map()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DataPerInterval') is not None:
            temp_model = DescribeDcdnDomainHttpCodeDataResponseBodyDataPerInterval()
            self.data_per_interval = temp_model.from_map(m['DataPerInterval'])
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainHttpCodeDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainHttpCodeDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainHttpCodeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainHttpCodeDataByLayerRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, layer=None,
                 location_name_en=None, start_time=None):
        # The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated.
        # 
        # If you do not specify a domain name, data of all domain names is queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time interval between the data entries to return. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Description**.
        self.interval = interval  # type: str
        # The name of the Internet service provider (ISP). You can call the DescribeDcdnRegionAndIsp operation to query the ISP name. If you do not specify a value for this parameter, all ISPs are queried.
        self.isp_name_en = isp_name_en  # type: str
        # The layer at which you want to query the distribution of HTTP status codes. The network layer supports IPv4 and IPv6. The application layer supports http, https, and quic. You can also set the value to all.
        # 
        # Default value: all.
        self.layer = layer  # type: str
        # The name of the region. You can call the DescribeDcdnRegionAndIsp operation to query the region name. If you do not specify a value for this parameter, all regions are queried.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The minimum data granularity is 5 minutes.
        # 
        # If you do not set this parameter, data in the last 24 hours is queried.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataByLayerRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainHttpCodeDataByLayerResponseBodyHttpCodeDataIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, total_value=None, value=None):
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str
        # The total number of times that HTTP status codes were returned.
        self.total_value = total_value  # type: str
        # The number of times that the HTTP status code was returned.
        self.value = value  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataByLayerResponseBodyHttpCodeDataIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.total_value is not None:
            result['TotalValue'] = self.total_value
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('TotalValue') is not None:
            self.total_value = m.get('TotalValue')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnDomainHttpCodeDataByLayerResponseBodyHttpCodeDataInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainHttpCodeDataByLayerResponseBodyHttpCodeDataIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataByLayerResponseBodyHttpCodeDataInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainHttpCodeDataByLayerResponseBodyHttpCodeDataIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainHttpCodeDataByLayerResponseBody(TeaModel):
    def __init__(self, data_interval=None, http_code_data_interval=None, request_id=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The distribution of HTTP status codes at each time interval.
        self.http_code_data_interval = http_code_data_interval  # type: DescribeDcdnDomainHttpCodeDataByLayerResponseBodyHttpCodeDataInterval
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.http_code_data_interval:
            self.http_code_data_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataByLayerResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.http_code_data_interval is not None:
            result['HttpCodeDataInterval'] = self.http_code_data_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('HttpCodeDataInterval') is not None:
            temp_model = DescribeDcdnDomainHttpCodeDataByLayerResponseBodyHttpCodeDataInterval()
            self.http_code_data_interval = temp_model.from_map(m['HttpCodeDataInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainHttpCodeDataByLayerResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainHttpCodeDataByLayerResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainHttpCodeDataByLayerResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainHttpCodeDataByLayerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainIpaBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, fix_time_gap=None, interval=None, isp_name_en=None,
                 location_name_en=None, start_time=None, time_merge=None):
        # The accelerated domain name.
        # 
        # Separate multiple domain names with commas (,). If you do not specify a value for this parameter, all accelerated domain names are queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # Specify whether to implement padding with zeros. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.fix_time_gap = fix_time_gap  # type: str
        # The time granularity for a query. Unit: seconds.
        # 
        # The value varies based on the values of the **StartTime** and **EndTime** parameters. Valid values:
        # 
        # *   If the time range between StartTime and EndTime is less than 3 days, the valid values are **300**, **3600**, and **86400**. If you do not specify a value for this parameter, **300** is used.
        # *   If the time range between StartTime and EndTime is from 3 to 31 days (31 days excluded), the valid values are **3600** and **86400**. Default value: **3600**.
        # *   If the time range between StartTime and EndTime is 31 days or longer, the valid value is **86400**. Default value: **86400**.
        self.interval = interval  # type: str
        # The name of the Internet service provider (ISP).
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str
        # Specifies whether to automatically set the interval. If you set **TimeMerge** to **1**, the value of the **Interval** parameter is automatically assigned based on the **startTime** and **endTime** parameters. You can set either this parameter or the **Interval** parameter.
        self.time_merge = time_merge  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.fix_time_gap is not None:
            result['FixTimeGap'] = self.fix_time_gap
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.time_merge is not None:
            result['TimeMerge'] = self.time_merge
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FixTimeGap') is not None:
            self.fix_time_gap = m.get('FixTimeGap')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TimeMerge') is not None:
            self.time_merge = m.get('TimeMerge')
        return self


class DescribeDcdnDomainIpaBpsDataResponseBodyBpsDataPerIntervalDataModule(TeaModel):
    def __init__(self, ipa_bps=None, time_stamp=None):
        # The bandwidth value. Unit: bit/s.
        self.ipa_bps = ipa_bps  # type: float
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaBpsDataResponseBodyBpsDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipa_bps is not None:
            result['IpaBps'] = self.ipa_bps
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IpaBps') is not None:
            self.ipa_bps = m.get('IpaBps')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainIpaBpsDataResponseBodyBpsDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainIpaBpsDataResponseBodyBpsDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaBpsDataResponseBodyBpsDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainIpaBpsDataResponseBodyBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainIpaBpsDataResponseBody(TeaModel):
    def __init__(self, bps_data_per_interval=None, data_interval=None, domain_name=None, end_time=None,
                 request_id=None, start_time=None):
        # The bandwidth data returned at each interval.
        self.bps_data_per_interval = bps_data_per_interval  # type: DescribeDcdnDomainIpaBpsDataResponseBodyBpsDataPerInterval
        # The time interval at which data is collected. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.bps_data_per_interval:
            self.bps_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps_data_per_interval is not None:
            result['BpsDataPerInterval'] = self.bps_data_per_interval.to_map()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BpsDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainIpaBpsDataResponseBodyBpsDataPerInterval()
            self.bps_data_per_interval = temp_model.from_map(m['BpsDataPerInterval'])
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainIpaBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainIpaBpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainIpaBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainIpaConnDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, split_by=None, start_time=None):
        # The domain names accelerated by IPA. Separate multiple domain names with commas (,).
        # 
        # >  If you do not specify this parameter, the merged data of all accelerated domain names is returned.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # Specifies how query results are grouped. By default, this parameter is empty. Valid values:
        # 
        # *   domain: Query results are grouped by accelerated domain name.
        # *   An empty string: Query results are not grouped.
        self.split_by = split_by  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaConnDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.split_by is not None:
            result['SplitBy'] = self.split_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('SplitBy') is not None:
            self.split_by = m.get('SplitBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainIpaConnDataResponseBodyConnectionDataPerIntervalDataModule(TeaModel):
    def __init__(self, connections=None, domain=None, time_stamp=None):
        # The number of IPA user connections.
        self.connections = connections  # type: long
        # The accelerated domain name.
        self.domain = domain  # type: str
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaConnDataResponseBodyConnectionDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connections is not None:
            result['Connections'] = self.connections
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Connections') is not None:
            self.connections = m.get('Connections')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainIpaConnDataResponseBodyConnectionDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainIpaConnDataResponseBodyConnectionDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaConnDataResponseBodyConnectionDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainIpaConnDataResponseBodyConnectionDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainIpaConnDataResponseBody(TeaModel):
    def __init__(self, connection_data_per_interval=None, end_time=None, request_id=None, start_time=None):
        # The number of user connections at each time interval.
        self.connection_data_per_interval = connection_data_per_interval  # type: DescribeDcdnDomainIpaConnDataResponseBodyConnectionDataPerInterval
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.connection_data_per_interval:
            self.connection_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaConnDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_data_per_interval is not None:
            result['ConnectionDataPerInterval'] = self.connection_data_per_interval.to_map()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainIpaConnDataResponseBodyConnectionDataPerInterval()
            self.connection_data_per_interval = temp_model.from_map(m['ConnectionDataPerInterval'])
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainIpaConnDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainIpaConnDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaConnDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainIpaConnDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainIpaTrafficDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, fix_time_gap=None, interval=None, isp_name_en=None,
                 location_name_en=None, start_time=None, time_merge=None):
        # The name of the accelerated domain name.
        # 
        # You can specify one or more accelerated domain names. Separate them with commas (,). By default, all accelerated domain names that belong to your Alibaba Cloud account are queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # Specify whether to implement padding with zeros. Valid values:
        # 
        # *   **true**: Yes
        # *   **false**: No
        self.fix_time_gap = fix_time_gap  # type: str
        # The time interval between the data entries returned. Unit: seconds.
        # 
        # The valid values vary based on the values of the **StartTime** and **EndTime** parameters. Valid values:
        # 
        # *   If the time range between StartTime and EndTime is less than 3 days, valid values are **300**, **3600**, and **86400**. Default value: **300**.
        # *   If the time range between StartTime and EndTime is from 3 to 31 days (31 days excluded), valid values are **3600** and **86400**. Default value: **3600**.
        # *   If the time range between StartTime and EndTime is 31 days or longer, the valid value is **86400**. Default value: **86400**.
        self.interval = interval  # type: str
        # The name of the Internet service provider (ISP) for Dynamic Route for CDN (DCDN).
        # 
        # You can call the [DescribeCdnRegionAndIsp](~~207199~~) operation to query the most recent ISP list. If you do not specify an ISP, all ISPs are queried.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeCdnRegionAndIsp](~~207199~~) operation to query the most recent region list. If you do not specify a region, all regions are queried.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC+0.
        self.start_time = start_time  # type: str
        # Specify whether to automatically calculate the value of the **Interval** parameter. If you set the **TimeMerge** parameter to **1**, the value of the **Interval** parameter is automatically assigned based on the **StartTime** and **EndTime** parameters. You can set this parameter or the **Interval** parameter.
        self.time_merge = time_merge  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.fix_time_gap is not None:
            result['FixTimeGap'] = self.fix_time_gap
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.time_merge is not None:
            result['TimeMerge'] = self.time_merge
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FixTimeGap') is not None:
            self.fix_time_gap = m.get('FixTimeGap')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TimeMerge') is not None:
            self.time_merge = m.get('TimeMerge')
        return self


class DescribeDcdnDomainIpaTrafficDataResponseBodyTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(self, ipa_traffic=None, time_stamp=None):
        # The total amount of network traffic.
        self.ipa_traffic = ipa_traffic  # type: float
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaTrafficDataResponseBodyTrafficDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipa_traffic is not None:
            result['IpaTraffic'] = self.ipa_traffic
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IpaTraffic') is not None:
            self.ipa_traffic = m.get('IpaTraffic')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainIpaTrafficDataResponseBodyTrafficDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainIpaTrafficDataResponseBodyTrafficDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaTrafficDataResponseBodyTrafficDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainIpaTrafficDataResponseBodyTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainIpaTrafficDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, request_id=None, start_time=None,
                 traffic_data_per_interval=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range that was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range that was queried.
        self.start_time = start_time  # type: str
        # The monitoring data of network traffic that was collected at each interval.
        self.traffic_data_per_interval = traffic_data_per_interval  # type: DescribeDcdnDomainIpaTrafficDataResponseBodyTrafficDataPerInterval

    def validate(self):
        if self.traffic_data_per_interval:
            self.traffic_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.traffic_data_per_interval is not None:
            result['TrafficDataPerInterval'] = self.traffic_data_per_interval.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TrafficDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainIpaTrafficDataResponseBodyTrafficDataPerInterval()
            self.traffic_data_per_interval = temp_model.from_map(m['TrafficDataPerInterval'])
        return self


class DescribeDcdnDomainIpaTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainIpaTrafficDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIpaTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainIpaTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainIspDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, start_time=None):
        # The accelerated domain name. You can specify only one domain name in each request.
        # 
        # If you do not specify an accelerated domain name, the data of all accelerated domain names that belong to your account is queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainIspDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainIspDataResponseBodyValueIspProportionData(TeaModel):
    def __init__(self, avg_object_size=None, avg_response_rate=None, avg_response_time=None, bps=None,
                 bytes_proportion=None, isp=None, isp_ename=None, proportion=None, qps=None, total_bytes=None, total_query=None):
        # The average response size. Unit: bytes.
        self.avg_object_size = avg_object_size  # type: str
        # The average response speed. Unit: byte/ms.
        self.avg_response_rate = avg_response_rate  # type: str
        # The average response time. Unit: milliseconds.
        self.avg_response_time = avg_response_time  # type: str
        # The bandwidth.
        self.bps = bps  # type: str
        # The proportion of network traffic. For example, a value of 90 indicates that 90% of network traffic was coming from the specified ISP.
        self.bytes_proportion = bytes_proportion  # type: str
        # The information about the ISP.
        self.isp = isp  # type: str
        # The name of the ISP.
        self.isp_ename = isp_ename  # type: str
        # The proportion of requests.
        self.proportion = proportion  # type: str
        # The number of queries per second.
        self.qps = qps  # type: str
        # The total amount of network traffic.
        self.total_bytes = total_bytes  # type: str
        # The total number of requests.
        self.total_query = total_query  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainIspDataResponseBodyValueIspProportionData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_object_size is not None:
            result['AvgObjectSize'] = self.avg_object_size
        if self.avg_response_rate is not None:
            result['AvgResponseRate'] = self.avg_response_rate
        if self.avg_response_time is not None:
            result['AvgResponseTime'] = self.avg_response_time
        if self.bps is not None:
            result['Bps'] = self.bps
        if self.bytes_proportion is not None:
            result['BytesProportion'] = self.bytes_proportion
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.isp_ename is not None:
            result['IspEname'] = self.isp_ename
        if self.proportion is not None:
            result['Proportion'] = self.proportion
        if self.qps is not None:
            result['Qps'] = self.qps
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        if self.total_query is not None:
            result['TotalQuery'] = self.total_query
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgObjectSize') is not None:
            self.avg_object_size = m.get('AvgObjectSize')
        if m.get('AvgResponseRate') is not None:
            self.avg_response_rate = m.get('AvgResponseRate')
        if m.get('AvgResponseTime') is not None:
            self.avg_response_time = m.get('AvgResponseTime')
        if m.get('Bps') is not None:
            self.bps = m.get('Bps')
        if m.get('BytesProportion') is not None:
            self.bytes_proportion = m.get('BytesProportion')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('IspEname') is not None:
            self.isp_ename = m.get('IspEname')
        if m.get('Proportion') is not None:
            self.proportion = m.get('Proportion')
        if m.get('Qps') is not None:
            self.qps = m.get('Qps')
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        if m.get('TotalQuery') is not None:
            self.total_query = m.get('TotalQuery')
        return self


class DescribeDcdnDomainIspDataResponseBodyValue(TeaModel):
    def __init__(self, isp_proportion_data=None):
        self.isp_proportion_data = isp_proportion_data  # type: list[DescribeDcdnDomainIspDataResponseBodyValueIspProportionData]

    def validate(self):
        if self.isp_proportion_data:
            for k in self.isp_proportion_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIspDataResponseBodyValue, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IspProportionData'] = []
        if self.isp_proportion_data is not None:
            for k in self.isp_proportion_data:
                result['IspProportionData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.isp_proportion_data = []
        if m.get('IspProportionData') is not None:
            for k in m.get('IspProportionData'):
                temp_model = DescribeDcdnDomainIspDataResponseBodyValueIspProportionData()
                self.isp_proportion_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainIspDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, request_id=None, start_time=None,
                 value=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str
        # The access statistics by ISP.
        self.value = value  # type: DescribeDcdnDomainIspDataResponseBodyValue

    def validate(self):
        if self.value:
            self.value.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIspDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.value is not None:
            result['Value'] = self.value.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Value') is not None:
            temp_model = DescribeDcdnDomainIspDataResponseBodyValue()
            self.value = temp_model.from_map(m['Value'])
        return self


class DescribeDcdnDomainIspDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainIspDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainIspDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainIspDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainLogRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, page_number=None, page_size=None, start_time=None):
        # The accelerated domain name that you want to query. You can specify only one domain name in each call.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The number of the page to return. Pages start from page **1**.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: long
        # The number of entries to return on each page.
        # 
        # Valid values: **1** to **1000**. Default value: **300**. Maximum value: **1000**.
        self.page_size = page_size  # type: long
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail(TeaModel):
    def __init__(self, end_time=None, log_name=None, log_path=None, log_size=None, start_time=None):
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The name of the log file.
        self.log_name = log_name  # type: str
        # The path of the log file.
        # 
        # Take note of the Expires field (expiration timestamp) in the response parameter LogPath. If the log download URL expires, you must obtain it again. For more information, see [LogPath field](~~31952~~).
        self.log_path = log_path  # type: str
        # The size of the log file. Unit: bytes.
        self.log_size = log_size  # type: long
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.log_name is not None:
            result['LogName'] = self.log_name
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.log_size is not None:
            result['LogSize'] = self.log_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('LogName') is not None:
            self.log_name = m.get('LogName')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('LogSize') is not None:
            self.log_size = m.get('LogSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos(TeaModel):
    def __init__(self, log_info_detail=None):
        self.log_info_detail = log_info_detail  # type: list[DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail]

    def validate(self):
        if self.log_info_detail:
            for k in self.log_info_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LogInfoDetail'] = []
        if self.log_info_detail is not None:
            for k in self.log_info_detail:
                result['LogInfoDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.log_info_detail = []
        if m.get('LogInfoDetail') is not None:
            for k in m.get('LogInfoDetail'):
                temp_model = DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail()
                self.log_info_detail.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos(TeaModel):
    def __init__(self, page_index=None, page_size=None, total=None):
        # The page number of the returned page.
        self.page_index = page_index  # type: long
        # The number of entries returned per page.
        self.page_size = page_size  # type: long
        # The total number of entries returned.
        self.total = total  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetail(TeaModel):
    def __init__(self, log_count=None, log_infos=None, page_infos=None):
        # The total number of entries returned on the current page.
        self.log_count = log_count  # type: long
        # The log information. The log information is indicated by the LogInfoDetail parameter.
        self.log_infos = log_infos  # type: DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos
        # The page information. The page information is indicated by the PageInfoDetail parameter.
        self.page_infos = page_infos  # type: DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos

    def validate(self):
        if self.log_infos:
            self.log_infos.validate()
        if self.page_infos:
            self.page_infos.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_count is not None:
            result['LogCount'] = self.log_count
        if self.log_infos is not None:
            result['LogInfos'] = self.log_infos.to_map()
        if self.page_infos is not None:
            result['PageInfos'] = self.page_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LogCount') is not None:
            self.log_count = m.get('LogCount')
        if m.get('LogInfos') is not None:
            temp_model = DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos()
            self.log_infos = temp_model.from_map(m['LogInfos'])
        if m.get('PageInfos') is not None:
            temp_model = DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos()
            self.page_infos = temp_model.from_map(m['PageInfos'])
        return self


class DescribeDcdnDomainLogResponseBodyDomainLogDetails(TeaModel):
    def __init__(self, domain_log_detail=None):
        self.domain_log_detail = domain_log_detail  # type: list[DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetail]

    def validate(self):
        if self.domain_log_detail:
            for k in self.domain_log_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainLogResponseBodyDomainLogDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainLogDetail'] = []
        if self.domain_log_detail is not None:
            for k in self.domain_log_detail:
                result['DomainLogDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_log_detail = []
        if m.get('DomainLogDetail') is not None:
            for k in m.get('DomainLogDetail'):
                temp_model = DescribeDcdnDomainLogResponseBodyDomainLogDetailsDomainLogDetail()
                self.domain_log_detail.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainLogResponseBody(TeaModel):
    def __init__(self, domain_log_details=None, domain_name=None, request_id=None):
        # The log information. The log information is indicated by the DomainLogDetail parameter.
        self.domain_log_details = domain_log_details  # type: DescribeDcdnDomainLogResponseBodyDomainLogDetails
        # The domain name.
        self.domain_name = domain_name  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_log_details:
            self.domain_log_details.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_log_details is not None:
            result['DomainLogDetails'] = self.domain_log_details.to_map()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainLogDetails') is not None:
            temp_model = DescribeDcdnDomainLogResponseBodyDomainLogDetails()
            self.domain_log_details = temp_model.from_map(m['DomainLogDetails'])
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainLogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainMultiUsageDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, start_time=None):
        # If this parameter is not set, data of all your accelerated domain names is queried.
        # 
        # You can specify one or more accelerated domain names. Separate domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end time must be later than the start time.
        # 
        # *   Specify the time in the ISO 8601 standard
        # *   in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
        # *   You must set both the start time and the end time.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query.
        # 
        # *   Specify the time in the ISO 8601 standard
        # *   in the yyyy-MM-ddTHH:mm:ssZ format . The time must be in UTC.
        # *   The minimum time interval at which data is collected is 5 minutes.
        # *   If you do not specify a start time, data within the last 24 hours is queried.
        # *   You must set both the start time and the end time.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainMultiUsageDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainMultiUsageDataResponseBodyRequestPerIntervalRequestDataModule(TeaModel):
    def __init__(self, domain=None, request=None, time_stamp=None, type=None):
        # The accelerated domain name.
        self.domain = domain  # type: str
        # The number of requests.
        self.request = request  # type: long
        # The timestamp of the data entry.
        self.time_stamp = time_stamp  # type: str
        # The type of the requests. Valid values: StaticHttps, DynamicHttps, DynamicHttp, StaticQuic, and DynamicQuic.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainMultiUsageDataResponseBodyRequestPerIntervalRequestDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.request is not None:
            result['Request'] = self.request
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Request') is not None:
            self.request = m.get('Request')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDcdnDomainMultiUsageDataResponseBodyRequestPerInterval(TeaModel):
    def __init__(self, request_data_module=None):
        self.request_data_module = request_data_module  # type: list[DescribeDcdnDomainMultiUsageDataResponseBodyRequestPerIntervalRequestDataModule]

    def validate(self):
        if self.request_data_module:
            for k in self.request_data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainMultiUsageDataResponseBodyRequestPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RequestDataModule'] = []
        if self.request_data_module is not None:
            for k in self.request_data_module:
                result['RequestDataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.request_data_module = []
        if m.get('RequestDataModule') is not None:
            for k in m.get('RequestDataModule'):
                temp_model = DescribeDcdnDomainMultiUsageDataResponseBodyRequestPerIntervalRequestDataModule()
                self.request_data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainMultiUsageDataResponseBodyTrafficPerIntervalTrafficDataModule(TeaModel):
    def __init__(self, area=None, bps=None, domain=None, time_stamp=None, type=None):
        # The name of the district.
        self.area = area  # type: str
        # The number of bits per second.
        self.bps = bps  # type: float
        # The accelerated domain name.
        self.domain = domain  # type: str
        # The timestamp of the data entry.
        self.time_stamp = time_stamp  # type: str
        # The type of the network traffic. Valid values: Simple, IPA, and WebSocket.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainMultiUsageDataResponseBodyTrafficPerIntervalTrafficDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.bps is not None:
            result['Bps'] = self.bps
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('Bps') is not None:
            self.bps = m.get('Bps')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDcdnDomainMultiUsageDataResponseBodyTrafficPerInterval(TeaModel):
    def __init__(self, traffic_data_module=None):
        self.traffic_data_module = traffic_data_module  # type: list[DescribeDcdnDomainMultiUsageDataResponseBodyTrafficPerIntervalTrafficDataModule]

    def validate(self):
        if self.traffic_data_module:
            for k in self.traffic_data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainMultiUsageDataResponseBodyTrafficPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TrafficDataModule'] = []
        if self.traffic_data_module is not None:
            for k in self.traffic_data_module:
                result['TrafficDataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.traffic_data_module = []
        if m.get('TrafficDataModule') is not None:
            for k in m.get('TrafficDataModule'):
                temp_model = DescribeDcdnDomainMultiUsageDataResponseBodyTrafficPerIntervalTrafficDataModule()
                self.traffic_data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainMultiUsageDataResponseBody(TeaModel):
    def __init__(self, end_time=None, request_id=None, request_per_interval=None, start_time=None,
                 traffic_per_interval=None):
        # The end of the time range that was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about requests collected every 5 minutes.
        self.request_per_interval = request_per_interval  # type: DescribeDcdnDomainMultiUsageDataResponseBodyRequestPerInterval
        # The beginning of the time range that was queried.
        self.start_time = start_time  # type: str
        # The statistics of network traffic collected every 5 minutes.
        self.traffic_per_interval = traffic_per_interval  # type: DescribeDcdnDomainMultiUsageDataResponseBodyTrafficPerInterval

    def validate(self):
        if self.request_per_interval:
            self.request_per_interval.validate()
        if self.traffic_per_interval:
            self.traffic_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainMultiUsageDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.request_per_interval is not None:
            result['RequestPerInterval'] = self.request_per_interval.to_map()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.traffic_per_interval is not None:
            result['TrafficPerInterval'] = self.traffic_per_interval.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RequestPerInterval') is not None:
            temp_model = DescribeDcdnDomainMultiUsageDataResponseBodyRequestPerInterval()
            self.request_per_interval = temp_model.from_map(m['RequestPerInterval'])
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TrafficPerInterval') is not None:
            temp_model = DescribeDcdnDomainMultiUsageDataResponseBodyTrafficPerInterval()
            self.traffic_per_interval = temp_model.from_map(m['TrafficPerInterval'])
        return self


class DescribeDcdnDomainMultiUsageDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainMultiUsageDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainMultiUsageDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainMultiUsageDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainOriginBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,). If you do not specify a value for this parameter, all accelerated domain names are queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # > The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time granularity for a query. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Usage notes**.
        self.interval = interval  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainOriginBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainOriginBpsDataResponseBodyOriginBpsDataPerIntervalDataModule(TeaModel):
    def __init__(self, dynamic_http_origin_bps=None, dynamic_https_origin_bps=None, origin_bps=None,
                 static_http_origin_bps=None, static_https_origin_bps=None, time_stamp=None):
        # The bandwidth that was consumed for fetching dynamic content from the origin over HTTP.
        self.dynamic_http_origin_bps = dynamic_http_origin_bps  # type: float
        # The bandwidth that was consumed for fetching dynamic content from the origin over HTTPS.
        self.dynamic_https_origin_bps = dynamic_https_origin_bps  # type: float
        # The bandwidth that was consumed for fetching content from the origin.
        self.origin_bps = origin_bps  # type: float
        # The bandwidth that was consumed for fetching static content from the origin over HTTP.
        self.static_http_origin_bps = static_http_origin_bps  # type: float
        # The bandwidth that was consumed for fetching static content from the origin over HTTPS.
        self.static_https_origin_bps = static_https_origin_bps  # type: float
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainOriginBpsDataResponseBodyOriginBpsDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_http_origin_bps is not None:
            result['DynamicHttpOriginBps'] = self.dynamic_http_origin_bps
        if self.dynamic_https_origin_bps is not None:
            result['DynamicHttpsOriginBps'] = self.dynamic_https_origin_bps
        if self.origin_bps is not None:
            result['OriginBps'] = self.origin_bps
        if self.static_http_origin_bps is not None:
            result['StaticHttpOriginBps'] = self.static_http_origin_bps
        if self.static_https_origin_bps is not None:
            result['StaticHttpsOriginBps'] = self.static_https_origin_bps
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicHttpOriginBps') is not None:
            self.dynamic_http_origin_bps = m.get('DynamicHttpOriginBps')
        if m.get('DynamicHttpsOriginBps') is not None:
            self.dynamic_https_origin_bps = m.get('DynamicHttpsOriginBps')
        if m.get('OriginBps') is not None:
            self.origin_bps = m.get('OriginBps')
        if m.get('StaticHttpOriginBps') is not None:
            self.static_http_origin_bps = m.get('StaticHttpOriginBps')
        if m.get('StaticHttpsOriginBps') is not None:
            self.static_https_origin_bps = m.get('StaticHttpsOriginBps')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainOriginBpsDataResponseBodyOriginBpsDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainOriginBpsDataResponseBodyOriginBpsDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainOriginBpsDataResponseBodyOriginBpsDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainOriginBpsDataResponseBodyOriginBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainOriginBpsDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, origin_bps_data_per_interval=None,
                 request_id=None, start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The origin bandwidth data returned at each time interval. Unit: bit/s.
        self.origin_bps_data_per_interval = origin_bps_data_per_interval  # type: DescribeDcdnDomainOriginBpsDataResponseBodyOriginBpsDataPerInterval
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The start of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.origin_bps_data_per_interval:
            self.origin_bps_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainOriginBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.origin_bps_data_per_interval is not None:
            result['OriginBpsDataPerInterval'] = self.origin_bps_data_per_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OriginBpsDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainOriginBpsDataResponseBodyOriginBpsDataPerInterval()
            self.origin_bps_data_per_interval = temp_model.from_map(m['OriginBpsDataPerInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainOriginBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainOriginBpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainOriginBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainOriginBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainOriginTrafficDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,). If you do not specify a value for this parameter, all accelerated domain names are queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time interval between the data entries to return. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Description**.
        self.interval = interval  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainOriginTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainOriginTrafficDataResponseBodyOriginTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(self, dynamic_http_origin_traffic=None, dynamic_https_origin_traffic=None, origin_traffic=None,
                 static_http_origin_traffic=None, static_https_origin_traffic=None, time_stamp=None):
        # The amount of back-to-origin traffic that was consumed to deliver dynamic content over HTTP.
        self.dynamic_http_origin_traffic = dynamic_http_origin_traffic  # type: float
        # The amount of back-to-origin traffic that was consumed to deliver dynamic content over HTTPS.
        self.dynamic_https_origin_traffic = dynamic_https_origin_traffic  # type: float
        # The amount of back-to-origin traffic.
        self.origin_traffic = origin_traffic  # type: float
        # The amount of back-to-origin traffic that was consumed to deliver static content over HTTP.
        self.static_http_origin_traffic = static_http_origin_traffic  # type: float
        # The amount of back-to-origin traffic that was consumed to deliver static content over HTTPS.
        self.static_https_origin_traffic = static_https_origin_traffic  # type: float
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainOriginTrafficDataResponseBodyOriginTrafficDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_http_origin_traffic is not None:
            result['DynamicHttpOriginTraffic'] = self.dynamic_http_origin_traffic
        if self.dynamic_https_origin_traffic is not None:
            result['DynamicHttpsOriginTraffic'] = self.dynamic_https_origin_traffic
        if self.origin_traffic is not None:
            result['OriginTraffic'] = self.origin_traffic
        if self.static_http_origin_traffic is not None:
            result['StaticHttpOriginTraffic'] = self.static_http_origin_traffic
        if self.static_https_origin_traffic is not None:
            result['StaticHttpsOriginTraffic'] = self.static_https_origin_traffic
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicHttpOriginTraffic') is not None:
            self.dynamic_http_origin_traffic = m.get('DynamicHttpOriginTraffic')
        if m.get('DynamicHttpsOriginTraffic') is not None:
            self.dynamic_https_origin_traffic = m.get('DynamicHttpsOriginTraffic')
        if m.get('OriginTraffic') is not None:
            self.origin_traffic = m.get('OriginTraffic')
        if m.get('StaticHttpOriginTraffic') is not None:
            self.static_http_origin_traffic = m.get('StaticHttpOriginTraffic')
        if m.get('StaticHttpsOriginTraffic') is not None:
            self.static_https_origin_traffic = m.get('StaticHttpsOriginTraffic')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainOriginTrafficDataResponseBodyOriginTrafficDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainOriginTrafficDataResponseBodyOriginTrafficDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainOriginTrafficDataResponseBodyOriginTrafficDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainOriginTrafficDataResponseBodyOriginTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainOriginTrafficDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, origin_traffic_data_per_interval=None,
                 request_id=None, start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The amount of back-to-origin traffic returned at each time interval. Unit: bytes.
        self.origin_traffic_data_per_interval = origin_traffic_data_per_interval  # type: DescribeDcdnDomainOriginTrafficDataResponseBodyOriginTrafficDataPerInterval
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.origin_traffic_data_per_interval:
            self.origin_traffic_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainOriginTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.origin_traffic_data_per_interval is not None:
            result['OriginTrafficDataPerInterval'] = self.origin_traffic_data_per_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OriginTrafficDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainOriginTrafficDataResponseBodyOriginTrafficDataPerInterval()
            self.origin_traffic_data_per_interval = temp_model.from_map(m['OriginTrafficDataPerInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainOriginTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainOriginTrafficDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainOriginTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainOriginTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainPropertyRequest(TeaModel):
    def __init__(self, domain_name=None):
        # The accelerated domain name that you want to query. You can specify only one domain name in each call.
        self.domain_name = domain_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainPropertyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeDcdnDomainPropertyResponseBody(TeaModel):
    def __init__(self, domain_name=None, protocol=None, request_id=None):
        # The accelerated domain name that is queried.
        self.domain_name = domain_name  # type: str
        # The name of the protocol. Valid values:
        # 
        # *   **udp**: User Datagram Protocol (UDP)
        # *   **tcp**: Transmission Control Protocol (TCP)
        self.protocol = protocol  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainPropertyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainPropertyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainPropertyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainPropertyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainPropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainPvDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, start_time=None):
        # The name of the accelerated domain. You can specify only one domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainPvDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainPvDataResponseBodyPvDataIntervalUsageData(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str
        # The consumed network traffic.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainPvDataResponseBodyPvDataIntervalUsageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnDomainPvDataResponseBodyPvDataInterval(TeaModel):
    def __init__(self, usage_data=None):
        self.usage_data = usage_data  # type: list[DescribeDcdnDomainPvDataResponseBodyPvDataIntervalUsageData]

    def validate(self):
        if self.usage_data:
            for k in self.usage_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainPvDataResponseBodyPvDataInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UsageData'] = []
        if self.usage_data is not None:
            for k in self.usage_data:
                result['UsageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.usage_data = []
        if m.get('UsageData') is not None:
            for k in m.get('UsageData'):
                temp_model = DescribeDcdnDomainPvDataResponseBodyPvDataIntervalUsageData()
                self.usage_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainPvDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, pv_data_interval=None, request_id=None,
                 start_time=None):
        # The data collection interval. Unit: second.
        self.data_interval = data_interval  # type: str
        # The name of the accelerated domain for which the data was returned.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which the data was collected.
        self.end_time = end_time  # type: str
        # The number of PVs at each interval.
        self.pv_data_interval = pv_data_interval  # type: DescribeDcdnDomainPvDataResponseBodyPvDataInterval
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which the data was collected.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.pv_data_interval:
            self.pv_data_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainPvDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.pv_data_interval is not None:
            result['PvDataInterval'] = self.pv_data_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PvDataInterval') is not None:
            temp_model = DescribeDcdnDomainPvDataResponseBodyPvDataInterval()
            self.pv_data_interval = temp_model.from_map(m['PvDataInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainPvDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainPvDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainPvDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainPvDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainQpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 start_time=None):
        # The accelerated domain name.
        # 
        # Separate multiple domain names with commas (,). If you do not specify a value for this parameter, all accelerated domain names are queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # > The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time granularity for a query. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Usage notes**.
        self.interval = interval  # type: str
        # The name of the Internet service provider (ISP).
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainQpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainQpsDataResponseBodyQpsDataPerIntervalDataModule(TeaModel):
    def __init__(self, acc=None, dynamic_http_acc=None, dynamic_http_qps=None, dynamic_https_acc=None,
                 dynamic_https_qps=None, qps=None, static_http_acc=None, static_http_qps=None, static_https_acc=None,
                 static_https_qps=None, time_stamp=None):
        # The total number of requests.
        self.acc = acc  # type: float
        # The number of requests for dynamic content delivery over HTTP.
        self.dynamic_http_acc = dynamic_http_acc  # type: float
        # The QPS for dynamic content delivery over HTTP.
        self.dynamic_http_qps = dynamic_http_qps  # type: float
        # The number of requests for dynamic content delivery over HTTPS.
        self.dynamic_https_acc = dynamic_https_acc  # type: float
        # The QPS for dynamic content delivery over HTTPS.
        self.dynamic_https_qps = dynamic_https_qps  # type: float
        # The total QPS.
        self.qps = qps  # type: float
        # The number of requests for static content delivery over HTTP.
        self.static_http_acc = static_http_acc  # type: float
        # The QPS for static content delivery over HTTP.
        self.static_http_qps = static_http_qps  # type: float
        # The number of requests for static content delivery over HTTPS.
        self.static_https_acc = static_https_acc  # type: float
        # The QPS for static content delivery over HTTPS.
        self.static_https_qps = static_https_qps  # type: float
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainQpsDataResponseBodyQpsDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acc is not None:
            result['Acc'] = self.acc
        if self.dynamic_http_acc is not None:
            result['DynamicHttpAcc'] = self.dynamic_http_acc
        if self.dynamic_http_qps is not None:
            result['DynamicHttpQps'] = self.dynamic_http_qps
        if self.dynamic_https_acc is not None:
            result['DynamicHttpsAcc'] = self.dynamic_https_acc
        if self.dynamic_https_qps is not None:
            result['DynamicHttpsQps'] = self.dynamic_https_qps
        if self.qps is not None:
            result['Qps'] = self.qps
        if self.static_http_acc is not None:
            result['StaticHttpAcc'] = self.static_http_acc
        if self.static_http_qps is not None:
            result['StaticHttpQps'] = self.static_http_qps
        if self.static_https_acc is not None:
            result['StaticHttpsAcc'] = self.static_https_acc
        if self.static_https_qps is not None:
            result['StaticHttpsQps'] = self.static_https_qps
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acc') is not None:
            self.acc = m.get('Acc')
        if m.get('DynamicHttpAcc') is not None:
            self.dynamic_http_acc = m.get('DynamicHttpAcc')
        if m.get('DynamicHttpQps') is not None:
            self.dynamic_http_qps = m.get('DynamicHttpQps')
        if m.get('DynamicHttpsAcc') is not None:
            self.dynamic_https_acc = m.get('DynamicHttpsAcc')
        if m.get('DynamicHttpsQps') is not None:
            self.dynamic_https_qps = m.get('DynamicHttpsQps')
        if m.get('Qps') is not None:
            self.qps = m.get('Qps')
        if m.get('StaticHttpAcc') is not None:
            self.static_http_acc = m.get('StaticHttpAcc')
        if m.get('StaticHttpQps') is not None:
            self.static_http_qps = m.get('StaticHttpQps')
        if m.get('StaticHttpsAcc') is not None:
            self.static_https_acc = m.get('StaticHttpsAcc')
        if m.get('StaticHttpsQps') is not None:
            self.static_https_qps = m.get('StaticHttpsQps')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainQpsDataResponseBodyQpsDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainQpsDataResponseBodyQpsDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainQpsDataResponseBodyQpsDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainQpsDataResponseBodyQpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainQpsDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, qps_data_per_interval=None,
                 request_id=None, start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The QPS returned at each time interval.
        self.qps_data_per_interval = qps_data_per_interval  # type: DescribeDcdnDomainQpsDataResponseBodyQpsDataPerInterval
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The start of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.qps_data_per_interval:
            self.qps_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainQpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.qps_data_per_interval is not None:
            result['QpsDataPerInterval'] = self.qps_data_per_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('QpsDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainQpsDataResponseBodyQpsDataPerInterval()
            self.qps_data_per_interval = temp_model.from_map(m['QpsDataPerInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainQpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainQpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainQpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainQpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainQpsDataByLayerRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, layer=None,
                 location_name_en=None, start_time=None):
        # The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated.
        # 
        # If you do not specify a domain name, data of all domain names is queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time interval between the data entries to return. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Description**.
        self.interval = interval  # type: str
        # The name of the ISP. You can call the DescribeDcdnRegionAndIsp operation to query the ISP name. If you do not specify a value for this parameter, all ISPs are queried.
        self.isp_name_en = isp_name_en  # type: str
        # The layers at which you want to query the QPS. The network layer supports IPv4 and IPv6. The application layer supports http, https, and quic. You can also set the value to all.
        # 
        # Default value: all.
        self.layer = layer  # type: str
        # The name of the region. You can call the DescribeDcdnRegionAndIsp operation to query the region name. If you do not specify a value for this parameter, all regions are queried.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The minimum data granularity is 5 minutes.
        # 
        # If you do not set this parameter, data in the last 24 hours is queried.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainQpsDataByLayerRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainQpsDataByLayerResponseBodyQpsDataIntervalDataModule(TeaModel):
    def __init__(self, acc_domestic_value=None, acc_overseas_value=None, acc_value=None, domestic_value=None,
                 overseas_value=None, time_stamp=None, value=None):
        # The number of requests in the Chinese mainland.
        self.acc_domestic_value = acc_domestic_value  # type: str
        # The number of requests outside the Chinese mainland.
        self.acc_overseas_value = acc_overseas_value  # type: str
        # The total number of requests.
        self.acc_value = acc_value  # type: str
        # The number of queries per second in the Chinese mainland.
        self.domestic_value = domestic_value  # type: str
        # The number of queries per second outside the Chinese mainland.
        self.overseas_value = overseas_value  # type: str
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str
        # The total number of queries per second.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainQpsDataByLayerResponseBodyQpsDataIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acc_domestic_value is not None:
            result['AccDomesticValue'] = self.acc_domestic_value
        if self.acc_overseas_value is not None:
            result['AccOverseasValue'] = self.acc_overseas_value
        if self.acc_value is not None:
            result['AccValue'] = self.acc_value
        if self.domestic_value is not None:
            result['DomesticValue'] = self.domestic_value
        if self.overseas_value is not None:
            result['OverseasValue'] = self.overseas_value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccDomesticValue') is not None:
            self.acc_domestic_value = m.get('AccDomesticValue')
        if m.get('AccOverseasValue') is not None:
            self.acc_overseas_value = m.get('AccOverseasValue')
        if m.get('AccValue') is not None:
            self.acc_value = m.get('AccValue')
        if m.get('DomesticValue') is not None:
            self.domestic_value = m.get('DomesticValue')
        if m.get('OverseasValue') is not None:
            self.overseas_value = m.get('OverseasValue')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnDomainQpsDataByLayerResponseBodyQpsDataInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainQpsDataByLayerResponseBodyQpsDataIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainQpsDataByLayerResponseBodyQpsDataInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainQpsDataByLayerResponseBodyQpsDataIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainQpsDataByLayerResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, layer=None, qps_data_interval=None,
                 request_id=None, start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The layer at which the data was collected.
        self.layer = layer  # type: str
        # The QPS returned at each time interval.
        self.qps_data_interval = qps_data_interval  # type: DescribeDcdnDomainQpsDataByLayerResponseBodyQpsDataInterval
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.qps_data_interval:
            self.qps_data_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainQpsDataByLayerResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.qps_data_interval is not None:
            result['QpsDataInterval'] = self.qps_data_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('QpsDataInterval') is not None:
            temp_model = DescribeDcdnDomainQpsDataByLayerResponseBodyQpsDataInterval()
            self.qps_data_interval = temp_model.from_map(m['QpsDataInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainQpsDataByLayerResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainQpsDataByLayerResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainQpsDataByLayerResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainQpsDataByLayerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainRealTimeBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, isp_name_en=None, location_name_en=None, start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The name of the Internet service provider (ISP).
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeBpsDataResponseBodyDataBpsModel(TeaModel):
    def __init__(self, bps=None, time_stamp=None):
        # The bandwidth, in bit/s.
        self.bps = bps  # type: float
        # The timestamp of the data returned. The time follows the ISO 8601 standard. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeBpsDataResponseBodyDataBpsModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps is not None:
            result['Bps'] = self.bps
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bps') is not None:
            self.bps = m.get('Bps')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainRealTimeBpsDataResponseBodyData(TeaModel):
    def __init__(self, bps_model=None):
        self.bps_model = bps_model  # type: list[DescribeDcdnDomainRealTimeBpsDataResponseBodyDataBpsModel]

    def validate(self):
        if self.bps_model:
            for k in self.bps_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeBpsDataResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BpsModel'] = []
        if self.bps_model is not None:
            for k in self.bps_model:
                result['BpsModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bps_model = []
        if m.get('BpsModel') is not None:
            for k in m.get('BpsModel'):
                temp_model = DescribeDcdnDomainRealTimeBpsDataResponseBodyDataBpsModel()
                self.bps_model.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRealTimeBpsDataResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The list of the data returned.
        self.data = data  # type: DescribeDcdnDomainRealTimeBpsDataResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDcdnDomainRealTimeBpsDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainRealTimeBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainRealTimeBpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainRealTimeBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainRealTimeByteHitRateDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, start_time=None):
        # The domain name. Separate multiple domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeByteHitRateDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeByteHitRateDataResponseBodyDataByteHitRateDataModel(TeaModel):
    def __init__(self, byte_hit_rate=None, time_stamp=None):
        # The byte hit ratio.
        self.byte_hit_rate = byte_hit_rate  # type: float
        # The timestamp of the data returned. The time follows the ISO 8601 standard. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeByteHitRateDataResponseBodyDataByteHitRateDataModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.byte_hit_rate is not None:
            result['ByteHitRate'] = self.byte_hit_rate
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ByteHitRate') is not None:
            self.byte_hit_rate = m.get('ByteHitRate')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainRealTimeByteHitRateDataResponseBodyData(TeaModel):
    def __init__(self, byte_hit_rate_data_model=None):
        self.byte_hit_rate_data_model = byte_hit_rate_data_model  # type: list[DescribeDcdnDomainRealTimeByteHitRateDataResponseBodyDataByteHitRateDataModel]

    def validate(self):
        if self.byte_hit_rate_data_model:
            for k in self.byte_hit_rate_data_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeByteHitRateDataResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ByteHitRateDataModel'] = []
        if self.byte_hit_rate_data_model is not None:
            for k in self.byte_hit_rate_data_model:
                result['ByteHitRateDataModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.byte_hit_rate_data_model = []
        if m.get('ByteHitRateDataModel') is not None:
            for k in m.get('ByteHitRateDataModel'):
                temp_model = DescribeDcdnDomainRealTimeByteHitRateDataResponseBodyDataByteHitRateDataModel()
                self.byte_hit_rate_data_model.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRealTimeByteHitRateDataResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The list of byte hit ratios.
        self.data = data  # type: DescribeDcdnDomainRealTimeByteHitRateDataResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeByteHitRateDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDcdnDomainRealTimeByteHitRateDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainRealTimeByteHitRateDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainRealTimeByteHitRateDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeByteHitRateDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainRealTimeByteHitRateDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainRealTimeDetailDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, field=None, isp_name_en=None, location_name_en=None,
                 merge=None, merge_loc_isp=None, start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # > The end time must be later than the start time, and the maximum time range to query is 10 minutes.
        self.end_time = end_time  # type: str
        # The type of the information that you want to query. Separate multiple types with commas (,). Valid values:
        # 
        # *   **qps**: queries per second
        # *   **bps**: bandwidth
        # *   **http_code**: HTTP status code
        self.field = field  # type: str
        # The name of the ISP. You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query the ISP name.
        # 
        # If you do not specify a value for this parameter, all ISPs are queried.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region. You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query the region name.
        # 
        # If you do not specify a value for this parameter, all regions are queried.
        self.location_name_en = location_name_en  # type: str
        # Specifies whether to return a summary value. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        # 
        # The default value is **false**.
        self.merge = merge  # type: str
        # Specifies whether to return a summary value of **LocationNameEn** and **IspNameEn**. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        # 
        # The default value is **false**.
        self.merge_loc_isp = merge_loc_isp  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeDetailDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.field is not None:
            result['Field'] = self.field
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.merge is not None:
            result['Merge'] = self.merge
        if self.merge_loc_isp is not None:
            result['MergeLocIsp'] = self.merge_loc_isp
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('Merge') is not None:
            self.merge = m.get('Merge')
        if m.get('MergeLocIsp') is not None:
            self.merge_loc_isp = m.get('MergeLocIsp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeDetailDataResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The information returned.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeDetailDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainRealTimeDetailDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainRealTimeDetailDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeDetailDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainRealTimeDetailDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainRealTimeHttpCodeDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, isp_name_en=None, location_name_en=None, start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # > The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The name of the Internet service provider (ISP).
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeHttpCodeDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValueRealTimeCodeProportionData(TeaModel):
    def __init__(self, code=None, count=None, proportion=None):
        # The HTTP status code returned.
        self.code = code  # type: str
        # The total number of entries.
        self.count = count  # type: str
        # The proportion of the HTTP status code.
        self.proportion = proportion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValueRealTimeCodeProportionData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.count is not None:
            result['Count'] = self.count
        if self.proportion is not None:
            result['Proportion'] = self.proportion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Proportion') is not None:
            self.proportion = m.get('Proportion')
        return self


class DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValue(TeaModel):
    def __init__(self, real_time_code_proportion_data=None):
        self.real_time_code_proportion_data = real_time_code_proportion_data  # type: list[DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValueRealTimeCodeProportionData]

    def validate(self):
        if self.real_time_code_proportion_data:
            for k in self.real_time_code_proportion_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValue, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RealTimeCodeProportionData'] = []
        if self.real_time_code_proportion_data is not None:
            for k in self.real_time_code_proportion_data:
                result['RealTimeCodeProportionData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.real_time_code_proportion_data = []
        if m.get('RealTimeCodeProportionData') is not None:
            for k in m.get('RealTimeCodeProportionData'):
                temp_model = DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValueRealTimeCodeProportionData()
                self.real_time_code_proportion_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageData(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str
        # The information about the HTTP status code returned.
        self.value = value  # type: DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValue

    def validate(self):
        if self.value:
            self.value.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            temp_model = DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValue()
            self.value = temp_model.from_map(m['Value'])
        return self


class DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeData(TeaModel):
    def __init__(self, usage_data=None):
        self.usage_data = usage_data  # type: list[DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageData]

    def validate(self):
        if self.usage_data:
            for k in self.usage_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UsageData'] = []
        if self.usage_data is not None:
            for k in self.usage_data:
                result['UsageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.usage_data = []
        if m.get('UsageData') is not None:
            for k in m.get('UsageData'):
                temp_model = DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageData()
                self.usage_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRealTimeHttpCodeDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, real_time_http_code_data=None,
                 request_id=None, start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The proportions of the HTTP status codes.
        self.real_time_http_code_data = real_time_http_code_data  # type: DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeData
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The start of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.real_time_http_code_data:
            self.real_time_http_code_data.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeHttpCodeDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.real_time_http_code_data is not None:
            result['RealTimeHttpCodeData'] = self.real_time_http_code_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RealTimeHttpCodeData') is not None:
            temp_model = DescribeDcdnDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeData()
            self.real_time_http_code_data = temp_model.from_map(m['RealTimeHttpCodeData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeHttpCodeDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainRealTimeHttpCodeDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeHttpCodeDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainRealTimeHttpCodeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainRealTimeQpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, isp_name_en=None, location_name_en=None, start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The name of the Internet service provider (ISP).
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeQpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeQpsDataResponseBodyDataQpsModel(TeaModel):
    def __init__(self, qps=None, time_stamp=None):
        # The QPS data.
        self.qps = qps  # type: float
        # The timestamp of the data returned. The time follows the ISO 8601 standard. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeQpsDataResponseBodyDataQpsModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qps is not None:
            result['Qps'] = self.qps
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Qps') is not None:
            self.qps = m.get('Qps')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainRealTimeQpsDataResponseBodyData(TeaModel):
    def __init__(self, qps_model=None):
        self.qps_model = qps_model  # type: list[DescribeDcdnDomainRealTimeQpsDataResponseBodyDataQpsModel]

    def validate(self):
        if self.qps_model:
            for k in self.qps_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeQpsDataResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['QpsModel'] = []
        if self.qps_model is not None:
            for k in self.qps_model:
                result['QpsModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.qps_model = []
        if m.get('QpsModel') is not None:
            for k in m.get('QpsModel'):
                temp_model = DescribeDcdnDomainRealTimeQpsDataResponseBodyDataQpsModel()
                self.qps_model.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRealTimeQpsDataResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The list of the data returned.
        self.data = data  # type: DescribeDcdnDomainRealTimeQpsDataResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeQpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDcdnDomainRealTimeQpsDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainRealTimeQpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainRealTimeQpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeQpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainRealTimeQpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainRealTimeReqHitRateDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeReqHitRateDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeReqHitRateDataResponseBodyDataReqHitRateDataModel(TeaModel):
    def __init__(self, req_hit_rate=None, time_stamp=None):
        # The request hit ratio.
        self.req_hit_rate = req_hit_rate  # type: float
        # The timestamp of the data returned. The time follows the ISO 8601 standard. The time is displayed in UTC.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeReqHitRateDataResponseBodyDataReqHitRateDataModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_hit_rate is not None:
            result['ReqHitRate'] = self.req_hit_rate
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReqHitRate') is not None:
            self.req_hit_rate = m.get('ReqHitRate')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnDomainRealTimeReqHitRateDataResponseBodyData(TeaModel):
    def __init__(self, req_hit_rate_data_model=None):
        self.req_hit_rate_data_model = req_hit_rate_data_model  # type: list[DescribeDcdnDomainRealTimeReqHitRateDataResponseBodyDataReqHitRateDataModel]

    def validate(self):
        if self.req_hit_rate_data_model:
            for k in self.req_hit_rate_data_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeReqHitRateDataResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ReqHitRateDataModel'] = []
        if self.req_hit_rate_data_model is not None:
            for k in self.req_hit_rate_data_model:
                result['ReqHitRateDataModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.req_hit_rate_data_model = []
        if m.get('ReqHitRateDataModel') is not None:
            for k in m.get('ReqHitRateDataModel'):
                temp_model = DescribeDcdnDomainRealTimeReqHitRateDataResponseBodyDataReqHitRateDataModel()
                self.req_hit_rate_data_model.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRealTimeReqHitRateDataResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The list of request hit ratios.
        self.data = data  # type: DescribeDcdnDomainRealTimeReqHitRateDataResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeReqHitRateDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDcdnDomainRealTimeReqHitRateDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainRealTimeReqHitRateDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainRealTimeReqHitRateDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeReqHitRateDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainRealTimeReqHitRateDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainRealTimeSrcBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeSrcBpsDataResponseBodyRealTimeSrcBpsDataPerIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str
        # The bandwidth data during back-to-origin routing.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcBpsDataResponseBodyRealTimeSrcBpsDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnDomainRealTimeSrcBpsDataResponseBodyRealTimeSrcBpsDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainRealTimeSrcBpsDataResponseBodyRealTimeSrcBpsDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcBpsDataResponseBodyRealTimeSrcBpsDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainRealTimeSrcBpsDataResponseBodyRealTimeSrcBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRealTimeSrcBpsDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None,
                 real_time_src_bps_data_per_interval=None, request_id=None, start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 60 (1 minute), 300 (5 minutes), and 3600(1 hour). For more information, see **Description**.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The back-to-origin bandwidth data returned at each time interval. Unit: bit/s.
        self.real_time_src_bps_data_per_interval = real_time_src_bps_data_per_interval  # type: DescribeDcdnDomainRealTimeSrcBpsDataResponseBodyRealTimeSrcBpsDataPerInterval
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.real_time_src_bps_data_per_interval:
            self.real_time_src_bps_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.real_time_src_bps_data_per_interval is not None:
            result['RealTimeSrcBpsDataPerInterval'] = self.real_time_src_bps_data_per_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RealTimeSrcBpsDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainRealTimeSrcBpsDataResponseBodyRealTimeSrcBpsDataPerInterval()
            self.real_time_src_bps_data_per_interval = temp_model.from_map(m['RealTimeSrcBpsDataPerInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeSrcBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainRealTimeSrcBpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainRealTimeSrcBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainRealTimeSrcHttpCodeDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, isp_name_en=None, location_name_en=None, start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The name of the Internet service provider (ISP).
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcHttpCodeDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageDataValueRealTimeSrcCodeProportionData(TeaModel):
    def __init__(self, code=None, count=None, proportion=None):
        # The HTTP status code.
        self.code = code  # type: str
        # The number of HTTP status codes.
        self.count = count  # type: str
        # The proportion of the HTTP status code.
        self.proportion = proportion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageDataValueRealTimeSrcCodeProportionData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.count is not None:
            result['Count'] = self.count
        if self.proportion is not None:
            result['Proportion'] = self.proportion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Proportion') is not None:
            self.proportion = m.get('Proportion')
        return self


class DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageDataValue(TeaModel):
    def __init__(self, real_time_src_code_proportion_data=None):
        self.real_time_src_code_proportion_data = real_time_src_code_proportion_data  # type: list[DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageDataValueRealTimeSrcCodeProportionData]

    def validate(self):
        if self.real_time_src_code_proportion_data:
            for k in self.real_time_src_code_proportion_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageDataValue, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RealTimeSrcCodeProportionData'] = []
        if self.real_time_src_code_proportion_data is not None:
            for k in self.real_time_src_code_proportion_data:
                result['RealTimeSrcCodeProportionData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.real_time_src_code_proportion_data = []
        if m.get('RealTimeSrcCodeProportionData') is not None:
            for k in m.get('RealTimeSrcCodeProportionData'):
                temp_model = DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageDataValueRealTimeSrcCodeProportionData()
                self.real_time_src_code_proportion_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageData(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str
        # The proportions of HTTP status codes.
        self.value = value  # type: DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageDataValue

    def validate(self):
        if self.value:
            self.value.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            temp_model = DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageDataValue()
            self.value = temp_model.from_map(m['Value'])
        return self


class DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeData(TeaModel):
    def __init__(self, usage_data=None):
        self.usage_data = usage_data  # type: list[DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageData]

    def validate(self):
        if self.usage_data:
            for k in self.usage_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UsageData'] = []
        if self.usage_data is not None:
            for k in self.usage_data:
                result['UsageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.usage_data = []
        if m.get('UsageData') is not None:
            for k in m.get('UsageData'):
                temp_model = DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeDataUsageData()
                self.usage_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, real_time_src_http_code_data=None,
                 request_id=None, start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC.
        self.end_time = end_time  # type: str
        # The proportions of HTTP status codes at each time interval.
        self.real_time_src_http_code_data = real_time_src_http_code_data  # type: DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeData
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried. 
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.real_time_src_http_code_data:
            self.real_time_src_http_code_data.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.real_time_src_http_code_data is not None:
            result['RealTimeSrcHttpCodeData'] = self.real_time_src_http_code_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RealTimeSrcHttpCodeData') is not None:
            temp_model = DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBodyRealTimeSrcHttpCodeData()
            self.real_time_src_http_code_data = temp_model.from_map(m['RealTimeSrcHttpCodeData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeSrcHttpCodeDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcHttpCodeDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainRealTimeSrcHttpCodeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainRealTimeSrcTrafficDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeSrcTrafficDataResponseBodyRealTimeSrcTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str
        # The traffic value at each time interval.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcTrafficDataResponseBodyRealTimeSrcTrafficDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnDomainRealTimeSrcTrafficDataResponseBodyRealTimeSrcTrafficDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainRealTimeSrcTrafficDataResponseBodyRealTimeSrcTrafficDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcTrafficDataResponseBodyRealTimeSrcTrafficDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainRealTimeSrcTrafficDataResponseBodyRealTimeSrcTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRealTimeSrcTrafficDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None,
                 real_time_src_traffic_data_per_interval=None, request_id=None, start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 60 (1 minute), 300 (5 minutes), and 3600(1 hour). For more information, see **Usage notes**.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The amount of origin traffic returned at each time interval. Unit: bytes.
        self.real_time_src_traffic_data_per_interval = real_time_src_traffic_data_per_interval  # type: DescribeDcdnDomainRealTimeSrcTrafficDataResponseBodyRealTimeSrcTrafficDataPerInterval
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The start of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.real_time_src_traffic_data_per_interval:
            self.real_time_src_traffic_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.real_time_src_traffic_data_per_interval is not None:
            result['RealTimeSrcTrafficDataPerInterval'] = self.real_time_src_traffic_data_per_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RealTimeSrcTrafficDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainRealTimeSrcTrafficDataResponseBodyRealTimeSrcTrafficDataPerInterval()
            self.real_time_src_traffic_data_per_interval = temp_model.from_map(m['RealTimeSrcTrafficDataPerInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeSrcTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainRealTimeSrcTrafficDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeSrcTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainRealTimeSrcTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainRealTimeTrafficDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, start_time=None):
        # The accelerated domain name. You can specify one or more domain names and separate them with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC. The end time must be later than the start time.
        # 
        # >  If you do not set the StartTime or EndTime parameter, the request returns the data collected in the last hour. If you set both the StartTime and EndTime parameters, the request returns the data collected within the specified time range.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  If you do not set the StartTime or EndTime parameter, the request returns the data collected in the last hour. If you set both the StartTime and EndTime parameters, the request returns the data collected within the specified time range.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str
        # The amount of back-to-origin network traffic.
        # 
        # >  The network traffic is measured in bytes.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRealTimeTrafficDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None,
                 real_time_traffic_data_per_interval=None, request_id=None, start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 60 (1 minute), 300 (5 minutes), and 3600 (1 hour). For more information, see **Description**.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The amount of back-to-origin network traffic returned at each interval.
        self.real_time_traffic_data_per_interval = real_time_traffic_data_per_interval  # type: DescribeDcdnDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerInterval
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.real_time_traffic_data_per_interval:
            self.real_time_traffic_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.real_time_traffic_data_per_interval is not None:
            result['RealTimeTrafficDataPerInterval'] = self.real_time_traffic_data_per_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RealTimeTrafficDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerInterval()
            self.real_time_traffic_data_per_interval = temp_model.from_map(m['RealTimeTrafficDataPerInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRealTimeTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainRealTimeTrafficDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRealTimeTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainRealTimeTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainRegionDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, start_time=None):
        # The accelerated domain name. You can specify only one domain name.
        # 
        # If you do not specify an accelerated domain name, all accelerated domain names in your account are queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. The end time must be later than the start time.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRegionDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainRegionDataResponseBodyValueRegionProportionData(TeaModel):
    def __init__(self, avg_object_size=None, avg_response_rate=None, avg_response_time=None, bps=None,
                 bytes_proportion=None, proportion=None, qps=None, region=None, region_ename=None, total_bytes=None, total_query=None):
        # The average response size. Unit: bytes.
        self.avg_object_size = avg_object_size  # type: str
        # The average response speed. Unit: byte/s.
        self.avg_response_rate = avg_response_rate  # type: str
        # The average response time. Unit: milliseconds.
        self.avg_response_time = avg_response_time  # type: str
        # The bandwidth.
        self.bps = bps  # type: str
        # The proportion of network traffic occupied by the specified region based on the total amount of network traffic in percentile. For example, a value of 90 indicates that 90% of the network traffic was coming from the specified region.
        self.bytes_proportion = bytes_proportion  # type: str
        # The proportion of requests from the specified region based on the total number of requests in percentile. For example, a value of 90 indicates that 90% of the requests were coming from the specified region.
        self.proportion = proportion  # type: str
        # The number of queries per second.
        self.qps = qps  # type: str
        # The region.
        self.region = region  # type: str
        # The name of the region.
        self.region_ename = region_ename  # type: str
        # The total amount of network traffic.
        self.total_bytes = total_bytes  # type: str
        # The total number of requests.
        self.total_query = total_query  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainRegionDataResponseBodyValueRegionProportionData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_object_size is not None:
            result['AvgObjectSize'] = self.avg_object_size
        if self.avg_response_rate is not None:
            result['AvgResponseRate'] = self.avg_response_rate
        if self.avg_response_time is not None:
            result['AvgResponseTime'] = self.avg_response_time
        if self.bps is not None:
            result['Bps'] = self.bps
        if self.bytes_proportion is not None:
            result['BytesProportion'] = self.bytes_proportion
        if self.proportion is not None:
            result['Proportion'] = self.proportion
        if self.qps is not None:
            result['Qps'] = self.qps
        if self.region is not None:
            result['Region'] = self.region
        if self.region_ename is not None:
            result['RegionEname'] = self.region_ename
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        if self.total_query is not None:
            result['TotalQuery'] = self.total_query
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgObjectSize') is not None:
            self.avg_object_size = m.get('AvgObjectSize')
        if m.get('AvgResponseRate') is not None:
            self.avg_response_rate = m.get('AvgResponseRate')
        if m.get('AvgResponseTime') is not None:
            self.avg_response_time = m.get('AvgResponseTime')
        if m.get('Bps') is not None:
            self.bps = m.get('Bps')
        if m.get('BytesProportion') is not None:
            self.bytes_proportion = m.get('BytesProportion')
        if m.get('Proportion') is not None:
            self.proportion = m.get('Proportion')
        if m.get('Qps') is not None:
            self.qps = m.get('Qps')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionEname') is not None:
            self.region_ename = m.get('RegionEname')
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        if m.get('TotalQuery') is not None:
            self.total_query = m.get('TotalQuery')
        return self


class DescribeDcdnDomainRegionDataResponseBodyValue(TeaModel):
    def __init__(self, region_proportion_data=None):
        self.region_proportion_data = region_proportion_data  # type: list[DescribeDcdnDomainRegionDataResponseBodyValueRegionProportionData]

    def validate(self):
        if self.region_proportion_data:
            for k in self.region_proportion_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRegionDataResponseBodyValue, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RegionProportionData'] = []
        if self.region_proportion_data is not None:
            for k in self.region_proportion_data:
                result['RegionProportionData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.region_proportion_data = []
        if m.get('RegionProportionData') is not None:
            for k in m.get('RegionProportionData'):
                temp_model = DescribeDcdnDomainRegionDataResponseBodyValueRegionProportionData()
                self.region_proportion_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainRegionDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, request_id=None, start_time=None,
                 value=None):
        # The data collection interval. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which the data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which the data was queried.
        self.start_time = start_time  # type: str
        # The proportions of requests that were initiated from each region.
        self.value = value  # type: DescribeDcdnDomainRegionDataResponseBodyValue

    def validate(self):
        if self.value:
            self.value.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRegionDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.value is not None:
            result['Value'] = self.value.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Value') is not None:
            temp_model = DescribeDcdnDomainRegionDataResponseBodyValue()
            self.value = temp_model.from_map(m['Value'])
        return self


class DescribeDcdnDomainRegionDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainRegionDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainRegionDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainRegionDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainStagingConfigRequest(TeaModel):
    def __init__(self, domain_name=None, function_names=None):
        # The name of the accelerated domain.
        self.domain_name = domain_name  # type: str
        # The names of the features to query. You can specify multiple features and separate them with commas (,).
        self.function_names = function_names  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainStagingConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.function_names is not None:
            result['FunctionNames'] = self.function_names
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('FunctionNames') is not None:
            self.function_names = m.get('FunctionNames')
        return self


class DescribeDcdnDomainStagingConfigResponseBodyDomainConfigsFunctionArgs(TeaModel):
    def __init__(self, arg_name=None, arg_value=None):
        # The name of the configuration.
        self.arg_name = arg_name  # type: str
        # The value of the configuration.
        self.arg_value = arg_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainStagingConfigResponseBodyDomainConfigsFunctionArgs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg_name is not None:
            result['ArgName'] = self.arg_name
        if self.arg_value is not None:
            result['ArgValue'] = self.arg_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArgName') is not None:
            self.arg_name = m.get('ArgName')
        if m.get('ArgValue') is not None:
            self.arg_value = m.get('ArgValue')
        return self


class DescribeDcdnDomainStagingConfigResponseBodyDomainConfigs(TeaModel):
    def __init__(self, config_id=None, function_args=None, function_name=None, status=None):
        # The ID of the configuration.
        self.config_id = config_id  # type: str
        # The descriptions of a feature.
        self.function_args = function_args  # type: list[DescribeDcdnDomainStagingConfigResponseBodyDomainConfigsFunctionArgs]
        # The name of the feature.
        self.function_name = function_name  # type: str
        # The status of the feature. Valid values:
        # 
        # *   success
        # *   testing
        # *   failed
        # *   configuring
        self.status = status  # type: str

    def validate(self):
        if self.function_args:
            for k in self.function_args:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainStagingConfigResponseBodyDomainConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        result['FunctionArgs'] = []
        if self.function_args is not None:
            for k in self.function_args:
                result['FunctionArgs'].append(k.to_map() if k else None)
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        self.function_args = []
        if m.get('FunctionArgs') is not None:
            for k in m.get('FunctionArgs'):
                temp_model = DescribeDcdnDomainStagingConfigResponseBodyDomainConfigsFunctionArgs()
                self.function_args.append(temp_model.from_map(k))
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDcdnDomainStagingConfigResponseBody(TeaModel):
    def __init__(self, domain_configs=None, request_id=None):
        # The configurations of accelerated domain names returned.
        self.domain_configs = domain_configs  # type: list[DescribeDcdnDomainStagingConfigResponseBodyDomainConfigs]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_configs:
            for k in self.domain_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainStagingConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainConfigs'] = []
        if self.domain_configs is not None:
            for k in self.domain_configs:
                result['DomainConfigs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_configs = []
        if m.get('DomainConfigs') is not None:
            for k in m.get('DomainConfigs'):
                temp_model = DescribeDcdnDomainStagingConfigResponseBodyDomainConfigs()
                self.domain_configs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnDomainStagingConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainStagingConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainStagingConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainStagingConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainTopReferVisitRequest(TeaModel):
    def __init__(self, domain_name=None, sort_by=None, start_time=None):
        # The accelerated domain name. You can specify only one domain name.
        self.domain_name = domain_name  # type: str
        # The method that is used to sort the web pages. Valid values:
        # 
        # *   **traf**: by network traffic.
        # *   **pv**: by the number of visits.
        # 
        # Default value**: pv**.
        self.sort_by = sort_by  # type: str
        # The start of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # To query the data on a specified day, use the yyyy-MM-ddT16:00:00Z format.
        # 
        # If you do not specify this parameter, data collected within the last 24 hours is queried by default.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainTopReferVisitRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainTopReferVisitResponseBodyTopReferListReferList(TeaModel):
    def __init__(self, flow=None, flow_proportion=None, refer_detail=None, visit_data=None, visit_proportion=None):
        # The network traffic. Unit: bytes.
        self.flow = flow  # type: str
        # The proportion of the network traffic.
        self.flow_proportion = flow_proportion  # type: float
        # The complete referenced URL.
        self.refer_detail = refer_detail  # type: str
        # The number of visits to the URL.
        self.visit_data = visit_data  # type: str
        # The proportion of the visits.
        self.visit_proportion = visit_proportion  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainTopReferVisitResponseBodyTopReferListReferList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow is not None:
            result['Flow'] = self.flow
        if self.flow_proportion is not None:
            result['FlowProportion'] = self.flow_proportion
        if self.refer_detail is not None:
            result['ReferDetail'] = self.refer_detail
        if self.visit_data is not None:
            result['VisitData'] = self.visit_data
        if self.visit_proportion is not None:
            result['VisitProportion'] = self.visit_proportion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Flow') is not None:
            self.flow = m.get('Flow')
        if m.get('FlowProportion') is not None:
            self.flow_proportion = m.get('FlowProportion')
        if m.get('ReferDetail') is not None:
            self.refer_detail = m.get('ReferDetail')
        if m.get('VisitData') is not None:
            self.visit_data = m.get('VisitData')
        if m.get('VisitProportion') is not None:
            self.visit_proportion = m.get('VisitProportion')
        return self


class DescribeDcdnDomainTopReferVisitResponseBodyTopReferList(TeaModel):
    def __init__(self, refer_list=None):
        self.refer_list = refer_list  # type: list[DescribeDcdnDomainTopReferVisitResponseBodyTopReferListReferList]

    def validate(self):
        if self.refer_list:
            for k in self.refer_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTopReferVisitResponseBodyTopReferList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ReferList'] = []
        if self.refer_list is not None:
            for k in self.refer_list:
                result['ReferList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.refer_list = []
        if m.get('ReferList') is not None:
            for k in m.get('ReferList'):
                temp_model = DescribeDcdnDomainTopReferVisitResponseBodyTopReferListReferList()
                self.refer_list.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainTopReferVisitResponseBody(TeaModel):
    def __init__(self, domain_name=None, request_id=None, start_time=None, top_refer_list=None):
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The start of the time range during which the data is collected.
        self.start_time = start_time  # type: str
        # The list of frequently referenced URLs returned.
        self.top_refer_list = top_refer_list  # type: DescribeDcdnDomainTopReferVisitResponseBodyTopReferList

    def validate(self):
        if self.top_refer_list:
            self.top_refer_list.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTopReferVisitResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.top_refer_list is not None:
            result['TopReferList'] = self.top_refer_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TopReferList') is not None:
            temp_model = DescribeDcdnDomainTopReferVisitResponseBodyTopReferList()
            self.top_refer_list = temp_model.from_map(m['TopReferList'])
        return self


class DescribeDcdnDomainTopReferVisitResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainTopReferVisitResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTopReferVisitResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainTopReferVisitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainTopUrlVisitRequest(TeaModel):
    def __init__(self, domain_name=None, sort_by=None, start_time=None):
        # The accelerated domain name. You can specify only one domain name in each call.
        self.domain_name = domain_name  # type: str
        # The method that is used to sort the web pages. Valid values:
        # 
        # *   **traf**: by network traffic.
        # *   **pv**: by the number of visits.
        # 
        # Default value: **pv**.
        self.sort_by = sort_by  # type: str
        # The start of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format. The time must be in UTC.
        # 
        # To query the data on a specified day, use the format: yyyy-MM-ddT16:00:00Z.
        # 
        # >  If you do not set this parameter, the data within the last 24 hours is queried.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainTopUrlVisitResponseBodyAllUrlListUrlList(TeaModel):
    def __init__(self, flow=None, flow_proportion=None, url_detail=None, visit_data=None, visit_proportion=None):
        # The network traffic that was consumed by visits to the URLs. Unit: bytes.
        self.flow = flow  # type: str
        # The proportion of network traffic consumed for accessing the URL.
        self.flow_proportion = flow_proportion  # type: float
        # The complete string of the URL that was queried.
        self.url_detail = url_detail  # type: str
        # The number of visits to the URL.
        self.visit_data = visit_data  # type: str
        # The proportion of visits.
        self.visit_proportion = visit_proportion  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponseBodyAllUrlListUrlList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow is not None:
            result['Flow'] = self.flow
        if self.flow_proportion is not None:
            result['FlowProportion'] = self.flow_proportion
        if self.url_detail is not None:
            result['UrlDetail'] = self.url_detail
        if self.visit_data is not None:
            result['VisitData'] = self.visit_data
        if self.visit_proportion is not None:
            result['VisitProportion'] = self.visit_proportion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Flow') is not None:
            self.flow = m.get('Flow')
        if m.get('FlowProportion') is not None:
            self.flow_proportion = m.get('FlowProportion')
        if m.get('UrlDetail') is not None:
            self.url_detail = m.get('UrlDetail')
        if m.get('VisitData') is not None:
            self.visit_data = m.get('VisitData')
        if m.get('VisitProportion') is not None:
            self.visit_proportion = m.get('VisitProportion')
        return self


class DescribeDcdnDomainTopUrlVisitResponseBodyAllUrlList(TeaModel):
    def __init__(self, url_list=None):
        self.url_list = url_list  # type: list[DescribeDcdnDomainTopUrlVisitResponseBodyAllUrlListUrlList]

    def validate(self):
        if self.url_list:
            for k in self.url_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponseBodyAllUrlList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UrlList'] = []
        if self.url_list is not None:
            for k in self.url_list:
                result['UrlList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.url_list = []
        if m.get('UrlList') is not None:
            for k in m.get('UrlList'):
                temp_model = DescribeDcdnDomainTopUrlVisitResponseBodyAllUrlListUrlList()
                self.url_list.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainTopUrlVisitResponseBodyUrl200ListUrlList(TeaModel):
    def __init__(self, flow=None, flow_proportion=None, url_detail=None, visit_data=None, visit_proportion=None):
        # The network traffic that was consumed by visits to the URLs. Unit: bytes.
        self.flow = flow  # type: str
        # The proportion of network traffic consumed for accessing the URL.
        self.flow_proportion = flow_proportion  # type: float
        # The complete string of the URL that was queried.
        self.url_detail = url_detail  # type: str
        # The number of visits to the URL.
        self.visit_data = visit_data  # type: str
        # The proportion of visits to the URL.
        self.visit_proportion = visit_proportion  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponseBodyUrl200ListUrlList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow is not None:
            result['Flow'] = self.flow
        if self.flow_proportion is not None:
            result['FlowProportion'] = self.flow_proportion
        if self.url_detail is not None:
            result['UrlDetail'] = self.url_detail
        if self.visit_data is not None:
            result['VisitData'] = self.visit_data
        if self.visit_proportion is not None:
            result['VisitProportion'] = self.visit_proportion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Flow') is not None:
            self.flow = m.get('Flow')
        if m.get('FlowProportion') is not None:
            self.flow_proportion = m.get('FlowProportion')
        if m.get('UrlDetail') is not None:
            self.url_detail = m.get('UrlDetail')
        if m.get('VisitData') is not None:
            self.visit_data = m.get('VisitData')
        if m.get('VisitProportion') is not None:
            self.visit_proportion = m.get('VisitProportion')
        return self


class DescribeDcdnDomainTopUrlVisitResponseBodyUrl200List(TeaModel):
    def __init__(self, url_list=None):
        self.url_list = url_list  # type: list[DescribeDcdnDomainTopUrlVisitResponseBodyUrl200ListUrlList]

    def validate(self):
        if self.url_list:
            for k in self.url_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponseBodyUrl200List, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UrlList'] = []
        if self.url_list is not None:
            for k in self.url_list:
                result['UrlList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.url_list = []
        if m.get('UrlList') is not None:
            for k in m.get('UrlList'):
                temp_model = DescribeDcdnDomainTopUrlVisitResponseBodyUrl200ListUrlList()
                self.url_list.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainTopUrlVisitResponseBodyUrl300ListUrlList(TeaModel):
    def __init__(self, flow=None, flow_proportion=None, url_detail=None, visit_data=None, visit_proportion=None):
        # The network traffic that was consumed by visits to the URLs. Unit: bytes.
        self.flow = flow  # type: str
        # The proportion of network traffic consumed for accessing the URL.
        self.flow_proportion = flow_proportion  # type: float
        # The complete string of the URL that was queried.
        self.url_detail = url_detail  # type: str
        # The number of visits to the URL.
        self.visit_data = visit_data  # type: str
        # The proportion of visits.
        self.visit_proportion = visit_proportion  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponseBodyUrl300ListUrlList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow is not None:
            result['Flow'] = self.flow
        if self.flow_proportion is not None:
            result['FlowProportion'] = self.flow_proportion
        if self.url_detail is not None:
            result['UrlDetail'] = self.url_detail
        if self.visit_data is not None:
            result['VisitData'] = self.visit_data
        if self.visit_proportion is not None:
            result['VisitProportion'] = self.visit_proportion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Flow') is not None:
            self.flow = m.get('Flow')
        if m.get('FlowProportion') is not None:
            self.flow_proportion = m.get('FlowProportion')
        if m.get('UrlDetail') is not None:
            self.url_detail = m.get('UrlDetail')
        if m.get('VisitData') is not None:
            self.visit_data = m.get('VisitData')
        if m.get('VisitProportion') is not None:
            self.visit_proportion = m.get('VisitProportion')
        return self


class DescribeDcdnDomainTopUrlVisitResponseBodyUrl300List(TeaModel):
    def __init__(self, url_list=None):
        self.url_list = url_list  # type: list[DescribeDcdnDomainTopUrlVisitResponseBodyUrl300ListUrlList]

    def validate(self):
        if self.url_list:
            for k in self.url_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponseBodyUrl300List, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UrlList'] = []
        if self.url_list is not None:
            for k in self.url_list:
                result['UrlList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.url_list = []
        if m.get('UrlList') is not None:
            for k in m.get('UrlList'):
                temp_model = DescribeDcdnDomainTopUrlVisitResponseBodyUrl300ListUrlList()
                self.url_list.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainTopUrlVisitResponseBodyUrl400ListUrlList(TeaModel):
    def __init__(self, flow=None, flow_proportion=None, url_detail=None, visit_data=None, visit_proportion=None):
        # The network traffic that was consumed by visits to the URLs. Unit: bytes.
        self.flow = flow  # type: str
        # The proportion of network traffic consumed for accessing the URL.
        self.flow_proportion = flow_proportion  # type: float
        # The complete string of the URL that was queried.
        self.url_detail = url_detail  # type: str
        # The number of visits to the URL.
        self.visit_data = visit_data  # type: str
        # The proportion of visits.
        self.visit_proportion = visit_proportion  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponseBodyUrl400ListUrlList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow is not None:
            result['Flow'] = self.flow
        if self.flow_proportion is not None:
            result['FlowProportion'] = self.flow_proportion
        if self.url_detail is not None:
            result['UrlDetail'] = self.url_detail
        if self.visit_data is not None:
            result['VisitData'] = self.visit_data
        if self.visit_proportion is not None:
            result['VisitProportion'] = self.visit_proportion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Flow') is not None:
            self.flow = m.get('Flow')
        if m.get('FlowProportion') is not None:
            self.flow_proportion = m.get('FlowProportion')
        if m.get('UrlDetail') is not None:
            self.url_detail = m.get('UrlDetail')
        if m.get('VisitData') is not None:
            self.visit_data = m.get('VisitData')
        if m.get('VisitProportion') is not None:
            self.visit_proportion = m.get('VisitProportion')
        return self


class DescribeDcdnDomainTopUrlVisitResponseBodyUrl400List(TeaModel):
    def __init__(self, url_list=None):
        self.url_list = url_list  # type: list[DescribeDcdnDomainTopUrlVisitResponseBodyUrl400ListUrlList]

    def validate(self):
        if self.url_list:
            for k in self.url_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponseBodyUrl400List, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UrlList'] = []
        if self.url_list is not None:
            for k in self.url_list:
                result['UrlList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.url_list = []
        if m.get('UrlList') is not None:
            for k in m.get('UrlList'):
                temp_model = DescribeDcdnDomainTopUrlVisitResponseBodyUrl400ListUrlList()
                self.url_list.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainTopUrlVisitResponseBodyUrl500ListUrlList(TeaModel):
    def __init__(self, flow=None, flow_proportion=None, url_detail=None, visit_data=None, visit_proportion=None):
        # The network traffic that was consumed by visits to the URLs. Unit: bytes.
        self.flow = flow  # type: str
        # The proportion of network traffic consumed for accessing the URL.
        self.flow_proportion = flow_proportion  # type: float
        # The complete string of the URL that was queried.
        self.url_detail = url_detail  # type: str
        # The number of visits to the URL.
        self.visit_data = visit_data  # type: str
        # The proportion of visits.
        self.visit_proportion = visit_proportion  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponseBodyUrl500ListUrlList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow is not None:
            result['Flow'] = self.flow
        if self.flow_proportion is not None:
            result['FlowProportion'] = self.flow_proportion
        if self.url_detail is not None:
            result['UrlDetail'] = self.url_detail
        if self.visit_data is not None:
            result['VisitData'] = self.visit_data
        if self.visit_proportion is not None:
            result['VisitProportion'] = self.visit_proportion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Flow') is not None:
            self.flow = m.get('Flow')
        if m.get('FlowProportion') is not None:
            self.flow_proportion = m.get('FlowProportion')
        if m.get('UrlDetail') is not None:
            self.url_detail = m.get('UrlDetail')
        if m.get('VisitData') is not None:
            self.visit_data = m.get('VisitData')
        if m.get('VisitProportion') is not None:
            self.visit_proportion = m.get('VisitProportion')
        return self


class DescribeDcdnDomainTopUrlVisitResponseBodyUrl500List(TeaModel):
    def __init__(self, url_list=None):
        self.url_list = url_list  # type: list[DescribeDcdnDomainTopUrlVisitResponseBodyUrl500ListUrlList]

    def validate(self):
        if self.url_list:
            for k in self.url_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponseBodyUrl500List, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UrlList'] = []
        if self.url_list is not None:
            for k in self.url_list:
                result['UrlList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.url_list = []
        if m.get('UrlList') is not None:
            for k in m.get('UrlList'):
                temp_model = DescribeDcdnDomainTopUrlVisitResponseBodyUrl500ListUrlList()
                self.url_list.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainTopUrlVisitResponseBody(TeaModel):
    def __init__(self, all_url_list=None, domain_name=None, request_id=None, start_time=None, url_200list=None,
                 url_300list=None, url_400list=None, url_500list=None):
        # A list of frequently requested URLs.
        self.all_url_list = all_url_list  # type: DescribeDcdnDomainTopUrlVisitResponseBodyAllUrlList
        # The accelerated domain name for which the data was returned.
        self.domain_name = domain_name  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which the data was collected.
        self.start_time = start_time  # type: str
        # A list of URLs for which 2xx status codes were returned.
        self.url_200list = url_200list  # type: DescribeDcdnDomainTopUrlVisitResponseBodyUrl200List
        # A list of URLs for which 3xx status codes were returned.
        self.url_300list = url_300list  # type: DescribeDcdnDomainTopUrlVisitResponseBodyUrl300List
        # A list of URLs for which 4xx status codes were returned.
        self.url_400list = url_400list  # type: DescribeDcdnDomainTopUrlVisitResponseBodyUrl400List
        # A list of URLs for which 5xx status codes were returned.
        self.url_500list = url_500list  # type: DescribeDcdnDomainTopUrlVisitResponseBodyUrl500List

    def validate(self):
        if self.all_url_list:
            self.all_url_list.validate()
        if self.url_200list:
            self.url_200list.validate()
        if self.url_300list:
            self.url_300list.validate()
        if self.url_400list:
            self.url_400list.validate()
        if self.url_500list:
            self.url_500list.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_url_list is not None:
            result['AllUrlList'] = self.all_url_list.to_map()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.url_200list is not None:
            result['Url200List'] = self.url_200list.to_map()
        if self.url_300list is not None:
            result['Url300List'] = self.url_300list.to_map()
        if self.url_400list is not None:
            result['Url400List'] = self.url_400list.to_map()
        if self.url_500list is not None:
            result['Url500List'] = self.url_500list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllUrlList') is not None:
            temp_model = DescribeDcdnDomainTopUrlVisitResponseBodyAllUrlList()
            self.all_url_list = temp_model.from_map(m['AllUrlList'])
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Url200List') is not None:
            temp_model = DescribeDcdnDomainTopUrlVisitResponseBodyUrl200List()
            self.url_200list = temp_model.from_map(m['Url200List'])
        if m.get('Url300List') is not None:
            temp_model = DescribeDcdnDomainTopUrlVisitResponseBodyUrl300List()
            self.url_300list = temp_model.from_map(m['Url300List'])
        if m.get('Url400List') is not None:
            temp_model = DescribeDcdnDomainTopUrlVisitResponseBodyUrl400List()
            self.url_400list = temp_model.from_map(m['Url400List'])
        if m.get('Url500List') is not None:
            temp_model = DescribeDcdnDomainTopUrlVisitResponseBodyUrl500List()
            self.url_500list = temp_model.from_map(m['Url500List'])
        return self


class DescribeDcdnDomainTopUrlVisitResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainTopUrlVisitResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTopUrlVisitResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainTopUrlVisitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainTrafficDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 start_time=None):
        # The accelerated domain name.
        # 
        # Separate multiple domain names with commas (,). If you do not specify a value for this parameter, all accelerated domain names are queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # > The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time granularity for a query. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Usage notes**.
        self.interval = interval  # type: str
        # The name of the Internet service provider (ISP).
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(self, dynamic_http_traffic=None, dynamic_https_traffic=None, static_http_traffic=None,
                 static_https_traffic=None, time_stamp=None, traffic=None):
        # The network traffic that was consumed to deliver dynamic content over HTTP.
        self.dynamic_http_traffic = dynamic_http_traffic  # type: float
        # The network traffic that was consumed to deliver dynamic content over HTTPS.
        self.dynamic_https_traffic = dynamic_https_traffic  # type: float
        # The network traffic that was consumed to deliver static content over HTTP.
        self.static_http_traffic = static_http_traffic  # type: float
        # The network traffic that was consumed to deliver static content over HTTPS.
        self.static_https_traffic = static_https_traffic  # type: float
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str
        # The total amount of network traffic.
        self.traffic = traffic  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_http_traffic is not None:
            result['DynamicHttpTraffic'] = self.dynamic_http_traffic
        if self.dynamic_https_traffic is not None:
            result['DynamicHttpsTraffic'] = self.dynamic_https_traffic
        if self.static_http_traffic is not None:
            result['StaticHttpTraffic'] = self.static_http_traffic
        if self.static_https_traffic is not None:
            result['StaticHttpsTraffic'] = self.static_https_traffic
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.traffic is not None:
            result['Traffic'] = self.traffic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicHttpTraffic') is not None:
            self.dynamic_http_traffic = m.get('DynamicHttpTraffic')
        if m.get('DynamicHttpsTraffic') is not None:
            self.dynamic_https_traffic = m.get('DynamicHttpsTraffic')
        if m.get('StaticHttpTraffic') is not None:
            self.static_http_traffic = m.get('StaticHttpTraffic')
        if m.get('StaticHttpsTraffic') is not None:
            self.static_https_traffic = m.get('StaticHttpsTraffic')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Traffic') is not None:
            self.traffic = m.get('Traffic')
        return self


class DescribeDcdnDomainTrafficDataResponseBodyTrafficDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTrafficDataResponseBodyTrafficDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainTrafficDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, request_id=None, start_time=None,
                 traffic_data_per_interval=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str
        # The network traffic returned at each time interval. Unit: bytes.
        self.traffic_data_per_interval = traffic_data_per_interval  # type: DescribeDcdnDomainTrafficDataResponseBodyTrafficDataPerInterval

    def validate(self):
        if self.traffic_data_per_interval:
            self.traffic_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.traffic_data_per_interval is not None:
            result['TrafficDataPerInterval'] = self.traffic_data_per_interval.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TrafficDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainTrafficDataResponseBodyTrafficDataPerInterval()
            self.traffic_data_per_interval = temp_model.from_map(m['TrafficDataPerInterval'])
        return self


class DescribeDcdnDomainTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainTrafficDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainUsageDataRequest(TeaModel):
    def __init__(self, area=None, data_protocol=None, domain_name=None, end_time=None, field=None, interval=None,
                 start_time=None, type=None):
        # The billable region. Valid values:
        # 
        # *   **CN**: Chinese mainland
        # *   **OverSeas**: outside the Chinese mainland
        # *   **AP1**: Asia Pacific 1
        # *   **AP2**: Asia Pacific 2
        # *   **AP3**: Asia Pacific 3
        # *   **NA**: North America
        # *   **SA**: South America
        # *   **EU**: Europe
        # *   **MEAA**: Middle East and Africa
        # *   **all**: all the preceding billable regions
        # 
        # Default value: **CN**\
        self.area = area  # type: str
        # The protocol of the data that you want query. Valid values:
        # 
        # *   **quic**: Quick UDP Internet Connections (QUIC)
        # *   **https**: HTTPS
        # *   **http**: HTTP
        # *   **all**: HTTP, HTTPS, and QUIC
        # 
        # Default value: **all**\
        self.data_protocol = data_protocol  # type: str
        # The accelerated domain name. You can specify up to 100 domain names in each request. Separate multiple domain names with commas (,).
        # 
        # > If you do not specify this parameter, the usage data of all accelerated domain names that belong to your Alibaba Cloud account is returned.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # > The end time must be later than the start time. The maximum time range that can be queried is 31 days.
        self.end_time = end_time  # type: str
        # The type of data that you want to query. Valid values:
        # 
        # *   **bps**: bandwidth
        # *   **traf**: traffic
        # *   **acc**: requests
        # 
        # > If the value is set to **acc**, the **Area** parameter is not supported.
        self.field = field  # type: str
        # The time interval between the data entries to return. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Usage notes**.
        self.interval = interval  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # > The minimum time granularity at which the data is queried is 5 minutes.
        self.start_time = start_time  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainUsageDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.data_protocol is not None:
            result['DataProtocol'] = self.data_protocol
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.field is not None:
            result['Field'] = self.field
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('DataProtocol') is not None:
            self.data_protocol = m.get('DataProtocol')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDcdnDomainUsageDataResponseBodyUsageDataPerIntervalDataModule(TeaModel):
    def __init__(self, peak_time=None, special_value=None, time_stamp=None, value=None):
        # If the **Field** parameter in the request is set to **bps**, this parameter returns the time of the peak bandwidth value. Otherwise, this parameter returns the same value as the **TimeStamp** parameter.
        self.peak_time = peak_time  # type: str
        # The data usage in a specific scenario.
        # 
        # > SpecialValue indicates the data usage in a specific scenario. If no special billable item is specified, ignore this parameter.
        self.special_value = special_value  # type: str
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str
        # The amount of resource usage.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainUsageDataResponseBodyUsageDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.peak_time is not None:
            result['PeakTime'] = self.peak_time
        if self.special_value is not None:
            result['SpecialValue'] = self.special_value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PeakTime') is not None:
            self.peak_time = m.get('PeakTime')
        if m.get('SpecialValue') is not None:
            self.special_value = m.get('SpecialValue')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnDomainUsageDataResponseBodyUsageDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainUsageDataResponseBodyUsageDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainUsageDataResponseBodyUsageDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainUsageDataResponseBodyUsageDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainUsageDataResponseBody(TeaModel):
    def __init__(self, area=None, data_interval=None, domain_name=None, end_time=None, request_id=None,
                 start_time=None, type=None, usage_data_per_interval=None):
        # The billable region where the usage data was collected.
        self.area = area  # type: str
        # The time interval between the data entries. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str
        # The type of the content returned.
        self.type = type  # type: str
        # The network traffic that was collected at each interval.
        self.usage_data_per_interval = usage_data_per_interval  # type: DescribeDcdnDomainUsageDataResponseBodyUsageDataPerInterval

    def validate(self):
        if self.usage_data_per_interval:
            self.usage_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainUsageDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        if self.usage_data_per_interval is not None:
            result['UsageDataPerInterval'] = self.usage_data_per_interval.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UsageDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainUsageDataResponseBodyUsageDataPerInterval()
            self.usage_data_per_interval = temp_model.from_map(m['UsageDataPerInterval'])
        return self


class DescribeDcdnDomainUsageDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainUsageDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainUsageDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainUsageDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainUvDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, start_time=None):
        # The name of the accelerated domain. You can specify only one domain name.
        # 
        # By default, all the accelerated domains are queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainUvDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainUvDataResponseBodyUvDataIntervalUsageData(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str
        # The number of UVs.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainUvDataResponseBodyUvDataIntervalUsageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnDomainUvDataResponseBodyUvDataInterval(TeaModel):
    def __init__(self, usage_data=None):
        self.usage_data = usage_data  # type: list[DescribeDcdnDomainUvDataResponseBodyUvDataIntervalUsageData]

    def validate(self):
        if self.usage_data:
            for k in self.usage_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainUvDataResponseBodyUvDataInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UsageData'] = []
        if self.usage_data is not None:
            for k in self.usage_data:
                result['UsageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.usage_data = []
        if m.get('UsageData') is not None:
            for k in m.get('UsageData'):
                temp_model = DescribeDcdnDomainUvDataResponseBodyUvDataIntervalUsageData()
                self.usage_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainUvDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, request_id=None, start_time=None,
                 uv_data_interval=None):
        # The data collection interval. Unit: second.
        self.data_interval = data_interval  # type: str
        # The name of the accelerated domain for which the data was returned.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which the data was collected.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which the data was collected.
        self.start_time = start_time  # type: str
        # The number of UVs at each interval.
        self.uv_data_interval = uv_data_interval  # type: DescribeDcdnDomainUvDataResponseBodyUvDataInterval

    def validate(self):
        if self.uv_data_interval:
            self.uv_data_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainUvDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.uv_data_interval is not None:
            result['UvDataInterval'] = self.uv_data_interval.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('UvDataInterval') is not None:
            temp_model = DescribeDcdnDomainUvDataResponseBodyUvDataInterval()
            self.uv_data_interval = temp_model.from_map(m['UvDataInterval'])
        return self


class DescribeDcdnDomainUvDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainUvDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainUvDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainUvDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainWebsocketBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 start_time=None):
        # The accelerated domain name.
        # 
        # Separate multiple domain names with commas (,). If you do not specify a value for this parameter, all accelerated domain names are queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time interval between the data entries to return. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Description**.
        self.interval = interval  # type: str
        # The name of the Internet service provider (ISP).
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainWebsocketBpsDataResponseBodyBpsDataPerIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, websocket_bps=None):
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str
        # The bandwidth value. Unit: bit/s.
        self.websocket_bps = websocket_bps  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketBpsDataResponseBodyBpsDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.websocket_bps is not None:
            result['WebsocketBps'] = self.websocket_bps
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('WebsocketBps') is not None:
            self.websocket_bps = m.get('WebsocketBps')
        return self


class DescribeDcdnDomainWebsocketBpsDataResponseBodyBpsDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainWebsocketBpsDataResponseBodyBpsDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketBpsDataResponseBodyBpsDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainWebsocketBpsDataResponseBodyBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainWebsocketBpsDataResponseBody(TeaModel):
    def __init__(self, bps_data_per_interval=None, data_interval=None, domain_name=None, end_time=None,
                 request_id=None, start_time=None):
        # The bandwidth values returned at each interval.
        self.bps_data_per_interval = bps_data_per_interval  # type: DescribeDcdnDomainWebsocketBpsDataResponseBodyBpsDataPerInterval
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.bps_data_per_interval:
            self.bps_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps_data_per_interval is not None:
            result['BpsDataPerInterval'] = self.bps_data_per_interval.to_map()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BpsDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainWebsocketBpsDataResponseBodyBpsDataPerInterval()
            self.bps_data_per_interval = temp_model.from_map(m['BpsDataPerInterval'])
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainWebsocketBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainWebsocketBpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainWebsocketBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainWebsocketHttpCodeDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 start_time=None):
        # The accelerated domain name. Separate multiple accelerated domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time interval between the data entries to return. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Description**.
        self.interval = interval  # type: str
        # The name of the Internet service provider (ISP).
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketHttpCodeDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModuleWebsocketHttpCodeHttpCodeDataModule(TeaModel):
    def __init__(self, code=None, count=None, proportion=None):
        # The HTTP status code.
        self.code = code  # type: int
        # The total number of times that the HTTP status code was returned.
        self.count = count  # type: float
        # The proportion of the HTTP status code.
        self.proportion = proportion  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModuleWebsocketHttpCodeHttpCodeDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.count is not None:
            result['Count'] = self.count
        if self.proportion is not None:
            result['Proportion'] = self.proportion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Proportion') is not None:
            self.proportion = m.get('Proportion')
        return self


class DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModuleWebsocketHttpCode(TeaModel):
    def __init__(self, http_code_data_module=None):
        self.http_code_data_module = http_code_data_module  # type: list[DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModuleWebsocketHttpCodeHttpCodeDataModule]

    def validate(self):
        if self.http_code_data_module:
            for k in self.http_code_data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModuleWebsocketHttpCode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HttpCodeDataModule'] = []
        if self.http_code_data_module is not None:
            for k in self.http_code_data_module:
                result['HttpCodeDataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.http_code_data_module = []
        if m.get('HttpCodeDataModule') is not None:
            for k in m.get('HttpCodeDataModule'):
                temp_model = DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModuleWebsocketHttpCodeHttpCodeDataModule()
                self.http_code_data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, websocket_http_code=None):
        # The timestamp of the data returned.
        self.time_stamp = time_stamp  # type: str
        # The information about the HTTP status codes.
        self.websocket_http_code = websocket_http_code  # type: DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModuleWebsocketHttpCode

    def validate(self):
        if self.websocket_http_code:
            self.websocket_http_code.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.websocket_http_code is not None:
            result['WebsocketHttpCode'] = self.websocket_http_code.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('WebsocketHttpCode') is not None:
            temp_model = DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModuleWebsocketHttpCode()
            self.websocket_http_code = temp_model.from_map(m['WebsocketHttpCode'])
        return self


class DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainWebsocketHttpCodeDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, http_code_data_per_interval=None,
                 request_id=None, start_time=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The HTTP status codes.
        self.http_code_data_per_interval = http_code_data_per_interval  # type: DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerInterval
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.http_code_data_per_interval:
            self.http_code_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketHttpCodeDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.http_code_data_per_interval is not None:
            result['HttpCodeDataPerInterval'] = self.http_code_data_per_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('HttpCodeDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainWebsocketHttpCodeDataResponseBodyHttpCodeDataPerInterval()
            self.http_code_data_per_interval = temp_model.from_map(m['HttpCodeDataPerInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainWebsocketHttpCodeDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainWebsocketHttpCodeDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketHttpCodeDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainWebsocketHttpCodeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnDomainWebsocketTrafficDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 start_time=None):
        # The accelerated domain name.
        # 
        # Separate multiple domain names with commas (,). If you do not specify a value for this parameter, all accelerated domain names are queried.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC.
        # 
        # > The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The time granularity for a query. Unit: seconds.
        # 
        # The time granularity varies with the maximum time range per query. Valid values: 300 (5 minutes), 3600 (1 hour), and 86400 (1 day). For more information, see **Usage notes**.
        self.interval = interval  # type: str
        # The name of the ISP.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query ISPs.
        self.isp_name_en = isp_name_en  # type: str
        # The name of the region.
        # 
        # You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query regions.
        self.location_name_en = location_name_en  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnDomainWebsocketTrafficDataResponseBodyTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, websocket_traffic=None):
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str
        # The total volume of traffic.
        self.websocket_traffic = websocket_traffic  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketTrafficDataResponseBodyTrafficDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.websocket_traffic is not None:
            result['WebsocketTraffic'] = self.websocket_traffic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('WebsocketTraffic') is not None:
            self.websocket_traffic = m.get('WebsocketTraffic')
        return self


class DescribeDcdnDomainWebsocketTrafficDataResponseBodyTrafficDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDcdnDomainWebsocketTrafficDataResponseBodyTrafficDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketTrafficDataResponseBodyTrafficDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDcdnDomainWebsocketTrafficDataResponseBodyTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDcdnDomainWebsocketTrafficDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, request_id=None, start_time=None,
                 traffic_data_per_interval=None):
        # The time interval between the data entries returned. Unit: seconds.
        self.data_interval = data_interval  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The start of the time range during which data was queried.
        self.start_time = start_time  # type: str
        # The network traffic returned at each time interval. Unit: bytes.
        self.traffic_data_per_interval = traffic_data_per_interval  # type: DescribeDcdnDomainWebsocketTrafficDataResponseBodyTrafficDataPerInterval

    def validate(self):
        if self.traffic_data_per_interval:
            self.traffic_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.traffic_data_per_interval is not None:
            result['TrafficDataPerInterval'] = self.traffic_data_per_interval.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TrafficDataPerInterval') is not None:
            temp_model = DescribeDcdnDomainWebsocketTrafficDataResponseBodyTrafficDataPerInterval()
            self.traffic_data_per_interval = temp_model.from_map(m['TrafficDataPerInterval'])
        return self


class DescribeDcdnDomainWebsocketTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnDomainWebsocketTrafficDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnDomainWebsocketTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnDomainWebsocketTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnErUsageDataRequest(TeaModel):
    def __init__(self, end_time=None, routine_id=None, spec=None, split_by=None, start_time=None):
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The ID of the ER.
        self.routine_id = routine_id  # type: str
        # The specification of the ER. Valid values:
        # 
        # *   5ms
        # *   50ms
        # *   100ms
        self.spec = spec  # type: str
        # Specifies how the results are grouped. If you set this parameter to routine, the returned results are grouped based on the ER ID. If you set this parameter to spec, the returned results are grouped based on the ER specification.
        # 
        # >  If you leave this parameter empty, the returned results are not grouped.
        self.split_by = split_by  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnErUsageDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.routine_id is not None:
            result['RoutineID'] = self.routine_id
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.split_by is not None:
            result['SplitBy'] = self.split_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RoutineID') is not None:
            self.routine_id = m.get('RoutineID')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('SplitBy') is not None:
            self.split_by = m.get('SplitBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnErUsageDataResponseBodyErAccDataErAccItem(TeaModel):
    def __init__(self, er_acc=None, routine=None, spec=None, time_stamp=None):
        # The number of ER requests.
        self.er_acc = er_acc  # type: long
        # The ID of the ER. This parameter is returned only when SplitBy is set to routine.
        self.routine = routine  # type: str
        # The specification of the ER. This parameter is returned only when SplitBy is set to spec.
        self.spec = spec  # type: str
        # The timestamp of the returned data.
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnErUsageDataResponseBodyErAccDataErAccItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.er_acc is not None:
            result['ErAcc'] = self.er_acc
        if self.routine is not None:
            result['Routine'] = self.routine
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErAcc') is not None:
            self.er_acc = m.get('ErAcc')
        if m.get('Routine') is not None:
            self.routine = m.get('Routine')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDcdnErUsageDataResponseBodyErAccData(TeaModel):
    def __init__(self, er_acc_item=None):
        self.er_acc_item = er_acc_item  # type: list[DescribeDcdnErUsageDataResponseBodyErAccDataErAccItem]

    def validate(self):
        if self.er_acc_item:
            for k in self.er_acc_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnErUsageDataResponseBodyErAccData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ErAccItem'] = []
        if self.er_acc_item is not None:
            for k in self.er_acc_item:
                result['ErAccItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.er_acc_item = []
        if m.get('ErAccItem') is not None:
            for k in m.get('ErAccItem'):
                temp_model = DescribeDcdnErUsageDataResponseBodyErAccDataErAccItem()
                self.er_acc_item.append(temp_model.from_map(k))
        return self


class DescribeDcdnErUsageDataResponseBody(TeaModel):
    def __init__(self, end_time=None, er_acc_data=None, request_id=None, start_time=None):
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The list of the returned data.
        self.er_acc_data = er_acc_data  # type: DescribeDcdnErUsageDataResponseBodyErAccData
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.er_acc_data:
            self.er_acc_data.validate()

    def to_map(self):
        _map = super(DescribeDcdnErUsageDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.er_acc_data is not None:
            result['ErAccData'] = self.er_acc_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ErAccData') is not None:
            temp_model = DescribeDcdnErUsageDataResponseBodyErAccData()
            self.er_acc_data = temp_model.from_map(m['ErAccData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnErUsageDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnErUsageDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnErUsageDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnErUsageDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnHttpsDomainListRequest(TeaModel):
    def __init__(self, keyword=None, page_number=None, page_size=None):
        # The keyword used for search.
        self.keyword = keyword  # type: str
        # The number of pages to return. Valid values: **1 to 100000**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Valid values: **1 to 500**. Default value: **20**.
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnHttpsDomainListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDcdnHttpsDomainListResponseBodyCertInfosCertInfo(TeaModel):
    def __init__(self, cert_common_name=None, cert_expire_time=None, cert_name=None, cert_start_time=None,
                 cert_status=None, cert_type=None, cert_update_time=None, domain_name=None):
        # The returned primary domain name of the certificate.
        self.cert_common_name = cert_common_name  # type: str
        # The time when the certificate expires.
        self.cert_expire_time = cert_expire_time  # type: str
        # The name of the certificate.
        self.cert_name = cert_name  # type: str
        # The time when the certificate became effective.
        self.cert_start_time = cert_start_time  # type: str
        # The status of the certificate. Valid values:
        # 
        # *   **ok**: The certificate is working as expected.
        # *   **mismatch**: The certificate does not match the specified domain name.
        # *   **expired**: The certificate has expired.
        # *   **expire_soon**: The certificate is about to expire.
        self.cert_status = cert_status  # type: str
        # The type of the certificate. Valid values:
        # 
        # *   **free**: A free certificate.
        # *   **cas**: A certificate that is purchased through Alibaba Cloud SSL Certificates Service.
        # *   **upload**: A user-uploaded certificate.
        self.cert_type = cert_type  # type: str
        # The time when the certificate was updated.
        self.cert_update_time = cert_update_time  # type: str
        # The accelerated domain name for which the certificate information was queried.
        self.domain_name = domain_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnHttpsDomainListResponseBodyCertInfosCertInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_common_name is not None:
            result['CertCommonName'] = self.cert_common_name
        if self.cert_expire_time is not None:
            result['CertExpireTime'] = self.cert_expire_time
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cert_start_time is not None:
            result['CertStartTime'] = self.cert_start_time
        if self.cert_status is not None:
            result['CertStatus'] = self.cert_status
        if self.cert_type is not None:
            result['CertType'] = self.cert_type
        if self.cert_update_time is not None:
            result['CertUpdateTime'] = self.cert_update_time
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertCommonName') is not None:
            self.cert_common_name = m.get('CertCommonName')
        if m.get('CertExpireTime') is not None:
            self.cert_expire_time = m.get('CertExpireTime')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('CertStartTime') is not None:
            self.cert_start_time = m.get('CertStartTime')
        if m.get('CertStatus') is not None:
            self.cert_status = m.get('CertStatus')
        if m.get('CertType') is not None:
            self.cert_type = m.get('CertType')
        if m.get('CertUpdateTime') is not None:
            self.cert_update_time = m.get('CertUpdateTime')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeDcdnHttpsDomainListResponseBodyCertInfos(TeaModel):
    def __init__(self, cert_info=None):
        self.cert_info = cert_info  # type: list[DescribeDcdnHttpsDomainListResponseBodyCertInfosCertInfo]

    def validate(self):
        if self.cert_info:
            for k in self.cert_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnHttpsDomainListResponseBodyCertInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CertInfo'] = []
        if self.cert_info is not None:
            for k in self.cert_info:
                result['CertInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cert_info = []
        if m.get('CertInfo') is not None:
            for k in m.get('CertInfo'):
                temp_model = DescribeDcdnHttpsDomainListResponseBodyCertInfosCertInfo()
                self.cert_info.append(temp_model.from_map(k))
        return self


class DescribeDcdnHttpsDomainListResponseBody(TeaModel):
    def __init__(self, cert_infos=None, request_id=None, total_count=None):
        # The certificate information about the domain name.
        self.cert_infos = cert_infos  # type: DescribeDcdnHttpsDomainListResponseBodyCertInfos
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.cert_infos:
            self.cert_infos.validate()

    def to_map(self):
        _map = super(DescribeDcdnHttpsDomainListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_infos is not None:
            result['CertInfos'] = self.cert_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertInfos') is not None:
            temp_model = DescribeDcdnHttpsDomainListResponseBodyCertInfos()
            self.cert_infos = temp_model.from_map(m['CertInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnHttpsDomainListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnHttpsDomainListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnHttpsDomainListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnHttpsDomainListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnIpInfoRequest(TeaModel):
    def __init__(self, ip=None):
        # The IP address. You can specify only one IP address.
        self.ip = ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnIpInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['IP'] = self.ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        return self


class DescribeDcdnIpInfoResponseBody(TeaModel):
    def __init__(self, dcdn_ip=None, isp=None, isp_ename=None, region=None, region_ename=None, request_id=None):
        # Indicates whether the specified IP address is assigned to an Alibaba Cloud DCDN node.
        # 
        # *   True: The specified IP address is assigned to an Alibaba Cloud DCDN node.
        # *   False: The specified IP address is not assigned to an Alibaba Cloud DCDN node.
        self.dcdn_ip = dcdn_ip  # type: str
        # The Internet service provider (ISP) to which the specified IP address belongs.
        self.isp = isp  # type: str
        # The name of the ISP.
        self.isp_ename = isp_ename  # type: str
        # The region to which the specified IP address belongs.
        self.region = region  # type: str
        # The name of the region.
        self.region_ename = region_ename  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnIpInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dcdn_ip is not None:
            result['DcdnIp'] = self.dcdn_ip
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.isp_ename is not None:
            result['IspEname'] = self.isp_ename
        if self.region is not None:
            result['Region'] = self.region
        if self.region_ename is not None:
            result['RegionEname'] = self.region_ename
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DcdnIp') is not None:
            self.dcdn_ip = m.get('DcdnIp')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('IspEname') is not None:
            self.isp_ename = m.get('IspEname')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionEname') is not None:
            self.region_ename = m.get('RegionEname')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnIpInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnIpInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnIpInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnIpaDomainConfigsRequest(TeaModel):
    def __init__(self, domain_name=None, function_names=None, owner_id=None, security_token=None):
        # The accelerated domain names. Separate multiple domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The name of the feature. Only the protogw value is supported, which indicates IP Application Accelerator (IPA).
        self.function_names = function_names  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.function_names is not None:
            result['FunctionNames'] = self.function_names
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('FunctionNames') is not None:
            self.function_names = m.get('FunctionNames')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg(TeaModel):
    def __init__(self, arg_name=None, arg_value=None):
        # The name of the configuration.
        self.arg_name = arg_name  # type: str
        # The value of the configuration.
        self.arg_value = arg_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg_name is not None:
            result['ArgName'] = self.arg_name
        if self.arg_value is not None:
            result['ArgValue'] = self.arg_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArgName') is not None:
            self.arg_name = m.get('ArgName')
        if m.get('ArgValue') is not None:
            self.arg_value = m.get('ArgValue')
        return self


class DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs(TeaModel):
    def __init__(self, function_arg=None):
        self.function_arg = function_arg  # type: list[DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg]

    def validate(self):
        if self.function_arg:
            for k in self.function_arg:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FunctionArg'] = []
        if self.function_arg is not None:
            for k in self.function_arg:
                result['FunctionArg'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.function_arg = []
        if m.get('FunctionArg') is not None:
            for k in m.get('FunctionArg'):
                temp_model = DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg()
                self.function_arg.append(temp_model.from_map(k))
        return self


class DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfig(TeaModel):
    def __init__(self, config_id=None, function_args=None, function_name=None, status=None):
        # The ID of the configuration.
        self.config_id = config_id  # type: str
        # The list of features.
        self.function_args = function_args  # type: DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs
        # The name of the feature.
        self.function_name = function_name  # type: str
        # The configuration status of the feature. Valid values:
        # 
        # *   **success**\
        # *   **testing**\
        # *   **failed**\
        # *   **configuring**\
        self.status = status  # type: str

    def validate(self):
        if self.function_args:
            self.function_args.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.function_args is not None:
            result['FunctionArgs'] = self.function_args.to_map()
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('FunctionArgs') is not None:
            temp_model = DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs()
            self.function_args = temp_model.from_map(m['FunctionArgs'])
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigs(TeaModel):
    def __init__(self, domain_config=None):
        self.domain_config = domain_config  # type: list[DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfig]

    def validate(self):
        if self.domain_config:
            for k in self.domain_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainConfig'] = []
        if self.domain_config is not None:
            for k in self.domain_config:
                result['DomainConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_config = []
        if m.get('DomainConfig') is not None:
            for k in m.get('DomainConfig'):
                temp_model = DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigsDomainConfig()
                self.domain_config.append(temp_model.from_map(k))
        return self


class DescribeDcdnIpaDomainConfigsResponseBody(TeaModel):
    def __init__(self, domain_configs=None, request_id=None):
        # The configurations of the domain name.
        self.domain_configs = domain_configs  # type: DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigs
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_configs:
            self.domain_configs.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_configs is not None:
            result['DomainConfigs'] = self.domain_configs.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainConfigs') is not None:
            temp_model = DescribeDcdnIpaDomainConfigsResponseBodyDomainConfigs()
            self.domain_configs = temp_model.from_map(m['DomainConfigs'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnIpaDomainConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnIpaDomainConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnIpaDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnIpaDomainDetailRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        # The accelerated domain names for which you want to query basic information. You can specify only one domain name in each request.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnIpaDomainDetailResponseBodyDomainDetailSourcesSource(TeaModel):
    def __init__(self, content=None, enabled=None, port=None, priority=None, type=None, weight=None):
        # The address of the origin server.
        self.content = content  # type: str
        # The status of the origin server.
        self.enabled = enabled  # type: str
        # The custom port. Valid values: **0** to **65535**.
        self.port = port  # type: int
        # The priority of the origin server if multiple origin servers are specified.
        self.priority = priority  # type: str
        # The type of the origin server. Valid values:
        # 
        # *   **ipaddr**: an IP address.
        # *   **domain**: a domain name.
        # *   **oss**: Object Storage Service (OSS) buckets are not supported.
        self.type = type  # type: str
        # The weight of the origin server if multiple origin servers are specified.
        self.weight = weight  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainDetailResponseBodyDomainDetailSourcesSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.type is not None:
            result['Type'] = self.type
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeDcdnIpaDomainDetailResponseBodyDomainDetailSources(TeaModel):
    def __init__(self, source=None):
        self.source = source  # type: list[DescribeDcdnIpaDomainDetailResponseBodyDomainDetailSourcesSource]

    def validate(self):
        if self.source:
            for k in self.source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainDetailResponseBodyDomainDetailSources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Source'] = []
        if self.source is not None:
            for k in self.source:
                result['Source'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.source = []
        if m.get('Source') is not None:
            for k in m.get('Source'):
                temp_model = DescribeDcdnIpaDomainDetailResponseBodyDomainDetailSourcesSource()
                self.source.append(temp_model.from_map(k))
        return self


class DescribeDcdnIpaDomainDetailResponseBodyDomainDetail(TeaModel):
    def __init__(self, cert_name=None, cname=None, description=None, domain_name=None, domain_status=None,
                 gmt_created=None, gmt_modified=None, resource_group_id=None, sslprotocol=None, sslpub=None, scope=None,
                 sources=None):
        # Indicates the name of the certificate if the HTTPS protocol is enabled.
        self.cert_name = cert_name  # type: str
        # The CNAME assigned to the domain name.
        self.cname = cname  # type: str
        # The description.
        self.description = description  # type: str
        # The accelerated domain names.
        self.domain_name = domain_name  # type: str
        # The status of the accelerated domain name. Valid values:
        # 
        # *   **online**: The domain name is enabled.
        # *   **offline**: The domain name is disabled.
        # *   **configuring**: The domain name is being configured.
        # *   **configure_failed**: The domain name failed to be configured.
        # *   **checking**: The domain name is under review.
        # *   **check_failed**: The domain name failed the review.
        self.domain_status = domain_status  # type: str
        # The time when the accelerated domain name was created.
        self.gmt_created = gmt_created  # type: str
        # The time when the accelerated domain name was last modified.
        self.gmt_modified = gmt_modified  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # Indicates whether the Security Socket Layer (SSL) certificate is enabled. Valid values:
        # 
        # *   **on**: The SSL certificate is enabled.
        # *   **off**: The SSL certificate is disabled.
        self.sslprotocol = sslprotocol  # type: str
        # Indicates the public key of the certificate if the HTTPS protocol is enabled.
        self.sslpub = sslpub  # type: str
        # The accelerated region. Valid values:
        # 
        # *   domestic: Chinese mainland
        # *   overseas: global (excluding the Chinese mainland)
        # *   global: global
        self.scope = scope  # type: str
        # The information about the origin server.
        self.sources = sources  # type: DescribeDcdnIpaDomainDetailResponseBodyDomainDetailSources

    def validate(self):
        if self.sources:
            self.sources.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainDetailResponseBodyDomainDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.sslpub is not None:
            result['SSLPub'] = self.sslpub
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.sources is not None:
            result['Sources'] = self.sources.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('SSLPub') is not None:
            self.sslpub = m.get('SSLPub')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('Sources') is not None:
            temp_model = DescribeDcdnIpaDomainDetailResponseBodyDomainDetailSources()
            self.sources = temp_model.from_map(m['Sources'])
        return self


class DescribeDcdnIpaDomainDetailResponseBody(TeaModel):
    def __init__(self, domain_detail=None, request_id=None):
        # The details about the accelerated domain name.
        self.domain_detail = domain_detail  # type: DescribeDcdnIpaDomainDetailResponseBodyDomainDetail
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_detail:
            self.domain_detail.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_detail is not None:
            result['DomainDetail'] = self.domain_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainDetail') is not None:
            temp_model = DescribeDcdnIpaDomainDetailResponseBodyDomainDetail()
            self.domain_detail = temp_model.from_map(m['DomainDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnIpaDomainDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnIpaDomainDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaDomainDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnIpaDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnIpaServiceRequest(TeaModel):
    def __init__(self, owner_id=None, security_token=None):
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnIpaServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnIpaServiceResponseBodyOperationLocksLockReason(TeaModel):
    def __init__(self, lock_reason=None):
        # The reason why the IPA service was locked. A value of **financial** indicates that your account has an overdue payment.
        self.lock_reason = lock_reason  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnIpaServiceResponseBodyOperationLocksLockReason, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        return self


class DescribeDcdnIpaServiceResponseBodyOperationLocks(TeaModel):
    def __init__(self, lock_reason=None):
        self.lock_reason = lock_reason  # type: list[DescribeDcdnIpaServiceResponseBodyOperationLocksLockReason]

    def validate(self):
        if self.lock_reason:
            for k in self.lock_reason:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaServiceResponseBodyOperationLocks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LockReason'] = []
        if self.lock_reason is not None:
            for k in self.lock_reason:
                result['LockReason'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.lock_reason = []
        if m.get('LockReason') is not None:
            for k in m.get('LockReason'):
                temp_model = DescribeDcdnIpaServiceResponseBodyOperationLocksLockReason()
                self.lock_reason.append(temp_model.from_map(k))
        return self


class DescribeDcdnIpaServiceResponseBody(TeaModel):
    def __init__(self, changing_affect_time=None, changing_charge_type=None, instance_id=None,
                 internet_charge_type=None, opening_time=None, operation_locks=None, request_id=None):
        # The time when the change of the billing method starts to take effect. The time is in GMT. This time appears on the frontend only when it is later than the current time.
        self.changing_affect_time = changing_affect_time  # type: str
        # The new billing method to take effect. Valid values:
        # 
        # *   **PayByTraffic**\
        # *   **PayByBandwidth**\
        # *   **PayByBandwidth95**\
        # *   **PayByBandwidth_monthavg**\
        # *   **PayByBandwidth_month4th**\
        # *   **PayByBandwidth_monthday95avg**\
        # *   **PayByBandwidth_nighthalf95**\
        self.changing_charge_type = changing_charge_type  # type: str
        # The ID of the instance.
        self.instance_id = instance_id  # type: str
        # The current billing method. Valid values:
        # 
        # *   **PayByTraffic**\
        # *   **PayByBandwidth**\
        # *   **PayByBandwidth95**\
        # *   **PayByBandwidth_monthavg**\
        # *   **PayByBandwidth_month4th**\
        # *   **PayByBandwidth_monthday95avg**\
        # *   **PayByBandwidth_nighthalf95**\
        self.internet_charge_type = internet_charge_type  # type: str
        # The time when the IPA service was activated. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mmZ format.
        self.opening_time = opening_time  # type: str
        # The lock status of the IPA service.
        self.operation_locks = operation_locks  # type: DescribeDcdnIpaServiceResponseBodyOperationLocks
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.operation_locks:
            self.operation_locks.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.changing_affect_time is not None:
            result['ChangingAffectTime'] = self.changing_affect_time
        if self.changing_charge_type is not None:
            result['ChangingChargeType'] = self.changing_charge_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.opening_time is not None:
            result['OpeningTime'] = self.opening_time
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChangingAffectTime') is not None:
            self.changing_affect_time = m.get('ChangingAffectTime')
        if m.get('ChangingChargeType') is not None:
            self.changing_charge_type = m.get('ChangingChargeType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('OpeningTime') is not None:
            self.opening_time = m.get('OpeningTime')
        if m.get('OperationLocks') is not None:
            temp_model = DescribeDcdnIpaServiceResponseBodyOperationLocks()
            self.operation_locks = temp_model.from_map(m['OperationLocks'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnIpaServiceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnIpaServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnIpaServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnIpaUserDomainsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key. Valid values of N: 1 to 20. You can call the TagDcdnResources operation to set a tag for a domain name.
        self.key = key  # type: str
        # The tag value. Valid values of N: 1 to 20.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnIpaUserDomainsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnIpaUserDomainsRequest(TeaModel):
    def __init__(self, check_domain_show=None, domain_name=None, domain_search_type=None, domain_status=None,
                 func_filter=None, func_id=None, owner_id=None, page_number=None, page_size=None, resource_group_id=None,
                 tag=None):
        # Specifies whether to display domain names that are under review, failed the review, or failed to be configured. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.check_domain_show = check_domain_show  # type: bool
        # The domain name that is used as a keyword to filter domain names. Fuzzy match is supported.
        self.domain_name = domain_name  # type: str
        # The search method. Default value: full_match. Valid values:
        # 
        # *   **fuzzy_match**: fuzzy match
        # *   **pre_match**: prefix match
        # *   **suf_match**: suffix match
        # *   **full_match**: exact match
        self.domain_search_type = domain_search_type  # type: str
        # The status of the domain name. Valid values:
        # 
        # *   **online**: enabled
        # *   **offline**: disabled
        # *   **configuring**: configuring
        # *   **configure_failed**: configuration failed
        # *   **checking**: reviewing
        # *   **check_failed**: review failed
        self.domain_status = domain_status  # type: str
        # The status of the feature.
        # 
        # *   config: The feature is enabled.
        # *   unconfig: The feature is not enabled.
        self.func_filter = func_filter  # type: str
        # The ID of the feature. For example, a value of 7 specifies the feature of configuring an expiration rule for a specific directory. For more information about feature IDs, see [Parameters for configuring features for domain names](~~410622~~).
        self.func_id = func_id  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Valid values: **1** to **100000**.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of domain names to return on each page. Default value: **20**. Maximum value: **500**.
        # 
        # Valid values: an integer from **1** to **500**.
        self.page_size = page_size  # type: int
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.tag = tag  # type: list[DescribeDcdnIpaUserDomainsRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaUserDomainsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_domain_show is not None:
            result['CheckDomainShow'] = self.check_domain_show
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_search_type is not None:
            result['DomainSearchType'] = self.domain_search_type
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        if self.func_filter is not None:
            result['FuncFilter'] = self.func_filter
        if self.func_id is not None:
            result['FuncId'] = self.func_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckDomainShow') is not None:
            self.check_domain_show = m.get('CheckDomainShow')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainSearchType') is not None:
            self.domain_search_type = m.get('DomainSearchType')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        if m.get('FuncFilter') is not None:
            self.func_filter = m.get('FuncFilter')
        if m.get('FuncId') is not None:
            self.func_id = m.get('FuncId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDcdnIpaUserDomainsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDcdnIpaUserDomainsResponseBodyDomainsPageDataSourcesSource(TeaModel):
    def __init__(self, content=None, port=None, priority=None, type=None, weight=None):
        # The address of the origin server.
        self.content = content  # type: str
        # The port of the origin server.
        self.port = port  # type: int
        # The priority of the origin server.
        self.priority = priority  # type: str
        # The type of the origin server.
        self.type = type  # type: str
        # The weight of the origin server if multiple origin servers have been specified.
        self.weight = weight  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnIpaUserDomainsResponseBodyDomainsPageDataSourcesSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.type is not None:
            result['Type'] = self.type
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeDcdnIpaUserDomainsResponseBodyDomainsPageDataSources(TeaModel):
    def __init__(self, source=None):
        self.source = source  # type: list[DescribeDcdnIpaUserDomainsResponseBodyDomainsPageDataSourcesSource]

    def validate(self):
        if self.source:
            for k in self.source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaUserDomainsResponseBodyDomainsPageDataSources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Source'] = []
        if self.source is not None:
            for k in self.source:
                result['Source'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.source = []
        if m.get('Source') is not None:
            for k in m.get('Source'):
                temp_model = DescribeDcdnIpaUserDomainsResponseBodyDomainsPageDataSourcesSource()
                self.source.append(temp_model.from_map(k))
        return self


class DescribeDcdnIpaUserDomainsResponseBodyDomainsPageData(TeaModel):
    def __init__(self, cname=None, description=None, domain_name=None, domain_status=None, gmt_created=None,
                 gmt_modified=None, resource_group_id=None, sslprotocol=None, sandbox=None, sources=None):
        # The CNAME assigned to the accelerated domain name.
        self.cname = cname  # type: str
        # The reason why the accelerated domain name failed the review.
        self.description = description  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The status of the accelerated domain name. Valid values:
        # 
        # *   **online**: enabled
        # *   **offline**: disabled
        # *   **configuring**: configuring
        # *   **configure_failed**: configuration failed
        # *   **checking**: reviewing
        # *   **check_failed**: review failed
        self.domain_status = domain_status  # type: str
        # The time when the accelerated domain name was added to Alibaba Cloud Dynamic Route for CDN (DCDN).
        self.gmt_created = gmt_created  # type: str
        # The time when the accelerated domain name was modified.
        self.gmt_modified = gmt_modified  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # The status of HTTPS.
        # 
        # *   **on**\
        # *   **off**\
        self.sslprotocol = sslprotocol  # type: str
        # Indicates whether the accelerated domain name was in a sandbox.
        self.sandbox = sandbox  # type: str
        # The information about the origin server.
        self.sources = sources  # type: DescribeDcdnIpaUserDomainsResponseBodyDomainsPageDataSources

    def validate(self):
        if self.sources:
            self.sources.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaUserDomainsResponseBodyDomainsPageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.sandbox is not None:
            result['Sandbox'] = self.sandbox
        if self.sources is not None:
            result['Sources'] = self.sources.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('Sandbox') is not None:
            self.sandbox = m.get('Sandbox')
        if m.get('Sources') is not None:
            temp_model = DescribeDcdnIpaUserDomainsResponseBodyDomainsPageDataSources()
            self.sources = temp_model.from_map(m['Sources'])
        return self


class DescribeDcdnIpaUserDomainsResponseBodyDomains(TeaModel):
    def __init__(self, page_data=None):
        self.page_data = page_data  # type: list[DescribeDcdnIpaUserDomainsResponseBodyDomainsPageData]

    def validate(self):
        if self.page_data:
            for k in self.page_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaUserDomainsResponseBodyDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PageData'] = []
        if self.page_data is not None:
            for k in self.page_data:
                result['PageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.page_data = []
        if m.get('PageData') is not None:
            for k in m.get('PageData'):
                temp_model = DescribeDcdnIpaUserDomainsResponseBodyDomainsPageData()
                self.page_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnIpaUserDomainsResponseBody(TeaModel):
    def __init__(self, domains=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The array that consists of multiple PageData parameters. The details about each accelerated domain name are included in a separate PageData parameter.
        self.domains = domains  # type: DescribeDcdnIpaUserDomainsResponseBodyDomains
        # The number of the returned page.
        self.page_number = page_number  # type: long
        # The number of domain names returned per page.
        self.page_size = page_size  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of domain names returned.
        self.total_count = total_count  # type: long

    def validate(self):
        if self.domains:
            self.domains.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaUserDomainsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['Domains'] = self.domains.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Domains') is not None:
            temp_model = DescribeDcdnIpaUserDomainsResponseBodyDomains()
            self.domains = temp_model.from_map(m['Domains'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnIpaUserDomainsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnIpaUserDomainsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnIpaUserDomainsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnIpaUserDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnL2VipsRequest(TeaModel):
    def __init__(self, domain_name=None):
        self.domain_name = domain_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnL2VipsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeDcdnL2VipsResponseBody(TeaModel):
    def __init__(self, domain_name=None, request_id=None, vips=None):
        self.domain_name = domain_name  # type: str
        self.request_id = request_id  # type: str
        self.vips = vips  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnL2VipsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vips is not None:
            result['Vips'] = self.vips
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Vips') is not None:
            self.vips = m.get('Vips')
        return self


class DescribeDcdnL2VipsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnL2VipsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnL2VipsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnL2VipsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnRealTimeDeliveryFieldRequest(TeaModel):
    def __init__(self, business_type=None):
        # The type of the collected logs. Default value: cdn_log_access_l1. Valid values:
        # 
        # *   **cdn_log_access_l1**: access logs of L1 Dynamic Route for CDN (DCDN) nodes
        # *   **cdn_log_origin**: back-to-origin logs
        # *   **cdn_log_er**: EdgeRoutine logs
        self.business_type = business_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnRealTimeDeliveryFieldRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        return self


class DescribeDcdnRealTimeDeliveryFieldResponseBodyContentFields(TeaModel):
    def __init__(self, description=None, field_name=None):
        # The description of the field.
        self.description = description  # type: str
        # The name of the field. For more information about the fields in real-time log entries, see [Fields in a real-time log](~~324199~~).
        self.field_name = field_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnRealTimeDeliveryFieldResponseBodyContentFields, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        return self


class DescribeDcdnRealTimeDeliveryFieldResponseBodyContent(TeaModel):
    def __init__(self, fields=None):
        self.fields = fields  # type: list[DescribeDcdnRealTimeDeliveryFieldResponseBodyContentFields]

    def validate(self):
        if self.fields:
            for k in self.fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnRealTimeDeliveryFieldResponseBodyContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Fields'] = []
        if self.fields is not None:
            for k in self.fields:
                result['Fields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fields = []
        if m.get('Fields') is not None:
            for k in m.get('Fields'):
                temp_model = DescribeDcdnRealTimeDeliveryFieldResponseBodyContentFields()
                self.fields.append(temp_model.from_map(k))
        return self


class DescribeDcdnRealTimeDeliveryFieldResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The returned results.
        self.content = content  # type: DescribeDcdnRealTimeDeliveryFieldResponseBodyContent
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super(DescribeDcdnRealTimeDeliveryFieldResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = DescribeDcdnRealTimeDeliveryFieldResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnRealTimeDeliveryFieldResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnRealTimeDeliveryFieldResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnRealTimeDeliveryFieldResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnRealTimeDeliveryFieldResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnRefreshQuotaRequest(TeaModel):
    def __init__(self, owner_id=None, security_token=None):
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnRefreshQuotaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnRefreshQuotaResponseBody(TeaModel):
    def __init__(self, block_quota=None, block_remain=None, dir_quota=None, dir_remain=None,
                 ignore_params_quota=None, ignore_params_remain=None, preload_quota=None, preload_remain=None, regex_quota=None,
                 regex_remain=None, request_id=None, url_quota=None, url_remain=None):
        # The maximum number of URLs that can be blocked.
        self.block_quota = block_quota  # type: str
        # The remaining number of URLs that can be blocked each day.
        self.block_remain = block_remain  # type: str
        # The maximum number of directories that can be refreshed each day.
        self.dir_quota = dir_quota  # type: str
        # The remaining number of directories that can be refreshed each day.
        self.dir_remain = dir_remain  # type: str
        self.ignore_params_quota = ignore_params_quota  # type: str
        self.ignore_params_remain = ignore_params_remain  # type: str
        # The maximum number of URLs that can be prefetched each day.
        self.preload_quota = preload_quota  # type: str
        # The remaining number of URLs that can be prefetched each day.
        self.preload_remain = preload_remain  # type: str
        # The maximum number of URLs or directories that can be refreshed by using regular expressions each day.
        self.regex_quota = regex_quota  # type: str
        # The remaining number of URLs or directories that can be refreshed by using regular expressions each day.
        self.regex_remain = regex_remain  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The maximum number of URLs that can be refreshed each day.
        self.url_quota = url_quota  # type: str
        # The remaining number of URLs that can be refreshed each day.
        self.url_remain = url_remain  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnRefreshQuotaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_quota is not None:
            result['BlockQuota'] = self.block_quota
        if self.block_remain is not None:
            result['BlockRemain'] = self.block_remain
        if self.dir_quota is not None:
            result['DirQuota'] = self.dir_quota
        if self.dir_remain is not None:
            result['DirRemain'] = self.dir_remain
        if self.ignore_params_quota is not None:
            result['IgnoreParamsQuota'] = self.ignore_params_quota
        if self.ignore_params_remain is not None:
            result['IgnoreParamsRemain'] = self.ignore_params_remain
        if self.preload_quota is not None:
            result['PreloadQuota'] = self.preload_quota
        if self.preload_remain is not None:
            result['PreloadRemain'] = self.preload_remain
        if self.regex_quota is not None:
            result['RegexQuota'] = self.regex_quota
        if self.regex_remain is not None:
            result['RegexRemain'] = self.regex_remain
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.url_quota is not None:
            result['UrlQuota'] = self.url_quota
        if self.url_remain is not None:
            result['UrlRemain'] = self.url_remain
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlockQuota') is not None:
            self.block_quota = m.get('BlockQuota')
        if m.get('BlockRemain') is not None:
            self.block_remain = m.get('BlockRemain')
        if m.get('DirQuota') is not None:
            self.dir_quota = m.get('DirQuota')
        if m.get('DirRemain') is not None:
            self.dir_remain = m.get('DirRemain')
        if m.get('IgnoreParamsQuota') is not None:
            self.ignore_params_quota = m.get('IgnoreParamsQuota')
        if m.get('IgnoreParamsRemain') is not None:
            self.ignore_params_remain = m.get('IgnoreParamsRemain')
        if m.get('PreloadQuota') is not None:
            self.preload_quota = m.get('PreloadQuota')
        if m.get('PreloadRemain') is not None:
            self.preload_remain = m.get('PreloadRemain')
        if m.get('RegexQuota') is not None:
            self.regex_quota = m.get('RegexQuota')
        if m.get('RegexRemain') is not None:
            self.regex_remain = m.get('RegexRemain')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UrlQuota') is not None:
            self.url_quota = m.get('UrlQuota')
        if m.get('UrlRemain') is not None:
            self.url_remain = m.get('UrlRemain')
        return self


class DescribeDcdnRefreshQuotaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnRefreshQuotaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnRefreshQuotaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnRefreshQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnRefreshTaskByIdRequest(TeaModel):
    def __init__(self, task_id=None):
        # The ID of the task that you want to query. You can query task IDs by performing the following operations:
        # 
        # *   Perform the [RefreshDcdnObjectCaches](~~130620~~) operation to query refresh task IDs.
        # *   Perform the [PreloadDcdnObjectCaches](~~130636~~) operation to query prefetch task IDs.
        # 
        # >  You can specify at most 10 task IDs in each call. Separate IDs with commas (,).
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnRefreshTaskByIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeDcdnRefreshTaskByIdResponseBodyTasks(TeaModel):
    def __init__(self, creation_time=None, description=None, object_path=None, object_type=None, process=None,
                 status=None, task_id=None):
        # The time when the task was created. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The error returned when the refresh or prefetch task failed. Valid values:
        # 
        # *   **Internal Error**: An internal error occurred.
        # *   **Origin Timeout**: The response from the origin server timed out.
        # *   **Origin Return StatusCode 5XX**: The origin server returned an HTTP 5xx status code.
        self.description = description  # type: str
        # The path of the refresh or prefetch object.
        self.object_path = object_path  # type: str
        # The type of the refresh or prefetch task. Valid values:
        # 
        # *   **file**: refreshes an individual file.
        # *   **directory**: refreshes files under a specified directory.
        # *   **preload**: prefetches an individual file.
        self.object_type = object_type  # type: str
        # The progress of the task, in percentage.
        self.process = process  # type: str
        # The status of the task. Valid values:
        # 
        # *   **Complete**: The task has completed.
        # *   **Pending**: The task is pending.
        # *   **Refreshing**: The task is in progress.
        # *   **Failed**: The task has failed.
        self.status = status  # type: str
        # The ID of the task.
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnRefreshTaskByIdResponseBodyTasks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.object_path is not None:
            result['ObjectPath'] = self.object_path
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.process is not None:
            result['Process'] = self.process
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ObjectPath') is not None:
            self.object_path = m.get('ObjectPath')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('Process') is not None:
            self.process = m.get('Process')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeDcdnRefreshTaskByIdResponseBody(TeaModel):
    def __init__(self, request_id=None, tasks=None, total_count=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # A list of prefetch or refresh tasks.
        self.tasks = tasks  # type: list[DescribeDcdnRefreshTaskByIdResponseBodyTasks]
        # The total number of tasks.
        self.total_count = total_count  # type: long

    def validate(self):
        if self.tasks:
            for k in self.tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnRefreshTaskByIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tasks'] = []
        if self.tasks is not None:
            for k in self.tasks:
                result['Tasks'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tasks = []
        if m.get('Tasks') is not None:
            for k in m.get('Tasks'):
                temp_model = DescribeDcdnRefreshTaskByIdResponseBodyTasks()
                self.tasks.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnRefreshTaskByIdResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnRefreshTaskByIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnRefreshTaskByIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnRefreshTaskByIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnRefreshTasksRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, object_path=None, object_type=None, owner_id=None,
                 page_number=None, page_size=None, security_token=None, start_time=None, status=None, task_id=None):
        # The accelerated domain name. You can specify only one domain name in each call.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The path of the object. The path is used as a condition for exact matching.
        self.object_path = object_path  # type: str
        # The type of the task.
        # 
        # *   **file**: URL-based refresh
        # *   **directory**: directory-based refresh
        # *   **preload**: URL-based prefetch
        # 
        # If you set the **DomainName** or **Status** parameter, you must also set this parameter.
        self.object_type = object_type  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Valid values: **1** to **100000**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **20**. Maximum value: **50**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.security_token = security_token  # type: str
        # The start of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str
        # The status of the task.
        # 
        # *   **Complete**: The task has completed.
        # *   **Refreshing**: The task is in progress.
        # *   **Failed**: The task failed.
        self.status = status  # type: str
        # The ID of the task. A task ID is assigned when you create a refresh or prefetch task.
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnRefreshTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.object_path is not None:
            result['ObjectPath'] = self.object_path
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ObjectPath') is not None:
            self.object_path = m.get('ObjectPath')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeDcdnRefreshTasksResponseBodyTasksTask(TeaModel):
    def __init__(self, creation_time=None, description=None, object_path=None, object_type=None, process=None,
                 status=None, task_id=None):
        # The time when the task was created. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The type of error returned when the refresh or prefetch task has failed.
        # 
        # *   **InternalError**: An internal error occurred.
        # *   **OriginTimeout**: The response from the origin server timed out.
        # *   **OriginReturn StatusCode 5XX**: The origin server returned a 5XX error.
        self.description = description  # type: str
        # The URL of the object to be refreshed.
        self.object_path = object_path  # type: str
        # The type of the task.
        # 
        # *   **file**: URL-based refresh
        # *   **path**: directory-based refresh
        # *   **preload**: URL-based prefetch
        self.object_type = object_type  # type: str
        # The progress of the task, in percentage.
        self.process = process  # type: str
        # The status of the task.
        # 
        # *   **Complete**: The task has completed.
        # *   **Refreshing**: The task is in progress.
        # *   **Failed**: The task failed.
        self.status = status  # type: str
        # The ID of the task.
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnRefreshTasksResponseBodyTasksTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.object_path is not None:
            result['ObjectPath'] = self.object_path
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.process is not None:
            result['Process'] = self.process
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ObjectPath') is not None:
            self.object_path = m.get('ObjectPath')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('Process') is not None:
            self.process = m.get('Process')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeDcdnRefreshTasksResponseBodyTasks(TeaModel):
    def __init__(self, task=None):
        self.task = task  # type: list[DescribeDcdnRefreshTasksResponseBodyTasksTask]

    def validate(self):
        if self.task:
            for k in self.task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnRefreshTasksResponseBodyTasks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Task'] = []
        if self.task is not None:
            for k in self.task:
                result['Task'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.task = []
        if m.get('Task') is not None:
            for k in m.get('Task'):
                temp_model = DescribeDcdnRefreshTasksResponseBodyTasksTask()
                self.task.append(temp_model.from_map(k))
        return self


class DescribeDcdnRefreshTasksResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, tasks=None, total_count=None):
        # The page number of the returned page.
        self.page_number = page_number  # type: long
        # The number of entries returned per page.
        self.page_size = page_size  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Details about tasks.
        self.tasks = tasks  # type: DescribeDcdnRefreshTasksResponseBodyTasks
        # The number of tasks.
        self.total_count = total_count  # type: long

    def validate(self):
        if self.tasks:
            self.tasks.validate()

    def to_map(self):
        _map = super(DescribeDcdnRefreshTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.tasks is not None:
            result['Tasks'] = self.tasks.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Tasks') is not None:
            temp_model = DescribeDcdnRefreshTasksResponseBodyTasks()
            self.tasks = temp_model.from_map(m['Tasks'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnRefreshTasksResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnRefreshTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnRefreshTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnRefreshTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnRegionAndIspRequest(TeaModel):
    def __init__(self, owner_id=None, security_token=None):
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnRegionAndIspRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnRegionAndIspResponseBodyIspsIsp(TeaModel):
    def __init__(self, name_en=None, name_zh=None):
        # The English name of the ISP.
        self.name_en = name_en  # type: str
        # The Chinese name of the ISP.
        self.name_zh = name_zh  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnRegionAndIspResponseBodyIspsIsp, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_en is not None:
            result['NameEn'] = self.name_en
        if self.name_zh is not None:
            result['NameZh'] = self.name_zh
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NameEn') is not None:
            self.name_en = m.get('NameEn')
        if m.get('NameZh') is not None:
            self.name_zh = m.get('NameZh')
        return self


class DescribeDcdnRegionAndIspResponseBodyIsps(TeaModel):
    def __init__(self, isp=None):
        self.isp = isp  # type: list[DescribeDcdnRegionAndIspResponseBodyIspsIsp]

    def validate(self):
        if self.isp:
            for k in self.isp:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnRegionAndIspResponseBodyIsps, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Isp'] = []
        if self.isp is not None:
            for k in self.isp:
                result['Isp'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.isp = []
        if m.get('Isp') is not None:
            for k in m.get('Isp'):
                temp_model = DescribeDcdnRegionAndIspResponseBodyIspsIsp()
                self.isp.append(temp_model.from_map(k))
        return self


class DescribeDcdnRegionAndIspResponseBodyRegionsRegion(TeaModel):
    def __init__(self, name_en=None, name_zh=None):
        # The English name of the region.
        self.name_en = name_en  # type: str
        # The Chinese name of the region.
        self.name_zh = name_zh  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnRegionAndIspResponseBodyRegionsRegion, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_en is not None:
            result['NameEn'] = self.name_en
        if self.name_zh is not None:
            result['NameZh'] = self.name_zh
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NameEn') is not None:
            self.name_en = m.get('NameEn')
        if m.get('NameZh') is not None:
            self.name_zh = m.get('NameZh')
        return self


class DescribeDcdnRegionAndIspResponseBodyRegions(TeaModel):
    def __init__(self, region=None):
        self.region = region  # type: list[DescribeDcdnRegionAndIspResponseBodyRegionsRegion]

    def validate(self):
        if self.region:
            for k in self.region:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnRegionAndIspResponseBodyRegions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Region'] = []
        if self.region is not None:
            for k in self.region:
                result['Region'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.region = []
        if m.get('Region') is not None:
            for k in m.get('Region'):
                temp_model = DescribeDcdnRegionAndIspResponseBodyRegionsRegion()
                self.region.append(temp_model.from_map(k))
        return self


class DescribeDcdnRegionAndIspResponseBody(TeaModel):
    def __init__(self, isps=None, regions=None, request_id=None):
        # The list of ISPs.
        self.isps = isps  # type: DescribeDcdnRegionAndIspResponseBodyIsps
        # The list of regions.
        self.regions = regions  # type: DescribeDcdnRegionAndIspResponseBodyRegions
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.isps:
            self.isps.validate()
        if self.regions:
            self.regions.validate()

    def to_map(self):
        _map = super(DescribeDcdnRegionAndIspResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.isps is not None:
            result['Isps'] = self.isps.to_map()
        if self.regions is not None:
            result['Regions'] = self.regions.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Isps') is not None:
            temp_model = DescribeDcdnRegionAndIspResponseBodyIsps()
            self.isps = temp_model.from_map(m['Isps'])
        if m.get('Regions') is not None:
            temp_model = DescribeDcdnRegionAndIspResponseBodyRegions()
            self.regions = temp_model.from_map(m['Regions'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnRegionAndIspResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnRegionAndIspResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnRegionAndIspResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnRegionAndIspResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnReportRequest(TeaModel):
    def __init__(self, area=None, domain_name=None, end_time=None, http_code=None, is_overseas=None, report_id=None,
                 start_time=None):
        # The region. You can call the [DescribeDcdnRegionAndIsp](~~207199~~) operation to query the most recent region list.
        # 
        # *   If you do not specify a region, all regions are queried.
        # *   If you specify a region, data about the specified region is returned. You can specify one or more regions. Separate multiple regions with commas (,).
        self.area = area  # type: str
        # The domain names that you want to query. Separate domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. The time in the ISO 8601 standard in the YYYY-MM-DDTHH:mm:ssZ format. The time must be in UTC+0.
        self.end_time = end_time  # type: str
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: HTTP 2xx status codes
        # *   **3xx**: HTTP 3xx status codes
        # *   **4xx**: HTTP 4xx status codes
        # *   **5xx**: HTTP 5xx status codes
        # 
        # If you do not specify an HTTP status code, all HTTP status codes are queried.
        self.http_code = http_code  # type: str
        # Specifies whether the region is outside the Chinese mainland. Valid values:
        # 
        # *   **1**: outside the Chinese mainland
        # *   **0**: inside the Chinese mainland
        self.is_overseas = is_overseas  # type: str
        # The ID of the operations report that you want to query. You can specify only one ID in each call. You can call the [DescribeDcdnSubList](~~270075~~) operation to query report IDs.
        self.report_id = report_id  # type: long
        # The start of the time range to query. The time in the ISO 8601 standard in the YYYY-MM-DDTHH:mm:ssZ format. The time must be in UTC+0.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.is_overseas is not None:
            result['IsOverseas'] = self.is_overseas
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('IsOverseas') is not None:
            self.is_overseas = m.get('IsOverseas')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnReportResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The content of the operations report.
        self.content = content  # type: dict[str, any]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnReportListRequest(TeaModel):
    def __init__(self, report_id=None):
        # The ID of the operations report that you want to query. If you do not specify an ID, all operations reports are queried.
        self.report_id = report_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnReportListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        return self


class DescribeDcdnReportListResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The information about the report that is queried.
        self.content = content  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnReportListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnReportListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnReportListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnReportListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnReportListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnSLSRealtimeLogDeliveryRequest(TeaModel):
    def __init__(self, project_name=None):
        # The name of a real-time log delivery project.
        self.project_name = project_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnSLSRealtimeLogDeliveryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class DescribeDcdnSLSRealtimeLogDeliveryResponseBodyContent(TeaModel):
    def __init__(self, business_type=None, data_center=None, domain_name=None, field_name=None, project_name=None,
                 slslog_store=None, slsproject=None, slsregion=None, sampling_rate=None, status=None, type=None):
        # The type of the collected logs. Default value: cdn_log_access_l1. Valid values:
        # 
        # *   **cdn_log_access_l1**: access logs of Dynamic Route for CDN (DCDN) points of presence (POPs)
        # *   **cdn_log_origin**: back-to-origin logs
        # *   **cdn_log_er**: EdgeRoutine logs
        self.business_type = business_type  # type: str
        # The region from which logs were collected.
        self.data_center = data_center  # type: str
        # The domain names from which logs were collected. You can specify one or more domain names. Separate multiple domain names with commas (,).
        self.domain_name = domain_name  # type: str
        # The name of the field. For more information about fields in real-time log entries, see [Fields in a real-time log](~~324199~~).
        self.field_name = field_name  # type: str
        # The name of the Log Service project
        self.project_name = project_name  # type: str
        # The name of the Logstore.
        self.slslog_store = slslog_store  # type: str
        # The name of the Log Service project.
        self.slsproject = slsproject  # type: str
        # The region to which logs were delivered.
        self.slsregion = slsregion  # type: str
        # The sampling rate.
        self.sampling_rate = sampling_rate  # type: str
        # The status of real-time logs.
        # 
        # *   **success**: The transcoded stream is uploaded.
        # *   **fail**: The transcoded stream fails to be uploaded.
        self.status = status  # type: str
        # The type of log delivery. Only **SLS_POST** is supported.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnSLSRealtimeLogDeliveryResponseBodyContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.slslog_store is not None:
            result['SLSLogStore'] = self.slslog_store
        if self.slsproject is not None:
            result['SLSProject'] = self.slsproject
        if self.slsregion is not None:
            result['SLSRegion'] = self.slsregion
        if self.sampling_rate is not None:
            result['SamplingRate'] = self.sampling_rate
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('SLSLogStore') is not None:
            self.slslog_store = m.get('SLSLogStore')
        if m.get('SLSProject') is not None:
            self.slsproject = m.get('SLSProject')
        if m.get('SLSRegion') is not None:
            self.slsregion = m.get('SLSRegion')
        if m.get('SamplingRate') is not None:
            self.sampling_rate = m.get('SamplingRate')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDcdnSLSRealtimeLogDeliveryResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The configuration results of the domain name.
        self.content = content  # type: DescribeDcdnSLSRealtimeLogDeliveryResponseBodyContent
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super(DescribeDcdnSLSRealtimeLogDeliveryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = DescribeDcdnSLSRealtimeLogDeliveryResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnSLSRealtimeLogDeliveryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnSLSRealtimeLogDeliveryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnSLSRealtimeLogDeliveryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnSLSRealtimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnSMCertificateDetailRequest(TeaModel):
    def __init__(self, cert_identifier=None, owner_id=None, security_token=None):
        # The ID of the certificate.
        self.cert_identifier = cert_identifier  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnSMCertificateDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_identifier is not None:
            result['CertIdentifier'] = self.cert_identifier
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertIdentifier') is not None:
            self.cert_identifier = m.get('CertIdentifier')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnSMCertificateDetailResponseBody(TeaModel):
    def __init__(self, cert_expire_time=None, cert_identifier=None, cert_name=None, cert_org=None, common_name=None,
                 encrypt_certificate=None, request_id=None, sans=None, sign_certificate=None):
        # The time when the certificate expires. The time is displayed in UTC.
        self.cert_expire_time = cert_expire_time  # type: str
        # The ID of the certificate.
        self.cert_identifier = cert_identifier  # type: str
        # The name of the certificate.
        self.cert_name = cert_name  # type: str
        # The certificate authority (CA) that issued the certificate.
        self.cert_org = cert_org  # type: str
        # The top-level domain name.
        self.common_name = common_name  # type: str
        # The content of the encryption certificate.
        self.encrypt_certificate = encrypt_certificate  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The subdomain name.
        self.sans = sans  # type: str
        # The content of the signature certificate.
        self.sign_certificate = sign_certificate  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnSMCertificateDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_expire_time is not None:
            result['CertExpireTime'] = self.cert_expire_time
        if self.cert_identifier is not None:
            result['CertIdentifier'] = self.cert_identifier
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cert_org is not None:
            result['CertOrg'] = self.cert_org
        if self.common_name is not None:
            result['CommonName'] = self.common_name
        if self.encrypt_certificate is not None:
            result['EncryptCertificate'] = self.encrypt_certificate
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sans is not None:
            result['Sans'] = self.sans
        if self.sign_certificate is not None:
            result['SignCertificate'] = self.sign_certificate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertExpireTime') is not None:
            self.cert_expire_time = m.get('CertExpireTime')
        if m.get('CertIdentifier') is not None:
            self.cert_identifier = m.get('CertIdentifier')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('CertOrg') is not None:
            self.cert_org = m.get('CertOrg')
        if m.get('CommonName') is not None:
            self.common_name = m.get('CommonName')
        if m.get('EncryptCertificate') is not None:
            self.encrypt_certificate = m.get('EncryptCertificate')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Sans') is not None:
            self.sans = m.get('Sans')
        if m.get('SignCertificate') is not None:
            self.sign_certificate = m.get('SignCertificate')
        return self


class DescribeDcdnSMCertificateDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnSMCertificateDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnSMCertificateDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnSMCertificateDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnSMCertificateListRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        # The accelerated domain name whose SM certificates you want to query.
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnSMCertificateListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnSMCertificateListResponseBodyCertificateListModelCertList(TeaModel):
    def __init__(self, cert_identifier=None, cert_name=None, common=None, issuer=None):
        # The ID of the certificate.
        self.cert_identifier = cert_identifier  # type: str
        # The name of the certificate.
        self.cert_name = cert_name  # type: str
        # The common name of the certificate.
        self.common = common  # type: str
        # The certificate authority (CA) that issued the certificate.
        self.issuer = issuer  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnSMCertificateListResponseBodyCertificateListModelCertList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_identifier is not None:
            result['CertIdentifier'] = self.cert_identifier
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.common is not None:
            result['Common'] = self.common
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertIdentifier') is not None:
            self.cert_identifier = m.get('CertIdentifier')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Common') is not None:
            self.common = m.get('Common')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        return self


class DescribeDcdnSMCertificateListResponseBodyCertificateListModel(TeaModel):
    def __init__(self, cert_list=None, count=None):
        # A list of certificates.
        self.cert_list = cert_list  # type: list[DescribeDcdnSMCertificateListResponseBodyCertificateListModelCertList]
        # The number of certificates that are returned.
        self.count = count  # type: int

    def validate(self):
        if self.cert_list:
            for k in self.cert_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnSMCertificateListResponseBodyCertificateListModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CertList'] = []
        if self.cert_list is not None:
            for k in self.cert_list:
                result['CertList'].append(k.to_map() if k else None)
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cert_list = []
        if m.get('CertList') is not None:
            for k in m.get('CertList'):
                temp_model = DescribeDcdnSMCertificateListResponseBodyCertificateListModelCertList()
                self.cert_list.append(temp_model.from_map(k))
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeDcdnSMCertificateListResponseBody(TeaModel):
    def __init__(self, certificate_list_model=None, request_id=None):
        # The type of the certificate information.
        self.certificate_list_model = certificate_list_model  # type: DescribeDcdnSMCertificateListResponseBodyCertificateListModel
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.certificate_list_model:
            self.certificate_list_model.validate()

    def to_map(self):
        _map = super(DescribeDcdnSMCertificateListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.certificate_list_model is not None:
            result['CertificateListModel'] = self.certificate_list_model.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertificateListModel') is not None:
            temp_model = DescribeDcdnSMCertificateListResponseBodyCertificateListModel()
            self.certificate_list_model = temp_model.from_map(m['CertificateListModel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnSMCertificateListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnSMCertificateListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnSMCertificateListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnSMCertificateListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnSecFuncInfoRequest(TeaModel):
    def __init__(self, lang=None, sec_func_type=None):
        # The language. Valid values: en and zh. Default value: en.
        self.lang = lang  # type: str
        # The type of the drop-down list. Valid values: RobotRuleName and RobotObject.
        self.sec_func_type = sec_func_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnSecFuncInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.sec_func_type is not None:
            result['SecFuncType'] = self.sec_func_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SecFuncType') is not None:
            self.sec_func_type = m.get('SecFuncType')
        return self


class DescribeDcdnSecFuncInfoResponseBodyContent(TeaModel):
    def __init__(self, label=None, value=None):
        # The language (Chinese or English).
        self.label = label  # type: str
        # The options in the drop-down list.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnSecFuncInfoResponseBodyContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnSecFuncInfoResponseBody(TeaModel):
    def __init__(self, content=None, description=None, http_status=None, request_id=None, ret_code=None):
        # The parameters required by the code.
        self.content = content  # type: list[DescribeDcdnSecFuncInfoResponseBodyContent]
        # The description of HTTP responses.
        self.description = description  # type: str
        # The HTTP status code.
        self.http_status = http_status  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The return value for HTTP requests.
        # 
        # *   0: OK.
        # *   Values other than 0: an error.
        self.ret_code = ret_code  # type: str

    def validate(self):
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnSecFuncInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Content'] = []
        if self.content is not None:
            for k in self.content:
                result['Content'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.http_status is not None:
            result['HttpStatus'] = self.http_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.content = []
        if m.get('Content') is not None:
            for k in m.get('Content'):
                temp_model = DescribeDcdnSecFuncInfoResponseBodyContent()
                self.content.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HttpStatus') is not None:
            self.http_status = m.get('HttpStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        return self


class DescribeDcdnSecFuncInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnSecFuncInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnSecFuncInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnSecFuncInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnSecSpecInfoResponseBodySpecInfosRuleConfigs(TeaModel):
    def __init__(self, code=None, expr=None, value=None):
        # The configuration code of the security rule.
        self.code = code  # type: str
        # The configuration expression of the security rule.
        self.expr = expr  # type: str
        # The value of the configuration expression of the security rule.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnSecSpecInfoResponseBodySpecInfosRuleConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.expr is not None:
            result['Expr'] = self.expr
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Expr') is not None:
            self.expr = m.get('Expr')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnSecSpecInfoResponseBodySpecInfos(TeaModel):
    def __init__(self, rule_code=None, rule_configs=None):
        # The code of the security rule.
        self.rule_code = rule_code  # type: str
        # The configurations of the security rule.
        self.rule_configs = rule_configs  # type: list[DescribeDcdnSecSpecInfoResponseBodySpecInfosRuleConfigs]

    def validate(self):
        if self.rule_configs:
            for k in self.rule_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnSecSpecInfoResponseBodySpecInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_code is not None:
            result['RuleCode'] = self.rule_code
        result['RuleConfigs'] = []
        if self.rule_configs is not None:
            for k in self.rule_configs:
                result['RuleConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleCode') is not None:
            self.rule_code = m.get('RuleCode')
        self.rule_configs = []
        if m.get('RuleConfigs') is not None:
            for k in m.get('RuleConfigs'):
                temp_model = DescribeDcdnSecSpecInfoResponseBodySpecInfosRuleConfigs()
                self.rule_configs.append(temp_model.from_map(k))
        return self


class DescribeDcdnSecSpecInfoResponseBody(TeaModel):
    def __init__(self, request_id=None, spec_infos=None, version=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The code and configurations of the security rules.
        self.spec_infos = spec_infos  # type: list[DescribeDcdnSecSpecInfoResponseBodySpecInfos]
        # The version of secure DCDN.
        self.version = version  # type: str

    def validate(self):
        if self.spec_infos:
            for k in self.spec_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnSecSpecInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SpecInfos'] = []
        if self.spec_infos is not None:
            for k in self.spec_infos:
                result['SpecInfos'].append(k.to_map() if k else None)
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.spec_infos = []
        if m.get('SpecInfos') is not None:
            for k in m.get('SpecInfos'):
                temp_model = DescribeDcdnSecSpecInfoResponseBodySpecInfos()
                self.spec_infos.append(temp_model.from_map(k))
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeDcdnSecSpecInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnSecSpecInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnSecSpecInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnSecSpecInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnServiceRequest(TeaModel):
    def __init__(self, owner_id=None, security_token=None):
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnServiceResponseBodyOperationLocksLockReason(TeaModel):
    def __init__(self, lock_reason=None):
        # The reason why the service was locked. For example, a value of financial indicates that an overdue payment exists.
        self.lock_reason = lock_reason  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnServiceResponseBodyOperationLocksLockReason, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        return self


class DescribeDcdnServiceResponseBodyOperationLocks(TeaModel):
    def __init__(self, lock_reason=None):
        self.lock_reason = lock_reason  # type: list[DescribeDcdnServiceResponseBodyOperationLocksLockReason]

    def validate(self):
        if self.lock_reason:
            for k in self.lock_reason:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnServiceResponseBodyOperationLocks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LockReason'] = []
        if self.lock_reason is not None:
            for k in self.lock_reason:
                result['LockReason'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.lock_reason = []
        if m.get('LockReason') is not None:
            for k in m.get('LockReason'):
                temp_model = DescribeDcdnServiceResponseBodyOperationLocksLockReason()
                self.lock_reason.append(temp_model.from_map(k))
        return self


class DescribeDcdnServiceResponseBody(TeaModel):
    def __init__(self, changing_affect_time=None, changing_charge_type=None, instance_id=None,
                 internet_charge_type=None, opening_time=None, operation_locks=None, request_id=None, websocket_changing_time=None,
                 websocket_changing_type=None, websocket_type=None):
        # The start time when the next billing method takes effect. The time is displayed in UTC.
        self.changing_affect_time = changing_affect_time  # type: str
        # The next billing method that takes effect. Valid values:
        # 
        # *   **PayByTraffic**: traffic
        # *   **PayByBandwidth**: bandwidth
        # *   **PayByBandwidth95**: 95th percentile bandwidth
        # *   **PayByBandwidth_monthavg**: monthly average bandwidth
        # *   **PayByBandwidth_month4th**: the fourth peak bandwidth in each month
        # *   **PayByBandwidth_monthday95avg**: monthly average 95th percentile bandwidth
        # *   **PayByBandwidth_nighthalf95**: 95th percentile bandwidth of half idle bandwidth in the nighttime
        self.changing_charge_type = changing_charge_type  # type: str
        # The ID of the instance.
        self.instance_id = instance_id  # type: str
        # The current billing method. Valid values:
        # 
        # *   **PayByTraffic**: traffic
        # *   **PayByBandwidth**: bandwidth
        # *   **PayByBandwidth95**: 95th percentile bandwidth
        # *   **PayByBandwidth_monthavg**: monthly average bandwidth
        # *   **PayByBandwidth_month4th**: the fourth peak bandwidth in each month
        # *   **PayByBandwidth_monthday95avg**: monthly average 95th percentile bandwidth
        # *   **PayByBandwidth_nighthalf95**: 95th percentile bandwidth of half idle bandwidth in the nighttime
        self.internet_charge_type = internet_charge_type  # type: str
        # The time when the DCDN service was activated. The time follows the ISO 8601 standard.
        self.opening_time = opening_time  # type: str
        # The lock status of the DCDN service.
        self.operation_locks = operation_locks  # type: DescribeDcdnServiceResponseBodyOperationLocks
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The time when the changes of the WebSocket configuration take effect. The value is the same as that of the ChangingAffectTime parameter. This parameter can be displayed in the console only if the specified time is later than the current time.
        self.websocket_changing_time = websocket_changing_time  # type: str
        # The next effective billing method of WebSocket. Valid values: **websockettraffic** and **websocketbps**. A value of websockettraffic indicates that you are billed based on the traffic volume. A value of websocketbps indicates that you are billed based on the bandwidth.
        self.websocket_changing_type = websocket_changing_type  # type: str
        # The current billing method of WebSocket. Valid values: **websockettraffic** and **websocketbps**. A value of websockettraffic indicates that you are billed based on the traffic volume. A value of websocketbps indicates that you are billed based on the bandwidth.
        self.websocket_type = websocket_type  # type: str

    def validate(self):
        if self.operation_locks:
            self.operation_locks.validate()

    def to_map(self):
        _map = super(DescribeDcdnServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.changing_affect_time is not None:
            result['ChangingAffectTime'] = self.changing_affect_time
        if self.changing_charge_type is not None:
            result['ChangingChargeType'] = self.changing_charge_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.opening_time is not None:
            result['OpeningTime'] = self.opening_time
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.websocket_changing_time is not None:
            result['WebsocketChangingTime'] = self.websocket_changing_time
        if self.websocket_changing_type is not None:
            result['WebsocketChangingType'] = self.websocket_changing_type
        if self.websocket_type is not None:
            result['WebsocketType'] = self.websocket_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChangingAffectTime') is not None:
            self.changing_affect_time = m.get('ChangingAffectTime')
        if m.get('ChangingChargeType') is not None:
            self.changing_charge_type = m.get('ChangingChargeType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('OpeningTime') is not None:
            self.opening_time = m.get('OpeningTime')
        if m.get('OperationLocks') is not None:
            temp_model = DescribeDcdnServiceResponseBodyOperationLocks()
            self.operation_locks = temp_model.from_map(m['OperationLocks'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WebsocketChangingTime') is not None:
            self.websocket_changing_time = m.get('WebsocketChangingTime')
        if m.get('WebsocketChangingType') is not None:
            self.websocket_changing_type = m.get('WebsocketChangingType')
        if m.get('WebsocketType') is not None:
            self.websocket_type = m.get('WebsocketType')
        return self


class DescribeDcdnServiceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnStagingIpResponseBodyIPV4s(TeaModel):
    def __init__(self, ipv4=None):
        self.ipv4 = ipv4  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnStagingIpResponseBodyIPV4s, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv4 is not None:
            result['IPV4'] = self.ipv4
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IPV4') is not None:
            self.ipv4 = m.get('IPV4')
        return self


class DescribeDcdnStagingIpResponseBody(TeaModel):
    def __init__(self, ipv4s=None, request_id=None):
        # The IPv4 addresses.format
        self.ipv4s = ipv4s  # type: DescribeDcdnStagingIpResponseBodyIPV4s
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.ipv4s:
            self.ipv4s.validate()

    def to_map(self):
        _map = super(DescribeDcdnStagingIpResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv4s is not None:
            result['IPV4s'] = self.ipv4s.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IPV4s') is not None:
            temp_model = DescribeDcdnStagingIpResponseBodyIPV4s()
            self.ipv4s = temp_model.from_map(m['IPV4s'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnStagingIpResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnStagingIpResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnStagingIpResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnStagingIpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnSubListResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The information about the custom report task.
        self.content = content  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnSubListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnSubListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnSubListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnSubListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnSubListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnTagResourcesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of tag N. Valid values of N: **1** to **20**.
        self.key = key  # type: str
        # The value of tag N. Valid values of N: **1** to **20**.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnTagResourcesRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnTagResourcesRequest(TeaModel):
    def __init__(self, resource_id=None, resource_type=None, tag=None):
        self.resource_id = resource_id  # type: list[str]
        # The type of the resource. Set the value to **DOMAIN**.
        self.resource_type = resource_type  # type: str
        self.tag = tag  # type: list[DescribeDcdnTagResourcesRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnTagResourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDcdnTagResourcesRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDcdnTagResourcesResponseBodyTagResourcesTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of the tag.
        self.key = key  # type: str
        # The value of the tag.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnTagResourcesResponseBodyTagResourcesTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnTagResourcesResponseBodyTagResources(TeaModel):
    def __init__(self, resource_id=None, tag=None):
        # The ID of the resource.
        self.resource_id = resource_id  # type: str
        # The tags.
        self.tag = tag  # type: list[DescribeDcdnTagResourcesResponseBodyTagResourcesTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnTagResourcesResponseBodyTagResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDcdnTagResourcesResponseBodyTagResourcesTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDcdnTagResourcesResponseBody(TeaModel):
    def __init__(self, request_id=None, tag_resources=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The tags of the instance.
        self.tag_resources = tag_resources  # type: list[DescribeDcdnTagResourcesResponseBodyTagResources]

    def validate(self):
        if self.tag_resources:
            for k in self.tag_resources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnTagResourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TagResources'] = []
        if self.tag_resources is not None:
            for k in self.tag_resources:
                result['TagResources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tag_resources = []
        if m.get('TagResources') is not None:
            for k in m.get('TagResources'):
                temp_model = DescribeDcdnTagResourcesResponseBodyTagResources()
                self.tag_resources.append(temp_model.from_map(k))
        return self


class DescribeDcdnTagResourcesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnTagResourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnTagResourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnTagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnTopDomainsByFlowRequest(TeaModel):
    def __init__(self, end_time=None, limit=None, start_time=None):
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The maximum number of domain names to return. Valid values: **1** to **100**. Default value: **20**.
        self.limit = limit  # type: long
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnTopDomainsByFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnTopDomainsByFlowResponseBodyTopDomainsTopDomain(TeaModel):
    def __init__(self, domain_name=None, max_bps=None, max_bps_time=None, rank=None, total_access=None,
                 total_traffic=None, traffic_percent=None):
        # The name of the accelerated domain.
        self.domain_name = domain_name  # type: str
        # The peak bandwidth.
        self.max_bps = max_bps  # type: long
        # The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC.
        self.max_bps_time = max_bps_time  # type: str
        # The ranking of the domains.
        self.rank = rank  # type: long
        # The number of visits to the URL that was queried.
        self.total_access = total_access  # type: long
        # The total amount of network traffic.
        self.total_traffic = total_traffic  # type: str
        # The proportion of the network traffic that was consumed for accessing the URL.
        self.traffic_percent = traffic_percent  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnTopDomainsByFlowResponseBodyTopDomainsTopDomain, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.max_bps is not None:
            result['MaxBps'] = self.max_bps
        if self.max_bps_time is not None:
            result['MaxBpsTime'] = self.max_bps_time
        if self.rank is not None:
            result['Rank'] = self.rank
        if self.total_access is not None:
            result['TotalAccess'] = self.total_access
        if self.total_traffic is not None:
            result['TotalTraffic'] = self.total_traffic
        if self.traffic_percent is not None:
            result['TrafficPercent'] = self.traffic_percent
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('MaxBps') is not None:
            self.max_bps = m.get('MaxBps')
        if m.get('MaxBpsTime') is not None:
            self.max_bps_time = m.get('MaxBpsTime')
        if m.get('Rank') is not None:
            self.rank = m.get('Rank')
        if m.get('TotalAccess') is not None:
            self.total_access = m.get('TotalAccess')
        if m.get('TotalTraffic') is not None:
            self.total_traffic = m.get('TotalTraffic')
        if m.get('TrafficPercent') is not None:
            self.traffic_percent = m.get('TrafficPercent')
        return self


class DescribeDcdnTopDomainsByFlowResponseBodyTopDomains(TeaModel):
    def __init__(self, top_domain=None):
        self.top_domain = top_domain  # type: list[DescribeDcdnTopDomainsByFlowResponseBodyTopDomainsTopDomain]

    def validate(self):
        if self.top_domain:
            for k in self.top_domain:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnTopDomainsByFlowResponseBodyTopDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TopDomain'] = []
        if self.top_domain is not None:
            for k in self.top_domain:
                result['TopDomain'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.top_domain = []
        if m.get('TopDomain') is not None:
            for k in m.get('TopDomain'):
                temp_model = DescribeDcdnTopDomainsByFlowResponseBodyTopDomainsTopDomain()
                self.top_domain.append(temp_model.from_map(k))
        return self


class DescribeDcdnTopDomainsByFlowResponseBody(TeaModel):
    def __init__(self, domain_count=None, domain_online_count=None, end_time=None, request_id=None, start_time=None,
                 top_domains=None):
        # The total number of accelerated domains under your account.
        self.domain_count = domain_count  # type: long
        # The total number of accelerated domains that are in the **Enabled** state under your account.
        self.domain_online_count = domain_online_count  # type: long
        # The end of the time range during which the data was collected.
        self.end_time = end_time  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The beginning of the time range during which the data was collected.
        self.start_time = start_time  # type: str
        # The top N domain names ranked by network traffic.
        self.top_domains = top_domains  # type: DescribeDcdnTopDomainsByFlowResponseBodyTopDomains

    def validate(self):
        if self.top_domains:
            self.top_domains.validate()

    def to_map(self):
        _map = super(DescribeDcdnTopDomainsByFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_count is not None:
            result['DomainCount'] = self.domain_count
        if self.domain_online_count is not None:
            result['DomainOnlineCount'] = self.domain_online_count
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.top_domains is not None:
            result['TopDomains'] = self.top_domains.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainCount') is not None:
            self.domain_count = m.get('DomainCount')
        if m.get('DomainOnlineCount') is not None:
            self.domain_online_count = m.get('DomainOnlineCount')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TopDomains') is not None:
            temp_model = DescribeDcdnTopDomainsByFlowResponseBodyTopDomains()
            self.top_domains = temp_model.from_map(m['TopDomains'])
        return self


class DescribeDcdnTopDomainsByFlowResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnTopDomainsByFlowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnTopDomainsByFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnTopDomainsByFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserBillHistoryRequest(TeaModel):
    def __init__(self, end_time=None, start_time=None):
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
        # 
        # The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard
        # 
        # in the YYYY-MM-DDThh:mm:ssZ format. The time must be in UTC+0.
        # 
        # The minimum data collection interval is 5 minutes.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserBillHistoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItemBillingDataBillingDataItem(TeaModel):
    def __init__(self, bandwidth=None, cdn_region=None, charge_type=None, count=None, flow=None):
        # The bandwidth. Unit: bit/s.
        self.bandwidth = bandwidth  # type: float
        # The region for which the billing records are generated. Valid values: **CN**, **OverSeas**, **AP1**, **AP2**, **AP3**, **NA**, **SA**, **EU**, and **MEAA**.
        self.cdn_region = cdn_region  # type: str
        # The billing type. Valid values: **StaticHttp**, **DynamicHttp**, and **DynamicHttps**.
        self.charge_type = charge_type  # type: str
        # The number of billing entries.
        self.count = count  # type: float
        # The traffic. Unit: byte.
        self.flow = flow  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItemBillingDataBillingDataItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.cdn_region is not None:
            result['CdnRegion'] = self.cdn_region
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.count is not None:
            result['Count'] = self.count
        if self.flow is not None:
            result['Flow'] = self.flow
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('CdnRegion') is not None:
            self.cdn_region = m.get('CdnRegion')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Flow') is not None:
            self.flow = m.get('Flow')
        return self


class DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItemBillingData(TeaModel):
    def __init__(self, billing_data_item=None):
        self.billing_data_item = billing_data_item  # type: list[DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItemBillingDataBillingDataItem]

    def validate(self):
        if self.billing_data_item:
            for k in self.billing_data_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItemBillingData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BillingDataItem'] = []
        if self.billing_data_item is not None:
            for k in self.billing_data_item:
                result['BillingDataItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.billing_data_item = []
        if m.get('BillingDataItem') is not None:
            for k in m.get('BillingDataItem'):
                temp_model = DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItemBillingDataBillingDataItem()
                self.billing_data_item.append(temp_model.from_map(k))
        return self


class DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItem(TeaModel):
    def __init__(self, bill_time=None, bill_type=None, billing_data=None, dimension=None):
        # The start time of the billing cycle.
        self.bill_time = bill_time  # type: str
        # The billing method.
        self.bill_type = bill_type  # type: str
        # The billing data.
        self.billing_data = billing_data  # type: DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItemBillingData
        # The dimension.
        self.dimension = dimension  # type: str

    def validate(self):
        if self.billing_data:
            self.billing_data.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_time is not None:
            result['BillTime'] = self.bill_time
        if self.bill_type is not None:
            result['BillType'] = self.bill_type
        if self.billing_data is not None:
            result['BillingData'] = self.billing_data.to_map()
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BillTime') is not None:
            self.bill_time = m.get('BillTime')
        if m.get('BillType') is not None:
            self.bill_type = m.get('BillType')
        if m.get('BillingData') is not None:
            temp_model = DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItemBillingData()
            self.billing_data = temp_model.from_map(m['BillingData'])
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        return self


class DescribeDcdnUserBillHistoryResponseBodyBillHistoryData(TeaModel):
    def __init__(self, bill_history_data_item=None):
        self.bill_history_data_item = bill_history_data_item  # type: list[DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItem]

    def validate(self):
        if self.bill_history_data_item:
            for k in self.bill_history_data_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserBillHistoryResponseBodyBillHistoryData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BillHistoryDataItem'] = []
        if self.bill_history_data_item is not None:
            for k in self.bill_history_data_item:
                result['BillHistoryDataItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bill_history_data_item = []
        if m.get('BillHistoryDataItem') is not None:
            for k in m.get('BillHistoryDataItem'):
                temp_model = DescribeDcdnUserBillHistoryResponseBodyBillHistoryDataBillHistoryDataItem()
                self.bill_history_data_item.append(temp_model.from_map(k))
        return self


class DescribeDcdnUserBillHistoryResponseBody(TeaModel):
    def __init__(self, bill_history_data=None, request_id=None):
        # The billing records.
        self.bill_history_data = bill_history_data  # type: DescribeDcdnUserBillHistoryResponseBodyBillHistoryData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.bill_history_data:
            self.bill_history_data.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserBillHistoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_history_data is not None:
            result['BillHistoryData'] = self.bill_history_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BillHistoryData') is not None:
            temp_model = DescribeDcdnUserBillHistoryResponseBodyBillHistoryData()
            self.bill_history_data = temp_model.from_map(m['BillHistoryData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnUserBillHistoryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserBillHistoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserBillHistoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserBillHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserBillTypeRequest(TeaModel):
    def __init__(self, end_time=None, start_time=None):
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard
        # 
        # in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard
        # 
        # in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserBillTypeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnUserBillTypeResponseBodyBillTypeDataBillTypeDataItem(TeaModel):
    def __init__(self, bill_type=None, billing_cycle=None, dimension=None, end_time=None, product=None,
                 start_time=None):
        # The metering method. Valid values:
        # 
        # *   **hour_flow**: pay by data transfer per hour
        # *   **day_bandwidth**: pay by bandwidth per day
        # *   **month\_95**: pay by 95th percentile
        # *   **month_avg_day_bandwidth**: pay by average daily peak bandwidth per month
        # *   **month\_4th_day_bandwidth**: pay by 4th peak bandwidth per month
        # *   **month_avg_day\_95**: pay by average daily 95th percentile per month
        # *   **month\_95\_night_half**: pay by 95th percentile (50 % off during nighttime)
        # *   **hour_vas**: pay by value-added service per month
        # *   **quic_hour_count**: pay by QUIC request per hour
        # *   **hour_count**: pay by request per hour
        # *   **rtlog_count_day**: pay by real-time log entry
        self.bill_type = bill_type  # type: str
        # The billing cycle.
        self.billing_cycle = billing_cycle  # type: str
        # The dimension. Valid values:
        # 
        # *   **flow**: network traffic and bandwidth
        # *   **vas**: value-added services (HTTPS and requests for dynamic content)
        # *   **websocket**: WebSocket
        # *   **quic**: the number of QUIC requests
        # *   **rtlog2sls**: log entries delivered to Log Service in real time
        self.dimension = dimension  # type: str
        # The time when the metering method ends.
        self.end_time = end_time  # type: str
        # The name of the service.
        self.product = product  # type: str
        # The time when the metering method takes effect.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserBillTypeResponseBodyBillTypeDataBillTypeDataItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_type is not None:
            result['BillType'] = self.bill_type
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.product is not None:
            result['Product'] = self.product
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BillType') is not None:
            self.bill_type = m.get('BillType')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnUserBillTypeResponseBodyBillTypeData(TeaModel):
    def __init__(self, bill_type_data_item=None):
        self.bill_type_data_item = bill_type_data_item  # type: list[DescribeDcdnUserBillTypeResponseBodyBillTypeDataBillTypeDataItem]

    def validate(self):
        if self.bill_type_data_item:
            for k in self.bill_type_data_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserBillTypeResponseBodyBillTypeData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BillTypeDataItem'] = []
        if self.bill_type_data_item is not None:
            for k in self.bill_type_data_item:
                result['BillTypeDataItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bill_type_data_item = []
        if m.get('BillTypeDataItem') is not None:
            for k in m.get('BillTypeDataItem'):
                temp_model = DescribeDcdnUserBillTypeResponseBodyBillTypeDataBillTypeDataItem()
                self.bill_type_data_item.append(temp_model.from_map(k))
        return self


class DescribeDcdnUserBillTypeResponseBody(TeaModel):
    def __init__(self, bill_type_data=None, request_id=None):
        # The information about the metering method.
        self.bill_type_data = bill_type_data  # type: DescribeDcdnUserBillTypeResponseBodyBillTypeData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.bill_type_data:
            self.bill_type_data.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserBillTypeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_type_data is not None:
            result['BillTypeData'] = self.bill_type_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BillTypeData') is not None:
            temp_model = DescribeDcdnUserBillTypeResponseBodyBillTypeData()
            self.bill_type_data = temp_model.from_map(m['BillTypeData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnUserBillTypeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserBillTypeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserBillTypeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserBillTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserCertificateExpireCountResponseBody(TeaModel):
    def __init__(self, expire_within_30days_count=None, expired_count=None, request_id=None):
        # The number of domain names whose SSL certificates are about to expires within 30 days.
        self.expire_within_30days_count = expire_within_30days_count  # type: int
        # The number of domain names whose SSL certificates have already expired.
        self.expired_count = expired_count  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserCertificateExpireCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire_within_30days_count is not None:
            result['ExpireWithin30DaysCount'] = self.expire_within_30days_count
        if self.expired_count is not None:
            result['ExpiredCount'] = self.expired_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExpireWithin30DaysCount') is not None:
            self.expire_within_30days_count = m.get('ExpireWithin30DaysCount')
        if m.get('ExpiredCount') is not None:
            self.expired_count = m.get('ExpiredCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnUserCertificateExpireCountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserCertificateExpireCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserCertificateExpireCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserCertificateExpireCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserConfigsRequest(TeaModel):
    def __init__(self, function_name=None):
        # The configuration that you want to query. Valid values:
        # 
        # *   domain_business_control: user configurations
        # *   bot_basic: the basic edition of bot traffic management, which supports authorized crawlers and provides threat intelligence
        # *   bot_Advance: the advanced edition of bot traffic management, which supports authorized crawlers and AI intelligent protection and provides threat intelligence
        self.function_name = function_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        return self


class DescribeDcdnUserConfigsResponseBodyConfigs(TeaModel):
    def __init__(self, arg_name=None, arg_value=None, function_name=None):
        # The name of the configuration.
        # 
        # The configuration that is specified by enterprise users and public service sectors.
        self.arg_name = arg_name  # type: str
        # The value of the configuration. Valid values:
        # 
        # *   cc_rule: HTTP flood protection
        # *   ddos_dispatch: DDoS mitigation
        # *   edge_safe: application security on edge nodes
        # *   blocked_regions: region blacklist
        # *   http_acl_policy: precise access control
        # *   bot_manager: bot traffic management
        # *   ip_reputation: IP reputation library
        self.arg_value = arg_value  # type: str
        # The configuration returned.
        self.function_name = function_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserConfigsResponseBodyConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg_name is not None:
            result['ArgName'] = self.arg_name
        if self.arg_value is not None:
            result['ArgValue'] = self.arg_value
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArgName') is not None:
            self.arg_name = m.get('ArgName')
        if m.get('ArgValue') is not None:
            self.arg_value = m.get('ArgValue')
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        return self


class DescribeDcdnUserConfigsResponseBody(TeaModel):
    def __init__(self, configs=None, request_id=None):
        # The user configurations.
        self.configs = configs  # type: list[DescribeDcdnUserConfigsResponseBodyConfigs]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = DescribeDcdnUserConfigsResponseBodyConfigs()
                self.configs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnUserConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserDomainsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of the tag. Valid values of N: **1** to **20**. You can call the TagDcdnResources operation to set a tag for a domain name.
        self.key = key  # type: str
        # The value of the tag. Valid values of N: **1** to **20**.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnUserDomainsRequest(TeaModel):
    def __init__(self, change_end_time=None, change_start_time=None, check_domain_show=None, coverage=None,
                 domain_name=None, domain_search_type=None, domain_status=None, owner_id=None, page_number=None, page_size=None,
                 resource_group_id=None, security_token=None, tag=None):
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
        # 
        # > The end time must be later than the start time.
        self.change_end_time = change_end_time  # type: str
        # The start of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
        self.change_start_time = change_start_time  # type: str
        # Specifies whether to display domain names that are under review, failed the review, or failed to be configured. Valid values:
        # 
        # *   true: displays domain names.
        # *   false: does not display domain names.
        self.check_domain_show = check_domain_show  # type: bool
        # The acceleration region. By default, all acceleration regions are queried.
        # 
        # *   **domestic**: Chinese mainland
        # *   **overseas**: global (excluding the Chinese mainland)
        # *   **global**: global
        self.coverage = coverage  # type: str
        # The accelerated domain names. If you do not set this parameter, configurations of all domain names that match the conditions are returned.
        self.domain_name = domain_name  # type: str
        # The search method. Default value: full_match. Valid values:
        # 
        # *   **fuzzy_match**: fuzzy match
        # *   **pre_match**: prefix match
        # *   **suf_match**: suffix match
        # *   **full_match**: exact match
        # 
        # > If you specify the domain names to query but do not set the DomainSearchType parameter, the exact match mode is used.
        self.domain_search_type = domain_search_type  # type: str
        # The status of the domain name. Valid values:
        # 
        # *   **online**: enabled
        # *   **offline**: disabled
        # *   **configuring**: configuring
        # *   **configure_failed**: configuration failed
        # *   **checking**: reviewing
        # *   **check_failed:** review failed
        self.domain_status = domain_status  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Valid values: **1** to **100000**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **20**. Valid values: **1** to **500**.
        self.page_size = page_size  # type: int
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        self.security_token = security_token  # type: str
        # The tags of the domain names.
        self.tag = tag  # type: list[DescribeDcdnUserDomainsRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_end_time is not None:
            result['ChangeEndTime'] = self.change_end_time
        if self.change_start_time is not None:
            result['ChangeStartTime'] = self.change_start_time
        if self.check_domain_show is not None:
            result['CheckDomainShow'] = self.check_domain_show
        if self.coverage is not None:
            result['Coverage'] = self.coverage
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_search_type is not None:
            result['DomainSearchType'] = self.domain_search_type
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChangeEndTime') is not None:
            self.change_end_time = m.get('ChangeEndTime')
        if m.get('ChangeStartTime') is not None:
            self.change_start_time = m.get('ChangeStartTime')
        if m.get('CheckDomainShow') is not None:
            self.check_domain_show = m.get('CheckDomainShow')
        if m.get('Coverage') is not None:
            self.coverage = m.get('Coverage')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainSearchType') is not None:
            self.domain_search_type = m.get('DomainSearchType')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDcdnUserDomainsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDcdnUserDomainsResponseBodyDomainsPageDataSourcesSource(TeaModel):
    def __init__(self, content=None, port=None, priority=None, type=None, weight=None):
        # The address of the origin server.
        self.content = content  # type: str
        # The port of the origin server.
        self.port = port  # type: int
        # The priority.
        self.priority = priority  # type: str
        # The type of the origin server.
        self.type = type  # type: str
        # The weight.
        self.weight = weight  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsResponseBodyDomainsPageDataSourcesSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.type is not None:
            result['Type'] = self.type
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeDcdnUserDomainsResponseBodyDomainsPageDataSources(TeaModel):
    def __init__(self, source=None):
        self.source = source  # type: list[DescribeDcdnUserDomainsResponseBodyDomainsPageDataSourcesSource]

    def validate(self):
        if self.source:
            for k in self.source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsResponseBodyDomainsPageDataSources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Source'] = []
        if self.source is not None:
            for k in self.source:
                result['Source'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.source = []
        if m.get('Source') is not None:
            for k in m.get('Source'):
                temp_model = DescribeDcdnUserDomainsResponseBodyDomainsPageDataSourcesSource()
                self.source.append(temp_model.from_map(k))
        return self


class DescribeDcdnUserDomainsResponseBodyDomainsPageData(TeaModel):
    def __init__(self, cname=None, description=None, domain_id=None, domain_name=None, domain_status=None,
                 gmt_created=None, gmt_modified=None, resource_group_id=None, sslprotocol=None, sandbox=None, sources=None):
        # The CNAME assigned to the accelerated domain name.
        self.cname = cname  # type: str
        # The reason why the accelerated domain name failed the review.
        self.description = description  # type: str
        # The ID of the accelerated domain name.
        self.domain_id = domain_id  # type: long
        # The information about the accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The status of the accelerated domain name.
        # 
        # *   **online**: enabled
        # *   **offline**: disabled
        # *   **configuring**: configuring
        # *   **configure_failed**: configuration failed
        # *   **checking**: reviewing
        # *   **check_failed:** review failed
        self.domain_status = domain_status  # type: str
        # The time when the accelerated domain name was added.
        self.gmt_created = gmt_created  # type: str
        # The time when the accelerated domain name was modified.
        self.gmt_modified = gmt_modified  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # Indicates whether HTTPS is enabled.
        # 
        # *   **on**\
        # *   **off**\
        self.sslprotocol = sslprotocol  # type: str
        # Indicates whether the accelerated domain name was in a sandbox.
        self.sandbox = sandbox  # type: str
        # The information about the origin server.
        self.sources = sources  # type: DescribeDcdnUserDomainsResponseBodyDomainsPageDataSources

    def validate(self):
        if self.sources:
            self.sources.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsResponseBodyDomainsPageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.sandbox is not None:
            result['Sandbox'] = self.sandbox
        if self.sources is not None:
            result['Sources'] = self.sources.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('Sandbox') is not None:
            self.sandbox = m.get('Sandbox')
        if m.get('Sources') is not None:
            temp_model = DescribeDcdnUserDomainsResponseBodyDomainsPageDataSources()
            self.sources = temp_model.from_map(m['Sources'])
        return self


class DescribeDcdnUserDomainsResponseBodyDomains(TeaModel):
    def __init__(self, page_data=None):
        self.page_data = page_data  # type: list[DescribeDcdnUserDomainsResponseBodyDomainsPageData]

    def validate(self):
        if self.page_data:
            for k in self.page_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsResponseBodyDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PageData'] = []
        if self.page_data is not None:
            for k in self.page_data:
                result['PageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.page_data = []
        if m.get('PageData') is not None:
            for k in m.get('PageData'):
                temp_model = DescribeDcdnUserDomainsResponseBodyDomainsPageData()
                self.page_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnUserDomainsResponseBody(TeaModel):
    def __init__(self, domains=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The detailed information about each accelerated domain name. The returned information is displayed in the format that is specified by the PageData parameter.
        self.domains = domains  # type: DescribeDcdnUserDomainsResponseBodyDomains
        # The page number of the returned page.
        self.page_number = page_number  # type: long
        # The number of entries returned per page.
        self.page_size = page_size  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: long

    def validate(self):
        if self.domains:
            self.domains.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['Domains'] = self.domains.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Domains') is not None:
            temp_model = DescribeDcdnUserDomainsResponseBodyDomains()
            self.domains = temp_model.from_map(m['Domains'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnUserDomainsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserDomainsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserDomainsByFuncRequest(TeaModel):
    def __init__(self, domain_name=None, func_filter=None, func_id=None, page_number=None, page_size=None,
                 resource_group_id=None):
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # Specifies whether the feature that is specified by the FuncId parameter is enabled. Valid values:
        # 
        # *   **config**: enabled
        # *   **unconfig**: not enabled
        self.func_filter = func_filter  # type: str
        # The ID of the feature. For more information about how to query feature IDs, see [Feature settings for a domain name](~~410622~~). For example, the ID of the origin host feature (set_req_host_header) is 18.
        self.func_id = func_id  # type: int
        # The number of the page to return. Default value: **1**. Valid values: **1 to 100000**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **20**. Valid values: **1 to 500**.
        self.page_size = page_size  # type: int
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsByFuncRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.func_filter is not None:
            result['FuncFilter'] = self.func_filter
        if self.func_id is not None:
            result['FuncId'] = self.func_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('FuncFilter') is not None:
            self.func_filter = m.get('FuncFilter')
        if m.get('FuncId') is not None:
            self.func_id = m.get('FuncId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageDataSourcesSource(TeaModel):
    def __init__(self, content=None, port=None, priority=None, type=None, weight=None):
        # The address of the origin server.
        self.content = content  # type: str
        # The port of the origin server.
        self.port = port  # type: int
        # The priority.
        self.priority = priority  # type: str
        # The type of the origin server.
        self.type = type  # type: str
        # The weight of the origin server if multiple origin servers have been specified.
        self.weight = weight  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageDataSourcesSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.type is not None:
            result['Type'] = self.type
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageDataSources(TeaModel):
    def __init__(self, source=None):
        self.source = source  # type: list[DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageDataSourcesSource]

    def validate(self):
        if self.source:
            for k in self.source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageDataSources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Source'] = []
        if self.source is not None:
            for k in self.source:
                result['Source'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.source = []
        if m.get('Source') is not None:
            for k in m.get('Source'):
                temp_model = DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageDataSourcesSource()
                self.source.append(temp_model.from_map(k))
        return self


class DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageData(TeaModel):
    def __init__(self, cname=None, description=None, domain_name=None, domain_status=None, gmt_created=None,
                 gmt_modified=None, resource_group_id=None, sandbox=None, sources=None, ssl_protocol=None):
        # The CNAME assigned to the accelerated domain name.
        self.cname = cname  # type: str
        # The reason why the accelerated domain name failed the review.
        self.description = description  # type: str
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str
        # The status of the accelerated domain name. Valid values:
        # 
        # *   **online**: enabled
        # *   **offline**: disabled
        # *   **configuring**: configuring
        # *   **configure_failed**: configuration failed
        # *   **checking**: reviewing
        # *   **check_failed**: failed the review
        self.domain_status = domain_status  # type: str
        # The time when the accelerated domain name was added.
        self.gmt_created = gmt_created  # type: str
        # The time when the accelerated domain name was modified.
        self.gmt_modified = gmt_modified  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # Indicates whether the accelerated domain name was in a sandbox.
        self.sandbox = sandbox  # type: str
        # The information about the origin server.
        self.sources = sources  # type: DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageDataSources
        # Indicates whether HTTPS is enabled. Valid values:
        # 
        # *   **on**\
        # *   **off**\
        self.ssl_protocol = ssl_protocol  # type: str

    def validate(self):
        if self.sources:
            self.sources.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.sandbox is not None:
            result['Sandbox'] = self.sandbox
        if self.sources is not None:
            result['Sources'] = self.sources.to_map()
        if self.ssl_protocol is not None:
            result['SslProtocol'] = self.ssl_protocol
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Sandbox') is not None:
            self.sandbox = m.get('Sandbox')
        if m.get('Sources') is not None:
            temp_model = DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageDataSources()
            self.sources = temp_model.from_map(m['Sources'])
        if m.get('SslProtocol') is not None:
            self.ssl_protocol = m.get('SslProtocol')
        return self


class DescribeDcdnUserDomainsByFuncResponseBodyDomains(TeaModel):
    def __init__(self, page_data=None):
        self.page_data = page_data  # type: list[DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageData]

    def validate(self):
        if self.page_data:
            for k in self.page_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsByFuncResponseBodyDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PageData'] = []
        if self.page_data is not None:
            for k in self.page_data:
                result['PageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.page_data = []
        if m.get('PageData') is not None:
            for k in m.get('PageData'):
                temp_model = DescribeDcdnUserDomainsByFuncResponseBodyDomainsPageData()
                self.page_data.append(temp_model.from_map(k))
        return self


class DescribeDcdnUserDomainsByFuncResponseBody(TeaModel):
    def __init__(self, domains=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The detailed information about each accelerated domain name. The returned information is displayed in the format that is specified by the PageData parameter.
        self.domains = domains  # type: DescribeDcdnUserDomainsByFuncResponseBodyDomains
        # The page number of the returned page.
        self.page_number = page_number  # type: long
        # The number of entries returned per page.
        self.page_size = page_size  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of domain names returned.
        self.total_count = total_count  # type: long

    def validate(self):
        if self.domains:
            self.domains.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsByFuncResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['Domains'] = self.domains.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Domains') is not None:
            temp_model = DescribeDcdnUserDomainsByFuncResponseBodyDomains()
            self.domains = temp_model.from_map(m['Domains'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnUserDomainsByFuncResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserDomainsByFuncResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserDomainsByFuncResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserDomainsByFuncResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserQuotaRequest(TeaModel):
    def __init__(self, owner_id=None, security_token=None):
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserQuotaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeDcdnUserQuotaResponseBody(TeaModel):
    def __init__(self, block_quota=None, block_remain=None, domain_quota=None, preload_quota=None,
                 preload_remain=None, refresh_dir_quota=None, refresh_dir_remain=None, refresh_url_quota=None,
                 refresh_url_remain=None, request_id=None):
        # The maximum number of URLs that can be blocked.
        self.block_quota = block_quota  # type: int
        # The remaining number of URLs that can be blocked.
        self.block_remain = block_remain  # type: int
        # The maximum number of accelerated domains.
        self.domain_quota = domain_quota  # type: int
        # The maximum number of URLs that can be prefetched.
        self.preload_quota = preload_quota  # type: int
        # The remaining number of URLs that can be prefetched.
        self.preload_remain = preload_remain  # type: int
        # The maximum number of directories that can be refreshed.
        self.refresh_dir_quota = refresh_dir_quota  # type: int
        # The remaining number of directories that can be refreshed.
        self.refresh_dir_remain = refresh_dir_remain  # type: int
        # The maximum number of URLs that can be refreshed.
        self.refresh_url_quota = refresh_url_quota  # type: int
        # The remaining number of URLs that can be refreshed.
        self.refresh_url_remain = refresh_url_remain  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserQuotaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_quota is not None:
            result['BlockQuota'] = self.block_quota
        if self.block_remain is not None:
            result['BlockRemain'] = self.block_remain
        if self.domain_quota is not None:
            result['DomainQuota'] = self.domain_quota
        if self.preload_quota is not None:
            result['PreloadQuota'] = self.preload_quota
        if self.preload_remain is not None:
            result['PreloadRemain'] = self.preload_remain
        if self.refresh_dir_quota is not None:
            result['RefreshDirQuota'] = self.refresh_dir_quota
        if self.refresh_dir_remain is not None:
            result['RefreshDirRemain'] = self.refresh_dir_remain
        if self.refresh_url_quota is not None:
            result['RefreshUrlQuota'] = self.refresh_url_quota
        if self.refresh_url_remain is not None:
            result['RefreshUrlRemain'] = self.refresh_url_remain
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlockQuota') is not None:
            self.block_quota = m.get('BlockQuota')
        if m.get('BlockRemain') is not None:
            self.block_remain = m.get('BlockRemain')
        if m.get('DomainQuota') is not None:
            self.domain_quota = m.get('DomainQuota')
        if m.get('PreloadQuota') is not None:
            self.preload_quota = m.get('PreloadQuota')
        if m.get('PreloadRemain') is not None:
            self.preload_remain = m.get('PreloadRemain')
        if m.get('RefreshDirQuota') is not None:
            self.refresh_dir_quota = m.get('RefreshDirQuota')
        if m.get('RefreshDirRemain') is not None:
            self.refresh_dir_remain = m.get('RefreshDirRemain')
        if m.get('RefreshUrlQuota') is not None:
            self.refresh_url_quota = m.get('RefreshUrlQuota')
        if m.get('RefreshUrlRemain') is not None:
            self.refresh_url_remain = m.get('RefreshUrlRemain')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnUserQuotaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserQuotaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserQuotaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserRealTimeDeliveryFieldRequest(TeaModel):
    def __init__(self, business_type=None):
        # The type of the collected logs. Default value: cdn_log_access_l1. Valid values:
        # 
        # *   **cdn_log_access_l1**: access logs of L1 Dynamic Route for CDN (DCDN) nodes
        # *   **cdn_log_origin**: back-to-origin logs
        # *   **cdn_log_er**: EdgeRoutine logs
        self.business_type = business_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserRealTimeDeliveryFieldRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        return self


class DescribeDcdnUserRealTimeDeliveryFieldResponseBodyContentFields(TeaModel):
    def __init__(self, description=None, field_name=None, selected=None):
        # The description of the field.
        self.description = description  # type: str
        # The name of the field.
        self.field_name = field_name  # type: str
        # Indicates whether a field was selected.
        # 
        # *   **true**: The field was selected.
        # *   **false**: The field was not selected.
        self.selected = selected  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserRealTimeDeliveryFieldResponseBodyContentFields, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.selected is not None:
            result['Selected'] = self.selected
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('Selected') is not None:
            self.selected = m.get('Selected')
        return self


class DescribeDcdnUserRealTimeDeliveryFieldResponseBodyContent(TeaModel):
    def __init__(self, fields=None):
        self.fields = fields  # type: list[DescribeDcdnUserRealTimeDeliveryFieldResponseBodyContentFields]

    def validate(self):
        if self.fields:
            for k in self.fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserRealTimeDeliveryFieldResponseBodyContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Fields'] = []
        if self.fields is not None:
            for k in self.fields:
                result['Fields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fields = []
        if m.get('Fields') is not None:
            for k in m.get('Fields'):
                temp_model = DescribeDcdnUserRealTimeDeliveryFieldResponseBodyContentFields()
                self.fields.append(temp_model.from_map(k))
        return self


class DescribeDcdnUserRealTimeDeliveryFieldResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The configuration results of the domain name.
        self.content = content  # type: DescribeDcdnUserRealTimeDeliveryFieldResponseBodyContent
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserRealTimeDeliveryFieldResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = DescribeDcdnUserRealTimeDeliveryFieldResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnUserRealTimeDeliveryFieldResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserRealTimeDeliveryFieldResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserRealTimeDeliveryFieldResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserRealTimeDeliveryFieldResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserResourcePackageRequest(TeaModel):
    def __init__(self, owner_id=None, security_token=None, status=None):
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str
        # The status of the resource plan. Valid values:
        # 
        # *   **valid**: The resource plan is valid.
        # *   **closed**: The resource plan is expired.
        # *   If you leave this parameter empty, all resource plans are queried.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserResourcePackageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDcdnUserResourcePackageResponseBodyResourcePackageInfosResourcePackageInfo(TeaModel):
    def __init__(self, commodity_code=None, curr_capacity=None, display_name=None, end_time=None,
                 init_capacity=None, instance_id=None, start_time=None, status=None, template_name=None):
        # The commodity code of the resource plan.
        self.commodity_code = commodity_code  # type: str
        # The remaining quota of the resource plan.
        # 
        # *   The unit for traffic: bytes.
        # *   The unit for requests: count.
        self.curr_capacity = curr_capacity  # type: str
        # The name of the resource plan.
        self.display_name = display_name  # type: str
        # The time when the resource plan expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.end_time = end_time  # type: str
        # The total quota of the resource plan.
        # 
        # *   The unit for traffic: bytes.
        # *   The unit for requests: count.
        self.init_capacity = init_capacity  # type: str
        # The ID of the resource plan.
        self.instance_id = instance_id  # type: str
        # The time when the resource plan takes effect. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.start_time = start_time  # type: str
        # The status of the resource plan. Valid values:
        # 
        # *   **valid**: The resource plan is valid.
        # *   **closed**: The resource package is expired.
        self.status = status  # type: str
        # The name of the template.
        self.template_name = template_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserResourcePackageResponseBodyResourcePackageInfosResourcePackageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.curr_capacity is not None:
            result['CurrCapacity'] = self.curr_capacity
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.init_capacity is not None:
            result['InitCapacity'] = self.init_capacity
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CurrCapacity') is not None:
            self.curr_capacity = m.get('CurrCapacity')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InitCapacity') is not None:
            self.init_capacity = m.get('InitCapacity')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        return self


class DescribeDcdnUserResourcePackageResponseBodyResourcePackageInfos(TeaModel):
    def __init__(self, resource_package_info=None):
        self.resource_package_info = resource_package_info  # type: list[DescribeDcdnUserResourcePackageResponseBodyResourcePackageInfosResourcePackageInfo]

    def validate(self):
        if self.resource_package_info:
            for k in self.resource_package_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserResourcePackageResponseBodyResourcePackageInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResourcePackageInfo'] = []
        if self.resource_package_info is not None:
            for k in self.resource_package_info:
                result['ResourcePackageInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource_package_info = []
        if m.get('ResourcePackageInfo') is not None:
            for k in m.get('ResourcePackageInfo'):
                temp_model = DescribeDcdnUserResourcePackageResponseBodyResourcePackageInfosResourcePackageInfo()
                self.resource_package_info.append(temp_model.from_map(k))
        return self


class DescribeDcdnUserResourcePackageResponseBody(TeaModel):
    def __init__(self, request_id=None, resource_package_infos=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The detailed information about resource plans. The returned information is displayed in the format that is specified by the ResourcePackageInfo parameter.
        self.resource_package_infos = resource_package_infos  # type: DescribeDcdnUserResourcePackageResponseBodyResourcePackageInfos

    def validate(self):
        if self.resource_package_infos:
            self.resource_package_infos.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserResourcePackageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_package_infos is not None:
            result['ResourcePackageInfos'] = self.resource_package_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourcePackageInfos') is not None:
            temp_model = DescribeDcdnUserResourcePackageResponseBodyResourcePackageInfos()
            self.resource_package_infos = temp_model.from_map(m['ResourcePackageInfos'])
        return self


class DescribeDcdnUserResourcePackageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserResourcePackageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserResourcePackageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserResourcePackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserSecDropRequest(TeaModel):
    def __init__(self, data=None, metric=None, sec_func=None):
        # The date or month that you want to query.
        # 
        # *   If data is collected every day, set the date in the format of yyyymmdd, such as 20201203.
        # *   If data is collected every month, set the month in the format of yyyymm, such as 202012.
        self.data = data  # type: str
        # The time interval at which data is collected.
        # 
        # *   If data is collected every day, the number of blocked packets on the specified day is calculated.
        # *   If data is collected every month, the number of blocked packets in the specified month is calculated.
        self.metric = metric  # type: str
        # The security feature. Valid values:
        # 
        # *   waf: WAF
        # *   tmd: rate limiting
        # *   robot: bot traffic recognition
        # *   l4\_dm_drop: domain name blocking on Layer 4
        self.sec_func = sec_func  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserSecDropRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.metric is not None:
            result['Metric'] = self.metric
        if self.sec_func is not None:
            result['SecFunc'] = self.sec_func
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Metric') is not None:
            self.metric = m.get('Metric')
        if m.get('SecFunc') is not None:
            self.sec_func = m.get('SecFunc')
        return self


class DescribeDcdnUserSecDropResponseBody(TeaModel):
    def __init__(self, drops=None, msg=None, request_id=None, uuid_str=None):
        # The number of packets that are blocked.
        self.drops = drops  # type: int
        # Indicates whether the information is found.
        # 
        # *   Found: yes
        # *   Not Found: no
        self.msg = msg  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The character string that is concatenated based on the request parameters and is used to locate causes when data is not found.
        self.uuid_str = uuid_str  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserSecDropResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drops is not None:
            result['Drops'] = self.drops
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.uuid_str is not None:
            result['UuidStr'] = self.uuid_str
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Drops') is not None:
            self.drops = m.get('Drops')
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UuidStr') is not None:
            self.uuid_str = m.get('UuidStr')
        return self


class DescribeDcdnUserSecDropResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserSecDropResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserSecDropResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserSecDropResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserSecDropByMinuteRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, lang=None, object=None, page_number=None, page_size=None,
                 rule_name=None, sec_func=None, start_time=None):
        # The domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0. Example: 2006-01-02T15:05:04Z.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time  # type: str
        # The language. Valid values: en and zh. Default value: en
        self.lang = lang  # type: str
        # The object that triggered the rule.
        self.object = object  # type: str
        # The number of the page to return. Pages start from page 1.
        self.page_number = page_number  # type: long
        # The number of entries to return on each page. Maximum value: 100.
        self.page_size = page_size  # type: long
        # The rule that was triggered.
        self.rule_name = rule_name  # type: str
        # The name of the security feature.
        self.sec_func = sec_func  # type: str
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0. Example: 2006-01-02T15:04:04Z.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserSecDropByMinuteRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.object is not None:
            result['Object'] = self.object
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.sec_func is not None:
            result['SecFunc'] = self.sec_func
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SecFunc') is not None:
            self.sec_func = m.get('SecFunc')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnUserSecDropByMinuteResponseBodyRows(TeaModel):
    def __init__(self, domain=None, drops=None, object=None, rule_name=None, sec_func=None, tm_str=None):
        # The domain name.
        self.domain = domain  # type: str
        # The number of packets blocked within 5 minutes.
        self.drops = drops  # type: int
        # The object that triggered the rule.
        self.object = object  # type: str
        # The rule that is triggered.
        self.rule_name = rule_name  # type: str
        # The security feature that blocked the packets.
        self.sec_func = sec_func  # type: str
        # The beginning of the time range that was queried. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is in UTC+0.
        self.tm_str = tm_str  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserSecDropByMinuteResponseBodyRows, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.drops is not None:
            result['Drops'] = self.drops
        if self.object is not None:
            result['Object'] = self.object
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.sec_func is not None:
            result['SecFunc'] = self.sec_func
        if self.tm_str is not None:
            result['TmStr'] = self.tm_str
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Drops') is not None:
            self.drops = m.get('Drops')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SecFunc') is not None:
            self.sec_func = m.get('SecFunc')
        if m.get('TmStr') is not None:
            self.tm_str = m.get('TmStr')
        return self


class DescribeDcdnUserSecDropByMinuteResponseBody(TeaModel):
    def __init__(self, description=None, len=None, page_number=None, page_size=None, request_id=None, rows=None,
                 total_count=None):
        # The description of HTTP responses.
        self.description = description  # type: str
        # The total number of entries returned.
        self.len = len  # type: int
        # The number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned on each page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The array returned.
        self.rows = rows  # type: list[DescribeDcdnUserSecDropByMinuteResponseBodyRows]
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.rows:
            for k in self.rows:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserSecDropByMinuteResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.len is not None:
            result['Len'] = self.len
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Rows'] = []
        if self.rows is not None:
            for k in self.rows:
                result['Rows'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Len') is not None:
            self.len = m.get('Len')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.rows = []
        if m.get('Rows') is not None:
            for k in m.get('Rows'):
                temp_model = DescribeDcdnUserSecDropByMinuteResponseBodyRows()
                self.rows.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnUserSecDropByMinuteResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserSecDropByMinuteResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserSecDropByMinuteResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserSecDropByMinuteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnUserTagsResponseBodyTags(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of the returned tag.
        self.key = key  # type: str
        # The value of the returned tag.
        self.value = value  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnUserTagsResponseBodyTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnUserTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, tags=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The tags.
        self.tags = tags  # type: list[DescribeDcdnUserTagsResponseBodyTags]

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeDcdnUserTagsResponseBodyTags()
                self.tags.append(temp_model.from_map(k))
        return self


class DescribeDcdnUserTagsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnUserTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnUserTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnUserTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnVerifyContentRequest(TeaModel):
    def __init__(self, domain_name=None):
        # The domain name for which you want to query the ownership verification content. You can specify only one domain name in one request.
        self.domain_name = domain_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnVerifyContentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeDcdnVerifyContentResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The verification content.
        self.content = content  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnVerifyContentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnVerifyContentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnVerifyContentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnVerifyContentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnVerifyContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafDomainRequest(TeaModel):
    def __init__(self, domain_name=None, region_id=None, resource_group_id=None):
        # The accelerated domain name. If you do not specify an accelerated domain name, all accelerated domain names are queried.
        self.domain_name = domain_name  # type: str
        # The region where WAF is enabled.
        self.region_id = region_id  # type: str
        # The ID of the resource group. If you leave this parameter empty, the default resource group is used.
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeDcdnWafDomainResponseBodyOutPutDomains(TeaModel):
    def __init__(self, acl_status=None, cc_status=None, domain=None, status=None, waf_status=None):
        # The status of the ACL. Valid values:
        # 
        # *   0: disabled
        # *   1: enabled
        self.acl_status = acl_status  # type: int
        # The status of protection against HTTP flood attacks. Valid values:
        # 
        # *   0: disabled
        # *   1: enabled
        self.cc_status = cc_status  # type: int
        # The domain name that has WAF enabled.
        self.domain = domain  # type: str
        # The status of the domain name. Valid values:
        # 
        # *   1: The domain name is added to WAF, or the domain name is valid.
        # *   10: The domain name is being added to WAF.
        # *   11: The domain name failed to be added to WAF.
        self.status = status  # type: int
        # The status of WAF. Valid values:
        # 
        # *   0: disabled
        # *   1: enabled
        self.waf_status = waf_status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafDomainResponseBodyOutPutDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_status is not None:
            result['AclStatus'] = self.acl_status
        if self.cc_status is not None:
            result['CcStatus'] = self.cc_status
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.status is not None:
            result['Status'] = self.status
        if self.waf_status is not None:
            result['WafStatus'] = self.waf_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AclStatus') is not None:
            self.acl_status = m.get('AclStatus')
        if m.get('CcStatus') is not None:
            self.cc_status = m.get('CcStatus')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('WafStatus') is not None:
            self.waf_status = m.get('WafStatus')
        return self


class DescribeDcdnWafDomainResponseBody(TeaModel):
    def __init__(self, out_put_domains=None, request_id=None, total_count=None):
        # Details about the accelerated domain names.
        self.out_put_domains = out_put_domains  # type: list[DescribeDcdnWafDomainResponseBodyOutPutDomains]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The number of accelerated domain names returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.out_put_domains:
            for k in self.out_put_domains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OutPutDomains'] = []
        if self.out_put_domains is not None:
            for k in self.out_put_domains:
                result['OutPutDomains'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.out_put_domains = []
        if m.get('OutPutDomains') is not None:
            for k in m.get('OutPutDomains'):
                temp_model = DescribeDcdnWafDomainResponseBodyOutPutDomains()
                self.out_put_domains.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnWafDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafDomainDetailRequest(TeaModel):
    def __init__(self, domain_name=None):
        # The accelerated domain name. You can specify only one domain name in each request. Exact match is supported.
        self.domain_name = domain_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafDomainDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeDcdnWafDomainDetailResponseBodyDomainDefenseScenes(TeaModel):
    def __init__(self, defense_scene=None, policy_id=None, policy_ids=None):
        # The type of the protection policy. Valid values:
        # 
        # *   waf_group: basic web protection
        # *   custom_acl: custom protection
        # *   whitelist: IP address whitelist
        self.defense_scene = defense_scene  # type: str
        # The ID of the protection policy. If multiple IDs exist, only one ID is returned.
        self.policy_id = policy_id  # type: long
        # The IDs of the protection policies. Multiple IDs are separated by commas (,).
        self.policy_ids = policy_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafDomainDetailResponseBodyDomainDefenseScenes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defense_scene is not None:
            result['DefenseScene'] = self.defense_scene
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenseScene') is not None:
            self.defense_scene = m.get('DefenseScene')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        return self


class DescribeDcdnWafDomainDetailResponseBodyDomain(TeaModel):
    def __init__(self, defense_scenes=None, domain_name=None):
        # The types of the protection policies.
        self.defense_scenes = defense_scenes  # type: list[DescribeDcdnWafDomainDetailResponseBodyDomainDefenseScenes]
        # The accelerated domain name.
        self.domain_name = domain_name  # type: str

    def validate(self):
        if self.defense_scenes:
            for k in self.defense_scenes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafDomainDetailResponseBodyDomain, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DefenseScenes'] = []
        if self.defense_scenes is not None:
            for k in self.defense_scenes:
                result['DefenseScenes'].append(k.to_map() if k else None)
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.defense_scenes = []
        if m.get('DefenseScenes') is not None:
            for k in m.get('DefenseScenes'):
                temp_model = DescribeDcdnWafDomainDetailResponseBodyDomainDefenseScenes()
                self.defense_scenes.append(temp_model.from_map(k))
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeDcdnWafDomainDetailResponseBody(TeaModel):
    def __init__(self, domain=None, request_id=None):
        # The information about the accelerated domain name.
        self.domain = domain  # type: DescribeDcdnWafDomainDetailResponseBodyDomain
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain:
            self.domain.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafDomainDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Domain') is not None:
            temp_model = DescribeDcdnWafDomainDetailResponseBodyDomain()
            self.domain = temp_model.from_map(m['Domain'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnWafDomainDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafDomainDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafDomainDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafDomainsRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, query_args=None):
        # The page number of the returned page. Valid values: **1** to **100000**.
        # 
        # Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of domain names to return per page. Valid values: an integer from **1** to **500**. Default value: **20**.
        self.page_size = page_size  # type: int
        # The query conditions. You can filter domain names by name. Fuzzy match is supported
        # 
        #     QueryArgs={"DomainName":"Accelerated domain name"}
        self.query_args = query_args  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafDomainsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_args is not None:
            result['QueryArgs'] = self.query_args
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryArgs') is not None:
            self.query_args = m.get('QueryArgs')
        return self


class DescribeDcdnWafDomainsResponseBodyDomains(TeaModel):
    def __init__(self, client_ip_tag=None, domain_name=None, policy_count=None):
        # The header of IP address of the client that is connected to the point of presence (POP).
        self.client_ip_tag = client_ip_tag  # type: str
        # The protected domain name.
        self.domain_name = domain_name  # type: str
        # The number of protection policies that were configured for the protected domain name.
        self.policy_count = policy_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafDomainsResponseBodyDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip_tag is not None:
            result['ClientIpTag'] = self.client_ip_tag
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.policy_count is not None:
            result['PolicyCount'] = self.policy_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientIpTag') is not None:
            self.client_ip_tag = m.get('ClientIpTag')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('PolicyCount') is not None:
            self.policy_count = m.get('PolicyCount')
        return self


class DescribeDcdnWafDomainsResponseBody(TeaModel):
    def __init__(self, domains=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The protected domain names.
        self.domains = domains  # type: list[DescribeDcdnWafDomainsResponseBodyDomains]
        # The page number of the returned page, which is the same as the PageNumber parameter in request parameters.
        self.page_number = page_number  # type: int
        # The number of domain names returned per page, which is the same as the PageSize parameter in request parameters.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of protected domain names.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.domains:
            for k in self.domains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafDomainsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Domains'] = []
        if self.domains is not None:
            for k in self.domains:
                result['Domains'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domains = []
        if m.get('Domains') is not None:
            for k in m.get('Domains'):
                temp_model = DescribeDcdnWafDomainsResponseBodyDomains()
                self.domains.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnWafDomainsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafDomainsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafDomainsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafFilterInfoRequest(TeaModel):
    def __init__(self, defense_scenes=None, language=None):
        # The type of the protection policy. Separate multiple types with commas (,). Valid values:
        # 
        # *   waf_group: basic web protection
        # *   custom_acl: custom
        # *   whitelist: whitelist
        # 
        # >  If you do not specify this parameter, all types are returned.
        self.defense_scenes = defense_scenes  # type: str
        # The language of the returned information. Default value: en. Valid values:
        # 
        # *   en: English
        # *   cn: Simplified Chinese
        self.language = language  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafFilterInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defense_scenes is not None:
            result['DefenseScenes'] = self.defense_scenes
        if self.language is not None:
            result['Language'] = self.language
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenseScenes') is not None:
            self.defense_scenes = m.get('DefenseScenes')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        return self


class DescribeDcdnWafFilterInfoResponseBodyContentFieldsLogicalSymbolRegexp(TeaModel):
    def __init__(self, err_msg=None, pattern=None):
        # The error message returned because no items match the regular expression.
        self.err_msg = err_msg  # type: str
        # The regular expression.
        self.pattern = pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafFilterInfoResponseBodyContentFieldsLogicalSymbolRegexp, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.err_msg is not None:
            result['ErrMsg'] = self.err_msg
        if self.pattern is not None:
            result['Pattern'] = self.pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrMsg') is not None:
            self.err_msg = m.get('ErrMsg')
        if m.get('Pattern') is not None:
            self.pattern = m.get('Pattern')
        return self


class DescribeDcdnWafFilterInfoResponseBodyContentFieldsLogicalSymbol(TeaModel):
    def __init__(self, description=None, max_length=None, regexp=None, symbol=None, tip=None, type=None):
        # The logical symbol that is displayed in the Dynamic Route for CDN (DCDN) console.
        self.description = description  # type: str
        # The maximum number of match contents that you can specify. The value of this parameter varies based on the value of the Type parameter. Valid values:
        # 
        # *   If the value of the Type parameter is **multi**, the value of this parameter is the maximum number of match contents.
        # *   If the value of the Type parameter is **single**, the value of this parameter is 1.
        # *   If the value of the Type parameter is **none**, the value of this parameter is 0.
        self.max_length = max_length  # type: int
        # The information about the regular expression.
        self.regexp = regexp  # type: DescribeDcdnWafFilterInfoResponseBodyContentFieldsLogicalSymbolRegexp
        # The logical symbol that is passed to the backend.
        self.symbol = symbol  # type: str
        # The tips that are displayed in the match content.
        self.tip = tip  # type: str
        # The number of match contents that you can specify. Valid values:
        # 
        # *   multi: You can specify multiple match contents.
        # *   single: You can specify only a match content.
        # *   none: You cannot specify a match content.
        self.type = type  # type: str

    def validate(self):
        if self.regexp:
            self.regexp.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafFilterInfoResponseBodyContentFieldsLogicalSymbol, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.max_length is not None:
            result['MaxLength'] = self.max_length
        if self.regexp is not None:
            result['Regexp'] = self.regexp.to_map()
        if self.symbol is not None:
            result['Symbol'] = self.symbol
        if self.tip is not None:
            result['Tip'] = self.tip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MaxLength') is not None:
            self.max_length = m.get('MaxLength')
        if m.get('Regexp') is not None:
            temp_model = DescribeDcdnWafFilterInfoResponseBodyContentFieldsLogicalSymbolRegexp()
            self.regexp = temp_model.from_map(m['Regexp'])
        if m.get('Symbol') is not None:
            self.symbol = m.get('Symbol')
        if m.get('Tip') is not None:
            self.tip = m.get('Tip')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDcdnWafFilterInfoResponseBodyContentFields(TeaModel):
    def __init__(self, extend_field=None, logical_symbol=None, match_field=None):
        # The description of the match field. If this parameter is not returned or if this parameter is empty, the match field does not have a description.
        self.extend_field = extend_field  # type: str
        # The information about the logical symbol.
        self.logical_symbol = logical_symbol  # type: list[DescribeDcdnWafFilterInfoResponseBodyContentFieldsLogicalSymbol]
        # The match field.
        self.match_field = match_field  # type: str

    def validate(self):
        if self.logical_symbol:
            for k in self.logical_symbol:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafFilterInfoResponseBodyContentFields, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extend_field is not None:
            result['ExtendField'] = self.extend_field
        result['LogicalSymbol'] = []
        if self.logical_symbol is not None:
            for k in self.logical_symbol:
                result['LogicalSymbol'].append(k.to_map() if k else None)
        if self.match_field is not None:
            result['MatchField'] = self.match_field
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExtendField') is not None:
            self.extend_field = m.get('ExtendField')
        self.logical_symbol = []
        if m.get('LogicalSymbol') is not None:
            for k in m.get('LogicalSymbol'):
                temp_model = DescribeDcdnWafFilterInfoResponseBodyContentFieldsLogicalSymbol()
                self.logical_symbol.append(temp_model.from_map(k))
        if m.get('MatchField') is not None:
            self.match_field = m.get('MatchField')
        return self


class DescribeDcdnWafFilterInfoResponseBodyContent(TeaModel):
    def __init__(self, defense_scene=None, fields=None):
        # The type of the protection policy, which is the same as the DefenseScenes parameter in request parameters.
        self.defense_scene = defense_scene  # type: str
        # The information about the match condition.
        self.fields = fields  # type: list[DescribeDcdnWafFilterInfoResponseBodyContentFields]

    def validate(self):
        if self.fields:
            for k in self.fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafFilterInfoResponseBodyContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defense_scene is not None:
            result['DefenseScene'] = self.defense_scene
        result['Fields'] = []
        if self.fields is not None:
            for k in self.fields:
                result['Fields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenseScene') is not None:
            self.defense_scene = m.get('DefenseScene')
        self.fields = []
        if m.get('Fields') is not None:
            for k in m.get('Fields'):
                temp_model = DescribeDcdnWafFilterInfoResponseBodyContentFields()
                self.fields.append(temp_model.from_map(k))
        return self


class DescribeDcdnWafFilterInfoResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The returned information.
        self.content = content  # type: list[DescribeDcdnWafFilterInfoResponseBodyContent]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafFilterInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Content'] = []
        if self.content is not None:
            for k in self.content:
                result['Content'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.content = []
        if m.get('Content') is not None:
            for k in m.get('Content'):
                temp_model = DescribeDcdnWafFilterInfoResponseBodyContent()
                self.content.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnWafFilterInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafFilterInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafFilterInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafFilterInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafGeoInfoRequest(TeaModel):
    def __init__(self, language=None):
        # The language of the information to return. Valid values:
        # 
        # *   cn: Chinese
        # *   en: English
        self.language = language  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafGeoInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.language is not None:
            result['Language'] = self.language
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Language') is not None:
            self.language = m.get('Language')
        return self


class DescribeDcdnWafGeoInfoResponseBodyContentContinentsRegions(TeaModel):
    def __init__(self, name=None, value=None):
        # The name of the country or region.
        self.name = name  # type: str
        # The code of the country or region.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafGeoInfoResponseBodyContentContinentsRegions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDcdnWafGeoInfoResponseBodyContentContinents(TeaModel):
    def __init__(self, name=None, regions=None):
        # The district to which the country or region belongs.
        self.name = name  # type: str
        # The region information.
        self.regions = regions  # type: list[DescribeDcdnWafGeoInfoResponseBodyContentContinentsRegions]

    def validate(self):
        if self.regions:
            for k in self.regions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafGeoInfoResponseBodyContentContinents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        result['Regions'] = []
        if self.regions is not None:
            for k in self.regions:
                result['Regions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.regions = []
        if m.get('Regions') is not None:
            for k in m.get('Regions'):
                temp_model = DescribeDcdnWafGeoInfoResponseBodyContentContinentsRegions()
                self.regions.append(temp_model.from_map(k))
        return self


class DescribeDcdnWafGeoInfoResponseBodyContent(TeaModel):
    def __init__(self, continents=None, type=None):
        # The information about the country or region.
        self.continents = continents  # type: list[DescribeDcdnWafGeoInfoResponseBodyContentContinents]
        # The type of the region.
        # 
        # *   CN: China
        # *   Other: outside China
        self.type = type  # type: str

    def validate(self):
        if self.continents:
            for k in self.continents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafGeoInfoResponseBodyContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Continents'] = []
        if self.continents is not None:
            for k in self.continents:
                result['Continents'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.continents = []
        if m.get('Continents') is not None:
            for k in m.get('Continents'):
                temp_model = DescribeDcdnWafGeoInfoResponseBodyContentContinents()
                self.continents.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDcdnWafGeoInfoResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        # The type of information about the country or region.
        self.content = content  # type: list[DescribeDcdnWafGeoInfoResponseBodyContent]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafGeoInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Content'] = []
        if self.content is not None:
            for k in self.content:
                result['Content'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.content = []
        if m.get('Content') is not None:
            for k in m.get('Content'):
                temp_model = DescribeDcdnWafGeoInfoResponseBodyContent()
                self.content.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnWafGeoInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafGeoInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafGeoInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafGeoInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafLogsRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, page_number=None, page_size=None, start_time=None):
        # The accelerated domain name. You can specify only one domain name.
        self.domain_name = domain_name  # type: str
        # The end of the time range to query the logs.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.end_time = end_time  # type: str
        # The number of the page to return. Valid values: positive integers.
        self.page_number = page_number  # type: long
        # The number of entries to return on each page. Default value: **300**. Valid values: **1 to 1000**.
        self.page_size = page_size  # type: long
        # The beginning of the time range to query the logs.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafLogsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnWafLogsResponseBodyDomainLogDetailsLogInfos(TeaModel):
    def __init__(self, end_time=None, log_name=None, log_path=None, log_size=None, start_time=None):
        # The end of the time range during which data was queried.
        self.end_time = end_time  # type: str
        # The name of the log file.
        self.log_name = log_name  # type: str
        # The path of the log file.
        self.log_path = log_path  # type: str
        # The size of the log file. Unit: bytes.
        self.log_size = log_size  # type: long
        # The beginning of the time range during which data was queried.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafLogsResponseBodyDomainLogDetailsLogInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.log_name is not None:
            result['LogName'] = self.log_name
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.log_size is not None:
            result['LogSize'] = self.log_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('LogName') is not None:
            self.log_name = m.get('LogName')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('LogSize') is not None:
            self.log_size = m.get('LogSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDcdnWafLogsResponseBodyDomainLogDetailsPageInfos(TeaModel):
    def __init__(self, page_index=None, page_size=None, total=None):
        # The page number of the returned page.
        self.page_index = page_index  # type: long
        # The number of entries returned per page.
        self.page_size = page_size  # type: long
        # The total number of entries returned.
        self.total = total  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafLogsResponseBodyDomainLogDetailsPageInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDcdnWafLogsResponseBodyDomainLogDetails(TeaModel):
    def __init__(self, domain_name=None, log_count=None, log_infos=None, page_infos=None):
        # The WAF domain name.
        self.domain_name = domain_name  # type: str
        # The total number of entries returned on the current page.
        self.log_count = log_count  # type: long
        # The log information.
        self.log_infos = log_infos  # type: list[DescribeDcdnWafLogsResponseBodyDomainLogDetailsLogInfos]
        # The page information. The page information is indicated by the PageInfoDetail parameter.
        self.page_infos = page_infos  # type: DescribeDcdnWafLogsResponseBodyDomainLogDetailsPageInfos

    def validate(self):
        if self.log_infos:
            for k in self.log_infos:
                if k:
                    k.validate()
        if self.page_infos:
            self.page_infos.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafLogsResponseBodyDomainLogDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.log_count is not None:
            result['LogCount'] = self.log_count
        result['LogInfos'] = []
        if self.log_infos is not None:
            for k in self.log_infos:
                result['LogInfos'].append(k.to_map() if k else None)
        if self.page_infos is not None:
            result['PageInfos'] = self.page_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LogCount') is not None:
            self.log_count = m.get('LogCount')
        self.log_infos = []
        if m.get('LogInfos') is not None:
            for k in m.get('LogInfos'):
                temp_model = DescribeDcdnWafLogsResponseBodyDomainLogDetailsLogInfos()
                self.log_infos.append(temp_model.from_map(k))
        if m.get('PageInfos') is not None:
            temp_model = DescribeDcdnWafLogsResponseBodyDomainLogDetailsPageInfos()
            self.page_infos = temp_model.from_map(m['PageInfos'])
        return self


class DescribeDcdnWafLogsResponseBody(TeaModel):
    def __init__(self, domain_log_details=None, request_id=None):
        # Details about domain logs.
        self.domain_log_details = domain_log_details  # type: list[DescribeDcdnWafLogsResponseBodyDomainLogDetails]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_log_details:
            for k in self.domain_log_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafLogsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainLogDetails'] = []
        if self.domain_log_details is not None:
            for k in self.domain_log_details:
                result['DomainLogDetails'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_log_details = []
        if m.get('DomainLogDetails') is not None:
            for k in m.get('DomainLogDetails'):
                temp_model = DescribeDcdnWafLogsResponseBodyDomainLogDetails()
                self.domain_log_details.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnWafLogsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafLogsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafLogsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafPoliciesRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, query_args=None):
        # The number of the page to return. Valid values: **1** to **100000**. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of protection policies to return per page. Valid values: an integer from **1** to **500**. Default value: **20**.
        self.page_size = page_size  # type: int
        # The query conditions. The value is a string in the JSON format.
        # 
        # Format:
        # 
        #     QueryArgs={"PolicyIds":"The ID of the proteuleIds":"Thection policy","R range of protection rule IDs","PolicyNameLike":"The name of the protection policy","DomainNames":"The protected domain names","PolicyType":"default","DefenseScenes":"waf_group","PolicyStatus":"on","OrderBy":"GmtModified","Desc":"false"}
        # 
        # >  If you do not set this parameter, all protection policies are queried.
        self.query_args = query_args  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafPoliciesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_args is not None:
            result['QueryArgs'] = self.query_args
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryArgs') is not None:
            self.query_args = m.get('QueryArgs')
        return self


class DescribeDcdnWafPoliciesResponseBodyPolicies(TeaModel):
    def __init__(self, defense_scene=None, domain_count=None, gmt_modified=None, policy_id=None, policy_name=None,
                 policy_status=None, policy_type=None, rule_count=None):
        # The type of the protection policy, which is the same as the DefenseScenes field in the QueryArgs parameter in request parameters.
        self.defense_scene = defense_scene  # type: str
        # The number of domain names that use this protection policy.
        self.domain_count = domain_count  # type: int
        # The time when the protection policy was modified. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.gmt_modified = gmt_modified  # type: str
        # The ID of the protection policy.
        self.policy_id = policy_id  # type: long
        # The name of the protection policy.
        self.policy_name = policy_name  # type: str
        # The status of the protection policy, which is the same as the PolicyStatus field in the QueryArgs parameter in request parameters.
        self.policy_status = policy_status  # type: str
        # Indicates whether this protection policy is the default policy, which is the same as the PolicyType field in the QueryArgs parameter in request parameters.
        self.policy_type = policy_type  # type: str
        # The number of protection rules in this protection policy.
        self.rule_count = rule_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafPoliciesResponseBodyPolicies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defense_scene is not None:
            result['DefenseScene'] = self.defense_scene
        if self.domain_count is not None:
            result['DomainCount'] = self.domain_count
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.policy_status is not None:
            result['PolicyStatus'] = self.policy_status
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.rule_count is not None:
            result['RuleCount'] = self.rule_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenseScene') is not None:
            self.defense_scene = m.get('DefenseScene')
        if m.get('DomainCount') is not None:
            self.domain_count = m.get('DomainCount')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('PolicyStatus') is not None:
            self.policy_status = m.get('PolicyStatus')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('RuleCount') is not None:
            self.rule_count = m.get('RuleCount')
        return self


class DescribeDcdnWafPoliciesResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, policies=None, request_id=None, total_count=None):
        # The page number of the returned page. Valid values: **1** to **100000**. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of protection policies returned per page. Valid values: an integer from **1** to **500**. Default value: **20**.
        self.page_size = page_size  # type: int
        # The protection policies.
        self.policies = policies  # type: list[DescribeDcdnWafPoliciesResponseBodyPolicies]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of protection policies.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafPoliciesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = DescribeDcdnWafPoliciesResponseBodyPolicies()
                self.policies.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnWafPoliciesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafPoliciesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafPoliciesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafPolicyRequest(TeaModel):
    def __init__(self, policy_id=None):
        # The ID of the protection policy. You can specify only one ID in each request.
        self.policy_id = policy_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        return self


class DescribeDcdnWafPolicyResponseBodyPolicy(TeaModel):
    def __init__(self, defense_scene=None, domain_count=None, gmt_modified=None, policy_id=None, policy_name=None,
                 policy_status=None, policy_type=None, rule_configs=None, rule_count=None):
        # The type of the protection policy. Valid values:
        # 
        # *   waf_group: basic web protection
        # *   custom_acl: custom
        # *   whitelist: whitelist
        self.defense_scene = defense_scene  # type: str
        # The number of domain names that use the protection policy.
        self.domain_count = domain_count  # type: int
        # The time when the protection policy was modified. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.gmt_modified = gmt_modified  # type: str
        # The ID of the protection policy.
        self.policy_id = policy_id  # type: long
        # The name of the protection policy.
        self.policy_name = policy_name  # type: str
        # The status of the protection policy. Valid values:
        # 
        # *   on
        # *   off
        self.policy_status = policy_status  # type: str
        # Indicates whether the current policy is the default policy. Valid values:
        # 
        # *   default: The current policy is the default policy.
        # *   custom: The current policy is not the default policy.
        self.policy_type = policy_type  # type: str
        # The protection rule configurations corresponding to the protection policy. The configurations only support Bot management. For more information, see [Configure protection rules](~~423350~~).
        self.rule_configs = rule_configs  # type: str
        # The number of protection rules in the protection policy.
        self.rule_count = rule_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyResponseBodyPolicy, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defense_scene is not None:
            result['DefenseScene'] = self.defense_scene
        if self.domain_count is not None:
            result['DomainCount'] = self.domain_count
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.policy_status is not None:
            result['PolicyStatus'] = self.policy_status
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.rule_configs is not None:
            result['RuleConfigs'] = self.rule_configs
        if self.rule_count is not None:
            result['RuleCount'] = self.rule_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenseScene') is not None:
            self.defense_scene = m.get('DefenseScene')
        if m.get('DomainCount') is not None:
            self.domain_count = m.get('DomainCount')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('PolicyStatus') is not None:
            self.policy_status = m.get('PolicyStatus')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('RuleConfigs') is not None:
            self.rule_configs = m.get('RuleConfigs')
        if m.get('RuleCount') is not None:
            self.rule_count = m.get('RuleCount')
        return self


class DescribeDcdnWafPolicyResponseBody(TeaModel):
    def __init__(self, policy=None, request_id=None):
        # The information about the protection policy.
        self.policy = policy  # type: DescribeDcdnWafPolicyResponseBodyPolicy
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.policy:
            self.policy.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy is not None:
            result['Policy'] = self.policy.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Policy') is not None:
            temp_model = DescribeDcdnWafPolicyResponseBodyPolicy()
            self.policy = temp_model.from_map(m['Policy'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnWafPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafPolicyDomainsRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, policy_id=None):
        # The number of the page to return. Valid values: **1** to **100000**. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of domain names to return per page. Valid values: an integer from **1** to **500**. Default value: **20**.
        self.page_size = page_size  # type: int
        # The ID of the protection policy. You can specify only one ID in each request.
        self.policy_id = policy_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyDomainsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        return self


class DescribeDcdnWafPolicyDomainsResponseBodyDomains(TeaModel):
    def __init__(self, domain_name=None):
        # The accelerated domain name that was protected by the specified protection policy.
        self.domain_name = domain_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyDomainsResponseBodyDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeDcdnWafPolicyDomainsResponseBody(TeaModel):
    def __init__(self, domains=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The accelerated domain names.
        self.domains = domains  # type: list[DescribeDcdnWafPolicyDomainsResponseBodyDomains]
        # The page number of the returned page, which is the same as the PageNumber parameter in request parameters.
        self.page_number = page_number  # type: int
        # The number of domain names returned per page, which is the same as the PageSize parameter in request parameters.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of domain names returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.domains:
            for k in self.domains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyDomainsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Domains'] = []
        if self.domains is not None:
            for k in self.domains:
                result['Domains'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domains = []
        if m.get('Domains') is not None:
            for k in m.get('Domains'):
                temp_model = DescribeDcdnWafPolicyDomainsResponseBodyDomains()
                self.domains.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnWafPolicyDomainsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafPolicyDomainsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyDomainsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafPolicyDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafPolicyValidDomainsRequest(TeaModel):
    def __init__(self, defense_scene=None, domain_name_like=None, page_number=None, page_size=None):
        # The type of the Web Application Firewall (WAF) protection policy. Valid values:
        # 
        # *   waf_group: basic web protection
        # *   custom_acl: custom protection
        # *   whitelist: IP address whitelist
        # *   ip_blacklist: IP address blacklist
        # *   region_block: region blacklist
        # *   bot: bot management
        self.defense_scene = defense_scene  # type: str
        # The protected domain name. Fuzzy search is supported.
        self.domain_name_like = domain_name_like  # type: str
        # The number of the page to return. Valid values: **1** to **100000**. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of domain names to return on each page. Valid values: an integer from **1** to **500**. Default value: **20**.
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyValidDomainsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defense_scene is not None:
            result['DefenseScene'] = self.defense_scene
        if self.domain_name_like is not None:
            result['DomainNameLike'] = self.domain_name_like
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenseScene') is not None:
            self.defense_scene = m.get('DefenseScene')
        if m.get('DomainNameLike') is not None:
            self.domain_name_like = m.get('DomainNameLike')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDcdnWafPolicyValidDomainsResponseBodyDomainsPolicies(TeaModel):
    def __init__(self, id=None, name=None, type=None):
        # The ID of the policy.
        self.id = id  # type: long
        # The name of the policy.
        self.name = name  # type: str
        # The type of the policy.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyValidDomainsResponseBodyDomainsPolicies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDcdnWafPolicyValidDomainsResponseBodyDomains(TeaModel):
    def __init__(self, domain_name=None, policies=None, policy_id=None, policy_name=None, policy_type=None):
        # The protected domain name.
        self.domain_name = domain_name  # type: str
        # The policy that is bound to the domain name.
        self.policies = policies  # type: list[DescribeDcdnWafPolicyValidDomainsResponseBodyDomainsPolicies]
        # The ID of the protection policy.
        self.policy_id = policy_id  # type: long
        # The name of the protection policy.
        self.policy_name = policy_name  # type: str
        # Indicates whether the protection policy is the default policy. Valid values:
        # 
        # *   default: The protection policy is the default policy.
        # *   custom: The protection policy is not the default policy.
        self.policy_type = policy_type  # type: str

    def validate(self):
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyValidDomainsResponseBodyDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = DescribeDcdnWafPolicyValidDomainsResponseBodyDomainsPolicies()
                self.policies.append(temp_model.from_map(k))
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        return self


class DescribeDcdnWafPolicyValidDomainsResponseBody(TeaModel):
    def __init__(self, domains=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The information about the protected domain names.
        self.domains = domains  # type: list[DescribeDcdnWafPolicyValidDomainsResponseBodyDomains]
        # The page number of the returned page, which is the same as the PageNumber parameter in request parameters.
        self.page_number = page_number  # type: int
        # The number of domain names returned per page, which is the same as the PageSize parameter in request parameters.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of domain names returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.domains:
            for k in self.domains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyValidDomainsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Domains'] = []
        if self.domains is not None:
            for k in self.domains:
                result['Domains'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domains = []
        if m.get('Domains') is not None:
            for k in m.get('Domains'):
                temp_model = DescribeDcdnWafPolicyValidDomainsResponseBodyDomains()
                self.domains.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnWafPolicyValidDomainsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafPolicyValidDomainsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafPolicyValidDomainsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafPolicyValidDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafRuleRequest(TeaModel):
    def __init__(self, rule_id=None):
        # The ID of the protection rule. You can specify only one ID in each request.
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribeDcdnWafRuleResponseBodyRule(TeaModel):
    def __init__(self, defense_scene=None, gmt_modified=None, policy_id=None, rule_config=None, rule_id=None,
                 rule_name=None, rule_status=None):
        # The type of the protection policy. Valid values:
        # 
        # - waf_group: basic web protection
        # - custom_acl: custom
        # - whitelist: whitelist
        self.defense_scene = defense_scene  # type: str
        # The time at which the protection rule was modified. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.gmt_modified = gmt_modified  # type: str
        # The ID of the protection policy.
        self.policy_id = policy_id  # type: long
        # The configurations of the protection rule.
        self.rule_config = rule_config  # type: str
        # The ID of the protection rule.
        self.rule_id = rule_id  # type: long
        # The name of the protection rule.
        self.rule_name = rule_name  # type: str
        # The status of the protection rule. Valid values:
        # 
        # - on
        # - off
        self.rule_status = rule_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafRuleResponseBodyRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defense_scene is not None:
            result['DefenseScene'] = self.defense_scene
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.rule_config is not None:
            result['RuleConfig'] = self.rule_config
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenseScene') is not None:
            self.defense_scene = m.get('DefenseScene')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RuleConfig') is not None:
            self.rule_config = m.get('RuleConfig')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        return self


class DescribeDcdnWafRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, rule=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the protection rule.
        self.rule = rule  # type: DescribeDcdnWafRuleResponseBodyRule

    def validate(self):
        if self.rule:
            self.rule.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule is not None:
            result['Rule'] = self.rule.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Rule') is not None:
            temp_model = DescribeDcdnWafRuleResponseBodyRule()
            self.rule = temp_model.from_map(m['Rule'])
        return self


class DescribeDcdnWafRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafRulesRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, query_args=None):
        # The number of the page to return. Valid values: **1** to **100000**. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of protection rules to return per page. Valid values: an integer from **1** to **500**. Default value: **20**.
        self.page_size = page_size  # type: int
        # The query conditions. The value is a string in the JSON format: `QueryArgs={"PolicyIds":"The range of protection policy IDs","RuleIds":"The range of protection rule IDs","RuleNameLike":"The name of the protection rule","DomainNames":"The protected domain names","DefenseScenes":"waf_group","RuleStatus":"on","OrderBy":"GmtModified","Desc":"false"}`
        # 
        # >  If you do not specify this parameter, all protection rules are queried.
        self.query_args = query_args  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_args is not None:
            result['QueryArgs'] = self.query_args
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryArgs') is not None:
            self.query_args = m.get('QueryArgs')
        return self


class DescribeDcdnWafRulesResponseBodyRules(TeaModel):
    def __init__(self, defense_scene=None, gmt_modified=None, policy_id=None, rule_config=None, rule_id=None,
                 rule_name=None, rule_status=None):
        # The type of the protection policy, which is the same as the DefenseScenes field in the QueryArgs parameter.
        self.defense_scene = defense_scene  # type: str
        # The modification time. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.gmt_modified = gmt_modified  # type: str
        # The ID of the protection policy.
        self.policy_id = policy_id  # type: long
        # The configuration information about the protection rule.
        self.rule_config = rule_config  # type: str
        # The ID of the protection rule.
        self.rule_id = rule_id  # type: long
        # The name of the protection rule.
        self.rule_name = rule_name  # type: str
        # The status of the protection rule, which is the same as the RuleStatus field in the QueryArgs parameter.
        self.rule_status = rule_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafRulesResponseBodyRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defense_scene is not None:
            result['DefenseScene'] = self.defense_scene
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.rule_config is not None:
            result['RuleConfig'] = self.rule_config
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenseScene') is not None:
            self.defense_scene = m.get('DefenseScene')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RuleConfig') is not None:
            self.rule_config = m.get('RuleConfig')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        return self


class DescribeDcdnWafRulesResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, rules=None, total_count=None):
        # The page number of the returned page, which is the same as the PageNumber parameter in request parameters.
        self.page_number = page_number  # type: int
        # The number of protection rules returned per page, which is the same as the PageSize parameter in request parameters.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the protection rule.
        self.rules = rules  # type: list[DescribeDcdnWafRulesResponseBodyRules]
        # The total number of protection rules.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeDcdnWafRulesResponseBodyRules()
                self.rules.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDcdnWafRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDcdnWafRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDcdnWafScenesRequest(TeaModel):
    def __init__(self, defense_scenes=None):
        # The types of the protection policies that you want to query. Separate multiple types with commas (,). Valid values:
        # 
        # *   waf_group: basic web protection
        # *   custom_acl: custom protection
        # *   whitelist: IP address whitelist
        # *   ip_blacklist: IP address blacklist
        # *   region_block: region blacklist
        # *   bot: bot management
        # 
        # >  If you do not set this parameter, all types of protection policies are queried.
        self.defense_scenes = defense_scenes  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafScenesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defense_scenes is not None:
            result['DefenseScenes'] = self.defense_scenes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenseScenes') is not None:
            self.defense_scenes = m.get('DefenseScenes')
        return self


class DescribeDcdnWafScenesResponseBodyDefenseScenes(TeaModel):
    def __init__(self, defense_scene=None, policy_count=None, rule_count=None):
        # The type of the protection policy, which is the same as the DefenseScenes parameter in request parameters.
        self.defense_scene = defense_scene  # type: str
        # The total number of policies of this type that were configured.
        self.policy_count = policy_count  # type: int
        # The total number of protection rules that were configured in this type of the policy.
        self.rule_count = rule_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDcdnWafScenesResponseBodyDefenseScenes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defense_scene is not None:
            result['DefenseScene'] = self.defense_scene
        if self.policy_count is not None:
            result['PolicyCount'] = self.policy_count
        if self.rule_count is not None:
            result['RuleCount'] = self.rule_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefenseScene') is not None:
            self.defense_scene = m.get('DefenseScene')
        if m.get('PolicyCount') is not None:
            self.policy_count = m.get('PolicyCount')
        if m.get('RuleCount') is not None:
            self.rule_count = m.get('RuleCount')
        return self


class DescribeDcdnWafScenesResponseBody(TeaModel):
    def __init__(self, defense_scenes=None, request_id=None):
        # The types of the protection policies.
        self.defense_scenes = defense_scenes  # type: list[DescribeDcdnWafScenesResponseBodyDefenseScenes]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.defense_scenes:
            for k in self.defense_scenes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafScenesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DefenseScenes'] = []
        if self.defense_scenes is not None:
            for k in self.defense_scenes:
                result['DefenseScenes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.defense_scenes = []
        if m.get('DefenseScenes') is not None:
            for k in m.get('DefenseScenes'):
                temp_model = DescribeDcdnWafScenesResponseBodyDefenseScenes()
                self.defense_scenes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDcdnWafScenesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDcdnWafScenesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDcdnWafScenesResponse, self).to_map()
        if _map is not None:
           