# -*- coding: utf-8 -*-
import cv2
import numpy as np
import numpy.typing as npt

from typing import Tuple, Union, overload, Type, List, Optional

from .constant import Place
from .coordinate import Rect, Size


Dtype = npt.DTypeLike
Stream = Optional[cv2.cuda.Stream]
Shape = Union[Tuple[int, int, int], List[int, int, int]]
ImageType = Union[np.ndarray, cv2.cuda.GpuMat, cv2.UMat, Image]
Size = Union[Tuple[int, int], List[int, int], Size]


class BaseImage(object):
    _data: Union[np.ndarray, cv2.cuda.GpuMat, cv2.UMat]
    _read_mode: int
    _dtype: Dtype
    _place: int
    _stream: Stream
    _bufferPool: Optional[cv2.cuda.BufferPool]
    def __init__(self, data: Union[str, bytes, ImageType], read_mode: int = cv2.IMREAD_COLOR,  dtype: Dtype = np.uint8,
                 place: int = Place.Ndarray, clone: bool = True,
                 stream: Stream = None, bufferPool: cv2.cuda.BufferPool = None): ...

    def write(self, data: Union[str, bytes, ImageType], read_mode: int = None, dtype: Dtype = None, place=None, clone=True) -> None: ...

    def _create_gpu_mat(self, data: Union[ImageType, Size, Tuple[int, int]], dtype: int) -> cv2.cuda.GpuMat: ...

    def dtype_convert(self, dtype: Dtype) -> None: ...

    def place_convert(self, place: int) -> None: ...

    @property
    def shape(self) -> Shape: ...

    @staticmethod
    def get_shape(data) -> Shape: ...

    @property
    def size(self) -> Tuple[int, int]: ...

    @property
    def channels(self) -> int: ...

    @property
    def dtype(self) -> Dtype: ...

    @property
    def cv_dtype(self) -> int: ...

    @property
    def cv_dtype_no_channels(self) -> int: ...

    @staticmethod
    def get_cv_dtype(data: ImageType) -> int: ...

    @staticmethod
    def get_np_dtype(data: ImageType) -> Dtype: ...

    @property
    def place(self) -> int: ...

    @property
    def data(self) -> ImageType: ...

    @property
    def stream(self) -> Stream: ...


class Image(BaseImage):
    def clone(self) -> Image: ...

    def _clone_with_params(self, data, **kwargs) -> Image: ...

    @overload
    def resize(self, w: int, h: int, code: int = cv2.INTER_LINEAR, stream: Stream = None) -> Image: ...

    @overload
    def resize(self, size: Size, code: int = cv2.INTER_LINEAR, stream: Stream = None) -> Image: ...

    def rotate(self, code: int, stream: Stream = None) -> Image: ...

    def _resize(self, w: int, h: int, code: int = cv2.INTER_LINEAR, stream: Stream = None) -> Image: ...

    def cvtColor(self, code: int, stream: Stream = None) -> Image: ...

    def crop(self, rect: Rect) -> Image: ...

    def threshold(self, thresh: int = 0, maxval: int = 255, code=cv2.THRESH_OTSU, stream: Stream = None) -> Image: ...

    def rectangle(self, rect: Rect, color: Tuple[int, int, int] = (0, 255, 0), thickness: int = 1, lineType=cv2.LINE_8) -> None: ...

    def copyMakeBorder(self, top: int, bottom: int, left: int, right: int, borderType: int, stream: Stream = None) -> Image: ...

    def gaussianBlur(self, size: Tuple[int, int] = (11, 11), sigma: Union[int, float] = 1.5, borderType: int = cv2.BORDER_DEFAULT, stream: Stream = None) -> Image: ...

    def warpPerspective(self, matrix: np.ndarray, size: Size, flags: int = cv2.INTER_LINEAR, borderMode: int = cv2.BORDER_CONSTANT, borderValue: int = 0, stream: Stream = None) -> Image: ...

    def bitwise_not(self, mask=None, stream: Stream = None) -> Image: ...

    def imshow(self, title: str = None, flags: int = cv2.WINDOW_KEEPRATIO) -> None: ...

    def imwrite(self, fileName: str) -> None: ...

    def split(self, stream: Stream = None) -> Tuple[Union[np.ndarray, cv2.cuda.GpuMat, cv2.UMat], ...]: ...

    def calcHist(self, histSize: List[int, ...], ranges: Union[Tuple[int, ...], List[int, ...]], mask=None, accumulate: bool = False, stream: Stream = None) -> List[npt.NDArray[np.float32], ...]: ...