# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['novelsave_sources',
 'novelsave_sources.models',
 'novelsave_sources.sources',
 'novelsave_sources.sources.metadata',
 'novelsave_sources.sources.novel',
 'novelsave_sources.utils']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4.10.0,<5.0.0',
 'cloudscraper>=1.2.58,<2.0.0',
 'deprecation>=2.1.0,<3.0.0',
 'lxml>=4.6.3,<5.0.0',
 'requests>=2.26.0,<3.0.0']

setup_kwargs = {
    'name': 'novelsave-sources',
    'version': '0.3.0',
    'description': 'A collection of novel sources offering varying amounts of scraping capability.',
    'long_description': '# 📚 Novelsave Sources\n\nA collection of novel sources offering varying amounts of scraping capability.\n\n> Request a new source by [creating a new issue](https://github.com/mHaisham/novelsave_sources/issues/new/choose)\n\n## 🤖 Usage\n\n### API\n\nThis package exposes 4 basic functions that can be used to interact with the provided\nsources, both of novel and metadata variety.\n\n- [`novel_source_types`](#novel_source_types) - Locate and return all the novel source types\n- [`locate_novel_source`](#locate_novel_source) - Locate and return the novel source parser for the url if it is supported\n- [`metadata_source_types`](#metadata_source_types) - Locate and return all the metadata source types\n- [`locate_metadata_source`](#locate_metadata_source) - Locate and return the metadata source parser for the url if it is supported\n\n#### novel_source_types\n\nFinds all the novel source implementations defined by this package and returns their types.\n\n`rtype` - `List[Type[Source]]`\n\n#### locate_novel_source\n\nTakes a url and tries to find a defined novel source that can parse the webpage.\nIf found returns the source type otherwise raises a `UnknownSourceException`.\n\n`rtype` - `Type[Source]`\n\n#### metadata_source_types\n\nFinds all the metadata source implementations defined by this package and returns their types.\n\n`rtype` - `List[Type[MetaSource]]`\n\n#### locate_metadata_source\n\nTakes a url and tries to find a defined metadata source that can parse the webpage.\nIf found returns the source type otherwise raises a `UnknownSourceException`.\n\n`rtype` - `Type[MetaSource]`\n\n### Behaviour\n\n#### HttpGateway\n\n`Crawler` type which `Source` extends from takes a `BaseHttpGateway` as a dependency.\n\nThe default implementation has the following properties:\n\n- Uses `cloudscraper` package, which detects Cloudflare\'s anti-bot pages.\n- Disables SSL protection, as this seems to break most sites.\n\nYou may override this behaviour by implementing `BaseHttpGateway` interface,\nand providing it as a dependency when sources are instantiated.\n\n### Build\n\nTo update the sources segment in the README.md, run the following command:\n\n```bash\npython3 manage.py compile\n```\n\n## 📒 Sources\n\n### Novel\n\n#### ✅ Supported\n\n<table>\n    <thead>\n        <tr>\n            <th align="center">Lang</th>\n            <th>Source</th>\n            <th align="center">Search</th>\n            <th align="center">Last Checked</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td align="center">en</td>\n            <td>https://1stkissnovel.love</td>\n            <td align="center"></td>\n            <td align="center">2021-10-14</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://betwixtedbutterfly.com</td>\n            <td align="center"></td>\n            <td align="center">2021-10-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://boxnovel.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://chrysanthemumgarden.com/</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://creativenovels.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-17</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://dragontea.ink/</td>\n            <td align="center"></td>\n            <td align="center">2021-10-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://dummynovels.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://forums.spacebattles.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-09</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://forums.sufficientvelocity.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-09</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelfull.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelfun.net</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelgate.net</td>\n            <td align="center"></td>\n            <td align="center">2021-09-03</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelonlinefull.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelsite.net</td>\n            <td align="center"></td>\n            <td align="center">2021-09-06</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://novelsrock.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://peachpitting.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://rainofsnow.com/</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://readlightnovels.net</td>\n            <td align="center"></td>\n            <td align="center">2021-09-06</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://readnovelfull.com/</td>\n            <td align="center"></td>\n            <td align="center">2021-10-17</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://wuxiaworld.online</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://wuxiaworld.site</td>\n            <td align="center"></td>\n            <td align="center">2021-09-03</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.chickengege.org</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.foxaholic.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-03</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.lightnovelworld.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.mtlnovel.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.novelhall.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.novelpassion.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.readlightnovel.me</td>\n            <td align="center"></td>\n            <td align="center">2021-09-07</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.royalroad.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-06</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.scribblehub.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-06</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.wattpad.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-06</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.webnovel.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-03</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.wuxiaworld.co</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.wuxiaworld.com</td>\n            <td align="center"></td>\n            <td align="center">2021-09-04</td>\n        </tr>\n    </tbody>\n</table>\n\n#### ❌ Rejected\n\n<table>\n    <thead>\n        <tr>\n            <th align="center">Lang</th>\n            <th>Source</th>\n            <th>Reason</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.fanfiction.net</td>\n            <td>Has cloudflare bot protection</td>\n        </tr>\n    </tbody>\n</table>\n\n### Metadata\n\n#### ✅ Supported\n\n<table>\n    <thead>\n        <tr>\n            <th align="center">Lang</th>\n            <th>Metadata Source</th>\n            <th align="center">Last Checked</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.novelupdates.com</td>\n            <td align="center">2021-09-03</td>\n        </tr>\n        <tr>\n            <td align="center">en</td>\n            <td>https://www.wlnupdates.com/</td>\n            <td align="center">2021-08-25</td>\n        </tr>\n    </tbody>\n</table>\n\n## 📝 Disclaimer\n\nWe are not affiliated, associated, authorized, endorsed by, or in any way officially\nconnected with any of the [sources](#sources) mentioned above.\n\n## 📜 License\n\n[Apache-2.0](https://github.com/mHaisham/novelsave_sources/blob/master/LICENSE)\n',
    'author': 'Mensch272',
    'author_email': '47662901+mensch272@users.noreply.github.com',
    'maintainer': 'Mensch272',
    'maintainer_email': '47662901+mensch272@users.noreply.github.com',
    'url': 'https://github.com/mensch272/novelsave_sources',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
