"""Shared types and small helpers for XPLT reading."""

from __future__ import annotations

from collections.abc import Iterable
from dataclasses import dataclass

import numpy as np

Index = int | slice | Iterable[int] | np.ndarray | None
ItemBlock = np.ndarray


@dataclass
class MultBlock:
    """Packed data for FMT_MULT (data + counts per item)."""

    data: np.ndarray
    nper: np.ndarray


MultLike = MultBlock | np.ndarray

# Buffer and registry aliases
ItemBuffer = dict[str, list[ItemBlock | None]]
RegionBuffer = dict[str, list[np.ndarray | None]]
MultBuffer = dict[str, list[MultLike | None]]
PerRegionBuffer = dict[str, dict[str, list[np.ndarray | None]]]
PerRegionMultBuffer = dict[str, dict[str, list[MultLike | None]]]

NodeRegionSeen = dict[str, dict[str, np.ndarray]]
ItemSeen = dict[str, dict[str, np.ndarray]]
MultSeen = dict[str, dict[str, MultBlock]]
RegionSeen = dict[str, dict[str, np.ndarray]]


__all__ = [
    "Index",
    "ItemBlock",
    "ItemBuffer",
    "ItemSeen",
    "MultBlock",
    "MultBuffer",
    "MultLike",
    "MultSeen",
    "NodeRegionSeen",
    "PerRegionBuffer",
    "PerRegionMultBuffer",
    "RegionBuffer",
    "RegionSeen",
]
