"""Experimental data helpers."""

from __future__ import annotations

from collections.abc import Callable
from dataclasses import dataclass

import numpy as np

WeightFunction = Callable[[np.ndarray], np.ndarray]


@dataclass
class ExperimentSeries:
    """Simple container for experimental x/y data and optional weights."""

    x: np.ndarray
    y: np.ndarray
    weight: WeightFunction | None = None

    def weighted(self) -> tuple[np.ndarray, np.ndarray, np.ndarray | None]:
        """Return experimental data together with optional weights."""
        if self.weight is None:
            return self.x, self.y, None
        weights = self.weight(self.x)
        return self.x, self.y, np.asarray(weights, dtype=float)


__all__ = ["ExperimentSeries", "WeightFunction"]
