"""Simulation adapters for reading FEBio output artefacts."""

from __future__ import annotations

from collections.abc import Callable
from dataclasses import dataclass
from pathlib import Path

import numpy as np


@dataclass
class SimulationAdapter:
    """Callable-based adapter that extracts data from FEBio artefacts."""

    reader: Callable[[Path], tuple[np.ndarray, np.ndarray]]

    def read(self, xplt_path: Path) -> tuple[np.ndarray, np.ndarray]:
        """Return the simulated series for a given `.xplt` file.

        Args:
            xplt_path: Path to the simulation output file.

        Returns:
            Tuple with the simulated abscissa and ordinate arrays.
        """
        return self.reader(Path(xplt_path))


__all__ = ["SimulationAdapter"]
