# pyfebiopt

pyFEBiOpt wraps the FEBio solver with a more flexible toolbox. FEBio ships with
optimisation hooks, but they are intentionally narrow; this library delivers
extremely flexible inverse optimisation, multi-objective workflows, and
extensible, parallel computation that slot cleanly into existing FEBio projects.

## Highlights

- Inverse optimisation engine with reparameterisation, clean logging, monitoring,
  Jacobian helpers, FEB template bindings, and configurable runners/storage. Build
  parameter grids, run multiple cases, and keep artefacts organised with automatic
  cleanup/persistence policies.
- Post-processing via a fast binary `.xplt` reader with sliceable views for nodes,
  elements, faces, and regions (no copies until needed).
- Visualisation utilities built on `pyvista` for quick mesh/result plotting.
- Extensible design: adapters for experiment data, telemetry hooks, series export,
  and structured configuration dataclasses to keep projects reproducible. Plug in
  your own experiment loaders or monitoring sinks without changing the engine.
