# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2015, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

TABLES = {'HL70001': ('Administrative Sex',
                      (('A', 'Ambiguous'),
                       ('F', 'Female'),
                       ('M', 'Male'),
                       ('N', 'Not applicable'),
                       ('O', 'Other'),
                       ('U', 'Unknown'))),
          'HL70002': ('Marital Status',
                      (('A', 'Separated'),
                       ('B', 'Unmarried'),
                       ('C', 'Common law'),
                       ('D', 'Divorced'),
                       ('E', 'Legally Separated'),
                       ('G', 'Living together'),
                       ('I', 'Interlocutory'),
                       ('M', 'Married'),
                       ('N', 'Annulled'),
                       ('O', 'Other'),
                       ('P', 'Domestic partner'),
                       ('R', 'Registered domestic partner'),
                       ('S', 'Single'),
                       ('T', 'Unreported'),
                       ('U', 'Unknown'),
                       ('W', 'Widowed'))),
          'HL70003': ('Event type',
                      (('A01', 'ADT/ACK - Admit/visit notification'),
                       ('A02', 'ADT/ACK - Transfer a patient'),
                       ('A03', 'ADT/ACK -  Discharge/end visit'),
                       ('A04', 'ADT/ACK -  Register a patient'),
                       ('A05', 'ADT/ACK -  Pre-admit a patient'),
                       ('A06', 'ADT/ACK -  Change an outpatient to an inpatient'),
                       ('A07', 'ADT/ACK -  Change an inpatient to an outpatient'),
                       ('A08', 'ADT/ACK -  Update patient information'),
                       ('A09', 'ADT/ACK -  Patient departing - tracking'),
                       ('A10', 'ADT/ACK -  Patient arriving - tracking'),
                       ('A11', 'ADT/ACK -  Cancel admit/visit notification'),
                       ('A12', 'ADT/ACK -  Cancel transfer'),
                       ('A13', 'ADT/ACK -  Cancel discharge/end visit'),
                       ('A14', 'ADT/ACK -  Pending admit'),
                       ('A15', 'ADT/ACK -  Pending transfer'),
                       ('A16', 'ADT/ACK -  Pending discharge'),
                       ('A17', 'ADT/ACK -  Swap patients'),
                       ('A18',
                        'ADT/ACK -  Merge patient information (for backward compatibility only)'),
                       ('A19', 'QRY/ADR -  Patient query'),
                       ('A20', 'ADT/ACK -  Bed status update'),
                       ('A21', 'ADT/ACK -  Patient goes on a _leave of absence_'),
                       ('A22',
                        'ADT/ACK -  Patient returns from a _leave of absence_'),
                       ('A23', 'ADT/ACK -  Delete a patient record'),
                       ('A24', 'ADT/ACK -  Link patient information'),
                       ('A25', 'ADT/ACK -  Cancel pending discharge'),
                       ('A26', 'ADT/ACK -  Cancel pending transfer'),
                       ('A27', 'ADT/ACK -  Cancel pending admit'),
                       ('A28', 'ADT/ACK -  Add person information'),
                       ('A29', 'ADT/ACK -  Delete person information'),
                       ('A30',
                        'ADT/ACK -  Merge person information (for backward compatibility only)'),
                       ('A31', 'ADT/ACK -  Update person information'),
                       ('A32', 'ADT/ACK -  Cancel patient arriving - tracking'),
                       ('A33', 'ADT/ACK -  Cancel patient departing - tracking'),
                       ('A34',
                        'ADT/ACK -  Merge patient information - patient ID only (for backward compatibility only)'),
                       ('A35',
                        'ADT/ACK -  Merge patient information - account number only (for backward compatibility only)'),
                       ('A36',
                        'ADT/ACK -  Merge patient information - patient ID and account number (for backward '
                        'compatibility only)'),
                       ('A37', 'ADT/ACK -  Unlink patient information'),
                       ('A38', 'ADT/ACK - Cancel pre-admit'),
                       ('A39',
                        'ADT/ACK - Merge person _ patient ID (for backward compatibility only)'),
                       ('A40', 'ADT/ACK - Merge patient _ patient identifier list'),
                       ('A41', 'ADT/ACK - Merge account - patient account number'),
                       ('A42', 'ADT/ACK - Merge visit - visit number'),
                       ('A43',
                        'ADT/ACK - Move patient information _ patient identifier list'),
                       ('A44',
                        'ADT/ACK - Move account information - patient account number'),
                       ('A45', 'ADT/ACK - Move visit information - visit number'),
                       ('A46',
                        'ADT/ACK - Change patient ID (for backward compatibility only)'),
                       ('A47', 'ADT/ACK - Change patient identifier list'),
                       ('A48',
                        'ADT/ACK - Change alternate patient ID (for backward compatibility only)'),
                       ('A49', 'ADT/ACK - Change patient account number'),
                       ('A50', 'ADT/ACK - Change visit number'),
                       ('A51', 'ADT/ACK - Change alternate visit ID'),
                       ('A52', 'ADT/ACK _ Cancel leave of absence for a patient'),
                       ('A53',
                        'ADT/ACK _ Cancel patient returns from a leave of absence'),
                       ('A54', 'ADT/ACK - Change attending doctor'),
                       ('A55', 'ADT/ACK _ Cancel change attending doctor'),
                       ('A60', 'ADT/ACK _ Update allergy information'),
                       ('A61', 'ADT/ACK _ Change consulting doctor'),
                       ('A62', 'ADT/ACK _ Cancel change consulting doctor'),
                       ('B01', 'PMU/ACK _ Add personnel record'),
                       ('B02', 'PMU/ACK _ Update personnel record'),
                       ('B03', 'PMU/ACK _ Delete personnel re cord'),
                       ('B04', 'PMU/ACK _ Active practicing person'),
                       ('B05', 'PMU/ACK _ Deactivate practicing person'),
                       ('B06', 'PMU/ACK _ Terminate practicing person'),
                       ('B07', 'PMU/ACK _ Grant Certificate/Permission'),
                       ('B08', 'PMU/ACK _ Revoke Certificate/Permission'),
                       ('C01', 'CRM - Register a patient on a clinical trial'),
                       ('C02',
                        'CRM - Cancel a patient registration on clinical trial (for clerical mistakes only)'),
                       ('C03', 'CRM - Correct/update registration information'),
                       ('C04', 'CRM - Patient has gone off a clinical trial'),
                       ('C05', 'CRM - Patient enters phase of clinical trial'),
                       ('C06',
                        'CRM - Cancel patient entering a phase (clerical mistake)'),
                       ('C07', 'CRM - Correct/update phase information'),
                       ('C08', 'CRM - Patient has gone off phase of clinical trial'),
                       ('C09',
                        'CSU - Automated time intervals for reporting, like monthly'),
                       ('C10', 'CSU - Patient completes the clinical trial'),
                       ('C11',
                        'CSU - Patient completes a phase of the clinical trial'),
                       ('C12',
                        'CSU - Update/correction of patient order/result information'),
                       ('CNQ', 'Cancel Query'),
                       ('I01', 'RQI/RPI - Request for insurance information'),
                       ('I02',
                        'RQI/RPL - Request/receipt of patient selection display list'),
                       ('I03', 'RQI/RPR - Request/receipt of patient selection list'),
                       ('I04', 'RQD/RPI - Request for patient demographic data'),
                       ('I05', 'RQC/RCI - Request for patient clinical information'),
                       ('I06', 'RQC/RCL - Request/receipt of clinical data listing'),
                       ('I07', 'PIN/ACK - Unsolicited insurance information'),
                       ('I08',
                        'RQA/RPA - Request for treatment authorization information'),
                       ('I09',
                        'RQA/RPA - Request for modification to an authorization'),
                       ('I10',
                        'RQA/RPA - Request for resubmission of an authorization'),
                       ('I11',
                        'RQA/RPA - Request for cancellation of an authorization'),
                       ('I12', 'REF/RRI -  Patient referral'),
                       ('I13', 'REF/RRI - Modify patient referral'),
                       ('I14', 'REF/RRI - Cancel patient referral'),
                       ('I15', 'REF/RRI - Request patient referral status'),
                       ('J01', 'QCN/ACK _ Cancel query/acknowledge message'),
                       ('J02', 'QSX/ACK _ Cancel subscription/acknowledge message'),
                       ('K11',
                        'RSP - Segment pattern response in response to QBP^Q11'),
                       ('K13', 'RTB - Tabular response in response to QBP^Q13'),
                       ('K15', 'RDY - Display response in response to QBP^Q15'),
                       ('K21', 'RSP _ Get person demographics response'),
                       ('K22', 'RSP _ Find candidates response'),
                       ('K23', 'RSP _ Get corresponding identifiers response'),
                       ('K24', 'RSP _ Allocate identifiers response'),
                       ('K25', 'RSP - Personnel Information by Segment Response'),
                       ('M01',
                        'MFN/MFK - Master file not otherwise specified (for backward compatibility only)'),
                       ('M02', 'MFN/MFK - Master file _ staff practitioner'),
                       ('M03',
                        'MFN/MFK - Master file - test/observation (for backward compatibility only)'),
                       ('M04', 'MFN/MFK - Master files charge description'),
                       ('M05', 'MFN/MFK - Patient location master file'),
                       ('M06',
                        'MFN/MFK - Clinical study with phases and schedules master file'),
                       ('M07',
                        'MFN/MFK - Clinical study without phases but with schedules master file'),
                       ('M08', 'MFN/MFK - Test/observation (numeric) master file'),
                       ('M09',
                        'MFN/MFK - Test/observation (categorical) master file'),
                       ('M10', 'MFN/MFK - Test /observation batteries master file'),
                       ('M11', 'MFN/MFK - Test/calculated observations master file'),
                       ('M12', 'MFN/MFK _ Master file notification message'),
                       ('M13', 'MFN/MFK - Master file notification - general'),
                       ('M14', 'MFN/MFK - Master file notification _ site defined'),
                       ('M15', 'MFN/MFK _ Inventory item master file notification'),
                       ('N01', 'NMQ/NMR - Application management query message'),
                       ('N02',
                        'NMD/ACK - Application management data message (unsolicited)'),
                       ('O01', 'ORM - Order message (also RDE, RDS, RGV, RAS)'),
                       ('O02', 'ORR - Order response (also RRE, RRD, RRG, RRA)'),
                       ('O03', 'OMD _ Diet order'),
                       ('O04', 'ORD _ Diet order acknowledgment'),
                       ('O05', 'OMS _ Stock requisition order'),
                       ('O06', 'ORS _ Stock requisition acknowledgment'),
                       ('O07', 'OMN _ Non-stock requisition order'),
                       ('O08', 'ORN _ Non-stock requisition acknowledgment'),
                       ('O09', 'OMP _ Pharmacy/treatment order'),
                       ('O10', 'ORP _ Pharmacy/treatment order acknowledgment'),
                       ('O11', 'RDE _ Pharmacy/treatment encoded order'),
                       ('O12',
                        'RRE _ Pharmacy/treatment encoded order acknowledgment'),
                       ('O13', 'RDS _ Pharmacy/treatment dispense'),
                       ('O14', 'RRD _ Pharmacy/treatment dispense acknowledgment'),
                       ('O15', 'RGV _ Pharmacy/treatment give'),
                       ('O16', 'RRG _ Pharmacy/treatment give acknowledgment'),
                       ('O17', 'RAS _ Pharmacy/treatment administration'),
                       ('O18',
                        'RRA _ Pharmacy/treatment administration acknowledgment'),
                       ('O19', 'OMG _ General clinical order'),
                       ('O20', 'ORG/ORL _ General clinical order response'),
                       ('O21', 'OML - Laboratory order'),
                       ('O22',
                        'ORL - General laboratory order response message to any OML'),
                       ('O23', 'OMI _ Imaging order'),
                       ('O24', 'ORI _ Imaging order response message to any OMI'),
                       ('O25',
                        'RDE - Pharmacy/treatment refill authorization request'),
                       ('O26',
                        'RRE - Pharmacy/Treatment Refill Authorization Acknowledgement'),
                       ('O27', 'OMB _ Blood product order'),
                       ('O28', 'ORB _ Blood product order acknowledgment'),
                       ('O29', 'BPS _ Blood product dispense status'),
                       ('O30', 'BRP _ Blood product dispense status acknowledgment'),
                       ('O31', 'BTS _ Blood product transfusion/disposition'),
                       ('O32',
                        'BRT _ Blood product transfusion/disposition acknowledgment'),
                       ('O33',
                        'OML _ Laboratory order for multiple orders related to a single specimen'),
                       ('O34',
                        'ORL _ Laboratory order response message to a multiple order related to single specimen OML'),
                       ('O35',
                        'OML _ Laboratory order for multiple orders related to a single container of a specimen'),
                       ('O36',
                        'ORL - Laboratory order response message to a single container of a specimen OML'),
                       ('P01', 'BAR/ACK - Add patient accounts'),
                       ('P02', 'BAR/ACK - Purge patient accounts'),
                       ('P03', 'DFT/ACK - Post detail financial transaction'),
                       ('P04', 'QRY/DSP - Generate bill and A/R statements'),
                       ('P05', 'BAR/ACK - Update account'),
                       ('P06', 'BAR/ACK - End account'),
                       ('P07',
                        'PEX - Unsolicited initial individual product experience report'),
                       ('P08',
                        'PEX - Unsolicited update individual product experience report'),
                       ('P09', 'SUR - Summary product experience report'),
                       ('P10',
                        'BAR/ACK _Transmit Ambulatory Payment  Classification(APC)'),
                       ('P11', 'DFT/ACK - Post Detail Financial Transactions - New'),
                       ('P12', 'BAR/ACK - Update Diagnosis/Procedure'),
                       ('PC1', 'PPR - PC/ problem add'),
                       ('PC2', 'PPR - PC/ problem update'),
                       ('PC3', 'PPR - PC/ problem delete'),
                       ('PC4', 'QRY - PC/ problem query'),
                       ('PC5', 'PRR - PC/ problem response'),
                       ('PC6', 'PGL - PC/ goal add'),
                       ('PC7', 'PGL - PC/ goal update'),
                       ('PC8', 'PGL - PC/ goal delete'),
                       ('PC9', 'QRY - PC/ goal query'),
                       ('PCA', 'PPV - PC/ goal response'),
                       ('PCB', 'PPP - PC/ pathway (problem-oriented) add'),
                       ('PCC', 'PPP - PC/ pathway (problem-oriented) update'),
                       ('PCD', 'PPP - PC/ pathway (problem-oriented) delete'),
                       ('PCE', 'QRY - PC/ pathway (problem-oriented) query'),
                       ('PCF', 'PTR - PC/ pathway (problem-oriented) query response'),
                       ('PCG', 'PPG - PC/ pathway (goal-oriented) add'),
                       ('PCH', 'PPG - PC/ pathway (goal-oriented) update'),
                       ('PCJ', 'PPG - PC/ pathway (goal-oriented) delete'),
                       ('PCK', 'QRY - PC/ pathway (goal-oriented) query'),
                       ('PCL', 'PPT - PC/ pathway (goal-oriented) query response'),
                       ('Q01', 'QRY/DSR - Query sent for immediate response'),
                       ('Q02', 'QRY/QCK - Query sent for deferred response'),
                       ('Q03', 'DSR/ACK - Deferred response to a query'),
                       ('Q04', 'EQQ _ Embedded query language query'),
                       ('Q05', 'UDM/ACK - Unsolicited display update message'),
                       ('Q06', 'OSQ/OSR - Query for order status'),
                       ('Q07', 'VQQ _ Virtual table query'),
                       ('Q08', 'SPQ _ Stored procedure request'),
                       ('Q09', 'RQQ _ event replay query'),
                       ('Q11',
                        'QBP - Query by parameter requesting an RSP segment pattern response'),
                       ('Q13',
                        'QBP - Query by parameter requesting an  RTB - tabular response'),
                       ('Q15',
                        'QBP - Query by parameter requesting an RDY display response'),
                       ('Q16', 'QSB _ Create subscription'),
                       ('Q17', 'QVR _ Query for previous events'),
                       ('Q21', 'QBP _ Get person demographics'),
                       ('Q22', 'QBP _ Find candidates'),
                       ('Q23', 'QBP _ Get corresponding identifiers'),
                       ('Q24', 'QBP _ Allocate identifiers'),
                       ('Q25', 'QBP - Personnel Information by Segment Query'),
                       ('Q26', 'ROR - Pharmacy/treatment order response'),
                       ('Q27', 'RAR - Pharmacy/treatment administration information'),
                       ('Q28', 'RDR - Pharmacy/treatment dispense information'),
                       ('Q29', 'RER - Pharmacy/treatment encoded order information'),
                       ('Q30', 'RGR - Pharmacy/treatment dose information'),
                       ('R01',
                        'ORU/ACK - Unsolicited transmission of an observation message'),
                       ('R02', 'QRY - Query for results of observation'),
                       ('R03',
                        'QRY/DSR Display-oriented results, query/unsol. update (for backward compatibility only) '
                        '(Replaced by Q05)'),
                       ('R04',
                        'ORF - Response to query; transmission of requested observation'),
                       ('R07', 'EDR - Enhanced Display Response'),
                       ('R08', 'TBR - Tabular Data Response'),
                       ('R09', 'ERP - Event Replay Response'),
                       ('R21', 'OUL _ Unsolicited laboratory observation'),
                       ('R22',
                        'OUL _ Unsolicited Specimen Oriented Observation Message'),
                       ('R23',
                        'OUL _ Unsolicited Specimen Container Oriented Observation Message'),
                       ('R24',
                        'OUL _ Unsolicited Order Oriented Observation Message'),
                       ('R30',
                        'ORU _ Unsolicited Point-Of-Care Observation Message Without Existing Order _ Place An Order'),
                       ('R31',
                        'ORU _ Unsolicited New Point-Of-Care Observation Message _ Search For An Order'),
                       ('R32',
                        'ORU _ Unsolicited Pre-Ordered Point-Of-Care Observation'),
                       ('ROR', 'ROR - Pharmacy prescription order query response'),
                       ('S01', 'SRM/SRR - Request new appointment booking'),
                       ('S02', 'SRM/SRR - Request appointment rescheduling'),
                       ('S03', 'SRM/SRR - Request appointment modification'),
                       ('S04', 'SRM/SRR - Request appointment cancellation'),
                       ('S05', 'SRM/SRR - Request appointment discontinuation'),
                       ('S06', 'SRM/SRR - Request appointment deletion'),
                       ('S07',
                        'SRM/SRR - Request addition of service/resource on appointment'),
                       ('S08',
                        'SRM/SRR - Request modification of service/resource on appointment'),
                       ('S09',
                        'SRM/SRR - Request cancellation of service/resource on appointment'),
                       ('S10',
                        'SRM/SRR - Request discontinuation of service/resource on appointment'),
                       ('S11',
                        'SRM/SRR - Request deletion of service/resource on appointment'),
                       ('S12', 'SIU/ACK - Notification of new appointment booking'),
                       ('S13', 'SIU/ACK - Notification of appointment rescheduling'),
                       ('S14', 'SIU/ACK - Notification of appointment modification'),
                       ('S15', 'SIU/ACK - Notification of appointment cancellation'),
                       ('S16',
                        'SIU/ACK - Notification of appointment discontinuation'),
                       ('S17', 'SIU/ACK - Notification of appointment deletion'),
                       ('S18',
                        'SIU/ACK - Notification of addition of service/resource on appointment'),
                       ('S19',
                        'SIU/ACK - Notification of modification of service/resource on appointment'),
                       ('S20',
                        'SIU/ACK - Notification of cancellation of service/resource on appointment'),
                       ('S21',
                        'SIU/ACK - Notification of discontinuation of service/resource on appointment'),
                       ('S22',
                        'SIU/ACK - Notification of deletion of service/resource on appointment'),
                       ('S23',
                        'SIU/ACK - Notification of blocked schedule time slot(s)'),
                       ('S24',
                        'SIU/ACK - Notification of opened (_unblocked_) schedule time slot(s)'),
                       ('S25', 'SQM/SQR - Schedule query message and response'),
                       ('S26',
                        'SIU/ACK Notification that patient did not show up for schedule appointment'),
                       ('T01', 'MDM/ACK - Original document notification'),
                       ('T02',
                        'MDM/ACK - Original document notification and content'),
                       ('T03', 'MDM/ACK - Document status change notification'),
                       ('T04',
                        'MDM/ACK - Document status change notification and content'),
                       ('T05', 'MDM/ACK - Document addendum notification'),
                       ('T06',
                        'MDM/ACK - Document addendum notification and content'),
                       ('T07', 'MDM/ACK - Document edit notification'),
                       ('T08', 'MDM/ACK - Document edit notification and content'),
                       ('T09', 'MDM/ACK - Document replacement notification'),
                       ('T10',
                        'MDM/ACK - Document replacement notification and content'),
                       ('T11', 'MDM/ACK - Document cancel notification'),
                       ('T12', 'QRY/DOC - Document query'),
                       ('U01', 'ESU/ACK _ Automated equipment status update'),
                       ('U02', 'ESR/ACK _ Automated equipment status request'),
                       ('U03', 'SSU/ACK - Specimen status update'),
                       ('U04', 'SSR/ACK - specimen status request'),
                       ('U05', 'INU/ACK  - Automated equipment inventory update'),
                       ('U06', 'INR/ACK _ Automated equipment inventory request'),
                       ('U07', 'EAC/ACK _ Automated equipment command'),
                       ('U08', 'EAR/ACK _ Automated equipment response'),
                       ('U09', 'EAN/ACK _ Automated equipment notification'),
                       ('U10',
                        'TCU/ACK _ Automated equipment test code settings update'),
                       ('U11',
                        'TCR/ACK _ Automated equipment test code settings request'),
                       ('U12', 'LSU/ACK _ Automated equipment log/service update'),
                       ('U13', 'LSR/ACK _ Automated equipment log/service request'),
                       ('V01', 'VXQ - Query for vaccination record'),
                       ('V02',
                        'VXX - Response to vaccination query returning multiple PID matches'),
                       ('V03', 'VXR - Vaccination record response'),
                       ('V04', 'VXU - Unsolicited vaccination record update'),
                       ('Varies',
                        'MFQ/MFR - Master files query (use event same as asking for e.g., M05 - location)'),
                       ('W01',
                        'ORU - Waveform result, unsolicited transmission of requested information'),
                       ('W02', 'QRF - Waveform result, response to query'))),
          'HL70004': ('Patient Class',
                      (('B', 'Obstetrics'),
                       ('C', 'Commercial Account'),
                       ('E', 'Emergency'),
                       ('I', 'Inpatient'),
                       ('N', 'Not Applicable'),
                       ('O', 'Outpatient'),
                       ('P', 'Preadmit'),
                       ('R', 'Recurring patient'),
                       ('U', 'Unknown'))),
          'HL70005': ('Race',
                      (('...', 'see chapter 3'),
                       ('1002-5', 'American Indian or Alaska Native'),
                       ('2028-9', 'Asian'),
                       ('2054-5', 'Black or African American'),
                       ('2076-8', 'Native Hawaiian or Other Pacific Islander'),
                       ('2106-3', 'White'),
                       ('2131-1', 'Other Race'))),
          'HL70006': ('Religion',
                      (('ABC', 'Christian: American Baptist Church'),
                       ('AGN', 'Agnostic'),
                       ('AME', 'Christian: African Methodist Episcopal Zion'),
                       ('AMT', 'Christian: African Methodist Episcopal'),
                       ('ANG', 'Christian: Anglican'),
                       ('AOG', 'Christian: Assembly of God'),
                       ('ATH', 'Atheist'),
                       ('BAH', "Baha'i"),
                       ('BAP', 'Christian: Baptist'),
                       ('BMA', 'Buddhist: Mahayana'),
                       ('BOT', 'Buddhist: Other'),
                       ('BTA', 'Buddhist: Tantrayana'),
                       ('BTH', 'Buddhist: Theravada'),
                       ('BUD', 'Buddhist'),
                       ('CAT', 'Christian: Roman Catholic'),
                       ('CFR', 'Chinese Folk Religionist'),
                       ('CHR', 'Christian'),
                       ('CHS', 'Christian: Christian Science'),
                       ('CMA', 'Christian: Christian Missionary Alliance'),
                       ('CNF', 'Confucian'),
                       ('COC', 'Christian: Church of Christ'),
                       ('COG', 'Christian: Church of God'),
                       ('COI', 'Christian: Church of God in Christ'),
                       ('COL', 'Christian: Congregational'),
                       ('COM', 'Christian: Community'),
                       ('COP', 'Christian: Other Pentecostal'),
                       ('COT', 'Christian: Other'),
                       ('CRR', 'Christian: Christian Reformed'),
                       ('EOT', 'Christian: Eastern Orthodox'),
                       ('EPI', 'Christian: Episcopalian'),
                       ('ERL', 'Ethnic Religionist'),
                       ('EVC', 'Christian: Evangelical Church'),
                       ('FRQ', 'Christian: Friends'),
                       ('FWB', 'Christian: Free Will Baptist'),
                       ('GRE', 'Christian: Greek Orthodox'),
                       ('HIN', 'Hindu'),
                       ('HOT', 'Hindu: Other'),
                       ('HSH', 'Hindu: Shaivites'),
                       ('HVA', 'Hindu: Vaishnavites'),
                       ('JAI', 'Jain'),
                       ('JCO', 'Jewish: Conservative'),
                       ('JEW', 'Jewish'),
                       ('JOR', 'Jewish: Orthodox'),
                       ('JOT', 'Jewish: Other'),
                       ('JRC', 'Jewish: Reconstructionist'),
                       ('JRF', 'Jewish: Reform'),
                       ('JRN', 'Jewish: Renewal'),
                       ('JWN', "Christian: Jehovah's Witness"),
                       ('LMS', 'Christian: Lutheran Missouri Synod'),
                       ('LUT', 'Christian: Lutheran'),
                       ('MEN', 'Christian: Mennonite'),
                       ('MET', 'Christian: Methodist'),
                       ('MOM', 'Christian: Latter-day Saints'),
                       ('MOS', 'Muslim'),
                       ('MOT', 'Muslim: Other'),
                       ('MSH', 'Muslim: Shiite'),
                       ('MSU', 'Muslim: Sunni'),
                       ('NAM', 'Native American'),
                       ('NAZ', 'Christian: Church of the Nazarene'),
                       ('NOE', 'Nonreligious'),
                       ('NRL', 'New Religionist'),
                       ('ORT', 'Christian: Orthodox'),
                       ('OTH', 'Other'),
                       ('PEN', 'Christian: Pentecostal'),
                       ('PRC', 'Christian: Other Protestant'),
                       ('PRE', 'Christian: Presbyterian'),
                       ('PRO', 'Christian: Protestant'),
                       ('QUA', 'Christian: Friends'),
                       ('REC', 'Christian: Reformed Church'),
                       ('REO', 'Christian: Reorganized Church of Jesus Christ-LDS'),
                       ('SAA', 'Christian: Salvation Army'),
                       ('SEV', 'Christian: Seventh Day Adventist'),
                       ('SHN', 'Shintoist'),
                       ('SIK', 'Sikh'),
                       ('SOU', 'Christian: Southern Baptist'),
                       ('SPI', 'Spiritist'),
                       ('UCC', 'Christian: United Church of Christ'),
                       ('UMD', 'Christian: United Methodist'),
                       ('UNI', 'Christian: Unitarian'),
                       ('UNU', 'Christian: Unitarian Universalist'),
                       ('VAR', 'Unknown'),
                       ('WES', 'Christian: Wesleyan'),
                       ('WMC', 'Christian: Wesleyan Methodist'))),
          'HL70007': ('Admission Type',
                      (('A', 'Accident'),
                       ('C', 'Elective'),
                       ('E', 'Emergency'),
                       ('L', 'Labor and Delivery'),
                       ('N', 'Newborn (Birth in healthcare facility)'),
                       ('R', 'Routine'),
                       ('U', 'Urgent'))),
          'HL70008': ('Acknowledgment code',
                      (('AA',
                        'Original mode: Application Accept - Enhanced mode: Application acknowledgment: Accept'),
                       ('AE',
                        'Original mode: Application Error - Enhanced mode: Application acknowledgment: Error'),
                       ('AR',
                        'Original mode: Application Reject - Enhanced mode: Application acknowledgment: Reject'),
                       ('CA', 'Enhanced mode: Accept acknowledgment: Commit Accept'),
                       ('CE', 'Enhanced mode: Accept acknowledgment: Commit Error'),
                       ('CR', 'Enhanced mode: Accept acknowledgment: Commit Reject'))),
          'HL70009': ('Ambulatory Status',
                      (('A0', 'No functional limitations'),
                       ('A1', 'Ambulates with assistive device'),
                       ('A2', 'Wheelchair/stretcher bound'),
                       ('A3', 'Comatose; non-responsive'),
                       ('A4', 'Disoriented'),
                       ('A5', 'Vision impaired'),
                       ('A6', 'Hearing impaired'),
                       ('A7', 'Speech impaired'),
                       ('A8', 'Non-English speaking'),
                       ('A9', 'Functional level unknown'),
                       ('B1', 'Oxygen therapy'),
                       ('B2', 'Special equipment (tubes, IVs, catheters)'),
                       ('B3', 'Amputee'),
                       ('B4', 'Mastectomy'),
                       ('B5', 'Paraplegic'),
                       ('B6', 'Pregnant'))),
          'HL70017': ('Transaction Type',
                      (('AJ', 'Adjustment'),
                       ('CD', 'Credit'),
                       ('CG', 'Charge'),
                       ('CO', 'Co-payment'),
                       ('PY', 'Payment'))),
          'HL70023': ('Admit Source',
                      (('1', 'Physician referral'),
                       ('2', 'Clinic referral'),
                       ('3', 'HMO referral'),
                       ('4', 'Transfer from a hospital'),
                       ('5', 'Transfer from a skilled nursing facility'),
                       ('6', 'Transfer from another health care facility'),
                       ('7', 'Emergency room'),
                       ('8', 'Court/law enforcement'),
                       ('9', 'Information not available'))),
          'HL70027': ('Priority',
                      (('A', 'As soon as possible (a priority lower than stat)'),
                       ('P', 'Preoperative (to be done prior to surgery)'),
                       ('R', 'Routine'),
                       ('S', 'Stat (do immediately)'),
                       ('T',
                        'Timing critical (do as near as possible to requested time)'))),
          'HL70038': ('Order status',
                      (('A', 'Some, but not all, results available'),
                       ('CA', 'Order was canceled'),
                       ('CM', 'Order is completed'),
                       ('DC', 'Order was discontinued'),
                       ('ER', 'Error, order not found'),
                       ('HD', 'Order is on hold'),
                       ('IP', 'In process, unspecified'),
                       ('RP', 'Order has been replaced'),
                       ('SC', 'In process, scheduled'))),
          'HL70048': ('What subject filter',
                      (('ADV', 'Advice/diagnosis'),
                       ('ANU',
                        'Nursing unit lookup (returns patients in beds, excluding empty beds)'),
                       ('APA', 'Account number query, return matching visit'),
                       ('APM',
                        'Medical record number query, returns visits for a medical record number'),
                       ('APN', 'Patient name lookup'),
                       ('APP', 'Physician lookup'),
                       ('ARN',
                        'Nursing unit lookup (returns patients in beds, including empty beds)'),
                       ('CAN', 'Cancel.  Used to cancel a query'),
                       ('DEM', 'Demographics'),
                       ('FIN', 'Financial'),
                       ('GID', 'Generate new identifier'),
                       ('GOL', 'Goals'),
                       ('MRI', 'Most recent inpatient'),
                       ('MRO', 'Most recent outpatient'),
                       ('NCK', 'Network clock'),
                       ('NSC', 'Network status change'),
                       ('NST', 'Network statistic'),
                       ('ORD', 'Order'),
                       ('OTH', 'Other'),
                       ('PRB', 'Problems'),
                       ('PRO', 'Procedure'),
                       ('RAR', 'Pharmacy administration information'),
                       ('RDR', 'Pharmacy dispense information'),
                       ('RER', 'Pharmacy encoded order information'),
                       ('RES', 'Result'),
                       ('RGR', 'Pharmacy give information'),
                       ('ROR', 'Pharmacy prescription information'),
                       ('SAL',
                        'All schedule related information, including open slots, booked slots, blocked slots'),
                       ('SBK', 'Booked slots on the identified schedule'),
                       ('SBL', 'Blocked slots on the identified schedule'),
                       ('SOF',
                        'First open slot on the identified schedule after the start date/tiem'),
                       ('SOP',
                        'Open slots on the identified schedule between the begin and end of the start date/time range'),
                       ('SSA', 'Time slots available for a single appointment'),
                       ('SSR', 'Time slots available for a recurring appointment'),
                       ('STA', 'Status'),
                       ('VXI', 'Vaccine Information'),
                       ('XID', 'Get cross-referenced identifiers'))),
          'HL70052': ('Diagnosis Type',
                      (('A', 'Admitting'), ('F', 'Final'), ('W', 'Working'))),
          'HL70061': ('Check digit scheme',
                      (('ISO', 'ISO 7064: 1983'),
                       ('M10', 'Mod 10 algorithm'),
                       ('M11', 'Mod 11 algorithm'),
                       ('NPI',
                        'Check digit algorithm in the US National Provider Identifier'))),
          'HL70062': ('Event reason',
                      (('01', 'Patient request'),
                       ('02', 'Physician/health practitioner order'),
                       ('03', 'Census management'),
                       ('O', 'Other'),
                       ('U', 'Unknown'))),
          'HL70063': ('Relationship',
                      (('ASC', 'Associate'),
                       ('BRO', 'Brother'),
                       ('CGV', 'Care giver'),
                       ('CHD', 'Child'),
                       ('DEP', 'Handicapped dependent'),
                       ('DOM', 'Life partner'),
                       ('EMC', 'Emergency contact'),
                       ('EME', 'Employee'),
                       ('EMR', 'Employer'),
                       ('EXF', 'Extended family'),
                       ('FCH', 'Foster child'),
                       ('FND', 'Friend'),
                       ('FTH', 'Father'),
                       ('GCH', 'Grandchild'),
                       ('GRD', 'Guardian'),
                       ('GRP', 'Grandparent'),
                       ('MGR', 'Manager'),
                       ('MTH', 'Mother'),
                       ('NCH', 'Natural child'),
                       ('NON', 'None'),
                       ('OAD', 'Other adult'),
                       ('OTH', 'Other'),
                       ('OWN', 'Owner'),
                       ('PAR', 'Parent'),
                       ('SCH', 'Stepchild'),
                       ('SEL', 'Self'),
                       ('SIB', 'Sibling'),
                       ('SIS', 'Sister'),
                       ('SPO', 'Spouse'),
                       ('TRA', 'Trainer'),
                       ('UNK', 'Unknown'),
                       ('WRD', 'Ward of court'))),
          'HL70065': ('Specimen Action Code',
                      (('A', 'Add ordered tests to the existing specimen'),
                       ('G', 'Generated order; reflex order'),
                       ('L', 'Lab to obtain specimen from patient'),
                       ('O', 'Specimen obtained by service other than Lab'),
                       ('P', 'Pending specimen; Order sent prior to delivery'),
                       ('R', 'Revised order'),
                       ('S', 'Schedule the tests specified below'))),
          'HL70066': ('Employment Status',
                      (('1', 'Full time employed'),
                       ('2', 'Part time employed'),
                       ('3', 'Unemployed'),
                       ('4', 'Self-employed,'),
                       ('5', 'Retired'),
                       ('6', 'On active military duty'),
                       ('9', 'Unknown'),
                       ('C', 'Contract, per diem'),
                       ('L',
                        'Leave of absence (e.g. Family leave, sabbatical, etc.)'),
                       ('O', 'Other'),
                       ('T', 'Temporarily unemployed'))),
          'HL70069': ('Hospital Service',
                      (('CAR', 'Cardiac Service'),
                       ('MED', 'Medical Service'),
                       ('PUL', 'Pulmonary Service'),
                       ('SUR', 'Surgical Service'),
                       ('URO', 'Urology Service'))),
          'HL70070': ('Specimen Source Codes',
                      (('ABS', 'Abscess'),
                       ('ACNE', 'Tissue, Acne'),
                       ('ACNFLD', 'Fluid, Acne'),
                       ('AIRS', 'Air Sample'),
                       ('ALL', 'Allograft'),
                       ('AMN', 'Amniotic fluid'),
                       ('AMP', 'Amputation'),
                       ('ANGI', 'Catheter Tip, Angio'),
                       ('ARTC', 'Catheter Tip, Arterial'),
                       ('ASERU', 'Serum, Acute'),
                       ('ASP', 'Aspirate'),
                       ('ATTE', 'Environmental, Autoclave Ampule'),
                       ('AUTOC', 'Environment, Attest'),
                       ('AUTP', 'Autopsy'),
                       ('BBL', 'Blood bag'),
                       ('BCYST', "Cyst, Baker's"),
                       ('BDY', 'Whole body'),
                       ('BIFL', 'Bile fluid'),
                       ('BITE', 'Bite'),
                       ('BLD', 'Whole blood'),
                       ('BLDA', 'Blood  arterial'),
                       ('BLDC', 'Blood  capillary'),
                       ('BLDCO', 'Cord blood'),
                       ('BLDV', 'Blood  venous'),
                       ('BLEB', 'Bleb'),
                       ('BLIST', 'Blister'),
                       ('BOIL', 'Boil'),
                       ('BON', 'Bone'),
                       ('BOWL', 'Bowel contents'),
                       ('BPH', 'Basophils'),
                       ('BPU', 'Blood product unit'),
                       ('BRN', 'Burn'),
                       ('BRO', 'Bronchial'),
                       ('BRSH', 'Brush'),
                       ('BRTH', 'Breath (use EXHLD)'),
                       ('BRUS', 'Brushing'),
                       ('BUB', 'Bubo'),
                       ('BULLA', 'Bulla/Bullae'),
                       ('BX', 'Biopsy'),
                       ('CALC', 'Calculus (=Stone)'),
                       ('CARBU', 'Carbuncle'),
                       ('CAT', 'Catheter'),
                       ('CBITE', 'Bite, Cat'),
                       ('CDM', 'Cardiac muscle'),
                       ('CLIPP', 'Clippings'),
                       ('CNJT', 'Conjunctiva'),
                       ('CNL', 'Cannula'),
                       ('COL', 'Colostrum'),
                       ('CONE', 'Biospy, Cone'),
                       ('CSCR', 'Scratch, Cat'),
                       ('CSERU', 'Serum, Convalescent'),
                       ('CSF', 'Cerebral spinal fluid'),
                       ('CSITE', 'Catheter Insertion Site'),
                       ('CSMY', 'Fluid,  Cystostomy Tube'),
                       ('CST', 'Fluid, Cyst'),
                       ('CSVR', 'Blood, Cell Saver'),
                       ('CTP', 'Catheter tip'),
                       ('CUR', 'Curettage'),
                       ('CVM', 'Cervical mucus'),
                       ('CVPS', 'Site, CVP'),
                       ('CVPT', 'Catheter Tip, CVP'),
                       ('CVX', 'Cervix'),
                       ('CYN', 'Nodule, Cystic'),
                       ('CYST', 'Cyst'),
                       ('DBITE', 'Bite, Dog'),
                       ('DCS', 'Sputum, Deep Cough'),
                       ('DEC', 'Ulcer, Decubitus'),
                       ('DEION', 'Environmental, Water  (Deionized)'),
                       ('DIA', 'Dialysate'),
                       ('DIAF', 'Dialysis fluid'),
                       ('DISCHG', 'Discharge'),
                       ('DIV', 'Diverticulum'),
                       ('DOSE', 'Dose med or substance'),
                       ('DRN', 'Drain'),
                       ('DRNG', 'Drainage, Tube'),
                       ('DRNGP', 'Drainage, Penrose'),
                       ('DUFL', 'Duodenal fluid'),
                       ('EAR', 'Ear'),
                       ('EARW', 'Ear wax (cerumen)'),
                       ('EBRUSH', 'Brush, Esophageal'),
                       ('EEYE', 'Environmental, Eye Wash'),
                       ('EFF', 'Environmental, Effluent'),
                       ('EFFUS', 'Effusion'),
                       ('EFOD', 'Environmental, Food'),
                       ('EISO', 'Environmental, Isolette'),
                       ('ELT', 'Electrode'),
                       ('ENDC', 'Endocardium'),
                       ('ENDM', 'Endometrium'),
                       ('ENVIR', 'Environmental, Unidentified Substance'),
                       ('EOS', 'Eosinophils'),
                       ('EOTH', 'Environmental, Other Substance'),
                       ('ESOI', 'Environmental, Soil'),
                       ('ESOS', 'Environmental, Solution (Sterile)'),
                       ('ETA', 'Aspirate,  Endotrach'),
                       ('ETTP', 'Catheter Tip, Endotracheal'),
                       ('ETTUB', 'Tube, Endotracheal'),
                       ('EWHI', 'Environmental, Whirlpool'),
                       ('EXG', 'Exhaled gas (=breath)'),
                       ('EXS', 'Shunt, External'),
                       ('EXUDTE', 'Exudate'),
                       ('EYE', 'Eye'),
                       ('FAW', 'Environmental, Water  (Well)'),
                       ('FBLOOD', 'Blood, Fetal'),
                       ('FGA', 'Fluid,  Abdomen'),
                       ('FIB', 'Fibroblasts'),
                       ('FIST', 'Fistula'),
                       ('FLD', 'Fluid, Other'),
                       ('FLT', 'Filter'),
                       ('FLU', 'Body fluid, unsp'),
                       ('FLUID', 'Fluid'),
                       ('FOLEY', 'Catheter Tip, Foley'),
                       ('FRS', 'Fluid, Respiratory'),
                       ('FSCLP', 'Scalp, Fetal'),
                       ('FUR', 'Furuncle'),
                       ('GAS', 'Gas'),
                       ('GASA', 'Aspirate, Gastric'),
                       ('GASAN', 'Antrum, Gastric'),
                       ('GASBR', 'Brushing, Gastric'),
                       ('GASD', 'Drainage, Gastric'),
                       ('GAST', 'Gastric fluid/contents'),
                       ('GEN', 'Genital'),
                       ('GENC', 'Genital cervix'),
                       ('GENL', 'Genital lochia'),
                       ('GENV', 'Genital vaginal'),
                       ('GRAFT', 'Graft'),
                       ('GRANU', 'Granuloma'),
                       ('GROSH', 'Catheter, Groshong'),
                       ('GSOL', 'Solution, Gastrostomy'),
                       ('GSPEC', 'Biopsy, Gastric'),
                       ('GT', 'Tube, Gastric'),
                       ('GTUBE', 'Drainage Tube, Drainage (Gastrostomy)'),
                       ('HAR', 'Hair'),
                       ('HBITE', 'Bite, Human'),
                       ('HBLUD', 'Blood, Autopsy'),
                       ('HEMAQ', 'Catheter Tip, Hemaquit'),
                       ('HEMO', 'Catheter Tip, Hemovac'),
                       ('HERNI', 'Tissue, Herniated'),
                       ('HEV', 'Drain, Hemovac'),
                       ('HIC', 'Catheter, Hickman'),
                       ('HYDC', 'Fluid, Hydrocele'),
                       ('IBITE', 'Bite, Insect'),
                       ('ICYST', 'Cyst, Inclusion'),
                       ('IDC', 'Catheter Tip, Indwelling'),
                       ('IHG', 'Inhaled Gas'),
                       ('ILEO', 'Drainage, Ileostomy'),
                       ('ILLEG', 'Source of Specimen Is Illegible'),
                       ('IMP', 'Implant'),
                       ('INCI', 'Site, Incision/Surgical'),
                       ('INFIL', 'Infiltrate'),
                       ('INS', 'Insect'),
                       ('INTRD', 'Catheter Tip, Introducer'),
                       ('ISLT', 'Isolate'),
                       ('IT', 'Intubation tube'),
                       ('IUD', 'Intrauterine Device'),
                       ('IVCAT', 'Catheter Tip, IV'),
                       ('IVFLD', 'Fluid, IV'),
                       ('IVTIP', 'Tubing Tip, IV'),
                       ('JEJU', 'Drainage, Jejunal'),
                       ('JNTFLD', 'Fluid, Joint'),
                       ('JP', 'Drainage, Jackson Pratt'),
                       ('KELOI', 'Lavage'),
                       ('KIDFLD', 'Fluid, Kidney'),
                       ('LAM', 'Lamella'),
                       ('LAVG', 'Lavage, Bronhial'),
                       ('LAVGG', 'Lavage, Gastric'),
                       ('LAVGP', 'Lavage, Peritoneal'),
                       ('LAVPG', 'Lavage, Pre-Bronch'),
                       ('LENS1', 'Contact Lens'),
                       ('LENS2', 'Contact Lens Case'),
                       ('LESN', 'Lesion'),
                       ('LIQ', 'Liquid NOS'),
                       ('LIQO', 'Liquid, Other'),
                       ('LN', 'Line'),
                       ('LNA', 'Line arterial'),
                       ('LNV', 'Line venous'),
                       ('LSAC', 'Fluid, Lumbar Sac'),
                       ('LYM', 'Lymphocytes'),
                       ('MAC', 'Macrophages'),
                       ('MAHUR', 'Catheter Tip, Makurkour'),
                       ('MAR', 'Marrow'),
                       ('MASS', 'Mass'),
                       ('MBLD', 'Menstrual blood'),
                       ('MEC', 'Meconium'),
                       ('MILK', 'Breast milk'),
                       ('MLK', 'Milk'),
                       ('MUCOS', 'Mucosa'),
                       ('MUCUS', 'Mucus'),
                       ('NAIL', 'Nail'),
                       ('NASDR', 'Drainage, Nasal'),
                       ('NEDL', 'Needle'),
                       ('NEPH', 'Site, Nephrostomy'),
                       ('NGASP', 'Aspirate, Nasogastric'),
                       ('NGAST', 'Drainage, Nasogastric'),
                       ('NGS', 'Site, Naso/Gastric'),
                       ('NODUL', 'Nodule(s)'),
                       ('NOS', 'Nose (nasal passage)'),
                       ('NSECR', 'Secretion, Nasal'),
                       ('ORH', 'Other'),
                       ('ORL', 'Lesion, Oral'),
                       ('OTH', 'Source, Other'),
                       ('PACEM', 'Pacemaker'),
                       ('PAFL', 'Pancreatic fluid'),
                       ('PAT', 'Patient'),
                       ('PCFL', 'Fluid, Pericardial'),
                       ('PDSIT', 'Site, Peritoneal Dialysis'),
                       ('PDTS', 'Site, Peritoneal Dialysis Tunnel'),
                       ('PELVA', 'Abscess, Pelvic'),
                       ('PENIL', 'Lesion, Penile'),
                       ('PERIA', 'Abscess, Perianal'),
                       ('PILOC', 'Cyst, Pilonidal'),
                       ('PINS', 'Site, Pin'),
                       ('PIS', 'Site, Pacemaker Insetion'),
                       ('PLAN', 'Plant Material'),
                       ('PLAS', 'Plasma'),
                       ('PLB', 'Plasma bag'),
                       ('PLC', 'Placenta'),
                       ('PLEVS', 'Serum, Peak Level'),
                       ('PLR', 'Pleural fluid (thoracentesis fld)'),
                       ('PMN', 'Polymorphonuclear neutrophils'),
                       ('PND', 'Drainage, Penile'),
                       ('POL', 'Polyps'),
                       ('POPGS', 'Graft Site, Popliteal'),
                       ('POPLG', 'Graft, Popliteal'),
                       ('POPLV', 'Site, Popliteal Vein'),
                       ('PORTA', 'Catheter, Porta'),
                       ('PPP', 'Platelet poor plasma'),
                       ('PROST', 'Prosthetic Device'),
                       ('PRP', 'Platelet rich plasma'),
                       ('PRT', 'Peritoneal fluid /ascites'),
                       ('PSC', 'Pseudocyst'),
                       ('PUNCT', 'Wound, Puncture'),
                       ('PUS', 'Pus'),
                       ('PUSFR', 'Pustule'),
                       ('PUST', 'Pus'),
                       ('QC3', 'Quality Control'),
                       ('RANDU', 'Urine, Random'),
                       ('RBC', 'Erythrocytes'),
                       ('RBITE', 'Bite, Reptile'),
                       ('RECT', 'Drainage, Rectal'),
                       ('RECTA', 'Abscess, Rectal'),
                       ('RENALC', 'Cyst, Renal'),
                       ('RENC', 'Fluid, Renal Cyst'),
                       ('RES', 'Respiratory'),
                       ('RT', 'Route of medicine'),
                       ('SAL', 'Saliva'),
                       ('SCAR', 'Tissue, Keloid (Scar)'),
                       ('SCLV', 'Catheter Tip, Subclavian'),
                       ('SCROA', 'Abscess, Scrotal'),
                       ('SECRE', 'Secretion(s)'),
                       ('SER', 'Serum'),
                       ('SHU', 'Site, Shunt'),
                       ('SHUNF', 'Fluid, Shunt'),
                       ('SHUNT', 'Shunt'),
                       ('SITE', 'Site'),
                       ('SKBP', 'Biopsy, Skin'),
                       ('SKM', 'Skeletal muscle'),
                       ('SKN', 'Skin'),
                       ('SMM', 'Mass, Sub-Mandibular'),
                       ('SMN', 'Seminal fluid'),
                       ('SNV', 'Synovial fluid (Joint fluid)'),
                       ('SPRM', 'Spermatozoa'),
                       ('SPRP', 'Catheter Tip, Suprapubic'),
                       ('SPRPB', 'Cathether Tip, Suprapubic'),
                       ('SPS', 'Environmental, Spore Strip'),
                       ('SPT', 'Sputum'),
                       ('SPTC', 'Sputum - coughed'),
                       ('SPTT', 'Sputum - tracheal aspirate'),
                       ('SPUT1', 'Sputum, Simulated'),
                       ('SPUTIN', 'Sputum, Inducted'),
                       ('SPUTSP', 'Sputum, Spontaneous'),
                       ('STER', 'Environmental, Sterrad'),
                       ('STL', 'Stool = Fecal'),
                       ('STON', 'Stone (use CALC)'),
                       ('STONE', 'Stone, Kidney'),
                       ('SUBMA', 'Abscess, Submandibular'),
                       ('SUBMX', 'Abscess, Submaxillary'),
                       ('SUMP', 'Drainage, Sump'),
                       ('SUP', 'Suprapubic Tap'),
                       ('SUTUR', 'Suture'),
                       ('SWGZ', 'Catheter Tip, Swan Gantz'),
                       ('SWT', 'Sweat'),
                       ('TASP', 'Aspirate, Tracheal'),
                       ('TEAR', 'Tears'),
                       ('THRB', 'Thrombocyte (platelet)'),
                       ('THRT', 'Throat'),
                       ('TISG', 'Tissue gall bladder'),
                       ('TISPL', 'Tissue placenta'),
                       ('TISS', 'Tissue'),
                       ('TISU', 'Tissue ulcer'),
                       ('TLC', 'Cathether Tip, Triple Lumen'),
                       ('TLGI', 'Tissue large intestine'),
                       ('TLNG', 'Tissue lung'),
                       ('TRAC', 'Site, Tracheostomy'),
                       ('TRANS', 'Transudate'),
                       ('TSERU', 'Serum, Trough'),
                       ('TSMI', 'Tissue small intestine'),
                       ('TSTES', 'Abscess, Testicular'),
                       ('TTRA', 'Aspirate, Transtracheal'),
                       ('TUB', 'Tube NOS'),
                       ('TUBES', 'Tubes'),
                       ('TUMOR', 'Tumor'),
                       ('TZANC', 'Smear, Tzanck'),
                       ('UDENT', 'Source, Unidentified'),
                       ('ULC', 'Ulcer'),
                       ('UMB', 'Umbilical blood'),
                       ('UMED', 'Unknown medicine'),
                       ('UR', 'Urine'),
                       ('URC', 'Urine clean catch'),
                       ('URINB', 'Urine, Bladder Washings'),
                       ('URINC', 'Urine, Catheterized'),
                       ('URINM', 'Urine, Midstream'),
                       ('URINN', 'Urine, Nephrostomy'),
                       ('URINP', 'Urine, Pedibag'),
                       ('URNS', 'Urine sediment'),
                       ('URT', 'Urine catheter'),
                       ('URTH', 'Urethra'),
                       ('USCOP', 'Urine, Cystoscopy'),
                       ('USPEC', 'Source, Unspecified'),
                       ('USUB', 'Unknown substance'),
                       ('VASTIP', 'Catheter Tip, Vas'),
                       ('VENT', 'Catheter Tip, Ventricular'),
                       ('VITF', 'Vitreous Fluid'),
                       ('VOM', 'Vomitus'),
                       ('WASH', 'Wash'),
                       ('WASI', 'Washing, e.g. bronchial washing'),
                       ('WAT', 'Water'),
                       ('WB', 'Blood, Whole'),
                       ('WBC', 'Leukocytes'),
                       ('WEN', 'Wen'),
                       ('WICK', 'Wick'),
                       ('WND', 'Wound'),
                       ('WNDA', 'Wound abscess'),
                       ('WNDD', 'Wound drainage'),
                       ('WNDE', 'Wound exudate'),
                       ('WORM', 'Worm'),
                       ('WRT', 'Wart'),
                       ('WWA', 'Environmental, Water'),
                       ('WWO', 'Environmental, Water (Ocean)'),
                       ('WWT', 'Environmental, Water  (Tap)'),
                       ('XXX', 'To be specified in another part of the message'))),
          'HL70074': ('Diagnostic Service Section ID',
                      (('AU', 'Audiology'),
                       ('BG', 'Blood Gases'),
                       ('BLB', 'Blood Bank'),
                       ('CH', 'Chemistry'),
                       ('CP', 'Cytopathology'),
                       ('CT', 'CAT Scan'),
                       ('CTH', 'Cardiac Catheterization'),
                       ('CUS', 'Cardiac Ultrasound'),
                       ('EC', 'Electrocardiac (e.g., EKG,  EEC, Holter)'),
                       ('EN', 'Electroneuro (EEG, EMG,EP,PSG)'),
                       ('HM', 'Hematology'),
                       ('ICU', 'Bedside ICU Monitoring'),
                       ('IMM', 'Immunology'),
                       ('LAB', 'Laboratory'),
                       ('MB', 'Microbiology'),
                       ('MCB', 'Mycobacteriology'),
                       ('MYC', 'Mycology'),
                       ('NMR', 'Nuclear Magnetic Resonance'),
                       ('NMS', 'Nuclear Medicine Scan'),
                       ('NRS', 'Nursing Service Measures'),
                       ('OSL', 'Outside Lab'),
                       ('OT', 'Occupational Therapy'),
                       ('OTH', 'Other'),
                       ('OUS', 'OB Ultrasound'),
                       ('PF', 'Pulmonary Function'),
                       ('PHR', 'Pharmacy'),
                       ('PHY', 'Physician (Hx. Dx, admission note, etc.)'),
                       ('PT', 'Physical Therapy'),
                       ('RAD', 'Radiology'),
                       ('RC', 'Respiratory Care (therapy)'),
                       ('RT', 'Radiation Therapy'),
                       ('RUS', 'Radiology Ultrasound'),
                       ('RX', 'Radiograph'),
                       ('SP', 'Surgical Pathology'),
                       ('SR', 'Serology'),
                       ('TX', 'Toxicology'),
                       ('VR', 'Virology'),
                       ('VUS', 'Vascular Ultrasound'),
                       ('XRC', 'Cineradiograph'))),
          'HL70076': ('Message type',
                      (('ACK', 'General acknowledgment message'),
                       ('ADR', 'ADT response'),
                       ('ADT', 'ADT message'),
                       ('BAR', 'Add/change billing account'),
                       ('BPS', 'Blood product dispense status message'),
                       ('BRP',
                        'Blood product dispense status acknowledgement message'),
                       ('BRT',
                        'Blood product transfusion/disposition acknowledgement message'),
                       ('BTS', 'Blood product transfusion/disposition message'),
                       ('CRM', 'Clinical study registration message'),
                       ('CSU', 'Unsolicited study data message'),
                       ('DFT', 'Detail financial transactions'),
                       ('DOC', 'Document response'),
                       ('DSR', 'Display response'),
                       ('EAC', 'Automated equipment command message'),
                       ('EAN', 'Automated equipment notification message'),
                       ('EAR', 'Automated equipment response message'),
                       ('EDR', 'Enhanced display response'),
                       ('EQQ', 'Embedded query language query'),
                       ('ERP', 'Event replay response'),
                       ('ESR',
                        'Automated equipment status update acknowledgment message'),
                       ('ESU', 'Automated equipment status update message'),
                       ('INR', 'Automated equipment inventory request message'),
                       ('INU', 'Automated equipment inventory update message'),
                       ('LSR', 'Automated equipment log/service request message'),
                       ('LSU', 'Automated equipment log/service update message'),
                       ('MCF',
                        'Delayed Acknowledgment (Retained for backward compatibility only)'),
                       ('MDM', 'Medical document management'),
                       ('MFD', 'Master files delayed application acknowledgment'),
                       ('MFK', 'Master files application acknowledgment'),
                       ('MFN', 'Master files notification'),
                       ('MFQ', 'Master files query'),
                       ('MFR', 'Master files response'),
                       ('NMD', 'Application management data message'),
                       ('NMQ', 'Application management query message'),
                       ('NMR', 'Application management response message'),
                       ('OMB', 'Blood product order message'),
                       ('OMD', 'Dietary order'),
                       ('OMG', 'General clinical order message'),
                       ('OMI', 'Imaging order'),
                       ('OML', 'Laboratory order message'),
                       ('OMN', 'Non-stock requisition order message'),
                       ('OMP', 'Pharmacy/treatment order message'),
                       ('OMS', 'Stock requisition order message'),
                       ('ORB', 'Blood product order acknowledgement message'),
                       ('ORD', 'Dietary order acknowledgment message'),
                       ('ORF', 'Query for results of observation'),
                       ('ORG', 'General clinical order acknowledgment message'),
                       ('ORI', 'Imaging order acknowledgement message'),
                       ('ORL', 'Laboratory acknowledgment message (unsolicited)'),
                       ('ORM', 'Pharmacy/treatment order message'),
                       ('ORN',
                        'Non-stock requisition - General order acknowledgment message'),
                       ('ORP', 'Pharmacy/treatment order acknowledgment message'),
                       ('ORR', 'General order response message response to any ORM'),
                       ('ORS', 'Stock requisition - Order acknowledgment message'),
                       ('ORU', 'Unsolicited transmission of an observation message'),
                       ('OSQ', 'Query response for order status'),
                       ('OSR', 'Query response for order status'),
                       ('OUL', 'Unsolicited laboratory observation message'),
                       ('PEX', 'Product experience message'),
                       ('PGL', 'Patient goal message'),
                       ('PIN', 'Patient insurance information'),
                       ('PMU', 'Add personnel record'),
                       ('PPG', 'Patient pathway message (goal-oriented)'),
                       ('PPP', 'Patient pathway message (problem-oriented)'),
                       ('PPR', 'Patient problem message'),
                       ('PPT', 'Patient pathway goal-oriented response'),
                       ('PPV', 'Patient goal response'),
                       ('PRR', 'Patient problem response'),
                       ('PTR', 'Patient pathway problem-oriented response'),
                       ('QBP', 'Query by parameter'),
                       ('QCK', 'Deferred query'),
                       ('QCN', 'Cancel query'),
                       ('QRY', 'Query, original mode'),
                       ('QSB', 'Create subscription'),
                       ('QSX', 'Cancel subscription/acknowledge message'),
                       ('QVR', 'Query for previous events'),
                       ('RAR', 'Pharmacy/treatment administration information'),
                       ('RAS', 'Pharmacy/treatment administration message'),
                       ('RCI', 'Return clinical information'),
                       ('RCL', 'Return clinical list'),
                       ('RDE', 'Pharmacy/treatment encoded order message'),
                       ('RDR', 'Pharmacy/treatment dispense information'),
                       ('RDS', 'Pharmacy/treatment dispense message'),
                       ('RDY', 'Display based response'),
                       ('REF', 'Patient referral'),
                       ('RER', 'Pharmacy/treatment encoded order information'),
                       ('RGR', 'Pharmacy/treatment dose information'),
                       ('RGV', 'Pharmacy/treatment give message'),
                       ('ROR', 'Pharmacy/treatment order response'),
                       ('RPA', 'Return patient authorization'),
                       ('RPI', 'Return patient information'),
                       ('RPL', 'Return patient display list'),
                       ('RPR', 'Return patient list'),
                       ('RQA', 'Request patient authorization'),
                       ('RQC', 'Request clinical information'),
                       ('RQI', 'Request patient information'),
                       ('RQP', 'Request patient demographics'),
                       ('RQQ', 'Event replay query'),
                       ('RRA',
                        'Pharmacy/treatment administration acknowledgment message'),
                       ('RRD', 'Pharmacy/treatment dispense acknowledgment message'),
                       ('RRE',
                        'Pharmacy/treatment encoded order acknowledgment message'),
                       ('RRG', 'Pharmacy/treatment give acknowledgment message'),
                       ('RRI', 'Return referral information'),
                       ('RSP', 'Segment pattern response'),
                       ('RTB', 'Tabular response'),
                       ('SIU', 'Schedule information unsolicited'),
                       ('SPQ', 'Stored procedure request'),
                       ('SQM', 'Schedule query message'),
                       ('SQR', 'Schedule query response'),
                       ('SRM', 'Schedule request message'),
                       ('SRR', 'Scheduled request response'),
                       ('SSR', 'Specimen status request message'),
                       ('SSU', 'Specimen status update message'),
                       ('SUR', 'Summary product experience report'),
                       ('TBR', 'Tabular data response'),
                       ('TCR',
                        'Automated equipment test code settings request message'),
                       ('TCU',
                        'Automated equipment test code settings update message'),
                       ('UDM', 'Unsolicited display update message'),
                       ('VQQ', 'Virtual table query'),
                       ('VXQ', 'Query for vaccination record'),
                       ('VXR', 'Vaccination record response'),
                       ('VXU', 'Unsolicited vaccination record update'),
                       ('VXX',
                        'Response for vaccination query with multiple PID matches'))),
          'HL70078': ('Abnormal flags',
                      (('<', 'Below absolute low-off instrument scale'),
                       ('>', 'Above absolute high-off instrument scale'),
                       ('A', 'Abnormal (applies to non-numeric results)'),
                       ('AA',
                        'Very abnormal (applies to non-numeric units, analogous to panic limits for numeric units)'),
                       ('B', 'Better--use when direction not relevant'),
                       ('D', 'Significant change down'),
                       ('H', 'Above high normal'),
                       ('HH', 'Above upper panic limits'),
                       ('I',
                        'Intermediate. Indicates for microbiology susceptibilities only.'),
                       ('L', 'Below low normal'),
                       ('LL', 'Below lower panic limits'),
                       ('MS',
                        'Moderately susceptible. Indicates for microbiology susceptibilities only.'),
                       ('N', 'Normal (applies to non-numeric results)'),
                       ('null', "No range defined, or normal ranges don't apply"),
                       ('R',
                        'Resistant. Indicates for microbiology susceptibilities only.'),
                       ('S',
                        'Susceptible. Indicates for microbiology susceptibilities only.'),
                       ('U', 'Significant change up'),
                       ('VS',
                        'Very susceptible. Indicates for microbiology susceptibilities only.'),
                       ('W', 'Worse--use when direction not relevant'))),
          'HL70080': ('Nature of Abnormal Testing',
                      (('A', 'An age-based population'),
                       ('B', 'Breed'),
                       ('N', 'None - generic normal range'),
                       ('R', 'A race-based population'),
                       ('S', 'A sex-based population'),
                       ('SP', 'Species'),
                       ('ST', 'Strain'))),
          'HL70083': ('Outlier Type', (('C', 'Outlier cost'), ('D', 'Outlier days'))),
          'HL70085': ('Observation result status codes interpretation',
                      (('C',
                        'Record coming over is a correction and thus replaces a final result'),
                       ('D', 'Deletes the OBX record'),
                       ('F',
                        'Final results; Can only be changed with a corrected result.'),
                       ('I', 'Specimen in lab; results pending'),
                       ('N',
                        'Not asked; used to affirmatively document that the observation identified in the OBX was not '
                        'sought when the universal service ID in OBR-4 implies that it would be sought.'),
                       ('O', 'Order detail description only (no result)'),
                       ('P', 'Preliminary results'),
                       ('R', 'Results entered -- not verified'),
                       ('S', 'Partial results'),
                       ('U',
                        'Results status change to final without retransmitting results already sent as _preliminary._  '
                        'E.g., radiology changes status from preliminary to final'),
                       ('W',
                        'Post original as wrong, e.g., transmitted for wrong patient'),
                       ('X', 'Results cannot be obtained for this observation'))),
          'HL70091': ('Query priority', (('D', 'Deferred'), ('I', 'Immediate'))),
          'HL70092': ('Re-Admission Indicator', (('R', 'Re-admission'),)),
          'HL70093': ('Release Information',
                      (('_', 'user-defined codes'), ('N', 'No'), ('Y', 'Yes'))),
          'HL70098': ('Type of Agreement',
                      (('M', 'Maternity'), ('S', 'Standard'), ('U', 'Unified'))),
          'HL70100': ('Invocation event',
                      (('D', 'On discharge'),
                       ('O', 'On receipt of order'),
                       ('R', 'At time service is completed'),
                       ('S', 'At time service is started'),
                       ('T', 'At a designated date/time'))),
          'HL70103': ('Processing ID',
                      (('D', 'Debugging'), ('P', 'Production'), ('T', 'Training'))),
          'HL70104': ('Version ID',
                      (('2.0', 'Release 2.0'),
                       ('2.0D', 'Demo 2.0'),
                       ('2.1', 'Release 2. 1'),
                       ('2.2', 'Release 2.2'),
                       ('2.3', 'Release 2.3'),
                       ('2.3.1', 'Release 2.3.1'),
                       ('2.4', 'Release 2.4'),
                       ('2.5', 'Release 2.5'),
                       ('2.5.1', 'Release 2.5.1'))),
          'HL70105': ('Source of comment',
                      (('L', 'Ancillary (filler) department is source of comment'),
                       ('O', 'Other system is source of comment'),
                       ('P', 'Orderer (placer) is source of comment'))),
          'HL70106': ('Query/response format code',
                      (('D', 'Response is in display format'),
                       ('R', 'Response is in record-oriented format'),
                       ('T', 'Response is in tabular format'))),
          'HL70107': ('Deferred response type',
                      (('B', 'Before the Date/Time specified'),
                       ('L', 'Later than the Date/Time specified'))),
          'HL70108': ('Query results level',
                      (('O', 'Order plus order status'),
                       ('R', 'Results without bulk text'),
                       ('S', 'Status only'),
                       ('T', 'Full results'))),
          'HL70109': ('Report priority', (('R', 'Routine'), ('S', 'Stat'))),
          'HL70112': ('Discharge Disposition',
                      (('01', 'Discharged to home or self care (routine discharge)'),
                       ('02',
                        'Discharged/transferred to another short term general hospital for inpatient care'),
                       ('03',
                        'Discharged/transferred to skilled nursing facility (SNF)'),
                       ('04',
                        'Discharged/transferred to an intermediate care facility (ICF)'),
                       ('05',
                        'Discharged/transferred to another type of institution for inpatient care or referred for '
                        'outpatient services to another institution'),
                       ('06',
                        'Discharged/transferred to home under care of organized home health service organization'),
                       ('07', 'Left against medical advice or discontinued care'),
                       ('08',
                        'Discharged/transferred to home under care of Home IV provider'),
                       ('09', 'Admitted as an inpatient to this hospital'),
                       ('10 _19',
                        'Discharge to be defined at state level, if necessary'),
                       ('20', 'Expired (i.e. dead)'),
                       ('21 ... 29',
                        'Expired to be defined at state level, if necessary'),
                       ('30',
                        'Still patient or expected to return for outpatient services (i.e. still a patient)'),
                       ('31 _ 39',
                        'Still patient to be defined at state level, if necessary  (i.e. still a patient)'),
                       ('40', 'Expired (i.e. died) at home'),
                       ('41',
                        'Expired (i.e. died) in a medical facility; e.g., hospital, SNF, ICF, or free standing '
                        'hospice'),
                       ('42', 'Expired (i.e. died)  - place unknown'))),
          'HL70116': ('Bed Status',
                      (('C', 'Closed'),
                       ('H', 'Housekeeping'),
                       ('I', 'Isolated'),
                       ('K', 'Contaminated'),
                       ('O', 'Occupied'),
                       ('U', 'Unoccupied'))),
          'HL70119': ('Order control codes',
                      (('AF', 'Order/service refill request approval'),
                       ('CA', 'Cancel order/service request'),
                       ('CH', 'Child order/service'),
                       ('CN', 'Combined result'),
                       ('CR', 'Canceled as requested'),
                       ('DC', 'Discontinue order/service request'),
                       ('DE', 'Data errors'),
                       ('DF', 'Order/service refill request denied'),
                       ('DR', 'Discontinued as requested'),
                       ('FU', 'Order/service refilled, unsolicited'),
                       ('HD', 'Hold order request'),
                       ('HR', 'On hold as requested'),
                       ('LI', 'Link order/service to patient care problem or goal'),
                       ('NA', 'Number assigned'),
                       ('NW', 'New order/service'),
                       ('OC', 'Order/service canceled'),
                       ('OD', 'Order/service discontinued'),
                       ('OE', 'Order/service released'),
                       ('OF', 'Order/service refilled as requested'),
                       ('OH', 'Order/service held'),
                       ('OK', 'Order/service accepted & OK'),
                       ('OP', 'Notification of order for outside dispense'),
                       ('OR', 'Released as requested'),
                       ('PA', 'Parent order/service'),
                       ('PR', 'Previous Results with new order/service'),
                       ('PY',
                        'Notification of replacement order for outside dispense'),
                       ('RE', 'Observations/Performed Service to follow'),
                       ('RF', 'Refill order/service request'),
                       ('RL', 'Release previous hold'),
                       ('RO', 'Replacement order'),
                       ('RP', 'Order/service replace request'),
                       ('RQ', 'Replaced as requested'),
                       ('RR', 'Request received'),
                       ('RU', 'Replaced unsolicited'),
                       ('SC', 'Status changed'),
                       ('SN', 'Send order/service number'),
                       ('SR', 'Response to send order/service status request'),
                       ('SS', 'Send order/service status request'),
                       ('UA', 'Unable to accept order/service'),
                       ('UC', 'Unable to cancel'),
                       ('UD', 'Unable to discontinue'),
                       ('UF', 'Unable to refill'),
                       ('UH', 'Unable to put on hold'),
                       ('UM', 'Unable to replace'),
                       ('UN',
                        'Unlink order/service from patient care problem or goal'),
                       ('UR', 'Unable to release'),
                       ('UX', 'Unable to change'),
                       ('XO', 'Change order/service request'),
                       ('XR', 'Changed as requested'),
                       ('XX', 'Order/service changed, unsol.'))),
          'HL70121': ('Response flag',
                      (('D', 'Same as R, also other associated segments'),
                       ('E', 'Report exceptions only'),
                       ('F', 'Same as D, plus confirmations explicitly'),
                       ('N', 'Only the MSA segment is returned'),
                       ('R', 'Same as E, also Replacement and Parent-Child'))),
          'HL70122': ('Charge type',
                      (('CH', 'Charge'),
                       ('CO', 'Contract'),
                       ('CR', 'Credit'),
                       ('DP', 'Department'),
                       ('GR', 'Grant'),
                       ('NC', 'No Charge'),
                       ('PC', 'Professional'),
                       ('RS', 'Research'))),
          'HL70123': ('Result Status',
                      (('A', 'Some, but not all, results available'),
                       ('C', 'Correction to results'),
                       ('F',
                        'Final results; results stored and verified.  Can only be changed with a corrected result.'),
                       ('I',
                        'No results available; specimen received, procedure incomplete'),
                       ('O', 'Order received; specimen not yet received'),
                       ('P',
                        'Preliminary: A verified early result is available, final results not yet obtained'),
                       ('R', 'Results stored; not yet verified'),
                       ('S',
                        'No results available; procedure scheduled, but not done'),
                       ('X', 'No results available; Order canceled.'),
                       ('Y',
                        'No order on record for this test.  (Used only on queries)'),
                       ('Z', 'No record of this patient. (Used only on queries)'))),
          'HL70124': ('Transportation Mode',
                      (('CART', 'Cart - patient travels on cart or gurney'),
                       ('PORT', "The examining device goes to patient's location"),
                       ('WALK', 'Patient walks to diagnostic service'),
                       ('WHLC', 'Wheelchair'))),
          'HL70125': ('Value type',
                      (('AD', 'Address'),
                       ('CE', 'Coded Entry'),
                       ('CF', 'Coded Element With Formatted Values'),
                       ('CK', 'Composite ID With Check Digit'),
                       ('CN', 'Composite ID And Name'),
                       ('CP', 'Composite Price'),
                       ('CX', 'Extended Composite ID With Check Digit'),
                       ('DT', 'Date'),
                       ('ED', 'Encapsulated Data'),
                       ('FT', 'Formatted Text (Display)'),
                       ('MO', 'Money'),
                       ('NM', 'Numeric'),
                       ('PN', 'Person Name'),
                       ('RP', 'Reference Pointer'),
                       ('SN', 'Structured Numeric'),
                       ('ST', 'String Data.'),
                       ('TM', 'Time'),
                       ('TN', 'Telephone Number'),
                       ('TS', 'Time Stamp (Date & Time)'),
                       ('TX', 'Text Data (Display)'),
                       ('XAD', 'Extended Address'),
                       ('XCN', 'Extended Composite Name And Number For Persons'),
                       ('XON',
                        'Extended Composite Name And Number For Organizations'),
                       ('XPN', 'Extended Person Name'),
                       ('XTN', 'Extended Telecommunications Number'))),
          'HL70126': ('Quantity limited request',
                      (('CH', 'Characters'),
                       ('LI', 'Lines'),
                       ('PG', 'Pages'),
                       ('RD', 'Records'),
                       ('ZO', 'Locally defined'))),
          'HL70127': ('Allergen Type',
                      (('AA', 'Animal Allergy'),
                       ('DA', 'Drug allergy'),
                       ('EA', 'Environmental Allergy'),
                       ('FA', 'Food allergy'),
                       ('LA', 'Pollen Allergy'),
                       ('MA', 'Miscellaneous allergy'),
                       ('MC', 'Miscellaneous contraindication'),
                       ('PA', 'Plant Allergy'))),
          'HL70128': ('Allergy Severity',
                      (('MI', 'Mild'),
                       ('MO', 'Moderate'),
                       ('SV', 'Severe'),
                       ('U', 'Unknown'))),
          'HL70130': ('Visit User Code',
                      (('HO', 'Home'),
                       ('MO', 'Mobile Unit'),
                       ('PH', 'Phone'),
                       ('TE', 'Teaching'))),
          'HL70131': ('Contact Role',
                      (('C', 'Emergency Contact'),
                       ('E', 'Employer'),
                       ('F', 'Federal Agency'),
                       ('I', 'Insurance Company'),
                       ('N', 'Next-of-Kin'),
                       ('O', 'Other'),
                       ('S', 'State Agency'),
                       ('U', 'Unknown'))),
          'HL70133': ('Procedure Practitioner Identifier Code Type',
                      (('AN', 'Anesthesiologist/Anesthetist'),
                       ('AS', 'Assistant Surgeon'),
                       ('CM', 'Certified Nurse Midwife'),
                       ('NP', 'Nurse Practitioner'),
                       ('PR', 'Procedure MD/ Surgeon'),
                       ('PS', 'Primary Surgeon'),
                       ('RD', 'Radiologist'),
                       ('RS', 'Resident'),
                       ('SN', 'Scrub Nurse'))),
          'HL70135': ('Assignment of Benefits',
                      (('M', 'Modified assignment'), ('N', 'No'), ('Y', 'Yes'))),
          'HL70136': ('Yes/no indicator', (('N', 'No'), ('Y', 'Yes'))),
          'HL70137': ('Mail Claim Party',
                      (('E', 'Employer'),
                       ('G', 'Guarantor'),
                       ('I', 'Insurance company'),
                       ('O', 'Other'),
                       ('P', 'Patient'))),
          'HL70140': ('Military Service',
                      (('AUSA', 'Australian Army'),
                       ('AUSAF', 'Australian Air Force'),
                       ('AUSN', 'Australian Navy'),
                       ('NATO', 'North Atlantic Treaty Organization'),
                       ('NOAA', 'National Oceanic and Atmospheric Administration'),
                       ('USA', 'US Army'),
                       ('USAF', 'US Air Force'),
                       ('USCG', 'US Coast Guard'),
                       ('USMC', 'US Marine Corps'),
                       ('USN', 'US Navy'),
                       ('USPHS', 'US Public Health Service'))),
          'HL70141': ('Military Rank/Grade',
                      (('E1... E9', 'Enlisted'),
                       ('O1 ... O9', 'Officers'),
                       ('W1 ... W4', 'Warrant Officers'))),
          'HL70142': ('Military Status',
                      (('ACT', 'Active duty'),
                       ('DEC', 'Deceased'),
                       ('RET', 'Retired'))),
          'HL70144': ('Eligibility Source',
                      (('1', 'Insurance company'),
                       ('2', 'Employer'),
                       ('3', 'Insured presented policy'),
                       ('4', 'Insured presented card'),
                       ('5', 'Signed statement on file'),
                       ('6', 'Verbal information'),
                       ('7', 'None'))),
          'HL70145': ('Room type',
                      (('2ICU', 'Second intensive care unit'),
                       ('2PRI', 'Second private room'),
                       ('2SPR', 'Second semi-private room'),
                       ('ICU', 'Intensive care unit'),
                       ('PRI', 'Private room'),
                       ('SPR', 'Semi-private room'))),
          'HL70146': ('Amount type',
                      (('DF', 'Differential'),
                       ('LM', 'Limit'),
                       ('PC', 'Percentage'),
                       ('RT', 'Rate'),
                       ('UL', 'Unlimited'))),
          'HL70147': ('Policy type',
                      (('2ANC', 'Second ancillary'),
                       ('2MMD', 'Second major medical'),
                       ('3MMD', 'Third major medical'),
                       ('ANC', 'Ancillary'),
                       ('MMD', 'Major medical'))),
          'HL70148': ('Money or percentage indicator',
                      (('AT', 'Currency amount'), ('PC', 'Percentage'))),
          'HL70149': ('Day type',
                      (('AP', 'Approved'), ('DE', 'Denied'), ('PE', 'Pending'))),
          'HL70150': ('Certification patient type',
                      (('ER', 'Emergency'),
                       ('IPE', 'Inpatient elective'),
                       ('OPE', 'Outpatient elective'),
                       ('UR', 'Urgent'))),
          'HL70155': ('Accept/application acknowledgment conditions',
                      (('AL', 'Always'),
                       ('ER', 'Error/reject conditions only'),
                       ('NE', 'Never'),
                       ('SU', 'Successful completion only'))),
          'HL70156': ('Which date/time qualifier',
                      (('ANY', 'Any date/time within a range'),
                       ('COL',
                        'Collection date/time, equivalent to film or sample collection date/time'),
                       ('ORD', 'Order date/time'),
                       ('RCT',
                        'Specimen receipt date/time, receipt of specimen in filling ancillary (Lab)'),
                       ('REP',
                        'Report date/time, report date/time at filing ancillary (i.e., Lab)'),
                       ('SCHED', 'Schedule date/time'))),
          'HL70157': ('Which date/time status qualifier',
                      (('ANY', 'Any status'),
                       ('CFN', 'Current final value, whether final or corrected'),
                       ('COR', 'Corrected only (no final with corrections)'),
                       ('FIN', 'Final only (no corrections)'),
                       ('PRE', 'Preliminary'),
                       ('REP', 'Report completion date/time'))),
          'HL70158': ('Date/time selection qualifier',
                      (('1ST', 'First value within range'),
                       ('ALL', 'All values within the range'),
                       ('LST', 'Last value within the range'),
                       ('REV',
                        'All values within the range returned in reverse chronological order (This is the default if '
                        'not otherwise specified.)'))),
          'HL70159': ('Diet Code Specification Type',
                      (('D', 'Diet'), ('P', 'Preference'), ('S', 'Supplement'))),
          'HL70160': ('Tray Type',
                      (('EARLY', 'Early tray'),
                       ('GUEST', 'Guest tray'),
                       ('LATE', 'Late tray'),
                       ('MSG', 'Tray message only'),
                       ('NO', 'No tray'))),
          'HL70161': ('Allow Substitution',
                      (('G', 'Allow generic substitutions.'),
                       ('N',
                        'Substitutions are NOT authorized.  (This is the default - null.)'),
                       ('T', 'Allow therapeutic substitutions'))),
          'HL70162': ('Route of Administration',
                      (('AP', 'Apply Externally'),
                       ('B', 'Buccal'),
                       ('DT', 'Dental'),
                       ('EP', 'Epidural'),
                       ('ET', 'Endotrachial Tube*'),
                       ('GTT', 'Gastrostomy Tube'),
                       ('GU', 'GU Irrigant'),
                       ('IA', 'Intra-arterial'),
                       ('IB', 'Intrabursal'),
                       ('IC', 'Intracardiac'),
                       ('ICV', 'Intracervical (uterus)'),
                       ('ID', 'Intradermal'),
                       ('IH', 'Inhalation'),
                       ('IHA', 'Intrahepatic Artery'),
                       ('IM', 'Intramuscular'),
                       ('IMR', 'Immerse (Soak) Body Part'),
                       ('IN', 'Intranasal'),
                       ('IO', 'Intraocular'),
                       ('IP', 'Intraperitoneal'),
                       ('IS', 'Intrasynovial'),
                       ('IT', 'Intrathecal'),
                       ('IU', 'Intrauterine'),
                       ('IV', 'Intravenous'),
                       ('MM', 'Mucous Membrane'),
                       ('MTH', 'Mouth/Throat'),
                       ('NG', 'Nasogastric'),
                       ('NP', 'Nasal Prongs*'),
                       ('NS', 'Nasal'),
                       ('NT', 'Nasotrachial Tube'),
                       ('OP', 'Ophthalmic'),
                       ('OT', 'Otic'),
                       ('OTH', 'Other/Miscellaneous'),
                       ('PF', 'Perfusion'),
                       ('PO', 'Oral'),
                       ('PR', 'Rectal'),
                       ('RM', 'Rebreather Mask*'),
                       ('SC', 'Subcutaneous'),
                       ('SD', 'Soaked Dressing'),
                       ('SL', 'Sublingual'),
                       ('TD', 'Transdermal'),
                       ('TL', 'Translingual'),
                       ('TP', 'Topical'),
                       ('TRA', 'Tracheostomy*'),
                       ('UR', 'Urethral'),
                       ('VG', 'Vaginal'),
                       ('VM', 'Ventimask'),
                       ('WND', 'Wound'))),
          'HL70163': ('Body site',
                      (('BE', 'Bilateral Ears'),
                       ('BN', 'Bilateral Nares'),
                       ('BU', 'Buttock'),
                       ('CT', 'Chest Tube'),
                       ('LA', 'Left Arm'),
                       ('LAC', 'Left Anterior Chest'),
                       ('LACF', 'Left Antecubital Fossa'),
                       ('LD', 'Left Deltoid'),
                       ('LE', 'Left Ear'),
                       ('LEJ', 'Left External Jugular'),
                       ('LF', 'Left Foot'),
                       ('LG', 'Left Gluteus Medius'),
                       ('LH', 'Left Hand'),
                       ('LIJ', 'Left Internal Jugular'),
                       ('LLAQ', 'Left Lower Abd Quadrant'),
                       ('LLFA', 'Left Lower Forearm'),
                       ('LMFA', 'Left Mid Forearm'),
                       ('LN', 'Left Naris'),
                       ('LPC', 'Left Posterior Chest'),
                       ('LSC', 'Left Subclavian'),
                       ('LT', 'Left Thigh'),
                       ('LUA', 'Left Upper Arm'),
                       ('LUAQ', 'Left Upper Abd Quadrant'),
                       ('LUFA', 'Left Upper Forearm'),
                       ('LVG', 'Left Ventragluteal'),
                       ('LVL', 'Left Vastus Lateralis'),
                       ('NB', 'Nebulized'),
                       ('OD', 'Right Eye'),
                       ('OS', 'Left Eye'),
                       ('OU', 'Bilateral Eyes'),
                       ('PA', 'Perianal'),
                       ('PERIN', 'Perineal'),
                       ('RA', 'Right Arm'),
                       ('RAC', 'Right Anterior Chest'),
                       ('RACF', 'Right Antecubital Fossa'),
                       ('RD', 'Right Deltoid'),
                       ('RE', 'Right Ear'),
                       ('REJ', 'Right External Jugular'),
                       ('RF', 'Right Foot'),
                       ('RG', 'Right Gluteus Medius'),
                       ('RH', 'Right Hand'),
                       ('RIJ', 'Right Internal Jugular'),
                       ('RLAQ', 'Rt Lower Abd Quadrant'),
                       ('RLFA', 'Right Lower Forearm'),
                       ('RMFA', 'Right Mid Forearm'),
                       ('RN', 'Right Naris'),
                       ('RPC', 'Right Posterior Chest'),
                       ('RSC', 'Right Subclavian'),
                       ('RT', 'Right Thigh'),
                       ('RUA', 'Right Upper Arm'),
                       ('RUAQ', 'Right Upper Abd Quadrant'),
                       ('RUFA', 'Right Upper Forearm'),
                       ('RVG', 'Right Ventragluteal'),
                       ('RVL', 'Right Vastus Lateralis'))),
          'HL70164': ('Administration Device',
                      (('AP', 'Applicator'),
                       ('BT', 'Buretrol'),
                       ('HL', 'Heparin Lock'),
                       ('IPPB', 'IPPB'),
                       ('IVP', 'IV Pump'),
                       ('IVS', 'IV Soluset'),
                       ('MI', 'Metered Inhaler'),
                       ('NEB', 'Nebulizer'),
                       ('PCA', 'PCA Pump'))),
          'HL70165': ('Administration Method',
                      (('CH', 'Chew'),
                       ('DI', 'Dissolve'),
                       ('DU', 'Dust'),
                       ('IF', 'Infiltrate'),
                       ('IR', 'Irrigate'),
                       ('IS', 'Insert'),
                       ('IVP', 'IV Push'),
                       ('IVPB', 'IV Piggyback'),
                       ('NB', 'Nebulized'),
                       ('PF', 'Perfuse'),
                       ('PT', 'Pain'),
                       ('SH', 'Shampoo'),
                       ('SO', 'Soak'),
                       ('WA', 'Wash'),
                       ('WI', 'Wipe'))),
          'HL70166': ('RX Component Type', (('A', 'Additive'), ('B', 'Base'))),
          'HL70167': ('Substitution Status',
                      (('0', 'No product selection indicated'),
                       ('1', 'Substitution not allowed by prescriber'),
                       ('2',
                        'Substitution allowed - patient requested product dispensed'),
                       ('3',
                        'Substitution allowed - pharmacist selected product dispensed'),
                       ('4', 'Substitution allowed - generic drug not in stock'),
                       ('5',
                        'Substitution allowed - brand drug dispensed as a generic'),
                       ('7', 'Substitution not allowed - brand drug mandated by law'),
                       ('8',
                        'Substitution allowed - generic drug not available in marketplace'),
                       ('G', 'A generic substitution was dispensed.'),
                       ('N',
                        'No substitute was dispensed.  This is equivalent to the default (null) value.'),
                       ('T', 'A therapeutic substitution was dispensed.'))),
          'HL70168': ('Processing priority',
                      (('A', 'As soon as possible (a priority lower than stat)'),
                       ('B',
                        'Do at bedside or portable (may be used with other codes)'),
                       ('C',
                        'Measure continuously (e.g., arterial line blood pressure)'),
                       ('P', 'Preoperative (to be done prior to surgery)'),
                       ('R', 'Routine'),
                       ('S', 'Stat (do immediately)'),
                       ('T',
                        'Timing critical (do as near as possible to requested time)'))),
          'HL70169': ('Reporting priority',
                      (('C', 'Call back results'), ('R', 'Rush reporting'))),
          'HL70170': ('Derived specimen',
                      (('C', 'Child Observation'),
                       ('N', 'Not Applicable'),
                       ('P', 'Parent Observation'))),
          'HL70173': ('Coordination of Benefits',
                      (('CO', 'Coordination'), ('IN', 'Independent'))),
          'HL70174': ('Nature of Service/Test/Observation',
                      (('A',
                        'Atomic service/test/observation (test code or treatment code)'),
                       ('C',
                        'Single observation calculated via a rule or formula from other independent observations '
                        '(e.g., Alveolar--arterial ratio, cardiac output)'),
                       ('F',
                        'Functional procedure that may consist of one or more interrelated measures (e.g., glucose '
                        'tolerance test, creatinine clearance), usually done at different times and/or on different '
                        'specimens'),
                       ('P',
                        'Profile or battery consisting of many independent atomic observations (e.g., SMA12, '
                        'electrolytes), usually done at one instrument on one specimen'),
                       ('S',
                        'Superset--a set of batteries or procedures ordered under a single code unit but processed as '
                        'separate batteries (e.g., routines = CBC, UA, electrolytes)'))),
          'HL70175': ('Master file identifier code',
                      (('CDM', 'Charge description master file'),
                       ('CLN', 'Clinic master file'),
                       ('CMA',
                        'Clinical study with phases and scheduled master file'),
                       ('CMB',
                        'Clinical study without phases but with scheduled master file'),
                       ('INV', 'Inventory master file'),
                       ('LOC', 'Location master file'),
                       ('OMA', 'Numerical observation master file'),
                       ('OMB', 'Categorical observation master file'),
                       ('OMC', 'Observation batteries master file'),
                       ('OMD', 'Calculated observations master file'),
                       ('OME', 'Other Observation/Service Item master file'),
                       ('PRA', 'Practitioner master file'),
                       ('STF', 'Staff master file'))),
          'HL70177': ('Confidentiality code',
                      (('AID', 'AIDS patient'),
                       ('EMP', 'Employee'),
                       ('ETH', 'Alcohol/drug treatment patient'),
                       ('HIV', 'HIV(+) patient'),
                       ('PSY', 'Psychiatric patient'),
                       ('R', 'Restricted'),
                       ('U', 'Usual control'),
                       ('UWM', 'Unwed mother'),
                       ('V', 'Very restricted'),
                       ('VIP', 'Very important person or celebrity'))),
          'HL70178': ('File level event code',
                      (('REP',
                        'Replace current version of this master file with the version contained in this message'),
                       ('UPD',
                        'Change file records as defined in the record-level event codes for each record that '
                        'follows'))),
          'HL70179': ('Response level',
                      (('AL',
                        'Always.  All MFA segments (whether denoting errors or not) must be returned via the '
                        'application-level acknowledgment message'),
                       ('ER',
                        'Error/Reject conditions only.  Only MFA segments denoting errors must be returned via the '
                        'application-level acknowledgment for this message'),
                       ('NE', 'Never.  No application-level response needed'),
                       ('SU',
                        'Success.  Only MFA segments denoting success must be returned via the application-level '
                        'acknowledgment for this message'))),
          'HL70180': ('Record-level event code',
                      (('MAC', 'Reactivate deactivated record'),
                       ('MAD', 'Add record to master file'),
                       ('MDC',
                        'Deactivate: discontinue using record in master file, but do not delete from database'),
                       ('MDL', 'Delete record from master file'),
                       ('MUP', 'Update record for master file'))),
          'HL70181': ('MFN record-level error return',
                      (('S',
                        'Successful posting of the record defined by the MFE segment'),
                       ('U',
                        'Unsuccessful posting of the record defined by the MFE segment'))),
          'HL70182': ('Staff type', (('...', 'No suggested values defined'),)),
          'HL70183': ('Active/Inactive',
                      (('A', 'Active Staff'), ('I', 'Inactive Staff'))),
          'HL70184': ('Department', (('...', 'No suggested values defined'),)),
          'HL70185': ('Preferred method of contact',
                      (('B', 'Beeper Number'),
                       ('C', 'Cellular Phone Number'),
                       ('E', 'E-Mail Address (for backward compatibility)'),
                       ('F', 'FAX Number'),
                       ('H', 'Home Phone Number'),
                       ('O', 'Office Phone Number'))),
          'HL70187': ('Provider billing',
                      (('I', 'Institution bills for provider'),
                       ('P', 'Provider does own billing'))),
          'HL70189': ('Ethnic Group',
                      (('...', 'see chapter 3'),
                       ('H', 'Hispanic or Latino'),
                       ('N', 'Not Hispanic or Latino'),
                       ('U', 'Unknown'))),
          'HL70190': ('Address type',
                      (('B', 'Firm/Business'),
                       ('BA', 'Bad address'),
                       ('BDL',
                        'Birth delivery location (address where birth occurred)'),
                       ('BR', 'Residence at birth (home address at time of birth)'),
                       ('C', 'Current Or Temporary'),
                       ('F', 'Country Of Origin'),
                       ('H', 'Home'),
                       ('L', 'Legal Address'),
                       ('M', 'Mailing'),
                       ('N', 'Birth (nee) (birth address, not otherwise specified)'),
                       ('O', 'Office'),
                       ('P', 'Permanent'),
                       ('RH',
                        'Registry home. Refers to the information system, typically managed by a public health '
                        'agency, that stores patient information such as immunization histories or cancer data, '
                        'regardless of where the patient obtains services.'))),
          'HL70191': ('Type of referenced data',
                      (('AP',
                        'Other application data, typically uninterpreted binary data (HL7 V2.3 and later)'),
                       ('AU', 'Audio data (HL7 V2.3 and later)'),
                       ('FT', 'Formatted text (HL7 V2.2 only)'),
                       ('IM', 'Image data (HL7 V2.3 and later)'),
                       ('multipart', 'MIME multipart package'),
                       ('NS', 'Non-scanned image (HL7 V2.2 only)'),
                       ('SD', 'Scanned document (HL7 V2.2 only)'),
                       ('SI', 'Scanned image (HL7 V2.2 only)'),
                       ('TEXT',
                        'Machine readable text document (HL7 V2.3.1 and later)'),
                       ('TX', 'Machine readable text document (HL7 V2.2 only)'))),
          'HL70193': ('Amount class',
                      (('AT', 'Amount'),
                       ('LM', 'Limit'),
                       ('PC', 'Percentage'),
                       ('UL', 'Unlimited'))),
          'HL70200': ('Name type',
                      (('A', 'Alias Name'),
                       ('B', 'Name at Birth'),
                       ('C', 'Adopted Name'),
                       ('D', 'Display Name'),
                       ('I', 'Licensing Name'),
                       ('L', 'Legal Name'),
                       ('M', 'Maiden Name'),
                       ('N', 'Nickname /_Call me_ Name/Street Name'),
                       ('P',
                        'Name of Partner/Spouse (retained for backward compatibility only)'),
                       ('R', 'Registered Name (animals only)'),
                       ('S', 'Coded Pseudo-Name to ensure anonymity'),
                       ('T', 'Indigenous/Tribal/Community Name'),
                       ('U', 'Unspecified'))),
          'HL70201': ('Telecommunication use code',
                      (('ASN', 'Answering Service Number'),
                       ('BPN', 'Beeper Number'),
                       ('EMR', 'Emergency Number'),
                       ('NET', 'Network (email) Address'),
                       ('ORN', 'Other Residence Number'),
                       ('PRN', 'Primary Residence Number'),
                       ('VHN', 'Vacation Home Number'),
                       ('WPN', 'Work Number'))),
          'HL70202': ('Telecommunication equipment type',
                      (('BP', 'Beeper'),
                       ('CP', 'Cellular Phone'),
                       ('FX', 'Fax'),
                       ('Internet',
                        'Internet Address: Use Only If Telecommunication Use Code Is NET'),
                       ('MD', 'Modem'),
                       ('PH', 'Telephone'),
                       ('TDD', 'Telecommunications Device for the Deaf'),
                       ('TTY', 'Teletypewriter'),
                       ('X.400',
                        'X.400 email address: Use Only If Telecommunication Use Code Is NET'))),
          'HL70203': ('Identifier type',
                      (('AM', 'American Express'),
                       ('AN', 'Account number'),
                       ('ANC', 'Account number Creditor'),
                       ('AND', 'Account number debitor'),
                       ('ANON', 'Anonymous identifier'),
                       ('ANT', 'Temporary Account Number'),
                       ('APRN', 'Advanced Practice Registered Nurse number'),
                       ('BA', 'Bank Account Number'),
                       ('BC', 'Bank Card Number'),
                       ('BR', 'Birth registry number'),
                       ('BRN', 'Breed Registry Number'),
                       ('CC', 'Cost Center number'),
                       ('CY', 'County number'),
                       ('DDS', 'Dentist license number'),
                       ('DEA', 'Drug Enforcement Administration registration number'),
                       ('DFN', 'Drug Furnishing or prescriptive authority Number'),
                       ('DI', "Diner's Club card"),
                       ('DL', "Driver's license number"),
                       ('DN', 'Doctor number'),
                       ('DO', 'Osteopathic License number'),
                       ('DPM', 'Podiatrist license number'),
                       ('DR', 'Donor Registration Number'),
                       ('DS', 'Discover Card'),
                       ('EI', 'Employee number'),
                       ('EN', 'Employer number'),
                       ('FI', 'Facility ID'),
                       ('GI', 'Guarantor internal identifier'),
                       ('GL', 'General ledger number'),
                       ('GN', 'Guarantor external  identifier'),
                       ('HC', 'Health Card Number'),
                       ('IND', 'Indigenous/Aboriginal'),
                       ('JHN', 'Jurisdictional health number (Canada)'),
                       ('LI', 'Labor and industries number'),
                       ('LN', 'License number'),
                       ('LR', 'Local Registry ID'),
                       ('MA', 'Patient Medicaid number'),
                       ('MB', 'Member Number'),
                       ('MC', "Patient's Medicare number"),
                       ('MCD', 'Practitioner Medicaid number'),
                       ('MCN', 'Microchip Number'),
                       ('MCR', 'Practitioner Medicare number'),
                       ('MD', 'Medical License number'),
                       ('MI', 'Military ID number'),
                       ('MR', 'Medical record number'),
                       ('MRT', 'Temporary Medical Record Number'),
                       ('MS', 'MasterCard'),
                       ('NE', 'National employer identifier'),
                       ('NH', 'National Health Plan Identifier'),
                       ('NI', 'National unique individual identifier'),
                       ('NII', 'National Insurance Organization Identifier'),
                       ('NIIP', 'National Insurance Payor Identifier (Payor)'),
                       ('NNxxx',
                        'National Person Identifier where the xxx is the ISO table 3166 3-character (alphabetic) '
                        'country code'),
                       ('NP', 'Nurse practitioner number'),
                       ('NPI', 'National provider identifier'),
                       ('OD', 'Optometrist license number'),
                       ('PA', 'Physician Assistant number'),
                       ('PCN', 'Penitentiary/correctional institution Number'),
                       ('PE', 'Living Subject Enterprise Number'),
                       ('PEN', 'Pension Number'),
                       ('PI', 'Patient internal identifier'),
                       ('PN', 'Person number'),
                       ('PNT', 'Temporary Living Subject Number'),
                       ('PPN', 'Passport number'),
                       ('PRC', 'Permanent Resident Card Number'),
                       ('PRN', 'Provider number'),
                       ('PT', 'Patient external identifier'),
                       ('QA', 'QA number'),
                       ('RI', 'Resource identifier'),
                       ('RN', 'Registered Nurse Number'),
                       ('RPH', 'Pharmacist license number'),
                       ('RR', 'Railroad Retirement number'),
                       ('RRI', 'Regional registry ID'),
                       ('SL', 'State license'),
                       ('SN', 'Subscriber Number'),
                       ('SR', 'State registry ID'),
                       ('SS', 'Social Security number'),
                       ('TAX', 'Tax ID number'),
                       ('TN', 'Treaty Number/ (Canada)'),
                       ('U', 'Unspecified identifier'),
                       ('UPIN',
                        'Medicare/CMS (formerly HCFA)_s Universal Physician Identification numbers'),
                       ('VN', 'Visit number'),
                       ('VS', 'VISA'),
                       ('WC', 'WIC identifier'),
                       ('WCN', 'Workers_ Comp Number'),
                       ('XX', 'Organization identifier'))),
          'HL70204': ('Organizational name type',
                      (('A', 'Alias name'),
                       ('D', 'Display name'),
                       ('L', 'Legal name'),
                       ('SL', 'Stock exchange listing name'))),
          'HL70205': ('Price type',
                      (('AP', 'administrative price or handling fee'),
                       ('DC', 'direct unit cost'),
                       ('IC', 'indirect unit cost'),
                       ('PF', 'professional fee for performing provider'),
                       ('TF', 'technology fee for use of equipment'),
                       ('TP', 'total price'),
                       ('UP',
                        'unit price, may be based on length of procedure or service'))),
          'HL70206': ('Segment action code',
                      (('A', 'Add/Insert'), ('D', 'Delete'), ('U', 'Update'))),
          'HL70207': ('Processing mode',
                      (('A', 'Archive'),
                       ('I', 'Initial load'),
                       ('Not present',
                        'Not present (the default, meaning current  processing)'),
                       ('R', 'Restore from archive'),
                       ('T',
                        'Current processing, transmitted at intervals (scheduled or on demand)'))),
          'HL70208': ('Query Response Status',
                      (('AE', 'Application error'),
                       ('AR', 'Application reject'),
                       ('NF', 'No data found, no errors'),
                       ('OK', 'Data found, no errors (this is the default)'))),
          'HL70209': ('Relational operator',
                      (('CT', 'Contains'),
                       ('EQ', 'Equal'),
                       ('GE', 'Greater than or equal'),
                       ('GN', 'Generic'),
                       ('GT', 'Greater than'),
                       ('LE', 'Less than or equal'),
                       ('LT', 'Less than'),
                       ('NE', 'Not Equal'))),
          'HL70210': ('Relational conjunction', (('AND', 'Default'), ('OR', ''))),
          'HL70211': ('Alternate character sets',
                      (('8859/1',
                        'The printable characters from the ISO 8859/1 Character set'),
                       ('8859/2',
                        'The printable characters from the ISO 8859/2 Character set'),
                       ('8859/3',
                        'The printable characters from the ISO 8859/3 Character set'),
                       ('8859/4',
                        'The printable characters from the ISO 8859/4 Character set'),
                       ('8859/5',
                        'The printable characters from the ISO 8859/5 Character set'),
                       ('8859/6',
                        'The printable characters from the ISO 8859/6 Character set'),
                       ('8859/7',
                        'The printable characters from the ISO 8859/7 Character set'),
                       ('8859/8',
                        'The printable characters from the ISO 8859/8 Character set'),
                       ('8859/9',
                        'The printable characters from the ISO 8859/9 Character set'),
                       ('ASCII', 'The printable 7-bit ASCII character set.'),
                       ('BIG-5', 'Code for Taiwanese Character Set (BIG-5)'),
                       ('CNS 11643-1992',
                        'Code for Taiwanese Character Set (CNS 11643-1992)'),
                       ('GB 18030-2000',
                        'Code for Chinese Character Set (GB 18030-2000)'),
                       ('ISO IR14',
                        'Code for Information Exchange (one byte)(JIS X 0201-1976).'),
                       ('ISO IR159',
                        'Code of the supplementary Japanese Graphic Character set for information interchange '
                        '(JIS X 0212-1990).'),
                       ('ISO IR87',
                        'Code for the Japanese Graphic Character set for information interchange (JIS X 0208-1990),'),
                       ('KS X 1001', 'Code for Korean Character Set (KS X 1001)'),
                       ('UNICODE',
                        'The world wide character standard from ISO/IEC 10646-1-1993'),
                       ('UNICODE UTF-16', 'UCS Transformation Format, 16-bit form'),
                       ('UNICODE UTF-32', 'UCS Transformation Format, 32-bit form'),
                       ('UNICODE UTF-8', 'UCS Transformation Format, 8-bit form'),
                       ('8859/15',
                        'The printable characters from the ISO 8859/15 Character set'))),
          'HL70213': ('Purge Status Code',
                      (('D',
                        'The visit is marked for deletion and the user cannot enter new data against it.'),
                       ('I',
                        'The visit is marked inactive and the user cannot enter new data against it.'),
                       ('P',
                        'Marked for purge.  User is no longer able to update the visit.'))),
          'HL70214': ('Special Program Code',
                      (('CH', 'Child Health Assistance'),
                       ('ES', 'Elective Surgery Program'),
                       ('FP', 'Family Planning'),
                       ('O', 'Other'),
                       ('U', 'Unknown'))),
          'HL70215': ('Publicity Code',
                      (('F', 'Family only'),
                       ('N', 'No Publicity'),
                       ('O', 'Other'),
                       ('U', 'Unknown'))),
          'HL70216': ('Patient Status Code',
                      (('AI', 'Active Inpatient'), ('DI', 'Discharged Inpatient'))),
          'HL70217': ('Visit Priority Code',
                      (('1', 'Emergency'), ('2', 'Urgent'), ('3', 'Elective'))),
          'HL70220': ('Living Arrangement',
                      (('A', 'Alone'),
                       ('F', 'Family'),
                       ('I', 'Institution'),
                       ('R', 'Relative'),
                       ('S', 'Spouse Only'),
                       ('U', 'Unknown'))),
          'HL70223': ('Living Dependency',
                      (('C', 'Small Children Dependent'),
                       ('M', 'Medical Supervision Required'),
                       ('O', 'Other'),
                       ('S', 'Spouse Dependent'),
                       ('U', 'Unknown'))),
          'HL70224': ('Transport Arranged',
                      (('A', 'Arranged'), ('N', 'Not Arranged'), ('U', 'Unknown'))),
          'HL70225': ('Escort Required',
                      (('N', 'Not Required'), ('R', 'Required'), ('U', 'Unknown'))),
          'HL70227': ('Manufacturers of Vaccines (code=MVX)',
                      (('AB', 'Abbott Laboratories'),
                       ('AD', 'Adams Laboratories, Inc.'),
                       ('ALP', 'Alpha Therapeutic Corporation'),
                       ('AR', 'Armour'),
                       ('AVB', 'Aventis Behring L.L.C.'),
                       ('AVI', 'Aviron'),
                       ('BA', 'Baxter Healthcare Coporation]'),
                       ('BAH', 'Baxter Health Corporation'),
                       ('BAY', 'Bayer Corporation'),
                       ('BP', 'Berna Products'),
                       ('BPC', 'Berna Products Corporation'),
                       ('CEN', 'Centeon L.L.C.'),
                       ('CHI', 'Chiron Corporation'),
                       ('CMP', 'Celltech Medeva Pharmaceuticals'),
                       ('CON', 'Connaught'),
                       ('EVN', 'Evans Medical Limited'),
                       ('GRE', 'Greer Laboratories, Inc.'),
                       ('IAG', 'Immuno International AG'),
                       ('IM', 'Merieux'),
                       ('IUS', 'Immuno-U.S., Inc.'),
                       ('JPN',
                        'The Research Foundation for Microbial Diseases of Osaka University'),
                       ('KGC', 'Korea Green Cross Corporation'),
                       ('LED', 'Lederle'),
                       ('MA', 'Massachusetts Public Health Biologic Laboratories'),
                       ('MBL', 'Massachusetts Biologic Laboratories'),
                       ('MED', 'MedImmune, Inc.'),
                       ('MIL', 'Miles'),
                       ('MIP', 'Bioport Corporation'),
                       ('MSD', 'Merck & Co., Inc.'),
                       ('NAB', 'NABI'),
                       ('NAV', 'North American Vaccine, Inc.'),
                       ('NOV', 'Novartis Pharmaceutical Corporation'),
                       ('NYB', 'New York Blood Center'),
                       ('ORT', 'Ortho-Clinical Diagnostics.'),
                       ('OTC', 'Organon Teknika Corporation'),
                       ('OTH', 'Other manufacturer'),
                       ('PD', 'Parkedale Pharmaceuticals'),
                       ('PMC', 'Aventis Pasteur Inc.'),
                       ('PRX', 'Praxis Biologics'),
                       ('PWJ', 'PowerJect Pharamaceuticals'),
                       ('SCL', 'Sclavo, Inc.'),
                       ('SI', 'Swiss Serum and Vaccine Inst.'),
                       ('SKB', 'GlaxoSmithKline'),
                       ('UNK', 'Unknown manufacturer'),
                       ('USA',
                        'United States Army Medical Research and Material Command'),
                       ('WA', 'Wyeth-Ayerst'),
                       ('WAL', 'Wyeth-Ayerst'))),
          'HL70228': ('Diagnosis Classification',
                      (('C', 'Consultation'),
                       ('D', 'Diagnosis'),
                       ('I',
                        'Invasive procedure not classified elsewhere (I.V., catheter, etc.)'),
                       ('M', 'Medication (antibiotic)'),
                       ('O', 'Other'),
                       ('R', 'Radiological scheduling (not using ICDA codes)'),
                       ('S', 'Sign and symptom'),
                       ('T', 'Tissue diagnosis'))),
          'HL70229': ('DRG Payor',
                      (('C', 'Champus'),
                       ('G', 'Managed Care Organization'),
                       ('M', 'Medicare'))),
          'HL70230': ('Procedure Functional Type',
                      (('A', 'Anesthesia'),
                       ('D', 'Diagnostic procedure'),
                       ('I',
                        'Invasive procedure not classified elsewhere (e.g., IV, catheter, etc.)'),
                       ('P',
                        'Procedure for treatment (therapeutic, including operations)'))),
          'HL70231': ('Student Status',
                      (('F', 'Full-time student'),
                       ('N', 'Not a student'),
                       ('P', 'Part-time student'))),
          'HL70232': ('Insurance Company Contact Reason',
                      (('01', 'Medicare claim status'),
                       ('02', 'Medicaid claim status'),
                       ('03', 'Name/address change'))),
          'HL70234': ('Report timing',
                      (('10D', '10 day report'),
                       ('15D', '15 day report'),
                       ('30D', '30 day report'),
                       ('3D', '3 day report'),
                       ('7D', '7 day report'),
                       ('AD', 'Additional information'),
                       ('CO', 'Correction'),
                       ('DE', 'Device evaluation'),
                       ('PD', 'Periodic'),
                       ('RQ', 'Requested information'))),
          'HL70235': ('Report source',
                      (('C', 'Clinical trial'),
                       ('D', 'Database/registry/poison control center'),
                       ('E', 'Distributor'),
                       ('H', 'Health professional'),
                       ('L', 'Literature'),
                       ('M', 'Manufacturer/marketing authority holder'),
                       ('N', 'Non-healthcare professional'),
                       ('O', 'Other'),
                       ('P', 'Patient'),
                       ('R', 'Regulatory agency'))),
          'HL70236': ('Event Reported To',
                      (('D', 'Distributor'),
                       ('L', 'Local facility/user facility'),
                       ('M', 'Manufacturer'),
                       ('R', 'Regulatory agency'))),
          'HL70237': ('Event Qualification',
                      (('A', 'Abuse'),
                       ('B', 'Unexpected beneficial effect'),
                       ('D', 'Dependency'),
                       ('I', 'Interaction'),
                       ('L', 'Lack of expect therapeutic effect'),
                       ('M', 'Misuse'),
                       ('O', 'Overdose'),
                       ('W', 'Drug withdrawal'))),
          'HL70238': ('Event Seriousness',
                      (('N', 'No'), ('S', 'Significant'), ('Y', 'Yes'))),
          'HL70239': ('Event Expected', (('N', 'No'), ('U', 'Unknown'), ('Y', 'Yes'))),
          'HL70240': ('Event Consequence',
                      (('C', 'Congenital anomaly/birth defect'),
                       ('D', 'Death'),
                       ('H', 'Caused hospitalized'),
                       ('I',
                        'Incapacity which is significant, persistent or permanent'),
                       ('J',
                        'Disability which is significant, persistent or permanent'),
                       ('L', 'Life threatening'),
                       ('O', 'Other'),
                       ('P', 'Prolonged hospitalization'),
                       ('R',
                        'Required intervention to prevent permanent impairment/damage'))),
          'HL70241': ('Patient Outcome',
                      (('D', 'Died'),
                       ('F', 'Fully recovered'),
                       ('N', 'Not recovering/unchanged'),
                       ('R', 'Recovering'),
                       ('S', 'Sequelae'),
                       ('U', 'Unknown'),
                       ('W', 'Worsening'))),
          'HL70242': ("Primary Observer's Qualification",
                      (('C', 'Health care consumer/patient'),
                       ('H', 'Other health professional'),
                       ('L', 'Lawyer/attorney'),
                       ('M',
                        "Mid-level professional (nurse, nurse practitioner, physician's assistant)"),
                       ('O', 'Other non-health professional'),
                       ('P', 'Physician (osteopath, homeopath)'),
                       ('R', 'Pharmacist'))),
          'HL70243': ('Identity May Be Divulged',
                      (('N', 'No'), ('NA', 'Not applicable'), ('Y', 'Yes'))),
          'HL70247': ('Status of Evaluation',
                      (('A', 'Evaluation anticipated, but not yet begun'),
                       ('C',
                        'Product received in condition which made analysis impossible'),
                       ('D', 'Product discarded -- unable to follow up'),
                       ('I', 'Product remains implanted -- unable to follow up'),
                       ('K', 'Problem already known, no evaluation necessary'),
                       ('O', 'Other'),
                       ('P', 'Evaluation in progress'),
                       ('Q', 'Product under quarantine -- unable to follow up'),
                       ('R', 'Product under recall/corrective action'),
                       ('U', 'Product unavailable for follow up investigation'),
                       ('X', 'Product not made by company'),
                       ('Y', 'Evaluation completed'))),
          'HL70248': ('Product source',
                      (('A', 'Actual product involved in incident was evaluated'),
                       ('L',
                        'A product from the same lot as the actual product involved was evaluated'),
                       ('N',
                        'A product from a controlled/non-related inventory was evaluated'),
                       ('R', 'A product from a reserve sample was evaluated'))),
          'HL70250': ('Relatedness Assessment',
                      (('H', 'Highly probable'),
                       ('I', 'Improbable'),
                       ('M', 'Moderately probable'),
                       ('N', 'Not related'),
                       ('S', 'Somewhat probable'))),
          'HL70251': ('Action Taken in Response to the Event',
                      (('DI', 'Product dose or frequency of use increased'),
                       ('DR', 'Product dose or frequency of use reduced'),
                       ('N', 'None'),
                       ('OT', 'Other'),
                       ('WP', 'Product withdrawn permanently'),
                       ('WT', 'Product withdrawn temporarily'))),
          'HL70252': ('Causality Observations',
                      (('AW', 'Abatement of event after product withdrawn'),
                       ('BE', 'Event recurred after product reintroduced'),
                       ('DR', 'Dose response observed'),
                       ('EX', 'Alternative explanations for the event available'),
                       ('IN', 'Event occurred after product introduced'),
                       ('LI', 'Literature reports association of product with event'),
                       ('OE',
                        'Occurrence of event was confirmed by objective evidence'),
                       ('OT', 'Other'),
                       ('PL', 'Effect observed when patient receives placebo'),
                       ('SE', 'Similar events in past for this patient'),
                       ('TC',
                        'Toxic levels of product documented in blood or body fluids'))),
          'HL70253': ('Indirect exposure mechanism',
                      (('B', 'Breast milk'),
                       ('F', 'Father'),
                       ('O', 'Other'),
                       ('P', 'Transplacental'),
                       ('X', 'Blood product'))),
          'HL70254': ('Kind of quantity',
                      (('ABS', 'Absorbance'),
                       ('ACNC', 'Concentration, Arbitrary Substance'),
                       ('ACT', '*Activity'),
                       ('APER', 'Appearance'),
                       ('ARB', '*Arbitrary'),
                       ('AREA', 'Area'),
                       ('ASPECT', 'Aspect'),
                       ('CACT', '*Catalytic Activity'),
                       ('CCNT', '*Catalytic Content'),
                       ('CCRTO', 'Catalytic Concentration Ratio'),
                       ('CFR', '*Catalytic Fraction'),
                       ('CLAS', 'Class'),
                       ('CNC', '*Catalytic Concentration'),
                       ('CNST', '*Constant'),
                       ('COEF', '*Coefficient'),
                       ('COLOR', 'Color'),
                       ('CONS', 'Consistency'),
                       ('CRAT', '*Catalytic Rate'),
                       ('CRTO', 'Catalytic Ratio'),
                       ('DEN', 'Density'),
                       ('DEV', 'Device'),
                       ('DIFF', '*Difference'),
                       ('ELAS', 'Elasticity'),
                       ('ELPOT', 'Electrical Potential (Voltage)'),
                       ('ELRAT', 'Electrical current (amperage)'),
                       ('ELRES', 'Electrical Resistance'),
                       ('ENGR', 'Energy'),
                       ('ENT', '*Entitic'),
                       ('ENTCAT', '*Entitic Catalytic Activity'),
                       ('ENTNUM', '*Entitic Number'),
                       ('ENTSUB', '*Entitic Substance of Amount'),
                       ('ENTVOL', '*Entitic Volume'),
                       ('EQL', 'Equilibrium'),
                       ('FORCE', 'Mechanical force'),
                       ('FREQ', 'Frequency'),
                       ('IMP', 'Impression/ interpretation of study'),
                       ('KINV', '*Kinematic Viscosity'),
                       ('LEN', 'Length'),
                       ('LINC', '*Length Increment'),
                       ('LIQ', '*Liquefaction'),
                       ('MASS', '*Mass'),
                       ('MCNC', '*Mass Concentration'),
                       ('MCNT', 'Mass Content'),
                       ('MCRTO', '*Mass Concentration Ratio'),
                       ('MFR', '*Mass Fraction'),
                       ('MGFLUX', 'Magnetic flux'),
                       ('MINC', '*Mass Increment'),
                       ('MORPH', 'Morphology'),
                       ('MOTIL', 'Motility'),
                       ('MRAT', '*Mass Rate'),
                       ('MRTO', '*Mass Ratio'),
                       ('NCNC', '*Number Concentration'),
                       ('NCNT', '*Number Content'),
                       ('NFR', '*Number Fraction'),
                       ('NRTO', '*Number Ratio'),
                       ('NUM', '*Number'),
                       ('OD', 'Optical density'),
                       ('OSMOL', '*Osmolality'),
                       ('PRES', '*Pressure (Partial)'),
                       ('PRID', 'Presence/Identity/Existence'),
                       ('PWR', 'Power (wattage)'),
                       ('RANGE', '*Ranges'),
                       ('RATIO', '*Ratios'),
                       ('RCRLTM', '*Reciprocal Relative Time'),
                       ('RDEN', '*Relative Density'),
                       ('REL', '*Relative'),
                       ('RLMCNC', '*Relative Mass Concentration'),
                       ('RLSCNC', '*Relative Substance Concentration'),
                       ('RLTM', '*Relative Time'),
                       ('SATFR', '*Saturation Fraction'),
                       ('SCNC', '*Substance Concentration'),
                       ('SCNCIN', '*Substance Concentration Increment'),
                       ('SCNT', '*Substance Content'),
                       ('SCNTR', '*Substance Content Rate'),
                       ('SCRTO', '*Substance Concentration Ratio'),
                       ('SFR', '*Substance Fraction'),
                       ('SHAPE', 'Shape'),
                       ('SMELL', 'Smell'),
                       ('SRAT', '*Substance Rate'),
                       ('SRTO', '*Substance Ratio'),
                       ('SUB', '*Substance Amount'),
                       ('SUSC', '*Susceptibility'),
                       ('TASTE', 'Taste'),
                       ('TEMP', '*Temperature'),
                       ('TEMPDF', '*Temperature Difference'),
                       ('TEMPIN', '*Temperature Increment'),
                       ('THRMCNC', '*Threshold Mass Concentration'),
                       ('THRSCNC', '*Threshold Substance Concentration'),
                       ('TIME', '*Time (e.g. seconds)'),
                       ('TITR', '*Dilution Factor (Titer)'),
                       ('TMDF', '*Time Difference'),
                       ('TMSTP', '*Time Stamp -- Date and Time'),
                       ('TRTO', '*Time Ratio'),
                       ('TYPE', '*Type'),
                       ('VCNT', '*Volume Content'),
                       ('VEL', '*Velocity'),
                       ('VELRT', '*Velocity Ratio'),
                       ('VFR', '*Volume Fraction'),
                       ('VISC', '*Viscosity'),
                       ('VOL', '*Volume'),
                       ('VRAT', '*Volume Rate'),
                       ('VRTO', '*Volume Ratio'))),
          'HL70255': ('Duration categories',
                      (('*',
                        '(asterisk) Life of the "unit."  Used for blood products.'),
                       ('12H', '12 hours'),
                       ('1H', '1 hour'),
                       ('1L', '1 months (30 days)'),
                       ('1W', '1 week'),
                       ('24H', '24 hours'),
                       ('2.5H', u'2\xbd hours'),
                       ('2D', '2 days'),
                       ('2H', '2 hours'),
                       ('2L', '2 months'),
                       ('2W', '2 weeks'),
                       ('30M', '30 minutes'),
                       ('3D', '3 days'),
                       ('3H', '3 hours'),
                       ('3L', '3 months'),
                       ('3W', '3 weeks'),
                       ('4D', '4 days'),
                       ('4H', '4 hours'),
                       ('4W', '4 weeks'),
                       ('5D', '5 days'),
                       ('5H', '5 hours'),
                       ('6D', '6 days'),
                       ('6H', '6 hours'),
                       ('7H', '7 hours'),
                       ('8H', '8 hours'),
                       ('PT',
                        'To identify measures at a point in time.  This is a synonym for "spot" or "random" as '
                        'applied to urine measurements.'))),
          'HL70256': ('Time delay post challenge',
                      (('10D', '10 days'),
                       ('10M', '10 minutes post challenge'),
                       ('12H', '12 hours post challenge'),
                       ('15M', '15 minutes post challenge'),
                       ('1H', '1 hour post challenge'),
                       ('1L', '1 month (30 days) post challenge'),
                       ('1M', '1 minute post challenge'),
                       ('1W', '1 week'),
                       ('20M', '20 minutes post challenge'),
                       ('24H', '24 hours post challenge'),
                       ('2.5H', '2 1/2 hours post challenge'),
                       ('25M', '25 minutes post challenge'),
                       ('2D', '2 days'),
                       ('2H', '2 hours post challenge'),
                       ('2L', '2 months (60 days) post challenge'),
                       ('2M', '2 minutes post challenge'),
                       ('2W', '2 weeks'),
                       ('30M', '30 minutes post challenge'),
                       ('3D', '3 days'),
                       ('3H', '3 hours post challenge'),
                       ('3L', '3 months (90 days) post challenge'),
                       ('3M', '3 minutes post challenge'),
                       ('3W', '3 weeks'),
                       ('4D', '4 days'),
                       ('4H', '4 hours post challenge'),
                       ('4M', '4 minutes post challenge'),
                       ('4W', '4 weeks'),
                       ('5D', '5 days'),
                       ('5H', '5  hours post challenge'),
                       ('5M', '5 minutes post challenge'),
                       ('6D', '6 days'),
                       ('6H', '6 hours post challenge'),
                       ('6M', '6 minutes post challenge'),
                       ('7D', '7 days'),
                       ('7H', '7 hours post challenge'),
                       ('7M', '7 minutes post challenge'),
                       ('8H', '8 hours post challenge'),
                       ('8H SHIFT', '8 hours aligned on nursing shifts'),
                       ('8M', '8 minutes post challenge'),
                       ('9M', '9 minutes post challenge'),
                       ('BS', 'Baseline (time just before the challenge)'),
                       ('PEAK',
                        'The time post drug dose at which the highest drug level is reached (differs by drug)'),
                       ('RANDOM',
                        'Time from the challenge, or dose not specified. (random)'),
                       ('TROUGH',
                        'The time post drug dose at which the lowest drug level is reached (varies with drug)'))),
          'HL70257': ('Nature of challenge',
                      (('CFST',
                        'Fasting (no calorie intake) for the period specified in the time component of the term, '
                        'e.g., 1H POST CFST'),
                       ('EXCZ',
                        'Exercise undertaken as challenge (can be quantified)'),
                       ('FFST',
                        'No fluid intake for the period specified in the time component of the term'))),
          'HL70258': ('Relationship modifier',
                      (('BPU', 'Blood product unit'),
                       ('CONTROL', 'Control'),
                       ('DONOR', 'Donor'),
                       ('PATIENT', 'Patient'))),
          'HL70259': ('Modality',
                      (('AS', 'Angioscopy'),
                       ('BS', 'Biomagnetic imaging'),
                       ('CD', 'Color flow Doppler'),
                       ('CP', 'Colposcopy'),
                       ('CR', 'Computed radiography'),
                       ('CS', 'Cystoscopy'),
                       ('CT', 'Computed tomography'),
                       ('DD', 'Duplex Doppler'),
                       ('DG', 'Diapanography'),
                       ('DM', 'Digital microscopy'),
                       ('EC', 'Echocardiography'),
                       ('ES', 'Endoscopy'),
                       ('FA', 'Fluorescein angiography'),
                       ('FS', 'Fundoscopy'),
                       ('LP', 'Laparoscopy'),
                       ('LS', 'Laser surface scan'),
                       ('MA', 'Magnetic resonance angiography'),
                       ('MS', 'Magnetic resonance spectroscopy'),
                       ('NM', 'Nuclear Medicine (radioisotope study)'),
                       ('OT', 'Other'),
                       ('PT', 'Positron emission tomography (PET)'),
                       ('RF', 'Radio fluoroscopy'),
                       ('ST', 'Single photon emission computed tomography (SPECT)'),
                       ('TG', 'Thermography'),
                       ('US', 'Ultrasound'),
                       ('XA', 'X-ray Angiography'))),
          'HL70260': ('Patient location type',
                      (('B', 'Bed'),
                       ('C', 'Clinic'),
                       ('D', 'Department'),
                       ('E', 'Exam Room'),
                       ('L', 'Other Location'),
                       ('N', 'Nursing Unit'),
                       ('O', 'Operating Room'),
                       ('R', 'Room'))),
          'HL70261': ('Location Equipment',
                      (('EEG', 'Electro-Encephalogram'),
                       ('EKG', 'Electro-Cardiogram'),
                       ('INF', 'Infusion pump'),
                       ('IVP', 'IV pump'),
                       ('OXY', 'Oxygen'),
                       ('SUC', 'Suction'),
                       ('VEN', 'Ventilator'),
                       ('VIT', 'Vital signs monitor'))),
          'HL70262': ('Privacy Level',
                      (('F', 'Isolation'),
                       ('J', 'Private room - medically justified'),
                       ('P', 'Private room'),
                       ('Q', 'Private room - due to overflow'),
                       ('S', 'Semi-private room'),
                       ('W', 'Ward'))),
          'HL70263': ('Level of Care',
                      (('A', 'Ambulatory'),
                       ('C', 'Critical care'),
                       ('E', 'Emergency'),
                       ('F', 'Isolation'),
                       ('N', 'Intensive care'),
                       ('R', 'Routine'),
                       ('S', 'Surgery'))),
          'HL70265': ('Specialty Type',
                      (('ALC', 'Allergy'),
                       ('AMB', 'Ambulatory'),
                       ('CAN', 'Cancer'),
                       ('CAR', 'Coronary/cardiac care'),
                       ('CCR', 'Critical care'),
                       ('CHI', 'Chiropractic'),
                       ('EDI', 'Education'),
                       ('EMR', 'Emergency'),
                       ('FPC', 'Family planning'),
                       ('INT', 'Intensive care'),
                       ('ISO', 'Isolation'),
                       ('NAT', 'Naturopathic'),
                       ('NBI', 'Newborn, nursery, infants'),
                       ('OBG', 'Obstetrics, gynecology'),
                       ('OBS', 'Observation'),
                       ('OTH', 'Other specialty'),
                       ('PED', 'Pediatrics'),
                       ('PHY', 'General/family practice'),
                       ('PIN', 'Pediatric/neonatal intensive care'),
                       ('PPS', 'Pediatric psychiatric'),
                       ('PRE', 'Pediatric rehabilitation'),
                       ('PSI', 'Psychiatric intensive care'),
                       ('PSY', 'Psychiatric'),
                       ('REH', 'Rehabilitation'),
                       ('SUR', 'Surgery'),
                       ('WIC', 'Walk-in clinic'))),
          'HL70267': ('Days of the week',
                      (('FRI', 'Friday'),
                       ('MON', 'Monday'),
                       ('SAT', 'Saturday'),
                       ('SUN', 'Sunday'),
                       ('THU', 'Thursday'),
                       ('TUE', 'Tuesday'),
                       ('WED', 'Wednesday'))),
          'HL70268': ('Override',
                      (('A', 'Override allowed'),
                       ('R', 'Override required'),
                       ('X', 'Override not allowed'))),
          'HL70269': ('Charge On Indicator',
                      (('O', 'Charge on Order'), ('R', 'Charge on Result'))),
          'HL70270': ('Document Type',
                      (('AR', 'Autopsy report'),
                       ('CD', 'Cardiodiagnostics'),
                       ('CN', 'Consultation'),
                       ('DI', 'Diagnostic imaging'),
                       ('DS', 'Discharge summary'),
                       ('ED', 'Emergency department report'),
                       ('HP', 'History and physical examination'),
                       ('OP', 'Operative report'),
                       ('PC', 'Psychiatric consultation'),
                       ('PH', 'Psychiatric history and physical examination'),
                       ('PN', 'Procedure note'),
                       ('PR', 'Progress note'),
                       ('SP', 'Surgical pathology'),
                       ('TS', 'Transfer summary'))),
          'HL70271': ('Document completion status',
                      (('AU', 'Authenticated'),
                       ('DI', 'Dictated'),
                       ('DO', 'Documented'),
                       ('IN', 'Incomplete'),
                       ('IP', 'In Progress'),
                       ('LA', 'Legally authenticated'),
                       ('PA', 'Pre-authenticated'))),
          'HL70272': ('Document Confidentiality Status',
                      (('R', 'Restricted'),
                       ('U', 'Usual control'),
                       ('V', 'Very restricted'))),
          'HL70273': ('Document Availability Status',
                      (('AV', 'Available for patient care'),
                       ('CA', 'Deleted'),
                       ('OB', 'Obsolete'),
                       ('UN', 'Unavailable for patient care'))),
          'HL70275': ('Document Storage Status',
                      (('AA', 'Active and archived'),
                       ('AC', 'Active'),
                       ('AR', 'Archived (not active)'),
                       ('PU', 'Purged'))),
          'HL70276': ('Appointment reason codes',
                      (('CHECKUP', 'A routine check-up, such as an annual physical'),
                       ('EMERGENCY', 'Emergency appointment'),
                       ('FOLLOWUP', 'A follow up visit from a previous appointment'),
                       ('ROUTINE', 'Routine appointment - default if not valued'),
                       ('WALKIN', 'A previously unscheduled walk-in visit'))),
          'HL70277': ('Appointment Type Codes',
                      (('Complete',
                        'A request to add a completed appointment, used to maintain records of completed '
                        'appointments that did not appear in the schedule (e.g., STAT, walk-in, etc.)'),
                       ('Normal',
                        'Routine schedule request type - default if not valued'),
                       ('Tentative',
                        'A request for a tentative (e.g., "penciled in") appointment'))),
          'HL70278': ('Filler status codes',
                      (('Blocked', 'The indicated time slot(s) is(are) blocked'),
                       ('Booked', 'The indicated appointment is booked'),
                       ('Cancelled',
                        'The indicated appointment was stopped from occurring (canceled prior to starting)'),
                       ('Complete',
                        'The indicated appointment has completed normally (was not discontinued, canceled, or '
                        'deleted)'),
                       ('Dc',
                        "The indicated appointment was discontinued (DC'ed while in progress, discontinued parent "
                        "appointment, or discontinued child appointment)"),
                       ('Deleted',
                        'The indicated appointment was deleted from the filler application'),
                       ('Noshow', 'The patient did not show up for the appointment'),
                       ('Overbook',
                        'The appointment has been confirmed; however it is confirmed in an overbooked state'),
                       ('Pending', 'Appointment has not yet been confirmed'),
                       ('Started',
                        'The indicated appointment has begun and is currently in progress'),
                       ('Waitlist',
                        'Appointment has been placed on a waiting list for a particular slot, or set of slots'))),
          'HL70279': ('Allow Substitution Codes',
                      (('Confirm',
                        'Contact the Placer Contact Person prior to making any substitutions of this resource'),
                       ('No', 'Substitution of this resource is not allowed'),
                       ('Notify',
                        'Notify the Placer Contact Person, through normal institutional procedures, that a '
                        'substitution of this resource has been made'),
                       ('Yes', 'Substitution of this resource is allowed'))),
          'HL70280': ('Referral priority',
                      (('A', 'ASAP'), ('R', 'Routine'), ('S', 'STAT'))),
          'HL70281': ('Referral type',
                      (('Hom', 'Home Care'),
                       ('Lab', 'Laboratory'),
                       ('Med', 'Medical'),
                       ('Psy', 'Psychiatric'),
                       ('Rad', 'Radiology'),
                       ('Skn', 'Skilled Nursing'))),
          'HL70282': ('Referral disposition',
                      (('AM', 'Assume Management'),
                       ('RP', 'Return Patient After Evaluation'),
                       ('SO', 'Second Opinion'),
                       ('WR', 'Send Written Report'))),
          'HL70283': ('Referral status',
                      (('A', 'Accepted'),
                       ('E', 'Expired'),
                       ('P', 'Pending'),
                       ('R', 'Rejected'))),
          'HL70284': ('Referral category',
                      (('A', 'Ambulatory'),
                       ('E', 'Emergency'),
                       ('I', 'Inpatient'),
                       ('O', 'Outpatient'))),
          'HL70286': ('Provider role',
                      (('CP', 'Consulting Provider'),
                       ('PP', 'Primary Care Provider'),
                       ('RP', 'Referring Provider'),
                       ('RT', 'Referred to Provider'))),
          'HL70287': ('Problem/goal action code',
                      (('AD', 'ADD'),
                       ('CO', 'CORRECT'),
                       ('DE', 'DELETE'),
                       ('LI', 'LINK'),
                       ('UC', 'UNCHANGED *'),
                       ('UN', 'UNLINK'),
                       ('UP', 'UPDATE'))),
          'HL70291': ('Subtype of referenced data',
                      (('BASIC', 'ISDN PCM audio data'),
                       ('DICOM', 'Digital Imaging and Communications in Medicine'),
                       ('FAX', 'Facsimile data'),
                       ('GIF', 'Graphics Interchange Format'),
                       ('HTML', 'Hypertext Markup Language'),
                       ('JOT', 'Electronic ink data (Jot 1.0 standard)'),
                       ('JPEG', 'Joint Photographic Experts Group'),
                       ('Octet-stream', 'Uninterpreted binary data'),
                       ('PICT', 'PICT format image data'),
                       ('PostScript', 'PostScript program'),
                       ('RTF', 'Rich Text Format'),
                       ('SGML',
                        'Standard Generalized Markup Language (HL7 V2.3.1 and later)'),
                       ('TIFF', 'TIFF image data'),
                       ('x-hl7-cda-level-one',
                        'HL7 Clinical Document Architecture Level One document'),
                       ('XML', 'Extensible Markup Language (HL7 V2.3.1 and later)'))),
          'HL70292': ('Vaccines administered (code = CVX)(parenteral, unless oral is noted)',
                      (('01', 'DTP'),
                       ('02', 'OPV'),
                       ('03', 'MMR'),
                       ('04', 'M/R'),
                       ('05', 'measles'),
                       ('06', 'rubella'),
                       ('07', 'mumps'),
                       ('08', 'Hep B, adolescent or pediatric'),
                       ('09', 'Td (adult)'),
                       ('10', 'IPV'),
                       ('100', 'pneumococcal conjugate'),
                       ('101', 'typhoid, ViCPs'),
                       ('102', 'DTP-Hib-Hep B'),
                       ('103', 'meningococcal C conjugate'),
                       ('104', 'Hep A-Hep B'),
                       ('105', 'smallpox, diluted'),
                       ('106', 'DTaP, 5 pertussis antigens'),
                       ('107', 'DTaP, NOS'),
                       ('108', 'meningococcal, NOS'),
                       ('109', 'pneumococcal, NOS'),
                       ('11', 'pertussis'),
                       ('12', 'diphtheria antitoxin'),
                       ('13', 'TIG'),
                       ('14', 'IG, NOS'),
                       ('15', 'influenza, split (incl. purified surface antigen)'),
                       ('16', 'influenza, whole'),
                       ('17', 'Hib, NOS'),
                       ('18', 'rabies, intramuscular injection'),
                       ('19', 'BCG'),
                       ('20', 'DTaP'),
                       ('21', 'Varicella'),
                       ('22', 'DTP-Hib'),
                       ('23', 'plague'),
                       ('24', 'anthrax'),
                       ('25', 'typhoid, oral'),
                       ('26', 'cholera'),
                       ('27', 'botulinum antitoxin'),
                       ('28', 'DT (pediatric)'),
                       ('29', 'CMVIG'),
                       ('30', 'HBIG'),
                       ('31', 'Hep A, pediatric, NOS'),
                       ('32', 'meningococcal'),
                       ('33', 'pneumococcal'),
                       ('34', 'RIG'),
                       ('35', 'tetanus toxoid'),
                       ('36', 'VZIG'),
                       ('37', 'yellow fever'),
                       ('38', 'rubella/mumps'),
                       ('39', 'Japanese encephalitis'),
                       ('40', 'rabies, intradermal injection'),
                       ('41', 'typhoid, parenteral'),
                       ('42', 'Hep B, adolescent/high risk infant2'),
                       ('43', 'Hep B, adult4'),
                       ('44', 'Hep B, dialysis'),
                       ('45', 'Hep B, NOS'),
                       ('46', 'Hib (PRP-D)'),
                       ('47', 'Hib (HbOC)'),
                       ('48', 'Hib (PRP-T)'),
                       ('49', 'Hib (PRP-OMP)'),
                       ('50', u'DTaP-Hib\xa0'),
                       ('51', 'Hib-Hep B'),
                       ('52', 'Hep A, adult'),
                       ('53', 'typhoid, parenteral, AKD (U.S. military)'),
                       ('54', 'adenovirus, type 4'),
                       ('55', 'adenovirus, type 7'),
                       ('56', 'dengue fever'),
                       ('57', 'hantavirus'),
                       ('58', 'Hep C'),
                       ('59', 'Hep E'),
                       ('60', 'herpes simplex 2'),
                       ('61', 'HIV'),
                       ('62', 'HPV'),
                       ('63', 'Junin virus'),
                       ('64', 'leishmaniasis'),
                       ('65', 'leprosy'),
                       ('66', 'Lyme disease'),
                       ('67', 'malaria'),
                       ('68', 'melanoma'),
                       ('69', 'parainfluenza-3'),
                       ('70', 'Q fever'),
                       ('71', u'RSV-IGIV\xa0'),
                       ('72', 'rheumatic fever'),
                       ('73', 'Rift Valley fever'),
                       ('74', 'rotavirus'),
                       ('75', 'smallpox'),
                       ('76', 'Staphylococcus bacterio lysate'),
                       ('77', 'tick-borne encephalitis'),
                       ('78', 'tularemia vaccine'),
                       ('79', 'vaccinia immune globulin'),
                       ('80', 'VEE, live'),
                       ('81', 'VEE, inactivated'),
                       ('82', 'adenovirus, NOS1'),
                       ('83', 'Hep A, ped/adol, 2 dose'),
                       ('84', 'Hep A, ped/adol, 3 dose'),
                       ('85', 'Hep A, NOS'),
                       ('86', 'IG'),
                       ('87', 'IGIV'),
                       ('88', 'influenza, NOS'),
                       ('89', 'polio, NOS'),
                       ('90', 'rabies, NOS'),
                       ('91', 'typhoid, NOS'),
                       ('92', 'VEE, NOS'),
                       ('93', 'RSV-MAb'),
                       ('94', 'MMRV'),
                       ('95', 'TST-OT tine test'),
                       ('96', 'TST-PPD intradermal'),
                       ('97', 'TST-PPD tine test'),
                       ('98', 'TST, NOS'),
                       ('99', 'RESERVED _ do not use'),
                       ('998', 'no vaccine administered'),
                       ('999', 'Unknown'))),
          'HL70294': ('Time selection criteria parameter class codes',
                      (('Fri',
                        'An indicator that Friday is or is not preferred for the day on which the appointment will '
                        'occur.'),
                       ('Mon',
                        'An indicator that Monday is or is not preferred for the day on which the appointment will '
                        'occur.'),
                       ('Prefend',
                        'An indicator that there is a preferred end time for the appointment request, service or '
                        'resource.'),
                       ('Prefstart',
                        'An indicator that there is a preferred start time for the appointment request, service or '
                        'resource.'),
                       ('Sat',
                        'An indicator that Saturday is or is not preferred for the day on which the appointment will '
                        'occur.'),
                       ('Sun',
                        'An indicator that Sunday is or is not preferred for the day on which the appointment will '
                        'occur.'),
                       ('Thu',
                        'An indicator that Thursday is or is not preferred for the day on which the appointment will '
                        'occur.'),
                       ('Tue',
                        'An indicator that Tuesday is or is not preferred for the day on which the appointment will '
                        'occur.'),
                       ('Wed',
                        'An indicator that Wednesday is or is not preferred for the day on which the appointment will '
                        'occur.'))),
          'HL70298': ('CP range type',
                      (('F',
                        'Flat-rate. Apply the entire price to this interval, do not pro-rate the price if the full '
                        'interval has not occurred/been consumed'),
                       ('P',
                        'Pro-rate. Apply this price to this interval, pro-rated by whatever portion of the interval '
                        'has occurred/been consumed'))),
          'HL70299': ('Encoding',
                      (('A', 'No encoding - data are displayable ASCII characters.'),
                       ('Base64',
                        'Encoding as defined by MIME (Multipurpose Internet Mail Extensions) standard RFC 1521. Four '
                        'consecutive ASCII characters represent three consecutive octets of binary data. Base64 '
                        'utilizes a 65-character subset of US-ASCII, consisting of both the upper and'),
                       ('Hex',
                        'Hexadecimal encoding - consecutive pairs of hexadecimal digits represent consecutive single '
                        'octets.'))),
          'HL70301': ('Universal ID type',
                      (('DNS',
                        'An Internet dotted name. Either in ASCII or as integers'),
                       ('GUID', 'Same as UUID.'),
                       ('HCD',
                        'The CEN Healthcare Coding Scheme Designator. (Identifiers used in DICOM follow this '
                        'assignment scheme.)'),
                       ('HL7', 'Reserved for future HL7 registration schemes'),
                       ('ISO',
                        'An International Standards Organization Object Identifier'),
                       ('L,M,N',
                        'These are reserved for locally defined coding schemes.'),
                       ('Random', 'Usually a base64 encoded string of random bits.'),
                       ('URI', 'Uniform Resource Identifier'),
                       ('UUID', 'The DCE Universal Unique Identifier'),
                       ('x400', 'An X.400 MHS format identifier'),
                       ('x500', 'An X.500 directory name'))),
          'HL70305': ('Person location type',
                      (('C', 'Clinic'),
                       ('D', 'Department'),
                       ('H', 'Home'),
                       ('N', 'Nursing Unit'),
                       ('O', 'Provider_s Office'),
                       ('P', 'Phone'),
                       ('S', 'SNF'))),
          'HL70309': ('Coverage Type',
                      (('B', 'Both hospital and physician'),
                       ('H', 'Hospital/institutional'),
                       ('P', 'Physician/professional'))),
          'HL70311': ('Job Status',
                      (('O', 'Other'),
                       ('P', 'Permanent'),
                       ('T', 'Temporary'),
                       ('U', 'Unknown'))),
          'HL70315': ('Living Will Code',
                      (('F', 'Yes, patient has a living will but it is not on file'),
                       ('I',
                        'No, patient does not have a living will but information was provided'),
                       ('N',
                        'No, patient does not have a living will and no information was provided'),
                       ('U', 'Unknown'),
                       ('Y', 'Yes, patient has a living will'))),
          'HL70316': ('Organ Donor Code',
                      (('F',
                        'Yes, patient is a documented donor, but documentation is not on file'),
                       ('I',
                        'No, patient is not a documented donor, but information was provided'),
                       ('N', 'No, patient has not agreed to be a donor'),
                       ('P',
                        'Patient leaves organ donation decision to a specific person'),
                       ('R', 'Patient leaves organ donation decision to relatives'),
                       ('U', 'Unknown'),
                       ('Y',
                        'Yes, patient is a documented donor and documentation is on file'))),
          'HL70317': ('Annotations',
                      (('9900', 'Pace spike'),
                       ('9901', 'SAS marker'),
                       ('9902', 'Sense marker'),
                       ('9903', 'Beat marker'),
                       ('9904', 'etc.'))),
          'HL70321': ('Dispense Method',
                      (('AD', 'Automatic Dispensing'),
                       ('F', 'Floor Stock'),
                       ('TR', 'Traditional'),
                       ('UD', 'Unit Dose'))),
          'HL70322': ('Completion Status for valid values.',
                      (('CP', 'Complete'),
                       ('NA', 'Not Administered'),
                       ('PA', 'Partially Administered'),
                       ('RE', 'Refused'))),
          'HL70323': ('Action Code',
                      (('A', 'Add/Insert'),
                       ('D', 'Delete'),
                       ('U', 'Update'),
                       ('X', 'No change'))),
          'HL70324': ('Location characteristic ID',
                      (('GEN', 'Gender of patient(s)'),
                       ('IMP', 'Implant: can be used for radiation implant patients'),
                       ('INF',
                        'Infectious disease: this location can be used for isolation'),
                       ('LCR', 'Level of care'),
                       ('LIC', 'Licensed'),
                       ('OVR', 'Overflow'),
                       ('PRL',
                        'Privacy level: indicating the level of private versus non-private room'),
                       ('SET', 'Bed is set up'),
                       ('SHA',
                        'Shadow: a temporary holding location that does not physically exist'),
                       ('SMK', 'Smoking'),
                       ('STF', 'Bed is staffed'),
                       ('TEA', 'Teaching location'))),
          'HL70325': ('Location Relationship ID',
                      (('ALI', 'Location Alias(es)'),
                       ('DTY', 'Nearest  dietary location'),
                       ('LAB', 'Nearest  lab'),
                       ('LB2', 'Second nearest lab'),
                       ('PAR', 'Parent location'),
                       ('RX', 'Nearest  pharmacy'),
                       ('RX2', 'Second nearest pharmacy'))),
          'HL70326': ('Visit Indicator',
                      (('A', 'Account level (default)'), ('V', 'Visit level'))),
          'HL70329': ('Quantity method',
                      (('A', 'Actual count'), ('E', 'Estimated (see comment)'))),
          'HL70330': ('Marketing basis',
                      (('510E', '510 (K) exempt'),
                       ('510K', '510 (K)'),
                       ('522S', 'Post marketing study (522)'),
                       ('PMA', 'Premarketing authorization'),
                       ('PRE', 'Preamendment'),
                       ('TXN', 'Transitional'))),
          'HL70331': ('Facility type',
                      (('A', 'Agent for a foreign manufacturer'),
                       ('D', 'Distributor'),
                       ('M', 'Manufacturer'),
                       ('U', 'User'))),
          'HL70332': ('Source type', (('A', 'Accept'), ('I', 'Initiate'))),
          'HL70334': ('Disabled Person Code',
                      (('AP', 'Associated party'),
                       ('GT', 'Guarantor'),
                       ('IN', 'Insured'),
                       ('PT', 'Patient'))),
          'HL70335': ('Repeat pattern',
                      (('A', 'Ante (before)'),
                       ('BID', 'twice a day at institution-specified times'),
                       ('C',
                        'service is provided continuously between start time and stop time'),
                       ('D', 'Cibus Diurnus (lunch)'),
                       ('I', 'Inter'),
                       ('M', 'Cibus Matutinus (breakfast)'),
                       ('Meal Related Timings', '<timing>C (_cum_)<meal>'),
                       ('Once', 'one time only.'),
                       ('P', 'Post (after)'),
                       ('PRN', 'given as needed'),
                       ('PRNxxx', 'where xxx is some frequency code'),
                       ('QAM', 'in the morning at institution-specified time'),
                       ('QHS', 'every day before the hour of sleep'),
                       ('QID', 'four times a day at institution-specified times'),
                       ('Q<integer>D', 'every <integer> days'),
                       ('Q<integer>H', 'every <integer> hours'),
                       ('Q<integer>J<day#>',
                        'repeats on a particular day of the week,'),
                       ('Q<integer>L', 'every <integer> months (Lunar cycle)'),
                       ('Q<integer>M', 'every <integer> minutes'),
                       ('Q<integer>S', 'every <integer> seconds'),
                       ('Q<integer>W', 'every <integer> weeks'),
                       ('QOD', 'every other day'),
                       ('QPM', 'in the evening at institution-specified time'),
                       ('QSHIFT',
                        'during each of three eight-hour shifts at institution-specified times'),
                       ('TID', 'three times a day at institution-specified times'),
                       ('U <spec>',
                        'for future use, where <spec> is an interval specification as defined by the UNIX cron '
                        'specification.'),
                       ('V', 'Cibus Vespertinus (dinner)'),
                       ('xID',
                        '_X_ times per day at institution-specified times, where X is a numeral 5 or greater.'))),
          'HL70336': ('Referral reason',
                      (('O', 'Provider Ordered'),
                       ('P', 'Patient Preference'),
                       ('S', 'Second Opinion'),
                       ('W', 'Work Load'))),
          'HL70337': ('Certification status', (('C', 'Certified'), ('E', 'Eligible'))),
          'HL70338': ('Practitioner ID number type',
                      (('CY', 'County number'),
                       ('DEA', 'Drug Enforcement Agency no.'),
                       ('GL', 'General ledger number'),
                       ('LI', 'Labor and industries number'),
                       ('L&I', 'Labor and industries number'),
                       ('MCD', 'Medicaid number'),
                       ('MCR', 'Medicare number'),
                       ('QA', 'QA number'),
                       ('SL', 'State license number'),
                       ('TAX', 'Tax ID number'),
                       ('TRL', 'Training license number'),
                       ('UPIN', 'Unique physician ID no.'))),
          'HL70339': ('Advanced Beneficiary Notice Code',
                      (('1', 'Service is subject to medical necessity procedures'),
                       ('2',
                        'Patient has been informed of responsibility, and agrees to pay for service'),
                       ('3',
                        'Patient has been informed of responsibility, and asks that the payer be billed'),
                       ('4', 'Advanced Beneficiary Notice has not been signed'))),
          'HL70344': ('Patient_s Relationship to Insured',
                      (('01', 'Patient is insured'),
                       ('02', 'Spouse'),
                       ('03', 'Natural child/insured financial responsibility'),
                       ('04',
                        'Natural child/Insured does not have financial responsibility'),
                       ('05', 'Step child'),
                       ('06', 'Foster child'),
                       ('07', 'Ward of the court'),
                       ('08', 'Employee'),
                       ('09', 'Unknown'),
                       ('10', 'Handicapped dependent'),
                       ('11', 'Organ donor'),
                       ('12', 'Cadaver donor'),
                       ('13', 'Grandchild'),
                       ('14', 'Niece/nephew'),
                       ('15', 'Injured plaintiff'),
                       ('16', 'Sponsored dependent'),
                       ('17', 'Minor dependent of a minor dependent'),
                       ('18', 'Parent'),
                       ('19', 'Grandparent'))),
          'HL70347': ('State/province',
                      (('AB', 'Alberta  (US and Canada)'), ('MI', 'Michigan  (US)'))),
          'HL70353': ('CWE statuses',
                      (('NA', 'Not applicable'),
                       ('NASK', 'Not asked'),
                       ('NAV', 'Not available'),
                       ('U', 'Unknown'),
                       ('UASK', 'Asked but Unknown'))),
          'HL70354': ('Message structure',
                      (('ACK', 'Varies'),
                       ('ADR_A19', 'A19'),
                       ('ADT_A01', 'A01, A04, A08, A13'),
                       ('ADT_A02', 'A02'),
                       ('ADT_A03', 'A03'),
                       ('ADT_A05', 'A05, A14, A28, A31'),
                       ('ADT_A06', 'A06, A07'),
                       ('ADT_A09', 'A09, A10, A11, A12'),
                       ('ADT_A15', 'A15'),
                       ('ADT_A16', 'A16'),
                       ('ADT_A17', 'A17'),
                       ('ADT_A18', 'A18'),
                       ('ADT_A20', 'A20'),
                       ('ADT_A21', 'A21, A22, A23, A25, A26, A27, A29, A32, A33'),
                       ('ADT_A24', 'A24'),
                       ('ADT_A30', 'A30, A34, A35, A36, A46, A47, A48, A49'),
                       ('ADT_A37', 'A37'),
                       ('ADT_A38', 'A38'),
                       ('ADT_A39', 'A39, A40, A41, A42'),
                       ('ADT_A43', 'A43, A44'),
                       ('ADT_A45', 'A45'),
                       ('ADT_A50', 'A50, A51'),
                       ('ADT_A52', 'A52, A53, A55'),
                       ('ADT_A54', 'A54'),
                       ('ADT_A60', 'A60'),
                       ('ADT_A61', 'A61, A62'),
                       ('BAR_P01', 'P01'),
                       ('BAR_P02', 'P02'),
                       ('BAR_P05', 'P05'),
                       ('BAR_P06', 'P06'),
                       ('BAR_P10', 'P10'),
                       ('BAR_P12', 'P12'),
                       ('BPS_O29', 'O29'),
                       ('BRP_030', 'O30'),
                       ('BRT_O32', 'O32'),
                       ('BTS_O31', 'O31'),
                       ('CRM_C01', 'C01, C02, C03, C04, C05, C06, C07, C08'),
                       ('CSU_C09', 'C09, C10, C11, C12'),
                       ('DFT_P03', 'P03'),
                       ('DFT_P11', 'P11'),
                       ('DOC_T12', 'T12'),
                       ('DSR_P04', 'P04'),
                       ('DSR_Q01', 'Q01'),
                       ('DSR_Q03', 'Q03'),
                       ('EAC_U07', 'U07'),
                       ('EAN_U09', 'U09'),
                       ('EAR_U08', 'U08'),
                       ('EDR_R07', 'R07'),
                       ('EQQ_Q04', 'Q04'),
                       ('ERP_R09', 'R09'),
                       ('ESR_U02', 'U02'),
                       ('ESU_U01', 'U01'),
                       ('INR_U06', 'U06'),
                       ('INU_U05', 'U05'),
                       ('LSU_U12', 'U12, U13'),
                       ('MDM_T01', 'T01, T03, T05, T07, T09, T11'),
                       ('MDM_T02', 'T02, T04, T06, T08, T10'),
                       ('MFD_MFA', 'MFA'),
                       ('MFK_M01',
                        'M01, M02, M03, M04, M05, M06, M07, M08, M09, M10, M11'),
                       ('MFN_M01', 'M01'),
                       ('MFN_M02', 'M02'),
                       ('MFN_M03', 'M03'),
                       ('MFN_M04', 'M04'),
                       ('MFN_M05', 'M05'),
                       ('MFN_M06', 'M06'),
                       ('MFN_M07', 'M07'),
                       ('MFN_M08', 'M08'),
                       ('MFN_M09', 'M09'),
                       ('MFN_M10', 'M10'),
                       ('MFN_M11', 'M11'),
                       ('MFN_M12', 'M12'),
                       ('MFN_M13', 'M13'),
                       ('MFN_M15', 'M15'),
                       ('MFQ_M01', 'M01, M02, M03, M04, M05, M06'),
                       ('MFR_M01', 'M01, M02, M03, M04, M05, M06'),
                       ('NMD_N02', 'N02'),
                       ('NMQ_N01', 'N01'),
                       ('NMR_N01', 'N01'),
                       ('OMB_O27', 'O27'),
                       ('OMD_O03', 'O03'),
                       ('OMG_O19', 'O19'),
                       ('OMI_O23', 'O23'),
                       ('OML_O21', 'O21'),
                       ('OML_O33', 'O33'),
                       ('OML_O35', 'O35'),
                       ('OMN_O07', '007'),
                       ('OMP_O09', 'O09'),
                       ('OMS_O05', 'O05'),
                       ('ORB_O28', 'O28'),
                       ('ORD_O04', 'O04'),
                       ('ORF_R04', 'R04'),
                       ('ORG_O20', 'O20'),
                       ('ORI_O24', 'O24'),
                       ('ORL_O22', '022'),
                       ('ORL_O34', 'O34'),
                       ('ORL_O36', 'O36'),
                       ('ORM_O01', 'O01'),
                       ('ORN_O08', 'O08'),
                       ('ORP_O10', 'O10'),
                       ('ORR_O02', 'O02'),
                       ('ORS_O06', 'O06'),
                       ('ORU_R01', 'R01'),
                       ('ORU_R30', 'R30'),
                       ('ORU_R31', 'R31'),
                       ('ORU_R32', 'R32'),
                       ('ORU_W01', 'W01'),
                       ('OSQ_Q06', 'Q06'),
                       ('OSR_Q06', 'Q06'),
                       ('OUL_R21', 'R21'),
                       ('OUL_R22', 'R22'),
                       ('OUL_R23', 'R23'),
                       ('OUL_R24', 'R24'),
                       ('PEX_P07', 'P07, P08'),
                       ('PGL_PC6', 'PC6, PC7, PC8'),
                       ('PMU_B01', 'B01, B02'),
                       ('PMU_B03', 'B03'),
                       ('PMU_B04', 'B04, B05, B06'),
                       ('PMU_B07', 'B07'),
                       ('PMU_B08', 'B08'),
                       ('PPG_PCG', 'PCC, PCG, PCH, PCJ'),
                       ('PPP_PCB', 'PCB, PCD'),
                       ('PPR_PC1', 'PC1, PC2, PC3'),
                       ('PPT_PCL', 'PCL'),
                       ('PPV_PCA', 'PCA'),
                       ('PRR_PC5', 'PC5'),
                       ('PTR_PCF', 'PCF'),
                       ('QBP_Q11', 'Q11'),
                       ('QBP_Q13', 'Q13'),
                       ('QBP_Q15', 'Q15'),
                       ('QBP_Q21', 'Q21, Q22, Q23,Q24, Q25'),
                       ('QCK_Q02', 'Q02'),
                       ('QCN_J01', 'J01, J02'),
                       ('QRF_W02', 'W02'),
                       ('QRY_A19', 'A19'),
                       ('QRY_P04', 'P04'),
                       ('QRY_PC4', 'PC4, PC9, PCE, PCK'),
                       ('QRY_Q01', 'Q01, Q26, Q27, Q28, Q29, Q30'),
                       ('QRY_Q02', 'Q02'),
                       ('QRY_R02', 'R02'),
                       ('QRY_T12', 'T12'),
                       ('QSB_Q16', 'Q16'),
                       ('QVR_Q17', 'Q17'),
                       ('RAR_RAR', 'RAR'),
                       ('RAS_O17', 'O17'),
                       ('RCI_I05', 'I05'),
                       ('RCL_I06', 'I06'),
                       ('RDE_O01', 'O01'),
                       ('RDE_O11', 'O11, O25'),
                       ('RDR_RDR', 'RDR'),
                       ('RDS_O13', 'O13'),
                       ('RDY_K15', 'K15'),
                       ('REF_I12', 'I12, I13, I14, I15'),
                       ('RER_RER', 'RER'),
                       ('RGR_RGR', 'RGR'),
                       ('RGV_O15', 'O15'),
                       ('ROR_ROR', 'ROR'),
                       ('RPA_I08', 'I08, I09. I10, I11'),
                       ('RPI_I01', 'I01, I04'),
                       ('RPL_I02', 'I02'),
                       ('RPR_I03', 'I03'),
                       ('RQA_I08', 'I08, I09, I10, I11'),
                       ('RQC_I05', 'I05, I06'),
                       ('RQI_I01', 'I01, I02, I03, I07'),
                       ('RQP_I04', 'I04'),
                       ('RQQ_Q09', 'Q09'),
                       ('RRA_O02', 'O02'),
                       ('RRA_O18', 'O18'),
                       ('RRD_O14', 'O14'),
                       ('RRE_O12', 'O12, O26'),
                       ('RRG_O16', 'O16'),
                       ('RRI_I12', 'I12, I13, I14, I15'),
                       ('RSP_K11', 'K11'),
                       ('RSP_K21', 'K21'),
                       ('RSP_K22', 'K22'),
                       ('RSP_K23', 'K23, K24'),
                       ('RTB_K13', 'K13'),
                       ('SIU_S12',
                        'S12, S13, S14, S15, S16, S17, S18, S19, S20, S21, S22, S23, S24, S26'),
                       ('SPQ_Q08', 'Q08'),
                       ('SQM_S25', 'S25'),
                       ('SQR_S25', 'S25'),
                       ('SRM_S01',
                        'S01, S02, S03, S04, S05, S06, S07, S08, S09, S10, S11'),
                       ('SRR_S01',
                        'S01, S02, S03, S04, S05, S06, S07, S08, S09, S10, S11'),
                       ('SSR_U04', 'U04'),
                       ('SSU_U03', 'U03'),
                       ('SUR_P09', 'P09'),
                       ('TBR_R08', 'R08'),
                       ('TBR_R09', 'R09'),
                       ('TCU_U10', 'U10, U11'),
                       ('UDM_Q05', 'Q05'),
                       ('VQQ_Q07', 'Q07'),
                       ('VXQ_V01', 'V01'),
                       ('VXR_V03', 'V03'),
                       ('VXU_V04', 'V04'),
                       ('VXX_V02', 'V02'))),
          'HL70355': ('Primary key value type',
                      (('CE', 'Coded element'), ('PL', 'Person location'))),
          'HL70356': ('Alternate character set handling scheme',
                      (('2.3',
                        'The character set switching mode specified in HL7 2.5, section 2.7.2, _Escape sequences '
                        'supporting multiple character sets_ and section 2.A.46, "XPN _ extended person name".'),
                       ('ISO 2022-1994',
                        'This standard is titled "Information Technology - Character Code Structure and Extension '
                        'Technique". .'),
                       ('<null>',
                        'This is the default, indicating that there is no character set switching occurring in this '
                        'message.'))),
          'HL70357': ('Message error condition codes',
                      (('0', 'Message accepted'),
                       ('100', 'Segment sequence error'),
                       ('101', 'Required field missing'),
                       ('102', 'Data type error'),
                       ('103', 'Table value not found'),
                       ('200', 'Unsupported message type'),
                       ('201', 'Unsupported event code'),
                       ('202', 'Unsupported processing id'),
                       ('203', 'Unsupported version id'),
                       ('204', 'Unknown key identifier'),
                       ('205', 'Duplicate key identifier'),
                       ('206', 'Application record locked'),
                       ('207', 'Application internal error'))),
          'HL70359': ('Diagnosis Priority',
                      (('0', 'Not included in diagnosis ranking'),
                       ('1', 'The primary diagnosis'),
                       ('2 _', 'For ranked secondary diagnoses'))),
          'HL70360': ('Degree/license/certificate',
                      (('AA', 'Associate of Arts'),
                       ('AAS', 'Associate of Applied Science'),
                       ('ABA', 'Associate of Business Administration'),
                       ('AE', 'Associate of Engineering'),
                       ('AS', 'Associate of Science'),
                       ('BA', 'Bachelor of Arts'),
                       ('BBA', 'Bachelor of Business Administration'),
                       ('BE', 'Bachelor or Engineering'),
                       ('BFA', 'Bachelor of Fine Arts'),
                       ('BN', 'Bachelor of Nursing'),
                       ('BS', 'Bachelor of Science'),
                       ('BSL', 'Bachelor of Science _ Law'),
                       ('BSN', 'Bachelor on Science - Nursing'),
                       ('BT', 'Bachelor of Theology'),
                       ('CANP', 'Certified Adult Nurse Practitioner'),
                       ('CER', 'Certificate'),
                       ('CMA', 'Certified Medical Assistant'),
                       ('CNM', 'Certified Nurse Midwife'),
                       ('CNP', 'Certified Nurse Practitioner'),
                       ('CNS', 'Certified Nurse Specialist'),
                       ('CPNP', 'Certified Pediatric Nurse Practitioner'),
                       ('CRN', 'Certified Registered Nurse'),
                       ('DBA', 'Doctor of Business Administration'),
                       ('DED', 'Doctor of Education'),
                       ('DIP', 'Diploma'),
                       ('DO', 'Doctor of Osteopathy'),
                       ('EMT', 'Emergency Medical Technician'),
                       ('EMTP', 'Emergency Medical Technician - Paramedic'),
                       ('FPNP', 'Family Practice Nurse Practitioner'),
                       ('HS', 'High School Graduate'),
                       ('JD', 'Juris Doctor'),
                       ('MA', 'Master of Arts'),
                       ('MBA', 'Master of Business Administration'),
                       ('MCE', 'Master of Civil Engineering'),
                       ('MD', 'Doctor of Medicine'),
                       ('MDA', 'Medical Assistant'),
                       ('MDI', 'Master of Divinity'),
                       ('ME', 'Master of Engineering'),
                       ('MED', 'Master of Education'),
                       ('MEE', 'Master of Electrical Engineering'),
                       ('MFA', 'Master of Fine Arts'),
                       ('MME', 'Master of Mechanical Engineering'),
                       ('MS', 'Master of Science'),
                       ('MSL', 'Master of Science _ Law'),
                       ('MSN', 'Master of Science _ Nursing'),
                       ('MT', 'Master of Theology'),
                       ('NG', 'Non-Graduate'),
                       ('NP', 'Nurse Practitioner'),
                       ('PA', 'Physician Assistant'),
                       ('PharmD', 'Doctor of Pharmacy'),
                       ('PHD', 'Doctor of Philosophy'),
                       ('PHE', 'Doctor of Engineering'),
                       ('PHS', 'Doctor of Science'),
                       ('PN', 'Advanced Practice Nurse'),
                       ('RMA', 'Registered Medical Assistant'),
                       ('RPH', 'Registered Pharmacist'),
                       ('SEC', 'Secretarial Certificate'),
                       ('TS', 'Trade School Graduate'))),
          'HL70364': ('Comment type',
                      (('1R', 'Primary Reason'),
                       ('2R', 'Secondary Reason'),
                       ('AI', 'Ancillary Instructions'),
                       ('DR', 'Duplicate/Interaction Reason'),
                       ('GI', 'General Instructions'),
                       ('GR', 'General Reason'),
                       ('PI', 'Patient Instructions'),
                       ('RE', 'Remark'))),
          'HL70365': ('Equipment state',
                      (('CL', 'Clearing'),
                       ('CO', 'Configuring'),
                       ('ES', 'E-stopped'),
                       ('ID', 'Idle'),
                       ('IN', 'Initializing'),
                       ('OP', 'Normal Operation'),
                       ('PA', 'Pausing'),
                       ('PD', 'Paused'),
                       ('PU', 'Powered Up'))),
          'HL70366': ('Local/remote control state', (('L', 'Local'), ('R', 'Remote'))),
          'HL70367': ('Alert level',
                      (('C', 'Critical'),
                       ('N', 'Normal'),
                       ('S', 'Serious'),
                       ('W', 'Warning'))),
          'HL70368': ('Remote control command',
                      (('AB', 'Abort'),
                       ('CL', 'Clear'),
                       ('CN', 'Clear Notification'),
                       ('DI', 'Disable Sending Events'),
                       ('EN', 'Enable Sending Events'),
                       ('ES', 'Emergency _stop'),
                       ('EX',
                        'Execute (command specified in field Parameters (ST) 01394)'),
                       ('IN', 'Initialize/Initiate'),
                       ('LC', 'Local Control Request'),
                       ('LK', 'Lock'),
                       ('LO', 'Load'),
                       ('PA', 'Pause'),
                       ('RC', 'Remote Control Request'),
                       ('RE', 'Resume'),
                       ('SA', 'Sampling'),
                       ('SU', 'Setup'),
                       ('TT', 'Transport To'),
                       ('UC', 'Unlock'),
                       ('UN', 'Unload'))),
          'HL70369': ('Specimen Role',
                      (('B', 'Blind Sample'),
                       ('C', 'Calibrator'),
                       ('E',
                        'Electronic QC, used with manufactured reference providing signals that simulate QC results'),
                       ('F',
                        'Specimen used for testing proficiency of the organization performing the testing (Filler)'),
                       ('G',
                        'Group (where a specimen consists of multiple individual elements that are not individually '
                        'identified)'),
                       ('L',
                        'Pool (aliquots of individual specimens combined to form a single specimen representing all '
                        'of the components.)'),
                       ('O', 'Specimen used for testing Operator Proficiency'),
                       ('P', 'Patient (default if blank component value)'),
                       ('Q', 'Control specimen'),
                       ('R', 'Replicate (of patient sample as a control)'),
                       ('V',
                        'Verifying Calibrator, used for periodic calibration checks'))),
          'HL70370': ('Container status',
                      (('I', 'Identified'),
                       ('L', 'Left Equipment'),
                       ('M', 'Missing'),
                       ('O', 'In Process'),
                       ('P', 'In Position'),
                       ('R', 'Process Completed'),
                       ('U', 'Unknown'),
                       ('X', 'Container Unavailable'))),
          'HL70371': ('Additive/Preservative',
                      (('ACDA', 'ACD Solution A'),
                       ('ACDB', 'ACD Solution B'),
                       ('ACET', 'Acetic Acid'),
                       ('AMIES', 'Amies transport medium'),
                       ('BACTM', 'Bacterial Transport medium'),
                       ('BF10', 'Buffered 10% formalin'),
                       ('BOR', 'Borate Boric Acid'),
                       ('BOUIN', "Bouin's solution"),
                       ('BSKM', 'Buffered skim milk'),
                       ('C32', '3.2%  Citrate'),
                       ('C38', '3.8% Citrate'),
                       ('CARS', "Carson's Modified 10% formalin"),
                       ('CARY', 'Cary Blair Medium'),
                       ('CHLTM', 'Chlamydia transport medium'),
                       ('CTAD',
                        'CTAD (this should be spelled out if not universally understood)'),
                       ('EDTK', 'Potassium/K EDTA'),
                       ('EDTK15', 'Potassium/K EDTA 15%'),
                       ('EDTK75', 'Potassium/K EDTA 7.5%'),
                       ('EDTN', 'Sodium/Na EDTA'),
                       ('ENT', 'Enteric bacteria transport medium'),
                       ('ENT+', 'Enteric plus'),
                       ('F10', '10% Formalin'),
                       ('FDP',
                        'Thrombin NIH; soybean trypsin inhibitor (Fibrin Degradation Products)'),
                       ('FL10', 'Sodium Fluoride, 10mg'),
                       ('FL100', 'Sodium Fluoride, 100mg'),
                       ('HCL6', '6N HCL'),
                       ('HEPA', 'Ammonium heparin'),
                       ('HEPL', 'Lithium/Li  Heparin'),
                       ('HEPN', 'Sodium/Na  Heparin'),
                       ('HNO3', 'Nitric Acid'),
                       ('JKM', 'Jones Kendrick Medium'),
                       ('KARN', "Karnovsky's fixative"),
                       ('KOX', 'Potassium Oxalate'),
                       ('LIA', 'Lithium iodoacetate'),
                       ('M4', 'M4'),
                       ('M4RT', 'M4-RT'),
                       ('M5', 'M5'),
                       ('MICHTM', "Michel's transport medium"),
                       ('MMDTM', 'MMD transport medium'),
                       ('NAF', 'Sodium Fluoride'),
                       ('NAPS',
                        'Sodium polyanethol sulfonate 0.35% in 0.85% sodium chloride'),
                       ('NONE', 'None'),
                       ('PAGE', "Pages's Saline"),
                       ('PHENOL', 'Phenol'),
                       ('PVA', 'PVA (polyvinylalcohol)'),
                       ('RLM', 'Reagan Lowe Medium'),
                       ('SILICA', 'Siliceous earth, 12 mg'),
                       ('SPS',
                        'SPS(this should be spelled out if not universally understood)'),
                       ('SST', 'Serum Separator Tube (Polymer Gel)'),
                       ('STUTM', 'Stuart transport medium'),
                       ('THROM', 'Thrombin'),
                       ('THYMOL', 'Thymol'),
                       ('THYO', 'Thyoglycollate broth'),
                       ('TOLU', 'Toluene'),
                       ('URETM', 'Ureaplasma transport medium'),
                       ('VIRTM', 'Viral Transport medium'),
                       ('WEST', 'Buffered Citrate (Westergren Sedimentation Rate)'))),
          'HL70372': ('Specimen component',
                      (('BLD', 'Whole blood, homogeneous'),
                       ('BSEP', 'Whole blood, separated'),
                       ('PLAS', 'Plasma, NOS (not otherwise specified)'),
                       ('PPP', 'Platelet poor plasma'),
                       ('PRP', 'Platelet rich plasma'),
                       ('SED', 'Sediment'),
                       ('SER', 'Serum, NOS (not otherwise specified)'),
                       ('SUP', 'Supernatant'))),
          'HL70373': ('Treatment',
                      (('ACID', 'Acidification'),
                       ('ALK', 'Alkalization'),
                       ('DEFB', 'Defibrination'),
                       ('FILT', 'Filtration'),
                       ('LDLP', 'LDL Precipitation'),
                       ('NEUT', 'Neutralization'),
                       ('RECA', 'Recalification'),
                       ('UFIL', 'Ultrafiltration'))),
          'HL70374': ('System induced contaminants',
                      (('CNTM', 'Present, type of contamination unspecified'),)),
          'HL70375': ('Artificial blood',
                      (('FLUR', 'Fluorocarbons'),
                       ('SFHB', 'Stromal free hemoglobin preparations'))),
          'HL70376': ('Special Handling Code',
                      (('AMB', 'Ambient temperature'),
                       ('C37', 'Body temperature'),
                       ('CAMB', 'Critical ambient temperature'),
                       ('CATM', 'Protect from air'),
                       ('CFRZ', 'Critical frozen temperature'),
                       ('CREF', 'Critical refrigerated temperature'),
                       ('DFRZ', 'Deep frozen'),
                       ('DRY', 'Dry'),
                       ('FRZ', 'Frozen temperature'),
                       ('MTLF', 'Metal Free'),
                       ('NTR', 'Liquid nitrogen'),
                       ('PRTL', 'Protect from light'),
                       ('PSA', 'Do not shake'),
                       ('PSO', 'No shock'),
                       ('REF', 'Refrigerated temperature'),
                       ('UFRZ', 'Ultra frozen'),
                       ('UPR', 'Upright'))),
          'HL70377': ('Other environmental factors',
                      (('A60',
                        'Opened container, indoor atmosphere, 60 minutes duration'),
                       ('ATM',
                        'Opened container, atmosphere and duration unspecified'))),
          'HL70383': ('Substance status',
                      (('CE', 'Calibration Error'),
                       ('CW', 'Calibration Warning'),
                       ('EE', 'Expired Error'),
                       ('EW', 'Expired Warning'),
                       ('NE', 'Not Available Error'),
                       ('NW', 'Not Available Warning'),
                       ('OE', 'Other Error'),
                       ('OK', 'OK Status'),
                       ('OW', 'Other Warning'),
                       ('QE', 'QC Error'),
                       ('QW', 'QC Warning'))),
          'HL70384': ('Substance type',
                      (('CO', 'Control'),
                       ('DI', 'Diluent'),
                       ('LI', 'Measurable Liquid Item'),
                       ('LW', 'Liquid Waste'),
                       ('MR', 'Multiple Test Reagent'),
                       ('OT', 'Other'),
                       ('PT', 'Pretreatment'),
                       ('PW', 'Purified Water'),
                       ('RC', 'Reagent Calibrator'),
                       ('SC', 'Countable Solid Item'),
                       ('SR', 'Single Test Reagent'),
                       ('SW', 'Solid Waste'))),
          'HL70387': ('Command response',
                      (('ER',
                        'Command cannot be completed because of error condition'),
                       ('OK', 'Command completed successfully'),
                       ('ST',
                        'Command cannot be completed because of the status of the requested equipment'),
                       ('TI',
                        'Command cannot be completed within requested completion time'),
                       ('UN', 'Command cannot be completed for unknown reasons'))),
          'HL70388': ('Processing type',
                      (('E', 'Evaluation'), ('P', 'Regular Production'))),
          'HL70389': ('Analyte repeat status',
                      (('D', 'Repeated with dilution'),
                       ('F', 'Reflex test'),
                       ('O', 'Original, first run'),
                       ('R', 'Repeated without dilution'))),
          'HL70391': ('Segment group',
                      (('OBRG', 'OBR group'),
                       ('ORCG', 'ORC group'),
                       ('PIDG', 'PID group'),
                       ('RXAG', 'RXA group'),
                       ('RXDG', 'RXD group'),
                       ('RXEG', 'RXE group'),
                       ('RXOG', 'RXO group'))),
          'HL70392': ('Match reason',
                      (('DB', 'Match on Date of Birth'),
                       ('NA', 'Match on Name (Alpha Match)'),
                       ('NP', 'Match on Name (Phonetic Match)'),
                       ('SS', 'Match on Social Security Number'))),
          'HL70393': ('Match algorithms',
                      (('LINKSOFT_2.01', 'Proprietary algorithm for LinkSoft v2.01'),
                       ('MATCHWARE_1.2', 'Proprietary algorithm for MatchWare v1.2'))),
          'HL70394': ('Response modality',
                      (('B', 'Batch'),
                       ('R', 'Real Time'),
                       ('T',
                        'Bolus (a series of responses sent at the same time without use of batch formatting)'))),
          'HL70395': ('Modify indicator',
                      (('M', 'Modified Subscription'), ('N', 'New Subscription'))),
          'HL70396': ('Coding system',
                      (('L', 'Local general code'),
                       ('L', 'Local general code'),
                       ('ACR', 'American College of Radiology finding codes'),
                       ('ANS+', 'HL7 set of units of measure'),
                       ('ART', 'WHO Adverse Reaction Terms'),
                       ('AS4', 'ASTM E1238/ E1467 Universal'),
                       ('AS4E', 'AS4 Neurophysiology Codes'),
                       ('ATC', 'American Type Culture Collection'),
                       ('C4', 'CPT-4'),
                       ('C5', 'CPT-5'),
                       ('CAS', 'Chemical abstract codes'),
                       ('CD2', 'CDT-2 Codes'),
                       ('CDCA', 'CDC Analyte Codes'),
                       ('CDCM', 'CDC Methods/Instruments Codes'),
                       ('CDS', 'CDC Surveillance'),
                       ('CE', 'CEN ECG diagnostic codes'),
                       ('CLP', 'CLIP'),
                       ('CPTM', 'CPT Modifier Code'),
                       ('CST', 'COSTART'),
                       ('CVX', 'CDC Vaccine Codes'),
                       ('DCM', 'DICOM Controlled Terminology'),
                       ('E', 'EUCLIDES'),
                       ('E5', 'Euclides  quantity codes'),
                       ('E6', 'Euclides Lab method codes'),
                       ('E7', 'Euclides Lab equipment codes'),
                       ('ENZC', 'Enzyme Codes'),
                       ('FDDC', 'First DataBank Drug Codes'),
                       ('FDDX', 'First DataBank Diagnostic Codes'),
                       ('FDK', 'FDA K10'),
                       ('HB', 'HIBCC'),
                       ('HCPCS',
                        'CMS (formerly HCFA)  Common Procedure Coding System'),
                       ('HCPT', 'Health Care Provider Taxonomy'),
                       ('HHC', 'Home Health Care'),
                       ('HI', 'Health Outcomes'),
                       ('HL7nnnn',
                        'HL7 Defined Codes where nnnn is the HL7 table number'),
                       ('HOT', 'Japanese Nationwide Medicine Code'),
                       ('HPC', 'CMS (formerly HCFA )Procedure Codes (HCPCS)'),
                       ('I10', 'ICD-10'),
                       ('I10P', 'ICD-10  Procedure Codes'),
                       ('I9', 'ICD9'),
                       ('I9C', 'ICD-9CM'),
                       ('IBT', 'ISBT'),
                       ('IBTnnnn',
                        'ISBT 128 codes where nnnn  specifies a specific table within ISBT 128.'),
                       ('IC2', 'ICHPPC-2'),
                       ('ICD10AM', 'ICD-10 Australian modification'),
                       ('ICD10CA', 'ICD-10 Canada'),
                       ('ICDO',
                        'International Classification of Diseases for Oncology'),
                       ('ICS', 'ICCS'),
                       ('ICSD', 'International Classification of Sleep Disorders'),
                       ('ISO+', 'ISO 2955.83 (units of measure) with HL7 extensions'),
                       ('ISOnnnn',
                        'ISO Defined Codes where nnnn is the ISO table number'),
                       ('IUPC', 'IUPAC/IFCC Component Codes'),
                       ('IUPP', 'IUPAC/IFCC Property Codes'),
                       ('JC10', 'JLAC/JSLM, nationwide laboratory code'),
                       ('JC8', 'Japanese Chemistry'),
                       ('JJ1017', 'Japanese Image Examination Cache'),
                       ('LB', 'Local billing code'),
                       ('LN',
                        u'Logical Observation Identifier Names and Codes (LOINC\xae)'),
                       ('MCD', 'Medicaid'),
                       ('MCR', 'Medicare'),
                       ('MDDX', 'Medispan Diagnostic Codes'),
                       ('MEDC', 'Medical Economics Drug Codes'),
                       ('MEDR',
                        'Medical Dictionary for Drug Regulatory Affairs (MEDDRA)'),
                       ('MEDX', 'Medical Economics Diagnostic Codes'),
                       ('MGPI', 'Medispan GPI'),
                       ('MVX', 'CDC Vaccine Manufacturer Codes'),
                       ('NDA', 'NANDA'),
                       ('NDC', 'National drug codes'),
                       ('NIC', 'Nursing Interventions Classification'),
                       ('NPI', 'National Provider Identifier'),
                       ('NUBC', 'National Uniform Billing Committee Code'),
                       ('OHA', 'Omaha System'),
                       ('POS', 'POS Codes'),
                       ('RC', 'Read Classification'),
                       ('SDM', 'SNOMED- DICOM Microglossary'),
                       ('SNM', 'Systemized Nomenclature of Medicine (SNOMED)'),
                       ('SNM3', 'SNOMED International'),
                       ('SNT', 'SNOMED topology codes (anatomic sites)'),
                       ('UC', 'UCDS'),
                       ('UMD', 'MDNS'),
                       ('UML', 'Unified Medical Language'),
                       ('UPC', 'Universal Product Code'),
                       ('UPIN', 'UPIN'),
                       ('USPS', 'United States Postal Service'),
                       ('W1', 'WHO record # drug codes (6 digit)'),
                       ('W2', 'WHO record # drug codes (8 digit)'),
                       ('W4', 'WHO record # code with ASTM extension'),
                       ('WC', 'WHO ATC'),
                       ('NABM', u'Nomenclature des Actes de Biologie M\xe9dicale'),
                       ('99IHE', 'Local general code for IHE'))),
          'HL70397': ('Sequencing',
                      (('A', 'Ascending'),
                       ('AN', 'Ascending, case insensitive'),
                       ('D', 'Descending'),
                       ('DN', 'Descending, case insensitive'),
                       ('N', 'None'))),
          'HL70398': ('Continuation style code',
                      (('F', 'Fragmentation'), ('I', 'Interactive Continuation'))),
          'HL70399': ('Country code',
                      (('AFG', 'Afghanistan'),
                       ('ALB', 'Albania'),
                       ('DZA', 'Algeria'),
                       ('ASM', 'American Samoa'),
                       ('AND', 'Andorra'),
                       ('AGO', 'Angola'),
                       ('AIA', 'Anguilla'),
                       ('ATG', 'Antigua and Barbuda'),
                       ('ARG', 'Argentina'),
                       ('ARM', 'Armenia'),
                       ('ABW', 'Aruba'),
                       ('AUS', 'Australia'),
                       ('AZE', 'Azerbaijan'),
                       ('BHS', 'Bahamas'),
                       ('BHR', 'Bahrain'),
                       ('BGD', 'Bangladesh'),
                       ('BRB', 'Barbados'),
                       ('BLR', 'Belarus'),
                       ('BLZ', 'Belize'),
                       ('BEN', 'Benin'),
                       ('BMU', 'Bermuda'),
                       ('BTN', 'Bhutan'),
                       ('BOL', 'Bolivia'),
                       ('BIH', 'Bosnia and Herzegovina'),
                       ('BWA', 'Botswana'),
                       ('BRA', 'Brazil'),
                       ('BRN', 'Brunei Darussalam'),
                       ('BFA', 'Burkina Faso'),
                       ('BDI', 'Burundi'),
                       ('KHM', 'Cambodia'),
                       ('CMR', 'Cameroon'),
                       ('CAN', 'Canada'),
                       ('CPV', 'Cape Verde'),
                       ('CYM', 'Cayman Islands'),
                       ('CAF', 'Central African Republic'),
                       ('TCD', 'Chad'),
                       ('CHL', 'Chile'),
                       ('CHN', 'China'),
                       ('COL', 'Colombia'),
                       ('COM', 'Comoros'),
                       ('COG', 'Congo'),
                       ('COD', 'Congo, the Democratic Republic of the'),
                       ('COK', 'Cook Islands'),
                       ('CRI', 'Costa Rica'),
                       ('CIV', "Cote D'Ivoire"),
                       ('HRV', 'Croatia'),
                       ('CUB', 'Cuba'),
                       ('DJI', 'Djibouti'),
                       ('DMA', 'Dominica'),
                       ('DOM', 'Dominican Republic'),
                       ('ECU', 'Ecuador'),
                       ('EGY', 'Egypt'),
                       ('SLV', 'El Salvador'),
                       ('GNQ', 'Equatorial Guinea'),
                       ('ERI', 'Eritrea'),
                       ('ETH', 'Ethiopia'),
                       ('FLK', 'Falkland Islands (Malvinas)'),
                       ('FRO', 'Faroe Islands'),
                       ('FJI', 'Fiji'),
                       ('GUF', 'French Guiana'),
                       ('PYF', 'French Polynesia'),
                       ('GAB', 'Gabon'),
                       ('GMB', 'Gambia'),
                       ('GEO', 'Georgia'),
                       ('GHA', 'Ghana'),
                       ('GIB', 'Gibraltar'),
                       ('GRC', 'Greece'),
                       ('GRL', 'Greenland'),
                       ('GRD', 'Grenada'),
                       ('GLP', 'Guadeloupe'),
                       ('GUM', 'Guam'),
                       ('GTM', 'Guatemala'),
                       ('GIN', 'Guinea'),
                       ('GNB', 'Guinea-Bissau'),
                       ('GUY', 'Guyana'),
                       ('HTI', 'Haiti'),
                       ('VAT', 'Holy See (Vatican City State)'),
                       ('HND', 'Honduras'),
                       ('HKG', 'Hong Kong'),
                       ('ISL', 'Iceland'),
                       ('IND', 'India'),
                       ('IDN', 'Indonesia'),
                       ('IRN', 'Iran, Islamic Republic of'),
                       ('IRQ', 'Iraq'),
                       ('ISR', 'Israel'),
                       ('JAM', 'Jamaica'),
                       ('JPN', 'Japan'),
                       ('JOR', 'Jordan'),
                       ('KAZ', 'Kazakhstan'),
                       ('KEN', 'Kenya'),
                       ('KIR', 'Kiribati'),
                       ('PRK', "Korea, Democratic People's Republic of"),
                       ('KOR', 'Korea, Republic of'),
                       ('KWT', 'Kuwait'),
                       ('KGZ', 'Kyrgyzstan'),
                       ('LAO', "Lao People's Democratic Republic"),
                       ('LBN', 'Lebanon'),
                       ('LSO', 'Lesotho'),
                       ('LBR', 'Liberia'),
                       ('LBY', 'Libyan Arab Jamahiriya'),
                       ('LIE', 'Liechtenstein'),
                       ('MAC', 'Macao'),
                       ('MKD', 'Macedonia, the Former Yugoslav Republic of'),
                       ('MDG', 'Madagascar'),
                       ('MWI', 'Malawi'),
                       ('MYS', 'Malaysia'),
                       ('MDV', 'Maldives'),
                       ('MLI', 'Mali'),
                       ('MHL', 'Marshall Islands'),
                       ('MTQ', 'Martinique'),
                       ('MRT', 'Mauritania'),
                       ('MUS', 'Mauritius'),
                       ('MEX', 'Mexico'),
                       ('FSM', 'Micronesia, Federated States of'),
                       ('MDA', 'Moldova, Republic of'),
                       ('MCO', 'Monaco'),
                       ('MNG', 'Mongolia'),
                       ('MSR', 'Montserrat'),
                       ('MAR', 'Morocco'),
                       ('MOZ', 'Mozambique'),
                       ('MMR', 'Myanmar'),
                       ('NAM', 'Namibia'),
                       ('NRU', 'Nauru'),
                       ('NPL', 'Nepal'),
                       ('ANT', 'Netherlands Antilles'),
                       ('NCL', 'New Caledonia'),
                       ('NZL', 'New Zealand'),
                       ('NIC', 'Nicaragua'),
                       ('NER', 'Niger'),
                       ('NGA', 'Nigeria'),
                       ('NIU', 'Niue'),
                       ('NFK', 'Norfolk Island'),
                       ('MNP', 'Northern Mariana Islands'),
                       ('NOR', 'Norway'),
                       ('OMN', 'Oman'),
                       ('PAK', 'Pakistan'),
                       ('PLW', 'Palau'),
                       ('PAN', 'Panama'),
                       ('PNG', 'Papua New Guinea'),
                       ('PRY', 'Paraguay'),
                       ('PER', 'Peru'),
                       ('PHL', 'Philippines'),
                       ('PCN', 'Pitcairn'),
                       ('PRI', 'Puerto Rico'),
                       ('QAT', 'Qatar'),
                       ('REU', 'Reunion'),
                       ('RUS', 'Russian Federation'),
                       ('RWA', 'Rwanda'),
                       ('SHN', 'Saint Helena'),
                       ('KNA', 'Saint Kitts and Nevis'),
                       ('LCA', 'Saint Lucia'),
                       ('SPM', 'Saint Pierre and Miquelon'),
                       ('VCT', 'Saint Vincent and the Grenadines'),
                       ('WSM', 'Samoa'),
                       ('SMR', 'San Marino'),
                       ('STP', 'Sao Tome and Principe'),
                       ('SAU', 'Saudi Arabia'),
                       ('SEN', 'Senegal'),
                       ('SYC', 'Seychelles'),
                       ('SLE', 'Sierra Leone'),
                       ('SGP', 'Singapore'),
                       ('SLB', 'Solomon Islands'),
                       ('SOM', 'Somalia'),
                       ('ZAF', 'South Africa'),
                       ('LKA', 'Sri Lanka'),
                       ('SDN', 'Sudan'),
                       ('SUR', 'Suriname'),
                       ('SJM', 'Svalbard and Jan Mayen'),
                       ('SWZ', 'Swaziland'),
                       ('CHE', 'Switzerland'),
                       ('SYR', 'Syrian Arab Republic'),
                       ('TWN', 'Taiwan, Province of China'),
                       ('TJK', 'Tajikistan'),
                       ('TZA', 'Tanzania, United Republic of'),
                       ('THA', 'Thailand'),
                       ('TGO', 'Togo'),
                       ('TKL', 'Tokelau'),
                       ('TON', 'Tonga'),
                       ('TTO', 'Trinidad and Tobago'),
                       ('TUN', 'Tunisia'),
                       ('TUR', 'Turkey'),
                       ('TKM', 'Turkmenistan'),
                       ('TCA', 'Turks and Caicos Islands'),
                       ('TUV', 'Tuvalu'),
                       ('UGA', 'Uganda'),
                       ('UKR', 'Ukraine'),
                       ('ARE', 'United Arab Emirates'),
                       ('USA', 'United States'),
                       ('URY', 'Uruguay'),
                       ('UZB', 'Uzbekistan'),
                       ('VUT', 'Vanuatu'),
                       ('VEN', 'Venezuela'),
                       ('VNM', 'Viet Nam'),
                       ('VGB', 'Virgin Islands, British'),
                       ('VIR', 'Virgin Islands, U.s.'),
                       ('WLF', 'Wallis and Futuna'),
                       ('ESH', 'Western Sahara'),
                       ('YEM', 'Yemen'),
                       ('ZMB', 'Zambia'),
                       ('ZWE', 'Zimbabwe'),
                       ('AUT', 'Austria'),
                       ('BEL', 'Belgium'),
                       ('CYP', 'Cyprus'),
                       ('CZE', 'Czech Republic'),
                       ('DNK', 'Denmark'),
                       ('EST', 'Estonia'),
                       ('FIN', 'Finland'),
                       ('FRA', 'France'),
                       ('DEU', 'Germany'),
                       ('HUN', 'Hungary'),
                       ('IRL', 'Ireland'),
                       ('ITA', 'Italy'),
                       ('LVA', 'Latvia'),
                       ('LTU', 'Lithuania'),
                       ('LUX', 'Luxembourg'),
                       ('MLT', 'Malta'),
                       ('NLD', 'Netherlands'),
                       ('POL', 'Poland'),
                       ('PRT', 'Portugal'),
                       ('SVK', 'Slovakia'),
                       ('SVN', 'Slovenia'),
                       ('ESP', 'Spain'),
                       ('SWE', 'Sweden'),
                       ('GBR', 'United Kingdom'),
                       ('ROM', 'Romania'),
                       ('BGR', 'Bulgaria'))),
          'HL70401': ('Government reimbursement program',
                      (('C', 'Medi-Cal'), ('MM', 'Medicare'))),
          'HL70402': ('School type',
                      (('D', 'Dental'),
                       ('G', 'Graduate'),
                       ('M', 'Medical'),
                       ('U', 'Undergraduate'))),
          'HL70403': ('Language Ability',
                      (('1', 'Read'),
                       ('2', 'Write'),
                       ('3', 'Speak'),
                       ('4', 'Understand'),
                       ('5', 'Sign'))),
          'HL70404': ('Language Proficiency',
                      (('1', 'Excellent'),
                       ('2', 'Good'),
                       ('3', 'Fair'),
                       ('4', 'Poor'),
                       ('5', 'Some (level unknown)'),
                       ('6', 'None'))),
          'HL70406': ('Organization unit type',
                      (('1', 'Hospital'),
                       ('2', 'Physician Clinic'),
                       ('3', 'Long Term Care'),
                       ('4', 'Acute Care'),
                       ('5', 'Other'),
                       ('H', 'Home'),
                       ('O', 'Office'))),
          'HL70409': ('Application change type',
                      (('M', 'Migrates to different CPU'),
                       ('SD', 'Shut down'),
                       ('SU', 'Start up'))),
          'HL70415': ('DRG Transfer Type',
                      (('E', 'DRG Exempt'), ('N', 'DRG Non Exempt'))),
          'HL70416': ('Procedure DRG Type',
                      (('1', '1st non-Operative'),
                       ('2', '2nd non-Operative'),
                       ('3', 'Major Operative'),
                       ('4', '2nd Operative'),
                       ('5', '3rd Operative'))),
          'HL70417': ('Tissue Type Code',
                      (('0', 'No tissue expected'),
                       ('1', 'Insufficient Tissue'),
                       ('2', 'Not abnormal'),
                       ('3', 'Abnormal-not categorized'),
                       ('4', 'Mechanical abnormal'),
                       ('5', 'Growth alteration'),
                       ('6', 'Degeneration & necrosis'),
                       ('7', 'Non-acute inflammation'),
                       ('8', 'Non-malignant neoplasm'),
                       ('9', 'Malignant neoplasm'),
                       ('B', 'Basal cell carcinoma'),
                       ('C', 'Carcinoma-unspecified type'),
                       ('G', 'Additional tissue required'))),
          'HL70418': ('Procedure Priority',
                      (('0', 'the admitting procedure'),
                       ('1', 'the primary procedure'),
                       ('2 _', 'for ranked secondary procedures'))),
          'HL70421': ('Severity of Illness Code',
                      (('MI', 'Mild'), ('MO', 'Moderate'), ('SE', 'Severe'))),
          'HL70422': ('Triage Code',
                      (('1', 'Non-acute'),
                       ('2', 'Acute'),
                       ('3', 'Urgent'),
                       ('4', 'Severe'),
                       ('5', 'Dead on Arrival (DOA)'),
                       ('99', 'Other'))),
          'HL70423': ('Case Category Code', (('D', 'Doctor_s Office Closed'),)),
          'HL70424': ('Gestation Category Code',
                      (('1', 'Premature / Pre-term'),
                       ('2', 'Full Term'),
                       ('3', 'Overdue / Post-term'))),
          'HL70425': ('Newborn Code',
                      (('1', 'Born in facility'),
                       ('2', 'Transfer in'),
                       ('3', 'Born en route'),
                       ('4', 'Other'),
                       ('5', 'Born at home'))),
          'HL70426': ('Blood Product Code',
                      (('CRYO', 'Cryoprecipitated AHF'),
                       ('CRYOP', 'Pooled Cryoprecipitate'),
                       ('FFP', 'Fresh Frozen Plasma'),
                       ('FFPTH', 'Fresh Frozen Plasma - Thawed'),
                       ('PC', 'Packed Cells'),
                       ('PCA', 'Autologous Packed Cells'),
                       ('PCNEO', 'Packed Cells - Neonatal'),
                       ('PCW', 'Washed Packed Cells'),
                       ('PLT', 'Platelet Concentrate'),
                       ('PLTNEO', 'Reduced Volume Platelets'),
                       ('PLTP', 'Pooled Platelets'),
                       ('PLTPH', 'Platelet Pheresis'),
                       ('PLTPHLR', 'Leukoreduced Platelet Pheresis'),
                       ('RWB', 'Reconstituted Whole Blood'),
                       ('WBA', 'Autologous Whole Blood'))),
          'HL70427': ('Risk Management Incident Code',
                      (('B', 'Body fluid exposure'),
                       ('C', 'Contaminated Substance'),
                       ('D', 'Diet Errors'),
                       ('E', 'Equipment problem'),
                       ('F', 'Patient fell (not from bed)'),
                       ('H', 'Patient fell from bed'),
                       ('I', 'Infusion error'),
                       ('J', 'Foreign object left during surgery'),
                       ('K', 'Sterile precaution violated'),
                       ('O', 'Other'),
                       ('P', 'Procedure error'),
                       ('R', 'Pharmaceutical error'),
                       ('S', 'Suicide Attempt'),
                       ('T', 'Transfusion error'))),
          'HL70428': ('Incident Type Code',
                      (('O', 'Other'), ('P', 'Preventable'), ('U', 'User Error'))),
          'HL70429': ('Production Class Code',
                      (('BR', 'Breeding/genetic stock'),
                       ('DA', 'Dairy'),
                       ('DR', 'Draft'),
                       ('DU', 'Dual Purpose'),
                       ('LY', 'Layer, Includes Multiplier flocks'),
                       ('MT', 'Meat'),
                       ('NA', 'Not Applicable'),
                       ('OT', 'Other'),
                       ('PL', 'Pleasure'),
                       ('RA', 'Racing'),
                       ('SH', 'Show'),
                       ('U', 'Unknown'))),
          'HL70430': ('Mode of Arrival Code',
                      (('A', 'Ambulance'),
                       ('C', 'Car'),
                       ('F', 'On foot'),
                       ('H', 'Helicopter'),
                       ('O', 'Other'),
                       ('P', 'Public Transport'),
                       ('U', 'Unknown'))),
          'HL70431': ('Recreational Drug Use Code',
                      (('A', 'Alcohol'),
                       ('C', 'Tobacco - chewed'),
                       ('K', 'Kava'),
                       ('M', 'Marijuana'),
                       ('O', 'Other'),
                       ('T', 'Tobacco - smoked'),
                       ('U', 'Unknown'))),
          'HL70432': ('Admission Level of Care Code',
                      (('AC', 'Acute'),
                       ('CH', 'Chronic'),
                       ('CO', 'Comatose'),
                       ('CR', 'Critical'),
                       ('IM', 'Improved'),
                       ('MO', 'Moribund'))),
          'HL70433': ('Precaution Code',
                      (('A', 'Aggressive'),
                       ('B', 'Blind'),
                       ('C', 'Confused'),
                       ('D', 'Deaf'),
                       ('I', 'On IV'),
                       ('N', '_No-code_ (i.e. Do not resuscitate)'),
                       ('O', 'Other'),
                       ('P', 'Paraplegic'),
                       ('U', 'Unknown'))),
          'HL70434': ('Patient Condition Code',
                      (('A', 'Satisfactory'),
                       ('C', 'Critical'),
                       ('O', 'Other'),
                       ('P', 'Poor'),
                       ('S', 'Stable'),
                       ('U', 'Unknown'))),
          'HL70435': ('Advance Directive Code', (('DNR', 'Do not resuscitate'),)),
          'HL70436': ('Sensitivity to Causative Agent Code',
                      (('AD', 'Adverse Reaction (Not otherwise classified)'),
                       ('AL', 'Allergy'),
                       ('CT', 'Contraindication'),
                       ('IN', 'Intolerance'))),
          'HL70437': ('Alert Device Code',
                      (('B', 'Bracelet'), ('N', 'Necklace'), ('W', 'Wallet Card'))),
          'HL70438': ('Allergy Clinical Status',
                      (('C', 'Confirmed or verified'),
                       ('D', 'Doubt raised'),
                       ('E', 'Erroneous'),
                       ('I', 'Confirmed but inactive'),
                       ('P', 'Pending'),
                       ('S', 'Suspect'),
                       ('U', 'Unconfirmed'))),
          'HL70440': ('Data types',
                      (('AD', 'Address'),
                       ('AUI', 'Authorization information'),
                       ('CCD', 'Charge code and date'),
                       ('CCP', 'Channel calibration parameters'),
                       ('CD', 'Channel definition'),
                       ('CE', 'Coded element'),
                       ('CF', 'Coded element with formatted values'),
                       ('CK', 'Composite ID with check digit'),
                       ('CM', 'Composite'),
                       ('CN', 'Composite ID number and name'),
                       ('CNE', 'Coded with no exceptions'),
                       ('CNS', 'Composite ID number and name simplified'),
                       ('CP', 'Composite price'),
                       ('CQ', 'Composite quantity with units'),
                       ('CSU', 'Channel sensitivity'),
                       ('CWE', 'Coded with exceptions'),
                       ('CX', 'Extended composite ID with check digit'),
                       ('DDI', 'Daily deductible information'),
                       ('DIN', 'Date and institution name'),
                       ('DLD', 'Discharge to location and date'),
                       ('DLN', 'Driver_s license number'),
                       ('DLT', 'Delta'),
                       ('DR', 'Date/time range'),
                       ('DT', 'Date'),
                       ('DTM', 'Date/time'),
                       ('DTN', 'Day type and number'),
                       ('ED', 'Encapsulated data'),
                       ('EI', 'Entity identifier'),
                       ('EIP', 'Entity identifier pair'),
                       ('ELD', 'Error location and description'),
                       ('ERL', 'Error location'),
                       ('FC', 'Financial class'),
                       ('FN', 'Family name'),
                       ('FT', 'Formatted text'),
                       ('GTS', 'General timing specification'),
                       ('HD', 'Hierarchic designator'),
                       ('ICD', 'Insurance certification definition'),
                       ('ID', 'Coded values for HL7 tables'),
                       ('IS', 'Coded value for user-defined tables'),
                       ('JCC', 'Job code/class'),
                       ('LA1', 'Location with address variation 1'),
                       ('LA2', 'Location with address variation 2'),
                       ('MA', 'Multiplexed array'),
                       ('MO', 'Money'),
                       ('MOC', 'Money and charge code'),
                       ('MOP', 'Money or percentage'),
                       ('MSG', 'Message type'),
                       ('NA', 'Numeric array'),
                       ('NDL', 'Name with location and date'),
                       ('NM', 'Numeric'),
                       ('NR', 'Numeric range'),
                       ('OCD', 'Occurrence code and date'),
                       ('OSD', 'Order sequence definition'),
                       ('OSP', 'Occurrence span code and date'),
                       ('PIP', 'Practitioner institutional privileges'),
                       ('PL', 'Person location'),
                       ('PLN', 'Practitioner license or other ID number'),
                       ('PN', 'Person name'),
                       ('PPN', 'Performing person time stamp'),
                       ('PRL', 'Parent result link'),
                       ('PT', 'Processing type'),
                       ('PTA', 'Policy type and amount'),
                       ('QIP', 'Query input parameter list'),
                       ('QSC', 'Query selection criteria'),
                       ('RCD', 'Row column definition'),
                       ('RFR', 'Reference range'),
                       ('RI', 'Repeat interval'),
                       ('RMC', 'Room coverage'),
                       ('RP', 'Reference pointer'),
                       ('RPT', 'Repeat pattern'),
                       ('SAD', 'Street Address'),
                       ('SCV', 'Scheduling class value pair'),
                       ('SI', 'Sequence ID'),
                       ('SN', 'Structured numeric'),
                       ('SPD', 'Specialty description'),
                       ('SPS', 'Specimen source'),
                       ('SRT', 'Sort order'),
                       ('ST', 'String'),
                       ('TM', 'Time'),
                       ('TN', 'Telephone number'),
                       ('TQ', 'Timing/quantity'),
                       ('TS', 'Time stamp'),
                       ('TX', 'Text data'),
                       ('UVC', 'UB value code and amount'),
                       ('VH', 'Visiting hours'),
                       ('VID', 'Version identifier'),
                       ('VR', 'Value range'),
                       ('WVI', 'Channel Identifier'),
                       ('WVS', 'Waveform source'),
                       ('XAD', 'Extended address'),
                       ('XCN', 'Extended composite ID number and name'),
                       ('XON',
                        'Extended composite name and ID number for organizations'),
                       ('XPN', 'Extended person name'),
                       ('XTN', 'Extended telecommunications number'))),
          'HL70441': ('Immunization Registry Status',
                      (('A', 'Active'),
                       ('I', 'Inactive'),
                       ('L', 'Inactive - Lost to follow-up (cancel contract)'),
                       ('M', 'Inactive - Moved or gone elsewhere (cancel contract)'),
                       ('O', 'Other'),
                       ('P',
                        'Inactive - Permanently inactive (Do not reactivate or add new entries to the record)'),
                       ('U', 'Unknown'))),
          'HL70442': ('Location Service Code',
                      (('D', 'Diagnostic'),
                       ('E', 'Emergency Room Casualty'),
                       ('P', 'Primary Care'),
                       ('T', 'Therapeutic'))),
          'HL70443': ('Provider role',
                      (('AD', 'Admitting'),
                       ('AT', 'Attending'),
                       ('CP', 'Consulting Provider'),
                       ('FHCP', 'Family Health Care Professional'),
                       ('PP', 'Primary Care Provider'),
                       ('RP', 'Referring Provider'),
                       ('RT', 'Referred to Provider'))),
          'HL70444': ('Name assembly order',
                      (('F', 'Prefix Family Middle Given Suffix'),
                       ('G', 'Prefix Given Middle Family Suffix'))),
          'HL70445': ('Identity Reliability Code',
                      (('AL', 'Patient/Person Name is an Alias'),
                       ('UA', 'Unknown/Default Address'),
                       ('UD', 'Unknown/Default Date of Birth'),
                       ('US', 'Unknown/Default Social Security Number'))),
          'HL70450': ('Event type', (('LOG', 'Log Event'), ('SER', 'Service Event'))),
          'HL70451': ('Substance identifier',
                      (('ALL', 'Used for query of all inventory items'),)),
          'HL70452': ('Health care provider type code',
                      (('SUGGESTION',
                        'ANSI ASC X12 Health Care Provider Taxonomy, Level 1 - Type'),)),
          'HL70453': ('Health care provider classification',
                      (('SUGGESTION',
                        'ANSI ASC X12 Health Care Provider Taxonomy, Level 2 -  Classification'),)),
          'HL70454': ('Health care provider area of specialization',
                      (('SUGGESTION',
                        'ANSI ASC X12 Health Care Provider Taxonomy, Level 3 - specialization'),)),
          'HL70455': ('Type of Bill Code', (('...', 'No suggested values'),)),
          'HL70456': ('Revenue code', (('...', 'No suggested values'),)),
          'HL70457': ('Overall Claim Disposition Code',
                      (('0', 'No edits present on claim'),
                       ('1',
                        'Only edits present are for line item denial or rejection'),
                       ('2',
                        'Multiple-day claim with one or more days denied or rejected'),
                       ('3',
                        'Claim denied, rejected, suspended or returned to provider with only post payment edits'),
                       ('4',
                        'Claim denied, rejected, suspended or returned to provider with only pre payment edits'))),
          'HL70458': ('OCE Edit Code',
                      (('1', 'Invalid diagnosis code'),
                       ('10',
                        'Non-covered  service submitted for verification of denial (condition code 21 from header '
                        'information on claim)'),
                       ('11',
                        'Non-covered service submitted for FI review (condition code 20 from header information on '
                        'claim)'),
                       ('12', 'Questionable covered service'),
                       ('13',
                        'Additional payment for service not provided by Medicare'),
                       ('14',
                        'Code indicates a site of service not included in OPPS'),
                       ('15', 'Service unit out of range for procedure'),
                       ('16',
                        'Multiple bilateral procedures without modifier 50 (see Appendix A)'),
                       ('17',
                        'Multiple bilateral procedures with modifier 50 (see Appendix A)'),
                       ('18', 'Inpatient procedure'),
                       ('19',
                        'Mutually exclusive procedure that is not allowed even if appropriate modifier present'),
                       ('2', 'Diagnosis and age conflict'),
                       ('20',
                        'Component of a comprehensive procedure that is not allowed even if appropriate modifier '
                        'present'),
                       ('21',
                        'Medical visit on same day as a type "T" or "S" procedure without modifier 25 '
                        '(see Appendix B)'),
                       ('22', 'Invalid modifier'),
                       ('23', 'Invalid date'),
                       ('24', 'Date out of OCE range'),
                       ('25', 'Invalid age'),
                       ('26', 'Invalid sex'),
                       ('27', 'Only incidental services reported'),
                       ('28',
                        'Code not recognized by Medicare; alternate code for same service available'),
                       ('29',
                        'Partial hospitalization service for non-mental health diagnosis'),
                       ('3', 'Diagnosis and sex conflict'),
                       ('30',
                        'Insufficient services on day of partial hospitalization'),
                       ('31',
                        'Partial hospitalization on same day as ECT or type "T" procedure'),
                       ('32',
                        'Partial hospitalization claim spans 3 or less days with in-sufficient services, or ECT or '
                        'significant procedure on at least one of the days'),
                       ('33',
                        'Partial hospitalization claim spans more than 3 days with insufficient number of days having '
                        'mental health services'),
                       ('34',
                        'Partial hospitalization claim spans more than 3 days with insufficient number of days '
                        'meeting partial hospitalization criteria'),
                       ('35.',
                        'Only activity therapy and/or occupational therapy services provided'),
                       ('36.',
                        'Extensive mental health services provided on day of ECT or significant procedure'),
                       ('37',
                        'Terminated bilateral procedure or terminated procedure with units greater than one'),
                       ('38.',
                        'Inconsistency between implanted device and implantation procedure'),
                       ('39.',
                        'Mutually exclusive procedure that would be allowed if appropriate modifier were present'),
                       ('4', 'Medicare secondary payer alert'),
                       ('40.',
                        'Component of a comprehensive procedure that would be allowed if appropriate modifier were '
                        'present'),
                       ('41.', 'Invalid revenue code'),
                       ('42.',
                        'Multiple medical visits on same day with same revenue code without condition code G0 '
                        '(see Appendix B)'),
                       ('5', 'E-code as reason for visit'),
                       ('6', 'Invalid procedure code'),
                       ('7', 'Procedure and age conflict'),
                       ('8', 'Procedure and sex conflict'),
                       ('9', 'Nov-covered service'))),
          'HL70459': ('Reimbursement Action Code',
                      (('0', 'OCE line item denial or rejection is not ignored'),
                       ('1', 'OCE line item denial or rejection is ignored'),
                       ('2',
                        'External line item denial. Line item is denied even if no OCE edits'),
                       ('3',
                        'External line item rejection. Line item is rejected even if no OCE edits'))),
          'HL70460': ('Denial or Rejection Code',
                      (('0', 'Line item not denied or rejected'),
                       ('1', 'Line item denied or rejected'),
                       ('2',
                        'Line item is on a multiple-day claim. The line item is not denied or rejected, but occurs '
                        'on a day that has been denied or rejected.'))),
          'HL70465': ('Name/address representation',
                      (('A', 'Alphabetic (i.e., Default or some single-byte)'),
                       ('I', 'Ideographic (i.e., Kanji)'),
                       ('P', 'Phonetic (i.e., ASCII, Katakana, Hiragana, etc.)'))),
          'HL70466': ('Ambulatory Payment Classification Code',
                      (('031', 'Dental procedures'),
                       ('163', 'Excision/biopsy'),
                       ('181', 'Level 1 skin repair.'))),
          'HL70467': ('Modifier Edit Code',
                      (('0', 'Modifier does NOT exist'),
                       ('1', 'Modifier present, no errors'),
                       ('2', 'Modifier invalid'),
                       ('3', 'Modifier NOT approved for ASC/HOPD use'),
                       ('4',
                        'Modifier approved for ASC/HOPD use, inappropriate for code'),
                       ('U', 'Modifier edit code unknown'))),
          'HL70468': ('Payment Adjustment Code',
                      (('1', 'No payment adjustment'),
                       ('2',
                        'Designated current drug or biological payment adjustment applies to APC (status indicator G)'),
                       ('3',
                        'Designated new device payment adjustment applies to APC (status indicator H)'),
                       ('4',
                        'Designated new drug or new biological payment adjustment applies to APC (status indicator J)'),
                       ('5',
                        'Deductible not applicable (specific list of HCPCS codes)'))),
          'HL70469': ('Packaging Status Code',
                      (('0', 'Not packaged'),
                       ('1',
                        'Packaged service (status indicator N, or no HCPCS code and certain revenue codes)'),
                       ('2',
                        'Packaged as part of partial hospitalization per diem or daily mental health service '
                        'per diem'))),
          'HL70470': ('Reimbursement Type Code',
                      (('Crnl', 'Corneal Tissue APC'),
                       ('DME', 'Durable Medical Equipment'),
                       ('EPO', 'Epotein'),
                       ('Lab', 'Clinical Laboratory APC'),
                       ('Mamm', 'Screening Mammography APC'),
                       ('NoPay', 'This APC is not paid'),
                       ('OPPS', 'Outpatient Prospective Payment System'),
                       ('PartH', 'Partial Hospitalization APC'),
                       ('Pckg', 'Packaged APC'),
                       ('Thrpy', 'Therapy APC'))),
          'HL70472': ('TQ conjunction ID',
                      (('A', 'Asynchronous'),
                       ('C', 'This is an actuation time'),
                       ('S', 'Synchronous.'))),
          'HL70473': ('Formulary Status',
                      (('G',
                        'This observation/service is on the formulary, and has guidelines'),
                       ('N', 'This observation/service is not on the formulary'),
                       ('R',
                        'This observation/service is on the formulary, but is restricted'),
                       ('Y', 'This observation/service is on the formulary'))),
          'HL70474': ('Organization Unit Type',
                      (('D', 'Department'),
                       ('F', 'Facility'),
                       ('S', 'Subdivision'),
                       ('U', 'Subdepartment'),
                       ('V', 'Division'))),
          'HL70475': ('Charge Type Reason',
                      (('01', 'Allergy'),
                       ('02', 'Intolerance'),
                       ('03', 'Treatment Failure'),
                       ('04', 'Patient Request'),
                       ('05', 'No Exception'))),
          'HL70477': ('Controlled Substance Schedule*',
                      (('I', 'Schedule I'),
                       ('II', 'Schedule II'),
                       ('III', 'Schedule III'),
                       ('IV', 'Schedule IV'),
                       ('V', 'Schedule V'),
                       ('VI', 'Schedule VI'))),
          'HL70478': ('Formulary Status',
                      (('G',
                        'Pharmaceutical substance is in the formulary, but guidelines apply'),
                       ('N', 'Pharmaceutical substance is NOT in the formulary'),
                       ('R',
                        'Pharmaceutical substance is in the formulary, but restrictions apply'),
                       ('Y', 'Pharmaceutical substance is in the formulary'))),
          'HL70480': ('Pharmacy Order Types',
                      (('M', 'Medication'),
                       ('O', 'Other solution as medication orders'),
                       ('S', 'IV Large Volume Solutions'))),
          'HL70482': ('Order Type',
                      (('I', 'Inpatient Order'), ('O', 'Outpatient Order'))),
          'HL70483': ('Authorization Mode',
                      (('EL', 'Electronic'),
                       ('EM', 'E-mail'),
                       ('FX', 'Fax'),
                       ('IP', 'In Person'),
                       ('MA', 'Mail'),
                       ('PA', 'Paper'),
                       ('PH', 'Phone'),
                       ('RE', 'Reflexive (Automated system)'),
                       ('VC', 'Video-conference'),
                       ('VO', 'Voice'))),
          'HL70484': ('Dispense Type',
                      (('B', 'Trial Quantity Balance'),
                       ('C', 'Compassionate Fill'),
                       ('N', 'New/Renew - Full Fill'),
                       ('P', 'New/Renew - Part Fill'),
                       ('Q', 'Refill - Part Fill'),
                       ('R', 'Refill - Full Fill'),
                       ('S', 'Manufacturer Sample'),
                       ('T', 'Trial Quantity'),
                       ('Z', 'Non-Prescription Fill'))),
          'HL70485': ('Extended Priority Codes',
                      (('A', 'ASAP'),
                       ('C', 'Callback'),
                       ('P', 'Preop'),
                       ('PRN', 'As needed'),
                       ('R', 'Routine'),
                       ('S', 'Stat'),
                       ('T', 'Timing critical'),
                       ('TD<integer>', ''),
                       ('TH<integer>', ''),
                       ('TL<integer>', ''),
                       ('TM<integer>', ''),
                       ('TS<integer>', ''),
                       ('TW<integer>', ''))),
          'HL70487': ('Specimen Type',
                      (('ABS', 'Abscess'),
                       ('AMN', 'Amniotic fluid'),
                       ('ASP', 'Aspirate'),
                       ('BIFL', 'Bile fluid'),
                       ('BLDA', 'Blood arterial'),
                       ('BBL', 'Blood bag'),
                       ('BLDC', 'Blood capillary'),
                       ('BPU', 'Blood product unit'),
                       ('BLDV', 'Blood venous'),
                       ('BON', 'Bone'),
                       ('BRO', 'Bronchial'),
                       ('BRN', 'Burn'),
                       ('CALC', 'Calculus (=Stone)'),
                       ('CDM', 'Cardiac muscle'),
                       ('CNL', 'Cannula'),
                       ('CTP', 'Catheter tip'),
                       ('CSF', 'Cerebral spinal fluid'),
                       ('CVM', 'Cervical mucus'),
                       ('CVX', 'Cervix'),
                       ('COL', 'Colostrum'),
                       ('BLDCO', 'Cord blood'),
                       ('CNJT', 'Conjunctiva'),
                       ('CUR', 'Curettage'),
                       ('CYST', 'Cyst'),
                       ('DIAF', 'Dialysis fluid'),
                       ('DOSE', 'Dose med or substance'),
                       ('DRN', 'Drain'),
                       ('DUFL', 'Duodenal fluid'),
                       ('EAR', 'Ear'),
                       ('EARW', 'Ear wax (cerumen)'),
                       ('ELT', 'Electrode'),
                       ('ENDC', 'Endocardium'),
                       ('ENDM', 'Endometrium'),
                       ('EYE', 'Eye'),
                       ('EXG', 'Exhaled gas (=breath)'),
                       ('FLT', 'Filter'),
                       ('FIST', 'Fistula'),
                       ('FLU', 'Body fluid, unsp'),
                       ('GAS', 'Gas'),
                       ('GAST', 'Gastric fluid/contents'),
                       ('GEN', 'Genital'),
                       ('GENC', 'Genital cervix'),
                       ('GENL', 'Genital lochia'),
                       ('GENV', 'Genital vaginal'),
                       ('HAR', 'Hair'),
                       ('IHG', 'Inhaled Gas'),
                       ('IT', 'Intubation tube'),
                       ('ISLT', 'Isolate'),
                       ('LAM', 'Lamella'),
                       ('LN', 'Line'),
                       ('LNA', 'Line arterial'),
                       ('LNV', 'Line venous'),
                       ('LIQ', 'Liquid NOS'),
                       ('MAR', 'Marrow'),
                       ('MEC', 'Meconium'),
                       ('MBLD', 'Menstrual blood'),
                       ('MLK', 'Milk'),
                       ('MILK', 'Breast milk'),
                       ('NAIL', 'Nail'),
                       ('NOS', 'Nose (nasal passage)'),
                       ('ORH', 'Other'),
                       ('PAFL', 'Pancreatic fluid'),
                       ('PRT', 'Peritoneal fluid /ascites'),
                       ('PLC', 'Placenta'),
                       ('PLAS', 'Plasma'),
                       ('PLB', 'Plasma bag'),
                       ('PLR', 'Pleural fluid (thoracentesis fld)'),
                       ('PPP', 'Platelet poor plasma'),
                       ('PRP', 'Platelet rich plasma'),
                       ('PUS', 'Pus'),
                       ('RT', 'Route of medicine'),
                       ('SAL', 'Saliva'),
                       ('SMN', 'Seminal fluid'),
                       ('SER', 'Serum'),
                       ('SKN', 'Skin'),
                       ('SKM', 'Skeletal muscle'),
                       ('SPRM', 'Spermatozoa'),
                       ('SPT', 'Sputum'),
                       ('SPTC', 'Sputum - coughed'),
                       ('SPTT', 'Sputum - tracheal aspirate'),
                       ('STL', 'Stool = Fecal'),
                       ('SWT', 'Sweat'),
                       ('SNV', 'Synovial fluid (Joint fluid)'),
                       ('TEAR', 'Tears'),
                       ('THRT', 'Throat'),
                       ('TISS', 'Tissue'),
                       ('TISG', 'Tissue gall bladder'),
                       ('TLGI', 'Tissue large intestine'),
                       ('TLNG', 'Tissue lung'),
                       ('TISPL', 'Tissue placenta'),
                       ('TSMI', 'Tissue small intestine'),
                       ('TISU', 'Tissue ulcer'),
                       ('TUB', 'Tube NOS'),
                       ('ULC', 'Ulcer'),
                       ('UMB', 'Umbilical blood'),
                       ('UMED', 'Unknown medicine'),
                       ('URTH', 'Urethra'),
                       ('UR', 'Urine'),
                       ('URC', 'Urine clean catch'),
                       ('URT', 'Urine catheter'),
                       ('URNS', 'Urine sediment'),
                       ('USUB', 'Unknown substance'),
                       ('VITF', 'Vitreous Fluid'),
                       ('VOM', 'Vomitus'),
                       ('BLD', 'Whole blood'),
                       ('BDY', 'Whole body'),
                       ('WAT', 'Water'),
                       ('WICK', 'Wick'),
                       ('WND', 'Wound'),
                       ('WNDA', 'Wound abscess'),
                       ('WNDE', 'Wound exudate'),
                       ('WNDD', 'Wound drainage'))),
          'HL70488': ('Specimen Collection Method',
                      (('ANP', 'Plates, Anaerobic'),
                       ('BAP', 'Plates, Blood Agar'),
                       ('BCAE', 'Blood Culture, Aerobic Bottle'),
                       ('BCAN', 'Blood Culture, Anaerobic Bottle'),
                       ('BCPD', 'Blood Culture, Pediatric Bottle'),
                       ('BIO', 'Biopsy'),
                       ('CAP', 'Capillary Specimen'),
                       ('CATH', 'Catheterized'),
                       ('CVP', 'Line, CVP'),
                       ('EPLA', 'Environmental, Plate'),
                       ('ESWA', 'Environmental, Swab'),
                       ('FNA', 'Aspiration, Fine Needle'),
                       ('KOFFP', 'Plate, Cough'),
                       ('LNA', 'Line, Arterial'),
                       ('LNV', 'Line, Venous'),
                       ('MARTL', 'Martin-Lewis Agar'),
                       ('ML11', 'Mod. Martin-Lewis Agar'),
                       ('MLP', 'Plate, Martin-Lewis'),
                       ('NYP', 'Plate, New York City'),
                       ('PACE', 'Pace, Gen-Probe'),
                       ('PIN', 'Pinworm Prep'),
                       ('PNA', 'Aterial puncture'),
                       ('PRIME', 'Pump Prime'),
                       ('PUMP', 'Pump Specimen'),
                       ('QC5', 'Quality Control For Micro'),
                       ('SCLP', 'Scalp, Fetal Vein'),
                       ('SCRAPS', 'Scrapings'),
                       ('SHA', 'Shaving'),
                       ('SWA', 'Swab'),
                       ('SWD', 'Swab, Dacron tipped'),
                       ('TMAN', 'Transport Media, Anaerobic'),
                       ('TMCH', 'Transport Media, Chalamydia'),
                       ('TMM4', 'Transport Media, M4'),
                       ('TMMY', 'Transport Media, Mycoplasma'),
                       ('TMOT', 'Transport Media,'),
                       ('TMP', 'Plate, Thayer-Martin'),
                       ('TMPV', 'Transport Media, PVA'),
                       ('TMSC', 'Transport Media, Stool Culture'),
                       ('TMUP', 'Transport Media, Ureaplasma'),
                       ('TMVI', 'Transport Media, Viral'),
                       ('VENIP', 'Venipuncture'),
                       ('WOOD', 'Swab, Wooden Shaft'))),
          'HL70489': ('Risk Codes',
                      (('AGG', 'Aggressive'),
                       ('BHZ', 'Biohazard'),
                       ('BIO', 'Biological'),
                       ('COR', 'Corrosive'),
                       ('ESC', 'Escape Risk'),
                       ('EXP', 'Explosive'),
                       ('IFL', 'MaterialDangerInflammable'),
                       ('INF', 'MaterialDangerInfectious'),
                       ('INJ', 'Injury Hazard'),
                       ('POI', 'Poison'),
                       ('RAD', 'Radioactive'))),
          'HL70490': ('Specimen Reject Reason',
                      (('EX', 'Expired'),
                       ('QS', 'Quantity not sufficient'),
                       ('RA', 'Missing patient ID number'),
                       ('RB', 'Broken container'),
                       ('RC', 'Clotting'),
                       ('RD', 'Missing collection date'),
                       ('RE', 'Missing patient name'),
                       ('RH', 'Hemolysis'),
                       ('RI', 'Identification problem'),
                       ('RM', 'Labeling'),
                       ('RN', 'Contamination'),
                       ('RP', 'Missing phlebotomist ID'),
                       ('RR', 'Improper storage'),
                       ('RS', 'Name misspelling'))),
          'HL70491': ('Specimen Quality',
                      (('E', 'Excellent'),
                       ('F', 'Fair'),
                       ('G', 'Good'),
                       ('P', 'Poor'))),
          'HL70492': ('Specimen Appropriateness',
                      (('??', 'Inappropriate due to _'),
                       ('A', 'Appropriate'),
                       ('I', 'Inappropriate'),
                       ('P', 'Preferred'))),
          'HL70493': ('Specimen Condition',
                      (('AUT', 'Autolyzed'),
                       ('CLOT', 'Clotted'),
                       ('CON', 'Contaminated'),
                       ('COOL', 'Cool'),
                       ('FROZ', 'Frozen'),
                       ('HEM', 'Hemolyzed'),
                       ('LIVE', 'Live'),
                       ('ROOM', 'Room temperature'),
                       ('SNR', 'Sample not received'))),
          'HL70494': ('Specimen Child Role',
                      (('A', 'Aliquot'),
                       ('C', 'Component'),
                       ('M', 'Modified from original specimen'))),
          'HL70495': ('Body Site Modifier',
                      (('ANT', 'Anterior'),
                       ('BIL', 'Bilateral'),
                       ('DIS', 'Distal'),
                       ('EXT', 'External'),
                       ('L', 'Left'),
                       ('LAT', 'Lateral'),
                       ('LLQ', 'Quadrant, Left Lower'),
                       ('LOW', 'Lower'),
                       ('LUQ', 'Quadrant, Left Upper'),
                       ('MED', 'Medial'),
                       ('POS', 'Posterior'),
                       ('PRO', 'Proximal'),
                       ('R', 'Right'),
                       ('RLQ', 'Quadrant, Right Lower'),
                       ('RUQ', 'Quadrant, Right Upper'),
                       (u'\xa0UPP', 'Upper'))),
          'HL70496': ('Consent Type',
                      (('001',
                        'Release of Information/MR / Authorization to Disclosure Protected Health Information'),
                       ('002', 'Medical Procedure (invasive)'),
                       ('003', 'Acknowledge Receipt of Privacy Notice'),
                       ('004', 'Abortion'),
                       ('005', 'Abortion/Laminaria'),
                       ('006', 'Accutane _ Information'),
                       ('007', 'Accutane _ Woman'),
                       ('008', 'Advanced Beneficiary Notice'),
                       ('009', 'AFP (Alpha Fetoprotein) Screening'),
                       ('010', 'Amniocentesis (consent & refusal)'),
                       ('011', 'Anatomical Gift (organ donation)'),
                       ('012', 'Anesthesia - Complications'),
                       ('013', 'Anesthesia - Questionnaire'),
                       ('014', 'Angiogram'),
                       ('015', 'Angioplasty'),
                       ('016', 'Anticancer Drugs'),
                       ('017', 'Antipsychotic Medications'),
                       ('018', 'Arthrogram'),
                       ('019', 'Autopsy'),
                       ('020', 'AZT Therapy'),
                       ('021', 'Biliary Drainage'),
                       ('022', 'Biliary Stone Extraction'),
                       ('023', 'Biopsy'),
                       ('024', 'Bleeding Time Test'),
                       ('025', 'Bronchogram'),
                       ('026', 'Cardiac Catheterization'),
                       ('027', 'Coronary Angiography'),
                       ('028', '""      "" w/o Surgery Capability'),
                       ('029', 'Cataract Op/Implant of FDA Aprvd Lens'),
                       ('030', 'Cataract Op/Implant of Investigational Lens'),
                       ('031', 'Cataract Surgery'),
                       ('032', 'Cholera Immunization'),
                       ('033', 'Cholesterol Screening'),
                       ('034', 'Circumcision _ Newborn'),
                       ('035', 'Colonoscopy'),
                       ('036', 'Contact Lenses'),
                       ('037', 'CT Scan - Cervical & Lumbar'),
                       ('038', 'CT Scan w/ IV Contrast Media into Vein'),
                       ('039', 'CVS (Chorionic Villus) Sampling'),
                       ('040', 'Cystospy'),
                       ('041',
                        'Disclosure of Protected Health Information to Family/Friends'),
                       ('042', 'D & C and Conization'),
                       ('043', 'Dacryocystogram'),
                       ('044', 'Diagnostic Isotope'),
                       ('045', 'Drainage of an Abscess'),
                       ('046', 'Drug Screening'),
                       ('047', 'Electronic Monitoring of Labor - Refusal'),
                       ('048', 'Endometrial Biopsy'),
                       ('049', 'Endoscopy/Sclerosis of Esophageal Varices'),
                       ('050', 'ERCP'),
                       ('051', 'Exposure to reportable Communicable Disease'),
                       ('052', 'External Version'),
                       ('053', 'Fluorescein Angioscopy'),
                       ('054', 'Hepatitis B - Consent/Declination'),
                       ('055', 'Herniogram'),
                       ('056', 'HIV Test - Consent Refusal'),
                       ('057', 'HIV Test - Disclosure'),
                       ('058', 'HIV Test - Prenatal'),
                       ('059', 'Home IV Treatment Program'),
                       ('060', 'Home Parenteral Treatment Program'),
                       ('061', 'Hysterectomy'),
                       ('062', 'Hysterosalpingogram'),
                       ('063', 'Injection Slip/ Consent'),
                       ('064', 'Intrauterine Device'),
                       ('065', 'Intrauterine Device/Sterilization'),
                       ('066', 'Intravascular Infusion of Streptokinase/Urokinase'),
                       ('067', 'Intravenous Cholangiogram'),
                       ('068', 'Intravenous Digital Angiography'),
                       ('069', 'Iodine Administration'),
                       ('070', 'ISG'),
                       ('071', 'IVP'),
                       ('072', 'Laser Photocoagulation'),
                       ('073', 'Laser treatment'),
                       ('074', 'Lithium Carbonate'),
                       ('075', 'Liver Biopsy'),
                       ('076', 'Lumbar Puncture'),
                       ('077', 'Lymphangiogram'),
                       ('078', 'MAO Inhibitors'),
                       ('079', 'Med, Psych, and/or Drug/Alcohol'),
                       ('080', 'Medical Treatment - Refusal'),
                       ('081', 'Morning-after Pill'),
                       ('082', 'MRI _ Adult'),
                       ('083', 'MRI _ Pediatric'),
                       ('084', 'Myelogram'),
                       ('085', 'Needle Biopsy'),
                       ('086', 'Needle Biopsy of Lung'),
                       ('087', 'Newborn Treatment and Release'),
                       ('088', 'Norplant Subdermal Birth Control Implant'),
                       ('089', 'Operations, Anesthesia, Transfusions'),
                       ('090', 'Oral Contraceptives'),
                       ('091', 'Organ Donation'),
                       ('092', 'Patient Permits, Consents'),
                       ('093', 'Patient Treatment Permit, Release & Admission'),
                       ('094', 'Penile Injections'),
                       ('095', 'Percutaneous Nephrostomy'),
                       ('096', 'Percutaneous Transhepatic Cholangiogram'),
                       ('097', 'Photographs'),
                       ('098', 'Photographs - Employee'),
                       ('099', 'Photographs - Medical Research'),
                       ('100', 'Photographs - news Media'),
                       ('101', 'Psychiatric Admission - Next of Kin'),
                       ('102', 'Psychiatric Information During Hospital Stay'),
                       ('103', 'Public Release of Information'),
                       ('104', 'Radiologic Procedure'),
                       ('105', 'Refusal of Treatment'),
                       ('106', 'Release of Body'),
                       ('107', 'Release of Limb'),
                       ('108', 'Rh Immune Globulin'),
                       ('109', 'Rights of Medical Research Participants'),
                       ('110',
                        'Request to Restrict Access/Disclosure to Medical Record/Protected Health Information'),
                       ('111', 'Request for Remain Anonymous'),
                       ('112', 'Seat Belt Exemption'),
                       ('113', 'Sialogram'),
                       ('1137', 'Voiding Cystogram'),
                       ('114', 'Sigmoidoscopy'),
                       ('115', 'Sterilization - Anesthesia & Medical Services'),
                       ('116', 'Sterilization -Federally Funded'),
                       ('117', 'Sterilization _ Female'),
                       ('118', 'Sterilization - Laparoscopy/Pomeroy'),
                       ('119', 'Sterilization - Non-Federally Funded'),
                       ('120', 'Sterilization - Secondary'),
                       ('121', 'Tranquilizers'),
                       ('122', 'Transfer - Acknowledgement'),
                       ('123', 'Transfer _ Authorization'),
                       ('124', 'Transfer Certification - Physician'),
                       ('125', 'Transfer/Discharge Request'),
                       ('126', 'Transfer for Non-Medical Reasons'),
                       ('127', 'Transfer - Interfaculty Neonatal'),
                       ('128', 'Transfer Refusal'),
                       ('129', 'Transfer Refusal of Further Treatment'),
                       ('130', 'Treadmill & EKG'),
                       ('131', 'Treadmill, Thallium-201'),
                       ('132', 'Typhoid'),
                       ('133', 'Use of Investigational Device'),
                       ('134', 'Use of Investigational Drug'),
                       ('135', 'Venogram'),
                       ('136', 'Videotape'))),
          'HL70497': ('Consent Mode',
                      (('T', 'Telephone'), ('V', 'Verbal'), ('W', 'Written'))),
          'HL70498': ('Consent Status',
                      (('A', 'Active _ Consent has been granted'),
                       ('B', 'Bypassed (Consent not sought)'),
                       ('L', 'Limited _ Consent has been granted with limitations'),
                       ('P', 'Pending _ Consent has not yet been sought'),
                       ('R', 'Refused _ Consent has been refused'),
                       ('X',
                        'Rescinded _ Consent was initially granted, but was subsequently revoked or ended.'))),
          'HL70499': ('Consent Bypass Reason',
                      (('E', 'Emergency'), ('PJ', 'Professional Judgment'))),
          'HL70500': ('Consent Disclosure Level',
                      (('F', 'Full Disclosure'),
                       ('N', 'No Disclosure'),
                       ('P', 'Partial Disclosure'))),
          'HL70501': ('Consent Non-Disclosure Reason',
                      (('E', 'Emergency'),
                       ('PR', 'Patient Request'),
                       ('RX', 'Rx Private'))),
          'HL70502': ('Non-Subject Consenter Reason',
                      (('LM', 'Legally mandated'),
                       ('MIN', 'Subject is a minor'),
                       ('NC', 'Subject is not competent to consent'))),
          'HL70503': ('Sequence/Results Flag',
                      (('C', 'Cyclical'),
                       ('R', 'Reserved for future use'),
                       ('S', 'Sequential'))),
          'HL70504': ('Sequence Condition Code',
                      (('EE',
                        'End related service request(s), end current service request.'),
                       ('ES',
                        'End related service request(s), start current service request.'),
                       ('SE',
                        'Start related service request(s), end current service request.'),
                       ('SS',
                        'Start related service request(s), start current service request.'))),
          'HL70505': ('Cyclic Entry/Exit Indicator',
                      (('*', 'The first service request in a cyclic group'),
                       ('#', 'The last service request in a cyclic group.'))),
          'HL70506': ('Service Request Relationship',
                      (('C', 'Compound'),
                       ('E', 'Exclusive'),
                       ('N', 'Nurse prerogative'),
                       ('S', 'Simultaneous'),
                       ('T', 'Tapering'))),
          'HL70507': ('Observation Result Handling',
                      (('F', 'Film-with-patient'),
                       ('N', 'Notify provider when ready'))),
          'HL70508': ('Blood Product Processing Requirements',
                      (('AU', 'Autologous Unit'),
                       ('CM', 'CMV Negative'),
                       ('CS', 'CMV Safe'),
                       ('DI', 'Directed Unit'),
                       ('FR', 'Fresh unit'),
                       ('HB', 'Hemoglobin S Negative'),
                       ('HL', 'HLA Matched'),
                       ('IG', 'IgA Deficient'),
                       ('IR', 'Irradiated'),
                       ('LR', 'Leukoreduced'),
                       ('WA', 'Washed'))),
          'HL70510': ('Blood Product Dispense Status',
                      (('CR', 'Released into inventory for general availability'),
                       ('DS', 'Dispensed to patient location'),
                       ('PT', 'Presumed transfused (dispensed and not returned)'),
                       ('RA', 'Returned unused/no longer needed'),
                       ('RD', 'Reserved and ready to dispense'),
                       ('RE', 'Released (no longer allocated for the patient)'),
                       ('RI', 'Received into inventory (for specified patient)'),
                       ('RL',
                        'Returned unused/keep linked to patient for possible use later'),
                       ('RQ', 'Request to dispense blood product'),
                       ('RS',
                        'Reserved (ordered and product allocated for the patient)'),
                       ('WA', 'Wasted (product no longer viable)'))),
          'HL70511': ('BP Observation Status Codes Interpretation',
                      (('C',
                        'Record coming over is a correction and thus replaces a final status'),
                       ('D', 'Deletes the BPX record'),
                       ('F',
                        'Final status; Can only be changed with a corrected status'),
                       ('O', 'Order detail description only (no status)'),
                       ('P', 'Preliminary status'),
                       ('W',
                        'Post original as wrong, e.g., transmitted for wrong patient'))),
          'HL70513': ('Blood Product Transfusion/Disposition Status',
                      (('RA', 'Returned unused/no longer needed'),
                       ('RL',
                        'Returned unused/keep linked to patient for possible use later'),
                       ('TR', 'Transfused with adverse reaction'),
                       ('TX', 'Transfused'),
                       ('WA', 'Wasted (product no longer viable)'))),
          'HL70514': ('Transfusion Adverse Reaction',
                      (('ABOINC', 'ABO Incompatible Transfusion Reaction'),
                       ('ACUTHEHTR', 'Acute Hemolytic Transfusion Reaction'),
                       ('ALLERGIC1', 'Allergic Reaction _ First'),
                       ('ALLERGIC2', 'Allergic Reaction _ Recurrent'),
                       ('ALLERGICR', 'Allergic Reaction _ Repeating'),
                       ('ANAPHYLAC', 'Anaphylactic Reaction'),
                       ('BACTCONTAM', 'Reaction to Bacterial Contamination'),
                       ('DELAYEDHTR', 'Delayed Hemolytic Transfusion Reaction'),
                       ('DELAYEDSTR', 'Delayed Serological Transfusion Reaction'),
                       ('GVHD', 'Graft vs Host Disease _ Transfusion _ Associated'),
                       ('HYPOTENS', 'Non-hemolytic Hypotensive Reaction'),
                       ('NONHTR1',
                        'Non-Hemolytic Fever Chill Transfusion Reaction _ First'),
                       ('NONHTR2',
                        'Non-Hemolytic Fever Chill Transfusion Reaction _ Recurrent'),
                       ('NONHTRREC',
                        'Non-Hemolytic Fever Chill Transfusion Reaction _ Repeating'),
                       ('NONIMMUNE', 'Non-Immune Hemolysis'),
                       ('NONSPEC',
                        'Non-Specific, Non-Hemolytic Transfusion Reaction'),
                       ('NORXN', 'No Evidence of Transfusion Reaction'),
                       ('PTP', 'Posttransfusion Purpura'),
                       ('VOLOVER', 'Symptoms most likely due to volume overload'))),
          'HL70516': ('Error severity',
                      (('E', 'Error'), ('I', 'Information'), ('W', 'Warning'))),
          'HL70517': ('Inform person code',
                      (('HD', 'Inform help desk'),
                       ('NPAT', 'Do NOT inform patient'),
                       ('PAT', 'Inform patient'),
                       ('USR', 'Inform User'))),
          'HL70518': ('Override type',
                      (('EQV', 'Equivalence Override'),
                       ('EXTN', 'Extension Override'),
                       ('INLV', 'Interval Override'))),
          'HL70519': ('Override reason', (('_', 'No suggested values'),)),
          'HL70523': ('Computation type',
                      (('%', 'Indicates a percent change'), ('a', 'Absolute Change'))),
          'HL70524': ('Sequence condition',
                      (('C', 'Repeating cycle of orders'),
                       ('R', 'Reserved for possible future use'),
                       ('S', 'Sequence conditions'))),
          'HL70527': ('Calendar alignment',
                      (('DM', 'day of the month'),
                       ('DW', 'day of the week (begins with Monday)'),
                       ('DY', 'day of the year'),
                       ('HD', 'hour of the day'),
                       ('MY', 'month of the year'),
                       ('NH', 'minute of the hour'),
                       ('SN', 'second of the minute'),
                       ('WY', 'week of the year'))),
          'HL70528': ('Event related period',
                      (('AC', 'before meal (from lat. ante cibus)'),
                       ('ACD', 'before lunch (from lat. ante cibus diurnus)'),
                       ('ACM', 'before breakfast (from lat. ante cibus matutinus)'),
                       ('ACV', 'before dinner (from lat. ante cibus vespertinus)'),
                       ('HS', 'the hour of sleep (e.g., H18-22)'),
                       ('IC', 'between meals (from lat. inter cibus)'),
                       ('ICD', 'between lunch and dinner'),
                       ('ICM', 'between breakfast and lunch'),
                       ('ICV', 'between dinner and the hour of sleep'),
                       ('PC', 'after meal (from lat. post cibus)'),
                       ('PCD', 'after lunch (from lat. post cibus diurnus)'),
                       ('PCM', 'after breakfast (from lat. post cibus matutinus)'),
                       ('PCV', 'after dinner (from lat. post cibus vespertinus)'))),
          'HL70529': ('Precision',
                      (('D', 'day'),
                       ('H', 'hour'),
                       ('L', 'month'),
                       ('M', 'minute'),
                       ('S', 'second'),
                       ('Y', 'year'))),
          'HL70530': ('Organization, agency, department ',
                      (('AE', 'American Express'),
                       ('DEA', 'Drug Enforcement Agency'),
                       ('DOD', 'Department of Defense'),
                       ('MC', 'Master Card'),
                       ('VA', 'Veterans Affairs'),
                       ('VI', 'Visa'))),
          'HL70532': ('Expanded yes/no indicator',
                      (('ASKU', 'asked but unknown '),
                       ('N', 'No'),
                       ('NA', 'not applicable'),
                       ('NASK', 'not asked'),
                       ('NAV', 'temporarily unavailable'),
                       ('NI', 'No Information'),
                       ('NP', 'not present'),
                       ('UNK', 'unknown'),
                       ('Y', 'Yes'))),
          'HL70534': ('Notify Clergy Code',
                      (('L', 'Last Rites only'),
                       ('N', 'No'),
                       ('O', 'Other'),
                       ('U', 'Unknown'),
                       ('Y', 'Yes'))),
          'HL70535': ('Signature Code',
                      (('C',
                        'Signed CMS-1500 claim form on file, e.g. authorization for release of any medical or other '
                        'information necessary to process this claim and assignment of benefits.'),
                       ('M',
                        'Signed authorization for assignment of benefits on file.'),
                       ('P',
                        'Signature generated by provider because the patient was not physically present for services.'),
                       ('S',
                        'Signed authorization for release of any medical or other information necessary to process '
                        'this claim on file.'))),
          'HL70536': ('Certificate Status',
                      (('E', 'Expired'),
                       ('I', 'Inactive'),
                       ('P', 'Provisional'),
                       ('R', 'Revoked'),
                       ('V', 'Active/Valid'))),
          'HL70537': ('Institution', (('...', 'No suggested values defined'),)),
          'HL70538': ('Institution Relationship Type',
                      (('CON', 'Contractor'),
                       ('CST', 'Consultant'),
                       ('EMP', 'Employee'),
                       ('VOL', 'Volunteer'))),
          'HL70540': ('Inactive Reason Code',
                      (('L', 'Leave of Absence'),
                       ('R', 'Retired'),
                       ('T', 'Termination'))),
          'HL70547': ('Jurisdictional Breadth',
                      (('C', 'County/Parish'),
                       ('N', 'Country'),
                       ('S', 'State/Province'))),
          'HL70548': ('Signatory_s Relationship to Subject',
                      (('1', 'Self'),
                       ('2', 'Parent'),
                       ('3', 'Next of Kin'),
                       ('4', 'Durable Power of Attorney in Healthcare Affairs'),
                       ('5', 'Conservator'),
                       ('6',
                        'Emergent Practitioner (practitioner judging case as emergency requiring care without a '
                        'consent)'),
                       ('7',
                        'Non-Emergent Practitioner (i.e. medical ethics committee)'))),
          'HL70550': ('Body Parts',
                      ((u'\xa0', 'External Jugular'),
                       ('ACET', 'Acetabulum'),
                       ('ACHIL', 'Achilles'),
                       ('ADB', 'Abdomen'),
                       ('ADE', 'Adenoids'),
                       ('ADR', 'Adrenal'),
                       ('AMN', 'Amniotic fluid'),
                       ('AMS', 'Amniotic Sac'),
                       ('ANAL', 'Anal'),
                       ('ANKL', 'Ankle'),
                       ('ANTEC', 'Antecubital'),
                       ('ANTECF', 'Antecubital Fossa'),
                       ('ANTR', 'Antrum'),
                       ('ANUS', 'Anus'),
                       ('AORTA', 'Aorta'),
                       ('APDX', 'Appendix'),
                       ('AR', 'Aortic Rim'),
                       ('AREO', 'Areola'),
                       ('ARM', 'Arm'),
                       ('ARTE', 'Artery'),
                       ('ASCIT', 'Ascites'),
                       ('ASCT', 'Ascitic Fluid'),
                       ('ATR', 'Atrium'),
                       ('AURI', 'Auricular'),
                       ('AV', 'Aortic Valve'),
                       ('AXI', 'Axilla'),
                       ('BACK', 'Back'),
                       ('BARTD', 'Bartholin Duct'),
                       ('BARTG', 'Bartholin Gland'),
                       ('BCYS', 'Brain Cyst Fluid'),
                       ('BDY', 'Body, Whole'),
                       ('BID', 'Bile Duct'),
                       ('BIFL', 'Bile fluid'),
                       ('BLAD', 'Bladder'),
                       ('BLD', 'Blood, Whole'),
                       ('BLDA', 'Blood,  Arterial'),
                       ('BLDC', 'Blood,  Capillary'),
                       ('BLDV', 'Blood,  Venous'),
                       ('BLOOD', 'Blood'),
                       ('BMAR', 'Bone marrow'),
                       ('BON', 'Bone'),
                       ('BOWEL', 'Bowel'),
                       ('BOWLA', 'Bowel, Large'),
                       ('BOWSM', 'Bowel, Small'),
                       ('BPH', 'Basophils'),
                       ('BRA', 'Brachial'),
                       ('BRAIN', 'Brain'),
                       ('BRO', 'Bronchial'),
                       ('BROCH', 'Bronchiole/Bronchiolar'),
                       ('BRONC', 'Bronchus/Bronchial'),
                       ('BROW', 'Eyebrow'),
                       ('BRST', 'Breast'),
                       ('BRSTFL', 'Breast fluid'),
                       ('BRTGF', 'Bartholin Gland Fluid'),
                       ('BRV', 'Broviac'),
                       ('BUCCA', 'Buccal'),
                       ('BURSA', 'Bursa'),
                       ('BURSF', 'Bursa Fluid'),
                       ('BUTT', 'Buttocks'),
                       ('CALF', 'Calf'),
                       ('CANAL', 'Canal'),
                       ('CANLI', 'Canaliculis'),
                       ('CANTH', 'Canthus'),
                       ('CARO', 'Carotid'),
                       ('CARP', 'Carpal'),
                       ('CAVIT', 'Cavity'),
                       ('CBLD', 'Blood, Cord'),
                       ('CDM', 'Cardiac Muscle'),
                       ('CDUCT', 'Common Duct'),
                       ('CECUM', 'Cecum/Cecal'),
                       ('CERVUT', 'Cervix/Uterus'),
                       ('CHE', 'Cavity, Chest'),
                       ('CHEEK', 'Cheek'),
                       ('CHES', 'Chest'),
                       (u'CHEST\xa0', 'Chest Tube'),
                       ('CHIN', 'Chin'),
                       ('CIRCU', 'Circumcision Site'),
                       ('CLAVI', 'Clavicle/Clavicular'),
                       ('CLIT', 'Clitoris'),
                       ('CLITO', 'Clitoral'),
                       ('CNL', 'Cannula'),
                       ('COCCG', 'Coccygeal'),
                       ('COCCY', 'Coccyx'),
                       ('COLON', 'Colon'),
                       ('COLOS', 'Colostomy'),
                       ('CONJ', 'Conjunctiva'),
                       ('COR', 'Cord'),
                       ('CORAL', 'Coral'),
                       ('CORD', 'Cord Blood'),
                       ('CORN', 'Cornea'),
                       ('COS', 'Colostomy Stoma'),
                       ('CRANE', 'Cranium, ethmoid'),
                       ('CRANF', 'Cranium, frontal'),
                       ('CRANO', 'Cranium, occipital'),
                       ('CRANP', 'Cranium, parietal'),
                       ('CRANS', 'Cranium, sphenoid'),
                       ('CRANT', 'Cranium, temporal'),
                       ('CSF', 'Cerebral Spinal Fluid'),
                       ('CUBIT', 'Cubitus'),
                       ('CUFF', 'Cuff'),
                       ('CULD', 'Cul De Sac'),
                       ('CULDO', 'Culdocentesis'),
                       ('CVX', 'Cervix'),
                       ('DELT', 'Deltoid'),
                       ('DEN', 'Dental Gingiva'),
                       ('DENTA', 'Dental'),
                       ('DIAF', 'Dialysis Fluid'),
                       ('DIGIT', 'Digit'),
                       ('DISC', 'Disc'),
                       ('DORS', 'Dorsum/Dorsal'),
                       ('DPH', 'Diaphragm'),
                       ('DUFL', 'Duodenal Fluid'),
                       ('DUODE', 'Duodenum/Duodenal'),
                       ('DUR', 'Dura'),
                       ('EAR', 'Ear'),
                       ('EARBI', 'Ear bone, incus'),
                       ('EARBM', 'Ear bone, malleus'),
                       ('EARBS', 'Ear bone,stapes'),
                       ('EARLO', 'Ear Lobe'),
                       ('EC', 'Endocervical'),
                       ('ELBOW', 'Elbow'),
                       ('ELBOWJ', 'Elbow Joint'),
                       ('ENDC', 'Endocardium'),
                       ('ENDM', 'Endometrium'),
                       ('EOLPH', 'endolpthamitis'),
                       ('EOS', 'Eosinophils'),
                       ('EPD', 'Epididymis'),
                       ('EPICA', 'Epicardial'),
                       ('EPICM', 'Epicardium'),
                       ('EPIDU', 'Epidural'),
                       ('EPIGL', 'Epiglottis'),
                       ('ESO', 'Esophagus'),
                       ('ESOPG', 'Esophageal'),
                       ('ET', 'Endotracheal'),
                       ('ETHMO', 'Ethmoid'),
                       ('EUR', 'Endourethral'),
                       ('EYE', 'Eye'),
                       ('EYELI', 'Eyelid'),
                       ('FACE', 'Face'),
                       ('FALLT', 'Fallopian Tube'),
                       ('FBINC', 'Facial bone, inferior nasal concha'),
                       ('FBLAC', 'Facial bone, lacrimal'),
                       ('FBMAX', 'Facial bone, maxilla'),
                       ('FBNAS', 'Facial bone, nasal'),
                       ('FBPAL', 'Facial bone, palatine'),
                       ('FBVOM', 'Facial bone, vomer'),
                       ('FBZYG', 'Facial bone, zygomatic'),
                       ('FEMOR', 'Femoral'),
                       ('FEMUR', 'Femur'),
                       ('FET', 'Fetus'),
                       ('FIBU', 'Fibula'),
                       ('FING', 'Finger'),
                       ('FINGN', 'Finger Nail'),
                       ('FMH', 'Femoral Head'),
                       ('FOL', 'Follicle'),
                       ('FOOT', 'Foot'),
                       ('FOREA', 'Forearm'),
                       ('FOREH', 'Forehead'),
                       ('FORES', 'Foreskin'),
                       ('FOURC', 'Fourchette'),
                       ('GB', 'Gall Bladder'),
                       ('GEN', 'Genital'),
                       ('GENC', 'Genital Cervix'),
                       ('GENL', 'Genital Lochia'),
                       ('GL', 'Genital Lesion'),
                       ('GLAND', 'Gland'),
                       ('GLANS', 'Glans'),
                       ('GLUT', 'Gluteus'),
                       ('GLUTE', 'Gluteal'),
                       ('GLUTM', 'Gluteus Medius'),
                       ('GROIN', 'Groin'),
                       ('GUM', 'Gum'),
                       ('GVU', 'Genital - Vulva'),
                       ('HAL', 'Hallux'),
                       ('HAND', 'Hand'),
                       ('HAR', 'Hair'),
                       ('HART', 'Heart'),
                       ('HEAD', 'Head'),
                       ('HEEL', 'Heel'),
                       ('HEM', 'Hemorrhoid'),
                       ('HIP', 'Hip'),
                       ('HIPJ', 'Hip Joint'),
                       ('HUMER', 'Humerus'),
                       ('HV', 'Heart Valve'),
                       ('HVB', 'Heart Valve, Bicuspid'),
                       ('HVT', 'Heart Valve, Tricuspid'),
                       ('HYMEN', 'Hymen'),
                       ('ICX', 'Intracervical'),
                       ('ILC', 'Ileal Conduit'),
                       ('ILCON', 'Ilical Conduit'),
                       ('ILCR', 'Iliac Crest'),
                       ('ILE', 'Ileal Loop'),
                       ('ILEOS', 'Ileostomy'),
                       ('ILEUM', 'Ileum'),
                       ('ILIAC', 'Iliac'),
                       ('INASA', 'Intranasal'),
                       ('INGUI', 'Inguinal'),
                       ('INSTL', 'Intestine, Large'),
                       ('INSTS', 'Intestine, Small'),
                       ('INT', 'Intestine'),
                       ('INTRO', 'Introitus'),
                       ('INTRU', 'Intrauterine'),
                       ('ISCHI', 'Ischium'),
                       ('ISH', 'Loop, Ishial'),
                       ('JAW', 'Jaw'),
                       ('JUGI', 'Jugular, Internal'),
                       (u'KIDN\xa0', 'Kidney'),
                       ('KNEE', 'Knee'),
                       ('KNEEF', 'Knee Fluid'),
                       ('KNEEJ', 'Knee Joint'),
                       ('LABIA', 'Labia'),
                       ('LABMA', 'Labia Majora'),
                       ('LABMI', 'Labia Minora'),
                       ('LACRI', 'Lacrimal'),
                       ('LAM', 'Lamella'),
                       ('LARYN', 'Larynx'),
                       ('LEG', 'Leg'),
                       ('LENS', 'Lens'),
                       ('LING', 'Lingual'),
                       ('LINGU', 'Lingula'),
                       ('LIP', 'Lip'),
                       ('LIVER', 'Liver'),
                       ('LMN', 'Lumen'),
                       ('LN', 'Lymph Node'),
                       ('LNG', 'Lymph Node, Groin'),
                       ('LOBE', 'Lobe'),
                       ('LOCH', 'Lochia'),
                       ('LUMBA', 'Lumbar'),
                       ('LUNG', 'Lung'),
                       ('LYM', 'Lymphocytes'),
                       ('MAC', 'Macrophages'),
                       ('MALLE', 'Malleolus'),
                       ('MANDI', 'Mandible/Mandibular'),
                       ('MAR', 'Marrow'),
                       ('MAST', 'Mastoid'),
                       ('MAXIL', 'Maxilla/Maxillary'),
                       ('MAXS', 'Maxillary Sinus'),
                       ('MEATU', 'Meatus'),
                       ('MEC', 'Meconium'),
                       ('MEDST', 'Mediastinum'),
                       ('MEDU', 'Medullary'),
                       ('METAC', 'Metacarpal'),
                       ('METAT', 'Metatarsal'),
                       ('MILK', 'Milk, Breast'),
                       ('MITRL', 'Mitral Valve'),
                       ('MOLAR', 'Molar'),
                       ('MONSU', 'Mons Ureteris'),
                       ('MONSV', 'Mons Veneris(Mons Pubis)'),
                       ('MOU', 'Membrane'),
                       ('MOUTH', 'Mouth'),
                       ('MP', 'Mons Pubis'),
                       ('MPB', 'Meninges'),
                       ('MRSA2', 'Mrsa:'),
                       ('MYO', 'Myocardium'),
                       ('NAIL', 'Nail'),
                       ('NAILB', 'Nail Bed'),
                       ('NAILF', 'Nail, Finger'),
                       ('NAILT', 'Nail, Toe'),
                       ('NARES', 'Nares'),
                       ('NASL', 'Nasal'),
                       ('NAVEL', 'Navel'),
                       ('NECK', 'Neck'),
                       ('NERVE', 'Nerve'),
                       ('NIPPL', 'Nipple'),
                       ('NLACR', 'Nasolacrimal'),
                       ('NOS', 'Nose (Nasal Passage)'),
                       ('NOSE', 'Nose'),
                       ('NOSTR', 'Nostril'),
                       ('NP', 'Nasopharyngeal'),
                       ('NSS', 'Nasal Septum'),
                       ('NTRAC', 'Nasotracheal'),
                       ('OCCIP', 'Occipital'),
                       ('OLECR', 'Olecranon'),
                       ('OMEN', 'Omentum'),
                       ('ORBIT', 'Orbit/Orbital'),
                       ('ORO', 'Oropharynx'),
                       ('OSCOX', 'Os coxa (pelvic girdle)'),
                       ('OVARY', 'Ovary'),
                       ('PAFL', 'Pancreatic Fluid'),
                       ('PALAT', 'Palate'),
                       ('PALM', 'Palm'),
                       ('PANAL', 'Perianal/Perirectal'),
                       ('PANCR', 'Pancreas'),
                       ('PARAT', 'Paratracheal'),
                       ('PARIE', 'Parietal'),
                       ('PARON', 'Paronychia'),
                       ('PAROT', 'Parotid'),
                       ('PAS', 'Parasternal'),
                       ('PATEL', 'Patella'),
                       ('PCARD', 'Pericardium'),
                       ('PCLIT', 'Periclitoral'),
                       ('PELV', 'Pelvis'),
                       ('PENIS', 'Penis'),
                       ('PENSH', 'Penile Shaft'),
                       ('PER', 'Peritoneal'),
                       ('PERI', 'Pericardial Fluid'),
                       ('PERIH', 'Perihepatic'),
                       ('PERIN', 'Perineal Abscess'),
                       ('PERIS', 'Perisplenic'),
                       ('PERIT', 'Peritoneum'),
                       ('PERIU', 'Periurethal'),
                       ('PERIV', 'Perivesicular'),
                       ('PERRA', 'Perirectal'),
                       ('PERT', 'Peritoneal Fluid'),
                       ('PHALA', 'Phalanyx'),
                       ('PILO', 'Pilonidal'),
                       ('PINNA', 'Pinna'),
                       ('PLACF', 'Placenta (Fetal Side)'),
                       ('PLACM', 'Placenta (Maternal Side)'),
                       ('PLANT', 'Plantar'),
                       ('PLATH', 'Palate, Hard'),
                       ('PLATS', 'Palate, Soft'),
                       ('PLC', 'Placenta'),
                       ('PLEU', 'Pleural Fluid'),
                       ('PLEUR', 'Pleura'),
                       ('PLR', 'Pleural Fluid (Thoracentesis Fld)'),
                       ('PNEAL', 'Perineal'),
                       ('PNEPH', 'Perinephric'),
                       ('PNM', 'Perineum'),
                       ('POPLI', 'Popliteal'),
                       ('PORBI', 'Periorbital'),
                       ('PREAU', 'Preauricular'),
                       ('PRERE', 'Prerenal'),
                       ('PROS', 'Prostatic Fluid'),
                       ('PRST', 'Prostate Gland'),
                       ('PTONS', 'Peritonsillar'),
                       ('PUBIC', 'Pubic'),
                       ('PUL', 'Pulmonary Artery'),
                       ('RADI', 'Radial'),
                       ('RADIUS', 'Radius'),
                       ('RBC', 'Red Blood Cells'),
                       ('RECTL', 'Rectal'),
                       ('RECTU', 'Rectum'),
                       ('RENL', 'Renal'),
                       ('RIB', 'Rib'),
                       ('RNP', 'Renal Pelvis'),
                       ('RPERI', 'Retroperitoneal'),
                       ('SAC', 'Uterine Cul/De/Sac'),
                       ('SACIL', 'Sacroiliac'),
                       ('SACRA', 'Sacral'),
                       ('SACRO', 'Sacrococcygeal'),
                       ('SACRU', 'Sacrum'),
                       ('SALGL', 'Salivary Gland'),
                       ('SCALP', 'Scalp'),
                       ('SCAPU', 'Scapula/Scapular'),
                       ('SCLAV', 'Supraclavicle/Supraclavicular'),
                       ('SCLER', 'Sclera'),
                       ('SCLV', 'Sub Clavian'),
                       ('SCROT', 'Scrotum/Scrotal'),
                       ('SDP', 'Subdiaphramatic'),
                       ('SEM', 'Seminal Fluid'),
                       ('SEMN', 'Semen'),
                       ('SEPTU', 'Septum/Septal'),
                       ('SEROM', 'Seroma'),
                       ('SGF', 'Subgaleal Fluid'),
                       ('SHIN', 'Shin'),
                       ('SHOL', 'Shoulder'),
                       ('SHOLJ', 'Sholder Joint'),
                       ('SIGMO', 'Sigmoid'),
                       ('SINUS', 'Sinus'),
                       ('SKENE', "Skene's Gland"),
                       ('SKM', 'Skeletal Muscle'),
                       ('SKULL', 'Skull'),
                       ('SOLE', 'Sole'),
                       ('SPCOR', 'Spinal Cord'),
                       ('SPHEN', 'Sphenoid'),
                       ('SPLN', 'Spleen'),
                       ('SPRM', 'Spermatozoa'),
                       ('SPX', 'Supra Cervical'),
                       ('STER', 'Sternum/Sternal'),
                       ('STOM', 'Stoma'),
                       ('STOMA', 'Stomach'),
                       ('STOOLL', 'Liquid Stool'),
                       ('STUMP', 'Stump'),
                       ('SUB', 'Subdural'),
                       ('SUBD', 'Subdural Fluid'),
                       ('SUBM', 'Submandibular'),
                       ('SUBME', 'Submental'),
                       ('SUBPH', 'Subphrenic'),
                       ('SUBX', 'Submaxillary'),
                       ('SUPB', 'Suprapubic Specimen'),
                       ('SUPRA', 'Suprapubic'),
                       ('SWT', 'Sweat'),
                       ('SWTG', 'Sweat Gland'),
                       ('SYN', 'Synovial Fluid'),
                       ('SYNOL', 'Synovial'),
                       ('SYNOV', 'Synovium'),
                       ('TARS', 'Tarsal'),
                       ('TBRON', 'Transbronchial'),
                       ('TCN', 'Transcarina Asp'),
                       ('TDUCT', 'Tear Duct'),
                       ('TEAR', 'Tears'),
                       ('TEMPL', 'Temple'),
                       ('TEMPO', 'Temporal'),
                       ('TESTI', 'Testicle(Testis)'),
                       ('THIGH', 'Thigh'),
                       ('THM', 'Thymus'),
                       ('THORA', 'Thoracentesis'),
                       ('THRB', 'Throat'),
                       ('THUMB', 'Thumb'),
                       ('THYRD', 'Thyroid'),
                       ('TIBIA', 'Tibia'),
                       ('TML', 'Temporal Lobe'),
                       ('TNL', 'Thumbnail'),
                       ('TOE', 'Toe'),
                       ('TOEN', 'Toe Nail'),
                       ('TONG', 'Tongue'),
                       ('TONS', 'Tonsil'),
                       ('TOOTH', 'Tooth'),
                       ('TRCHE', 'Trachea/Tracheal'),
                       ('TSK', 'Tooth Socket'),
                       ('ULNA', 'Ulna/Ulnar'),
                       ('UMB', 'Umbilical Blood'),
                       ('UMBL', 'Umbilicus'),
                       ('URET', 'Ureter'),
                       ('URTH', 'Urethra'),
                       ('USTOM', 'Stoma, Urinary'),
                       ('UTER', 'Uterus'),
                       ('UTERI', 'Uterine'),
                       ('VAGIN', 'Vagina/Vaginal'),
                       ('VAL', 'Valve'),
                       ('VAS', 'Vas Deferens'),
                       ('VASTL', 'Vastus Lateralis'),
                       ('VAULT', 'Vault'),
                       ('VCSF', 'Ventricular CSF'),
                       ('VCUFF', 'Vaginal Cuff'),
                       ('VEIN', 'Vein'),
                       ('VENTG', 'Ventragluteal'),
                       ('VERMI', 'Vermis Cerebelli'),
                       ('VERTC', 'Vertebra, cervical'),
                       ('VERTL', 'Vertebra, lumbar'),
                       ('VERTT', 'Vertebra, thoracic'),
                       ('VESCL', 'Vesicular'),
                       ('VESFLD', 'Vesicular Fluid'),
                       ('VESI', 'Vesicle'),
                       ('VESTI', 'Vestibule(Genital)'),
                       ('VGV', 'Vaginal Vault'),
                       ('VITR', 'Vitreous Fluid'),
                       ('VOC', 'Vocal Cord'),
                       ('VULVA', 'Vulva'),
                       ('WBC', 'Leukocytes'),
                       ('WRIST', 'Wrist')))}
