# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2015, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

TABLES = {'HL70001': ('Administrative sex',
                      (('A', 'Ambiguous'),
                       ('F', 'Female'),
                       ('M', 'Male'),
                       ('N', 'Not applicable'),
                       ('O', 'Other'),
                       ('U', 'Unknown'))),
          'HL70002': ('Marital status',
                      (('A', 'Separated'),
                       ('B', 'Unmarried'),
                       ('C', 'Common law'),
                       ('D', 'Divorced'),
                       ('E', 'Legally Separated'),
                       ('G', 'Living together'),
                       ('I', 'Interlocutory'),
                       ('M', 'Married'),
                       ('N', 'Annulled'),
                       ('O', 'Other'),
                       ('P', 'Domestic partner'),
                       ('R', 'Registered domestic partner'),
                       ('S', 'Single'),
                       ('T', 'Unreported'),
                       ('U', 'Unknown'),
                       ('W', 'Widowed'))),
          'HL70003': ('Event type',
                      (('A01', 'ADT/ACK - Admit/visit notification'),
                       ('A02', 'ADT/ACK - Transfer a patient'),
                       ('A03', 'ADT/ACK - Discharge/end visit'),
                       ('A04', 'ADT/ACK - Register a patient'),
                       ('A05', 'ADT/ACK - Pre-admit a patient'),
                       ('A06', 'ADT/ACK - Change an outpatient to an inpatient'),
                       ('A07', 'ADT/ACK - Change an inpatient to an outpatient'),
                       ('A08', 'ADT/ACK - Update patient information'),
                       ('A09', 'ADT/ACK - Patient departing - tracking'),
                       ('A10', 'ADT/ACK - Patient arriving - tracking'),
                       ('A11', 'ADT/ACK - Cancel admit/visit notification'),
                       ('A12', 'ADT/ACK - Cancel transfer'),
                       ('A13', 'ADT/ACK - Cancel discharge/end visit'),
                       ('A14', 'ADT/ACK - Pending admit'),
                       ('A15', 'ADT/ACK - Pending transfer'),
                       ('A16', 'ADT/ACK - Pending discharge'),
                       ('A17', 'ADT/ACK - Swap patients'),
                       ('A18',
                        'ADT/ACK - Merge patient information (for backward compatibility only)'),
                       ('A19', 'QRY/ADR - Patient query'),
                       ('A20', 'ADT/ACK - Bed status update'),
                       ('A21', 'ADT/ACK - Patient goes on a "leave of absence"'),
                       ('A22', 'ADT/ACK - Patient returns from a "leave of absence"'),
                       ('A23', 'ADT/ACK - Delete a patient record'),
                       ('A24', 'ADT/ACK - Link patient information'),
                       ('A25', 'ADT/ACK - Cancel pending discharge'),
                       ('A26', 'ADT/ACK - Cancel pending transfer'),
                       ('A27', 'ADT/ACK - Cancel pending admit'),
                       ('A28', 'ADT/ACK - Add person information'),
                       ('A29', 'ADT/ACK - Delete person information'),
                       ('A30',
                        'ADT/ACK - Merge person information (for backward compatibility only)'),
                       ('A31', 'ADT/ACK - Update person information'),
                       ('A32', 'ADT/ACK - Cancel patient arriving - tracking'),
                       ('A33', 'ADT/ACK - Cancel patient departing - tracking'),
                       ('A34',
                        'ADT/ACK - Merge patient information - patient ID only (for backward compatibility only)'),
                       ('A35',
                        'ADT/ACK - Merge patient information - account number only (for backward compatibility only)'),
                       ('A36',
                        'ADT/ACK - Merge patient information - patient ID and account number (for backward '
                        'compatibility only)'),
                       ('A37', 'ADT/ACK - Unlink patient information'),
                       ('A38', 'ADT/ACK - Cancel pre-admit'),
                       ('A39',
                        'ADT/ACK - Merge person - patient ID (for backward compatibility only)'),
                       ('A40', 'ADT/ACK - Merge patient - patient identifier list'),
                       ('A41', 'ADT/ACK - Merge account - patient account number'),
                       ('A42', 'ADT/ACK - Merge visit - visit number'),
                       ('A43',
                        'ADT/ACK - Move patient information - patient identifier list'),
                       ('A44',
                        'ADT/ACK - Move account information - patient account number'),
                       ('A45', 'ADT/ACK - Move visit information - visit number'),
                       ('A46',
                        'ADT/ACK - Change patient ID (for backward compatibility only)'),
                       ('A47', 'ADT/ACK - Change patient identifier list'),
                       ('A48',
                        'ADT/ACK - Change alternate patient ID (for backward compatibility only)'),
                       ('A49', 'ADT/ACK - Change patient account number'),
                       ('A50', 'ADT/ACK - Change visit number'),
                       ('A51', 'ADT/ACK - Change alternate visit ID'),
                       ('A52', 'ADT/ACK - Cancel leave of absence for a patient'),
                       ('A53',
                        'ADT/ACK - Cancel patient returns from a leave of absence'),
                       ('A54', 'ADT/ACK - Change attending doctor'),
                       ('A55', 'ADT/ACK - Cancel change attending doctor'),
                       ('A60', 'ADT/ACK - Update allergy information'),
                       ('A61', 'ADT/ACK - Change consulting doctor'),
                       ('A62', 'ADT/ACK - Cancel change consulting doctor'),
                       ('B01', 'PMU/ACK - Add personnel record'),
                       ('B02', 'PMU/ACK - Update personnel record'),
                       ('B03', 'PMU/ACK - Delete personnel re cord'),
                       ('B04', 'PMU/ACK - Active practicing person'),
                       ('B05', 'PMU/ACK - Deactivate practicing person'),
                       ('B06', 'PMU/ACK - Terminate practicing person'),
                       ('C01', 'CRM - Register a patient on a clinical trial'),
                       ('C02',
                        'CRM - Cancel a patient registration on clinical trial (for clerical mistakes only)'),
                       ('C03', 'CRM - Correct/update registration information'),
                       ('C04', 'CRM - Patient has gone off a clinical trial'),
                       ('C05', 'CRM - Patient enters phase of clinical trial'),
                       ('C06',
                        'CRM - Cancel patient entering a phase (clerical mistake)'),
                       ('C07', 'CRM - Correct/update phase information'),
                       ('C08', 'CRM - Patient has gone off phase of clinical trial'),
                       ('C09',
                        'CSU - Automated time intervals for reporting, like monthly'),
                       ('C10', 'CSU - Patient completes the clinical trial'),
                       ('C11',
                        'CSU - Patient completes a phase of the clinical trial'),
                       ('C12',
                        'CSU - Update/correction of patient order/result information'),
                       ('I01', 'RQI/RPI - Request for insurance information'),
                       ('I02',
                        'RQI/RPL - Request/receipt of patient selection display list'),
                       ('I03', 'RQI/RPR - Request/receipt of patient selection list'),
                       ('I04', 'RQD/RPI - Request for patient demographic data'),
                       ('I05', 'RQC/RCI - Request for patient clinical information'),
                       ('I06', 'RQC/RCL - Request/receipt of clinical data listing'),
                       ('I07', 'PIN/ACK - Unsolicited insurance information'),
                       ('I08',
                        'RQA/RPA - Request for treatment authorization information'),
                       ('I09',
                        'RQA/RPA - Request for modification to an authorization'),
                       ('I10',
                        'RQA/RPA - Request for resubmission of an authorization'),
                       ('I11',
                        'RQA/RPA - Request for cancellation of an authorization'),
                       ('I12', 'REF/RRI - Patient referral'),
                       ('I13', 'REF/RRI - Modify patient referral'),
                       ('I14', 'REF/RRI - Cancel patient referral'),
                       ('I15', 'REF/RRI - Request patient referral status'),
                       ('J01', 'QCN/ACK - Cancel query/acknowledge message'),
                       ('J02', 'QSX/ACK - Cancel subscription/acknowledge message'),
                       ('K21', 'RSP - Get person demographics response'),
                       ('K22', 'RSP - Find candidates response'),
                       ('K23', 'RSP - Get corresponding identifiers response'),
                       ('K24', 'RSP - Allocate identifiers response'),
                       ('K25', 'RSP - Personnel Information by Segment Response'),
                       ('M01',
                        'MFN/MFK - Master file not otherwise specified (for backward compatibility only)'),
                       ('M02', 'MFN/MFK - Master file - staff practitioner'),
                       ('M03',
                        'MFN/MFK - Master file - test/observation (for backward compatibility only)'),
                       ('M04', 'MFN/MFK - Master files charge description'),
                       ('M05', 'MFN/MFK - Patient location master file'),
                       ('M06',
                        'MFN/MFK - Clinical study with phases and schedules master file'),
                       ('M07',
                        'MFN/MFK - Clinical study without phases but with schedules master file'),
                       ('M08', 'MFN/MFK - Test/observation (numeric) master file'),
                       ('M09',
                        'MFN/MFK - Test/observation (categorical) master file'),
                       ('M10', 'MFN/MFK - Test /observation batteries master file'),
                       ('M11', 'MFN/MFK - Test/calculated observations master file'),
                       ('M12', 'MFN/MFK - Master file notification message'),
                       ('N01', 'NMQ/NMR - Application management query message'),
                       ('N02',
                        'NMD/ACK - Application management data message (unsolicited)'),
                       ('O01', 'ORM - Order message (also RDE, RDS, RGV, RAS)'),
                       ('O02', 'ORR - Order response (also RRE, RRD, RRG, RRA)'),
                       ('O03', 'OMD - Diet order'),
                       ('O04', 'ORD - Diet order acknowledgement'),
                       ('O05', 'OMS - Stock requisition order'),
                       ('O06', 'ORS - Stock requisition acknowledgement'),
                       ('O07', 'OMN - Non-stock requisition order'),
                       ('O08', 'ORN - Non-stock requisition acknowledgement'),
                       ('O09', 'OMP - Pharmacy/treatment order'),
                       ('O10', 'ORP - Pharmacy/treatment order acknowledgement'),
                       ('O11', 'RDE - Pharmacy/treatment encoded order'),
                       ('O12',
                        'RRE - Pharmacy/treatment encoded order acknowledgement'),
                       ('O13', 'RDS - Pharmacy/treatment dispense'),
                       ('O14', 'RRD - Pharmacy/treatment dispense acknowledgement'),
                       ('O15', 'RGV - Pharmacy/treatment give'),
                       ('O16', 'RRG - Pharmacy/treatment give acknowledgement'),
                       ('O17', 'RAS - Pharmacy/treatment administration'),
                       ('O18',
                        'RRA - Pharmacy/treatment administration acknowledgement'),
                       ('O19', 'OMG - General clinical order'),
                       ('O20', 'ORG/ORL - General clinical order response'),
                       ('O21', 'OML - Laboratory order'),
                       ('P01', 'BAR/ACK - Add patient accounts'),
                       ('P02', 'BAR/ACK - Purge patient accounts'),
                       ('P03', 'DFT/ACK - Post detail financial transaction'),
                       ('P04', 'QRY/DSP - Generate bill and A/R statements'),
                       ('P05', 'BAR/ACK - Update account'),
                       ('P06', 'BAR/ACK - End account'),
                       ('P07',
                        'PEX - Unsolicited initial individual product experience report'),
                       ('P08',
                        'PEX - Unsolicited update individual product experience report'),
                       ('P09', 'SUR - Summary product experience report'),
                       ('P10',
                        'BAR/ACK -Transmit Ambulatory Payment Classification(APC)'),
                       ('PC1', 'PPR - PC/ problem add'),
                       ('PC2', 'PPR - PC/ problem update'),
                       ('PC3', 'PPR - PC/ problem delete'),
                       ('PC4', 'QRY - PC/ problem query'),
                       ('PC5', 'PRR - PC/ problem response'),
                       ('PC6', 'PGL - PC/ goal add'),
                       ('PC7', 'PGL - PC/ goal update'),
                       ('PC8', 'PGL - PC/ goal delete'),
                       ('PC9', 'QRY - PC/ goal query'),
                       ('PCA', 'PPV - PC/ goal response'),
                       ('PCB', 'PPP - PC/ pathway (problem-oriented) add'),
                       ('PCC', 'PPP - PC/ pathway (problem-oriented) update'),
                       ('PCD', 'PPP - PC/ pathway (problem-oriented) delete'),
                       ('PCE', 'QRY - PC/ pathway (problem-oriented) query'),
                       ('PCF', 'PTR - PC/ pathway (problem-oriented) query response'),
                       ('PCG', 'PPG - PC/ pathway (goal-oriented) add'),
                       ('PCH', 'PPG - PC/ pathway (goal-oriented) update'),
                       ('PCJ', 'PPG - PC/ pathway (goal-oriented) delete'),
                       ('PCK', 'QRY - PC/ pathway (goal-oriented) query'),
                       ('PCL', 'PPT - PC/ pathway (goal-oriented) query response'),
                       ('Q01', 'QRY/DSR - Query sent for immediate response'),
                       ('Q02', 'QRY/QCK - Query sent for deferred response'),
                       ('Q03', 'DSR/ACK - Deferred response to a query'),
                       ('Q04', 'EQQ - Embedded query language query'),
                       ('Q05', 'UDM/ACK - Unsolicited display update message'),
                       ('Q06', 'OSQ/OSR - Query for order status'),
                       ('Q07', 'VQQ - Virtual table query'),
                       ('Q08', 'SPQ - Stored procedure request'),
                       ('Q09', 'RQQ - event replay query'),
                       ('Q16', 'QSB - Create subscription'),
                       ('Q17', 'QVR - Query for previous events'),
                       ('Q21', 'QBP - Get person demographics'),
                       ('Q22', 'QBP - Find candidates'),
                       ('Q23', 'QBP - Get corresponding identifiers'),
                       ('Q24', 'QBP - Allocate identifiers'),
                       ('Q25', 'QBP - Personnel Information by Segment Query'),
                       ('R01',
                        'ORU/ACK - Unsolicited transmission of an observation message'),
                       ('R02', 'QRY - Query for results of observation'),
                       ('R03',
                        'QRY/DSR Display-oriented results, query/unsol. update (for backward compatibility only) '
                        '(Replaced by Q05)'),
                       ('R04',
                        'ORF - Response to query; transmission of requested observation'),
                       ('R05', 'QRY/DSR - query for display results (See Q01)'),
                       ('R06', 'UDM - unsolicited update/display results (See Q05)'),
                       ('R07', 'EDR - enhanced display response'),
                       ('R08', 'TBR - tabular data response'),
                       ('R09', 'ERP - event replay response'),
                       ('R21', 'OUL - Unsolicited laboratory observation'),
                       ('RAR',
                        'RAR - Pharmacy administration information query response'),
                       ('RDR', 'RDR - Pharmacy dispense information query response'),
                       ('RER',
                        'RER - Pharmacy encoded order information query response'),
                       ('RGR', 'RGR - Pharmacy dose information query response'),
                       ('ROR', 'ROR - Pharmacy prescription order query response'),
                       ('S01', 'SRM/SRR - Request new appointment booking'),
                       ('S02', 'SRM/SRR - Request appointment rescheduling'),
                       ('S03', 'SRM/SRR - Request appointment modification'),
                       ('S04', 'SRM/SRR - Request appointment cancellation'),
                       ('S05', 'SRM/SRR - Request appointment discontinuation'),
                       ('S06', 'SRM/SRR - Request appointment deletion'),
                       ('S07',
                        'SRM/SRR - Request addition of service/resource on appointment'),
                       ('S08',
                        'SRM/SRR - Request modification of service/resource on appointment'),
                       ('S09',
                        'SRM/SRR - Request cancellation of service/resource on appointment'),
                       ('S10',
                        'SRM/SRR - Request discontinuation of service/resource on appointment'),
                       ('S11',
                        'SRM/SRR - Request deletion of service/resource on appointment'),
                       ('S12', 'SIU/ACK - Notification of new appointment booking'),
                       ('S13', 'SIU/ACK - Notification of appointment rescheduling'),
                       ('S14', 'SIU/ACK - Notification of appointment modification'),
                       ('S15', 'SIU/ACK - Notification of appointment cancellation'),
                       ('S16',
                        'SIU/ACK - Notification of appointment discontinuation'),
                       ('S17', 'SIU/ACK - Notification of appointment deletion'),
                       ('S18',
                        'SIU/ACK - Notification of addition of service/resource on appointment'),
                       ('S19',
                        'SIU/ACK - Notification of modification of service/resource on appointment'),
                       ('S20',
                        'SIU/ACK - Notification of cancellation of service/resource on appointment'),
                       ('S21',
                        'SIU/ACK - Notification of discontinuation of service/resource on appointment'),
                       ('S22',
                        'SIU/ACK - Notification of deletion of service/resource on appointment'),
                       ('S23',
                        'SIU/ACK - Notification of blocked schedule time slot(s)'),
                       ('S24',
                        'SIU/ACK - Notification of opened ("unblocked") schedule time slot(s)'),
                       ('S25', 'SQM/SQR - Schedule query message and response'),
                       ('S26',
                        'SIU/ACK Notification that patient did not show up for schedule appointment'),
                       ('T01', 'MDM/ACK - Original document notification'),
                       ('T02',
                        'MDM/ACK - Original document notification and content'),
                       ('T03', 'MDM/ACK - Document status change notification'),
                       ('T04',
                        'MDM/ACK - Document status change notification and content'),
                       ('T05', 'MDM/ACK - Document addendum notification'),
                       ('T06',
                        'MDM/ACK - Document addendum notification and content'),
                       ('T07', 'MDM/ACK - Document edit notification'),
                       ('T08', 'MDM/ACK - Document edit notification and content'),
                       ('T09', 'MDM/ACK - Document replacement notification'),
                       ('T10',
                        'MDM/ACK - Document replacement notification and content'),
                       ('T11', 'MDM/ACK - Document cancel notification'),
                       ('T12', 'QRY/DOC - Document query'),
                       ('U01', 'ESU/ACK - Automated equipment status update'),
                       ('U02', 'ESR/ACK - Automated equipment status request'),
                       ('U03', 'SSU/ACK - Specimen status update'),
                       ('U04', 'SSR/ACK - specimen status request'),
                       ('U05', 'INU/ACK - Automated equipment inventory update'),
                       ('U06', 'INR/ACK - Automated equipment inventory request'),
                       ('U07', 'EAC/ACK - Automated equipment command'),
                       ('U08', 'EAR/ACK - Automated equipment response'),
                       ('U09', 'EAN/ACK - Automated equipment notification'),
                       ('U10',
                        'TCU/ACK - Automated equipment test code settings update'),
                       ('U11',
                        'TCR/ACK - Automated equipment test code settings request'),
                       ('U12', 'LSU/ACK - Automated equipment log/service update'),
                       ('U13', 'LSR/ACK - Automated equipment log/service request'),
                       ('V01', 'VXQ - Query for vaccination record'),
                       ('V02',
                        'VXX - Response to vaccination query returning multiple PID matches'),
                       ('V03', 'VXR - Vaccination record response'),
                       ('V04', 'VXU - Unsolicited vaccination record update'),
                       ('Varies',
                        'MFQ/MFR - Master files query (use event same as asking for e.g., M05 - location)'),
                       ('W01',
                        'ORU - Waveform result, unsolicited transmission of requested information'),
                       ('W02', 'QRF - Waveform result, response to query'))),
          'HL70004': ('Patient class',
                      (('B', 'Obstetrics'),
                       ('C', 'Commercial Account'),
                       ('E', 'Emergency'),
                       ('I', 'Inpatient'),
                       ('N', 'Not Applicable'),
                       ('O', 'Outpatient'),
                       ('P', 'Preadmit'),
                       ('R', 'Recurring patient'),
                       ('U', 'Unknown'))),
          'HL70005': ('Race',
                      (('1002-5', 'American Indian or Alaska Native'),
                       ('2028-9', 'Asian'),
                       ('2054-5', 'Black or African American'),
                       ('2076-8', 'Native Hawaiian or Other Pacific Islander'),
                       ('2106-3', 'White'),
                       ('2131-1', 'Other Race'))),
          'HL70006': ('Religion',
                      (('ABC', 'Christian: American Baptist Church'),
                       ('AGN', 'Agnostic'),
                       ('AME', 'Christian: African Methodist Episcopal Zion'),
                       ('AMT', 'Christian: African Methodist Episcopal'),
                       ('ANG', 'Christian: Anglican'),
                       ('AOG', 'Christian: Assembly of God'),
                       ('ATH', 'Atheist'),
                       ('BAH', "Baha'i"),
                       ('BAP', 'Christian: Baptist'),
                       ('BMA', 'Buddhist: Mahayana'),
                       ('BOT', 'Buddhist: Other'),
                       ('BTA', 'Buddhist: Tantrayana'),
                       ('BTH', 'Buddhist: Theravada'),
                       ('BUD', 'Buddhist'),
                       ('CAT', 'Christian: Roman Catholic'),
                       ('CFR', 'Chinese Folk Religionist'),
                       ('CHR', 'Christian'),
                       ('CHS', 'Christian: Christian Science'),
                       ('CMA', 'Christian: Christian Missionary Alliance'),
                       ('CNF', 'Confucian'),
                       ('COC', 'Christian: Church of Christ'),
                       ('COG', 'Christian: Church of God'),
                       ('COI', 'Christian: Church of God in Christ'),
                       ('COL', 'Christian: Congregational'),
                       ('COM', 'Christian: Community'),
                       ('COP', 'Christian: Other Pentecostal'),
                       ('COT', 'Christian: Other'),
                       ('CRR', 'Christian: Christian Reformed'),
                       ('EOT', 'Christian: Eastern Orthodox'),
                       ('EPI', 'Christian: Episcopalian'),
                       ('ERL', 'Ethnic Religionist'),
                       ('EVC', 'Christian: Evangelical Church'),
                       ('FRQ', 'Christian: Friends'),
                       ('FWB', 'Christian: Free Will Baptist'),
                       ('GRE', 'Christian: Greek Orthodox'),
                       ('HIN', 'Hindu'),
                       ('HOT', 'Hindu: Other'),
                       ('HSH', 'Hindu: Shaivites'),
                       ('HVA', 'Hindu: Vaishnavites'),
                       ('JAI', 'Jain'),
                       ('JCO', 'Jewish: Conservative'),
                       ('JEW', 'Jewish'),
                       ('JOR', 'Jewish: Orthodox'),
                       ('JOT', 'Jewish: Other'),
                       ('JRC', 'Jewish: Reconstructionist'),
                       ('JRF', 'Jewish: Reform'),
                       ('JRN', 'Jewish: Renewal'),
                       ('JWN', "Christian: Jehovah's Witness"),
                       ('LMS', 'Christian: Lutheran Missouri Synod'),
                       ('LUT', 'Christian: Lutheran'),
                       ('MEN', 'Christian: Mennonite'),
                       ('MET', 'Christian: Methodist'),
                       ('MOM', 'Christian: Latter-day Saints'),
                       ('MOS', 'Muslim'),
                       ('MOT', 'Muslim: Other'),
                       ('MSH', 'Muslim: Shiite'),
                       ('MSU', 'Muslim: Sunni'),
                       ('NAM', 'Native American'),
                       ('NAZ', 'Christian: Church of the Nazarene'),
                       ('NOE', 'Nonreligious'),
                       ('NRL', 'New Religionist'),
                       ('ORT', 'Christian: Orthodox'),
                       ('OTH', 'Other'),
                       ('PEN', 'Christian: Pentecostal'),
                       ('PRC', 'Christian: Other Protestant'),
                       ('PRE', 'Christian: Presbyterian'),
                       ('PRO', 'Christian: Protestant'),
                       ('QUA', 'Christian: Friends'),
                       ('REC', 'Christian: Reformed Church'),
                       ('REO', 'Christian: Reorganized Church of Jesus Christ-LDS'),
                       ('SAA', 'Christian: Salvation Army'),
                       ('SEV', 'Christian: Seventh Day Adventist'),
                       ('SHN', 'Shintoist'),
                       ('SIK', 'Sikh'),
                       ('SOU', 'Christian: Southern Baptist'),
                       ('SPI', 'Spiritist'),
                       ('UCC', 'Christian: United Church of Christ'),
                       ('UMD', 'Christian: United Methodist'),
                       ('UNI', 'Christian: Unitarian'),
                       ('UNU', 'Christian: Unitarian Universalist'),
                       ('VAR', 'Unknown'),
                       ('WES', 'Christian: Wesleyan'),
                       ('WMC', 'Christian: Wesleyan Methodist'))),
          'HL70007': ('Admission type',
                      (('A', 'Accident'),
                       ('C', 'Elective'),
                       ('E', 'Emergency'),
                       ('L', 'Labor and Delivery'),
                       ('N', 'Newborn (Birth in healthcare facility)'),
                       ('R', 'Routine'),
                       ('U', 'Urgent'))),
          'HL70008': ('Acknowledgment code',
                      (('AA',
                        'Original mode: Application Accept - Enhanced mode: Application acknowledgment: Accept'),
                       ('AE',
                        'Original mode: Application Error - Enhanced mode: Application acknowledgment: Error'),
                       ('AR',
                        'Original mode: Application Reject - Enhanced mode: Application acknowledgment: Reject'),
                       ('CA', 'Enhanced mode: Accept acknowledgment: Commit Accept'),
                       ('CE', 'Enhanced mode: Accept acknowledgment: Commit Error'),
                       ('CR', 'Enhanced mode: Accept acknowledgment: Commit Reject'))),
          'HL70009': ('Ambulatory status',
                      (('A0', 'No functional limitations'),
                       ('A1', 'Ambulates with assistive device'),
                       ('A2', 'Wheelchair/stretcher bound'),
                       ('A3', 'Comatose; non-responsive'),
                       ('A4', 'Disoriented'),
                       ('A5', 'Vision impaired'),
                       ('A6', 'Hearing impaired'),
                       ('A7', 'Speech impaired'),
                       ('A8', 'Non-English speaking'),
                       ('A9', 'Functional level unknown'),
                       ('B1', 'Oxygen therapy'),
                       ('B2', 'Special equipment (tubes, IVs, catheters)'),
                       ('B3', 'Amputee'),
                       ('B4', 'Mastectomy'),
                       ('B5', 'Paraplegic'),
                       ('B6', 'Pregnant'))),
          'HL70017': ('Transaction type',
                      (('AJ', 'Adjustment'),
                       ('CD', 'Credit'),
                       ('CG', 'Charge'),
                       ('CO', 'Co-payment'),
                       ('PY', 'Payment'))),
          'HL70023': ('Admit source',
                      (('1', 'Physician referral'),
                       ('2', 'Clinic referral'),
                       ('3', 'HMO referral'),
                       ('4', 'Transfer from a hospital'),
                       ('5', 'Transfer from a skilled nursing facility'),
                       ('6', 'Transfer from another health care facility'),
                       ('7', 'Emergency room'),
                       ('8', 'Court/law enforcement'),
                       ('9', 'Information not available'))),
          'HL70027': ('Priority',
                      (('A', 'As soon as possible (a priority lower than stat)'),
                       ('P', 'Preoperative (to be done prior to surgery)'),
                       ('R', 'Routine'),
                       ('S', 'Stat (do immediately)'),
                       ('T',
                        'Timing critical (do as near as possible to requested time)'))),
          'HL70038': ('Order status',
                      (('A', 'Some, but not all, results available'),
                       ('CA', 'Order was canceled'),
                       ('CM', 'Order is completed'),
                       ('DC', 'Order was discontinued'),
                       ('ER', 'Error, order not found'),
                       ('HD', 'Order is on hold'),
                       ('IP', 'In process, unspecified'),
                       ('RP', 'Order has been replaced'),
                       ('SC', 'In process, scheduled'))),
          'HL70043': ('Condition code',
                      (('01', 'Military service related'),
                       ('02', 'Condition is employment related'),
                       ('03', 'Patient covered by insurance not reflected here'),
                       ('04', 'HMO enrollee'),
                       ('05', 'Lien has been filed'),
                       ('06',
                        'ESRD patient in first 18 months of entitlement covered by employer group health insurance'),
                       ('07',
                        'Treatment of non-terminal condition for hospice patient'),
                       ('08',
                        'Beneficiary would not provide information concerning other insurance coverage'),
                       ('09', 'Neither patient nor spouse is employed'),
                       ('10', 'Patient and/or spouse is employed but no EGHP exists'),
                       ('11', 'Disabled beneficiary but no LGHP'),
                       ('12 ... 16', 'Payer codes.'),
                       ('18', 'Maiden name retained'),
                       ('19', "Child retains mother's name"),
                       ('20', 'Beneficiary requested billing'),
                       ('21', 'Billing for Denial Notice'),
                       ('26',
                        'VA eligible patient chooses to receive services in a Medicare certified facility'),
                       ('27',
                        'Patient referred to a sole community hospital for a diagnostic laboratory test'),
                       ('28',
                        "Patient and/or spouse's EGHP is secondary to Medicare"),
                       ('29',
                        "Disabled beneficiary and/or family member's LGHP is secondary to Medicare"),
                       ('31', 'Patient is student (full time-day)'),
                       ('32', 'Patient is student (cooperative/work study program)'),
                       ('33', 'Patient is student (full time-night)'),
                       ('34', 'Patient is student (Part time)'),
                       ('36', 'General care patient in a special unit'),
                       ('37', 'Ward accommodation as patient request'),
                       ('38', 'Semi-private room not available'),
                       ('39', 'Private room medically necessary'),
                       ('40', 'Same day transfer'),
                       ('41', 'Partial hospitalization'),
                       ('46', 'Non-availability statement on file'),
                       ('48',
                        'Psychiatric residential treatment centers for children and adolescents'),
                       ('55', 'SNF bed not available'),
                       ('56', 'Medical appropriateness'),
                       ('57', 'SNF readmission'),
                       ('60', 'Day outlier'),
                       ('61', 'Cost outlier'),
                       ('62', 'Payer code'),
                       ('66', 'Provider does not wish cost outlier payment'),
                       ('67',
                        'Beneficiary elects not to use life time reserve (LTR) days'),
                       ('68',
                        'Beneficiary elects to use life time reserve (LTR) days'),
                       ('70', 'Self-administered EPO'),
                       ('71', 'Full care in unit'),
                       ('72', 'Self-care in unit'),
                       ('73', 'Self-care training'),
                       ('74', 'Home'),
                       ('75', 'Home - 100% reimbursement'),
                       ('76', 'Back-up in facility dialysis'),
                       ('77',
                        'Provider accepts or is obligated/required due to a contractual arrangement or law to accept '
                        'payment by a primary payer as payment in full'),
                       ('78', 'New coverage not implemented by HMO'),
                       ('79', 'Corf services provided off-site'),
                       ('80', 'Pregnant'))),
          'HL70048': ('What subject filter',
                      (('ADV', 'Advice/diagnosis'),
                       ('ANU',
                        'Nursing unit lookup (returns patients in beds, excluding empty beds)'),
                       ('APA', 'Account number query, return matching visit'),
                       ('APM',
                        'Medical record number query, returns visits for a medical record number'),
                       ('APN', 'Patient name lookup'),
                       ('APP', 'Physician lookup'),
                       ('ARN',
                        'Nursing unit lookup (returns patients in beds, including empty beds)'),
                       ('CAN', 'Cancel. Used to cancel a query'),
                       ('DEM', 'Demographics'),
                       ('FIN', 'Financial'),
                       ('GID', 'Generate new identifier'),
                       ('GOL', 'Goals'),
                       ('MRI', 'Most recent inpatient'),
                       ('MRO', 'Most recent outpatient'),
                       ('NCK', 'Network clock'),
                       ('NSC', 'Network status change'),
                       ('NST', 'Network statistic'),
                       ('ORD', 'Order'),
                       ('OTH', 'Other'),
                       ('PRB', 'Problems'),
                       ('PRO', 'Procedure'),
                       ('RAR', 'Pharmacy administration information'),
                       ('RDR', 'Pharmacy dispense information'),
                       ('RER', 'Pharmacy encoded order information'),
                       ('RES', 'Result'),
                       ('RGR', 'Pharmacy give information'),
                       ('ROR', 'Pharmacy prescription information'),
                       ('SAL',
                        'All schedule related information, including open slots, booked slots, blocked slots'),
                       ('SBK', 'Booked slots on the identified schedule'),
                       ('SBL', 'Blocked slots on the identified schedule'),
                       ('SOF',
                        'First open slot on the identified schedule after the start date/time'),
                       ('SOP', 'Open slots on the identified schedule'),
                       ('SSA', 'Time slots available for a single appointment'),
                       ('SSR', 'Time slots available for a recurring appointment'),
                       ('STA', 'Status'),
                       ('VXI', 'Vaccine Information'),
                       ('XID', 'Get cross-referenced identifiers'))),
          'HL70052': ('Diagnosis type',
                      (('A', 'Admitting'), ('F', 'Final'), ('W', 'Working'))),
          'HL70061': ('Check digit scheme',
                      (('ISO', 'ISO 7064: 1983'),
                       ('M10', 'Mod 10 algorithm'),
                       ('M11', 'Mod 11 algorithm'),
                       ('NPI',
                        'Check digit algorithm in the US National Provider Identifier'))),
          'HL70062': ('Event reason',
                      (('01', 'Patient request'),
                       ('02', 'Physician/health practitioner order'),
                       ('03', 'Census management'))),
          'HL70063': ('Relationship',
                      (('ASC', 'Associate'),
                       ('BRO', 'Brother'),
                       ('CGV', 'Care giver'),
                       ('CHD', 'Child'),
                       ('DEP', 'Handicapped dependent'),
                       ('DOM', 'Life partner'),
                       ('EMC', 'Emergency contact'),
                       ('EME', 'Employee'),
                       ('EMR', 'Employer'),
                       ('EXF', 'Extended family'),
                       ('FCH', 'Foster child'),
                       ('FND', 'Friend'),
                       ('FTH', 'Father'),
                       ('GCH', 'Grandchild'),
                       ('GRD', 'Guardian'),
                       ('GRP', 'Grandparent'),
                       ('MGR', 'Manager'),
                       ('MTH', 'Mother'),
                       ('NCH', 'Natural child'),
                       ('NON', 'None'),
                       ('OAD', 'Other adult'),
                       ('OTH', 'Other'),
                       ('OWN', 'Owner'),
                       ('PAR', 'Parent'),
                       ('SCH', 'Stepchild'),
                       ('SEL', 'Self'),
                       ('SIB', 'Sibling'),
                       ('SIS', 'Sister'),
                       ('SPO', 'Spouse'),
                       ('TRA', 'Trainer'),
                       ('UNK', 'Unknown'),
                       ('WRD', 'Ward of court'))),
          'HL70065': ('Specimen action code',
                      (('A', 'Add ordered tests to the existing specimen'),
                       ('G', 'Generated order; reflex order'),
                       ('L', 'Lab to obtain specimen from patient'),
                       ('O', 'Specimen obtained by service other than Lab'),
                       ('P', 'Pending specimen; Order sent prior to delivery'),
                       ('R', 'Revised order'),
                       ('S', 'Schedule the tests specified below'))),
          'HL70066': ('Employment status',
                      (('1', 'Full time employed'),
                       ('2', 'Part time employed'),
                       ('3', 'Unemployed'),
                       ('4', 'Self-employed,'),
                       ('5', 'Retired'),
                       ('6', 'On active military duty'),
                       ('9', 'Unknown'),
                       ('C', 'Contract, per diem'),
                       ('D', 'Per Diem'),
                       ('F', 'Full Time'),
                       ('L',
                        'Leave of absence (e.g. Family leave, sabbatical, etc.)'),
                       ('O', 'Other'),
                       ('P', 'Part Time'),
                       ('T', 'Temporarily unemployed'))),
          'HL70069': ('Hospital service',
                      (('CAR', 'Cardiac Service'),
                       ('MED', 'Medical Service'),
                       ('PUL', 'Pulmonary Service'),
                       ('SUR', 'Surgical Service'),
                       ('URO', 'Urology Service'))),
          'HL70070': ('Specimen source codes',
                      (('ABS', 'Abscess'),
                       ('AMN', 'Amniotic fluid'),
                       ('ASP', 'Aspirate'),
                       ('BBL', 'Blood bag'),
                       ('BDY', 'Whole body'),
                       ('BIFL', 'Bile fluid'),
                       ('BLD', 'Whole blood'),
                       ('BLDA', 'Blood arterial'),
                       ('BLDC', 'Blood capillary'),
                       ('BLDCO', 'Cord blood'),
                       ('BLDV', 'Blood venous'),
                       ('BON', 'Bone'),
                       ('BPH', 'Basophils'),
                       ('BPU', 'Blood product unit'),
                       ('BRN', 'Burn'),
                       ('BRO', 'Bronchial'),
                       ('BRTH', 'Breath (use EXHLD)'),
                       ('CALC', 'Calculus (=Stone)'),
                       ('CBLD', 'Cord blood'),
                       ('CDM', 'Cardiac muscle'),
                       ('CNJT', 'Conjunctiva'),
                       ('CNL', 'Cannula'),
                       ('COL', 'Colostrum'),
                       ('CSF', 'Cerebral spinal fluid'),
                       ('CTP', 'Catheter tip'),
                       ('CUR', 'Curettage'),
                       ('CVM', 'Cervical mucus'),
                       ('CVX', 'Cervix'),
                       ('CYST', 'Cyst'),
                       ('DIAF', 'Dialysis fluid'),
                       ('DOSE', 'Dose med or substance'),
                       ('DRN', 'Drain'),
                       ('DUFL', 'Duodenal fluid'),
                       ('EAR', 'Ear'),
                       ('EARW', 'Ear wax (cerumen)'),
                       ('ELT', 'Electrode'),
                       ('ENDC', 'Endocardium'),
                       ('ENDM', 'Endometrium'),
                       ('EOS', 'Eosinophils'),
                       ('EXG', 'Exhaled gas (=breath)'),
                       ('EXHLD', 'Exhaled gas (=breath)'),
                       ('EYE', 'Eye'),
                       ('FIB', 'Fibroblasts'),
                       ('FIST', 'Fistula'),
                       ('FLT', 'Filter'),
                       ('FLU', 'Body fluid, unsp'),
                       ('GAS', 'Gas'),
                       ('GAST', 'Gastric fluid/contents'),
                       ('GEN', 'Genital'),
                       ('GENC', 'Genital cervix'),
                       ('GENL', 'Genital lochia'),
                       ('GENV', 'Genital vaginal'),
                       ('HAR', 'Hair'),
                       ('IHG', 'Inhaled Gas'),
                       ('ISLT', 'Isolate'),
                       ('IT', 'Intubation tube'),
                       ('LAM', 'Lamella'),
                       ('LIQ', 'Liquid NOS'),
                       ('LN', 'Line'),
                       ('LNA', 'Line arterial'),
                       ('LNV', 'Line venous'),
                       ('LYM', 'Lymphocytes'),
                       ('MAC', 'Macrophages'),
                       ('MAR', 'Marrow'),
                       ('MBLD', 'Menstrual blood'),
                       ('MEC', 'Meconium'),
                       ('MILK', 'Breast milk'),
                       ('MLK', 'Milk'),
                       ('NAIL', 'Nail'),
                       ('NOS', 'Nose (nasal passage)'),
                       ('ORH', 'Other'),
                       ('PAFL', 'Pancreatic fluid'),
                       ('PAT', 'Patient'),
                       ('PLAS', 'Plasma'),
                       ('PLB', 'Plasma bag'),
                       ('PLC', 'Placenta'),
                       ('PLR', 'Pleural fluid (thoracentesis fld)'),
                       ('PMN', 'Polymorphonuclear neutrophils'),
                       ('PPP', 'Platelet poor plasma'),
                       ('PRP', 'Platelet rich plasma'),
                       ('PRT', 'Peritoneal fluid /ascites'),
                       ('PUS', 'Pus'),
                       ('RBC', 'Erythrocytes'),
                       ('RT', 'Route of medicine'),
                       ('SAL', 'Saliva'),
                       ('SEM', 'Seminal fluid'),
                       ('SER', 'Serum'),
                       ('SKM', 'Skeletal muscle'),
                       ('SKN', 'Skin'),
                       ('SMN', 'Seminal fluid'),
                       ('SNV', 'Synovial fluid (Joint fluid)'),
                       ('SPRM', 'Spermatozoa'),
                       ('SPT', 'Sputum'),
                       ('SPTC', 'Sputum - coughed'),
                       ('SPTT', 'Sputum - tracheal aspirate'),
                       ('STL', 'Stool = Fecal'),
                       ('STON', 'Stone (use CALC)'),
                       ('SWT', 'Sweat'),
                       ('TEAR', 'Tears'),
                       ('THRB', 'Thrombocyte (platelet)'),
                       ('THRT', 'Throat'),
                       ('TISG', 'Tissue gall bladder'),
                       ('TISPL', 'Tissue placenta'),
                       ('TISS', 'Tissue'),
                       ('TISU', 'Tissue ulcer'),
                       ('TLGI', 'Tissue large intestine'),
                       ('TLNG', 'Tissue lung'),
                       ('TSMI', 'Tissue small intestine'),
                       ('TUB', 'Tube NOS'),
                       ('ULC', 'Ulcer'),
                       ('UMB', 'Umbilical blood'),
                       ('UMED', 'Unknown medicine'),
                       ('UR', 'Urine'),
                       ('URC', 'Urine clean catch'),
                       ('URNS', 'Urine sediment'),
                       ('URT', 'Urine catheter'),
                       ('URTH', 'Urethra'),
                       ('USUB', 'Unknown substance'),
                       ('VITF', 'Vitreous Fluid'),
                       ('VOM', 'Vomitus'),
                       ('WAT', 'Water'),
                       ('WBC', 'Leukocytes'),
                       ('WICK', 'Wick'),
                       ('WND', 'Wound'),
                       ('WNDA', 'Wound abscess'),
                       ('WNDD', 'Wound drainage'),
                       ('WNDE', 'Wound exudate'),
                       ('XXX', 'To be specified in another part of the message'))),
          'HL70074': ('Diagnostic service section ID',
                      (('AU', 'Audiology'),
                       ('BG', 'Blood Gases'),
                       ('BLB', 'Blood Bank'),
                       ('CH', 'Chemistry'),
                       ('CP', 'Cytopathology'),
                       ('CT', 'CAT Scan'),
                       ('CTH', 'Cardiac Catheterization'),
                       ('CUS', 'Cardiac Ultrasound'),
                       ('EC', 'Electrocardiac (e.g., EKG, EEC, Holter)'),
                       ('EN', 'Electroneuro (EEG, EMG,EP,PSG)'),
                       ('HM', 'Hematology'),
                       ('ICU', 'Bedside ICU Monitoring'),
                       ('IMG', 'Diagnostic Imaging'),
                       ('IMM', 'Immunology'),
                       ('LAB', 'Laboratory'),
                       ('MB', 'Microbiology'),
                       ('MCB', 'Mycobacteriology'),
                       ('MYC', 'Mycology'),
                       ('NMR', 'Nuclear Magnetic Resonance'),
                       ('NMS', 'Nuclear Medicine Scan'),
                       ('NRS', 'Nursing Service Measures'),
                       ('OSL', 'Outside Lab'),
                       ('OT', 'Occupational Therapy'),
                       ('OTH', 'Other'),
                       ('OUS', 'OB Ultrasound'),
                       ('PAR', 'Parasitology'),
                       ('PAT', 'Pathology (gross & histopath, not surgical)'),
                       ('PF', 'Pulmonary function'),
                       ('PHR', 'Pharmacy'),
                       ('PHY', 'Physician (Hx. Dx, admission note, etc.)'),
                       ('PT', 'Physical Therapy'),
                       ('RAD', 'Radiology'),
                       ('RC', 'Respiratory Care (therapy)'),
                       ('RT', 'Radiation therapy'),
                       ('RUS', 'Radiology ultrasound'),
                       ('RX', 'Radiograph'),
                       ('SP', 'Surgical Pathology'),
                       ('SR', 'Serology'),
                       ('TX', 'Toxicology'),
                       ('URN', 'Urinalysis'),
                       ('VR', 'Virology'),
                       ('VUS', 'Vascular Ultrasound'),
                       ('XRC', 'Cineradiograph'))),
          'HL70076': ('Message type',
                      (('ACK', 'General acknowledgment message'),
                       ('ADR', 'ADT response'),
                       ('ADT', 'ADT message'),
                       ('BAR', 'Add/change billing account'),
                       ('CRM', 'Clinical study registration message'),
                       ('CSU', 'Unsolicited study data message'),
                       ('DFT', 'Detail financial transactions'),
                       ('DOC', 'Document response'),
                       ('DSR', 'Display response'),
                       ('EAC', 'Automated equipment command message'),
                       ('EAN', 'Automated equipment notification message'),
                       ('EAR', 'Automated equipment response message'),
                       ('EDR', 'Enhanced display response'),
                       ('EQQ', 'Embedded query language query'),
                       ('ERP', 'Event replay response'),
                       ('ESR',
                        'Automated equipment status update acknowledgement message'),
                       ('ESU', 'Automated equipment status update message'),
                       ('INR', 'Automated equipment inventory request message'),
                       ('INU', 'Automated equipment inventory update message'),
                       ('LSR', 'Automated equipment log/service request message'),
                       ('LSU', 'Automated equipment log/service update message'),
                       ('MCF',
                        'Delayed Acknowledgement (Retained for backward compatibility only)'),
                       ('MDM', 'Medical document management'),
                       ('MFD', 'Master files delayed application acknowledgment'),
                       ('MFK', 'Master files application acknowledgment'),
                       ('MFN', 'Master files notification'),
                       ('MFQ', 'Master files query'),
                       ('MFR', 'Master files response'),
                       ('NMD', 'Application management data message'),
                       ('NMQ', 'Application management query message'),
                       ('NMR', 'Application management response message'),
                       ('OMD', 'Dietary order'),
                       ('OMG', 'General clinical order message'),
                       ('OML', 'Laboratory order message'),
                       ('OMN', 'Non-stock requisition order message'),
                       ('OMP', 'Pharmacy/treatment order message'),
                       ('OMS', 'Stock requisition order message'),
                       ('ORD',
                        'Dietary order - General order acknowledgment message'),
                       ('ORF', 'Query for results of observation'),
                       ('ORG', 'General clinical order acknowledgement message'),
                       ('ORL', 'Laboratory acknowledgement message (unsolicited)'),
                       ('ORM', 'Pharmacy/treatment order message'),
                       ('ORN',
                        'Non-stock requisition - General order acknowledgment message'),
                       ('ORP', 'Pharmacy/treatment order acknowledgement message'),
                       ('ORR', 'General order response message response to any ORM'),
                       ('ORS',
                        'Stock requisition - General order acknowledgment message'),
                       ('ORU', 'Unsolicited transmission of an observation message'),
                       ('OSQ', 'Query response for order status'),
                       ('OSR', 'Query response for order status'),
                       ('OUL', 'Unsolicited laboratory observation message'),
                       ('PEX', 'Product experience message'),
                       ('PGL', 'Patient goal message'),
                       ('PIN', 'Patient insurance information'),
                       ('PMU', 'Add personnel record'),
                       ('PPG', 'Patient pathway message (goal-oriented)'),
                       ('PPP', 'Patient pathway message (problem-oriented)'),
                       ('PPR', 'Patient problem message'),
                       ('PPT', 'Patient pathway goal-oriented response'),
                       ('PPV', 'Patient goal response'),
                       ('PRR', 'Patient problem response'),
                       ('PTR', 'Patient pathway problem-oriented response'),
                       ('QBP', 'Query by parameter'),
                       ('QCK', 'Deferred query'),
                       ('QCN', 'Cancel query'),
                       ('QRY', 'Query, original mode'),
                       ('QSB', 'Create subscription'),
                       ('QSX', 'Cancel subscription/acknowledge message'),
                       ('QVR', 'Query for previous events'),
                       ('RAR', 'Pharmacy/treatment administration information'),
                       ('RAS', 'Pharmacy/treatment administration message'),
                       ('RCI', 'Return clinical information'),
                       ('RCL', 'Return clinical list'),
                       ('RDE', 'Pharmacy/treatment encoded order message'),
                       ('RDR', 'Pharmacy/treatment dispense information'),
                       ('RDS', 'Pharmacy/treatment dispense message'),
                       ('RDY', 'Display based response'),
                       ('REF', 'Patient referral'),
                       ('RER', 'Pharmacy/treatment encoded order information'),
                       ('RGR', 'Pharmacy/treatment dose information'),
                       ('RGV', 'Pharmacy/treatment give message'),
                       ('ROR', 'Pharmacy/treatment order response'),
                       ('RPA', 'Return patient authorization'),
                       ('RPI', 'Return patient information'),
                       ('RPL', 'Return patient display list'),
                       ('RPR', 'Return patient list'),
                       ('RQA', 'Request patient authorization'),
                       ('RQC', 'Request clinical information'),
                       ('RQI', 'Request patient information'),
                       ('RQP', 'Request patient demographics'),
                       ('RQQ', 'Event replay query'),
                       ('RRA',
                        'Pharmacy/treatment administration acknowledgement message'),
                       ('RRD', 'Pharmacy/treatment dispense acknowledgment message'),
                       ('RRE',
                        'Pharmacy/treatment encoded order acknowledgment message'),
                       ('RRG', 'Pharmacy/treatment give acknowledgment message'),
                       ('RRI', 'Return referral information'),
                       ('RSP', 'Segment pattern response'),
                       ('RTB', 'Tabular response'),
                       ('SIU', 'Schedule information unsolicited'),
                       ('SPQ', 'Stored procedure request'),
                       ('SQM', 'Schedule query message'),
                       ('SQR', 'Schedule query response'),
                       ('SRM', 'Schedule request message'),
                       ('SRR', 'Scheduled request response'),
                       ('SSR', 'Specimen status request message'),
                       ('SSU', 'Specimen status update message'),
                       ('SUR', 'Summary product experience report'),
                       ('TBR', 'Tabular data response'),
                       ('TCR',
                        'Automated equipment test code settings request message'),
                       ('TCU',
                        'Automated equipment test code settings update message'),
                       ('UDM', 'Unsolicited display update message'),
                       ('VQQ', 'Virtual table query'),
                       ('VXQ', 'Query for vaccination record'),
                       ('VXR', 'Vaccination record response'),
                       ('VXU', 'Unsolicited vaccination record update'),
                       ('VXX',
                        'Response for vaccination query with multiple PID matches'))),
          'HL70078': ('Abnormal flags',
                      (('<', 'Below absolute low-off instrument scale'),
                       ('>', 'Above absolute high-off instrument scale'),
                       ('A', 'Abnormal (applies to non-numeric results)'),
                       ('AA',
                        'Very abnormal (applies to non-numeric units, analogous to panic limits for numeric units)'),
                       ('B', 'Better--use when direction not relevant'),
                       ('D', 'Significant change down'),
                       ('H', 'Above high normal'),
                       ('HH', 'Above upper panic limits'),
                       ('I', 'Intermediate*'),
                       ('L', 'Below low normal'),
                       ('LL', 'Below lower panic limits'),
                       ('MS', 'Moderately susceptible*'),
                       ('N', 'Normal (applies to non-numeric results)'),
                       ('null', "No range defined, or normal ranges don't apply"),
                       ('R', 'Resistant*'),
                       ('S', 'Susceptible*'),
                       ('U', 'Significant change up'),
                       ('VS', 'Very susceptible*'),
                       ('W', 'Worse--use when direction not relevant'))),
          'HL70080': ('Nature of abnormal testing',
                      (('A', 'An age-based population'),
                       ('N', 'None - generic normal range'),
                       ('R', 'A race-based population'),
                       ('S', 'A sex-based population'))),
          'HL70083': ('Outlier type', (('C', 'Outlier cost'), ('D', 'Outlier days'))),
          'HL70085': ('Observation result status codes interpretation',
                      (('C',
                        'Record coming over is a correction and thus replaces a final result'),
                       ('D', 'Deletes the OBX record'),
                       ('F',
                        'Final results; Can only be changed with a corrected result.'),
                       ('I', 'Specimen in lab; results pending'),
                       ('N',
                        'Not asked; used to affirmatively document that the observation identified in the OBX was '
                        'not sought when the universal service ID in OBR-4 implies that it would be sought.'),
                       ('O', 'Order detail description only (no result)'),
                       ('P', 'Preliminary results'),
                       ('R', 'Results entered -- not verified'),
                       ('S', 'Partial results'),
                       ('U',
                        "Results status change to final without retransmitting results already sent as 'preliminary.' "
                        "E.g., radiology changes status from preliminary to final"),
                       ('W',
                        'Post original as wrong, e.g., transmitted for wrong patient'),
                       ('X', 'Results cannot be obtained for this observation'))),
          'HL70091': ('Query priority', (('D', 'Deferred'), ('I', 'Immediate'))),
          'HL70092': ('Re-admission indicator', (('R', 'Re-admission'),)),
          'HL70093': ('Release information',
                      (('...', 'user-defined codes'), ('N', 'No'), ('Y', 'Yes'))),
          'HL70098': ('Type of agreement',
                      (('M', 'Maternity'), ('S', 'Standard'), ('U', 'Unified'))),
          'HL70100': ('When to charge',
                      (('D', 'On discharge'),
                       ('O', 'On receipt of order'),
                       ('R', 'At time service is completed'),
                       ('S', 'At time service is started'),
                       ('T', 'At a designated date/time'))),
          'HL70102': ('Delayed acknowledgment type',
                      (('D', 'Message received, stored for later processing'),
                       ('F', 'acknowledgment after processing'))),
          'HL70103': ('Processing ID',
                      (('D', 'Debugging'), ('P', 'Production'), ('T', 'Training'))),
          'HL70104': ('Version ID',
                      (('2.0', 'Release 2.0'),
                       ('2.0D', 'Demo 2.0'),
                       ('2.1', 'Release 2. 1'),
                       ('2.2', 'Release 2.2'),
                       ('2.3', 'Release 2.3'),
                       ('2.3.1', 'Release 2.3.1'),
                       ('2.4', 'Release 2.4'))),
          'HL70105': ('Source of comment',
                      (('L', 'Ancillary (filler) department is source of comment'),
                       ('O', 'Other system is source of comment'),
                       ('P', 'Orderer (placer) is source of comment'))),
          'HL70106': ('Query/response format code',
                      (('D', 'Response is in display format'),
                       ('R', 'Response is in record-oriented format'),
                       ('T', 'Response is in tabular format'))),
          'HL70107': ('Deferred response type',
                      (('B', 'Before the Date/Time specified'),
                       ('L', 'Later than the Date/Time specified'))),
          'HL70108': ('Query results level',
                      (('O', 'Order plus order status'),
                       ('R', 'Results without bulk text'),
                       ('S', 'Status only'),
                       ('T', 'Full results'))),
          'HL70109': ('Report priority', (('R', 'Routine'), ('S', 'Stat'))),
          'HL70112': ('Discharge disposition',
                      (('01', 'Discharged to home or self care (routine discharge)'),
                       ('02',
                        'Discharged/transferred to another short term general hospital for inpatient care'),
                       ('03',
                        'Discharged/transferred to skilled nursing facility (SNF)'),
                       ('04',
                        'Discharged/transferred to an intermediate care facility (ICF)'),
                       ('05',
                        'Discharged/transferred to another type of institution for inpatient care or referred for '
                        'outpatient services to another institution'),
                       ('06',
                        'Discharged/transferred to home under care of organized home health service organization'),
                       ('07', 'Left against medical advice or discontinued care'),
                       ('08',
                        'Discharged/transferred to home under care of Home IV provider'),
                       ('09', 'Admitted as an inpatient to this hospital'),
                       ('10 ...19',
                        'Discharge to be defined at state level, if necessary'),
                       ('20', 'Expired (i.e. dead)'),
                       ('21 ... 29',
                        'Expired to be defined at state level, if necessary'),
                       ('30',
                        'Still patient or expected to return for outpatient services (i.e. still a patient)'),
                       ('31 ... 39',
                        'Still patient to be defined at state level, if necessary (i.e. still a patient)'),
                       ('40', 'Expired (i.e. died) at home'),
                       ('41',
                        'Expired (i.e. died) in a medical facility; e.g., hospital, SNF, ICF, or free standing '
                        'hospice'),
                       ('42', 'Expired (i.e. died) - place unknown'))),
          'HL70116': ('Bed status',
                      (('C', 'Closed'),
                       ('H', 'Housekeeping'),
                       ('I', 'Isolated'),
                       ('K', 'Contaminated'),
                       ('O', 'Occupied'),
                       ('U', 'Unoccupied'))),
          'HL70121': ('Response flag',
                      (('D', 'Same as R, also other associated segments'),
                       ('E', 'Report exceptions only'),
                       ('F', 'Same as D, plus confirmations explicitly'),
                       ('N', 'Only the MSA segment is returned'),
                       ('R', 'Same as E, also Replacement and Parent-Child'))),
          'HL70122': ('Charge type',
                      (('CH', 'Charge'),
                       ('CO', 'Contract'),
                       ('CR', 'Credit'),
                       ('DP', 'Department'),
                       ('GR', 'Grant'),
                       ('NC', 'No Charge'),
                       ('PC', 'Professional'),
                       ('RS', 'Research'))),
          'HL70123': ('Result status',
                      (('A', 'Some, but not all, results available'),
                       ('C', 'Correction to results'),
                       ('F',
                        'Final results; results stored and verified. Can only be changed with a corrected result.'),
                       ('I',
                        'No results available; specimen received, procedure incomplete'),
                       ('O', 'Order received; specimen not yet received'),
                       ('P',
                        'Preliminary: A verified early result is available, final results not yet obtained'),
                       ('R', 'Results stored; not yet verified'),
                       ('S',
                        'No results available; procedure scheduled, but not done'),
                       ('X', 'No results available; Order canceled.'),
                       ('Y',
                        'No order on record for this test. (Used only on queries)'),
                       ('Z', 'No record of this patient. (Used only on queries)'))),
          'HL70124': ('Transportation mode',
                      (('CART', 'Cart - patient travels on cart or gurney'),
                       ('PORT', "The examining device goes to patient's location"),
                       ('WALK', 'Patient walks to diagnostic service'),
                       ('WHLC', 'Wheelchair'))),
          'HL70125': ('Value type',
                      (('AD', 'Address'),
                       ('CE', 'Coded Entry'),
                       ('CF', 'Coded Element With Formatted Values'),
                       ('CK', 'Composite ID With Check Digit'),
                       ('CN', 'Composite ID And Name'),
                       ('CP', 'Composite Price'),
                       ('CX', 'Extended Composite ID With Check Digit'),
                       ('DT', 'Date'),
                       ('ED', 'Encapsulated Data'),
                       ('FT', 'Formatted Text (Display)'),
                       ('MO', 'Money'),
                       ('NM', 'Numeric'),
                       ('PN', 'Person Name'),
                       ('RP', 'Reference Pointer'),
                       ('SN', 'Structured Numeric'),
                       ('ST', 'String Data.'),
                       ('TM', 'Time'),
                       ('TN', 'Telephone Number'),
                       ('TS', 'Time Stamp (Date & Time)'),
                       ('TX', 'Text Data (Display)'),
                       ('XAD', 'Extended Address'),
                       ('XCN', 'Extended Composite Name And Number For Persons'),
                       ('XON',
                        'Extended Composite Name And Number For Organizations'),
                       ('XPN', 'Extended Person Name'),
                       ('XTN', 'Extended Telecommunications Number'))),
          'HL70126': ('Quantity limited request',
                      (('CH', 'Characters'),
                       ('LI', 'Lines'),
                       ('PG', 'Pages'),
                       ('RD', 'Records'),
                       ('ZO', 'Locally defined'))),
          'HL70127': ('Allergen type',
                      (('AA', 'Animal Allergy'),
                       ('DA', 'Drug allergy'),
                       ('EA', 'Environmental Allergy'),
                       ('FA', 'Food allergy'),
                       ('LA', 'Pollen Allergy'),
                       ('MA', 'Miscellaneous allergy'),
                       ('MC', 'Miscellaneous contraindication'),
                       ('PA', 'Plant Allergy'))),
          'HL70128': ('Allergy severity',
                      (('MI', 'Mild'),
                       ('MO', 'Moderate'),
                       ('SV', 'Severe'),
                       ('U', 'Unknown'))),
          'HL70130': ('Visit user code',
                      (('HO', 'Home'),
                       ('MO', 'Mobile Unit'),
                       ('PH', 'Phone'),
                       ('TE', 'Teaching'))),
          'HL70133': ('Procedure practitioner identifier code type',
                      (('AN', 'Anesthesiologist/Anesthetist'),
                       ('AS', 'Assistant Surgeon'),
                       ('CM', 'Certified Nurse Midwife'),
                       ('NP', 'Nurse Practitioner'),
                       ('PR', 'Procedure MD/ Surgeon'),
                       ('PS', 'Primary Surgeon'),
                       ('RD', 'Radiologist'),
                       ('RS', 'Resident'),
                       ('SN', 'Scrub Nurse'))),
          'HL70135': ('Assignment of benefits',
                      (('M', 'Modified assignment'), ('N', 'No'), ('Y', 'Yes'))),
          'HL70136': ('Yes/no indicator', (('N', 'No'), ('Y', 'Yes'))),
          'HL70137': ('Mail claim party',
                      (('E', 'Employer'),
                       ('G', 'Guarantor'),
                       ('I', 'Insurance company'),
                       ('O', 'Other'),
                       ('P', 'Patient'))),
          'HL70140': ('Military service',
                      (('AUSA', 'Australian Army'),
                       ('AUSAF', 'Australian Air Force'),
                       ('AUSN', 'Australian Navy'),
                       ('NATO', 'North Atlantic Treaty Organization'),
                       ('NOAA', 'National Oceanic and Atmospheric Administration'),
                       ('USA', 'U.S. Army'),
                       ('USAF', 'U.S. Air Force'),
                       ('USCG', 'U.S. Coast Guard'),
                       ('USMC', 'U.S. Marines'),
                       ('USN', 'U.S. Navy'),
                       ('USPHS', 'U.S. Public Health Service'))),
          'HL70141': ('Military rank/grade',
                      (('E1 ... E9', 'Enlisted'),
                       ('O1 ... O10', 'Officers'),
                       ('W1 ... W4', 'Warrant Officers'))),
          'HL70142': ('Military status',
                      (('ACT', 'Active duty'),
                       ('DEC', 'Deceased'),
                       ('RET', 'Retired'))),
          'HL70144': ('Eligibility source',
                      (('1', 'Insurance company'),
                       ('2', 'Employer'),
                       ('3', 'Insured presented policy'),
                       ('4', 'Insured presented card'),
                       ('5', 'Signed statement on file'),
                       ('6', 'Verbal information'),
                       ('7', 'None'))),
          'HL70145': ('Room type',
                      (('2ICU', 'Second intensive care unit'),
                       ('2PRI', 'Second private room'),
                       ('2SPR', 'Second semi-private room'),
                       ('ICU', 'Intensive care unit'),
                       ('PRI', 'Private room'),
                       ('SPR', 'Semi-private room'))),
          'HL70146': ('Amount type',
                      (('DF', 'Differential'),
                       ('LM', 'Limit'),
                       ('PC', 'Percentage'),
                       ('RT', 'Rate'),
                       ('UL', 'Unlimited'))),
          'HL70147': ('Policy type',
                      (('2ANC', 'Second ancillary'),
                       ('2MMD', 'Second major medical'),
                       ('3MMD', 'Third major medical'),
                       ('ANC', 'Ancillary'),
                       ('MMD', 'Major medical'))),
          'HL70148': ('Penalty type',
                      (('AT', 'Currency amount'), ('PC', 'Percentage'))),
          'HL70149': ('Day type',
                      (('AP', 'Approved'), ('DE', 'Denied'), ('PE', 'Pending'))),
          'HL70150': ('Pre-certification patient type',
                      (('ER', 'Emergency'),
                       ('IPE', 'Inpatient elective'),
                       ('OPE', 'Outpatient elective'),
                       ('UR', 'Urgent'))),
          'HL70153': ('Value code',
                      (('01', 'Most common semi-private rate'),
                       ('02', 'Hospital has no semi-private rooms'),
                       ('04',
                        'Inpatient professional component charges which are combined billed'),
                       ('05',
                        'Professional component included in charges and also billed separate to carrier'),
                       ('06', 'Medicare blood deductible'),
                       ('08',
                        'Medicare life time reserve amount in the first calendar year'),
                       ('09',
                        'Medicare co-insurance amount in the first calendar year'),
                       ('10', 'Lifetime reserve amount in the second calendar year'),
                       ('11', 'Co-insurance amount in the second calendar year'),
                       ('12',
                        'Working aged beneficiary/spouse with employer group health plan'),
                       ('13',
                        'ESRD beneficiary in a Medicare coordination period with an employer group health plan'),
                       ('14', 'No Fault including auto/other'),
                       ('15', "Worker's Compensation"),
                       ('16', 'PHS, or other federal agency'),
                       ('17', 'Payer code'),
                       ('21', 'Catastrophic'),
                       ('22', 'Surplus'),
                       ('23', 'Recurring monthly incode'),
                       ('24', 'Medicaid rate code'),
                       ('30', 'Pre-admission testing'),
                       ('31', 'Patient liability amount'),
                       ('37', 'Pints of blood furnished'),
                       ('38', 'Blood deductible pints'),
                       ('39', 'Pints of blood replaced'),
                       ('40',
                        'New coverage not implemented by HMO (for inpatient service only)'),
                       ('41', 'Black lung'),
                       ('42', 'VA'),
                       ('43', 'Disabled beneficiary under age 64 with LGHP'),
                       ('44',
                        'Amount provider agreed to accept from primary payer when this amount is less than charges but '
                        'higher than payment received,, then a Medicare secondary payment is due'),
                       ('45', 'Accident hour'),
                       ('46', 'Number of grace days'),
                       ('47', 'Any liability insurance'),
                       ('48', 'Hemoglobin reading'),
                       ('49', 'Hematocrit reading'),
                       ('50', 'Physical therapy visits'),
                       ('51', 'Occupational therapy visits'),
                       ('52', 'Speech therapy visits'),
                       ('53', 'Cardiac rehab visits'),
                       ('56', 'Skilled nurse - home visit hours'),
                       ('57', 'Home health aide - home visit hours'),
                       ('58', 'Arterial blood gas'),
                       ('59', 'Oxygen saturation'),
                       ('60', 'HHA branch MSA'),
                       ('67', 'Peritoneal dialysis'),
                       ('68', 'EPO-drug'),
                       ('70 ... 72', 'Payer codes'),
                       ('75 ... 79', 'Payer codes'),
                       ('80', 'Psychiatric visits'),
                       ('81', 'Visits subject to co-payment'),
                       ('A1', 'Deductible payer A'),
                       ('A2', 'Coinsurance payer A'),
                       ('A3', 'Estimated responsibility payer A'),
                       ('X0', 'Service excluded on primary policy'),
                       ('X4', 'Supplemental coverage'))),
          'HL70155': ('Accept/application acknowledgment conditions',
                      (('AL', 'Always'),
                       ('ER', 'Error/reject conditions only'),
                       ('NE', 'Never'),
                       ('SU', 'Successful completion only'))),
          'HL70156': ('Which date/time qualifier',
                      (('ANY', 'Any date/time within a range'),
                       ('COL',
                        'Collection date/time, equivalent to film or sample collection date/time'),
                       ('ORD', 'Order date/time'),
                       ('RCT',
                        'Specimen receipt date/time, receipt of specimen in filling ancillary (Lab)'),
                       ('REP',
                        'Report date/time, report date/time at filing ancillary (i.e., Lab)'),
                       ('SCHED', 'Schedule date/time'))),
          'HL70157': ('Which date/time status qualifier',
                      (('ANY', 'Any status'),
                       ('CFN', 'Current final value, whether final or corrected'),
                       ('COR', 'Corrected only (no final with corrections)'),
                       ('FIN', 'Final only (no corrections)'),
                       ('PRE', 'Preliminary'),
                       ('REP', 'Report completion date/time'))),
          'HL70158': ('Date/time selection qualifier',
                      (('1ST', 'First value within range'),
                       ('ALL', 'All values within the range'),
                       ('LST', 'Last value within the range'),
                       ('REV',
                        'All values within the range returned in reverse chronological order (This is the default if '
                        'not otherwise specified.)'))),
          'HL70159': ('Diet code specification type',
                      (('D', 'Diet'), ('P', 'Preference'), ('S', 'Supplement'))),
          'HL70160': ('Tray type',
                      (('EARLY', 'Early tray'),
                       ('GUEST', 'Guest tray'),
                       ('LATE', 'Late tray'),
                       ('MSG', 'Tray message only'),
                       ('NO', 'No tray'))),
          'HL70161': ('Allow substitution',
                      (('G', 'Allow generic substitutions.'),
                       ('N',
                        'Substitutions are NOT authorized. (This is the default - null.)'),
                       ('T', 'Allow therapeutic substitutions'))),
          'HL70162': ('Route of administration',
                      (('AP', 'Apply Externally'),
                       ('B', 'Buccal'),
                       ('DT', 'Dental'),
                       ('EP', 'Epidural'),
                       ('ET', 'Endotrachial Tube*'),
                       ('GTT', 'Gastrostomy Tube'),
                       ('GU', 'GU Irrigant'),
                       ('IA', 'Intra-arterial'),
                       ('IB', 'Intrabursal'),
                       ('IC', 'Intracardiac'),
                       ('ICV', 'Intracervical (uterus)'),
                       ('ID', 'Intradermal'),
                       ('IH', 'Inhalation'),
                       ('IHA', 'Intrahepatic Artery'),
                       ('IM', 'Intramuscular'),
                       ('IMR', 'Immerse (Soak) Body Part'),
                       ('IN', 'Intranasal'),
                       ('IO', 'Intraocular'),
                       ('IP', 'Intraperitoneal'),
                       ('IS', 'Intrasynovial'),
                       ('IT', 'Intrathecal'),
                       ('IU', 'Intrauterine'),
                       ('IV', 'Intravenous'),
                       ('MM', 'Mucous Membrane'),
                       ('MTH', 'Mouth/Throat'),
                       ('NG', 'Nasogastric'),
                       ('NP', 'Nasal Prongs*'),
                       ('NS', 'Nasal'),
                       ('NT', 'Nasotrachial Tube'),
                       ('OP', 'Ophthalmic'),
                       ('OT', 'Otic'),
                       ('OTH', 'Other/Miscellaneous'),
                       ('PF', 'Perfusion'),
                       ('PO', 'Oral'),
                       ('PR', 'Rectal'),
                       ('RM', 'Rebreather Mask*'),
                       ('SC', 'Subcutaneous'),
                       ('SD', 'Soaked Dressing'),
                       ('SL', 'Sublingual'),
                       ('TD', 'Transdermal'),
                       ('TL', 'Translingual'),
                       ('TP', 'Topical'),
                       ('TRA', 'Tracheostomy*'),
                       ('UR', 'Urethral'),
                       ('VG', 'Vaginal'),
                       ('VM', 'Ventimask'),
                       ('WND', 'Wound'))),
          'HL70163': ('Body site',
                      (('BE', 'Bilateral Ears'),
                       ('BN', 'Bilateral Nares'),
                       ('BU', 'Buttock'),
                       ('CT', 'Chest Tube'),
                       ('LA', 'Left Arm'),
                       ('LAC', 'Left Anterior Chest'),
                       ('LACF', 'Left Antecubital Fossa'),
                       ('LD', 'Left Deltoid'),
                       ('LE', 'Left Ear'),
                       ('LEJ', 'Left External Jugular'),
                       ('LF', 'Left Foot'),
                       ('LG', 'Left Gluteus Medius'),
                       ('LH', 'Left Hand'),
                       ('LIJ', 'Left Internal Jugular'),
                       ('LLAQ', 'Left Lower Abd Quadrant'),
                       ('LLFA', 'Left Lower Forearm'),
                       ('LMFA', 'Left Mid Forearm'),
                       ('LN', 'Left Naris'),
                       ('LPC', 'Left Posterior Chest'),
                       ('LSC', 'Left Subclavian'),
                       ('LT', 'Left Thigh'),
                       ('LUA', 'Left Upper Arm'),
                       ('LUAQ', 'Left Upper Abd Quadrant'),
                       ('LUFA', 'Left Upper Forearm'),
                       ('LVG', 'Left Ventragluteal'),
                       ('LVL', 'Left Vastus Lateralis'),
                       ('NB', 'Nebulized'),
                       ('OD', 'Right Eye'),
                       ('OS', 'Left Eye'),
                       ('OU', 'Bilateral Eyes'),
                       ('PA', 'Perianal'),
                       ('PERIN', 'Perineal'),
                       ('RA', 'Right Arm'),
                       ('RAC', 'Right Anterior Chest'),
                       ('RACF', 'Right Antecubital Fossa'),
                       ('RD', 'Right Deltoid'),
                       ('RE', 'Right Ear'),
                       ('REJ', 'Right External Jugular'),
                       ('RF', 'Right Foot'),
                       ('RG', 'Right Gluteus Medius'),
                       ('RH', 'Right Hand'),
                       ('RIJ', 'Right Internal Jugular'),
                       ('RLAQ', 'Rt Lower Abd Quadrant'),
                       ('RLFA', 'Right Lower Forearm'),
                       ('RMFA', 'Right Mid Forearm'),
                       ('RN', 'Right Naris'),
                       ('RPC', 'Right Posterior Chest'),
                       ('RSC', 'Right Subclavian'),
                       ('RT', 'Right Thigh'),
                       ('RUA', 'Right Upper Arm'),
                       ('RUAQ', 'Right Upper Abd Quadrant'),
                       ('RUFA', 'Right Upper Forearm'),
                       ('RVG', 'Right Ventragluteal'),
                       ('RVL', 'Right Vastus Lateralis'))),
          'HL70164': ('Administration device',
                      (('AP', 'Applicator'),
                       ('BT', 'Buretrol'),
                       ('HL', 'Heparin Lock'),
                       ('IPPB', 'IPPB'),
                       ('IVP', 'IV Pump'),
                       ('IVS', 'IV Soluset'),
                       ('MI', 'Metered Inhaler'),
                       ('NEB', 'Nebulizer'),
                       ('PCA', 'PCA Pump'))),
          'HL70165': ('Administration method',
                      (('CH', 'Chew'),
                       ('DI', 'Dissolve'),
                       ('DU', 'Dust'),
                       ('IF', 'Infiltrate'),
                       ('IR', 'Irrigate'),
                       ('IS', 'Insert'),
                       ('IVP', 'IV Push'),
                       ('IVPB', 'IV Piggyback'),
                       ('NB', 'Nebulized'),
                       ('PF', 'Perfuse'),
                       ('PT', 'Pain'),
                       ('SH', 'Shampoo'),
                       ('SO', 'Soak'),
                       ('WA', 'Wash'),
                       ('WI', 'Wipe'))),
          'HL70166': ('RX component type', (('A', 'Additive'), ('B', 'Base'))),
          'HL70167': ('Substitution status',
                      (('0', 'No product selection indicated'),
                       ('1', 'Substitution not allowed by prescriber'),
                       ('2',
                        'Substitution allowed - patient requested product dispensed'),
                       ('3',
                        'Substitution allowed - pharmacist selected product dispensed'),
                       ('4', 'Substitution allowed - generic drug not in stock'),
                       ('5',
                        'Substitution allowed - brand drug dispensed as a generic'),
                       ('7', 'Substitution not allowed - brand drug mandated by law'),
                       ('8',
                        'Substitution allowed - generic drug not available in marketplace'),
                       ('G', 'A generic substitution was dispensed.'),
                       ('N',
                        'No substitute was dispensed. This is equivalent to the default (null) value.'),
                       ('T', 'A therapeutic substitution was dispensed.'))),
          'HL70168': ('Processing priority',
                      (('A', 'As soon as possible (a priority lower than stat)'),
                       ('B',
                        'Do at bedside or portable (may be used with other codes)'),
                       ('C',
                        'Measure continuously (e.g., arterial line blood pressure)'),
                       ('P', 'Preoperative (to be done prior to surgery)'),
                       ('R', 'Routine'),
                       ('S', 'Stat (do immediately)'),
                       ('T',
                        'Timing critical (do as near as possible to requested time)'))),
          'HL70169': ('Reporting priority',
                      (('C', 'Call back results'), ('R', 'Rush reporting'))),
          'HL70170': ('Derived specimen',
                      (('C', 'Child Observation'),
                       ('N', 'Not Applicable'),
                       ('P', 'Parent Observation'))),
          'HL70173': ('Coordination of benefits',
                      (('CO', 'Coordination'), ('IN', 'Independent'))),
          'HL70174': ('Nature of service/test/observation',
                      (('A',
                        'Atomic service/test/observation (test code or treatment code)'),
                       ('C',
                        'Single observation calculated via a rule or formula from other independent observations '
                        '(e.g., Alveolar--arterial ratio, cardiac output)'),
                       ('F',
                        'Functional procedure that may consist of one or more interrelated measures (e.g., glucose '
                        'tolerance test, creatinine clearance), usually done at different times and/or on different '
                        'specimens'),
                       ('P',
                        'Profile or battery consisting of many independent atomic observations (e.g., SMA12, '
                        'electrolytes), usually done at one instrument on one specimen'),
                       ('S',
                        'Superset--a set of batteries or procedures ordered under a single code unit but processed '
                        'as separate batteries (e.g., routines = CBC, UA, electrolytes); This set indicates that the '
                        'code being described is used to order multiple service/test/observation b'))),
          'HL70175': ('Master file identifier code',
                      (('CDM', 'Charge description master file'),
                       ('CLN', 'Clinic master file'),
                       ('CMA',
                        'Clinical study with phases and scheduled master file'),
                       ('CMB',
                        'Clinical study without phases but with scheduled master file'),
                       ('LOC', 'Location master file'),
                       ('OMA', 'Numerical observation master file'),
                       ('OMB', 'Categorical observation master file'),
                       ('OMC', 'Observation batteries master file'),
                       ('OMD', 'Calculated observations master file'),
                       ('OME', 'Other basic observation/service attributes'),
                       ('PRA', 'Practitioner master file'),
                       ('STF', 'Staff master file'))),
          'HL70177': ('Confidentiality code',
                      (('AID', 'AIDS patient'),
                       ('EMP', 'Employee'),
                       ('ETH', 'Alcohol/drug treatment patient'),
                       ('HIV', 'HIV(+) patient'),
                       ('PSY', 'Psychiatric patient'),
                       ('R', 'Restricted'),
                       ('U', 'Usual control'),
                       ('UWM', 'Unwed mother'),
                       ('V', 'Very restricted'),
                       ('VIP', 'Very important person or celebrity'))),
          'HL70178': ('File level event code',
                      (('REP',
                        'Replace current version of this master file with the version contained in this message'),
                       ('UPD',
                        'Change file records as defined in the record-level event codes for each record that '
                        'follows'))),
          'HL70179': ('Response level',
                      (('AL',
                        'Always. All MFA segments (whether denoting errors or not) must be returned via the '
                        'application-level acknowledgment message'),
                       ('ER',
                        'Error/Reject conditions only. Only MFA segments denoting errors must be returned via '
                        'the application-level acknowledgment for this message'),
                       ('NE', 'Never. No application-level response needed'),
                       ('SU',
                        'Success. Only MFA segments denoting success must be returned via the application-level '
                        'acknowledgment for this message'))),
          'HL70180': ('Record-level event code',
                      (('MAC', 'Reactivate deactivated record'),
                       ('MAD', 'Add record to master file'),
                       ('MDC',
                        'Deactivate: discontinue using record in master file, but do not delete from database'),
                       ('MDL', 'Delete record from master file'),
                       ('MUP', 'Update record for master file'))),
          'HL70181': ('MFN record-level error return',
                      (('S',
                        'Successful posting of the record defined by the MFE segment'),
                       ('U',
                        'Unsuccessful posting of the record defined by the MFE segment'))),
          'HL70182': ('Staff type', (('...', 'No suggested values defined'),)),
          'HL70183': ('Active/inactive',
                      (('A', 'Active Staff'), ('I', 'Inactive Staff'))),
          'HL70184': ('Department', (('...', 'No suggested values defined'),)),
          'HL70185': ('Preferred method of contact',
                      (('B', 'Beeper Number'),
                       ('C', 'Cellular Phone Number'),
                       ('E', 'E-Mail Address (for backward compatibility)'),
                       ('F', 'FAX Number'),
                       ('H', 'Home Phone Number'),
                       ('O', 'Office Phone Number'))),
          'HL70187': ('Provider billing',
                      (('I', 'Institution bills for provider'),
                       ('P', 'Provider does own billing'))),
          'HL70189': ('Ethnic group',
                      (('...', 'see chapter 3'),
                       ('H', 'Hispanic or Latino'),
                       ('N', 'Not Hispanic or Latino'),
                       ('U', 'Unknown'))),
          'HL70190': ('Address type',
                      (('B', 'Firm/Business'),
                       ('BA', 'Bad address'),
                       ('BDL',
                        'Birth delivery location (address where birth occurred)'),
                       ('BR', 'Residence at birth (home address at time of birth)'),
                       ('C', 'Current Or Temporary'),
                       ('F', 'Country Of Origin'),
                       ('H', 'Home'),
                       ('L', 'Legal Address'),
                       ('M', 'Mailing'),
                       ('N', 'Birth (nee) (birth address, not otherwise specified)'),
                       ('O', 'Office'),
                       ('P', 'Permanent'),
                       ('RH',
                        'Registry home. Refers to the information system, typically managed by a public health '
                        'agency, that stores patient information such as immunization histories or cancer data, '
                        'regardless of where the patient obtains services.'))),
          'HL70191': ('Type of referenced data',
                      (('AP',
                        'Other application data, typically uninterpreted binary data (HL7 V2.3 and later)'),
                       ('AU', 'Audio data (HL7 V2.3 and later)'),
                       ('FT', 'Formatted text (HL7 V2.2 only)'),
                       ('IM', 'Image data (HL7 V2.3 and later)'),
                       ('multipart', 'MIME multipart package'),
                       ('NS', 'Non-scanned image (HL7 V2.2 only)'),
                       ('SD', 'Scanned document (HL7 V2.2 only)'),
                       ('SI', 'Scanned image (HL7 V2.2 only)'),
                       ('TEXT',
                        'Machine readable text document (HL7 V2.3.1 and later)'),
                       ('TX', 'Machine readable text document (HL7 V2.2 only)'))),
          'HL70193': ('Amount class',
                      (('AT', 'Amount'),
                       ('LM', 'Limit'),
                       ('PC', 'Percentage'),
                       ('UL', 'Unlimited'))),
          'HL70200': ('Name type',
                      (('A', 'Alias Name'),
                       ('B', 'Name at Birth'),
                       ('C', 'Adopted Name'),
                       ('D', 'Display Name'),
                       ('I', 'Licensing Name'),
                       ('L', 'Legal Name'),
                       ('M', 'Maiden Name'),
                       ('N', 'Nickname /"Call me" Name/Street Name'),
                       ('P',
                        'Name of Partner/Spouse (retained for backward compatibility only)'),
                       ('R', 'Registered Name (animals only)'),
                       ('S', 'Coded Pseudo-Name to ensure anonymity'),
                       ('T', 'Indigenous/Tribal/Community Name'),
                       ('U', 'Unspecified'))),
          'HL70201': ('Telecommunication use code',
                      (('ASN', 'Answering Service Number'),
                       ('BPN', 'Beeper Number'),
                       ('EMR', 'Emergency Number'),
                       ('NET', 'Network (email) Address'),
                       ('ORN', 'Other Residence Number'),
                       ('PRN', 'Primary Residence Number'),
                       ('VHN', 'Vacation Home Number'),
                       ('WPN', 'Work Number'))),
          'HL70202': ('Telecommunication equipment type',
                      (('BP', 'Beeper'),
                       ('CP', 'Cellular Phone'),
                       ('FX', 'Fax'),
                       ('Internet',
                        'Internet Address: Use Only If Telecommunication Use Code Is NET'),
                       ('MD', 'Modem'),
                       ('PH', 'Telephone'),
                       ('X.400',
                        'X.400 email address: Use Only If Telecommunication Use Code Is NET'))),
          'HL70203': ('Identifier type',
                      (('AM', 'American Express'),
                       ('AN', 'Account number'),
                       ('BA', 'Bank Account Number'),
                       ('BR', 'Birth registry number'),
                       ('BRN', 'Breed Registry Number'),
                       ('DI', "Diner's Club card"),
                       ('DL', "Driver's license number"),
                       ('DN', 'Doctor number'),
                       ('DR', 'Donor Registration Number'),
                       ('DS', 'Discover Card'),
                       ('EI', 'Employee number'),
                       ('EN', 'Employer number'),
                       ('FI', 'Facility ID'),
                       ('GI', 'Guarantor internal identifier'),
                       ('GN', 'Guarantor external identifier'),
                       ('HC', 'Health Card Number'),
                       ('JHN', 'Jurisdictional health number (Canada)'),
                       ('LN', 'License number'),
                       ('LR', 'Local Registry ID'),
                       ('MA', 'Medicaid number'),
                       ('MC', 'Medicare number'),
                       ('MCN', 'Microchip Number'),
                       ('MR', 'Medical record number'),
                       ('MS', 'MasterCard'),
                       ('NE', 'National employer identifier'),
                       ('NH', 'National Health Plan Identifier'),
                       ('NI', 'National unique individual identifier'),
                       ('NNxxx',
                        'National Person Identifier where the xxx is the ISO table 3166 3-character (alphabetic) '
                        'country code'),
                       ('NPI', 'National provider identifier'),
                       ('PEN', 'Pension Number'),
                       ('PI', 'Patient internal identifier'),
                       ('PN', 'Person number'),
                       ('PRN', 'Provider number'),
                       ('PT', 'Patient external identifier'),
                       ('RR', 'Railroad Retirement number'),
                       ('RRI', 'Regional registry ID'),
                       ('SL', 'State license'),
                       ('SR', 'State registry ID'),
                       ('SS', 'Social Security number'),
                       ('U', 'Unspecified'),
                       ('UPIN',
                        "Medicare/HCFA's Universal Physician Identification numbers"),
                       ('VN', 'Visit number'),
                       ('VS', 'VISA'),
                       ('WC', 'WIC identifier'),
                       ('WCN', "Workers' Comp Number"),
                       ('XX', 'Organization identifier'))),
          'HL70204': ('Organizational name type',
                      (('A', 'Alias name'),
                       ('D', 'Display name'),
                       ('L', 'Legal name'),
                       ('SL', 'Stock exchange listing name'))),
          'HL70205': ('Price type',
                      (('AP', 'administrative price or handling fee'),
                       ('DC', 'direct unit cost'),
                       ('IC', 'indirect unit cost'),
                       ('PF', 'professional fee for performing provider'),
                       ('TF', 'technology fee for use of equipment'),
                       ('TP', 'total price'),
                       ('UP',
                        'unit price, may be based on length of procedure or service'))),
          'HL70206': ('Segment action code',
                      (('A', 'Add/Insert'), ('D', 'Delete'), ('U', 'Update'))),
          'HL70207': ('Processing mode',
                      (('A', 'Archive'),
                       ('I', 'Initial load'),
                       ('Not present',
                        'Not present (the default, meaning current processing)'),
                       ('R', 'Restore from archive'),
                       ('T',
                        'Current processing, transmitted at intervals (scheduled or on demand)'))),
          'HL70208': ('Query response status',
                      (('AE', 'Application error'),
                       ('AR', 'Application reject'),
                       ('NF', 'No data found, no errors'),
                       ('OK', 'Data found, no errors (this is the default)'))),
          'HL70209': ('Relational operator',
                      (('CT', 'Contains'),
                       ('EQ', 'Equal'),
                       ('GE', 'Greater than or equal'),
                       ('GN', 'Generic'),
                       ('GT', 'Greater than'),
                       ('LE', 'Less than or equal'),
                       ('LT', 'Less than'),
                       ('NE', 'Not Equal'))),
          'HL70210': ('Relational conjunction', (('AND', 'Default'), ('OR', ''))),
          'HL70211': ('Alternate character sets',
                      (('8859/1',
                        'The printable characters from the ISO 8859/1 Character set'),
                       ('8859/2',
                        'The printable characters from the ISO 8859/2 Character set'),
                       ('8859/3',
                        'The printable characters from the ISO 8859/3 Character set'),
                       ('8859/4',
                        'The printable characters from the ISO 8859/4 Character set'),
                       ('8859/5',
                        'The printable characters from the ISO 8859/5 Character set'),
                       ('8859/6',
                        'The printable characters from the ISO 8859/6 Character set'),
                       ('8859/7',
                        'The printable characters from the ISO 8859/7 Character set'),
                       ('8859/8',
                        'The printable characters from the ISO 8859/8 Character set'),
                       ('8859/9',
                        'The printable characters from the ISO 8859/9 Character set'),
                       ('ASCII',
                        'The printable 7-bit ASCII character set. (This is the default if this field is omitted)'),
                       ('ISO IR14',
                        'Code for Information Exchange (one byte)(JIS X 0201-1976). Note that the code contains a '
                        'space, i.e. "ISO IR14".'),
                       ('ISO IR159',
                        'Code of the supplementary Japanese Graphic Character set for information interchange '
                        '(JIS X 0212-1990). Note that the code contains a space, i.e. "ISO IR159".'),
                       ('ISO IR87',
                        'Code for the Japanese Graphic Character set for information interchange (JIS X 0208-1990), '
                        'Note that the code contains a space, i.e. "ISO IR87".'),
                       ('UNICODE',
                        'The world wide character standard from ISO/IEC 10646-1-19931'))),
          'HL70213': ('Purge status code',
                      (('D',
                        'The visit is marked for deletion and the user cannot enter new data against it.'),
                       ('I',
                        'The visit is marked inactive and the user cannot enter new data against it.'),
                       ('P',
                        'Marked for purge. User is no longer able to update the visit.'))),
          'HL70217': ('Visit priority code',
                      (('1', 'Emergency'), ('2', 'Urgent'), ('3', 'Elective'))),
          'HL70220': ('Living arrangement',
                      (('A', 'Alone'),
                       ('F', 'Family'),
                       ('I', 'Institution'),
                       ('R', 'Relative'),
                       ('S', 'Spouse Only'),
                       ('U', 'Unknown'))),
          'HL70223': ('Living dependency',
                      (('C', 'Small Children Dependent'),
                       ('CB', 'Common Bath'),
                       ('D', 'Spouse dependent'),
                       ('M', 'Medical Supervision Required'),
                       ('O', 'Other'),
                       ('S', 'Spouse Dependent'),
                       ('U', 'Unknown'),
                       ('WU', 'Walk up'))),
          'HL70224': ('Transport arranged',
                      (('A', 'Arranged'), ('N', 'Not Arranged'), ('U', 'Unknown'))),
          'HL70225': ('Escort required',
                      (('N', 'Not Required'), ('R', 'Required'), ('U', 'Unknown'))),
          'HL70227': ('Manufacturers of vaccines (code=MVX)',
                      (('AB',
                        'Abbott Laboratories (includes Ross Products Division)'),
                       ('AD', 'Adams Laboratories'),
                       ('ALP', 'Alpha Therapeutic Corporation'),
                       ('AR', 'Armour [Inactive-use CEN]'),
                       ('AVI', 'Aviron'),
                       ('BA', 'Baxter Healthcare Corporation'),
                       ('BAY',
                        'Bayer Corporation(includes Miles, Inc. and Cutter Laboratories)'),
                       ('BP', 'Berna Products [Inactive-use BPC]'),
                       ('BPC',
                        'Berna Products Corporation (includes Swiss Serum and Vaccine Institute Berne)'),
                       ('CEN',
                        'Centeon L.L.C. (includes Armour Pharmaceutical Company)'),
                       ('CHI', 'Chiron Corporation'),
                       ('CON', 'Connaught [Inactive-use PMC]'),
                       ('EVN',
                        'Evans Medical Limited (an affiliate of Medeva Pharmaceuticals, Inc.)'),
                       ('GRE', 'Greer Laboratories, Inc.'),
                       ('IAG', 'Immuno International AG'),
                       ('IM', 'Merieux [Inactive-use PMC]'),
                       ('IUS', 'Immuno-U.S., Inc.'),
                       ('JPN',
                        'The Research Foundation for Microbial Diseases of Osaka University (BIKEN)'),
                       ('KGC', 'Korea Green Cross Corporation'),
                       ('LED', 'Lederle [Inactive-use WAL]'),
                       ('MA', 'Massachusetts Public Health Biologic Laboratories'),
                       ('MED', 'MedImmune, Inc.'),
                       ('MIL', 'Miles [Inactive-use BAY]'),
                       ('MIP',
                        'Bioport Corporation (formerly Michigan Biologic Products Institute)'),
                       ('MSD', 'Merck & Co., Inc.'),
                       ('NAB', 'NABI (formerly North American Biologicals, Inc.)'),
                       ('NAV', 'North American Vaccine, Inc.'),
                       ('NOV',
                        'Novartis Pharmaceutical Corporation (includes Ciba-Geigy Limited and Sandoz Limited)'),
                       ('NYB', 'New York Blood Center'),
                       ('ORT', 'Ortho Diagnostic Systems, Inc.'),
                       ('OTC', 'Organon Teknika Corporation'),
                       ('OTH', 'Other manufacturer'),
                       ('PD', 'Parkedale Pharmaceuticals (formerly Parke-Davis)'),
                       ('PMC',
                        'Aventis Pasteur Inc. (formerly Pasteur Merieux Connaught; includes Connaught Laboratories '
                        'and Pasteur Merieux)'),
                       ('PRX', 'Praxis Biologics [Inactive-use WAL]'),
                       ('SCL', 'Sclavo, Inc.'),
                       ('SI', 'Swiss Serum and Vaccine Inst. [Inactive-use BPC]'),
                       ('SKB', 'SmithKline Beecham'),
                       ('UNK', 'Unknown manufacturer'),
                       ('USA',
                        'United States Army Medical Research and Materiel Command'),
                       ('WA', 'Wyeth-Ayerst [Inactive-use WAL]'),
                       ('WAL',
                        'Wyeth-Ayerst (includes Wyeth-Lederle Vaccines and Pediatrics, Wyeth Laboratories, Lederle '
                        'Laboratories, and Praxis Biologics)'))),
          'HL70228': ('Diagnosis classification',
                      (('C', 'Consultation'),
                       ('D', 'Diagnosis'),
                       ('I',
                        'Invasive procedure not classified elsewhere (I.V., catheter, etc.)'),
                       ('M', 'Medication (antibiotic)'),
                       ('O', 'Other'),
                       ('R', 'Radiological scheduling (not using ICDA codes)'),
                       ('S', 'Sign and symptom'),
                       ('T', 'Tissue diagnosis'))),
          'HL70229': ('DRG payor',
                      (('C', 'Champus'),
                       ('G', 'Managed Care Organization'),
                       ('M', 'Medicare'))),
          'HL70230': ('Procedure functional type',
                      (('A', 'Anesthesia'),
                       ('D', 'Diagnostic procedure'),
                       ('I',
                        'Invasive procedure not classified elsewhere (e.g., IV, catheter, etc.)'),
                       ('P',
                        'Procedure for treatment (therapeutic, including operations)'))),
          'HL70231': ('Student status',
                      (('F', 'Full-time student'),
                       ('N', 'Not a student'),
                       ('P', 'Part-time student'))),
          'HL70232': ('Insurance company contact reason',
                      (('01', 'Medicare claim status'),
                       ('02', 'Medicaid claim status'),
                       ('03', 'Name/address change'))),
          'HL70234': ('Report timing',
                      (('10D', '10 day report'),
                       ('15D', '15 day report'),
                       ('30D', '30 day report'),
                       ('3D', '3 day report'),
                       ('7D', '7 day report'),
                       ('AD', 'Additional information'),
                       ('CO', 'Correction'),
                       ('DE', 'Device evaluation'),
                       ('PD', 'Periodic'),
                       ('RQ', 'Requested information'))),
          'HL70235': ('Report source',
                      (('C', 'Clinical trial'),
                       ('D', 'Database/registry/poison control center'),
                       ('E', 'Distributor'),
                       ('H', 'Health professional'),
                       ('L', 'Literature'),
                       ('M', 'Manufacturer/marketing authority holder'),
                       ('N', 'Non-healthcare professional'),
                       ('O', 'Other'),
                       ('P', 'Patient'),
                       ('R', 'Regulatory agency'))),
          'HL70236': ('Event reported to',
                      (('D', 'Distributor'),
                       ('L', 'Local facility/user facility'),
                       ('M', 'Manufacturer'),
                       ('R', 'Regulatory agency'))),
          'HL70237': ('Event qualification',
                      (('A', 'Abuse'),
                       ('B', 'Unexpected beneficial effect'),
                       ('D', 'Dependency'),
                       ('I', 'Interaction'),
                       ('L', 'Lack of expect therapeutic effect'),
                       ('M', 'Misuse'),
                       ('O', 'Overdose'),
                       ('W', 'Drug withdrawal'))),
          'HL70238': ('Event seriousness',
                      (('N', 'No'), ('S', 'Significant'), ('Y', 'Yes'))),
          'HL70239': ('Event expected', (('N', 'No'), ('U', 'Unknown'), ('Y', 'Yes'))),
          'HL70240': ('Event consequence',
                      (('C', 'Congenital anomaly/birth defect'),
                       ('D', 'Death'),
                       ('H', 'Caused hospitalized'),
                       ('I',
                        'Incapacity which is significant, persistent or permanent'),
                       ('J',
                        'Disability which is significant, persistent or permanent'),
                       ('L', 'Life threatening'),
                       ('O', 'Other'),
                       ('P', 'Prolonged hospitalization'),
                       ('R',
                        'Required intervention to prevent permanent impairment/damage'))),
          'HL70241': ('Patient outcome',
                      (('D', 'Died'),
                       ('F', 'Fully recovered'),
                       ('N', 'Not recovering/unchanged'),
                       ('R', 'Recovering'),
                       ('S', 'Sequelae'),
                       ('U', 'Unknown'),
                       ('W', 'Worsening'))),
          'HL70242': ("Primary observer's qualification",
                      (('C', 'Health care consumer/patient'),
                       ('H', 'Other health professional'),
                       ('L', 'Lawyer/attorney'),
                       ('M',
                        "Mid-level professional (nurse, nurse practitioner, physician's assistant)"),
                       ('O', 'Other non-health professional'),
                       ('P', 'Physician (osteopath, homeopath)'),
                       ('R', 'Pharmacist'))),
          'HL70243': ('Identity may be divulged',
                      (('N', 'No'), ('NA', 'Not applicable'), ('Y', 'Yes'))),
          'HL70247': ('Status of evaluation',
                      (('A', 'Evaluation anticipated, but not yet begun'),
                       ('C',
                        'Product received in condition which made analysis impossible'),
                       ('D', 'Product discarded -- unable to follow up'),
                       ('I', 'Product remains implanted -- unable to follow up'),
                       ('K', 'Problem already known, no evaluation necessary'),
                       ('O', 'Other'),
                       ('P', 'Evaluation in progress'),
                       ('Q', 'Product under quarantine -- unable to follow up'),
                       ('R', 'Product under recall/corrective action'),
                       ('U', 'Product unavailable for follow up investigation'),
                       ('X', 'Product not made by company'),
                       ('Y', 'Evaluation completed'))),
          'HL70248': ('Product source',
                      (('A', 'Actual product involved in incident was evaluated'),
                       ('L',
                        'A product from the same lot as the actual product involved was evaluated'),
                       ('N',
                        'A product from a controlled/non-related inventory was evaluated'),
                       ('R', 'A product from a reserve sample was evaluated'))),
          'HL70250': ('Relatedness assessment',
                      (('H', 'Highly probable'),
                       ('I', 'Improbable'),
                       ('M', 'Moderately probable'),
                       ('N', 'Not related'),
                       ('S', 'Somewhat probable'))),
          'HL70251': ('Action taken in response to the event',
                      (('DI', 'Product dose or frequency of use increased'),
                       ('DR', 'Product dose or frequency of use reduced'),
                       ('N', 'None'),
                       ('OT', 'Other'),
                       ('WP', 'Product withdrawn permanently'),
                       ('WT', 'Product withdrawn temporarily'))),
          'HL70252': ('Causality observations',
                      (('AW', 'Abatement of event after product withdrawn'),
                       ('BE', 'Event recurred after product reintroduced'),
                       ('DR', 'Dose response observed'),
                       ('EX', 'Alternative explanations for the event available'),
                       ('IN', 'Event occurred after product introduced'),
                       ('LI', 'Literature reports association of product with event'),
                       ('OE',
                        'Occurrence of event was confirmed by objective evidence'),
                       ('OT', 'Other'),
                       ('PL', 'Effect observed when patient receives placebo'),
                       ('SE', 'Similar events in past for this patient'),
                       ('TC',
                        'Toxic levels of product documented in blood or body fluids'))),
          'HL70253': ('Indirect exposure mechanism',
                      (('B', 'Breast milk'),
                       ('F', 'Father'),
                       ('O', 'Other'),
                       ('P', 'Transplacental'),
                       ('X', 'Blood product'))),
          'HL70254': ('Kind of quantity',
                      (('ABS', 'Absorbance'),
                       ('ACNC', 'Concentration, Arbitrary Substance'),
                       ('ACT', '*Activity'),
                       ('APER', 'Appearance'),
                       ('ARB', '*Arbitrary'),
                       ('AREA', 'Area'),
                       ('ASPECT', 'Aspect'),
                       ('CACT', '*Catalytic Activity'),
                       ('CCNT', '*Catalytic Content'),
                       ('CCRTO', 'Catalytic Concentration Ratio'),
                       ('CFR', '*Catalytic Fraction'),
                       ('CLAS', 'Class'),
                       ('CNC', '*Catalytic Concentration'),
                       ('CNST', '*Constant'),
                       ('COEF', '*Coefficient'),
                       ('COLOR', 'Color'),
                       ('CONS', 'Consistency'),
                       ('CRAT', '*Catalytic Rate'),
                       ('CRTO', 'Catalytic Ratio'),
                       ('DEN', 'Density'),
                       ('DEV', 'Device'),
                       ('DIFF', '*Difference'),
                       ('ELAS', 'Elasticity'),
                       ('ELPOT', 'Electrical Potential (Voltage)'),
                       ('ELRAT', 'Electrical current (amperage)'),
                       ('ELRES', 'Electrical Resistance'),
                       ('ENGR', 'Energy'),
                       ('ENT', '*Entitic'),
                       ('ENTCAT', '*Entitic Catalytic Activity'),
                       ('ENTNUM', '*Entitic Number'),
                       ('ENTSUB', '*Entitic Substance of Amount'),
                       ('ENTVOL', '*Entitic Volume'),
                       ('EQL', 'Equilibrium'),
                       ('FORCE', 'Mechanical force'),
                       ('FREQ', 'Frequency'),
                       ('IMP', 'Impression/ interpretation of study'),
                       ('KINV', '*Kinematic Viscosity'),
                       ('LEN', 'Length'),
                       ('LINC', '*Length Increment'),
                       ('LIQ', '*Liquefaction'),
                       ('MASS', '*Mass'),
                       ('MCNC', '*Mass Concentration'),
                       ('MCNT', 'Mass Content'),
                       ('MCRTO', '*Mass Concentration Ratio'),
                       ('MFR', '*Mass Fraction'),
                       ('MGFLUX', 'Magnetic flux'),
                       ('MINC', '*Mass Increment'),
                       ('MORPH', 'Morphology'),
                       ('MOTIL', 'Motility'),
                       ('MRAT', '*Mass Rate'),
                       ('MRTO', '*Mass Ratio'),
                       ('NCNC', '*Number Concentration'),
                       ('NCNT', '*Number Content'),
                       ('NFR', '*Number Fraction'),
                       ('NRTO', '*Number Ratio'),
                       ('NUM', '*Number'),
                       ('OD', 'Optical density'),
                       ('OSMOL', '*Osmolality'),
                       ('PRES', '*Pressure (Partial)'),
                       ('PRID', 'Presence/Identity/Existence'),
                       ('PWR', 'Power (wattage)'),
                       ('RANGE', '*Ranges'),
                       ('RATIO', '*Ratios'),
                       ('RCRLTM', '*Reciprocal Relative Time'),
                       ('RDEN', '*Relative Density'),
                       ('REL', '*Relative'),
                       ('RLMCNC', '*Relative Mass Concentration'),
                       ('RLSCNC', '*Relative Substance Concentration'),
                       ('RLTM', '*Relative Time'),
                       ('SATFR', '*Saturation Fraction'),
                       ('SCNC', '*Substance Concentration'),
                       ('SCNCIN', '*Substance Concentration Increment'),
                       ('SCNT', '*Substance Content'),
                       ('SCNTR', '*Substance Content Rate'),
                       ('SCRTO', '*Substance Concentration Ratio'),
                       ('SFR', '*Substance Fraction'),
                       ('SHAPE', 'Shape'),
                       ('SMELL', 'Smell'),
                       ('SRAT', '*Substance Rate'),
                       ('SRTO', '*Substance Ratio'),
                       ('SUB', '*Substance Amount'),
                       ('SUSC', '*Susceptibility'),
                       ('TASTE', 'Taste'),
                       ('TEMP', '*Temperature'),
                       ('TEMPDF', '*Temperature Difference'),
                       ('TEMPIN', '*Temperature Increment'),
                       ('THRMCNC', '*Threshold Mass Concentration'),
                       ('THRSCNC', '*Threshold Substance Concentration'),
                       ('TIME', '*Time (e.g. seconds)'),
                       ('TITR', '*Dilution Factor (Titer)'),
                       ('TMDF', '*Time Difference'),
                       ('TMSTP', '*Time Stamp -- Date and Time'),
                       ('TRTO', '*Time Ratio'),
                       ('TYPE', '*Type'),
                       ('VCNT', '*Volume Content'),
                       ('VEL', '*Velocity'),
                       ('VELRT', '*Velocity Ratio'),
                       ('VFR', '*Volume Fraction'),
                       ('VISC', '*Viscosity'),
                       ('VOL', '*Volume'),
                       ('VRAT', '*Volume Rate'),
                       ('VRTO', '*Volume Ratio'))),
          'HL70255': ('Duration categories',
                      (('*',
                        '(asterisk) Life of the "unit." Used for blood products.'),
                       ('12H', '12 hours'),
                       ('1H', '1 hour'),
                       ('1L', '1 months (30 days)'),
                       ('1W', '1 week'),
                       ('24H', '24 hours'),
                       ('2.5H', '21/2 hours'),
                       ('2D', '2 days'),
                       ('2H', '2 hours'),
                       ('2L', '2 months'),
                       ('2W', '2 weeks'),
                       ('30M', '30 minutes'),
                       ('3D', '3 days'),
                       ('3H', '3 hours'),
                       ('3L', '3 months'),
                       ('3W', '3 weeks'),
                       ('4D', '4 days'),
                       ('4H', '4 hours'),
                       ('4W', '4 weeks'),
                       ('5D', '5 days'),
                       ('5H', '5 hours'),
                       ('6D', '6 days'),
                       ('6H', '6 hours'),
                       ('7H', '7 hours'),
                       ('8H', '8 hours'),
                       ('PT',
                        'To identify measures at a point in time. This is a synonym for "spot" or "random" as '
                        'applied to urine measurements.'))),
          'HL70256': ('Time delay post challenge',
                      (('10D', '10 days'),
                       ('10M', '10 minutes post challenge'),
                       ('12H', '12 hours post challenge'),
                       ('15M', '15 minutes post challenge'),
                       ('1H', '1 hour post challenge'),
                       ('1L', '1 month (30 days) post challenge'),
                       ('1M', '1 minute post challenge'),
                       ('1W', '1 week'),
                       ('20M', '20 minutes post challenge'),
                       ('24H', '24 hours post challenge'),
                       ('2.5H', '2 1/2 hours post challenge'),
                       ('25M', '25 minutes post challenge'),
                       ('2D', '2 days'),
                       ('2H', '2 hours post challenge'),
                       ('2L', '2 months (60 days) post challenge'),
                       ('2M', '2 minutes post challenge'),
                       ('2W', '2 weeks'),
                       ('30M', '30 minutes post challenge'),
                       ('3D', '3 days'),
                       ('3H', '3 hours post challenge'),
                       ('3L', '3 months (90 days) post challenge'),
                       ('3M', '3 minutes post challenge'),
                       ('3W', '3 weeks'),
                       ('4D', '4 days'),
                       ('4H', '4 hours post challenge'),
                       ('4M', '4 minutes post challenge'),
                       ('4W', '4 weeks'),
                       ('5D', '5 days'),
                       ('5H', '5 hours post challenge'),
                       ('5M', '5 minutes post challenge'),
                       ('6D', '6 days'),
                       ('6H', '6 hours post challenge'),
                       ('6M', '6 minutes post challenge'),
                       ('7D', '7 days'),
                       ('7H', '7 hours post challenge'),
                       ('7M', '7 minutes post challenge'),
                       ('8H', '8 hours post challenge'),
                       ('8H SHIFT', '8 hours aligned on nursing shifts'),
                       ('8M', '8 minutes post challenge'),
                       ('9M', '9 minutes post challenge'),
                       ('BS', 'Baseline (time just before the challenge)'),
                       ('PEAK',
                        'The time post drug dose at which the highest drug level is reached (differs by drug)'),
                       ('RANDOM',
                        'Time from the challenge, or dose not specified. (random)'),
                       ('TROUGH',
                        'The time post drug dose at which the lowest drug level is reached (varies with drug)'))),
          'HL70257': ('Nature of challenge',
                      (('CFST',
                        'Fasting (no calorie intake) for the period specified in the time component of the term, '
                        'e.g., 1H POST CFST'),
                       ('EXCZ',
                        'Exercise undertaken as challenge (can be quantified)'),
                       ('FFST',
                        'No fluid intake for the period specified in the time component of the term'))),
          'HL70258': ('Relationship modifier',
                      (('BPU', 'Blood product unit'),
                       ('CONTROL', 'Control'),
                       ('DONOR', 'Donor'),
                       ('PATIENT', 'Patient'))),
          'HL70259': ('Modality',
                      (('AS', 'Angioscopy'),
                       ('BS', 'Biomagnetic imaging'),
                       ('CD', 'Color flow Doppler'),
                       ('CP', 'Colposcopy'),
                       ('CR', 'Computed radiography'),
                       ('CS', 'Cystoscopy'),
                       ('CT', 'Computed tomography'),
                       ('DD', 'Duplex Doppler'),
                       ('DG', 'Diapanography'),
                       ('DM', 'Digital microscopy'),
                       ('EC', 'Echocardiography'),
                       ('ES', 'Endoscopy'),
                       ('FA', 'Fluorescein angiography'),
                       ('FS', 'Fundoscopy'),
                       ('LP', 'Laparoscopy'),
                       ('LS', 'Laser surface scan'),
                       ('MA', 'Magnetic resonance angiography'),
                       ('MS', 'Magnetic resonance spectroscopy'),
                       ('NM', 'Nuclear Medicine (radioisotope study)'),
                       ('OT', 'Other'),
                       ('PT', 'Positron emission tomography (PET)'),
                       ('RF', 'Radio fluoroscopy'),
                       ('ST', 'Single photon emission computed tomography (SPECT)'),
                       ('TG', 'Thermography'),
                       ('US', 'Ultrasound'),
                       ('XA', 'X-ray Angiography'))),
          'HL70260': ('Patient location type',
                      (('B', 'Bed'),
                       ('C', 'Clinic'),
                       ('D', 'Department'),
                       ('E', 'Exam Room'),
                       ('L', 'Other Location'),
                       ('N', 'Nursing Unit'),
                       ('O', 'Operating Room'),
                       ('R', 'Room'))),
          'HL70261': ('Location equipment',
                      (('EEG', 'Electro-Encephalogram'),
                       ('EKG', 'Electro-Cardiogram'),
                       ('INF', 'Infusion pump'),
                       ('IVP', 'IV pump'),
                       ('OXY', 'Oxygen'),
                       ('SUC', 'Suction'),
                       ('VEN', 'Ventilator'),
                       ('VIT', 'Vital signs monitor'))),
          'HL70262': ('Privacy level',
                      (('F', 'Isolation'),
                       ('J', 'Private room - medically justified'),
                       ('P', 'Private room'),
                       ('Q', 'Private room - due to overflow'),
                       ('S', 'Semi-private room'),
                       ('W', 'Ward'))),
          'HL70263': ('Level of care',
                      (('A', 'Ambulatory'),
                       ('C', 'Critical care'),
                       ('E', 'Emergency'),
                       ('F', 'Isolation'),
                       ('N', 'Intensive care'),
                       ('R', 'Routine'),
                       ('S', 'Surgery'))),
          'HL70265': ('Specialty type',
                      (('ALC', 'Allergy'),
                       ('AMB', 'Ambulatory'),
                       ('CAN', 'Cancer'),
                       ('CAR', 'Coronary/cardiac care'),
                       ('CCR', 'Critical care'),
                       ('CHI', 'Chiropractic'),
                       ('EDI', 'Education'),
                       ('EMR', 'Emergency'),
                       ('FPC', 'Family planning'),
                       ('INT', 'Intensive care'),
                       ('ISO', 'Isolation'),
                       ('NAT', 'Naturopathic'),
                       ('NBI', 'Newborn, nursery, infants'),
                       ('OBG', 'Obstetrics, gynecology'),
                       ('OBS', 'Observation'),
                       ('OTH', 'Other specialty'),
                       ('PED', 'Pediatrics'),
                       ('PHY', 'General/family practice'),
                       ('PIN', 'Pediatric/neonatal intensive care'),
                       ('PPS', 'Pediatric psychiatric'),
                       ('PRE', 'Pediatric rehabilitation'),
                       ('PSI', 'Psychiatric intensive care'),
                       ('PSY', 'Psychiatric'),
                       ('REH', 'Rehabilitation'),
                       ('SUR', 'Surgery'),
                       ('WIC', 'Walk-in clinic'))),
          'HL70267': ('Days of the week',
                      (('FRI', 'Friday'),
                       ('MON', 'Monday'),
                       ('SAT', 'Saturday'),
                       ('SUN', 'Sunday'),
                       ('THU', 'Thursday'),
                       ('TUE', 'Tuesday'),
                       ('WED', 'Wednesday'))),
          'HL70268': ('Override',
                      (('A', 'Override allowed'),
                       ('R', 'Override required'),
                       ('X', 'Override not allowed'))),
          'HL70269': ('Charge on indicator',
                      (('O', 'Charge on Order'), ('R', 'Charge on Result'))),
          'HL70270': ('Document type',
                      (('AR', 'Autopsy report'),
                       ('CD', 'Cardiodiagnostics'),
                       ('CN', 'Consultation'),
                       ('DI', 'Diagnostic imaging'),
                       ('DS', 'Discharge summary'),
                       ('ED', 'Emergency department report'),
                       ('HP', 'History and physical examination'),
                       ('OP', 'Operative report'),
                       ('PC', 'Psychiatric consultation'),
                       ('PH', 'Psychiatric history and physical examination'),
                       ('PN', 'Procedure note'),
                       ('PR', 'Progress note'),
                       ('SP', 'Surgical pathology'),
                       ('TS', 'Transfer summary'))),
          'HL70271': ('Document completion status',
                      (('AU', 'Authenticated'),
                       ('DI', 'Dictated'),
                       ('DO', 'Documented'),
                       ('IN', 'Incomplete'),
                       ('IP', 'In Progress'),
                       ('LA', 'Legally authenticated'),
                       ('PA', 'Pre-authenticated'))),
          'HL70272': ('Document confidentiality status',
                      (('R', 'Restricted'),
                       ('U', 'Usual control'),
                       ('V', 'Very restricted'))),
          'HL70273': ('Document availability status',
                      (('AV', 'Available for patient care'),
                       ('CA', 'Deleted'),
                       ('OB', 'Obsolete'),
                       ('UN', 'Unavailable for patient care'))),
          'HL70275': ('Document storage status',
                      (('AA', 'Active and archived'),
                       ('AC', 'Active'),
                       ('AR', 'Archived (not active)'),
                       ('PU', 'Purged'))),
          'HL70276': ('Appointment reason codes',
                      (('CHECKUP', 'A routine check-up, such as an annual physical'),
                       ('EMERGENCY', 'Emergency appointment'),
                       ('FOLLOWUP', 'A follow up visit from a previous appointment'),
                       ('ROUTINE', 'Routine appointment - default if not valued'),
                       ('WALKIN', 'A previously unscheduled walk-in visit'))),
          'HL70277': ('Appointment type codes',
                      (('Complete',
                        'A request to add a completed appointment, used to maintain records of completed appointments '
                        'that did not appear in the schedule (e.g., STAT, walk-in, etc.)'),
                       ('Normal',
                        'Routine schedule request type - default if not valued'),
                       ('Tentative',
                        'A request for a tentative (e.g., "penciled in") appointment'))),
          'HL70278': ('Filler status codes',
                      (('Blocked', 'The indicated time slot(s) is(are) blocked'),
                       ('Booked', 'The indicated appointment is booked'),
                       ('Cancelled',
                        'The indicated appointment was stopped from occurring (canceled prior to starting)'),
                       ('Complete',
                        'The indicated appointment has completed normally (was not discontinued, canceled, or '
                        'deleted)'),
                       ('Dc',
                        "The indicated appointment was discontinued (DC'ed while in progress, discontinued parent "
                        "appointment, or discontinued child appointment)"),
                       ('Deleted',
                        'The indicated appointment was deleted from the filler application'),
                       ('Overbook',
                        'The appointment has been confirmed; however it is confirmed in an overbooked state'),
                       ('Pending', 'Appointment has not yet been confirmed'),
                       ('Started',
                        'The indicated appointment has begun and is currently in progress'),
                       ('Waitlist',
                        'Appointment has been placed on a waiting list for a particular slot, or set of slots'))),
          'HL70279': ('Allow substitution codes',
                      (('Confirm',
                        'Contact the Placer Contact Person prior to making any substitutions of this resource'),
                       ('No', 'Substitution of this resource is not allowed'),
                       ('Notify',
                        'Notify the Placer Contact Person, through normal institutional procedures, that a '
                        'substitution of this resource has been made'),
                       ('Yes', 'Substitution of this resource is allowed'))),
          'HL70280': ('Referral priority',
                      (('A', 'ASAP'), ('R', 'Routine'), ('S', 'STAT'))),
          'HL70281': ('Referral type',
                      (('Hom', 'Home Care'),
                       ('Lab', 'Laboratory'),
                       ('Med', 'Medical'),
                       ('Psy', 'Psychiatric'),
                       ('Rad', 'Radiology'),
                       ('Skn', 'Skilled Nursing'))),
          'HL70282': ('Referral disposition',
                      (('AM', 'Assume Management'),
                       ('RP', 'Return Patient After Evaluation'),
                       ('SO', 'Second Opinion'),
                       ('WR', 'Send Written Report'))),
          'HL70283': ('Referral status',
                      (('A', 'Accepted'),
                       ('E', 'Expired'),
                       ('P', 'Pending'),
                       ('R', 'Rejected'))),
          'HL70284': ('Referral category',
                      (('A', 'Ambulatory'),
                       ('E', 'Emergency'),
                       ('I', 'Inpatient'),
                       ('O', 'Outpatient'))),
          'HL70286': ('Provider role',
                      (('CP', 'Consulting Provider'),
                       ('PP', 'Primary Care Provider'),
                       ('RP', 'Referring Provider'),
                       ('RT', 'Referred to Provider'))),
          'HL70287': ('Problem/goal action code',
                      (('AD', 'ADD'),
                       ('CO', 'CORRECT'),
                       ('DE', 'DELETE'),
                       ('LI', 'LINK'),
                       ('UC', 'UNCHANGED *'),
                       ('UN', 'UNLINK'),
                       ('UP', 'UPDATE'))),
          'HL70290': ('MIME base64 encoding characters',
                      (('0', 'A'),
                       ('1', 'B'),
                       ('10', 'K'),
                       ('11', 'L'),
                       ('12', 'M'),
                       ('13', 'N'),
                       ('14', 'O'),
                       ('15', 'P'),
                       ('16', 'Q'),
                       ('17', 'R'),
                       ('18', 'S'),
                       ('19', 'T'),
                       ('2', 'C'),
                       ('20', 'U'),
                       ('21', 'V'),
                       ('22', 'W'),
                       ('23', 'X'),
                       ('24', 'Y'),
                       ('25', 'Z'),
                       ('26', 'a'),
                       ('27', 'b'),
                       ('28', 'c'),
                       ('29', 'd'),
                       ('3', 'D'),
                       ('30', 'e'),
                       ('31', 'f'),
                       ('32', 'g'),
                       ('33', 'h'),
                       ('34', 'I'),
                       ('35', 'j'),
                       ('36', 'k'),
                       ('37', 'l'),
                       ('38', 'm'),
                       ('39', 'n'),
                       ('4', 'E'),
                       ('40', 'o'),
                       ('41', 'p'),
                       ('42', 'q'),
                       ('43', 'r'),
                       ('44', 's'),
                       ('45', 't'),
                       ('46', 'u'),
                       ('47', 'v'),
                       ('48', 'w'),
                       ('49', 'x'),
                       ('5', 'F'),
                       ('50', 'y'),
                       ('51', 'z'),
                       ('52', '0'),
                       ('53', '1'),
                       ('54', '2'),
                       ('55', '3'),
                       ('56', '4'),
                       ('57', '5'),
                       ('58', '6'),
                       ('59', '7'),
                       ('6', 'G'),
                       ('60', '8'),
                       ('61', '9'),
                       ('62', '+'),
                       ('63', '/'),
                       ('7', 'H'),
                       ('8', 'I'),
                       ('9', 'J'),
                       ('(pad)', '='))),
          'HL70291': ('Subtype of referenced data',
                      (('BASIC', 'ISDN PCM audio data'),
                       ('DICOM', 'Digital Imaging and Communications in Medicine'),
                       ('FAX', 'Facsimile data'),
                       ('GIF', 'Graphics Interchange Format'),
                       ('HTML', 'Hypertext Markup Language'),
                       ('JOT', 'Electronic ink data (Jot 1.0 standard)'),
                       ('JPEG', 'Joint Photographic Experts Group'),
                       ('Octet-stream', 'Uninterpreted binary data'),
                       ('PICT', 'PICT format image data'),
                       ('PostScript', 'PostScript program'),
                       ('RTF', 'Rich Text Format'),
                       ('SGML',
                        'Standard Generalized Markup Language (HL7 V2.3.1 and later)'),
                       ('TIFF', 'TIFF image data'),
                       ('x-hl7-cda-level-one',
                        'HL7 Clinical Document Architecture Level One document'),
                       ('XML', 'Extensible Markup Language (HL7 V2.3.1 and later)'))),
          'HL70292': ('Vaccines administered (code = CVX)(parenteral, unless oral is noted)',
                      (('01', 'diphtheria, tetanus toxoids and pertussis vaccine'),
                       ('02', 'poliovirus vaccine, live, oral'),
                       ('03', 'measles, mumps and rubella virus vaccine'),
                       ('04', 'measles and rubella virus vaccine'),
                       ('05', 'measles virus vaccine'),
                       ('06', 'rubella virus vaccine'),
                       ('07', 'mumps virus vaccine'),
                       ('08',
                        'hepatitis B vaccine, pediatric or pediatric/adolescent dosage'),
                       ('09',
                        'tetanus and diphtheria toxoids, adsorbed for adult use'),
                       ('10', 'poliovirus vaccine, inactivated'),
                       ('100', 'pneumococcal conjugate vaccine, polyvalent'),
                       ('101', 'Typhoid Vi capsular polysaccharide vaccine'),
                       ('11', 'pertussis vaccine'),
                       ('12', 'diphtheria antitoxin'),
                       ('13', 'tetanus immune globulin'),
                       ('14', 'immune globulin, NOS'),
                       ('15',
                        'influenza virus vaccine, split virus (incl. purified surface antigen)'),
                       ('16', 'influenza virus vaccine, whole virus'),
                       ('17', 'Haemophilus influenzae type b vaccine, conjugate NOS'),
                       ('18', 'rabies vaccine, for intramuscular injection'),
                       ('19', 'Bacillus Calmette-Guerin vaccine'),
                       ('20',
                        'diphtheria, tetanus toxoids and acellular pertussis vaccine'),
                       ('21', 'varicella virus vaccine'),
                       ('22', 'DTP-Haemophilus influenzae type b conjugate vaccine'),
                       ('23', 'plague vaccine'),
                       ('24', 'anthrax vaccine'),
                       ('25', 'typhoid vaccine, live, oral'),
                       ('26', 'cholera vaccine'),
                       ('27', 'botulinum antitoxin'),
                       ('28',
                        'diphtheria and tetanus toxoids, adsorbed for pediatric use'),
                       ('29', 'cytomegalovirus immune globulin, intravenous'),
                       ('30', 'hepatitis B immune globulin'),
                       ('31', 'hepatitis A vaccine, pediatric dosage, NOS'),
                       ('32', 'meningococcal polysaccharide vaccine'),
                       ('33', 'pneumococcal polysaccharide vaccine'),
                       ('34', 'rabies immune globulin'),
                       ('35', 'tetanus toxoid'),
                       ('36', 'varicella zoster immune globulin'),
                       ('37', 'yellow fever vaccine'),
                       ('38', 'rubella and mumps virus vaccine'),
                       ('39', 'Japanese encephalitis vaccine'),
                       ('40', 'rabies vaccine, for intradermal injection'),
                       ('41',
                        'typhoid vaccine, parenteral, other than acetone-killed, dried'),
                       ('42',
                        'hepatitis B vaccine, adolescent/high risk infant dosage'),
                       ('43', 'hepatitis B vaccine, adult dosage'),
                       ('44', 'hepatitis B vaccine, dialysis patient dosage'),
                       ('45', 'hepatitis B vaccine, NOS'),
                       ('46',
                        'Haemophilus influenzae type b vaccine, PRP-D conjugate'),
                       ('47',
                        'Haemophilus influenzae type b vaccine, HbOC conjugate'),
                       ('48',
                        'Haemophilus influenzae type b vaccine, PRP-T conjugate'),
                       ('49',
                        'Haemophilus influenzae type b vaccine, PRP-OMP conjugate'),
                       ('50', 'DTaP-Haemophilus influenzae type b conjugate vaccine'),
                       ('51',
                        'Haemophilus influenzae type b conjugate and Hepatitis B vaccine'),
                       ('52', 'hepatitis A vaccine, adult dosage'),
                       ('53',
                        'typhoid vaccine, parenteral, acetone-killed, dried (U.S. military)'),
                       ('54', 'adenovirus vaccine, type 4, live, oral'),
                       ('55', 'adenovirus vaccine, type 7, live, oral'),
                       ('56', 'dengue fever vaccine'),
                       ('57', 'hantavirus vaccine'),
                       ('58', 'hepatitis C vaccine'),
                       ('59', 'hepatitis E vaccine'),
                       ('60', 'herpes simplex virus, type 2 vaccine'),
                       ('61', 'human immunodeficiency virus vaccine'),
                       ('62', 'human papilloma virus vaccine'),
                       ('63', 'Junin virus vaccine'),
                       ('64', 'leishmaniasis vaccine'),
                       ('65', 'leprosy vaccine'),
                       ('66', 'Lyme disease vaccine'),
                       ('67', 'malaria vaccine'),
                       ('68', 'melanoma vaccine'),
                       ('69', 'parainfluenza-3 virus vaccine'),
                       ('70', 'Q fever vaccine'),
                       ('71',
                        'respiratory syncytial virus immune globulin, intravenous'),
                       ('72', 'rheumatic fever vaccine'),
                       ('73', 'Rift Valley fever vaccine'),
                       ('74', 'rotavirus vaccine, tetravalent, live, oral'),
                       ('75', 'smallpox vaccine'),
                       ('76', 'Staphylococcus bacteriophage lysate'),
                       ('77', 'tick-borne encephalitis vaccine'),
                       ('78', 'tularemia vaccine'),
                       ('79', 'vaccinia immune globulin'),
                       ('80', 'Venezuelan equine encephalitis, live, attenuated'),
                       ('81', 'Venezuelan equine encephalitis, inactivated'),
                       ('82', 'adenovirus vaccine, NOS'),
                       ('83',
                        'hepatitis A vaccine, pediatric/adolescent dosage, 2 dose schedule'),
                       ('84',
                        'hepatitis A vaccine, pediatric/adolescent dosage, 3 dose schedule'),
                       ('85', 'hepatitis A vaccine, NOS'),
                       ('86', 'immune globulin, intramuscular'),
                       ('87', 'immune globulin, intravenous'),
                       ('88', 'influenza virus vaccine, NOS'),
                       ('89', 'poliovirus vaccine, NOS'),
                       ('90', 'rabies vaccine, NOS'),
                       ('91', 'typhoid vaccine, NOS'),
                       ('92', 'Venezuelan equine encephalitis vaccine, NOS'),
                       ('93',
                        'respiratory syncytial virus monoclonal antibody (palivizumab), intramuscular'),
                       ('94', 'measles, mumps, rubella, and varicella virus vaccine'),
                       ('95',
                        'tuberculin skin test; old tuberculin, multipuncture device'),
                       ('96',
                        'tuberculin skin test; purified protein derivative solution, intradermal'),
                       ('97',
                        'tuberculin skin test; purified protein derivative, multipuncture device'),
                       ('98', 'tuberculin skin test; NOS'),
                       ('99', 'RESERVED - do not use'),
                       ('999', 'unknown vaccine or immune globulin'))),
          'HL70294': ('Time selection criteria parameter class codes',
                      (('Fri',
                        'An indicator that Friday is or is not preferred for the day on which the appointment will '
                        'occur. OK = Preferred appointment day; NO = Day is not preferred'),
                       ('Mon',
                        'An indicator that Monday is or is not preferred for the day on which the appointment will '
                        'occur. OK = Preferred appointment day; NO = Day is not preferred'),
                       ('Prefend',
                        'The preferred end time for the appointment request, service or resource. Any legal time '
                        'specification in the format HHMM, using 24-hour clock notation'),
                       ('Prefstart',
                        'The preferred start time for the appointment request, service or resource. Any legal time '
                        'specification in the format HHMM, using 24-hour clock notation'),
                       ('Sat',
                        'An indicator that Saturday is or is not preferred for the day on which the appointment will '
                        'occur. OK = Preferred appointment day; NO = Day is not preferred'),
                       ('Sun',
                        'An indicator that Sunday is or is not preferred for the day on which the appointment will '
                        'occur. OK = Preferred appointment day; NO = Day is not preferred'),
                       ('Thu',
                        'An indicator that Thursday is or is not preferred for the day on which the appointment will '
                        'occur. OK = Preferred appointment day; NO = Day is not preferred'),
                       ('Tue',
                        'An indicator that Tuesday is or is not preferred for the day on which the appointment will '
                        'occur. OK = Preferred appointment day; NO = Day is not preferred'),
                       ('Wed',
                        'An indicator that Wednesday is or is not preferred for the day on which the appointment will '
                        'occur. OK = Preferred appointment day; NO = Day is not preferred'))),
          'HL70298': ('CP range type',
                      (('F',
                        'Flat-rate. Apply the entire price to this interval, do not pro-rate the price if the full '
                        'interval has not occurred/been consumed'),
                       ('P',
                        'Pro-rate. Apply this price to this interval, pro-rated by whatever portion of the interval '
                        'has occurred/been consumed'))),
          'HL70299': ('Encoding',
                      (('A', 'No encoding - data are displayable ASCII characters.'),
                       ('Base64',
                        'Encoding as defined by MIME (Multipurpose Internet Mail Extensions) standard RFC 1521. Four '
                        'consecutive ASCII characters represent three consecutive octets of binary data. Base64 '
                        'utilizes a 65-character subset of US-ASCII, consisting of both the upper a'),
                       ('Hex',
                        'Hexadecimal encoding - consecutive pairs of hexadecimal digits represent consecutive single '
                        'octets.'))),
          'HL70301': ('Universal ID type',
                      (('DNS',
                        'An Internet dotted name. Either in ASCII or as integers'),
                       ('GUID', 'Same as UUID.'),
                       ('HCD',
                        'The CEN Healthcare Coding Scheme Designator. (Identifiers used in DICOM follow this '
                        'assignment scheme.)'),
                       ('HL7', 'Reserved for future HL7 registration schemes'),
                       ('ISO',
                        'An International Standards Organization Object Identifier'),
                       ('L,M,N',
                        'These are reserved for locally defined coding schemes.'),
                       ('Random',
                        'Usually a base64 encoded string of random bits. The uniqueness depends on the length of '
                        'the bits. Mail systems often generate ASCII string "unique names," from a combination of '
                        'random bits and system names. Obviously, such identifiers will not be con'),
                       ('UUID', 'The DCE Universal Unique Identifier'),
                       ('x400', 'An X.400 MHS format identifier'),
                       ('x500', 'An X.500 directory name'))),
          'HL70305': ('Person location type',
                      (('C', 'Clinic'),
                       ('D', 'Department'),
                       ('H', 'Home'),
                       ('N', 'Nursing Unit'),
                       ('O', "Provider's Office"),
                       ('P', 'Phone'),
                       ('S', 'SNF'))),
          'HL70309': ('Coverage type',
                      (('B', 'Both hospital and physician'),
                       ('H', 'Hospital/institutional'),
                       ('P', 'Physician/professional'))),
          'HL70311': ('Job status',
                      (('O', 'Other'),
                       ('P', 'Permanent'),
                       ('T', 'Temporary'),
                       ('U', 'Unknown'))),
          'HL70315': ('Living will code',
                      (('F', 'Yes, patient has a living will but it is not on file'),
                       ('I',
                        'No, patient does not have a living will but information was provided'),
                       ('N',
                        'No, patient does not have a living will and no information was provided'),
                       ('U', 'Unknown'),
                       ('Y', 'Yes, patient has a living will'))),
          'HL70316': ('Organ donor code',
                      (('F',
                        'Yes, patient is a documented donor, but documentation is not on file'),
                       ('I',
                        'No, patient is not a documented donor, but information was provided'),
                       ('N', 'No, patient has not agreed to be a donor'),
                       ('P',
                        'Patient leaves organ donation decision to a specific person'),
                       ('R', 'Patient leaves organ donation decision to relatives'),
                       ('U', 'Unknown'),
                       ('Y',
                        'Yes, patient is a documented donor and documentation is on file'))),
          'HL70317': ('Annotations',
                      (('9900', 'Pace spike'),
                       ('9901', 'SAS marker'),
                       ('9902', 'Sense marker'),
                       ('9903', 'Beat marker'),
                       ('9904', 'etc.'))),
          'HL70321': ('Dispense method',
                      (('AD', 'Automatic Dispensing'),
                       ('F', 'Floor Stock'),
                       ('TR', 'Traditional'),
                       ('UD', 'Unit Dose'))),
          'HL70322': ('Completion status',
                      (('CP', 'Complete'),
                       ('NA', 'Not Administered'),
                       ('PA', 'Partially Administered'),
                       ('RE', 'Refused'))),
          'HL70323': ('Action code',
                      (('A', 'Add/Insert'), ('D', 'Delete'), ('U', 'Update'))),
          'HL70324': ('Location characteristic ID',
                      (('GEN', 'Gender of patient(s)'),
                       ('IMP', 'Implant: can be used for radiation implant patients'),
                       ('INF',
                        'Infectious disease: this location can be used for isolation'),
                       ('LCR', 'Level of care'),
                       ('LIC', 'Licensed'),
                       ('OVR', 'Overflow'),
                       ('PRL',
                        'Privacy level: indicating the level of private versus non-private room'),
                       ('SET', 'Bed is set up'),
                       ('SHA',
                        'Shadow: a temporary holding location that does not physically exist'),
                       ('SMK', 'Smoking'),
                       ('STF', 'Bed is staffed'),
                       ('TEA', 'Teaching location'))),
          'HL70325': ('Location relationship ID',
                      (('ALI', 'Location Alias(es)'),
                       ('DTY', 'Nearest dietary location'),
                       ('LAB', 'Nearest lab'),
                       ('LB2', 'Second nearest lab'),
                       ('PAR', 'Parent location'),
                       ('RX', 'Nearest pharmacy'),
                       ('RX2', 'Second nearest pharmacy'))),
          'HL70326': ('Visit indicator',
                      (('A', 'Account level (default)'), ('V', 'Visit level'))),
          'HL70329': ('Quantity method',
                      (('A', 'Actual count'), ('E', 'Estimated (see comment)'))),
          'HL70330': ('Marketing basis',
                      (('510E', '510 (K) exempt'),
                       ('510K', '510 (K)'),
                       ('522S', 'Post marketing study (522)'),
                       ('PMA', 'Premarketing authorization'),
                       ('PRE', 'Preamendment'),
                       ('TXN', 'Transitional'))),
          'HL70331': ('Facility type',
                      (('A', 'Agent for a foreign manufacturer'),
                       ('D', 'Distributor'),
                       ('M', 'Manufacturer'),
                       ('U', 'User'))),
          'HL70332': ('Source type', (('A', 'Accept'), ('I', 'Initiate'))),
          'HL70334': ('Disabled person',
                      (('AP', 'Associated party'),
                       ('GT', 'Guarantor'),
                       ('IN', 'Insured'),
                       ('PT', 'Patient'))),
          'HL70335': ('Repeat pattern',
                      (('A', 'Ante (before)'),
                       ('BID',
                        'twice a day at institution-specified times (e.g., 9AM-4PM)'),
                       ('C',
                        'service is provided continuously between start time and stop time'),
                       ('D', 'Cibus Diurnus (lunch)'),
                       ('I',
                        'Inter (e.g., between this meal and the next, between dinner and sleep'),
                       ('M', 'Cibus Matutinus (breakfast)'),
                       ('Meal Related Timings', '<timing>C ("cum")<meal>'),
                       ('Once',
                        'one time only. This is also the default when this component is null.'),
                       ('P', 'Post (after)'),
                       ('PRN', 'given as needed'),
                       ('PRNxxx',
                        'where xxx is some frequency code (e.g., PRNQ6H); given as needed over the frequency period.'),
                       ('QAM', 'in the morning at institution-specified time'),
                       ('QHS', 'every day before the hour of sleep'),
                       ('QID',
                        'four times a day at institution-specified times (e.g., 9AM-11AM-4PM-9PM)'),
                       ('Q<integer>D', 'every <integer> days'),
                       ('Q<integer>H', 'every <integer> hours'),
                       ('Q<integer>J<day#>',
                        'repeats on a particular day of the week, from the French jour (day). If <integer> is '
                        'missing, the repeat rate is assumed to be 1. Day numbers are counted from 1=Monday to '
                        '7=Sunday. So Q2J2 means every second Tuesday; Q1J6 means every Saturday.'),
                       ('Q<integer>L', 'every <integer> months (Lunar cycle)'),
                       ('Q<integer>M', 'every <integer> minutes'),
                       ('Q<integer>S', 'every <integer> seconds'),
                       ('Q<integer>W', 'every <integer> weeks'),
                       ('QOD', 'every other day (same as Q2D)'),
                       ('QPM', 'in the evening at institution-specified time'),
                       ('QSHIFT',
                        'during each of three eight-hour shifts at institution-specified times'),
                       ('TID',
                        'three times a day at institution-specified times (e.g., 9AM-4PM-9PM)'),
                       ('U <spec>',
                        'for future use, where <spec> is an interval specification as defined by the UNIX cron '
                        'specification.'),
                       ('V', 'Cibus Vespertinus (dinner)'),
                       ('xID',
                        '"X" times per day at institution-specified times, where X is a numeral 5 or greater. '
                        'E.g., 5ID=five times per day; 8ID=8 times per day'))),
          'HL70336': ('Referral reason',
                      (('O', 'Provider Ordered'),
                       ('P', 'Patient Preference'),
                       ('S', 'Second Opinion'),
                       ('W', 'Work Load'))),
          'HL70337': ('Certification status', (('C', 'Certified'), ('E', 'Eligible'))),
          'HL70338': ('Practitioner ID number type',
                      (('CY', 'County number'),
                       ('DEA', 'Drug Enforcement Agency no.'),
                       ('GL', 'General ledger number'),
                       ('L&I', 'Labor and industries number'),
                       ('MCD', 'Medicaid number'),
                       ('MCR', 'Medicare number'),
                       ('QA', 'QA number'),
                       ('SL', 'State license number'),
                       ('TAX', 'Tax ID number'),
                       ('TRL', 'Training license number'),
                       ('UPIN', 'Unique physician ID no.'))),
          'HL70339': ('Advanced beneficiary notice code',
                      (('1', 'Service is subject to medical necessity procedures'),
                       ('2',
                        'Patient has been informed of responsibility, and agrees to pay for service'),
                       ('3',
                        'Patient has been informed of responsibility, and asks that the payer be billed'),
                       ('4', 'Advanced Beneficiary Notice has not been signed'))),
          'HL70344': ("Patient's relationship to insured",
                      (('01', 'Patient is insured'),
                       ('02', 'Spouse'),
                       ('03', 'Natural child/insured financial responsibility'),
                       ('04',
                        'Natural child/Insured does not have financial responsibility'),
                       ('05', 'Step child'),
                       ('06', 'Foster child'),
                       ('07', 'Ward of the court'),
                       ('08', 'Employee'),
                       ('09', 'Unknown'),
                       ('10', 'Handicapped dependent'),
                       ('11', 'Organ donor'),
                       ('12', 'Cadaver donor'),
                       ('13', 'Grandchild'),
                       ('14', 'Niece/nephew'),
                       ('15', 'Injured plaintiff'),
                       ('16', 'Sponsored dependent'),
                       ('17', 'Minor dependent of a minor dependent'),
                       ('18', 'Parent'),
                       ('19', 'Grandparent'))),
          'HL70348': ('Special program indicator',
                      (('01', 'EPSDT-CHAP'),
                       ('02', "Physically handicapped children's program"),
                       ('03', 'Special federal funding'),
                       ('04', 'Family planning'),
                       ('05', 'Disability'),
                       ('06', 'PPV/Medicare 100% payment'),
                       ('07', 'Induced abortion-danger to life'),
                       ('08', 'Induced abortion victim rape/incest'))),
          'HL70349': ('PSRO/UR approval indicator',
                      (('1', 'Approved by the PSRO/UR as billed'),
                       ('2', 'Automatic approval as billed based on focused review'),
                       ('3', 'Partial approval'),
                       ('4', 'Admission denied'),
                       ('5', 'Postpayment review applicable'))),
          'HL70350': ('Occurrence code',
                      (('01', 'Auto accident'),
                       ('02',
                        'No fault insurance involved-including auto accident/other'),
                       ('03', 'Accident/tort liability'),
                       ('04', 'Accident/employment related'),
                       ('05', 'Other accident'),
                       ('06', 'Crime victim'),
                       ('09', 'Start of infertility treatment cycle'),
                       ('10', 'Last menstrual period'),
                       ('11', 'Onset of symptoms/illness'),
                       ('12', 'Date of onset for a chronically dependent individual'),
                       ('17',
                        'Date outpatient occupational therapy plan established or last reviewed'),
                       ('18', 'Date of retirement patient/beneficiary'),
                       ('19', 'Date of retirement spouse'),
                       ('20', 'Guarantee of payment began'),
                       ('21', 'UR notice received'),
                       ('22', 'Date active care ended'),
                       ('24', 'Date insurance denied'),
                       ('25', 'Date benefits terminated by primary payor'),
                       ('26', 'Date SNF bed available'),
                       ('27', 'Date home health plan established'),
                       ('28', "Spouse's date of birth"),
                       ('29',
                        'Date outpatient physical therapy plan established or last reviewed'),
                       ('30',
                        'Date outpatient speech pathology plan established or last reviewed'),
                       ('31',
                        'Date beneficiary notified of intent to bill (accommodations)'),
                       ('32',
                        'Date beneficiary notified of intent to bill (procedures or treatments)'),
                       ('33',
                        'First day of the Medicare coordination period for ESRD beneficiaries covered by EGHP'),
                       ('34', 'Date of election of extended care facilities'),
                       ('35', 'Date treatment started for P.T.'),
                       ('36',
                        'Date of inpatient hospital discharge for covered transplant patients'),
                       ('37',
                        'Date of inpatient hospital discharge for non-covered transplant patient'),
                       ('40', 'Scheduled date of admission'),
                       ('41', 'Date of first test for pre-admission testing'),
                       ('42', 'Date of discharge'),
                       ('43', 'Scheduled date of canceled surgery'),
                       ('44', 'Date treatment started for O.T.'),
                       ('45', 'Date treatment started for S.T.'),
                       ('46', 'Date treatment started for cardiac rehab.'),
                       ('47 ... 49', 'Payer codes'),
                       ('50', 'Date lien released'),
                       ('51', 'Date treatment started for psychiatric care'),
                       ('70 ... 99', 'Occurrence span codes and dates'),
                       ('A1', 'Birthdate - insured A'),
                       ('A2', 'Effective date - insured A policy'),
                       ('A3', 'Benefits exhausted payer A'))),
          'HL70351': ('Occurrence span',
                      (('70', 'Qualifying stay dates for SNF'),
                       ('71', 'Prior stay dates'),
                       ('72', 'First/last visit'),
                       ('73', 'Benefit eligibility period'),
                       ('74', 'Non-covered level of care'),
                       ('75', 'SNF level of care'),
                       ('76', 'Patient liability'),
                       ('77', 'Provider liability period'),
                       ('78', 'SNF prior stay dates'),
                       ('79', 'Payer code'),
                       ('M0', 'PSRO/UR approved stay dates'))),
          'HL70353': ('CWE statuses',
                      (('NA', 'Not applicable'),
                       ('NASK', 'Not asked'),
                       ('NAV', 'Not available'),
                       ('U', 'Unknown'),
                       ('UASK', 'Asked but Unknown'))),
          'HL70354': ('Message structure',
                      (('ACK', 'Varies'),
                       ('ADR_A19', 'A19'),
                       ('ADT_A01', 'A01, A04, A08, A13'),
                       ('ADT_A02', 'A02'),
                       ('ADT_A03', 'A03'),
                       ('ADT_A05', 'A05, A14, A28, A31'),
                       ('ADT_A06', 'A06, A07'),
                       ('ADT_A09', 'A09, A10, A11, A12'),
                       ('ADT_A15', 'A15'),
                       ('ADT_A16', 'A16'),
                       ('ADT_A17', 'A17'),
                       ('ADT_A18', 'A18'),
                       ('ADT_A20', 'A20'),
                       ('ADT_A21', 'A21, A22, A23, A25, A26, A27, A29, A32, A33'),
                       ('ADT_A24', 'A24'),
                       ('ADT_A30', 'A30, A34, A35, A36, A46, A47, A48, A49'),
                       ('ADT_A37', 'A37'),
                       ('ADT_A38', 'A38'),
                       ('ADT_A39', 'A39, A40, A41, A42'),
                       ('ADT_A43', 'A43, A44'),
                       ('ADT_A45', 'A45'),
                       ('ADT_A50', 'A50, A51'),
                       ('ADT_A52', 'A52, A53, A55'),
                       ('ADT_A54', 'A54'),
                       ('ADT_A60', 'A60'),
                       ('ADT_A61', 'A61, A62'),
                       ('BAR_P01', 'P01'),
                       ('BAR_P02', 'P02'),
                       ('BAR_P05', 'P05'),
                       ('BAR_P06', 'P06'),
                       ('BAR_P10', 'P10'),
                       ('CRM_C01', 'C01, C02, C03, C04, C05, C06, C07, C08'),
                       ('CSU_C09', 'C09, C10, C11, C12'),
                       ('DFT_P03', 'P03'),
                       ('DOC_T12', 'T12'),
                       ('DSR_P04', 'P04'),
                       ('DSR_Q01', 'Q01'),
                       ('DSR_Q03', 'Q03'),
                       ('EAC_U07', 'U07'),
                       ('EAN_U09', 'U09'),
                       ('EAR_U08', 'U08'),
                       ('EDR_R07', 'R07'),
                       ('EQQ_Q04', 'Q04'),
                       ('ERP_R09', 'R09'),
                       ('ESR_U02', 'U02'),
                       ('ESU_U01', 'U01'),
                       ('INR_U06', 'U06'),
                       ('INU_U05', 'U05'),
                       ('LSU_U12', 'U12, U13'),
                       ('MDM_T01', 'T01, T03, T05, T07, T09, T11'),
                       ('MDM_T02', 'T02, T04, T06, T08, T10'),
                       ('MFD_MFA', 'MFA'),
                       ('MFK_M01',
                        'M01, M02, M03, M04, M05, M06, M07, M08, M09, M10, M11'),
                       ('MFN_M01', 'M01'),
                       ('MFN_M02', 'M02'),
                       ('MFN_M03', 'M03'),
                       ('MFN_M04', 'M04'),
                       ('MFN_M05', 'M05'),
                       ('MFN_M06', 'M06'),
                       ('MFN_M07', 'M07'),
                       ('MFN_M08', 'M08'),
                       ('MFN_M09', 'M09'),
                       ('MFN_M10', 'M10'),
                       ('MFN_M11', 'M11'),
                       ('MFN_M12', 'M12'),
                       ('MFQ_M01', 'M01-M06'),
                       ('MFR_M01', 'M01-M06'),
                       ('NMD_N02', 'N02'),
                       ('NMQ_N01', 'N01'),
                       ('NMR_N01', 'N01'),
                       ('OMD_O03', 'O03'),
                       ('OMG_O19', 'O19'),
                       ('OML_O21', 'O21'),
                       ('OMN_O07', 'O07'),
                       ('OMP_O09', 'O09'),
                       ('OMS_O05', 'O05'),
                       ('ORD_O04', 'O04'),
                       ('ORF_R04', 'R04'),
                       ('ORG_O20', 'O20'),
                       ('ORL_O22', 'O22'),
                       ('ORM_O01', 'O01'),
                       ('ORN_O08', 'O08'),
                       ('ORP_O10', 'O10'),
                       ('ORR_O02', 'O02'),
                       ('ORS_O06', 'O06'),
                       ('ORU_R01', 'R01'),
                       ('ORU_W01', 'W01'),
                       ('OSQ_Q06', 'Q06'),
                       ('OSR_Q06', 'Q06'),
                       ('OUL_R21', 'R21'),
                       ('PEX_P07', 'P07, P08'),
                       ('PGL_PC6', 'PC6, PC7, PC8'),
                       ('PMU_B01', 'B01, B02'),
                       ('PMU_B03', 'B03'),
                       ('PMU_B04', 'B04, B05'),
                       ('PPG_PCG', 'PCG, PCH, PCJ'),
                       ('PPP_PCB', 'PCB, PCC, PCD'),
                       ('PPR_PC1', 'PC1, PC2, PC3'),
                       ('PPT_PCL', 'PCL'),
                       ('PPV_PCA', 'PCA'),
                       ('PRR_PC5', 'PC5'),
                       ('PTR_PCF', 'PCF'),
                       ('QBP_Q11', 'Q11'),
                       ('QBP_Q13', 'Q13'),
                       ('QBP_Q15', 'Q15'),
                       ('QBP_Q21', 'Q21, Q22, Q23, Q24, Q25'),
                       ('QCK_Q02', 'Q02'),
                       ('QCN_J01', 'J01, J02'),
                       ('QRY_A19', 'A19'),
                       ('QRY_PC4', 'PC4, PC9, PCE, PCK'),
                       ('QRY_Q01', 'Q01'),
                       ('QRY_Q02', 'Q02'),
                       ('QRY_R02', 'R02'),
                       ('QRY_T12', 'T12'),
                       ('QSB_Q16', 'Q16'),
                       ('QVR_Q17', 'Q17'),
                       ('RAR_RAR', 'RAR'),
                       ('RAS_O17', 'O17'),
                       ('RCI_I05', 'I05'),
                       ('RCL_I06', 'I06'),
                       ('RDE_O11', 'O11'),
                       ('RDR_RDR', 'RDR'),
                       ('RDS_O13', 'O13'),
                       ('RDY_K11', 'K11'),
                       ('RDY_K15', 'K15'),
                       ('REF_I12', 'I12, I13, I14, I15'),
                       ('RER_RER', 'RER'),
                       ('RGR_RGR', 'RGR'),
                       ('RGV_O15', 'O15'),
                       ('ROR_ROR', 'ROR'),
                       ('RPA_I08', 'I08, I09. I10, 1II'),
                       ('RPI_I01', 'I01, I04'),
                       ('RPI_I04', 'I04'),
                       ('RPL_I02', 'I02'),
                       ('RPR_I03', 'I03'),
                       ('RQA_I08', 'I08, I09, I10, I11'),
                       ('RQC_I05', 'I05, I06'),
                       ('RQI_I01', 'I01, I02, I03, I07'),
                       ('RQP_I04', 'I04'),
                       ('RQQ_Q09', 'Q09'),
                       ('RRA_O18', 'O18'),
                       ('RRD_O14', 'O14'),
                       ('RRE_O12', 'O12'),
                       ('RRG_O16', 'O16'),
                       ('RRI_I12', 'I12, I13, I14, I15'),
                       ('RSP_K21', 'K21'),
                       ('RSP_K22', 'K22'),
                       ('RSP_K23', 'K23, K24'),
                       ('RSP_K24', 'K24'),
                       ('RSP_K25', 'K25'),
                       ('RTB_K13', 'K13'),
                       ('SIU_S12',
                        'S12, S13, S14, S15, S16, S17, S18, S19, S20, S21, S22, S23, S24, S26'),
                       ('SPQ_Q08', 'Q08'),
                       ('SQM_S25', 'S25'),
                       ('SQR_S25', 'S25'),
                       ('SRM_S01',
                        'S01, S02, S03, S04, S05, S06, S07, S08, S09, S10, S11'),
                       ('SRR_S01',
                        'S01, S02, S03, S04, S05, S06, S07, S08, S09, S10, S11'),
                       ('SSR_U04', 'U04'),
                       ('SSU_U03', 'U03'),
                       ('SUR_P09', 'P09'),
                       ('TBR_R08', 'R08'),
                       ('TCU_U10', 'U10, U11'),
                       ('UDM_Q05', 'Q05'),
                       ('VQQ_Q07', 'Q07'),
                       ('VXQ_V01', 'V01'),
                       ('VXR_V03', 'V03'),
                       ('VXU_V04', 'V04'),
                       ('VXX_V02', 'V02'))),
          'HL70355': ('Primary key value type',
                      (('CE', 'Coded element'), ('PL', 'Person location'))),
          'HL70356': ('Alternate character set handling scheme',
                      (('2.3',
                        'The character set switching mode specified in HL7 2.3, sections 2.8.28.6.1, and 2.9.2. '
                        'Note that the escape sequences used in this mode do not use the ASCII "esc" character. '
                        'They are "HL7 escape sequences" as defined in HL7 2.3, sec. 2.9 as defined in I'),
                       ('ISO 2022-1994',
                        'This standard is titled "Information Technology - Character Code Structure and Extension '
                        'Technique". This standard specifies an escape sequence from basic one byte character set '
                        'to specified other character set, and vice versa. The escape sequence explic'),
                       ('<null>',
                        'This is the default, indicating that there is no character set switching occurring in this '
                        'message.'))),
          'HL70357': ('Message error condition codes',
                      (('0', 'Message accepted'),
                       ('100', 'Segment sequence error'),
                       ('101', 'Required field missing'),
                       ('102', 'Data type error'),
                       ('103', 'Table value not found'),
                       ('200', 'Unsupported message type'),
                       ('201', 'Unsupported event code'),
                       ('202', 'Unsupported processing id'),
                       ('203', 'Unsupported version id'),
                       ('204', 'Unknown key identifier'),
                       ('205', 'Duplicate key identifier'),
                       ('206', 'Application record locked'),
                       ('207', 'Application internal error'),
                       ('Errors', ''),
                       ('Rejection', ''),
                       ('Success', ''))),
          'HL70359': ('Diagnosis priority',
                      (('0', 'Not included in diagnosis ranking'),
                       ('1', 'The primary diagnosis'),
                       ('2 ...', 'For ranked secondary diagnoses'))),
          'HL70360': ('Degree',
                      (('AA', 'Associate of Arts'),
                       ('AAS', 'Associate of Applied Science'),
                       ('ABA', 'Associate of Business Administration'),
                       ('AE', 'Associate of Engineering'),
                       ('AS', 'Associate of Science'),
                       ('BA', 'Bachelor of Arts'),
                       ('BBA', 'Bachelor of Business Administration'),
                       ('BE', 'Bachelor or Engineering'),
                       ('BFA', 'Bachelor of Fine Arts'),
                       ('BN', 'Bachelor of Nursing'),
                       ('BS', 'Bachelor of Science'),
                       ('BSL', 'Bachelor of Science - Law'),
                       ('BT', 'Bachelor of Theology'),
                       ('CER', 'Certificate'),
                       ('DBA', 'Doctor of Business Administration'),
                       ('DED', 'Doctor of Education'),
                       ('DIP', 'Diploma'),
                       ('DO', 'Doctor of Osteopathy'),
                       ('HS', 'High School Graduate'),
                       ('JD', 'Juris Doctor'),
                       ('MA', 'Master of Arts'),
                       ('MBA', 'Master of Business Administration'),
                       ('MCE', 'Master of Civil Engineering'),
                       ('MD', 'Doctor of Medicine'),
                       ('MDI', 'Master of Divinity'),
                       ('ME', 'Master of Engineering'),
                       ('MED', 'Master of Education'),
                       ('MEE', 'Master of Electrical Engineering'),
                       ('MFA', 'Master of Fine Arts'),
                       ('MME', 'Master of Mechanical Engineering'),
                       ('MS', 'Master of Science'),
                       ('MSL', 'Master of Science - Law'),
                       ('MT', 'Master of Theology'),
                       ('NG', 'Non-Graduate'),
                       ('PharmD', 'Doctor of Pharmacy'),
                       ('PHD', 'Doctor of Philosophy'),
                       ('PHE', 'Doctor of Engineering'),
                       ('PHS', 'Doctor of Science'),
                       ('SEC', 'Secretarial Certificate'),
                       ('TS', 'Trade School Graduate'))),
          'HL70363': ('Assigning authority',
                      (('AUSDVA', 'Australia - Dept. of Veterans Affairs'),
                       ('AUSHIC', 'Australia - Health Insurance Commission'),
                       ('CANAB', 'Canada - Alberta'),
                       ('CANBC', 'Canada - British Columbia'),
                       ('CANMB', 'Canada - Manitoba'),
                       ('CANNB', 'Canada - New Brunswick'),
                       ('CANNF', 'Canada - Newfoundland'),
                       ('CANNS', 'Canada - Nova Scotia'),
                       ('CANNT', 'Canada - Northwest Territories'),
                       ('CANNU', 'Canada - Nanavut'),
                       ('CANON', 'Canada - Ontario'),
                       ('CANPE', 'Canada - Prince Edward Island'),
                       ('CANQC', 'Canada - Quebec'),
                       ('CANSK', 'Canada - Saskatchewan'),
                       ('CANYT', 'Canada - Yukon Territories'),
                       ('NLVWS',
                        'NL - Ministerie van Volksgezondheid, Welzijn en Sport'),
                       ('USCDC', 'US Center for Disease Control'),
                       ('USHCFA', 'US Healthcare Finance Authority'),
                       ('USSSA', 'US Social Security Administration'))),
          'HL70364': ('Comment type',
                      (('1R', 'Primary Reason'),
                       ('2R', 'Secondary Reason'),
                       ('AI', 'Ancillary Instructions'),
                       ('DR', 'Duplicate/Interaction Reason'),
                       ('GI', 'General Instructions'),
                       ('GR', 'General Reason'),
                       ('PI', 'Patient Instructions'),
                       ('RE', 'Remark'))),
          'HL70365': ('Equipment state',
                      (('CL', 'Clearing'),
                       ('CO', 'Configuring'),
                       ('ES', 'E-stopped'),
                       ('ID', 'Idle'),
                       ('IN', 'Initializing'),
                       ('OP', 'Normal Operation'),
                       ('PA', 'Pausing'),
                       ('PD', 'Paused'),
                       ('PU', 'Powered Up'))),
          'HL70366': ('Local/remote control state', (('L', 'Local'), ('R', 'Remote'))),
          'HL70367': ('Alert level',
                      (('C', 'Critical'),
                       ('N', 'Normal'),
                       ('S', 'Serious'),
                       ('W', 'Warning'))),
          'HL70368': ('Remote control command',
                      (('AB', 'Abort'),
                       ('CL', 'Clear'),
                       ('CN', 'Clear Notification'),
                       ('DI', 'Disable Sending Events'),
                       ('EN', 'Enable Sending Events'),
                       ('ES', 'Emergency -stop'),
                       ('EX',
                        'Execute (command specified in field Parameters (ST) 01394)'),
                       ('IN', 'Initialize/Initiate'),
                       ('LC', 'Local Control Request'),
                       ('LK', 'Lock'),
                       ('LO', 'Load'),
                       ('PA', 'Pause'),
                       ('RC', 'Remote Control Request'),
                       ('RE', 'Resume'),
                       ('SA', 'Sampling'),
                       ('SU', 'Setup'),
                       ('TT', 'Transport To'),
                       ('UC', 'Unlock'),
                       ('UN', 'Unload'))),
          'HL70369': ('Specimen role',
                      (('B', 'Blind Sample'),
                       ('C', 'Calibrator'),
                       ('P', 'Patient (default if blank component value)'),
                       ('Q', 'Control specimen'),
                       ('R', 'Replicate (of patient sample as a control)'))),
          'HL70370': ('Container status',
                      (('I', 'Identified'),
                       ('L', 'Left Equipment'),
                       ('M', 'Missing'),
                       ('O', 'In Process'),
                       ('P', 'In Position'),
                       ('R', 'Process Completed'),
                       ('U', 'Unknown'),
                       ('X', 'Container Unavailable'))),
          'HL70371': ('Additive',
                      (('BOR', 'Borate'),
                       ('C32', '3.2% Citrate'),
                       ('C38', '3.8% Citrate'),
                       ('EDTK', 'Potassium/K EDTA'),
                       ('EDTN', 'Sodium/Na EDTA'),
                       ('HCL6', '6N HCL'),
                       ('HEPL', 'Lithium/Li Heparin'),
                       ('HEPN', 'Sodium/Na Heparin'))),
          'HL70372': ('Specimen component',
                      (('BLD', 'Whole blood, homogeneous'),
                       ('BSEP', 'Whole blood, separated'),
                       ('PLAS', 'Plasma, NOS (not otherwise specified)'),
                       ('PPP', 'Platelet poor plasma'),
                       ('PRP', 'Platelet rich plasma'),
                       ('SED', 'Sediment'),
                       ('SER', 'Serum, NOS (not otherwise specified)'),
                       ('SUP', 'Supernatant'))),
          'HL70373': ('Treatment',
                      (('ACID', 'Acidification'),
                       ('ALK', 'Alkalization'),
                       ('DEFB', 'Defibrination'),
                       ('FILT', 'Filtration'),
                       ('LDLP', 'LDL Precipitation'),
                       ('NEUT', 'Neutralization'),
                       ('RECA', 'Recalification'),
                       ('UFIL', 'Ultrafiltration'))),
          'HL70374': ('System induced contaminants',
                      (('CNTM', 'Present, type of contamination unspecified'),)),
          'HL70375': ('Artificial blood',
                      (('FLUR', 'Fluorocarbons'),
                       ('SFHB', 'Stromal free hemoglobin preparations'))),
          'HL70376': ('Special handling considerations',
                      (('C37',
                        'Critical maintain at 37C (e.g., cryoglobulin specimen'),
                       ('CAMB', 'Critical ambient temperature'),
                       ('CATM',
                        'Critical do not expose to atmosphere - Do not uncap'),
                       ('CFRZ', 'Critical Frozen'),
                       ('CREF', 'Critical refrigerated'),
                       ('PRTL', 'Protect from light'))),
          'HL70377': ('Other environmental factors',
                      (('A60',
                        'Opened container, indoor atmosphere, 60 minutes duration'),
                       ('ATM', 'Opened container, atmosphere/duration unspecified'))),
          'HL70383': ('Substance status',
                      (('CE', 'Calibration Error'),
                       ('CW', 'Calibration Warning'),
                       ('EE', 'Expired Error'),
                       ('EW', 'Expired Warning'),
                       ('NE', 'Not Available Error'),
                       ('NW', 'Not Available Warning'),
                       ('OE', 'Other Error'),
                       ('OK', 'OK Status'),
                       ('OW', 'Other Warning'),
                       ('QE', 'QC Error'),
                       ('QW', 'QC Warning'))),
          'HL70384': ('Substance type',
                      (('CO', 'Control'),
                       ('DI', 'Diluent'),
                       ('LI', 'Measurable Liquid Item'),
                       ('LW', 'Liquid Waste'),
                       ('MR',
                        'Multiple Test Reagent (consumption cannot be tied to orders for single test)'),
                       ('OT', 'Other'),
                       ('PT', 'Pretreatment'),
                       ('PW', 'Purified Water'),
                       ('RC', 'Reagent Calibrator'),
                       ('SC', 'Countable Solid Item (e.g., Tip, etc.)'),
                       ('SR', 'Single Test Reagent'),
                       ('SW', 'Solid Waste'))),
          'HL70387': ('Command response',
                      (('ER',
                        'Command cannot be completed because of error condition (see response parameters)'),
                       ('OK', 'Command completed successfully'),
                       ('ST',
                        'Command cannot be completed because of the status of the requested equipment'),
                       ('TI',
                        'Command cannot be completed within requested completion time'),
                       ('UN', 'Command cannot be completed for unknown reasons'))),
          'HL70388': ('Processing type',
                      (('E', 'Evaluation'), ('P', 'Regular Production'))),
          'HL70389': ('Analyte repeat status',
                      (('D', 'Repeated with dilution'),
                       ('F', 'Reflex test'),
                       ('O', 'Original, first run'),
                       ('R', 'Repeated without dilution'))),
          'HL70391': ('Segment group',
                      (('etc', ''),
                       ('OBRG', 'OBR group'),
                       ('ORCG', 'ORC group'),
                       ('PIDG', 'PID group'),
                       ('RXAG', 'RXA group'),
                       ('RXDG', 'RXD group'),
                       ('RXEG', 'RXE group'),
                       ('RXOG', 'RXO group'))),
          'HL70392': ('Match reason',
                      (('DB', 'Match on Date of Birth'),
                       ('NA', 'Match on Name (Alpha Match)'),
                       ('NP', 'Match on Name (Phonetic Match)'),
                       ('SS', 'Match on Social Security Number'))),
          'HL70393': ('Match algorithms',
                      (('LINKSOFT_2.01', ''), ('MATCHWARE_1.2', ''))),
          'HL70394': ('Response modality',
                      (('B', 'Batch'),
                       ('R', 'Real Time'),
                       ('T',
                        'Bolus (a series of responses sent at the same time without use of batch formatting)'))),
          'HL70395': ('Modify indicator',
                      (('M', 'Modified Subscription'), ('N', 'New Subscription'))),
          'HL70396': ('Coding System',
                      (('L', 'Local general code'),
                       ('ACR', 'American College of Radiology finding codes'),
                       ('ART', 'WHO Adverse Reaction Terms'),
                       ('AS4', 'ASTM E1238/ E1467 Universal'),
                       ('AS4E', 'AS4 Neurophysiology Codes'),
                       ('ATC', 'American Type Culture Collection'),
                       ('C4', 'CPT-4'),
                       ('C5', 'CPT-5'),
                       ('CAS', 'Chemical abstract codes'),
                       ('CD2', 'CDT-2 Codes'),
                       ('CDCA', 'CDC Analyte Codes'),
                       ('CDCM', 'CDC Methods/Instruments Codes'),
                       ('CDS', 'CDC Surveillance'),
                       ('CE', 'CEN ECG diagnostic codes'),
                       ('CLP', 'CLIP'),
                       ('CPTM', 'CPT Modifier Code'),
                       ('CST', 'COSTART'),
                       ('CVX', 'CDC Vaccine Codes'),
                       ('DCL', 'DICOM Class Label'),
                       ('DCM', 'DICOM modality codes'),
                       ('DQL', 'DICOM Query Label'),
                       ('E', 'EUCLIDES'),
                       ('E5', 'Euclides quantity codes'),
                       ('E6', 'Euclides Lab method codes'),
                       ('E7', 'Euclides Lab equipment codes'),
                       ('ENZC', 'Enzyme Codes'),
                       ('FDDC', 'First DataBank Drug Codes'),
                       ('FDDX', 'First DataBank Diagnostic Codes'),
                       ('FDK', 'FDA K10'),
                       ('HB', 'HIBCC'),
                       ('HCPCS', 'HCFA Common Procedure Coding System'),
                       ('HHC', 'Home Health Care'),
                       ('HI', 'Health Outcomes'),
                       ('HL7nnnn',
                        'HL7 Defined Codes where nnnn is the HL7 table number'),
                       ('HPC', 'HCFA Procedure Codes (HCPCS)'),
                       ('I10', 'ICD-10'),
                       ('I10P', 'ICD-10 Procedure Codes'),
                       ('I9', 'ICD9'),
                       ('I9C', 'ICD-9CM'),
                       ('IBT', 'ISBT'),
                       ('IC2', 'ICHPPC-2'),
                       ('ICDO',
                        'International Classification of Diseases for Oncology'),
                       ('ICS', 'ICCS'),
                       ('ICSD', 'International Classification of Sleep Disorders'),
                       ('ISOnnnn',
                        'ISO Defined Codes where nnnn is the ISO table number'),
                       ('IUPC', 'IUPAC/IFCC Component Codes'),
                       ('IUPP', 'IUPAC/IFCC Property Codes'),
                       ('JC8', 'Japanese Chemistry'),
                       ('LB', 'Local billing code'),
                       ('LN',
                        'Logical Observation Identifier Names and Codes (LOINC(r))'),
                       ('MCD', 'Medicaid'),
                       ('MCR', 'Medicare'),
                       ('MDDX', 'Medispan Diagnostic Codes'),
                       ('MEDC', 'Medical Economics Drug Codes'),
                       ('MEDR',
                        'Medical Dictionary for Drug Regulatory Affairs (MEDDRA)'),
                       ('MEDX', 'Medical Economics Diagnostic Codes'),
                       ('MGPI', 'Medispan GPI'),
                       ('MVX', 'CDC Vaccine Manufacturer Codes'),
                       ('NDA', 'NANDA'),
                       ('NDC', 'National drug codes'),
                       ('NIC', 'Nursing Interventions Classification'),
                       ('NPI', 'National Provider Identifier'),
                       ('OHA', 'Omaha System'),
                       ('POS', 'POS Codes'),
                       ('RC', 'Read Classification'),
                       ('SDM', 'SNOMED- DICOM Microglossary'),
                       ('SNM', 'Systemized Nomenclature of Medicine (SNOMED)'),
                       ('SNM3', 'SNOMED International'),
                       ('SNT', 'SNOMED topology codes (anatomic sites)'),
                       ('UC', 'UCDS'),
                       ('UMD', 'MDNS'),
                       ('UML', 'Unified Medical Language'),
                       ('UPC', 'Universal Product Code'),
                       ('UPIN', 'UPIN'),
                       ('W1', 'WHO record # drug codes (6 digit)'),
                       ('W2', 'WHO record # drug codes (8 digit)'),
                       ('W4', 'WHO record # code with ASTM extension'),
                       ('WC', 'WHO ATC'),
                       ('99IHE', 'General code local to IHE'))),
          'HL70397': ('Sequencing',
                      (('A', 'Ascending'),
                       ('AN', 'Ascending, case insensitive'),
                       ('D', 'Descending'),
                       ('DN', 'Descending, case insensitive'),
                       ('N', 'None'))),
          'HL70398': ('Continuation style code',
                      (('F', 'Fragmentation'), ('I', 'Interactive Continuation'))),
          'HL70399': ('Country code',
                      (('ABW', 'ARUBA'),
                       ('AFG', 'AFGHANISTAN'),
                       ('AFT', 'FRENCH SOUTHERN TERRITORIES'),
                       ('AGO', 'ANGOLA'),
                       ('AIA', 'ANGUILLA'),
                       ('ALB', 'ALBANIA'),
                       ('AND', 'ANDORRA'),
                       ('ANT', 'NETHERLANDS ANTILLES'),
                       ('ARE', 'UNITED ARAB EMIRATES'),
                       ('ARG', 'ARGENTINA'),
                       ('ARM', 'ARMENIA'),
                       ('ASM', 'AMERICAN SAMOA'),
                       ('ATA', 'ANTARCTICA'),
                       ('ATG', 'ANTIGUA AND BARBUDA'),
                       ('AUS', 'AUSTRALIA'),
                       ('AUT', 'AUSTRIA'),
                       ('AZE', 'AZERBAIJAN'),
                       ('BDI', 'BURUNDI'),
                       ('BEL', 'BELGIUM'),
                       ('BEN', 'BENIN'),
                       ('BFA', 'BURKINA FASO'),
                       ('BGD', 'BANGLADESH'),
                       ('BGR', 'BULGARIA'),
                       ('BHR', 'BAHRAIN'),
                       ('BHS', 'BAHAMAS'),
                       ('BIH', 'BOSNIA AND HERZEGOVINA'),
                       ('BLR', 'BELARUS'),
                       ('BLZ', 'BELIZE'),
                       ('BMU', 'BERMUDA'),
                       ('BOL', 'BOLIVIA'),
                       ('BRA', 'BRAZIL'),
                       ('BRB', 'BARBADOS'),
                       ('BRN', 'BRUNEI DARUSSALAM'),
                       ('BTN', 'BHUTAN'),
                       ('BVT', 'BOUVET ISLAND'),
                       ('BWA', 'BOTSWANA'),
                       ('CAF', 'CENTRAL AFRICAN REPUBLIC'),
                       ('CAN', 'CANADA'),
                       ('CCK', 'COCOS (KEELING) ISLANDS'),
                       ('CHE', 'SWITZERLAND'),
                       ('CHL', 'CHILE'),
                       ('CHN', 'CHINA'),
                       ('CIV', "COTE D'VOIRE"),
                       ('CMR', 'CAMEROON'),
                       ('COD', 'CONGO, THE DEMOCRATIC REPUBLIC OF THE'),
                       ('COG', 'CONGO'),
                       ('COK', 'COOK ISLAND'),
                       ('COL', 'COLOMBIA'),
                       ('COM', 'COMOROS'),
                       ('CPV', 'CAPE VERDE'),
                       ('CRI', 'COSTA RICA'),
                       ('CUB', 'CUBA'),
                       ('CXR', 'CHRISTMAS ISLAND'),
                       ('CYM', 'CAYMAN ISLANDS'),
                       ('CYP', 'CYPRUS'),
                       ('CZE', 'CZECH REPUBLIC'),
                       ('DEU', 'GERMANY'),
                       ('DJI', 'DJIBOUTI'),
                       ('DMA', 'DOMINICA'),
                       ('DNK', 'DENMARK'),
                       ('DOM', 'DOMINICAN REPUBLIC'),
                       ('DZA', 'ALGERIA'),
                       ('ECU', 'ECUADOR'),
                       ('EGY', 'EGYPT'),
                       ('ERI', 'ERITREA'),
                       ('ESH', 'WESTERN SAHARA'),
                       ('ESP', 'SPAIN'),
                       ('EST', 'ESTONIA'),
                       ('ETH', 'ETHIOPIA'),
                       ('FIN', 'FINLAND'),
                       ('FJI', 'FIJI'),
                       ('FLK', 'FALKLAND ISLANDS (MALVINAS)'),
                       ('FRA', 'FRANCE'),
                       ('FRO', 'FAROE ISLANDS'),
                       ('FSM', 'MICRONESIA, FEDERATED STATES OF'),
                       ('GAB', 'GABON'),
                       ('GBR', 'UNITED KINGDOM'),
                       ('GEO', 'GEORGIA'),
                       ('GHA', 'GHANA'),
                       ('GIB', 'GIBRALTAR'),
                       ('GIN', 'GUINEA'),
                       ('GLP', 'GUADELOUPE'),
                       ('GMB', 'GAMBIA'),
                       ('GNB', 'GUINEA-BISSAU'),
                       ('GNQ', 'EQUATORIAL GUINEA'),
                       ('GRC', 'GREECE'),
                       ('GRD', 'GRENADA'),
                       ('GRL', 'GREENLAND'),
                       ('GTM', 'GUATEMALA'),
                       ('GUF', 'FRENCH GUIANA'),
                       ('GUM', 'GUAM'),
                       ('GUY', 'GUYANA'),
                       ('HKG', 'HONG KONG'),
                       ('HMD', 'HEARD ISLAND AND MCDONALD ISLANDS'),
                       ('HND', 'HONDURAS'),
                       ('HRV', 'CROATIA'),
                       ('HTI', 'HAITI'),
                       ('HUN', 'HUNGARY'),
                       ('IDN', 'INDONESIA'),
                       ('IND', 'INDIA'),
                       ('IOT', 'BRITISH INDIAN OCEAN TERRITORY'),
                       ('IRL', 'IRELAND'),
                       ('IRN', 'IRAN, ISLAMIC REPUBLIC OF'),
                       ('IRQ', 'IRAQ'),
                       ('ISL', 'ICELAND'),
                       ('ISR', 'ISRAEL'),
                       ('ITA', 'ITALY'),
                       ('JAM', 'JAMAICA'),
                       ('JOR', 'JORDAN'),
                       ('JPN', 'JAPAN'),
                       ('KAZ', 'KAZAKSTAN'),
                       ('KEN', 'KENYA'),
                       ('KGZ', 'KYRGYZSTAN'),
                       ('KHM', 'CAMBODIA'),
                       ('KIR', 'KIRIBATI'),
                       ('KNA', 'SAINT KITTS AND NEVIS'),
                       ('KOR', 'KOREA, REPUBLIC OF'),
                       ('KWT', 'KUWAIT'),
                       ('LAO', "LAO PEOPLE'S DEMOCRATIC REPUBLIC"),
                       ('LBN', 'LEBANNON'),
                       ('LBR', 'LIBERIA'),
                       ('LBY', 'LIBYAN ARAB JAMAHIRIYA'),
                       ('LCA', 'SAINT LUCIA'),
                       ('LIE', 'LIECHTENSTEIN'),
                       ('LKA', 'SRI LANKA'),
                       ('LSO', 'LESOTHO'),
                       ('LTU', 'LITHUANIA'),
                       ('LUX', 'LUXEMBOURG'),
                       ('LVA', 'LATIVA'),
                       ('MAC', 'MACAU'),
                       ('MAR', 'MOROCCO'),
                       ('MCO', 'MONACO'),
                       ('MDA', 'MOLDOVA, REPUBLIC OF'),
                       ('MDG', 'MADAGASCAR'),
                       ('MDV', 'MALDIVES'),
                       ('MEX', 'MEXICO'),
                       ('MHL', 'MARSHALL ISLANDS'),
                       ('MKD', 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF'),
                       ('MLI', 'MALI'),
                       ('MLT', 'MALTA'),
                       ('MMR', 'MYANMAR'),
                       ('MNG', 'MONGOLIA'),
                       ('MNP', 'NORTHERN MARIANA ISLANDS'),
                       ('MOZ', 'MOZAMBIQUE'),
                       ('MRT', 'MAURITANIA'),
                       ('MSR', 'MONTSERRAT'),
                       ('MTQ', 'MARTINIQUE'),
                       ('MUS', 'MAURITUS'),
                       ('MWI', 'MALAWI'),
                       ('MYS', 'MALAYSIA'),
                       ('MYT', 'MAYOTTE'),
                       ('NAM', 'NAMIBIA'),
                       ('NCL', 'NEW CALEDONIA'),
                       ('NER', 'NIGER'),
                       ('NFK', 'NORFOLK ISLAND'),
                       ('NGA', 'NIGERIA'),
                       ('NIC', 'NICARAGUA'),
                       ('NIU', 'NIUE'),
                       ('NLD', 'NETHERLANDS'),
                       ('NOR', 'NORWAY'),
                       ('NPL', 'NEPAL'),
                       ('NRU', 'NAURU'),
                       ('NZL', 'NEW ZEALAND'),
                       ('OMN', 'OMAN'),
                       ('PAK', 'PAKISTAN'),
                       ('PAN', 'PANAMA'),
                       ('PCN', 'PITCAIRN'),
                       ('PER', 'PERU'),
                       ('PHL', 'PHILIPPINES'),
                       ('PLW', 'PALAU'),
                       ('PNG', 'PAPUA NEW GUINEA'),
                       ('POL', 'POLAND'),
                       ('PRI', 'PUERTO RICO'),
                       ('PRK', "KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF"),
                       ('PRT', 'PORTUGAL'),
                       ('PRY', 'PARAGUAY'),
                       ('PYF', 'FRENCH POLYNESIA'),
                       ('QAT', 'QATAR'),
                       ('REU', 'REUNION'),
                       ('ROM', 'ROMANIA'),
                       ('RUS', 'RUSSIAN FEDERATION'),
                       ('RWA', 'RWANDA'),
                       ('SAU', 'SAUDI ARABIA'),
                       ('SDN', 'SUDAN'),
                       ('SEN', 'SENEGAL'),
                       ('SGP', 'SINGAPORE'),
                       ('SGS', 'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS'),
                       ('SHN', 'SAINT HELENA'),
                       ('SJM', 'SVALBARD AND JAN MAYEN'),
                       ('SLB', 'SOLOMON ISLANDS'),
                       ('SLE', 'SIERRA LEONE'),
                       ('SLV', 'EL SALVADOR'),
                       ('SMR', 'SAN MARINO'),
                       ('SOM', 'SOMALIA'),
                       ('SPM', 'SAINT PIERRE AND MIQUELON'),
                       ('STP', 'SAO TOME AND PRINCIPE'),
                       ('SUR', 'SURINAME'),
                       ('SVK', 'SLOVAKIA'),
                       ('SVN', 'SLOVENIA'),
                       ('SWE', 'SWEDEN'),
                       ('SWZ', 'SWAZILAND'),
                       ('SYC', 'SEYCHELLES'),
                       ('SYR', 'SYRIAN ARAB REPUBLIC'),
                       ('TCA', 'TURKS AND CAICOS ISLANDS'),
                       ('TCD', 'CHAD'),
                       ('TGO', 'TOGO'),
                       ('THA', 'THAILAND'),
                       ('TJK', 'TAJIKISTAN'),
                       ('TKL', 'TOKELAU'),
                       ('TKM', 'TURKMENISTAN'),
                       ('TMP', 'EAST TIMOR'),
                       ('TON', 'TONGA'),
                       ('TTO', 'TRINIDAD AND TOBAGO'),
                       ('TUN', 'TUNISIA'),
                       ('TUR', 'TURKEY'),
                       ('TUV', 'TUVALU'),
                       ('TWN', 'TAIWAN, PROVINCE OF CHINA'),
                       ('TZA', 'TANZANIA, UNITED REPUBLIC OF'),
                       ('UGA', 'UGANDA'),
                       ('UKR', 'UKRAINE'),
                       ('UMI', 'UNITED STATES MINOR OUTLYING ISLANDS'),
                       ('URY', 'URUGUAY'),
                       ('USA', 'UNITED STATES'),
                       ('UZB', 'UZBEKISTAN'),
                       ('VAT', 'HOLY SEE (VATICAN CITY STATE)'),
                       ('VCT', 'SAINT VINCENT AND THE GRENADINES'),
                       ('VEN', 'VENEZUELA'),
                       ('VGB', 'VIRGIN ISLANDS, BRITISH'),
                       ('VIR', 'VIRGIN ISLANDS, U.S.'),
                       ('VNM', 'VIET NAM'),
                       ('VUT', 'VANUATU'),
                       ('WLF', 'WALLIS AND FUTUNA'),
                       ('WSM', 'SAMOA'),
                       ('YEM', 'YEMEN'),
                       ('YUG', 'YUGOSLAVIA'),
                       ('ZAF', 'SOUTH AFRICA'),
                       ('ZMB', 'ZAMBIA'),
                       ('ZWE', 'ZIMBABWE'))),
          'HL70401': ('Government reimbursement program',
                      (('C', 'Medi-Cal'), ('MM', 'Medicare'))),
          'HL70402': ('School type',
                      (('D', 'Dental'),
                       ('G', 'Graduate'),
                       ('M', 'Medical'),
                       ('U', 'Undergraduate'))),
          'HL70403': ('Language ability',
                      (('1', 'Read'),
                       ('2', 'Write'),
                       ('3', 'Speak'),
                       ('4', 'Understand'),
                       ('5', 'Sign'))),
          'HL70404': ('Language proficiency',
                      (('1', 'Excellent'),
                       ('2', 'Good'),
                       ('3', 'Fair'),
                       ('4', 'Poor'),
                       ('5', 'Some (level unknown)'),
                       ('6', 'None'))),
          'HL70406': ('Organization unit type',
                      (('1', 'Hospital'),
                       ('2', 'Physician Clinic'),
                       ('3', 'Long Term Care'),
                       ('4', 'Acute Care'),
                       ('5', 'Other'),
                       ('H', 'Home'),
                       ('O', 'Office'))),
          'HL70409': ('Application change type',
                      (('M', 'Migrates to different CPU'),
                       ('SD', 'Shut down'),
                       ('SU', 'Start up'))),
          'HL70411': ('Supplemental service information values',
                      (('1ST', 'First'),
                       ('2ND', 'Second'),
                       ('3RD', 'Third'),
                       ('4TH', 'Fourth'),
                       ('5TH', 'Fifth'),
                       ('ANT', 'Anterior'),
                       ('A/P', 'Anterior/Posterior'),
                       ('BLT', 'Bilateral'),
                       ('DEC', 'Decubitus'),
                       ('DST', 'Distal'),
                       ('LAT', 'Lateral'),
                       ('LFT', 'Left'),
                       ('LLQ', 'Left Lower Quadrant'),
                       ('LOW', 'Lower'),
                       ('LUQ', 'Left Upper Quadrant'),
                       ('MED', 'Medial'),
                       ('OR', 'Operating Room'),
                       ('PED', 'Pediatric'),
                       ('POS', 'Posterior'),
                       ('PRT', 'Portable'),
                       ('PRX', 'Proximal'),
                       ('REC', 'Recumbent'),
                       ('RGH', 'Right'),
                       ('RLQ', 'Right Lower Quadrant'),
                       ('RUQ', 'Right Upper Quadrant'),
                       ('UPP', 'Upper'),
                       ('UPR', 'Upright'),
                       ('WCT', 'With Contrast'),
                       ('WOC', 'Without Contrast'),
                       ('WSD', 'With Sedation'))),
          'HL70415': ('DRG transfer type',
                      (('E', 'DRG Exempt'), ('N', 'DRG Non Exempt'))),
          'HL70416': ('Procedure DRG type',
                      (('1', '1st non-Operative'),
                       ('2', '2nd non-Operative'),
                       ('3', 'Major Operative'),
                       ('4', '2nd Operative'),
                       ('5', '3rd Operative'))),
          'HL70417': ('Tissue type code',
                      (('0', 'No tissue expected'),
                       ('1', 'Insufficient Tissue'),
                       ('2', 'Not abnormal'),
                       ('3', 'Abnormal-not categorized'),
                       ('4', 'Mechanical abnormal'),
                       ('5', 'Growth alteration'),
                       ('6', 'Degeneration & necrosis'),
                       ('7', 'Non-acute inflammation'),
                       ('8', 'Non-malignant neoplasm'),
                       ('9', 'Malignant neoplasm'),
                       ('B', 'Basal cell carcinoma'),
                       ('C', 'Carcinoma-unspecified type'),
                       ('G', 'Additional tissue required'))),
          'HL70418': ('Procedure priority',
                      (('0', 'the admitting procedure'),
                       ('1', 'the primary procedure'),
                       ('2 ...', 'for ranked secondary procedures'))),
          'HL70421': ('Severity of illness code',
                      (('MI', 'Mild'), ('MO', 'Moderate'), ('SE', 'Severe'))),
          'HL70422': ('Triage code',
                      (('1', 'Non-acute'),
                       ('2', 'Acute'),
                       ('3', 'Urgent'),
                       ('4', 'Severe'),
                       ('5', 'Dead on Arrival (DOA)'),
                       ('99', 'Other'))),
          'HL70423': ('Case category code', (('D', "Doctor's Office Closed"),)),
          'HL70424': ('Gestation category code',
                      (('1', 'Premature / Pre-term'),
                       ('2', 'Full Term'),
                       ('3', 'Overdue / Post-term'))),
          'HL70425': ('Newborn code',
                      (('1', 'Born in facility'),
                       ('2', 'Transfer in'),
                       ('3', 'Born en route'),
                       ('4', 'Other'),
                       ('5', 'Born at home'))),
          'HL70426': ('Blood product code',
                      (('CRYO', 'Cryoprecipitated AHF'),
                       ('CRYOP', 'Pooled Cryopecipitate'),
                       ('FFP', 'Fresh Frozen Plasma'),
                       ('FFPTH', 'Fresh Frozen Plasma - Thawed'),
                       ('PC', 'Packed Cells'),
                       ('PCA', 'Autologous Packed Cells'),
                       ('PCNEO', 'Packed Cells - Neonatal'),
                       ('PCW', 'Washed Packed Cells'),
                       ('PLT', 'Platelet Concentrate'),
                       ('PLTNEO', 'Reduced Volume Platelets'),
                       ('PLTP', 'Pooled Platelets'),
                       ('PLTPH', 'Platelet Pheresis'),
                       ('PLTPHLR', 'Leukoreduced Platelet Pheresis'),
                       ('RWB', 'Reconstituted Whole Blood'),
                       ('WBA', 'Autologous Whole Blood'))),
          'HL70427': ('Risk management incident code',
                      (('B', 'Body fluid exposure'),
                       ('C', 'Contaminated Substance'),
                       ('D', 'Diet Errors'),
                       ('E', 'Equipment problem'),
                       ('F', 'Patient fell (not from bed)'),
                       ('H', 'Patient fell from bed'),
                       ('I', 'Infusion error'),
                       ('J', 'Foreign object left during surgery'),
                       ('K', 'Sterile precaution violated'),
                       ('O', 'Other'),
                       ('P', 'Procedure error'),
                       ('R', 'Pharmaceutical error'),
                       ('S', 'Suicide Attempt'),
                       ('T', 'Transfusion error'))),
          'HL70428': ('Incident type code',
                      (('O', 'Other'), ('P', 'Preventable'), ('U', 'User Error'))),
          'HL70429': ('Production class Code',
                      (('BR', 'Breeding/genetic stock'),
                       ('DA', 'Dairy'),
                       ('DR', 'Draft'),
                       ('DU', 'Dual Purpose'),
                       ('LY', 'Layer, Includes Multiplier flocks'),
                       ('MT', 'Meat'),
                       ('NA', 'Not Applicable'),
                       ('OT', 'Other'),
                       ('PL', 'Pleasure'),
                       ('RA', 'Racing'),
                       ('SH', 'Show'),
                       ('U', 'Unknown'))),
          'HL70430': ('Mode of arrival code',
                      (('A', 'Ambulance'),
                       ('C', 'Car'),
                       ('F', 'On foot'),
                       ('H', 'Helicopter'),
                       ('O', 'Other'),
                       ('P', 'Public Transport'),
                       ('U', 'Unknown'))),
          'HL70431': ('Recreational drug use code',
                      (('A', 'Alcohol'),
                       ('C', 'Tobacco - chewed'),
                       ('K', 'Kava'),
                       ('M', 'Marijuana'),
                       ('O', 'Other'),
                       ('T', 'Tobacco - smoked'),
                       ('U', 'Unknown'))),
          'HL70432': ('Admission level of care code',
                      (('AC', 'Acute'),
                       ('CH', 'Chronic'),
                       ('CO', 'Comatose'),
                       ('CR', 'Critical'),
                       ('IM', 'Improved'),
                       ('MO', 'Moribund'))),
          'HL70433': ('Precaution code',
                      (('A', 'Aggressive'),
                       ('B', 'Blind'),
                       ('C', 'Confused'),
                       ('D', 'Deaf'),
                       ('I', 'On IV'),
                       ('N', '"No-code" (i.e. Do not resuscitate)'),
                       ('O', 'Other'),
                       ('P', 'Paraplegic'),
                       ('U', 'Unknown'))),
          'HL70434': ('Patient condition code',
                      (('A', 'Satisfactory'),
                       ('C', 'Critical'),
                       ('O', 'Other'),
                       ('P', 'Poor'),
                       ('S', 'Stable'),
                       ('U', 'Unknown'))),
          'HL70435': ('Advance directive code', (('DNR', 'Do not resuscitate'),)),
          'HL70436': ('Sensitivity to Causative Agent code',
                      (('AD', 'Adverse Reaction (Not otherwise classified)'),
                       ('AL', 'Allergy'),
                       ('CT', 'Contraindication'),
                       ('IN', 'Intolerance'))),
          'HL70437': ('Alert device code',
                      (('B', 'Bracelet'), ('N', 'Necklace'), ('W', 'Wallet Card'))),
          'HL70438': ('Allergy clinical status',
                      (('C', 'Confirmed or verified'),
                       ('D', 'Doubt raised'),
                       ('E', 'Erroneous'),
                       ('I', 'Confirmed but inactive'),
                       ('P', 'Pending'),
                       ('S', 'Suspect'),
                       ('U', 'Unconfirmed'))),
          'HL70440': ('Data types',
                      (('AD', 'Address'),
                       ('CD', 'Channel definition'),
                       ('CE', 'Coded element'),
                       ('CF', 'Coded element with formatted values'),
                       ('CK', 'Composite ID with check digit'),
                       ('CM', 'Composite'),
                       ('CN', 'Composite ID number and name'),
                       ('CNE', 'Coded with no exceptions'),
                       ('CP', 'Composite price'),
                       ('CQ', 'Composite quantity with units'),
                       ('CWE', 'Coded with exceptions'),
                       ('CX', 'Extended composite ID with check digit'),
                       ('DLN', "Driver's license number"),
                       ('DR', 'Date/time range'),
                       ('DT', 'Date'),
                       ('ED', 'Encapsulated data'),
                       ('EI', 'Entity identifier'),
                       ('FC', 'Financial class'),
                       ('FN', 'Family name'),
                       ('FT', 'Formatted text'),
                       ('HD', 'Hierarchic designator'),
                       ('ID', 'Coded values for HL7 tables'),
                       ('IS', 'Coded value for user-defined tables'),
                       ('JCC', 'Job code/class'),
                       ('MA', 'Multiplexed array'),
                       ('MO', 'Money'),
                       ('NA', 'Numeric array'),
                       ('NM', 'Numeric'),
                       ('PL', 'Person location'),
                       ('PN', 'Person name'),
                       ('PPN', 'Performing person time stamp'),
                       ('PT', 'Processing type'),
                       ('QIP', 'Query input parameter list'),
                       ('QSC', 'Query selection criteria'),
                       ('RCD', 'Row column definition'),
                       ('RI', 'Repeat interval'),
                       ('RP', 'Reference pointer'),
                       ('SAD', 'Street Address'),
                       ('SCV', 'Scheduling class value pair'),
                       ('SI', 'Sequence ID'),
                       ('SN', 'Structured numeric'),
                       ('SRT', 'Sort order'),
                       ('ST', 'String'),
                       ('TM', 'Time'),
                       ('TN', 'Telephone number'),
                       ('TQ', 'Timing/quantity'),
                       ('TS', 'Time stamp'),
                       ('TX', 'Text data'),
                       ('VH', 'Visiting hours'),
                       ('VID', 'Version identifier'),
                       ('XAD', 'Extended address'),
                       ('XCN', 'Extended composite ID number and name'),
                       ('XON',
                        'Extended composite name and ID number for organizations'),
                       ('XPN', 'Extended person name'),
                       ('XTN', 'Extended telecommunications number'))),
          'HL70441': ('Immunization registry status',
                      (('A', 'Active'),
                       ('I', 'Inactive'),
                       ('L', 'Inactive - Lost to follow-up (cancel contract)'),
                       ('M', 'Inactive - Moved or gone elsewhere (cancel contract)'),
                       ('O', 'Other'),
                       ('P',
                        'Inactive - Permanently inactive (Do not reactivate or add new entries to the record)'),
                       ('U', 'Unknown'))),
          'HL70442': ('Location service code',
                      (('D', 'Diagnostic'),
                       ('E', 'Emergency Room Casualty'),
                       ('P', 'Primary Care'),
                       ('T', 'Therapeutic'))),
          'HL70443': ('Provider role',
                      (('AD', 'Admitting'),
                       ('AT', 'Attending'),
                       ('CP', 'Consulting Provider'),
                       ('FHCP', 'Family Health Care Professional'),
                       ('PP', 'Primary Care Provider'),
                       ('RP', 'Referring Provider'),
                       ('RT', 'Referred to Provider'))),
          'HL70444': ('Name assembly order',
                      (('F', 'Prefix Family Middle Given Suffix'),
                       ('G', 'Prefix Given Middle Family Suffix'))),
          'HL70445': ('Identity Reliability Code',
                      (('AL', 'Patient/Person Name is an Alias'),
                       ('UA', 'Unknown/Default Address'),
                       ('UD', 'Unknown/Default Date of Birth'),
                       ('US', 'Unknown/Default Social Security Number'))),
          'HL70450': ('Event type', (('LOG', 'Log Event'), ('SER', 'Service Event'))),
          'HL70451': ('Substance identifier',
                      (('ALL', 'Used for query of all inventory items'),)),
          'HL70452': ('Health care provider type code',
                      (('SUGGESTION',
                        'ANSI ASC X12 Health Care Provider Taxonomy, Level 1 - Type'),)),
          'HL70453': ('Health care provider classification',
                      (('SUGGESTION',
                        'ANSI ASC X12 Health Care Provider Taxonomy, Level 2 - Classification'),)),
          'HL70454': ('Health care provider area of specialization',
                      (('SUGGESTION',
                        'ANSI ASC X12 Health Care Provider Taxonomy, Level 3 - specialization'),)),
          'HL70455': ('Type of bill code',
                      (('...', ''),
                       ('131', 'Hospital - Outpatient - Admit thru Discharge Claim'),
                       ('141', 'Hospital - Other - Admit thru Discharge Claim'))),
          'HL70456': ('Revenue code',
                      (('...', ''),
                       ('260', 'IV Therapy'),
                       ('280', 'Oncology'),
                       ('301', 'Lab/Chemistry'),
                       ('991', 'Cafeteria /Guest Tray'),
                       ('993', 'Telephone/Telegraph'),
                       ('994', 'TV/Radio'))),
          'HL70457': ('Overall claim disposition code',
                      (('0', 'No edits present on claim'),
                       ('1',
                        'Only edits present are for line item denial or rejection'),
                       ('2',
                        'Multiple-day claim with one or more days denied or rejected'),
                       ('3',
                        'Claim denied, rejected, suspended or returned to provider with only post payment edits'),
                       ('4',
                        'Claim denied, rejected, suspended or returned to provider with only pre payment edits'))),
          'HL70458': ('OCE edit code',
                      (('...', ''),
                       ('1', 'Invalid diagnosis code'),
                       ('10',
                        'Non-covered service submitted for verification of denial (condition code 21 from header '
                        'information on claim)'),
                       ('11',
                        'Non-covered service submitted for FI review (condition code 20 from header information on '
                        'claim)'),
                       ('12', 'Questionable covered service'),
                       ('13',
                        'Additional payment for service not provided by Medicare'),
                       ('14',
                        'Code indicates a site of service not included in OPPS'),
                       ('15', 'Service unit out of range for procedure'),
                       ('16',
                        'Multiple bilateral procedures without modifier 50 (see Appendix A)'),
                       ('17',
                        'Multiple bilateral procedures with modifier 50 (see Appendix A)'),
                       ('18', 'Inpatient procedure'),
                       ('19',
                        'Mutually exclusive procedure that is not allowed even if appropriate modifier present'),
                       ('2', 'Diagnosis and age conflict'),
                       ('20',
                        'Component of a comprehensive procedure that is not allowed even if appropriate modifier '
                        'present'),
                       ('21',
                        'Medical visit on same day as a type "T" or "S" procedure without modifier 25 (see '
                        'Appendix B)'),
                       ('22', 'Invalid modifier'),
                       ('23', 'Invalid date'),
                       ('24', 'Date out of OCE range'),
                       ('25', 'Invalid age'),
                       ('26', 'Invalid sex'),
                       ('27', 'Only incidental services reported'),
                       ('28',
                        'Code not recognized by Medicare; alternate code for same service available'),
                       ('29',
                        'Partial hospitalization service for non-mental health diagnosis'),
                       ('3', 'Diagnosis and sex conflict'),
                       ('30',
                        'Insufficient services on day of partial hospitalization'),
                       ('31',
                        'Partial hospitalization on same day as ECT or type "T" procedure'),
                       ('32',
                        'Partial hospitalization claim spans 3 or less days with in-sufficient services, or ECT or '
                        'significant procedure on at least one of the days'),
                       ('33',
                        'Partial hospitalization claim spans more than 3 days with insufficient number of days '
                        'having mental health services'),
                       ('34',
                        'Partial hospitalization claim spans more than 3 days with insufficient number of days '
                        'meeting partial hospitalization criteria'),
                       ('35.',
                        'Only activity therapy and/or occupational therapy services provided'),
                       ('36.',
                        'Extensive mental health services provided on day of ECT or significant procedure'),
                       ('37',
                        'Terminated bilateral procedure or terminated procedure with units greater than one'),
                       ('38.',
                        'Inconsistency between implanted device and implantation procedure'),
                       ('39.',
                        'Mutually exclusive procedure that would be allowed if appropriate modifier were present'),
                       ('4', 'Medicare secondary payer alert'),
                       ('40.',
                        'Component of a comprehensive procedure that would be allowed if appropriate modifier were '
                        'present'),
                       ('41.', 'Invalid revenue code'),
                       ('42.',
                        'Multiple medical visits on same day with same revenue code without condition code G0 (see '
                        'Appendix B)'),
                       ('5', 'E-code as reason for visit'),
                       ('6', 'Invalid procedure code'),
                       ('7', 'Procedure and age conflict'),
                       ('8', 'Procedure and sex conflict'),
                       ('9', 'Nov-covered service'))),
          'HL70459': ('Reimbursement Action Code',
                      (('0', 'OCE line item denial or rejection is not ignored'),
                       ('1', 'OCE line item denial or rejection is ignored'),
                       ('2',
                        'External line item denial. Line item is denied even if no OCE edits'),
                       ('3',
                        'External line item rejection. Line item is rejected even if no OCE edits'))),
          'HL70460': ('Denial or rejection code',
                      (('0', 'Line item not denied or rejected'),
                       ('1', 'Line item denied or rejected'),
                       ('2',
                        'Line item is on a multiple-day claim. The line item is not denied or rejected, but occurs '
                        'on a day that has been denied or rejected.'))),
          'HL70465': ('Name/address representation',
                      (('A', 'Alphabetic (i.e., Default or some single-byte)'),
                       ('I', 'Ideographic (i.e., Kanji)'),
                       ('P', 'Phonetic (i.e., ASCII, Katakana, Hiragana, etc.)'))),
          'HL70466': ('Ambulatory payment classification code',
                      (('...', ''),
                       ('031', 'Dental procedures'),
                       ('163', 'Excision/biopsy'),
                       ('181', 'Level 1 skin repair.'))),
          'HL70467': ('Modifier edit code',
                      (('0', 'Modifier does NOT exist'),
                       ('1', 'Modifier present, no errors'),
                       ('2', 'Modifier invalid'),
                       ('3', 'Modifier NOT approved for ASC/HOPD use'),
                       ('4',
                        'Modifier approved for ASC/HOPD use, inappropriate for code'),
                       ('U', 'Modifer edit code unknown'))),
          'HL70468': ('Payment adjustment code',
                      (('1', 'No payment adjustment'),
                       ('2',
                        'Designated current drug or biological payment adjustment applies to APC (status indicator G)'),
                       ('3',
                        'Designated new device payment adjustment applies to APC (status indicator H)'),
                       ('4',
                        'Designated new drug or new biological payment adjustment applies to APC (status indicator J)'),
                       ('5',
                        'Deductible not applicable (specific list of HCPCS codes)'))),
          'HL70469': ('Packaging status code',
                      (('0', 'Not packaged'),
                       ('1',
                        'Packaged service (status indicator N, or no HCPCS code and certain revenue codes)'),
                       ('2',
                        'Packaged as part of partial hospitalization per diem or daily mental health service '
                        'per diem'))),
          'HL70470': ('Reimbursement type code',
                      (('Crnl', 'Corneal Tissue APC'),
                       ('DME', 'Durable Medical Equipment'),
                       ('EPO', 'Epotein'),
                       ('Lab', 'Clinical Laboratory APC'),
                       ('Mamm', 'Screening Mammography APC'),
                       ('NoPay', 'This APC is not paid'),
                       ('OPPS', 'Outpatient Prospective Payment System'),
                       ('PartH', 'Partial Hospitalization APC'),
                       ('Pckg', 'Packaged APC'),
                       ('Thrpy', 'Therapy APC'))),
          'HL70472': ('TQ Conjunction ID',
                      (('A',
                        'Asynchronous: Do the next specification in parallel with this one (unless otherwise '
                        'constrained by the following components: ORC-7^4-start date/time and ORC-7^5-end date/time). '
                        'The conjunction of "A" specifies two parallel instructions, as are sometimes'),
                       ('C',
                        'This is an actuation time. It will be followed by a completion time for the service. '
                        'This code allows one to distinguish between the time and priority at which a service should '
                        'be actuated (e.g., blood should be drawn) and the time and priority at which'),
                       ('S',
                        'Synchronous. Do the next specification after this one (unless otherwise constrained by the '
                        'following components: ORC-7^4-start date/time and ORC-7^5-end date/time). An "S" '
                        'specification implies that the second timing sequence follows the first, e.g., when'))),
          'HL70473': ('Formulary status',
                      (('G',
                        'This observation/service is on the formulary, and has guidelines'),
                       ('N', 'This observation/service is not on the formulary'),
                       ('R',
                        'This observation/service is on the formulary, but is restricted'),
                       ('Y', 'This observation/service is on the formulary'))),
          'HL70474': ('Organization unit type - ORG',
                      (('D', 'Department'),
                       ('F', 'Facility'),
                       ('L', 'Local market area'),
                       ('M', 'Medical Center Area'),
                       ('S', 'Subdivision'),
                       ('U', 'Subdepartment'),
                       ('V', 'Division')))}
