# ant-sftpgo-client
SFTPGo REST API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2.4.4
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import sftpgo_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import sftpgo_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import sftpgo_client
from sftpgo_client.rest import ApiException
from pprint import pprint


# create an instance of the API class
api_instance = sftpgo_client.AdminsApi(sftpgo_client.ApiClient(configuration))
body = sftpgo_client.Admin() # Admin | 

try:
    # Adds a new admin
    api_response = api_instance.add_admin(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->add_admin: %s\n" % e)


# create an instance of the API class
api_instance = sftpgo_client.AdminsApi(sftpgo_client.ApiClient(configuration))
body = sftpgo_client.PwdChange() # PwdChange | 

try:
    # Change the password for the logged in admin
    api_response = api_instance.change_admin_password(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->change_admin_password: %s\n" % e)


# create an instance of the API class
api_instance = sftpgo_client.AdminsApi(sftpgo_client.ApiClient(configuration))
username = 'username_example' # str | the admin username

try:
    # Delete an existing admin
    api_response = api_instance.delete_admin(username)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->delete_admin: %s\n" % e)


# create an instance of the API class
api_instance = sftpgo_client.AdminsApi(sftpgo_client.ApiClient(configuration))
username = 'username_example' # str | the admin username

try:
    # Find admin by username
    api_response = api_instance.get_admin_by_username(username)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->get_admin_by_username: %s\n" % e)


# create an instance of the API class
api_instance = sftpgo_client.AdminsApi(sftpgo_client.ApiClient(configuration))
offset = 0 # int |  (optional) (default to 0)
limit = 100 # int | The maximum number of items to return. Max value is 500, default is 100 (optional) (default to 100)
order = 'order_example' # str | Ordering admins by username. Default ASC (optional)

try:
    # Returns an array with one or more admins
    api_response = api_instance.get_admins(offset=offset, limit=limit, order=order)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->get_admins: %s\n" % e)


# create an instance of the API class
api_instance = sftpgo_client.AdminsApi(sftpgo_client.ApiClient(configuration))
body = sftpgo_client.Admin() # Admin | 
username = 'username_example' # str | the admin username

try:
    # Update an existing admin
    api_response = api_instance.update_admin(body, username)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->update_admin: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to */api/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminsApi* | [**add_admin**](docs/AdminsApi.md#add_admin) | **POST** /admins | Adds a new admin
*AdminsApi* | [**change_admin_password**](docs/AdminsApi.md#change_admin_password) | **PUT** /changepwd/admin | Change the password for the logged in admin
*AdminsApi* | [**delete_admin**](docs/AdminsApi.md#delete_admin) | **DELETE** /admins/{username} | Delete an existing admin
*AdminsApi* | [**get_admin_by_username**](docs/AdminsApi.md#get_admin_by_username) | **GET** /admins/{username} | Find admin by username
*AdminsApi* | [**get_admins**](docs/AdminsApi.md#get_admins) | **GET** /admins | Returns an array with one or more admins
*AdminsApi* | [**update_admin**](docs/AdminsApi.md#update_admin) | **PUT** /admins/{username} | Update an existing admin
*ConnectionsApi* | [**close_connection**](docs/ConnectionsApi.md#close_connection) | **DELETE** /connections/{connectionID} | Terminate an active connection
*ConnectionsApi* | [**get_connections**](docs/ConnectionsApi.md#get_connections) | **GET** /connections | Get the active users and info about their uploads/downloads
*DefenderApi* | [**get_ban_time**](docs/DefenderApi.md#get_ban_time) | **GET** /defender/bantime | Returns the ban time for the specified IPv4/IPv6 address
*DefenderApi* | [**get_score**](docs/DefenderApi.md#get_score) | **GET** /defender/score | Returns the score for the specified IPv4/IPv6 address
*DefenderApi* | [**unban_host**](docs/DefenderApi.md#unban_host) | **POST** /defender/unban | Removes the specified IPv6/IPv6 from the banned ones
*FoldersApi* | [**add_folder**](docs/FoldersApi.md#add_folder) | **POST** /folders | Adds a new folder
*FoldersApi* | [**delete_folder**](docs/FoldersApi.md#delete_folder) | **DELETE** /folders/{name} | Delete an existing folder
*FoldersApi* | [**get_folder_by_name**](docs/FoldersApi.md#get_folder_by_name) | **GET** /folders/{name} | Find user by name
*FoldersApi* | [**get_folders**](docs/FoldersApi.md#get_folders) | **GET** /folders | Returns an array with one or more folders
*FoldersApi* | [**update_folder**](docs/FoldersApi.md#update_folder) | **PUT** /folders/{name} | Update an existing user
*HealthcheckApi* | [**healthz_get**](docs/HealthcheckApi.md#healthz_get) | **GET** /healthz | health check
*MaintenanceApi* | [**dumpdata**](docs/MaintenanceApi.md#dumpdata) | **GET** /dumpdata | Backup SFTPGo data as data provider independent JSON
*MaintenanceApi* | [**get_status**](docs/MaintenanceApi.md#get_status) | **GET** /status | Retrieve the status of the active services
*MaintenanceApi* | [**get_version**](docs/MaintenanceApi.md#get_version) | **GET** /version | Get version details
*MaintenanceApi* | [**loaddata_from_file**](docs/MaintenanceApi.md#loaddata_from_file) | **GET** /loaddata | Restore SFTPGo data from a JSON backup file on the server
*MaintenanceApi* | [**loaddata_from_request_body**](docs/MaintenanceApi.md#loaddata_from_request_body) | **POST** /loaddata | Restore SFTPGo data from a JSON backup
*QuotaApi* | [**folder_quota_update**](docs/QuotaApi.md#folder_quota_update) | **PUT** /folder-quota-update | update the folder used quota limits
*QuotaApi* | [**get_folders_quota_scans**](docs/QuotaApi.md#get_folders_quota_scans) | **GET** /folder-quota-scans | Get the active quota scans for folders
*QuotaApi* | [**get_quota_scans**](docs/QuotaApi.md#get_quota_scans) | **GET** /quota-scans | Get the active quota scans for users home directories
*QuotaApi* | [**quota_update**](docs/QuotaApi.md#quota_update) | **PUT** /quota-update | update the user used quota limits
*QuotaApi* | [**start_folder_quota_scan**](docs/QuotaApi.md#start_folder_quota_scan) | **POST** /folder-quota-scans | start a new folder quota scan
*QuotaApi* | [**start_quota_scan**](docs/QuotaApi.md#start_quota_scan) | **POST** /quota-scans | start a new user quota scan
*TokenApi* | [**get_token**](docs/TokenApi.md#get_token) | **GET** /token | Get an access token
*TokenApi* | [**logout**](docs/TokenApi.md#logout) | **GET** /logout | invalidate the access token
*UsersApi* | [**add_user**](docs/UsersApi.md#add_user) | **POST** /users | Adds a new user
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /users/{username} | Delete an existing user
*UsersApi* | [**get_user_by_username**](docs/UsersApi.md#get_user_by_username) | **GET** /users/{username} | Find user by username
*UsersApi* | [**get_users**](docs/UsersApi.md#get_users) | **GET** /users | Returns an array with one or more users
*UsersApi* | [**update_user**](docs/UsersApi.md#update_user) | **PUT** /users/{username} | Update an existing user

## Documentation For Models

 - [Admin](docs/Admin.md)
 - [AdminFilters](docs/AdminFilters.md)
 - [AdminPermissions](docs/AdminPermissions.md)
 - [ApiResponse](docs/ApiResponse.md)
 - [AzureBlobFsConfig](docs/AzureBlobFsConfig.md)
 - [BackupData](docs/BackupData.md)
 - [BanStatus](docs/BanStatus.md)
 - [BaseVirtualFolder](docs/BaseVirtualFolder.md)
 - [ConnectionStatus](docs/ConnectionStatus.md)
 - [CryptFsConfig](docs/CryptFsConfig.md)
 - [DataProviderStatus](docs/DataProviderStatus.md)
 - [DefenderUnbanBody](docs/DefenderUnbanBody.md)
 - [DirPermissions](docs/DirPermissions.md)
 - [ExtensionsFilter](docs/ExtensionsFilter.md)
 - [FTPDBinding](docs/FTPDBinding.md)
 - [FTPPassivePortRange](docs/FTPPassivePortRange.md)
 - [FTPServiceStatus](docs/FTPServiceStatus.md)
 - [FilesystemConfig](docs/FilesystemConfig.md)
 - [FolderQuotaScan](docs/FolderQuotaScan.md)
 - [GCSConfig](docs/GCSConfig.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [LoginMethods](docs/LoginMethods.md)
 - [OneOfinlineResponse200](docs/OneOfinlineResponse200.md)
 - [PatternsFilter](docs/PatternsFilter.md)
 - [Permission](docs/Permission.md)
 - [PwdChange](docs/PwdChange.md)
 - [QuotaScan](docs/QuotaScan.md)
 - [S3Config](docs/S3Config.md)
 - [SFTPFsConfig](docs/SFTPFsConfig.md)
 - [SSHBinding](docs/SSHBinding.md)
 - [SSHHostKey](docs/SSHHostKey.md)
 - [SSHServiceStatus](docs/SSHServiceStatus.md)
 - [ScoreStatus](docs/ScoreStatus.md)
 - [Secret](docs/Secret.md)
 - [ServicesStatus](docs/ServicesStatus.md)
 - [ServicesStatusDefender](docs/ServicesStatusDefender.md)
 - [SupportedProtocols](docs/SupportedProtocols.md)
 - [Token](docs/Token.md)
 - [Transfer](docs/Transfer.md)
 - [User](docs/User.md)
 - [UserFilters](docs/UserFilters.md)
 - [VersionInfo](docs/VersionInfo.md)
 - [VirtualFolder](docs/VirtualFolder.md)
 - [WebDAVBinding](docs/WebDAVBinding.md)
 - [WebDAVServiceStatus](docs/WebDAVServiceStatus.md)

## Documentation For Authorization


## BasicAuth

- **Type**: HTTP basic authentication

## BearerAuth

```
# create an instance of the API class
token_api_instance = sftpgo_client.TokenApi(sftpgo_client.ApiClient(configuration))

try:
    # Get an access token
    token = token_api_instance.get_token()
    pprint(token)
except ApiException as e:
    print("Exception when calling TokenApi->get_token: %s\n" % e)


# create an instance of the API class
users_api_instance = sftpgo_client.UsersApi(sftpgo_client.ApiClient(configuration))

users_api_instance.api_client.set_default_header('Authorization', 'Bearer {}'.format(token.access_token))

offset = 0 # int |  (optional) (default to 0)
limit = 100 # int | The maximum number of items to return. Max value is 500, default is 100 (optional) (default to 100)
order = 'ASC' # str | Ordering users by username. Default ASC (optional)

try:
    # Returns an array with one or more users
    api_response = users_api_instance.get_users(offset=offset, limit=limit, order=order)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling UsersApi->get_users: %s\n" % e)
```


## Author


