# coding: utf-8

"""
    SFTPGo

    SFTPGo REST API  # noqa: E501

    OpenAPI spec version: 2.4.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sftpgo_client.api_client import ApiClient


class MaintenanceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def dumpdata(self, **kwargs):  # noqa: E501
        """Backup SFTPGo data as data provider independent JSON  # noqa: E501

        The backup can be saved in a local file on the server, to avoid exposing sensitive data over the network, or returned as response body. The output of dumpdata can be used as input for loaddata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dumpdata(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str output_file: Path for the file to write the JSON serialized data to. This path is relative to the configured \"backups_path\". If this file already exists it will be overwritten. To return the backup as response body set `output_data` to true instead.
        :param int output_data: output_data:   * `0` or any other value != 1, the backup will be saved to a file on the server, `output_file` is required   * `1` the backup will be returned as response body 
        :param int indent: indent:   * `0` no indentation. This is the default   * `1` format the output JSON 
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.dumpdata_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.dumpdata_with_http_info(**kwargs)  # noqa: E501
            return data

    def dumpdata_with_http_info(self, **kwargs):  # noqa: E501
        """Backup SFTPGo data as data provider independent JSON  # noqa: E501

        The backup can be saved in a local file on the server, to avoid exposing sensitive data over the network, or returned as response body. The output of dumpdata can be used as input for loaddata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dumpdata_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str output_file: Path for the file to write the JSON serialized data to. This path is relative to the configured \"backups_path\". If this file already exists it will be overwritten. To return the backup as response body set `output_data` to true instead.
        :param int output_data: output_data:   * `0` or any other value != 1, the backup will be saved to a file on the server, `output_file` is required   * `1` the backup will be returned as response body 
        :param int indent: indent:   * `0` no indentation. This is the default   * `1` format the output JSON 
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['output_file', 'output_data', 'indent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method dumpdata" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'output_file' in params:
            query_params.append(('output-file', params['output_file']))  # noqa: E501
        if 'output_data' in params:
            query_params.append(('output-data', params['output_data']))  # noqa: E501
        if 'indent' in params:
            query_params.append(('indent', params['indent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/dumpdata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_status(self, **kwargs):  # noqa: E501
        """Retrieve the status of the active services  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ServicesStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_status_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve the status of the active services  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ServicesStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServicesStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_version(self, **kwargs):  # noqa: E501
        """Get version details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_version(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: VersionInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_version_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_version_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_version_with_http_info(self, **kwargs):  # noqa: E501
        """Get version details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_version_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: VersionInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_version" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/version', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VersionInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loaddata_from_file(self, input_file, **kwargs):  # noqa: E501
        """Restore SFTPGo data from a JSON backup file on the server  # noqa: E501

        Users, folders and admins will be restored one by one and the restore is stopped if a user/folder/admin cannot be added or updated, so it could happen a partial restore  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loaddata_from_file(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str input_file: Path for the file to read the JSON serialized data from. This can be an absolute path or a path relative to the configured \"backups_path\". The max allowed file size is 10MB (required)
        :param int scan_quota: Quota scan:   * `0` no quota scan is done, the imported users/folders will have used_quota_size and used_quota_files = 0 or the existing values if they already exists. This is the default   * `1` scan quota   * `2` scan quota if the user has quota restrictions required: false 
        :param int mode: Mode:   * `0` New users/admins are added, existing users/admins are updated. This is the default   * `1` New users/admins are added, existing users/admins are not modified   * `2` New users are added, existing users are updated and, if connected, they are disconnected and so forced to use the new configuration 
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loaddata_from_file_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.loaddata_from_file_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def loaddata_from_file_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Restore SFTPGo data from a JSON backup file on the server  # noqa: E501

        Users, folders and admins will be restored one by one and the restore is stopped if a user/folder/admin cannot be added or updated, so it could happen a partial restore  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loaddata_from_file_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str input_file: Path for the file to read the JSON serialized data from. This can be an absolute path or a path relative to the configured \"backups_path\". The max allowed file size is 10MB (required)
        :param int scan_quota: Quota scan:   * `0` no quota scan is done, the imported users/folders will have used_quota_size and used_quota_files = 0 or the existing values if they already exists. This is the default   * `1` scan quota   * `2` scan quota if the user has quota restrictions required: false 
        :param int mode: Mode:   * `0` New users/admins are added, existing users/admins are updated. This is the default   * `1` New users/admins are added, existing users/admins are not modified   * `2` New users are added, existing users are updated and, if connected, they are disconnected and so forced to use the new configuration 
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'scan_quota', 'mode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loaddata_from_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `loaddata_from_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scan_quota' in params:
            query_params.append(('scan-quota', params['scan_quota']))  # noqa: E501
        if 'mode' in params:
            query_params.append(('mode', params['mode']))  # noqa: E501
        if 'input_file' in params:
            query_params.append(('input-file', params['input_file']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/loaddata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loaddata_from_request_body(self, body, **kwargs):  # noqa: E501
        """Restore SFTPGo data from a JSON backup  # noqa: E501

        Users, folders and admins will be restored one by one and the restore is stopped if a user/folder/admin cannot be added or updated, so it could happen a partial restore  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loaddata_from_request_body(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BackupData body: (required)
        :param int scan_quota: Quota scan:   * `0` no quota scan is done, the imported users/folders will have used_quota_size and used_quota_files = 0 or the existing values if they already exists. This is the default   * `1` scan quota   * `2` scan quota if the user has quota restrictions required: false 
        :param int mode: Mode:   * `0` New users/admins are added, existing users/admins are updated. This is the default   * `1` New users/admins are added, existing users/admins are not modified   * `2` New users are added, existing users are updated and, if connected, they are disconnected and so forced to use the new configuration 
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loaddata_from_request_body_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.loaddata_from_request_body_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def loaddata_from_request_body_with_http_info(self, body, **kwargs):  # noqa: E501
        """Restore SFTPGo data from a JSON backup  # noqa: E501

        Users, folders and admins will be restored one by one and the restore is stopped if a user/folder/admin cannot be added or updated, so it could happen a partial restore  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loaddata_from_request_body_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BackupData body: (required)
        :param int scan_quota: Quota scan:   * `0` no quota scan is done, the imported users/folders will have used_quota_size and used_quota_files = 0 or the existing values if they already exists. This is the default   * `1` scan quota   * `2` scan quota if the user has quota restrictions required: false 
        :param int mode: Mode:   * `0` New users/admins are added, existing users/admins are updated. This is the default   * `1` New users/admins are added, existing users/admins are not modified   * `2` New users are added, existing users are updated and, if connected, they are disconnected and so forced to use the new configuration 
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'scan_quota', 'mode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loaddata_from_request_body" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `loaddata_from_request_body`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scan_quota' in params:
            query_params.append(('scan-quota', params['scan_quota']))  # noqa: E501
        if 'mode' in params:
            query_params.append(('mode', params['mode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/loaddata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
