import { AttiniState } from './attini-state';
export declare abstract class AttiniTask extends AttiniState {
    /**
     *
     * Get the json path to this steps output. Convenience
     * method that will return a string with the following format
     * $.output.<id>.<path>.<path>
     *
     * @param {string[]} [paths] - The path to the value from the outputs root.
     *
     */
    getOutputPath(...paths: string[]): string;
    /**
     *
     * Get a string value from the steps output.
     * This method can only be used as the value for a key/value pair in another Attini or
     * StepFunction step.
     *
     * @example
     * Valid examples:
     *
     * {my-key: step.getOutput()}
     * {my-key: step.getOutput('path','to','key')}
     *
     * Invalid examples:
     *
     * {my-key: 'test'+ step.getOutput()}
     * {my-key: '[step.getOutput()]}
     *
     * @param {string[]} [paths] - The path to the value from the outputs root.
     *
     */
    getOutput(...paths: string[]): string;
}
