"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniPayload = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
/**
 * Utility class for reading values from the payload of an Attini deployment plan.
 * Each method can only be used as the value of a key/value pair in an Attini or
 * StepFunction step.
 *
 * @example
 * Valid example:
 *
 * {my-key: AttiniPayload.environment()}
 *
 * Invalid examples:
 *
 * {my-key: 'test'+ AttiniPayload.environment()}
 * {my-key: '[step.AttiniPayload.environment()]}
 *
 *
 */
class AttiniPayload {
    static environment() {
        return aws_stepfunctions_1.JsonPath.stringAt(AttiniPayload.ENVIRONMENT_PATH);
    }
    static distributionName() {
        return aws_stepfunctions_1.JsonPath.stringAt(AttiniPayload.DISTRIBUTION_NAME_PATH);
    }
    static stackParameter(parameterName) {
        return aws_stepfunctions_1.JsonPath.stringAt(AttiniPayload.STACK_PARAMETERS_PATH + '.' + parameterName);
    }
    static version() {
        return aws_stepfunctions_1.JsonPath.stringAt(AttiniPayload.DISTRIBUTION_VERSION);
    }
}
exports.AttiniPayload = AttiniPayload;
_a = JSII_RTTI_SYMBOL_1;
AttiniPayload[_a] = { fqn: "@attini/cdk.AttiniPayload", version: "1.3.0" };
AttiniPayload.ENVIRONMENT_PATH = '$.deploymentOriginData.environment';
AttiniPayload.DISTRIBUTION_NAME_PATH = '$.deploymentOriginData.distributionName';
AttiniPayload.DISTRIBUTION_VERSION = '$.deploymentOriginData.version';
AttiniPayload.STACK_PARAMETERS_PATH = '$.stackParameters';
//# sourceMappingURL=data:application/json;base64,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