"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniCdk = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_task_1 = require("./attini-task");
const index_1 = require("./index");
/**
 * The AttiniCdk step allows you to deploy CDK projects as part of your deployment plan.
 */
class AttiniCdk extends attini_task_1.AttiniTask {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.type = 'AttiniCdk';
        this.props = props;
    }
    renderProps() {
        let { buildCommands: _, ...copy } = this.props;
        if (this.props.stackConfiguration) {
            copy.stackConfiguration = this.props.stackConfiguration?.map(value => index_1.PropsUtil.fixCase(value));
        }
        if (this.props.buildCommands) {
            copy.build = this.props.buildCommands;
        }
        if (this.props.diff) {
            copy.diff = index_1.PropsUtil.fixCase(this.props.diff);
        }
        return { Properties: aws_stepfunctions_1.FieldUtils.renderObject(index_1.PropsUtil.fixCase(copy)) };
    }
}
exports.AttiniCdk = AttiniCdk;
_a = JSII_RTTI_SYMBOL_1;
AttiniCdk[_a] = { fqn: "@attini/cdk.AttiniCdk", version: "1.3.0" };
//# sourceMappingURL=data:application/json;base64,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