"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PROVIDER_ERROR_KEY = exports.CLI_VERSION_ENV = exports.CLI_ASM_VERSION_ENV = exports.DEFAULT_REGION_ENV = exports.DEFAULT_ACCOUNT_ENV = exports.CONTEXT_ENV = exports.OUTDIR_ENV = void 0;
// output directory into which to emit synthesis outputs. CDK doesn't allow outdir
// to be specified both through the CDK_OUTDIR environment variable and the through
// aws:cdk:outdir context.
exports.OUTDIR_ENV = 'CDK_OUTDIR';
exports.CONTEXT_ENV = 'CDK_CONTEXT_JSON';
/**
 * Environment variable set by the CDK CLI with the default AWS account ID.
 */
exports.DEFAULT_ACCOUNT_ENV = 'CDK_DEFAULT_ACCOUNT';
/**
 * Environment variable set by the CDK CLI with the default AWS region.
 */
exports.DEFAULT_REGION_ENV = 'CDK_DEFAULT_REGION';
/**
 * Version of Cloud Assembly expected by CDK CLI.
 *
 * CLI started emitting this at 1.10.1
 */
exports.CLI_ASM_VERSION_ENV = 'CDK_CLI_ASM_VERSION';
/**
 * Version of the CLI currently running.
 *
 * CLI started emitting this at 1.10.1
 */
exports.CLI_VERSION_ENV = 'CDK_CLI_VERSION';
/**
 * If a context value is an object with this key, it indicates an error
 */
exports.PROVIDER_ERROR_KEY = '$providerError';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3hhcGkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjeGFwaS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxrRkFBa0Y7QUFDbEYsbUZBQW1GO0FBQ25GLDBCQUEwQjtBQUNiLFFBQUEsVUFBVSxHQUFHLFlBQVksQ0FBQztBQUMxQixRQUFBLFdBQVcsR0FBRyxrQkFBa0IsQ0FBQztBQUM5Qzs7R0FFRztBQUNVLFFBQUEsbUJBQW1CLEdBQUcscUJBQXFCLENBQUM7QUFDekQ7O0dBRUc7QUFDVSxRQUFBLGtCQUFrQixHQUFHLG9CQUFvQixDQUFDO0FBQ3ZEOzs7O0dBSUc7QUFDVSxRQUFBLG1CQUFtQixHQUFHLHFCQUFxQixDQUFDO0FBQ3pEOzs7O0dBSUc7QUFDVSxRQUFBLGVBQWUsR0FBRyxpQkFBaUIsQ0FBQztBQUNqRDs7R0FFRztBQUNVLFFBQUEsa0JBQWtCLEdBQUcsZ0JBQWdCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBvdXRwdXQgZGlyZWN0b3J5IGludG8gd2hpY2ggdG8gZW1pdCBzeW50aGVzaXMgb3V0cHV0cy4gQ0RLIGRvZXNuJ3QgYWxsb3cgb3V0ZGlyXG4vLyB0byBiZSBzcGVjaWZpZWQgYm90aCB0aHJvdWdoIHRoZSBDREtfT1VURElSIGVudmlyb25tZW50IHZhcmlhYmxlIGFuZCB0aGUgdGhyb3VnaFxuLy8gYXdzOmNkazpvdXRkaXIgY29udGV4dC5cbmV4cG9ydCBjb25zdCBPVVRESVJfRU5WID0gJ0NES19PVVRESVInO1xuZXhwb3J0IGNvbnN0IENPTlRFWFRfRU5WID0gJ0NES19DT05URVhUX0pTT04nO1xuLyoqXG4gKiBFbnZpcm9ubWVudCB2YXJpYWJsZSBzZXQgYnkgdGhlIENESyBDTEkgd2l0aCB0aGUgZGVmYXVsdCBBV1MgYWNjb3VudCBJRC5cbiAqL1xuZXhwb3J0IGNvbnN0IERFRkFVTFRfQUNDT1VOVF9FTlYgPSAnQ0RLX0RFRkFVTFRfQUNDT1VOVCc7XG4vKipcbiAqIEVudmlyb25tZW50IHZhcmlhYmxlIHNldCBieSB0aGUgQ0RLIENMSSB3aXRoIHRoZSBkZWZhdWx0IEFXUyByZWdpb24uXG4gKi9cbmV4cG9ydCBjb25zdCBERUZBVUxUX1JFR0lPTl9FTlYgPSAnQ0RLX0RFRkFVTFRfUkVHSU9OJztcbi8qKlxuICogVmVyc2lvbiBvZiBDbG91ZCBBc3NlbWJseSBleHBlY3RlZCBieSBDREsgQ0xJLlxuICpcbiAqIENMSSBzdGFydGVkIGVtaXR0aW5nIHRoaXMgYXQgMS4xMC4xXG4gKi9cbmV4cG9ydCBjb25zdCBDTElfQVNNX1ZFUlNJT05fRU5WID0gJ0NES19DTElfQVNNX1ZFUlNJT04nO1xuLyoqXG4gKiBWZXJzaW9uIG9mIHRoZSBDTEkgY3VycmVudGx5IHJ1bm5pbmcuXG4gKlxuICogQ0xJIHN0YXJ0ZWQgZW1pdHRpbmcgdGhpcyBhdCAxLjEwLjFcbiAqL1xuZXhwb3J0IGNvbnN0IENMSV9WRVJTSU9OX0VOViA9ICdDREtfQ0xJX1ZFUlNJT04nO1xuLyoqXG4gKiBJZiBhIGNvbnRleHQgdmFsdWUgaXMgYW4gb2JqZWN0IHdpdGggdGhpcyBrZXksIGl0IGluZGljYXRlcyBhbiBlcnJvclxuICovXG5leHBvcnQgY29uc3QgUFJPVklERVJfRVJST1JfS0VZID0gJyRwcm92aWRlckVycm9yJztcbiJdfQ==