"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BUNDLING_STACKS = exports.DISABLE_METADATA_STACK_TRACE = exports.DISABLE_ASSET_STAGING_CONTEXT = exports.DISABLE_VERSION_REPORTING = exports.PATH_METADATA_ENABLE_CONTEXT = void 0;
// --------------------------------------------------------------------------------
// This file declares context keys that are used by the CLI to control the
// behavior of CDK apps. Contrary to feature flags (which are defined under
// `features.ts`) these options are not bound to be removed in the next major
// version.
// --------------------------------------------------------------------------------
/**
 * Enables the embedding of the "aws:cdk:path" in CloudFormation template metadata.
 */
exports.PATH_METADATA_ENABLE_CONTEXT = 'aws:cdk:enable-path-metadata';
/**
 * Disable the collection and reporting of version information.
 */
exports.DISABLE_VERSION_REPORTING = 'aws:cdk:disable-version-reporting';
/**
 * If this is set, asset staging is disabled. This means that assets will not be copied to
 * the output directory and will be referenced with absolute source paths.
 */
exports.DISABLE_ASSET_STAGING_CONTEXT = 'aws:cdk:disable-asset-staging';
/**
 * If this context key is set, the CDK will stage assets under the specified
 * directory. Otherwise, assets will not be staged.
 * Omits stack traces from construct metadata entries.
 */
exports.DISABLE_METADATA_STACK_TRACE = 'aws:cdk:disable-stack-trace';
/**
 * Run bundling for stacks specified in this context key
 */
exports.BUNDLING_STACKS = 'aws:cdk:bundling-stacks';
//# sourceMappingURL=data:application/json;base64,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