"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnHook = void 0;
const cfn_element_1 = require("./cfn-element");
const util_1 = require("./util");
/**
 * Represents a CloudFormation resource.
 */
class CfnHook extends cfn_element_1.CfnElement {
    /**
     * Creates a new Hook object.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.type = props.type;
        this._cfnHookProperties = props.properties;
    }
    /** @internal */
    _toCloudFormation() {
        return {
            Hooks: {
                [this.logicalId]: {
                    Type: this.type,
                    Properties: util_1.ignoreEmpty(this.renderProperties(this._cfnHookProperties)),
                },
            },
        };
    }
    renderProperties(props) {
        return props;
    }
}
exports.CfnHook = CfnHook;
//# sourceMappingURL=data:application/json;base64,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