"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aspects = void 0;
const ASPECTS_SYMBOL = Symbol('cdk-aspects');
/**
 * Aspects can be applied to CDK tree scopes and can operate on the tree before
 * synthesis.
 */
class Aspects {
    // TODO(2.0): private readonly _aspects = new Array<IAspect>();
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * Returns the `Aspects` object associated with a construct scope.
     * @param scope The scope for which these aspects will apply.
     */
    static of(scope) {
        let aspects = scope[ASPECTS_SYMBOL];
        if (!aspects) {
            aspects = new Aspects(scope);
            Object.defineProperty(scope, ASPECTS_SYMBOL, {
                value: aspects,
                configurable: false,
                enumerable: false,
            });
        }
        return aspects;
    }
    /**
     * Adds an aspect to apply this scope before synthesis.
     * @param aspect The aspect to add.
     */
    add(aspect) {
        // TODO(2.0): this._aspects.push(aspect);
        this.scope.node._actualNode.applyAspect(aspect);
    }
    /**
     * The list of aspects which were directly applied on this scope.
     */
    get aspects() {
        // TODO(2.0): return  [ ...this._aspects ];
        return [...this.scope.node._actualNode._aspects]; // clone
    }
}
exports.Aspects = Aspects;
//# sourceMappingURL=data:application/json;base64,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