"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DISCARD = exports.Errors = void 0;
/**
 * Predefined error strings
 * Error names in Amazon States Language - https://states-language.net/spec.html#appendix-a
 * Error handling in Step Functions - https://docs.aws.amazon.com/step-functions/latest/dg/concepts-error-handling.html
 */
class Errors {
}
exports.Errors = Errors;
/**
 * Matches any Error.
 */
Errors.ALL = 'States.ALL';
/**
 * A Task State either ran longer than the “TimeoutSeconds” value, or
 * failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
 */
Errors.TIMEOUT = 'States.Timeout';
/**
 * A Task State failed during the execution.
 */
Errors.TASKS_FAILED = 'States.TaskFailed';
/**
 * A Task State failed because it had insufficient privileges to execute
 * the specified code.
 */
Errors.PERMISSIONS = 'States.Permissions';
/**
 * A Task State’s “ResultPath” field cannot be applied to the input the state received.
 */
Errors.RESULT_PATH_MATCH_FAILURE = 'States.ResultPathMatchFailure';
/**
 * Within a state’s “Parameters” field, the attempt to replace a field whose
 * name ends in “.$” using a Path failed.
 */
Errors.PARAMETER_PATH_FAILURE = 'States.ParameterPathFailure';
/**
 * A branch of a Parallel state failed.
 */
Errors.BRANCH_FAILED = 'States.BranchFailed';
/**
 * A Choice state failed to find a match for the condition field extracted
 * from its input.
 */
Errors.NO_CHOICE_MATCHED = 'States.NoChoiceMatched';
/**
 * Special string value to discard state input, output or result
 */
exports.DISCARD = 'DISCARD';
//# sourceMappingURL=data:application/json;base64,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