"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterSubnetGroup = void 0;
const ec2 = require("../../aws-ec2"); // Automatically re-written from '@aws-cdk/aws-ec2'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const redshift_generated_1 = require("./redshift.generated");
/**
 * Class for creating a Redshift cluster subnet group
 *
 * @resource AWS::Redshift::ClusterSubnetGroup
 */
class ClusterSubnetGroup extends core_1.Resource {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const { subnetIds } = props.vpc.selectSubnets((_a = props.vpcSubnets) !== null && _a !== void 0 ? _a : { subnetType: ec2.SubnetType.PRIVATE });
        const subnetGroup = new redshift_generated_1.CfnClusterSubnetGroup(this, 'Default', {
            description: props.description,
            subnetIds,
        });
        subnetGroup.applyRemovalPolicy((_b = props.removalPolicy) !== null && _b !== void 0 ? _b : core_1.RemovalPolicy.RETAIN, {
            applyToUpdateReplacePolicy: true,
        });
        this.clusterSubnetGroupName = subnetGroup.ref;
    }
    /**
     * Imports an existing subnet group by name.
     */
    static fromClusterSubnetGroupName(scope, id, clusterSubnetGroupName) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.clusterSubnetGroupName = clusterSubnetGroupName;
            }
        }(scope, id);
    }
}
exports.ClusterSubnetGroup = ClusterSubnetGroup;
//# sourceMappingURL=data:application/json;base64,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