"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnIdentity = exports.CfnDedicatedIpPool = exports.CfnConfigurationSetEventDestination = exports.CfnConfigurationSet = void 0;
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2020-09-22T23:27:16.805Z","fingerprint":"sKEiVPRVxTgBk70Y3TAOPle/odKVJ0rIK0h9cOA+gWw="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cfn_parse = require("../../core/lib/cfn-parse"); // Automatically re-written from '@aws-cdk/core/lib/cfn-parse'
/**
 * Determine whether the given properties match those of a `CfnConfigurationSetProps`
 *
 * @param properties - the TypeScript properties of a `CfnConfigurationSetProps`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('deliveryOptions', CfnConfigurationSet_DeliveryOptionsPropertyValidator)(properties.deliveryOptions));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('reputationOptions', CfnConfigurationSet_ReputationOptionsPropertyValidator)(properties.reputationOptions));
    errors.collect(cdk.propertyValidator('sendingOptions', CfnConfigurationSet_SendingOptionsPropertyValidator)(properties.sendingOptions));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnConfigurationSet_TagsPropertyValidator))(properties.tags));
    errors.collect(cdk.propertyValidator('trackingOptions', CfnConfigurationSet_TrackingOptionsPropertyValidator)(properties.trackingOptions));
    return errors.wrap('supplied properties not correct for "CfnConfigurationSetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet` resource
 *
 * @param properties - the TypeScript properties of a `CfnConfigurationSetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSetPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        DeliveryOptions: cfnConfigurationSetDeliveryOptionsPropertyToCloudFormation(properties.deliveryOptions),
        ReputationOptions: cfnConfigurationSetReputationOptionsPropertyToCloudFormation(properties.reputationOptions),
        SendingOptions: cfnConfigurationSetSendingOptionsPropertyToCloudFormation(properties.sendingOptions),
        Tags: cdk.listMapper(cfnConfigurationSetTagsPropertyToCloudFormation)(properties.tags),
        TrackingOptions: cfnConfigurationSetTrackingOptionsPropertyToCloudFormation(properties.trackingOptions),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        name: cfn_parse.FromCloudFormation.getString(properties.Name),
        deliveryOptions: properties.DeliveryOptions != null ? CfnConfigurationSetDeliveryOptionsPropertyFromCloudFormation(properties.DeliveryOptions) : undefined,
        reputationOptions: properties.ReputationOptions != null ? CfnConfigurationSetReputationOptionsPropertyFromCloudFormation(properties.ReputationOptions) : undefined,
        sendingOptions: properties.SendingOptions != null ? CfnConfigurationSetSendingOptionsPropertyFromCloudFormation(properties.SendingOptions) : undefined,
        tags: properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnConfigurationSetTagsPropertyFromCloudFormation)(properties.Tags) : undefined,
        trackingOptions: properties.TrackingOptions != null ? CfnConfigurationSetTrackingOptionsPropertyFromCloudFormation(properties.TrackingOptions) : undefined,
    };
}
/**
 * A CloudFormation `AWS::PinpointEmail::ConfigurationSet`
 *
 * @cloudformationResource AWS::PinpointEmail::ConfigurationSet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationset.html
 */
class CfnConfigurationSet extends cdk.CfnResource {
    /**
     * Create a new `AWS::PinpointEmail::ConfigurationSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnConfigurationSet.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'name', this);
        this.name = props.name;
        this.deliveryOptions = props.deliveryOptions;
        this.reputationOptions = props.reputationOptions;
        this.sendingOptions = props.sendingOptions;
        this.tags = props.tags;
        this.trackingOptions = props.trackingOptions;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const props = CfnConfigurationSetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnConfigurationSet(scope, id, props);
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnConfigurationSet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            deliveryOptions: this.deliveryOptions,
            reputationOptions: this.reputationOptions,
            sendingOptions: this.sendingOptions,
            tags: this.tags,
            trackingOptions: this.trackingOptions,
        };
    }
    renderProperties(props) {
        return cfnConfigurationSetPropsToCloudFormation(props);
    }
}
exports.CfnConfigurationSet = CfnConfigurationSet;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnConfigurationSet.CFN_RESOURCE_TYPE_NAME = "AWS::PinpointEmail::ConfigurationSet";
/**
 * Determine whether the given properties match those of a `DeliveryOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `DeliveryOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSet_DeliveryOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('sendingPoolName', cdk.validateString)(properties.sendingPoolName));
    return errors.wrap('supplied properties not correct for "DeliveryOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet.DeliveryOptions` resource
 *
 * @param properties - the TypeScript properties of a `DeliveryOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet.DeliveryOptions` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetDeliveryOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSet_DeliveryOptionsPropertyValidator(properties).assertSuccess();
    return {
        SendingPoolName: cdk.stringToCloudFormation(properties.sendingPoolName),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetDeliveryOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        sendingPoolName: properties.SendingPoolName != null ? cfn_parse.FromCloudFormation.getString(properties.SendingPoolName) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `ReputationOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `ReputationOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSet_ReputationOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('reputationMetricsEnabled', cdk.validateBoolean)(properties.reputationMetricsEnabled));
    return errors.wrap('supplied properties not correct for "ReputationOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet.ReputationOptions` resource
 *
 * @param properties - the TypeScript properties of a `ReputationOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet.ReputationOptions` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetReputationOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSet_ReputationOptionsPropertyValidator(properties).assertSuccess();
    return {
        ReputationMetricsEnabled: cdk.booleanToCloudFormation(properties.reputationMetricsEnabled),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetReputationOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        reputationMetricsEnabled: properties.ReputationMetricsEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReputationMetricsEnabled) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `SendingOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `SendingOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSet_SendingOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('sendingEnabled', cdk.validateBoolean)(properties.sendingEnabled));
    return errors.wrap('supplied properties not correct for "SendingOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet.SendingOptions` resource
 *
 * @param properties - the TypeScript properties of a `SendingOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet.SendingOptions` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetSendingOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSet_SendingOptionsPropertyValidator(properties).assertSuccess();
    return {
        SendingEnabled: cdk.booleanToCloudFormation(properties.sendingEnabled),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetSendingOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        sendingEnabled: properties.SendingEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.SendingEnabled) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSet_TagsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet.Tags` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetTagsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSet_TagsPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetTagsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        key: properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined,
        value: properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `TrackingOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `TrackingOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSet_TrackingOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('customRedirectDomain', cdk.validateString)(properties.customRedirectDomain));
    return errors.wrap('supplied properties not correct for "TrackingOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet.TrackingOptions` resource
 *
 * @param properties - the TypeScript properties of a `TrackingOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSet.TrackingOptions` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetTrackingOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSet_TrackingOptionsPropertyValidator(properties).assertSuccess();
    return {
        CustomRedirectDomain: cdk.stringToCloudFormation(properties.customRedirectDomain),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetTrackingOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        customRedirectDomain: properties.CustomRedirectDomain != null ? cfn_parse.FromCloudFormation.getString(properties.CustomRedirectDomain) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `CfnConfigurationSetEventDestinationProps`
 *
 * @param properties - the TypeScript properties of a `CfnConfigurationSetEventDestinationProps`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSetEventDestinationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('configurationSetName', cdk.requiredValidator)(properties.configurationSetName));
    errors.collect(cdk.propertyValidator('configurationSetName', cdk.validateString)(properties.configurationSetName));
    errors.collect(cdk.propertyValidator('eventDestination', CfnConfigurationSetEventDestination_EventDestinationPropertyValidator)(properties.eventDestination));
    errors.collect(cdk.propertyValidator('eventDestinationName', cdk.requiredValidator)(properties.eventDestinationName));
    errors.collect(cdk.propertyValidator('eventDestinationName', cdk.validateString)(properties.eventDestinationName));
    return errors.wrap('supplied properties not correct for "CfnConfigurationSetEventDestinationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination` resource
 *
 * @param properties - the TypeScript properties of a `CfnConfigurationSetEventDestinationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetEventDestinationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSetEventDestinationPropsValidator(properties).assertSuccess();
    return {
        ConfigurationSetName: cdk.stringToCloudFormation(properties.configurationSetName),
        EventDestinationName: cdk.stringToCloudFormation(properties.eventDestinationName),
        EventDestination: cfnConfigurationSetEventDestinationEventDestinationPropertyToCloudFormation(properties.eventDestination),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetEventDestinationPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        configurationSetName: cfn_parse.FromCloudFormation.getString(properties.ConfigurationSetName),
        eventDestinationName: cfn_parse.FromCloudFormation.getString(properties.EventDestinationName),
        eventDestination: properties.EventDestination != null ? CfnConfigurationSetEventDestinationEventDestinationPropertyFromCloudFormation(properties.EventDestination) : undefined,
    };
}
/**
 * A CloudFormation `AWS::PinpointEmail::ConfigurationSetEventDestination`
 *
 * @cloudformationResource AWS::PinpointEmail::ConfigurationSetEventDestination
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-configurationseteventdestination.html
 */
class CfnConfigurationSetEventDestination extends cdk.CfnResource {
    /**
     * Create a new `AWS::PinpointEmail::ConfigurationSetEventDestination`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnConfigurationSetEventDestination.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'configurationSetName', this);
        cdk.requireProperty(props, 'eventDestinationName', this);
        this.configurationSetName = props.configurationSetName;
        this.eventDestinationName = props.eventDestinationName;
        this.eventDestination = props.eventDestination;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const props = CfnConfigurationSetEventDestinationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnConfigurationSetEventDestination(scope, id, props);
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnConfigurationSetEventDestination.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            configurationSetName: this.configurationSetName,
            eventDestinationName: this.eventDestinationName,
            eventDestination: this.eventDestination,
        };
    }
    renderProperties(props) {
        return cfnConfigurationSetEventDestinationPropsToCloudFormation(props);
    }
}
exports.CfnConfigurationSetEventDestination = CfnConfigurationSetEventDestination;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnConfigurationSetEventDestination.CFN_RESOURCE_TYPE_NAME = "AWS::PinpointEmail::ConfigurationSetEventDestination";
/**
 * Determine whether the given properties match those of a `CloudWatchDestinationProperty`
 *
 * @param properties - the TypeScript properties of a `CloudWatchDestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSetEventDestination_CloudWatchDestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('dimensionConfigurations', cdk.listValidator(CfnConfigurationSetEventDestination_DimensionConfigurationPropertyValidator))(properties.dimensionConfigurations));
    return errors.wrap('supplied properties not correct for "CloudWatchDestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.CloudWatchDestination` resource
 *
 * @param properties - the TypeScript properties of a `CloudWatchDestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.CloudWatchDestination` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetEventDestinationCloudWatchDestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSetEventDestination_CloudWatchDestinationPropertyValidator(properties).assertSuccess();
    return {
        DimensionConfigurations: cdk.listMapper(cfnConfigurationSetEventDestinationDimensionConfigurationPropertyToCloudFormation)(properties.dimensionConfigurations),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetEventDestinationCloudWatchDestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        dimensionConfigurations: properties.DimensionConfigurations != null ? cfn_parse.FromCloudFormation.getArray(CfnConfigurationSetEventDestinationDimensionConfigurationPropertyFromCloudFormation)(properties.DimensionConfigurations) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `DimensionConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DimensionConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSetEventDestination_DimensionConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('defaultDimensionValue', cdk.requiredValidator)(properties.defaultDimensionValue));
    errors.collect(cdk.propertyValidator('defaultDimensionValue', cdk.validateString)(properties.defaultDimensionValue));
    errors.collect(cdk.propertyValidator('dimensionName', cdk.requiredValidator)(properties.dimensionName));
    errors.collect(cdk.propertyValidator('dimensionName', cdk.validateString)(properties.dimensionName));
    errors.collect(cdk.propertyValidator('dimensionValueSource', cdk.requiredValidator)(properties.dimensionValueSource));
    errors.collect(cdk.propertyValidator('dimensionValueSource', cdk.validateString)(properties.dimensionValueSource));
    return errors.wrap('supplied properties not correct for "DimensionConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.DimensionConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DimensionConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.DimensionConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetEventDestinationDimensionConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSetEventDestination_DimensionConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DefaultDimensionValue: cdk.stringToCloudFormation(properties.defaultDimensionValue),
        DimensionName: cdk.stringToCloudFormation(properties.dimensionName),
        DimensionValueSource: cdk.stringToCloudFormation(properties.dimensionValueSource),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetEventDestinationDimensionConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        defaultDimensionValue: cfn_parse.FromCloudFormation.getString(properties.DefaultDimensionValue),
        dimensionName: cfn_parse.FromCloudFormation.getString(properties.DimensionName),
        dimensionValueSource: cfn_parse.FromCloudFormation.getString(properties.DimensionValueSource),
    };
}
/**
 * Determine whether the given properties match those of a `EventDestinationProperty`
 *
 * @param properties - the TypeScript properties of a `EventDestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSetEventDestination_EventDestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('cloudWatchDestination', CfnConfigurationSetEventDestination_CloudWatchDestinationPropertyValidator)(properties.cloudWatchDestination));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('kinesisFirehoseDestination', CfnConfigurationSetEventDestination_KinesisFirehoseDestinationPropertyValidator)(properties.kinesisFirehoseDestination));
    errors.collect(cdk.propertyValidator('matchingEventTypes', cdk.requiredValidator)(properties.matchingEventTypes));
    errors.collect(cdk.propertyValidator('matchingEventTypes', cdk.listValidator(cdk.validateString))(properties.matchingEventTypes));
    errors.collect(cdk.propertyValidator('pinpointDestination', CfnConfigurationSetEventDestination_PinpointDestinationPropertyValidator)(properties.pinpointDestination));
    errors.collect(cdk.propertyValidator('snsDestination', CfnConfigurationSetEventDestination_SnsDestinationPropertyValidator)(properties.snsDestination));
    return errors.wrap('supplied properties not correct for "EventDestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.EventDestination` resource
 *
 * @param properties - the TypeScript properties of a `EventDestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.EventDestination` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetEventDestinationEventDestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSetEventDestination_EventDestinationPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchDestination: cfnConfigurationSetEventDestinationCloudWatchDestinationPropertyToCloudFormation(properties.cloudWatchDestination),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        KinesisFirehoseDestination: cfnConfigurationSetEventDestinationKinesisFirehoseDestinationPropertyToCloudFormation(properties.kinesisFirehoseDestination),
        MatchingEventTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.matchingEventTypes),
        PinpointDestination: cfnConfigurationSetEventDestinationPinpointDestinationPropertyToCloudFormation(properties.pinpointDestination),
        SnsDestination: cfnConfigurationSetEventDestinationSnsDestinationPropertyToCloudFormation(properties.snsDestination),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetEventDestinationEventDestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        cloudWatchDestination: properties.CloudWatchDestination != null ? CfnConfigurationSetEventDestinationCloudWatchDestinationPropertyFromCloudFormation(properties.CloudWatchDestination) : undefined,
        enabled: properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined,
        kinesisFirehoseDestination: properties.KinesisFirehoseDestination != null ? CfnConfigurationSetEventDestinationKinesisFirehoseDestinationPropertyFromCloudFormation(properties.KinesisFirehoseDestination) : undefined,
        matchingEventTypes: cfn_parse.FromCloudFormation.getStringArray(properties.MatchingEventTypes),
        pinpointDestination: properties.PinpointDestination != null ? CfnConfigurationSetEventDestinationPinpointDestinationPropertyFromCloudFormation(properties.PinpointDestination) : undefined,
        snsDestination: properties.SnsDestination != null ? CfnConfigurationSetEventDestinationSnsDestinationPropertyFromCloudFormation(properties.SnsDestination) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `KinesisFirehoseDestinationProperty`
 *
 * @param properties - the TypeScript properties of a `KinesisFirehoseDestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSetEventDestination_KinesisFirehoseDestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('deliveryStreamArn', cdk.requiredValidator)(properties.deliveryStreamArn));
    errors.collect(cdk.propertyValidator('deliveryStreamArn', cdk.validateString)(properties.deliveryStreamArn));
    errors.collect(cdk.propertyValidator('iamRoleArn', cdk.requiredValidator)(properties.iamRoleArn));
    errors.collect(cdk.propertyValidator('iamRoleArn', cdk.validateString)(properties.iamRoleArn));
    return errors.wrap('supplied properties not correct for "KinesisFirehoseDestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.KinesisFirehoseDestination` resource
 *
 * @param properties - the TypeScript properties of a `KinesisFirehoseDestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.KinesisFirehoseDestination` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetEventDestinationKinesisFirehoseDestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSetEventDestination_KinesisFirehoseDestinationPropertyValidator(properties).assertSuccess();
    return {
        DeliveryStreamArn: cdk.stringToCloudFormation(properties.deliveryStreamArn),
        IamRoleArn: cdk.stringToCloudFormation(properties.iamRoleArn),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetEventDestinationKinesisFirehoseDestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        deliveryStreamArn: cfn_parse.FromCloudFormation.getString(properties.DeliveryStreamArn),
        iamRoleArn: cfn_parse.FromCloudFormation.getString(properties.IamRoleArn),
    };
}
/**
 * Determine whether the given properties match those of a `PinpointDestinationProperty`
 *
 * @param properties - the TypeScript properties of a `PinpointDestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSetEventDestination_PinpointDestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('applicationArn', cdk.validateString)(properties.applicationArn));
    return errors.wrap('supplied properties not correct for "PinpointDestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.PinpointDestination` resource
 *
 * @param properties - the TypeScript properties of a `PinpointDestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.PinpointDestination` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetEventDestinationPinpointDestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSetEventDestination_PinpointDestinationPropertyValidator(properties).assertSuccess();
    return {
        ApplicationArn: cdk.stringToCloudFormation(properties.applicationArn),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetEventDestinationPinpointDestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        applicationArn: properties.ApplicationArn != null ? cfn_parse.FromCloudFormation.getString(properties.ApplicationArn) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `SnsDestinationProperty`
 *
 * @param properties - the TypeScript properties of a `SnsDestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationSetEventDestination_SnsDestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('topicArn', cdk.requiredValidator)(properties.topicArn));
    errors.collect(cdk.propertyValidator('topicArn', cdk.validateString)(properties.topicArn));
    return errors.wrap('supplied properties not correct for "SnsDestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.SnsDestination` resource
 *
 * @param properties - the TypeScript properties of a `SnsDestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::ConfigurationSetEventDestination.SnsDestination` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationSetEventDestinationSnsDestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationSetEventDestination_SnsDestinationPropertyValidator(properties).assertSuccess();
    return {
        TopicArn: cdk.stringToCloudFormation(properties.topicArn),
    };
}
// @ts-ignore TS6133
function CfnConfigurationSetEventDestinationSnsDestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        topicArn: cfn_parse.FromCloudFormation.getString(properties.TopicArn),
    };
}
/**
 * Determine whether the given properties match those of a `CfnDedicatedIpPoolProps`
 *
 * @param properties - the TypeScript properties of a `CfnDedicatedIpPoolProps`
 *
 * @returns the result of the validation.
 */
function CfnDedicatedIpPoolPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('poolName', cdk.validateString)(properties.poolName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnDedicatedIpPool_TagsPropertyValidator))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDedicatedIpPoolProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::DedicatedIpPool` resource
 *
 * @param properties - the TypeScript properties of a `CfnDedicatedIpPoolProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::DedicatedIpPool` resource.
 */
// @ts-ignore TS6133
function cfnDedicatedIpPoolPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDedicatedIpPoolPropsValidator(properties).assertSuccess();
    return {
        PoolName: cdk.stringToCloudFormation(properties.poolName),
        Tags: cdk.listMapper(cfnDedicatedIpPoolTagsPropertyToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDedicatedIpPoolPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        poolName: properties.PoolName != null ? cfn_parse.FromCloudFormation.getString(properties.PoolName) : undefined,
        tags: properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnDedicatedIpPoolTagsPropertyFromCloudFormation)(properties.Tags) : undefined,
    };
}
/**
 * A CloudFormation `AWS::PinpointEmail::DedicatedIpPool`
 *
 * @cloudformationResource AWS::PinpointEmail::DedicatedIpPool
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-dedicatedippool.html
 */
class CfnDedicatedIpPool extends cdk.CfnResource {
    /**
     * Create a new `AWS::PinpointEmail::DedicatedIpPool`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnDedicatedIpPool.CFN_RESOURCE_TYPE_NAME, properties: props });
        this.poolName = props.poolName;
        this.tags = props.tags;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const props = CfnDedicatedIpPoolPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDedicatedIpPool(scope, id, props);
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDedicatedIpPool.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            poolName: this.poolName,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return cfnDedicatedIpPoolPropsToCloudFormation(props);
    }
}
exports.CfnDedicatedIpPool = CfnDedicatedIpPool;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDedicatedIpPool.CFN_RESOURCE_TYPE_NAME = "AWS::PinpointEmail::DedicatedIpPool";
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDedicatedIpPool_TagsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::DedicatedIpPool.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::DedicatedIpPool.Tags` resource.
 */
// @ts-ignore TS6133
function cfnDedicatedIpPoolTagsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDedicatedIpPool_TagsPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnDedicatedIpPoolTagsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        key: properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined,
        value: properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `CfnIdentityProps`
 *
 * @param properties - the TypeScript properties of a `CfnIdentityProps`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('dkimSigningEnabled', cdk.validateBoolean)(properties.dkimSigningEnabled));
    errors.collect(cdk.propertyValidator('feedbackForwardingEnabled', cdk.validateBoolean)(properties.feedbackForwardingEnabled));
    errors.collect(cdk.propertyValidator('mailFromAttributes', CfnIdentity_MailFromAttributesPropertyValidator)(properties.mailFromAttributes));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnIdentity_TagsPropertyValidator))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnIdentityProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::Identity` resource
 *
 * @param properties - the TypeScript properties of a `CfnIdentityProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::Identity` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        DkimSigningEnabled: cdk.booleanToCloudFormation(properties.dkimSigningEnabled),
        FeedbackForwardingEnabled: cdk.booleanToCloudFormation(properties.feedbackForwardingEnabled),
        MailFromAttributes: cfnIdentityMailFromAttributesPropertyToCloudFormation(properties.mailFromAttributes),
        Tags: cdk.listMapper(cfnIdentityTagsPropertyToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnIdentityPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        name: cfn_parse.FromCloudFormation.getString(properties.Name),
        dkimSigningEnabled: properties.DkimSigningEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DkimSigningEnabled) : undefined,
        feedbackForwardingEnabled: properties.FeedbackForwardingEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.FeedbackForwardingEnabled) : undefined,
        mailFromAttributes: properties.MailFromAttributes != null ? CfnIdentityMailFromAttributesPropertyFromCloudFormation(properties.MailFromAttributes) : undefined,
        tags: properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnIdentityTagsPropertyFromCloudFormation)(properties.Tags) : undefined,
    };
}
/**
 * A CloudFormation `AWS::PinpointEmail::Identity`
 *
 * @cloudformationResource AWS::PinpointEmail::Identity
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html
 */
class CfnIdentity extends cdk.CfnResource {
    /**
     * Create a new `AWS::PinpointEmail::Identity`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIdentity.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'name', this);
        this.attrIdentityDnsRecordName1 = cdk.Token.asString(this.getAtt('IdentityDNSRecordName1'));
        this.attrIdentityDnsRecordName2 = cdk.Token.asString(this.getAtt('IdentityDNSRecordName2'));
        this.attrIdentityDnsRecordName3 = cdk.Token.asString(this.getAtt('IdentityDNSRecordName3'));
        this.attrIdentityDnsRecordValue1 = cdk.Token.asString(this.getAtt('IdentityDNSRecordValue1'));
        this.attrIdentityDnsRecordValue2 = cdk.Token.asString(this.getAtt('IdentityDNSRecordValue2'));
        this.attrIdentityDnsRecordValue3 = cdk.Token.asString(this.getAtt('IdentityDNSRecordValue3'));
        this.name = props.name;
        this.dkimSigningEnabled = props.dkimSigningEnabled;
        this.feedbackForwardingEnabled = props.feedbackForwardingEnabled;
        this.mailFromAttributes = props.mailFromAttributes;
        this.tags = props.tags;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const props = CfnIdentityPropsFromCloudFormation(resourceProperties);
        const ret = new CfnIdentity(scope, id, props);
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnIdentity.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            dkimSigningEnabled: this.dkimSigningEnabled,
            feedbackForwardingEnabled: this.feedbackForwardingEnabled,
            mailFromAttributes: this.mailFromAttributes,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return cfnIdentityPropsToCloudFormation(props);
    }
}
exports.CfnIdentity = CfnIdentity;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnIdentity.CFN_RESOURCE_TYPE_NAME = "AWS::PinpointEmail::Identity";
/**
 * Determine whether the given properties match those of a `MailFromAttributesProperty`
 *
 * @param properties - the TypeScript properties of a `MailFromAttributesProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentity_MailFromAttributesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('behaviorOnMxFailure', cdk.validateString)(properties.behaviorOnMxFailure));
    errors.collect(cdk.propertyValidator('mailFromDomain', cdk.validateString)(properties.mailFromDomain));
    return errors.wrap('supplied properties not correct for "MailFromAttributesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::Identity.MailFromAttributes` resource
 *
 * @param properties - the TypeScript properties of a `MailFromAttributesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::Identity.MailFromAttributes` resource.
 */
// @ts-ignore TS6133
function cfnIdentityMailFromAttributesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentity_MailFromAttributesPropertyValidator(properties).assertSuccess();
    return {
        BehaviorOnMxFailure: cdk.stringToCloudFormation(properties.behaviorOnMxFailure),
        MailFromDomain: cdk.stringToCloudFormation(properties.mailFromDomain),
    };
}
// @ts-ignore TS6133
function CfnIdentityMailFromAttributesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        behaviorOnMxFailure: properties.BehaviorOnMxFailure != null ? cfn_parse.FromCloudFormation.getString(properties.BehaviorOnMxFailure) : undefined,
        mailFromDomain: properties.MailFromDomain != null ? cfn_parse.FromCloudFormation.getString(properties.MailFromDomain) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentity_TagsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::PinpointEmail::Identity.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::PinpointEmail::Identity.Tags` resource.
 */
// @ts-ignore TS6133
function cfnIdentityTagsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentity_TagsPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnIdentityTagsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        key: properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined,
        value: properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined,
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlucG9pbnRlbWFpbC5nZW5lcmF0ZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJwaW5wb2ludGVtYWlsLmdlbmVyYXRlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSwrRUFBK0U7QUFDL0UsK0RBQStEO0FBQy9ELDhGQUE4RjtBQUM5RixzSEFBc0g7QUFDdEgsNEJBQTRCLENBQUMsaUVBQWlFO0FBQzlGLGtDQUFrQyxDQUFDLGdEQUFnRDtBQUNuRixzREFBc0QsQ0FBQyw4REFBOEQ7QUF1Q3JIOzs7Ozs7R0FNRztBQUNILFNBQVMsaUNBQWlDLENBQUMsVUFBZTtJQUN0RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUNqQztJQUNELE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsb0RBQW9ELENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUMzSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUNuRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxzREFBc0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDakosTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsbURBQW1ELENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN4SSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyx5Q0FBeUMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDN0gsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsb0RBQW9ELENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUMzSSxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsZ0VBQWdFLENBQUMsQ0FBQztBQUN6RixDQUFDO0FBQ0Q7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsd0NBQXdDLENBQUMsVUFBZTtJQUM3RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELGlDQUFpQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzlELE9BQU87UUFDSCxJQUFJLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7UUFDakQsZUFBZSxFQUFFLDBEQUEwRCxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDdkcsaUJBQWlCLEVBQUUsNERBQTRELENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzdHLGNBQWMsRUFBRSx5REFBeUQsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1FBQ3BHLElBQUksRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLCtDQUErQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUN0RixlQUFlLEVBQUUsMERBQTBELENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztLQUMxRyxDQUFDO0FBQ04sQ0FBQztBQUNELG9CQUFvQjtBQUNwQixTQUFTLDBDQUEwQyxDQUFDLFVBQWU7SUFDL0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxFQUFFLENBQUM7SUFDOUIsT0FBTztRQUNILElBQUksRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7UUFDN0QsZUFBZSxFQUFFLFVBQVUsQ0FBQyxlQUFlLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyw0REFBNEQsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7UUFDMUosaUJBQWlCLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsOERBQThELENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7UUFDbEssY0FBYyxFQUFFLFVBQVUsQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQywyREFBMkQsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7UUFDdEosSUFBSSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLGlEQUFpRCxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFnQjtRQUM1SixlQUFlLEVBQUUsVUFBVSxDQUFDLGVBQWUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLDREQUE0RCxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUztLQUM3SixDQUFDO0FBQ04sQ0FBQztBQUNEOzs7Ozs7R0FNRztBQUNILE1BQWEsbUJBQW9CLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUFrRHBEOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBK0I7UUFDekUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsbUJBQW1CLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7UUFDMUYsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3pDLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztRQUN2QixJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRCxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFDM0MsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztJQUNqRCxDQUFDO0lBN0REOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLEtBQUssR0FBRywwQ0FBMEMsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzdFLE1BQU0sR0FBRyxHQUFHLElBQUksbUJBQW1CLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUN0RCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztJQUNmLENBQUM7SUFnREQ7Ozs7OztPQU1HO0lBQ0ksT0FBTyxDQUFDLFNBQTRCO1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsbUJBQW1CLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNsRyxTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUMvRSxDQUFDO0lBQ0QsSUFBYyxhQUFhO1FBR3ZCLE9BQU87WUFDSCxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7WUFDZixlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN6QyxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2YsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1NBQ3hDLENBQUM7SUFDTixDQUFDO0lBQ1MsZ0JBQWdCLENBQUMsS0FFMUI7UUFHRyxPQUFPLHdDQUF3QyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQzNELENBQUM7O0FBaEdMLGtEQWlHQztBQWhHRzs7R0FFRztBQUNvQiwwQ0FBc0IsR0FBRyxzQ0FBc0MsQ0FBQztBQTJHM0Y7Ozs7OztHQU1HO0FBQ0gsU0FBUyxvREFBb0QsQ0FBQyxVQUFlO0lBQ3pFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQ2pDO0lBQ0QsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLCtEQUErRCxDQUFDLENBQUM7QUFDeEYsQ0FBQztBQUNEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDBEQUEwRCxDQUFDLFVBQWU7SUFDL0UsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDN0IsT0FBTyxVQUFVLENBQUM7S0FDckI7SUFDRCxvREFBb0QsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNqRixPQUFPO1FBQ0gsZUFBZSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO0tBQzFFLENBQUM7QUFDTixDQUFDO0FBQ0Qsb0JBQW9CO0FBQ3BCLFNBQVMsNERBQTRELENBQUMsVUFBZTtJQUNqRixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksRUFBRSxDQUFDO0lBQzlCLE9BQU87UUFDSCxlQUFlLEVBQUUsVUFBVSxDQUFDLGVBQWUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO0tBQ3ZJLENBQUM7QUFDTixDQUFDO0FBY0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyxzREFBc0QsQ0FBQyxVQUFlO0lBQzNFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQ2pDO0lBQ0QsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywwQkFBMEIsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLHdCQUF3QixDQUFDLENBQUMsQ0FBQztJQUM1SCxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsaUVBQWlFLENBQUMsQ0FBQztBQUMxRixDQUFDO0FBQ0Q7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsNERBQTRELENBQUMsVUFBZTtJQUNqRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELHNEQUFzRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ25GLE9BQU87UUFDSCx3QkFBd0IsRUFBRSxHQUFHLENBQUMsdUJBQXVCLENBQUMsVUFBVSxDQUFDLHdCQUF3QixDQUFDO0tBQzdGLENBQUM7QUFDTixDQUFDO0FBQ0Qsb0JBQW9CO0FBQ3BCLFNBQVMsOERBQThELENBQUMsVUFBZTtJQUNuRixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksRUFBRSxDQUFDO0lBQzlCLE9BQU87UUFDSCx3QkFBd0IsRUFBRSxVQUFVLENBQUMsd0JBQXdCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO0tBQ25LLENBQUM7QUFDTixDQUFDO0FBY0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyxtREFBbUQsQ0FBQyxVQUFlO0lBQ3hFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQ2pDO0lBQ0QsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDeEcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDhEQUE4RCxDQUFDLENBQUM7QUFDdkYsQ0FBQztBQUNEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHlEQUF5RCxDQUFDLFVBQWU7SUFDOUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDN0IsT0FBTyxVQUFVLENBQUM7S0FDckI7SUFDRCxtREFBbUQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNoRixPQUFPO1FBQ0gsY0FBYyxFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO0tBQ3pFLENBQUM7QUFDTixDQUFDO0FBQ0Qsb0JBQW9CO0FBQ3BCLFNBQVMsMkRBQTJELENBQUMsVUFBZTtJQUNoRixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksRUFBRSxDQUFDO0lBQzlCLE9BQU87UUFDSCxjQUFjLEVBQUUsVUFBVSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO0tBQ3JJLENBQUM7QUFDTixDQUFDO0FBbUJEOzs7Ozs7R0FNRztBQUNILFNBQVMseUNBQXlDLENBQUMsVUFBZTtJQUM5RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUNqQztJQUNELE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ3JGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxvREFBb0QsQ0FBQyxDQUFDO0FBQzdFLENBQUM7QUFDRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUywrQ0FBK0MsQ0FBQyxVQUFlO0lBQ3BFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sVUFBVSxDQUFDO0tBQ3JCO0lBQ0QseUNBQXlDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDdEUsT0FBTztRQUNILEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUMvQyxLQUFLLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7S0FDdEQsQ0FBQztBQUNOLENBQUM7QUFDRCxvQkFBb0I7QUFDcEIsU0FBUyxpREFBaUQsQ0FBQyxVQUFlO0lBQ3RFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sVUFBVSxDQUFDO0tBQ3JCO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxFQUFFLENBQUM7SUFDOUIsT0FBTztRQUNILEdBQUcsRUFBRSxVQUFVLENBQUMsR0FBRyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7UUFDaEcsS0FBSyxFQUFFLFVBQVUsQ0FBQyxLQUFLLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUztLQUN6RyxDQUFDO0FBQ04sQ0FBQztBQWNEOzs7Ozs7R0FNRztBQUNILFNBQVMsb0RBQW9ELENBQUMsVUFBZTtJQUN6RSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUNqQztJQUNELE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLCtEQUErRCxDQUFDLENBQUM7QUFDeEYsQ0FBQztBQUNEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDBEQUEwRCxDQUFDLFVBQWU7SUFDL0UsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDN0IsT0FBTyxVQUFVLENBQUM7S0FDckI7SUFDRCxvREFBb0QsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNqRixPQUFPO1FBQ0gsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztLQUNwRixDQUFDO0FBQ04sQ0FBQztBQUNELG9CQUFvQjtBQUNwQixTQUFTLDREQUE0RCxDQUFDLFVBQWU7SUFDakYsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxVQUFVLENBQUM7S0FDckI7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLEVBQUUsQ0FBQztJQUM5QixPQUFPO1FBQ0gsb0JBQW9CLEVBQUUsVUFBVSxDQUFDLG9CQUFvQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUztLQUN0SixDQUFDO0FBQ04sQ0FBQztBQXdCRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLGlEQUFpRCxDQUFDLFVBQWU7SUFDdEUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDN0IsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FDakM7SUFDRCxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDdEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUscUVBQXFFLENBQUMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO0lBQzlKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDdEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLGdGQUFnRixDQUFDLENBQUM7QUFDekcsQ0FBQztBQUNEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHdEQUF3RCxDQUFDLFVBQWU7SUFDN0UsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDN0IsT0FBTyxVQUFVLENBQUM7S0FDckI7SUFDRCxpREFBaUQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM5RSxPQUFPO1FBQ0gsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNqRixvQkFBb0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ2pGLGdCQUFnQixFQUFFLDJFQUEyRSxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztLQUM3SCxDQUFDO0FBQ04sQ0FBQztBQUNELG9CQUFvQjtBQUNwQixTQUFTLDBEQUEwRCxDQUFDLFVBQWU7SUFDL0UsVUFBVSxHQUFHLFVBQVUsSUFBSSxFQUFFLENBQUM7SUFDOUIsT0FBTztRQUNILG9CQUFvQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQzdGLG9CQUFvQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQzdGLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLDZFQUE2RSxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO0tBQ2pMLENBQUM7QUFDTixDQUFDO0FBQ0Q7Ozs7OztHQU1HO0FBQ0gsTUFBYSxtQ0FBb0MsU0FBUSxHQUFHLENBQUMsV0FBVztJQW1DcEU7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUErQztRQUN6RixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxtQ0FBbUMsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUMxRyxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxzQkFBc0IsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUN6RCxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxzQkFBc0IsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUN6RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7UUFDdkQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztJQUNuRCxDQUFDO0lBNUNEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLEtBQUssR0FBRywwREFBMEQsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzdGLE1BQU0sR0FBRyxHQUFHLElBQUksbUNBQW1DLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUN0RSxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztJQUNmLENBQUM7SUErQkQ7Ozs7OztPQU1HO0lBQ0ksT0FBTyxDQUFDLFNBQTRCO1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsbUNBQW1DLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNsSCxTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUMvRSxDQUFDO0lBQ0QsSUFBYyxhQUFhO1FBR3ZCLE9BQU87WUFDSCxvQkFBb0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQy9DLG9CQUFvQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7WUFDL0MsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtTQUMxQyxDQUFDO0lBQ04sQ0FBQztJQUNTLGdCQUFnQixDQUFDLEtBRTFCO1FBR0csT0FBTyx3REFBd0QsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMzRSxDQUFDOztBQTVFTCxrRkE2RUM7QUE1RUc7O0dBRUc7QUFDb0IsMERBQXNCLEdBQUcsc0RBQXNELENBQUM7QUF1RjNHOzs7Ozs7R0FNRztBQUNILFNBQVMsMEVBQTBFLENBQUMsVUFBZTtJQUMvRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUNqQztJQUNELE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQywyRUFBMkUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQztJQUNyTSxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMscUVBQXFFLENBQUMsQ0FBQztBQUM5RixDQUFDO0FBQ0Q7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsZ0ZBQWdGLENBQUMsVUFBZTtJQUNyRyxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELDBFQUEwRSxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3ZHLE9BQU87UUFDSCx1QkFBdUIsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLGlGQUFpRixDQUFDLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDO0tBQ2pLLENBQUM7QUFDTixDQUFDO0FBQ0Qsb0JBQW9CO0FBQ3BCLFNBQVMsa0ZBQWtGLENBQUMsVUFBZTtJQUN2RyxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksRUFBRSxDQUFDO0lBQzlCLE9BQU87UUFDSCx1QkFBdUIsRUFBRSxVQUFVLENBQUMsdUJBQXVCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLG1GQUFtRixDQUFDLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7S0FDblAsQ0FBQztBQUNOLENBQUM7QUF3QkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUywyRUFBMkUsQ0FBQyxVQUFlO0lBQ2hHLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQ2pDO0lBQ0QsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDO0lBQ3hILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDO0lBQ3JILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQztJQUN4RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDdEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHNFQUFzRSxDQUFDLENBQUM7QUFDL0YsQ0FBQztBQUNEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGlGQUFpRixDQUFDLFVBQWU7SUFDdEcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDN0IsT0FBTyxVQUFVLENBQUM7S0FDckI7SUFDRCwyRUFBMkUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN4RyxPQUFPO1FBQ0gscUJBQXFCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQztRQUNuRixhQUFhLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7UUFDbkUsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztLQUNwRixDQUFDO0FBQ04sQ0FBQztBQUNELG9CQUFvQjtBQUNwQixTQUFTLG1GQUFtRixDQUFDLFVBQWU7SUFDeEcsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxVQUFVLENBQUM7S0FDckI7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLEVBQUUsQ0FBQztJQUM5QixPQUFPO1FBQ0gscUJBQXFCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUM7UUFDL0YsYUFBYSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQztRQUMvRSxvQkFBb0IsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztLQUNoRyxDQUFDO0FBQ04sQ0FBQztBQXVDRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHFFQUFxRSxDQUFDLFVBQWU7SUFDMUYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDN0IsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FDakM7SUFDRCxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLDBFQUEwRSxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztJQUM3SyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzFGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDRCQUE0QixFQUFFLCtFQUErRSxDQUFDLENBQUMsVUFBVSxDQUFDLDBCQUEwQixDQUFDLENBQUMsQ0FBQztJQUM1TCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDO0lBQ2xILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUNsSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSx3RUFBd0UsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDdkssTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsbUVBQW1FLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN4SixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsZ0VBQWdFLENBQUMsQ0FBQztBQUN6RixDQUFDO0FBQ0Q7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsMkVBQTJFLENBQUMsVUFBZTtJQUNoRyxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELHFFQUFxRSxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ2xHLE9BQU87UUFDSCxxQkFBcUIsRUFBRSxnRkFBZ0YsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUM7UUFDekksT0FBTyxFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ3hELDBCQUEwQixFQUFFLHFGQUFxRixDQUFDLFVBQVUsQ0FBQywwQkFBMEIsQ0FBQztRQUN4SixrQkFBa0IsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQztRQUM3RixtQkFBbUIsRUFBRSw4RUFBOEUsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7UUFDbkksY0FBYyxFQUFFLHlFQUF5RSxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7S0FDdkgsQ0FBQztBQUNOLENBQUM7QUFDRCxvQkFBb0I7QUFDcEIsU0FBUyw2RUFBNkUsQ0FBQyxVQUFlO0lBQ2xHLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sVUFBVSxDQUFDO0tBQ3JCO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxFQUFFLENBQUM7SUFDOUIsT0FBTztRQUNILHFCQUFxQixFQUFFLFVBQVUsQ0FBQyxxQkFBcUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLGtGQUFrRixDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO1FBQ2xNLE9BQU8sRUFBRSxVQUFVLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7UUFDN0csMEJBQTBCLEVBQUUsVUFBVSxDQUFDLDBCQUEwQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsdUZBQXVGLENBQUMsVUFBVSxDQUFDLDBCQUEwQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7UUFDdE4sa0JBQWtCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUM7UUFDOUYsbUJBQW1CLEVBQUUsVUFBVSxDQUFDLG1CQUFtQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsZ0ZBQWdGLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7UUFDMUwsY0FBYyxFQUFFLFVBQVUsQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQywyRUFBMkUsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7S0FDekssQ0FBQztBQUNOLENBQUM7QUFtQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUywrRUFBK0UsQ0FBQyxVQUFlO0lBQ3BHLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQ2pDO0lBQ0QsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQ2hILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQzdHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUNsRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywwRUFBMEUsQ0FBQyxDQUFDO0FBQ25HLENBQUM7QUFDRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxxRkFBcUYsQ0FBQyxVQUFlO0lBQzFHLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sVUFBVSxDQUFDO0tBQ3JCO0lBQ0QsK0VBQStFLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDNUcsT0FBTztRQUNILGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDM0UsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO0tBQ2hFLENBQUM7QUFDTixDQUFDO0FBQ0Qsb0JBQW9CO0FBQ3BCLFNBQVMsdUZBQXVGLENBQUMsVUFBZTtJQUM1RyxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksRUFBRSxDQUFDO0lBQzlCLE9BQU87UUFDSCxpQkFBaUIsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUN2RixVQUFVLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO0tBQzVFLENBQUM7QUFDTixDQUFDO0FBY0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyx3RUFBd0UsQ0FBQyxVQUFlO0lBQzdGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQ2pDO0lBQ0QsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDdkcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLG1FQUFtRSxDQUFDLENBQUM7QUFDNUYsQ0FBQztBQUNEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDhFQUE4RSxDQUFDLFVBQWU7SUFDbkcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDN0IsT0FBTyxVQUFVLENBQUM7S0FDckI7SUFDRCx3RUFBd0UsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNyRyxPQUFPO1FBQ0gsY0FBYyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO0tBQ3hFLENBQUM7QUFDTixDQUFDO0FBQ0Qsb0JBQW9CO0FBQ3BCLFNBQVMsZ0ZBQWdGLENBQUMsVUFBZTtJQUNyRyxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksRUFBRSxDQUFDO0lBQzlCLE9BQU87UUFDSCxjQUFjLEVBQUUsVUFBVSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO0tBQ3BJLENBQUM7QUFDTixDQUFDO0FBY0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyxtRUFBbUUsQ0FBQyxVQUFlO0lBQ3hGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQ2pDO0lBQ0QsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsOERBQThELENBQUMsQ0FBQztBQUN2RixDQUFDO0FBQ0Q7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMseUVBQXlFLENBQUMsVUFBZTtJQUM5RixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELG1FQUFtRSxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ2hHLE9BQU87UUFDSCxRQUFRLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7S0FDNUQsQ0FBQztBQUNOLENBQUM7QUFDRCxvQkFBb0I7QUFDcEIsU0FBUywyRUFBMkUsQ0FBQyxVQUFlO0lBQ2hHLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sVUFBVSxDQUFDO0tBQ3JCO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxFQUFFLENBQUM7SUFDOUIsT0FBTztRQUNILFFBQVEsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7S0FDeEUsQ0FBQztBQUNOLENBQUM7QUFtQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxnQ0FBZ0MsQ0FBQyxVQUFlO0lBQ3JELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQ2pDO0lBQ0QsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLHdDQUF3QyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUM1SCxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsK0RBQStELENBQUMsQ0FBQztBQUN4RixDQUFDO0FBQ0Q7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsdUNBQXVDLENBQUMsVUFBZTtJQUM1RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzdELE9BQU87UUFDSCxRQUFRLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDekQsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsOENBQThDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO0tBQ3hGLENBQUM7QUFDTixDQUFDO0FBQ0Qsb0JBQW9CO0FBQ3BCLFNBQVMseUNBQXlDLENBQUMsVUFBZTtJQUM5RCxVQUFVLEdBQUcsVUFBVSxJQUFJLEVBQUUsQ0FBQztJQUM5QixPQUFPO1FBQ0gsUUFBUSxFQUFFLFVBQVUsQ0FBQyxRQUFRLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUztRQUMvRyxJQUFJLEVBQUUsVUFBVSxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsZ0RBQWdELENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCO0tBQzlKLENBQUM7QUFDTixDQUFDO0FBQ0Q7Ozs7OztHQU1HO0FBQ0gsTUFBYSxrQkFBbUIsU0FBUSxHQUFHLENBQUMsV0FBVztJQThCbkQ7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxRQUFpQyxFQUFFO1FBQzdFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLGtCQUFrQixDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQ3pGLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7SUFDM0IsQ0FBQztJQXBDRDs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBb0IsRUFBRSxFQUFVLEVBQUUsa0JBQXVCLEVBQUUsT0FBNEM7UUFDckksa0JBQWtCLEdBQUcsa0JBQWtCLElBQUksRUFBRSxDQUFDO1FBQzlDLE1BQU0sa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDcEYsTUFBTSxLQUFLLEdBQUcseUNBQXlDLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUM1RSxNQUFNLEdBQUcsR0FBRyxJQUFJLGtCQUFrQixDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDckQsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7SUFDZixDQUFDO0lBdUJEOzs7Ozs7T0FNRztJQUNJLE9BQU8sQ0FBQyxTQUE0QjtRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLGtCQUFrQixDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDakcsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDL0UsQ0FBQztJQUNELElBQWMsYUFBYTtRQUd2QixPQUFPO1lBQ0gsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtTQUNsQixDQUFDO0lBQ04sQ0FBQztJQUNTLGdCQUFnQixDQUFDLEtBRTFCO1FBR0csT0FBTyx1Q0FBdUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMxRCxDQUFDOztBQW5FTCxnREFvRUM7QUFuRUc7O0dBRUc7QUFDb0IseUNBQXNCLEdBQUcscUNBQXFDLENBQUM7QUFtRjFGOzs7Ozs7R0FNRztBQUNILFNBQVMsd0NBQXdDLENBQUMsVUFBZTtJQUM3RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUNqQztJQUNELE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ3JGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxvREFBb0QsQ0FBQyxDQUFDO0FBQzdFLENBQUM7QUFDRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw4Q0FBOEMsQ0FBQyxVQUFlO0lBQ25FLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sVUFBVSxDQUFDO0tBQ3JCO0lBQ0Qsd0NBQXdDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDckUsT0FBTztRQUNILEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUMvQyxLQUFLLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7S0FDdEQsQ0FBQztBQUNOLENBQUM7QUFDRCxvQkFBb0I7QUFDcEIsU0FBUyxnREFBZ0QsQ0FBQyxVQUFlO0lBQ3JFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sVUFBVSxDQUFDO0tBQ3JCO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxFQUFFLENBQUM7SUFDOUIsT0FBTztRQUNILEdBQUcsRUFBRSxVQUFVLENBQUMsR0FBRyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7UUFDaEcsS0FBSyxFQUFFLFVBQVUsQ0FBQyxLQUFLLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUztLQUN6RyxDQUFDO0FBQ04sQ0FBQztBQWtDRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHlCQUF5QixDQUFDLFVBQWU7SUFDOUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDN0IsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FDakM7SUFDRCxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDO0lBQ2hILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDJCQUEyQixFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMseUJBQXlCLENBQUMsQ0FBQyxDQUFDO0lBQzlILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLCtDQUErQyxDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUM1SSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUNuRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDckgsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHdEQUF3RCxDQUFDLENBQUM7QUFDakYsQ0FBQztBQUNEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGdDQUFnQyxDQUFDLFVBQWU7SUFDckQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDN0IsT0FBTyxVQUFVLENBQUM7S0FDckI7SUFDRCx5QkFBeUIsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN0RCxPQUFPO1FBQ0gsSUFBSSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO1FBQ2pELGtCQUFrQixFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUM7UUFDOUUseUJBQXlCLEVBQUUsR0FBRyxDQUFDLHVCQUF1QixDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQztRQUM1RixrQkFBa0IsRUFBRSxxREFBcUQsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUM7UUFDeEcsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsdUNBQXVDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO0tBQ2pGLENBQUM7QUFDTixDQUFDO0FBQ0Qsb0JBQW9CO0FBQ3BCLFNBQVMsa0NBQWtDLENBQUMsVUFBZTtJQUN2RCxVQUFVLEdBQUcsVUFBVSxJQUFJLEVBQUUsQ0FBQztJQUM5QixPQUFPO1FBQ0gsSUFBSSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUM3RCxrQkFBa0IsRUFBRSxVQUFVLENBQUMsa0JBQWtCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO1FBQzlJLHlCQUF5QixFQUFFLFVBQVUsQ0FBQyx5QkFBeUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLHlCQUF5QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7UUFDbkssa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGtCQUFrQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsdURBQXVELENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7UUFDOUosSUFBSSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLHlDQUF5QyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFnQjtLQUN2SixDQUFDO0FBQ04sQ0FBQztBQUNEOzs7Ozs7R0FNRztBQUNILE1BQWEsV0FBWSxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBcUU1Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXVCO1FBQ2pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLFdBQVcsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUNsRixHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDekMsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDO1FBQzVGLElBQUksQ0FBQywwQkFBMEIsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLHdCQUF3QixDQUFDLENBQUMsQ0FBQztRQUM1RixJQUFJLENBQUMsMEJBQTBCLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUM7UUFDNUYsSUFBSSxDQUFDLDJCQUEyQixHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMseUJBQXlCLENBQUMsQ0FBQyxDQUFDO1FBQzlGLElBQUksQ0FBQywyQkFBMkIsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLHlCQUF5QixDQUFDLENBQUMsQ0FBQztRQUM5RixJQUFJLENBQUMsMkJBQTJCLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLENBQUM7UUFDOUYsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUM7UUFDbkQsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQztRQUNqRSxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO1FBQ25ELElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztJQUMzQixDQUFDO0lBckZEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLEtBQUssR0FBRyxrQ0FBa0MsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3JFLE1BQU0sR0FBRyxHQUFHLElBQUksV0FBVyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDOUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7SUFDZixDQUFDO0lBd0VEOzs7Ozs7T0FNRztJQUNJLE9BQU8sQ0FBQyxTQUE0QjtRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLFdBQVcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQzFGLFNBQVMsQ0FBQyxZQUFZLENBQUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQy9FLENBQUM7SUFDRCxJQUFjLGFBQWE7UUFHdkIsT0FBTztZQUNILElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtZQUNmLGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDM0MseUJBQXlCLEVBQUUsSUFBSSxDQUFDLHlCQUF5QjtZQUN6RCxrQkFBa0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO1lBQzNDLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtTQUNsQixDQUFDO0lBQ04sQ0FBQztJQUNTLGdCQUFnQixDQUFDLEtBRTFCO1FBR0csT0FBTyxnQ0FBZ0MsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNuRCxDQUFDOztBQXZITCxrQ0F3SEM7QUF2SEc7O0dBRUc7QUFDb0Isa0NBQXNCLEdBQUcsOEJBQThCLENBQUM7QUF1SW5GOzs7Ozs7R0FNRztBQUNILFNBQVMsK0NBQStDLENBQUMsVUFBZTtJQUNwRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUM3QixPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUNqQztJQUNELE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDakgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxrRUFBa0UsQ0FBQyxDQUFDO0FBQzNGLENBQUM7QUFDRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxxREFBcUQsQ0FBQyxVQUFlO0lBQzFFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sVUFBVSxDQUFDO0tBQ3JCO0lBQ0QsK0NBQStDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDNUUsT0FBTztRQUNILG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7UUFDL0UsY0FBYyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO0tBQ3hFLENBQUM7QUFDTixDQUFDO0FBQ0Qsb0JBQW9CO0FBQ3BCLFNBQVMsdURBQXVELENBQUMsVUFBZTtJQUM1RSxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLFVBQVUsQ0FBQztLQUNyQjtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksRUFBRSxDQUFDO0lBQzlCLE9BQU87UUFDSCxtQkFBbUIsRUFBRSxVQUFVLENBQUMsbUJBQW1CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO1FBQ2hKLGNBQWMsRUFBRSxVQUFVLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7S0FDcEksQ0FBQztBQUNOLENBQUM7QUFtQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxpQ0FBaUMsQ0FBQyxVQUFlO0lBQ3RELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQzdCLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQ2pDO0lBQ0QsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDckYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLG9EQUFvRCxDQUFDLENBQUM7QUFDN0UsQ0FBQztBQUNEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHVDQUF1QyxDQUFDLFVBQWU7SUFDNUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDN0IsT0FBTyxVQUFVLENBQUM7S0FDckI7SUFDRCxpQ0FBaUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM5RCxPQUFPO1FBQ0gsR0FBRyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDO1FBQy9DLEtBQUssRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQztLQUN0RCxDQUFDO0FBQ04sQ0FBQztBQUNELG9CQUFvQjtBQUNwQixTQUFTLHlDQUF5QyxDQUFDLFVBQWU7SUFDOUQsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxVQUFVLENBQUM7S0FDckI7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLEVBQUUsQ0FBQztJQUM5QixPQUFPO1FBQ0gsR0FBRyxFQUFFLFVBQVUsQ0FBQyxHQUFHLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUztRQUNoRyxLQUFLLEVBQUUsVUFBVSxDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO0tBQ3pHLENBQUM7QUFDTixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTItMjAyMCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXG4vLyBTZWU6IGRvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tcmVzb3VyY2Utc3BlY2lmaWNhdGlvbi5odG1sXG4vLyBAY2ZuMnRzOm1ldGFAIHtcImdlbmVyYXRlZFwiOlwiMjAyMC0wOS0yMlQyMzoyNzoxNi44MDVaXCIsXCJmaW5nZXJwcmludFwiOlwic0tFaVZQUlZ4VGdCazcwWTNUQU9QbGUvb2RLVkowcklLMGg5Y09BK2dXdz1cIn1cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4gKi8gLy8gVGhpcyBpcyBnZW5lcmF0ZWQgY29kZSAtIGxpbmUgbGVuZ3RocyBhcmUgZGlmZmljdWx0IHRvIGNvbnRyb2xcbmltcG9ydCAqIGFzIGNkayBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCAqIGFzIGNmbl9wYXJzZSBmcm9tIFwiLi4vLi4vY29yZS9saWIvY2ZuLXBhcnNlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlL2xpYi9jZm4tcGFyc2UnXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldGBcbiAqXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuQ29uZmlndXJhdGlvblNldFByb3BzIHtcbiAgICAvKipcbiAgICAgKiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0Lk5hbWVgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0LW5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldC5EZWxpdmVyeU9wdGlvbnNgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0LWRlbGl2ZXJ5b3B0aW9uc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlbGl2ZXJ5T3B0aW9ucz86IENmbkNvbmZpZ3VyYXRpb25TZXQuRGVsaXZlcnlPcHRpb25zUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldC5SZXB1dGF0aW9uT3B0aW9uc2BcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQtcmVwdXRhdGlvbm9wdGlvbnNcbiAgICAgKi9cbiAgICByZWFkb25seSByZXB1dGF0aW9uT3B0aW9ucz86IENmbkNvbmZpZ3VyYXRpb25TZXQuUmVwdXRhdGlvbk9wdGlvbnNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAvKipcbiAgICAgKiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0LlNlbmRpbmdPcHRpb25zYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0Lmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC1zZW5kaW5nb3B0aW9uc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlbmRpbmdPcHRpb25zPzogQ2ZuQ29uZmlndXJhdGlvblNldC5TZW5kaW5nT3B0aW9uc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgIC8qKlxuICAgICAqIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXQuVGFnc2BcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQtdGFnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBDZm5Db25maWd1cmF0aW9uU2V0LlRhZ3NQcm9wZXJ0eVtdO1xuICAgIC8qKlxuICAgICAqIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXQuVHJhY2tpbmdPcHRpb25zYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0Lmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC10cmFja2luZ29wdGlvbnNcbiAgICAgKi9cbiAgICByZWFkb25seSB0cmFja2luZ09wdGlvbnM/OiBDZm5Db25maWd1cmF0aW9uU2V0LlRyYWNraW5nT3B0aW9uc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5Db25maWd1cmF0aW9uU2V0UHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkNvbmZpZ3VyYXRpb25TZXRQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0UHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7XG4gICAgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2RlbGl2ZXJ5T3B0aW9ucycsIENmbkNvbmZpZ3VyYXRpb25TZXRfRGVsaXZlcnlPcHRpb25zUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMuZGVsaXZlcnlPcHRpb25zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmVwdXRhdGlvbk9wdGlvbnMnLCBDZm5Db25maWd1cmF0aW9uU2V0X1JlcHV0YXRpb25PcHRpb25zUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMucmVwdXRhdGlvbk9wdGlvbnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NlbmRpbmdPcHRpb25zJywgQ2ZuQ29uZmlndXJhdGlvblNldF9TZW5kaW5nT3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLnNlbmRpbmdPcHRpb25zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuQ29uZmlndXJhdGlvblNldF9UYWdzUHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLnRhZ3MpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RyYWNraW5nT3B0aW9ucycsIENmbkNvbmZpZ3VyYXRpb25TZXRfVHJhY2tpbmdPcHRpb25zUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMudHJhY2tpbmdPcHRpb25zKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmbkNvbmZpZ3VyYXRpb25TZXRQcm9wc1wiJyk7XG59XG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkNvbmZpZ3VyYXRpb25TZXRQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldGAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Db25maWd1cmF0aW9uU2V0UHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgQ2ZuQ29uZmlndXJhdGlvblNldFByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5hbWUpLFxuICAgICAgICBEZWxpdmVyeU9wdGlvbnM6IGNmbkNvbmZpZ3VyYXRpb25TZXREZWxpdmVyeU9wdGlvbnNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5kZWxpdmVyeU9wdGlvbnMpLFxuICAgICAgICBSZXB1dGF0aW9uT3B0aW9uczogY2ZuQ29uZmlndXJhdGlvblNldFJlcHV0YXRpb25PcHRpb25zUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVwdXRhdGlvbk9wdGlvbnMpLFxuICAgICAgICBTZW5kaW5nT3B0aW9uczogY2ZuQ29uZmlndXJhdGlvblNldFNlbmRpbmdPcHRpb25zUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc2VuZGluZ09wdGlvbnMpLFxuICAgICAgICBUYWdzOiBjZGsubGlzdE1hcHBlcihjZm5Db25maWd1cmF0aW9uU2V0VGFnc1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICAgICAgVHJhY2tpbmdPcHRpb25zOiBjZm5Db25maWd1cmF0aW9uU2V0VHJhY2tpbmdPcHRpb25zUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudHJhY2tpbmdPcHRpb25zKSxcbiAgICB9O1xufVxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkNvbmZpZ3VyYXRpb25TZXRQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBDZm5Db25maWd1cmF0aW9uU2V0UHJvcHMge1xuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzIHx8IHt9O1xuICAgIHJldHVybiB7XG4gICAgICAgIG5hbWU6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTmFtZSksXG4gICAgICAgIGRlbGl2ZXJ5T3B0aW9uczogcHJvcGVydGllcy5EZWxpdmVyeU9wdGlvbnMgIT0gbnVsbCA/IENmbkNvbmZpZ3VyYXRpb25TZXREZWxpdmVyeU9wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkRlbGl2ZXJ5T3B0aW9ucykgOiB1bmRlZmluZWQsXG4gICAgICAgIHJlcHV0YXRpb25PcHRpb25zOiBwcm9wZXJ0aWVzLlJlcHV0YXRpb25PcHRpb25zICE9IG51bGwgPyBDZm5Db25maWd1cmF0aW9uU2V0UmVwdXRhdGlvbk9wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLlJlcHV0YXRpb25PcHRpb25zKSA6IHVuZGVmaW5lZCxcbiAgICAgICAgc2VuZGluZ09wdGlvbnM6IHByb3BlcnRpZXMuU2VuZGluZ09wdGlvbnMgIT0gbnVsbCA/IENmbkNvbmZpZ3VyYXRpb25TZXRTZW5kaW5nT3B0aW9uc1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuU2VuZGluZ09wdGlvbnMpIDogdW5kZWZpbmVkLFxuICAgICAgICB0YWdzOiBwcm9wZXJ0aWVzLlRhZ3MgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuQ29uZmlndXJhdGlvblNldFRhZ3NQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnksXG4gICAgICAgIHRyYWNraW5nT3B0aW9uczogcHJvcGVydGllcy5UcmFja2luZ09wdGlvbnMgIT0gbnVsbCA/IENmbkNvbmZpZ3VyYXRpb25TZXRUcmFja2luZ09wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLlRyYWNraW5nT3B0aW9ucykgOiB1bmRlZmluZWQsXG4gICAgfTtcbn1cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0YFxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuQ29uZmlndXJhdGlvblNldCBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRcIjtcbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiB0aGlzIHJlc291cmNlLlxuICAgICAqIFVzZWQgaW4gdGhlIEBhd3MtY2RrL2Nsb3VkZm9ybWF0aW9uLWluY2x1ZGUgbW9kdWxlLlxuICAgICAqXG4gICAgICogQGludGVybmFsXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBfZnJvbUNsb3VkRm9ybWF0aW9uKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCByZXNvdXJjZUF0dHJpYnV0ZXM6IGFueSwgb3B0aW9uczogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbk9wdGlvbnMpOiBDZm5Db25maWd1cmF0aW9uU2V0IHtcbiAgICAgICAgcmVzb3VyY2VBdHRyaWJ1dGVzID0gcmVzb3VyY2VBdHRyaWJ1dGVzIHx8IHt9O1xuICAgICAgICBjb25zdCByZXNvdXJjZVByb3BlcnRpZXMgPSBvcHRpb25zLnBhcnNlci5wYXJzZVZhbHVlKHJlc291cmNlQXR0cmlidXRlcy5Qcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcHJvcHMgPSBDZm5Db25maWd1cmF0aW9uU2V0UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkNvbmZpZ3VyYXRpb25TZXQoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldC5OYW1lYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0Lmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC1uYW1lXG4gICAgICovXG4gICAgcHVibGljIG5hbWU6IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0LkRlbGl2ZXJ5T3B0aW9uc2BcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQtZGVsaXZlcnlvcHRpb25zXG4gICAgICovXG4gICAgcHVibGljIGRlbGl2ZXJ5T3B0aW9uczogQ2ZuQ29uZmlndXJhdGlvblNldC5EZWxpdmVyeU9wdGlvbnNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcbiAgICAvKipcbiAgICAgKiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0LlJlcHV0YXRpb25PcHRpb25zYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0Lmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC1yZXB1dGF0aW9ub3B0aW9uc1xuICAgICAqL1xuICAgIHB1YmxpYyByZXB1dGF0aW9uT3B0aW9uczogQ2ZuQ29uZmlndXJhdGlvblNldC5SZXB1dGF0aW9uT3B0aW9uc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuICAgIC8qKlxuICAgICAqIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXQuU2VuZGluZ09wdGlvbnNgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0LXNlbmRpbmdvcHRpb25zXG4gICAgICovXG4gICAgcHVibGljIHNlbmRpbmdPcHRpb25zOiBDZm5Db25maWd1cmF0aW9uU2V0LlNlbmRpbmdPcHRpb25zUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldC5UYWdzYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0Lmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC10YWdzXG4gICAgICovXG4gICAgcHVibGljIHRhZ3M6IENmbkNvbmZpZ3VyYXRpb25TZXQuVGFnc1Byb3BlcnR5W10gfCB1bmRlZmluZWQ7XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldC5UcmFja2luZ09wdGlvbnNgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0LXRyYWNraW5nb3B0aW9uc1xuICAgICAqL1xuICAgIHB1YmxpYyB0cmFja2luZ09wdGlvbnM6IENmbkNvbmZpZ3VyYXRpb25TZXQuVHJhY2tpbmdPcHRpb25zUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbkNvbmZpZ3VyYXRpb25TZXRQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuQ29uZmlndXJhdGlvblNldC5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ25hbWUnLCB0aGlzKTtcbiAgICAgICAgdGhpcy5uYW1lID0gcHJvcHMubmFtZTtcbiAgICAgICAgdGhpcy5kZWxpdmVyeU9wdGlvbnMgPSBwcm9wcy5kZWxpdmVyeU9wdGlvbnM7XG4gICAgICAgIHRoaXMucmVwdXRhdGlvbk9wdGlvbnMgPSBwcm9wcy5yZXB1dGF0aW9uT3B0aW9ucztcbiAgICAgICAgdGhpcy5zZW5kaW5nT3B0aW9ucyA9IHByb3BzLnNlbmRpbmdPcHRpb25zO1xuICAgICAgICB0aGlzLnRhZ3MgPSBwcm9wcy50YWdzO1xuICAgICAgICB0aGlzLnRyYWNraW5nT3B0aW9ucyA9IHByb3BzLnRyYWNraW5nT3B0aW9ucztcbiAgICB9XG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgdGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIGFuZCBkaXNjbG9zZXMgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBpbnNwZWN0b3IgLSB0cmVlIGluc3BlY3RvciB0byBjb2xsZWN0IGFuZCBwcm9jZXNzIGF0dHJpYnV0ZXNcbiAgICAgKlxuICAgICAqIEBzdGFiaWxpdHkgZXhwZXJpbWVudGFsXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmbkNvbmZpZ3VyYXRpb25TZXQuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3RlY3RlZCBnZXQgY2ZuUHJvcGVydGllcygpOiB7XG4gICAgICAgIFtrZXk6IHN0cmluZ106IGFueTtcbiAgICB9IHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWU6IHRoaXMubmFtZSxcbiAgICAgICAgICAgIGRlbGl2ZXJ5T3B0aW9uczogdGhpcy5kZWxpdmVyeU9wdGlvbnMsXG4gICAgICAgICAgICByZXB1dGF0aW9uT3B0aW9uczogdGhpcy5yZXB1dGF0aW9uT3B0aW9ucyxcbiAgICAgICAgICAgIHNlbmRpbmdPcHRpb25zOiB0aGlzLnNlbmRpbmdPcHRpb25zLFxuICAgICAgICAgICAgdGFnczogdGhpcy50YWdzLFxuICAgICAgICAgICAgdHJhY2tpbmdPcHRpb25zOiB0aGlzLnRyYWNraW5nT3B0aW9ucyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtcbiAgICAgICAgW2tleTogc3RyaW5nXTogYW55O1xuICAgIH0pOiB7XG4gICAgICAgIFtrZXk6IHN0cmluZ106IGFueTtcbiAgICB9IHtcbiAgICAgICAgcmV0dXJuIGNmbkNvbmZpZ3VyYXRpb25TZXRQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcHMpO1xuICAgIH1cbn1cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuQ29uZmlndXJhdGlvblNldCB7XG4gICAgLyoqXG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQtZGVsaXZlcnlvcHRpb25zLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIERlbGl2ZXJ5T3B0aW9uc1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIGBDZm5Db25maWd1cmF0aW9uU2V0LkRlbGl2ZXJ5T3B0aW9uc1Byb3BlcnR5LlNlbmRpbmdQb29sTmFtZWBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC1kZWxpdmVyeW9wdGlvbnMuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0LWRlbGl2ZXJ5b3B0aW9ucy1zZW5kaW5ncG9vbG5hbWVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHNlbmRpbmdQb29sTmFtZT86IHN0cmluZztcbiAgICB9XG59XG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYERlbGl2ZXJ5T3B0aW9uc1Byb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBEZWxpdmVyeU9wdGlvbnNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0X0RlbGl2ZXJ5T3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTO1xuICAgIH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzZW5kaW5nUG9vbE5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc2VuZGluZ1Bvb2xOYW1lKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkRlbGl2ZXJ5T3B0aW9uc1Byb3BlcnR5XCInKTtcbn1cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldC5EZWxpdmVyeU9wdGlvbnNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYERlbGl2ZXJ5T3B0aW9uc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0LkRlbGl2ZXJ5T3B0aW9uc2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Db25maWd1cmF0aW9uU2V0RGVsaXZlcnlPcHRpb25zUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgQ2ZuQ29uZmlndXJhdGlvblNldF9EZWxpdmVyeU9wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgU2VuZGluZ1Bvb2xOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnNlbmRpbmdQb29sTmFtZSksXG4gICAgfTtcbn1cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0RGVsaXZlcnlPcHRpb25zUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogQ2ZuQ29uZmlndXJhdGlvblNldC5EZWxpdmVyeU9wdGlvbnNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIHByb3BlcnRpZXM7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzIHx8IHt9O1xuICAgIHJldHVybiB7XG4gICAgICAgIHNlbmRpbmdQb29sTmFtZTogcHJvcGVydGllcy5TZW5kaW5nUG9vbE5hbWUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU2VuZGluZ1Bvb2xOYW1lKSA6IHVuZGVmaW5lZCxcbiAgICB9O1xufVxuZXhwb3J0IG5hbWVzcGFjZSBDZm5Db25maWd1cmF0aW9uU2V0IHtcbiAgICAvKipcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC1yZXB1dGF0aW9ub3B0aW9ucy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBSZXB1dGF0aW9uT3B0aW9uc1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIGBDZm5Db25maWd1cmF0aW9uU2V0LlJlcHV0YXRpb25PcHRpb25zUHJvcGVydHkuUmVwdXRhdGlvbk1ldHJpY3NFbmFibGVkYFxuICAgICAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0LXJlcHV0YXRpb25vcHRpb25zLmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC1yZXB1dGF0aW9ub3B0aW9ucy1yZXB1dGF0aW9ubWV0cmljc2VuYWJsZWRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHJlcHV0YXRpb25NZXRyaWNzRW5hYmxlZD86IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGU7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBSZXB1dGF0aW9uT3B0aW9uc1Byb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSZXB1dGF0aW9uT3B0aW9uc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkNvbmZpZ3VyYXRpb25TZXRfUmVwdXRhdGlvbk9wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUztcbiAgICB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmVwdXRhdGlvbk1ldHJpY3NFbmFibGVkJywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5yZXB1dGF0aW9uTWV0cmljc0VuYWJsZWQpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiUmVwdXRhdGlvbk9wdGlvbnNQcm9wZXJ0eVwiJyk7XG59XG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXQuUmVwdXRhdGlvbk9wdGlvbnNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFJlcHV0YXRpb25PcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXQuUmVwdXRhdGlvbk9wdGlvbnNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQ29uZmlndXJhdGlvblNldFJlcHV0YXRpb25PcHRpb25zUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgQ2ZuQ29uZmlndXJhdGlvblNldF9SZXB1dGF0aW9uT3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBSZXB1dGF0aW9uTWV0cmljc0VuYWJsZWQ6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnJlcHV0YXRpb25NZXRyaWNzRW5hYmxlZCksXG4gICAgfTtcbn1cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0UmVwdXRhdGlvbk9wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBDZm5Db25maWd1cmF0aW9uU2V0LlJlcHV0YXRpb25PcHRpb25zUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBwcm9wZXJ0aWVzO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyB8fCB7fTtcbiAgICByZXR1cm4ge1xuICAgICAgICByZXB1dGF0aW9uTWV0cmljc0VuYWJsZWQ6IHByb3BlcnRpZXMuUmVwdXRhdGlvbk1ldHJpY3NFbmFibGVkICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5SZXB1dGF0aW9uTWV0cmljc0VuYWJsZWQpIDogdW5kZWZpbmVkLFxuICAgIH07XG59XG5leHBvcnQgbmFtZXNwYWNlIENmbkNvbmZpZ3VyYXRpb25TZXQge1xuICAgIC8qKlxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0LXNlbmRpbmdvcHRpb25zLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFNlbmRpbmdPcHRpb25zUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogYENmbkNvbmZpZ3VyYXRpb25TZXQuU2VuZGluZ09wdGlvbnNQcm9wZXJ0eS5TZW5kaW5nRW5hYmxlZGBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC1zZW5kaW5nb3B0aW9ucy5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQtc2VuZGluZ29wdGlvbnMtc2VuZGluZ2VuYWJsZWRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHNlbmRpbmdFbmFibGVkPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICB9XG59XG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFNlbmRpbmdPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFNlbmRpbmdPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQ29uZmlndXJhdGlvblNldF9TZW5kaW5nT3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTO1xuICAgIH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzZW5kaW5nRW5hYmxlZCcsIGNkay52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuc2VuZGluZ0VuYWJsZWQpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiU2VuZGluZ09wdGlvbnNQcm9wZXJ0eVwiJyk7XG59XG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXQuU2VuZGluZ09wdGlvbnNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFNlbmRpbmdPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXQuU2VuZGluZ09wdGlvbnNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQ29uZmlndXJhdGlvblNldFNlbmRpbmdPcHRpb25zUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgQ2ZuQ29uZmlndXJhdGlvblNldF9TZW5kaW5nT3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBTZW5kaW5nRW5hYmxlZDogY2RrLmJvb2xlYW5Ub0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc2VuZGluZ0VuYWJsZWQpLFxuICAgIH07XG59XG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQ29uZmlndXJhdGlvblNldFNlbmRpbmdPcHRpb25zUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogQ2ZuQ29uZmlndXJhdGlvblNldC5TZW5kaW5nT3B0aW9uc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlIHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgfHwge307XG4gICAgcmV0dXJuIHtcbiAgICAgICAgc2VuZGluZ0VuYWJsZWQ6IHByb3BlcnRpZXMuU2VuZGluZ0VuYWJsZWQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0Qm9vbGVhbihwcm9wZXJ0aWVzLlNlbmRpbmdFbmFibGVkKSA6IHVuZGVmaW5lZCxcbiAgICB9O1xufVxuZXhwb3J0IG5hbWVzcGFjZSBDZm5Db25maWd1cmF0aW9uU2V0IHtcbiAgICAvKipcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC10YWdzLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFRhZ3NQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBgQ2ZuQ29uZmlndXJhdGlvblNldC5UYWdzUHJvcGVydHkuS2V5YFxuICAgICAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0LXRhZ3MuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0LXRhZ3Mta2V5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBrZXk/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBgQ2ZuQ29uZmlndXJhdGlvblNldC5UYWdzUHJvcGVydHkuVmFsdWVgXG4gICAgICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQtdGFncy5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXQtdGFncy12YWx1ZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdmFsdWU/OiBzdHJpbmc7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBUYWdzUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFRhZ3NQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0X1RhZ3NQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUztcbiAgICB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2V5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmtleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndmFsdWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudmFsdWUpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiVGFnc1Byb3BlcnR5XCInKTtcbn1cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldC5UYWdzYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBUYWdzUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXQuVGFnc2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Db25maWd1cmF0aW9uU2V0VGFnc1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIHByb3BlcnRpZXM7XG4gICAgfVxuICAgIENmbkNvbmZpZ3VyYXRpb25TZXRfVGFnc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBLZXk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMua2V5KSxcbiAgICAgICAgVmFsdWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudmFsdWUpLFxuICAgIH07XG59XG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQ29uZmlndXJhdGlvblNldFRhZ3NQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBDZm5Db25maWd1cmF0aW9uU2V0LlRhZ3NQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIHByb3BlcnRpZXM7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzIHx8IHt9O1xuICAgIHJldHVybiB7XG4gICAgICAgIGtleTogcHJvcGVydGllcy5LZXkgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuS2V5KSA6IHVuZGVmaW5lZCxcbiAgICAgICAgdmFsdWU6IHByb3BlcnRpZXMuVmFsdWUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuVmFsdWUpIDogdW5kZWZpbmVkLFxuICAgIH07XG59XG5leHBvcnQgbmFtZXNwYWNlIENmbkNvbmZpZ3VyYXRpb25TZXQge1xuICAgIC8qKlxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0LXRyYWNraW5nb3B0aW9ucy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBUcmFja2luZ09wdGlvbnNQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBgQ2ZuQ29uZmlndXJhdGlvblNldC5UcmFja2luZ09wdGlvbnNQcm9wZXJ0eS5DdXN0b21SZWRpcmVjdERvbWFpbmBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldC10cmFja2luZ29wdGlvbnMuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0LXRyYWNraW5nb3B0aW9ucy1jdXN0b21yZWRpcmVjdGRvbWFpblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgY3VzdG9tUmVkaXJlY3REb21haW4/OiBzdHJpbmc7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBUcmFja2luZ09wdGlvbnNQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgVHJhY2tpbmdPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQ29uZmlndXJhdGlvblNldF9UcmFja2luZ09wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUztcbiAgICB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY3VzdG9tUmVkaXJlY3REb21haW4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuY3VzdG9tUmVkaXJlY3REb21haW4pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiVHJhY2tpbmdPcHRpb25zUHJvcGVydHlcIicpO1xufVxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0LlRyYWNraW5nT3B0aW9uc2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgVHJhY2tpbmdPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXQuVHJhY2tpbmdPcHRpb25zYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkNvbmZpZ3VyYXRpb25TZXRUcmFja2luZ09wdGlvbnNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBwcm9wZXJ0aWVzO1xuICAgIH1cbiAgICBDZm5Db25maWd1cmF0aW9uU2V0X1RyYWNraW5nT3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBDdXN0b21SZWRpcmVjdERvbWFpbjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5jdXN0b21SZWRpcmVjdERvbWFpbiksXG4gICAgfTtcbn1cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0VHJhY2tpbmdPcHRpb25zUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogQ2ZuQ29uZmlndXJhdGlvblNldC5UcmFja2luZ09wdGlvbnNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIHByb3BlcnRpZXM7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzIHx8IHt9O1xuICAgIHJldHVybiB7XG4gICAgICAgIGN1c3RvbVJlZGlyZWN0RG9tYWluOiBwcm9wZXJ0aWVzLkN1c3RvbVJlZGlyZWN0RG9tYWluICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkN1c3RvbVJlZGlyZWN0RG9tYWluKSA6IHVuZGVmaW5lZCxcbiAgICB9O1xufVxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uYFxuICpcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25Qcm9wcyB7XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uQ29uZmlndXJhdGlvblNldE5hbWVgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tY29uZmlndXJhdGlvbnNldG5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBjb25maWd1cmF0aW9uU2V0TmFtZTogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLkV2ZW50RGVzdGluYXRpb25OYW1lYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWV2ZW50ZGVzdGluYXRpb25uYW1lXG4gICAgICovXG4gICAgcmVhZG9ubHkgZXZlbnREZXN0aW5hdGlvbk5hbWU6IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5FdmVudERlc3RpbmF0aW9uYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWV2ZW50ZGVzdGluYXRpb25cbiAgICAgKi9cbiAgICByZWFkb25seSBldmVudERlc3RpbmF0aW9uPzogQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uRXZlbnREZXN0aW5hdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvblByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvblByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7XG4gICAgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2NvbmZpZ3VyYXRpb25TZXROYW1lJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmNvbmZpZ3VyYXRpb25TZXROYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdjb25maWd1cmF0aW9uU2V0TmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jb25maWd1cmF0aW9uU2V0TmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZXZlbnREZXN0aW5hdGlvbicsIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uX0V2ZW50RGVzdGluYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5ldmVudERlc3RpbmF0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdldmVudERlc3RpbmF0aW9uTmFtZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5ldmVudERlc3RpbmF0aW9uTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZXZlbnREZXN0aW5hdGlvbk5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZXZlbnREZXN0aW5hdGlvbk5hbWUpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25Qcm9wc1wiJyk7XG59XG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvblByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvblByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIHByb3BlcnRpZXM7XG4gICAgfVxuICAgIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIENvbmZpZ3VyYXRpb25TZXROYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmNvbmZpZ3VyYXRpb25TZXROYW1lKSxcbiAgICAgICAgRXZlbnREZXN0aW5hdGlvbk5hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZXZlbnREZXN0aW5hdGlvbk5hbWUpLFxuICAgICAgICBFdmVudERlc3RpbmF0aW9uOiBjZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbkV2ZW50RGVzdGluYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5ldmVudERlc3RpbmF0aW9uKSxcbiAgICB9O1xufVxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25Qcm9wcyB7XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgfHwge307XG4gICAgcmV0dXJuIHtcbiAgICAgICAgY29uZmlndXJhdGlvblNldE5hbWU6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQ29uZmlndXJhdGlvblNldE5hbWUpLFxuICAgICAgICBldmVudERlc3RpbmF0aW9uTmFtZTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5FdmVudERlc3RpbmF0aW9uTmFtZSksXG4gICAgICAgIGV2ZW50RGVzdGluYXRpb246IHByb3BlcnRpZXMuRXZlbnREZXN0aW5hdGlvbiAhPSBudWxsID8gQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25FdmVudERlc3RpbmF0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5FdmVudERlc3RpbmF0aW9uKSA6IHVuZGVmaW5lZCxcbiAgICB9O1xufVxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uYFxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25cbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbiBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uXCI7XG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24ge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wcyA9IENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uKHNjb3BlLCBpZCwgcHJvcHMpO1xuICAgICAgICBvcHRpb25zLnBhcnNlci5oYW5kbGVBdHRyaWJ1dGVzKHJldCwgcmVzb3VyY2VBdHRyaWJ1dGVzLCBpZCk7XG4gICAgICAgIHJldHVybiByZXQ7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLkNvbmZpZ3VyYXRpb25TZXROYW1lYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWNvbmZpZ3VyYXRpb25zZXRuYW1lXG4gICAgICovXG4gICAgcHVibGljIGNvbmZpZ3VyYXRpb25TZXROYW1lOiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uRXZlbnREZXN0aW5hdGlvbk5hbWVgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tZXZlbnRkZXN0aW5hdGlvbm5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgZXZlbnREZXN0aW5hdGlvbk5hbWU6IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5FdmVudERlc3RpbmF0aW9uYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWV2ZW50ZGVzdGluYXRpb25cbiAgICAgKi9cbiAgICBwdWJsaWMgZXZlbnREZXN0aW5hdGlvbjogQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uRXZlbnREZXN0aW5hdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbmAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25Qcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdjb25maWd1cmF0aW9uU2V0TmFtZScsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnZXZlbnREZXN0aW5hdGlvbk5hbWUnLCB0aGlzKTtcbiAgICAgICAgdGhpcy5jb25maWd1cmF0aW9uU2V0TmFtZSA9IHByb3BzLmNvbmZpZ3VyYXRpb25TZXROYW1lO1xuICAgICAgICB0aGlzLmV2ZW50RGVzdGluYXRpb25OYW1lID0gcHJvcHMuZXZlbnREZXN0aW5hdGlvbk5hbWU7XG4gICAgICAgIHRoaXMuZXZlbnREZXN0aW5hdGlvbiA9IHByb3BzLmV2ZW50RGVzdGluYXRpb247XG4gICAgfVxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKiBAc3RhYmlsaXR5IGV4cGVyaW1lbnRhbFxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHtcbiAgICAgICAgW2tleTogc3RyaW5nXTogYW55O1xuICAgIH0ge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgY29uZmlndXJhdGlvblNldE5hbWU6IHRoaXMuY29uZmlndXJhdGlvblNldE5hbWUsXG4gICAgICAgICAgICBldmVudERlc3RpbmF0aW9uTmFtZTogdGhpcy5ldmVudERlc3RpbmF0aW9uTmFtZSxcbiAgICAgICAgICAgIGV2ZW50RGVzdGluYXRpb246IHRoaXMuZXZlbnREZXN0aW5hdGlvbixcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtcbiAgICAgICAgW2tleTogc3RyaW5nXTogYW55O1xuICAgIH0pOiB7XG4gICAgICAgIFtrZXk6IHN0cmluZ106IGFueTtcbiAgICB9IHtcbiAgICAgICAgcmV0dXJuIGNmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5leHBvcnQgbmFtZXNwYWNlIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uIHtcbiAgICAvKipcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tY2xvdWR3YXRjaGRlc3RpbmF0aW9uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIENsb3VkV2F0Y2hEZXN0aW5hdGlvblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIGBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5DbG91ZFdhdGNoRGVzdGluYXRpb25Qcm9wZXJ0eS5EaW1lbnNpb25Db25maWd1cmF0aW9uc2BcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tY2xvdWR3YXRjaGRlc3RpbmF0aW9uLmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tY2xvdWR3YXRjaGRlc3RpbmF0aW9uLWRpbWVuc2lvbmNvbmZpZ3VyYXRpb25zXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBkaW1lbnNpb25Db25maWd1cmF0aW9ucz86IEFycmF5PENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLkRpbWVuc2lvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDbG91ZFdhdGNoRGVzdGluYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2xvdWRXYXRjaERlc3RpbmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25fQ2xvdWRXYXRjaERlc3RpbmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7XG4gICAgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2RpbWVuc2lvbkNvbmZpZ3VyYXRpb25zJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25fRGltZW5zaW9uQ29uZmlndXJhdGlvblByb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy5kaW1lbnNpb25Db25maWd1cmF0aW9ucykpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDbG91ZFdhdGNoRGVzdGluYXRpb25Qcm9wZXJ0eVwiJyk7XG59XG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLkNsb3VkV2F0Y2hEZXN0aW5hdGlvbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2xvdWRXYXRjaERlc3RpbmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLkNsb3VkV2F0Y2hEZXN0aW5hdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbkNsb3VkV2F0Y2hEZXN0aW5hdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIHByb3BlcnRpZXM7XG4gICAgfVxuICAgIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uX0Nsb3VkV2F0Y2hEZXN0aW5hdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBEaW1lbnNpb25Db25maWd1cmF0aW9uczogY2RrLmxpc3RNYXBwZXIoY2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25EaW1lbnNpb25Db25maWd1cmF0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLmRpbWVuc2lvbkNvbmZpZ3VyYXRpb25zKSxcbiAgICB9O1xufVxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uQ2xvdWRXYXRjaERlc3RpbmF0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uQ2xvdWRXYXRjaERlc3RpbmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBwcm9wZXJ0aWVzO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyB8fCB7fTtcbiAgICByZXR1cm4ge1xuICAgICAgICBkaW1lbnNpb25Db25maWd1cmF0aW9uczogcHJvcGVydGllcy5EaW1lbnNpb25Db25maWd1cmF0aW9ucyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbkRpbWVuc2lvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5EaW1lbnNpb25Db25maWd1cmF0aW9ucykgOiB1bmRlZmluZWQsXG4gICAgfTtcbn1cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24ge1xuICAgIC8qKlxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi1kaW1lbnNpb25jb25maWd1cmF0aW9uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIERpbWVuc2lvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBgQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uRGltZW5zaW9uQ29uZmlndXJhdGlvblByb3BlcnR5LkRlZmF1bHREaW1lbnNpb25WYWx1ZWBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tZGltZW5zaW9uY29uZmlndXJhdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWRpbWVuc2lvbmNvbmZpZ3VyYXRpb24tZGVmYXVsdGRpbWVuc2lvbnZhbHVlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBkZWZhdWx0RGltZW5zaW9uVmFsdWU6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIGBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5EaW1lbnNpb25Db25maWd1cmF0aW9uUHJvcGVydHkuRGltZW5zaW9uTmFtZWBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tZGltZW5zaW9uY29uZmlndXJhdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWRpbWVuc2lvbmNvbmZpZ3VyYXRpb24tZGltZW5zaW9ubmFtZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZGltZW5zaW9uTmFtZTogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogYENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLkRpbWVuc2lvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eS5EaW1lbnNpb25WYWx1ZVNvdXJjZWBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tZGltZW5zaW9uY29uZmlndXJhdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWRpbWVuc2lvbmNvbmZpZ3VyYXRpb24tZGltZW5zaW9udmFsdWVzb3VyY2VcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGRpbWVuc2lvblZhbHVlU291cmNlOiBzdHJpbmc7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBEaW1lbnNpb25Db25maWd1cmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYERpbWVuc2lvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbl9EaW1lbnNpb25Db25maWd1cmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7XG4gICAgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2RlZmF1bHREaW1lbnNpb25WYWx1ZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5kZWZhdWx0RGltZW5zaW9uVmFsdWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2RlZmF1bHREaW1lbnNpb25WYWx1ZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kZWZhdWx0RGltZW5zaW9uVmFsdWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2RpbWVuc2lvbk5hbWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuZGltZW5zaW9uTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGltZW5zaW9uTmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kaW1lbnNpb25OYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkaW1lbnNpb25WYWx1ZVNvdXJjZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5kaW1lbnNpb25WYWx1ZVNvdXJjZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGltZW5zaW9uVmFsdWVTb3VyY2UnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGltZW5zaW9uVmFsdWVTb3VyY2UpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiRGltZW5zaW9uQ29uZmlndXJhdGlvblByb3BlcnR5XCInKTtcbn1cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uRGltZW5zaW9uQ29uZmlndXJhdGlvbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgRGltZW5zaW9uQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5EaW1lbnNpb25Db25maWd1cmF0aW9uYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uRGltZW5zaW9uQ29uZmlndXJhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIHByb3BlcnRpZXM7XG4gICAgfVxuICAgIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uX0RpbWVuc2lvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgRGVmYXVsdERpbWVuc2lvblZhbHVlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRlZmF1bHREaW1lbnNpb25WYWx1ZSksXG4gICAgICAgIERpbWVuc2lvbk5hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGltZW5zaW9uTmFtZSksXG4gICAgICAgIERpbWVuc2lvblZhbHVlU291cmNlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRpbWVuc2lvblZhbHVlU291cmNlKSxcbiAgICB9O1xufVxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uRGltZW5zaW9uQ29uZmlndXJhdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLkRpbWVuc2lvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIHByb3BlcnRpZXM7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzIHx8IHt9O1xuICAgIHJldHVybiB7XG4gICAgICAgIGRlZmF1bHREaW1lbnNpb25WYWx1ZTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5EZWZhdWx0RGltZW5zaW9uVmFsdWUpLFxuICAgICAgICBkaW1lbnNpb25OYW1lOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkRpbWVuc2lvbk5hbWUpLFxuICAgICAgICBkaW1lbnNpb25WYWx1ZVNvdXJjZTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5EaW1lbnNpb25WYWx1ZVNvdXJjZSksXG4gICAgfTtcbn1cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24ge1xuICAgIC8qKlxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi1ldmVudGRlc3RpbmF0aW9uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIEV2ZW50RGVzdGluYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBgQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uRXZlbnREZXN0aW5hdGlvblByb3BlcnR5LkNsb3VkV2F0Y2hEZXN0aW5hdGlvbmBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tZXZlbnRkZXN0aW5hdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWV2ZW50ZGVzdGluYXRpb24tY2xvdWR3YXRjaGRlc3RpbmF0aW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBjbG91ZFdhdGNoRGVzdGluYXRpb24/OiBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5DbG91ZFdhdGNoRGVzdGluYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIGBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5FdmVudERlc3RpbmF0aW9uUHJvcGVydHkuRW5hYmxlZGBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tZXZlbnRkZXN0aW5hdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWV2ZW50ZGVzdGluYXRpb24tZW5hYmxlZFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZW5hYmxlZD86IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBgQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uRXZlbnREZXN0aW5hdGlvblByb3BlcnR5LktpbmVzaXNGaXJlaG9zZURlc3RpbmF0aW9uYFxuICAgICAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi1ldmVudGRlc3RpbmF0aW9uLmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tZXZlbnRkZXN0aW5hdGlvbi1raW5lc2lzZmlyZWhvc2VkZXN0aW5hdGlvblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkga2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb24/OiBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5LaW5lc2lzRmlyZWhvc2VEZXN0aW5hdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogYENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLkV2ZW50RGVzdGluYXRpb25Qcm9wZXJ0eS5NYXRjaGluZ0V2ZW50VHlwZXNgXG4gICAgICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWV2ZW50ZGVzdGluYXRpb24uaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi1ldmVudGRlc3RpbmF0aW9uLW1hdGNoaW5nZXZlbnR0eXBlc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWF0Y2hpbmdFdmVudFR5cGVzOiBzdHJpbmdbXTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIGBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5FdmVudERlc3RpbmF0aW9uUHJvcGVydHkuUGlucG9pbnREZXN0aW5hdGlvbmBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tZXZlbnRkZXN0aW5hdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWV2ZW50ZGVzdGluYXRpb24tcGlucG9pbnRkZXN0aW5hdGlvblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgcGlucG9pbnREZXN0aW5hdGlvbj86IENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLlBpbnBvaW50RGVzdGluYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIGBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5FdmVudERlc3RpbmF0aW9uUHJvcGVydHkuU25zRGVzdGluYXRpb25gXG4gICAgICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWV2ZW50ZGVzdGluYXRpb24uaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi1ldmVudGRlc3RpbmF0aW9uLXNuc2Rlc3RpbmF0aW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzbnNEZXN0aW5hdGlvbj86IENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLlNuc0Rlc3RpbmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBFdmVudERlc3RpbmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEV2ZW50RGVzdGluYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbl9FdmVudERlc3RpbmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7XG4gICAgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2Nsb3VkV2F0Y2hEZXN0aW5hdGlvbicsIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uX0Nsb3VkV2F0Y2hEZXN0aW5hdGlvblByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmNsb3VkV2F0Y2hEZXN0aW5hdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZW5hYmxlZCcsIGNkay52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuZW5hYmxlZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb24nLCBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbl9LaW5lc2lzRmlyZWhvc2VEZXN0aW5hdGlvblByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmtpbmVzaXNGaXJlaG9zZURlc3RpbmF0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtYXRjaGluZ0V2ZW50VHlwZXMnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubWF0Y2hpbmdFdmVudFR5cGVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtYXRjaGluZ0V2ZW50VHlwZXMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLm1hdGNoaW5nRXZlbnRUeXBlcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncGlucG9pbnREZXN0aW5hdGlvbicsIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uX1BpbnBvaW50RGVzdGluYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5waW5wb2ludERlc3RpbmF0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzbnNEZXN0aW5hdGlvbicsIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uX1Nuc0Rlc3RpbmF0aW9uUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMuc25zRGVzdGluYXRpb24pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiRXZlbnREZXN0aW5hdGlvblByb3BlcnR5XCInKTtcbn1cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uRXZlbnREZXN0aW5hdGlvbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgRXZlbnREZXN0aW5hdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5FdmVudERlc3RpbmF0aW9uYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uRXZlbnREZXN0aW5hdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIHByb3BlcnRpZXM7XG4gICAgfVxuICAgIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uX0V2ZW50RGVzdGluYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgQ2xvdWRXYXRjaERlc3RpbmF0aW9uOiBjZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbkNsb3VkV2F0Y2hEZXN0aW5hdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmNsb3VkV2F0Y2hEZXN0aW5hdGlvbiksXG4gICAgICAgIEVuYWJsZWQ6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmVuYWJsZWQpLFxuICAgICAgICBLaW5lc2lzRmlyZWhvc2VEZXN0aW5hdGlvbjogY2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25LaW5lc2lzRmlyZWhvc2VEZXN0aW5hdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmtpbmVzaXNGaXJlaG9zZURlc3RpbmF0aW9uKSxcbiAgICAgICAgTWF0Y2hpbmdFdmVudFR5cGVzOiBjZGsubGlzdE1hcHBlcihjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5tYXRjaGluZ0V2ZW50VHlwZXMpLFxuICAgICAgICBQaW5wb2ludERlc3RpbmF0aW9uOiBjZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvblBpbnBvaW50RGVzdGluYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5waW5wb2ludERlc3RpbmF0aW9uKSxcbiAgICAgICAgU25zRGVzdGluYXRpb246IGNmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uU25zRGVzdGluYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zbnNEZXN0aW5hdGlvbiksXG4gICAgfTtcbn1cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbkV2ZW50RGVzdGluYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5FdmVudERlc3RpbmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBwcm9wZXJ0aWVzO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyB8fCB7fTtcbiAgICByZXR1cm4ge1xuICAgICAgICBjbG91ZFdhdGNoRGVzdGluYXRpb246IHByb3BlcnRpZXMuQ2xvdWRXYXRjaERlc3RpbmF0aW9uICE9IG51bGwgPyBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbkNsb3VkV2F0Y2hEZXN0aW5hdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuQ2xvdWRXYXRjaERlc3RpbmF0aW9uKSA6IHVuZGVmaW5lZCxcbiAgICAgICAgZW5hYmxlZDogcHJvcGVydGllcy5FbmFibGVkICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5FbmFibGVkKSA6IHVuZGVmaW5lZCxcbiAgICAgICAga2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb246IHByb3BlcnRpZXMuS2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb24gIT0gbnVsbCA/IENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uS2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLktpbmVzaXNGaXJlaG9zZURlc3RpbmF0aW9uKSA6IHVuZGVmaW5lZCxcbiAgICAgICAgbWF0Y2hpbmdFdmVudFR5cGVzOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZ0FycmF5KHByb3BlcnRpZXMuTWF0Y2hpbmdFdmVudFR5cGVzKSxcbiAgICAgICAgcGlucG9pbnREZXN0aW5hdGlvbjogcHJvcGVydGllcy5QaW5wb2ludERlc3RpbmF0aW9uICE9IG51bGwgPyBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvblBpbnBvaW50RGVzdGluYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLlBpbnBvaW50RGVzdGluYXRpb24pIDogdW5kZWZpbmVkLFxuICAgICAgICBzbnNEZXN0aW5hdGlvbjogcHJvcGVydGllcy5TbnNEZXN0aW5hdGlvbiAhPSBudWxsID8gQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25TbnNEZXN0aW5hdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuU25zRGVzdGluYXRpb24pIDogdW5kZWZpbmVkLFxuICAgIH07XG59XG5leHBvcnQgbmFtZXNwYWNlIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uIHtcbiAgICAvKipcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24ta2luZXNpc2ZpcmVob3NlZGVzdGluYXRpb24uaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBgQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uS2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb25Qcm9wZXJ0eS5EZWxpdmVyeVN0cmVhbUFybmBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24ta2luZXNpc2ZpcmVob3NlZGVzdGluYXRpb24uaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi1raW5lc2lzZmlyZWhvc2VkZXN0aW5hdGlvbi1kZWxpdmVyeXN0cmVhbWFyblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZGVsaXZlcnlTdHJlYW1Bcm46IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIGBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5LaW5lc2lzRmlyZWhvc2VEZXN0aW5hdGlvblByb3BlcnR5LklhbVJvbGVBcm5gXG4gICAgICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLWtpbmVzaXNmaXJlaG9zZWRlc3RpbmF0aW9uLmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24ta2luZXNpc2ZpcmVob3NlZGVzdGluYXRpb24taWFtcm9sZWFyblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgaWFtUm9sZUFybjogc3RyaW5nO1xuICAgIH1cbn1cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgS2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgS2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbl9LaW5lc2lzRmlyZWhvc2VEZXN0aW5hdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTO1xuICAgIH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkZWxpdmVyeVN0cmVhbUFybicsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5kZWxpdmVyeVN0cmVhbUFybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVsaXZlcnlTdHJlYW1Bcm4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGVsaXZlcnlTdHJlYW1Bcm4pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2lhbVJvbGVBcm4nLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuaWFtUm9sZUFybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignaWFtUm9sZUFybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5pYW1Sb2xlQXJuKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIktpbmVzaXNGaXJlaG9zZURlc3RpbmF0aW9uUHJvcGVydHlcIicpO1xufVxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5LaW5lc2lzRmlyZWhvc2VEZXN0aW5hdGlvbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgS2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6UGlucG9pbnRFbWFpbDo6Q29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24uS2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25LaW5lc2lzRmlyZWhvc2VEZXN0aW5hdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIHByb3BlcnRpZXM7XG4gICAgfVxuICAgIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uX0tpbmVzaXNGaXJlaG9zZURlc3RpbmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIERlbGl2ZXJ5U3RyZWFtQXJuOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRlbGl2ZXJ5U3RyZWFtQXJuKSxcbiAgICAgICAgSWFtUm9sZUFybjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5pYW1Sb2xlQXJuKSxcbiAgICB9O1xufVxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uS2luZXNpc0ZpcmVob3NlRGVzdGluYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5LaW5lc2lzRmlyZWhvc2VEZXN0aW5hdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlIHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgfHwge307XG4gICAgcmV0dXJuIHtcbiAgICAgICAgZGVsaXZlcnlTdHJlYW1Bcm46IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRGVsaXZlcnlTdHJlYW1Bcm4pLFxuICAgICAgICBpYW1Sb2xlQXJuOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLklhbVJvbGVBcm4pLFxuICAgIH07XG59XG5leHBvcnQgbmFtZXNwYWNlIENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uIHtcbiAgICAvKipcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tcGlucG9pbnRkZXN0aW5hdGlvbi5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBQaW5wb2ludERlc3RpbmF0aW9uUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogYENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLlBpbnBvaW50RGVzdGluYXRpb25Qcm9wZXJ0eS5BcHBsaWNhdGlvbkFybmBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtY29uZmlndXJhdGlvbnNldGV2ZW50ZGVzdGluYXRpb24tcGlucG9pbnRkZXN0aW5hdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLXBpbnBvaW50ZGVzdGluYXRpb24tYXBwbGljYXRpb25hcm5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGFwcGxpY2F0aW9uQXJuPzogc3RyaW5nO1xuICAgIH1cbn1cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUGlucG9pbnREZXN0aW5hdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQaW5wb2ludERlc3RpbmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25fUGlucG9pbnREZXN0aW5hdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTO1xuICAgIH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhcHBsaWNhdGlvbkFybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5hcHBsaWNhdGlvbkFybikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJQaW5wb2ludERlc3RpbmF0aW9uUHJvcGVydHlcIicpO1xufVxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5QaW5wb2ludERlc3RpbmF0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQaW5wb2ludERlc3RpbmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLlBpbnBvaW50RGVzdGluYXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25QaW5wb2ludERlc3RpbmF0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25fUGlucG9pbnREZXN0aW5hdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBBcHBsaWNhdGlvbkFybjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5hcHBsaWNhdGlvbkFybiksXG4gICAgfTtcbn1cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvblBpbnBvaW50RGVzdGluYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5QaW5wb2ludERlc3RpbmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBwcm9wZXJ0aWVzO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyB8fCB7fTtcbiAgICByZXR1cm4ge1xuICAgICAgICBhcHBsaWNhdGlvbkFybjogcHJvcGVydGllcy5BcHBsaWNhdGlvbkFybiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5BcHBsaWNhdGlvbkFybikgOiB1bmRlZmluZWQsXG4gICAgfTtcbn1cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb24ge1xuICAgIC8qKlxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi1zbnNkZXN0aW5hdGlvbi5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBTbnNEZXN0aW5hdGlvblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIGBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5TbnNEZXN0aW5hdGlvblByb3BlcnR5LlRvcGljQXJuYFxuICAgICAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcGlucG9pbnRlbWFpbC1jb25maWd1cmF0aW9uc2V0ZXZlbnRkZXN0aW5hdGlvbi1zbnNkZXN0aW5hdGlvbi5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWNvbmZpZ3VyYXRpb25zZXRldmVudGRlc3RpbmF0aW9uLXNuc2Rlc3RpbmF0aW9uLXRvcGljYXJuXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB0b3BpY0Fybjogc3RyaW5nO1xuICAgIH1cbn1cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgU25zRGVzdGluYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgU25zRGVzdGluYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbl9TbnNEZXN0aW5hdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTO1xuICAgIH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0b3BpY0FybicsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy50b3BpY0FybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndG9waWNBcm4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudG9waWNBcm4pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiU25zRGVzdGluYXRpb25Qcm9wZXJ0eVwiJyk7XG59XG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLlNuc0Rlc3RpbmF0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBTbnNEZXN0aW5hdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpDb25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvbi5TbnNEZXN0aW5hdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Db25maWd1cmF0aW9uU2V0RXZlbnREZXN0aW5hdGlvblNuc0Rlc3RpbmF0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25fU25zRGVzdGluYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgVG9waWNBcm46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudG9waWNBcm4pLFxuICAgIH07XG59XG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQ29uZmlndXJhdGlvblNldEV2ZW50RGVzdGluYXRpb25TbnNEZXN0aW5hdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IENmbkNvbmZpZ3VyYXRpb25TZXRFdmVudERlc3RpbmF0aW9uLlNuc0Rlc3RpbmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBwcm9wZXJ0aWVzO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyB8fCB7fTtcbiAgICByZXR1cm4ge1xuICAgICAgICB0b3BpY0FybjogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Ub3BpY0FybiksXG4gICAgfTtcbn1cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQVdTOjpQaW5wb2ludEVtYWlsOjpEZWRpY2F0ZWRJcFBvb2xgXG4gKlxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWRlZGljYXRlZGlwcG9vbC5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuRGVkaWNhdGVkSXBQb29sUHJvcHMge1xuICAgIC8qKlxuICAgICAqIGBBV1M6OlBpbnBvaW50RW1haWw6OkRlZGljYXRlZElwUG9vbC5Qb29sTmFtZWBcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXBpbnBvaW50ZW1haWwtZGVkaWNhdGVkaXBwb29sLmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtZGVkaWNhdGVkaXBwb29sLXBvb2xuYW1lXG4gICAgICovXG4gICAgcmVhZG9ubHkgcG9vbE5hbWU/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6RGVkaWNhdGVkSXBQb29sLlRhZ3NgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWRlZGljYXRlZGlwcG9vbC5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWRlZGljYXRlZGlwcG9vbC10YWdzXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IENmbkRlZGljYXRlZElwUG9vbC5UYWdzUHJvcGVydHlbXTtcbn1cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuRGVkaWNhdGVkSXBQb29sUHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkRlZGljYXRlZElwUG9vbFByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkRlZGljYXRlZElwUG9vbFByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTO1xuICAgIH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwb29sTmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wb29sTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFncycsIGNkay5saXN0VmFsaWRhdG9yKENmbkRlZGljYXRlZElwUG9vbF9UYWdzUHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLnRhZ3MpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuRGVkaWNhdGVkSXBQb29sUHJvcHNcIicpO1xufVxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpEZWRpY2F0ZWRJcFBvb2xgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkRlZGljYXRlZElwUG9vbFByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpEZWRpY2F0ZWRJcFBvb2xgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuRGVkaWNhdGVkSXBQb29sUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgQ2ZuRGVkaWNhdGVkSXBQb29sUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIFBvb2xOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnBvb2xOYW1lKSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2ZuRGVkaWNhdGVkSXBQb29sVGFnc1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICB9O1xufVxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkRlZGljYXRlZElwUG9vbFByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IENmbkRlZGljYXRlZElwUG9vbFByb3BzIHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyB8fCB7fTtcbiAgICByZXR1cm4ge1xuICAgICAgICBwb29sTmFtZTogcHJvcGVydGllcy5Qb29sTmFtZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Qb29sTmFtZSkgOiB1bmRlZmluZWQsXG4gICAgICAgIHRhZ3M6IHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShDZm5EZWRpY2F0ZWRJcFBvb2xUYWdzUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuVGFncykgOiB1bmRlZmluZWQgYXMgYW55LFxuICAgIH07XG59XG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6UGlucG9pbnRFbWFpbDo6RGVkaWNhdGVkSXBQb29sYFxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6UGlucG9pbnRFbWFpbDo6RGVkaWNhdGVkSXBQb29sXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXBpbnBvaW50ZW1haWwtZGVkaWNhdGVkaXBwb29sLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbkRlZGljYXRlZElwUG9vbCBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OlBpbnBvaW50RW1haWw6OkRlZGljYXRlZElwUG9vbFwiO1xuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmbkRlZGljYXRlZElwUG9vbCB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzID0gQ2ZuRGVkaWNhdGVkSXBQb29sUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkRlZGljYXRlZElwUG9vbChzY29wZSwgaWQsIHByb3BzKTtcbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBgQVdTOjpQaW5wb2ludEVtYWlsOjpEZWRpY2F0ZWRJcFBvb2wuUG9vbE5hbWVgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWRlZGljYXRlZGlwcG9vbC5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWRlZGljYXRlZGlwcG9vbC1wb29sbmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyBwb29sTmFtZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuICAgIC8qKlxuICAgICAqIGBBV1M6OlBpbnBvaW50RW1haWw6OkRlZGljYXRlZElwUG9vbC5UYWdzYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1kZWRpY2F0ZWRpcHBvb2wuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1kZWRpY2F0ZWRpcHBvb2wtdGFnc1xuICAgICAqL1xuICAgIHB1YmxpYyB0YWdzOiBDZm5EZWRpY2F0ZWRJcFBvb2wuVGFnc1Byb3BlcnR5W10gfCB1bmRlZmluZWQ7XG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OlBpbnBvaW50RW1haWw6OkRlZGljYXRlZElwUG9vbGAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuRGVkaWNhdGVkSXBQb29sUHJvcHMgPSB7fSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuRGVkaWNhdGVkSXBQb29sLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICB0aGlzLnBvb2xOYW1lID0gcHJvcHMucG9vbE5hbWU7XG4gICAgICAgIHRoaXMudGFncyA9IHByb3BzLnRhZ3M7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKiBAc3RhYmlsaXR5IGV4cGVyaW1lbnRhbFxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5EZWRpY2F0ZWRJcFBvb2wuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3RlY3RlZCBnZXQgY2ZuUHJvcGVydGllcygpOiB7XG4gICAgICAgIFtrZXk6IHN0cmluZ106IGFueTtcbiAgICB9IHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIHBvb2xOYW1lOiB0aGlzLnBvb2xOYW1lLFxuICAgICAgICAgICAgdGFnczogdGhpcy50YWdzLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1xuICAgICAgICBba2V5OiBzdHJpbmddOiBhbnk7XG4gICAgfSk6IHtcbiAgICAgICAgW2tleTogc3RyaW5nXTogYW55O1xuICAgIH0ge1xuICAgICAgICByZXR1cm4gY2ZuRGVkaWNhdGVkSXBQb29sUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5leHBvcnQgbmFtZXNwYWNlIENmbkRlZGljYXRlZElwUG9vbCB7XG4gICAgLyoqXG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1waW5wb2ludGVtYWlsLWRlZGljYXRlZGlwcG9vbC10YWdzLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFRhZ3NQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBgQ2ZuRGVkaWNhdGVkSXBQb29sLlRhZ3NQcm9wZXJ0eS5LZXlgXG4gICAgICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1waW5wb2ludGVtYWlsLWRlZGljYXRlZGlwcG9vbC10YWdzLmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtZGVkaWNhdGVkaXBwb29sLXRhZ3Mta2V5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBrZXk/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBgQ2ZuRGVkaWNhdGVkSXBQb29sLlRhZ3NQcm9wZXJ0eS5WYWx1ZWBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtZGVkaWNhdGVkaXBwb29sLXRhZ3MuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1kZWRpY2F0ZWRpcHBvb2wtdGFncy12YWx1ZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdmFsdWU/OiBzdHJpbmc7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBUYWdzUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFRhZ3NQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5EZWRpY2F0ZWRJcFBvb2xfVGFnc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTO1xuICAgIH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdrZXknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMua2V5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd2YWx1ZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52YWx1ZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJUYWdzUHJvcGVydHlcIicpO1xufVxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpEZWRpY2F0ZWRJcFBvb2wuVGFnc2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgVGFnc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpEZWRpY2F0ZWRJcFBvb2wuVGFnc2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5EZWRpY2F0ZWRJcFBvb2xUYWdzUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgQ2ZuRGVkaWNhdGVkSXBQb29sX1RhZ3NQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgS2V5OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmtleSksXG4gICAgICAgIFZhbHVlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnZhbHVlKSxcbiAgICB9O1xufVxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkRlZGljYXRlZElwUG9vbFRhZ3NQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBDZm5EZWRpY2F0ZWRJcFBvb2wuVGFnc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlIHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgfHwge307XG4gICAgcmV0dXJuIHtcbiAgICAgICAga2V5OiBwcm9wZXJ0aWVzLktleSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXkpIDogdW5kZWZpbmVkLFxuICAgICAgICB2YWx1ZTogcHJvcGVydGllcy5WYWx1ZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5WYWx1ZSkgOiB1bmRlZmluZWQsXG4gICAgfTtcbn1cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQVdTOjpQaW5wb2ludEVtYWlsOjpJZGVudGl0eWBcbiAqXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXBpbnBvaW50ZW1haWwtaWRlbnRpdHkuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbklkZW50aXR5UHJvcHMge1xuICAgIC8qKlxuICAgICAqIGBBV1M6OlBpbnBvaW50RW1haWw6OklkZW50aXR5Lk5hbWVgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWlkZW50aXR5Lmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtaWRlbnRpdHktbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBgQVdTOjpQaW5wb2ludEVtYWlsOjpJZGVudGl0eS5Ea2ltU2lnbmluZ0VuYWJsZWRgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWlkZW50aXR5Lmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtaWRlbnRpdHktZGtpbXNpZ25pbmdlbmFibGVkXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGtpbVNpZ25pbmdFbmFibGVkPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAvKipcbiAgICAgKiBgQVdTOjpQaW5wb2ludEVtYWlsOjpJZGVudGl0eS5GZWVkYmFja0ZvcndhcmRpbmdFbmFibGVkYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1pZGVudGl0eS5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWlkZW50aXR5LWZlZWRiYWNrZm9yd2FyZGluZ2VuYWJsZWRcbiAgICAgKi9cbiAgICByZWFkb25seSBmZWVkYmFja0ZvcndhcmRpbmdFbmFibGVkPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAvKipcbiAgICAgKiBgQVdTOjpQaW5wb2ludEVtYWlsOjpJZGVudGl0eS5NYWlsRnJvbUF0dHJpYnV0ZXNgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWlkZW50aXR5Lmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtaWRlbnRpdHktbWFpbGZyb21hdHRyaWJ1dGVzXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWFpbEZyb21BdHRyaWJ1dGVzPzogQ2ZuSWRlbnRpdHkuTWFpbEZyb21BdHRyaWJ1dGVzUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6SWRlbnRpdHkuVGFnc2BcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXBpbnBvaW50ZW1haWwtaWRlbnRpdHkuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1pZGVudGl0eS10YWdzXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IENmbklkZW50aXR5LlRhZ3NQcm9wZXJ0eVtdO1xufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5JZGVudGl0eVByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5JZGVudGl0eVByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbklkZW50aXR5UHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7XG4gICAgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2RraW1TaWduaW5nRW5hYmxlZCcsIGNkay52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuZGtpbVNpZ25pbmdFbmFibGVkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdmZWVkYmFja0ZvcndhcmRpbmdFbmFibGVkJywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5mZWVkYmFja0ZvcndhcmRpbmdFbmFibGVkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtYWlsRnJvbUF0dHJpYnV0ZXMnLCBDZm5JZGVudGl0eV9NYWlsRnJvbUF0dHJpYnV0ZXNQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5tYWlsRnJvbUF0dHJpYnV0ZXMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25hbWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuSWRlbnRpdHlfVGFnc1Byb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy50YWdzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmbklkZW50aXR5UHJvcHNcIicpO1xufVxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpJZGVudGl0eWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuSWRlbnRpdHlQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6UGlucG9pbnRFbWFpbDo6SWRlbnRpdHlgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuSWRlbnRpdHlQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBwcm9wZXJ0aWVzO1xuICAgIH1cbiAgICBDZm5JZGVudGl0eVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5hbWUpLFxuICAgICAgICBEa2ltU2lnbmluZ0VuYWJsZWQ6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRraW1TaWduaW5nRW5hYmxlZCksXG4gICAgICAgIEZlZWRiYWNrRm9yd2FyZGluZ0VuYWJsZWQ6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmZlZWRiYWNrRm9yd2FyZGluZ0VuYWJsZWQpLFxuICAgICAgICBNYWlsRnJvbUF0dHJpYnV0ZXM6IGNmbklkZW50aXR5TWFpbEZyb21BdHRyaWJ1dGVzUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWFpbEZyb21BdHRyaWJ1dGVzKSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2ZuSWRlbnRpdHlUYWdzUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLnRhZ3MpLFxuICAgIH07XG59XG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuSWRlbnRpdHlQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBDZm5JZGVudGl0eVByb3BzIHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyB8fCB7fTtcbiAgICByZXR1cm4ge1xuICAgICAgICBuYW1lOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk5hbWUpLFxuICAgICAgICBka2ltU2lnbmluZ0VuYWJsZWQ6IHByb3BlcnRpZXMuRGtpbVNpZ25pbmdFbmFibGVkICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5Ea2ltU2lnbmluZ0VuYWJsZWQpIDogdW5kZWZpbmVkLFxuICAgICAgICBmZWVkYmFja0ZvcndhcmRpbmdFbmFibGVkOiBwcm9wZXJ0aWVzLkZlZWRiYWNrRm9yd2FyZGluZ0VuYWJsZWQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0Qm9vbGVhbihwcm9wZXJ0aWVzLkZlZWRiYWNrRm9yd2FyZGluZ0VuYWJsZWQpIDogdW5kZWZpbmVkLFxuICAgICAgICBtYWlsRnJvbUF0dHJpYnV0ZXM6IHByb3BlcnRpZXMuTWFpbEZyb21BdHRyaWJ1dGVzICE9IG51bGwgPyBDZm5JZGVudGl0eU1haWxGcm9tQXR0cmlidXRlc1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuTWFpbEZyb21BdHRyaWJ1dGVzKSA6IHVuZGVmaW5lZCxcbiAgICAgICAgdGFnczogcHJvcGVydGllcy5UYWdzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFycmF5KENmbklkZW50aXR5VGFnc1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLlRhZ3MpIDogdW5kZWZpbmVkIGFzIGFueSxcbiAgICB9O1xufVxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6OlBpbnBvaW50RW1haWw6OklkZW50aXR5YFxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6UGlucG9pbnRFbWFpbDo6SWRlbnRpdHlcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1pZGVudGl0eS5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5JZGVudGl0eSBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OlBpbnBvaW50RW1haWw6OklkZW50aXR5XCI7XG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuSWRlbnRpdHkge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wcyA9IENmbklkZW50aXR5UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbklkZW50aXR5KHNjb3BlLCBpZCwgcHJvcHMpO1xuICAgICAgICBvcHRpb25zLnBhcnNlci5oYW5kbGVBdHRyaWJ1dGVzKHJldCwgcmVzb3VyY2VBdHRyaWJ1dGVzLCBpZCk7XG4gICAgICAgIHJldHVybiByZXQ7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBJZGVudGl0eUROU1JlY29yZE5hbWUxXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJJZGVudGl0eURuc1JlY29yZE5hbWUxOiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIElkZW50aXR5RE5TUmVjb3JkTmFtZTJcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0cklkZW50aXR5RG5zUmVjb3JkTmFtZTI6IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgSWRlbnRpdHlETlNSZWNvcmROYW1lM1xuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRySWRlbnRpdHlEbnNSZWNvcmROYW1lMzogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBJZGVudGl0eUROU1JlY29yZFZhbHVlMVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRySWRlbnRpdHlEbnNSZWNvcmRWYWx1ZTE6IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgSWRlbnRpdHlETlNSZWNvcmRWYWx1ZTJcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0cklkZW50aXR5RG5zUmVjb3JkVmFsdWUyOiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIElkZW50aXR5RE5TUmVjb3JkVmFsdWUzXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJJZGVudGl0eURuc1JlY29yZFZhbHVlMzogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIGBBV1M6OlBpbnBvaW50RW1haWw6OklkZW50aXR5Lk5hbWVgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWlkZW50aXR5Lmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtaWRlbnRpdHktbmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyBuYW1lOiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6SWRlbnRpdHkuRGtpbVNpZ25pbmdFbmFibGVkYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1pZGVudGl0eS5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWlkZW50aXR5LWRraW1zaWduaW5nZW5hYmxlZFxuICAgICAqL1xuICAgIHB1YmxpYyBka2ltU2lnbmluZ0VuYWJsZWQ6IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6SWRlbnRpdHkuRmVlZGJhY2tGb3J3YXJkaW5nRW5hYmxlZGBcbiAgICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXBpbnBvaW50ZW1haWwtaWRlbnRpdHkuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1pZGVudGl0eS1mZWVkYmFja2ZvcndhcmRpbmdlbmFibGVkXG4gICAgICovXG4gICAgcHVibGljIGZlZWRiYWNrRm9yd2FyZGluZ0VuYWJsZWQ6IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG4gICAgLyoqXG4gICAgICogYEFXUzo6UGlucG9pbnRFbWFpbDo6SWRlbnRpdHkuTWFpbEZyb21BdHRyaWJ1dGVzYFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtcGlucG9pbnRlbWFpbC1pZGVudGl0eS5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWlkZW50aXR5LW1haWxmcm9tYXR0cmlidXRlc1xuICAgICAqL1xuICAgIHB1YmxpYyBtYWlsRnJvbUF0dHJpYnV0ZXM6IENmbklkZW50aXR5Lk1haWxGcm9tQXR0cmlidXRlc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuICAgIC8qKlxuICAgICAqIGBBV1M6OlBpbnBvaW50RW1haWw6OklkZW50aXR5LlRhZ3NgXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1waW5wb2ludGVtYWlsLWlkZW50aXR5Lmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtaWRlbnRpdHktdGFnc1xuICAgICAqL1xuICAgIHB1YmxpYyB0YWdzOiBDZm5JZGVudGl0eS5UYWdzUHJvcGVydHlbXSB8IHVuZGVmaW5lZDtcbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6UGlucG9pbnRFbWFpbDo6SWRlbnRpdHlgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbklkZW50aXR5UHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmbklkZW50aXR5LkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnbmFtZScsIHRoaXMpO1xuICAgICAgICB0aGlzLmF0dHJJZGVudGl0eURuc1JlY29yZE5hbWUxID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdJZGVudGl0eUROU1JlY29yZE5hbWUxJykpO1xuICAgICAgICB0aGlzLmF0dHJJZGVudGl0eURuc1JlY29yZE5hbWUyID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdJZGVudGl0eUROU1JlY29yZE5hbWUyJykpO1xuICAgICAgICB0aGlzLmF0dHJJZGVudGl0eURuc1JlY29yZE5hbWUzID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdJZGVudGl0eUROU1JlY29yZE5hbWUzJykpO1xuICAgICAgICB0aGlzLmF0dHJJZGVudGl0eURuc1JlY29yZFZhbHVlMSA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnSWRlbnRpdHlETlNSZWNvcmRWYWx1ZTEnKSk7XG4gICAgICAgIHRoaXMuYXR0cklkZW50aXR5RG5zUmVjb3JkVmFsdWUyID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdJZGVudGl0eUROU1JlY29yZFZhbHVlMicpKTtcbiAgICAgICAgdGhpcy5hdHRySWRlbnRpdHlEbnNSZWNvcmRWYWx1ZTMgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0lkZW50aXR5RE5TUmVjb3JkVmFsdWUzJykpO1xuICAgICAgICB0aGlzLm5hbWUgPSBwcm9wcy5uYW1lO1xuICAgICAgICB0aGlzLmRraW1TaWduaW5nRW5hYmxlZCA9IHByb3BzLmRraW1TaWduaW5nRW5hYmxlZDtcbiAgICAgICAgdGhpcy5mZWVkYmFja0ZvcndhcmRpbmdFbmFibGVkID0gcHJvcHMuZmVlZGJhY2tGb3J3YXJkaW5nRW5hYmxlZDtcbiAgICAgICAgdGhpcy5tYWlsRnJvbUF0dHJpYnV0ZXMgPSBwcm9wcy5tYWlsRnJvbUF0dHJpYnV0ZXM7XG4gICAgICAgIHRoaXMudGFncyA9IHByb3BzLnRhZ3M7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKiBAc3RhYmlsaXR5IGV4cGVyaW1lbnRhbFxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5JZGVudGl0eS5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHtcbiAgICAgICAgW2tleTogc3RyaW5nXTogYW55O1xuICAgIH0ge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZTogdGhpcy5uYW1lLFxuICAgICAgICAgICAgZGtpbVNpZ25pbmdFbmFibGVkOiB0aGlzLmRraW1TaWduaW5nRW5hYmxlZCxcbiAgICAgICAgICAgIGZlZWRiYWNrRm9yd2FyZGluZ0VuYWJsZWQ6IHRoaXMuZmVlZGJhY2tGb3J3YXJkaW5nRW5hYmxlZCxcbiAgICAgICAgICAgIG1haWxGcm9tQXR0cmlidXRlczogdGhpcy5tYWlsRnJvbUF0dHJpYnV0ZXMsXG4gICAgICAgICAgICB0YWdzOiB0aGlzLnRhZ3MsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7XG4gICAgICAgIFtrZXk6IHN0cmluZ106IGFueTtcbiAgICB9KToge1xuICAgICAgICBba2V5OiBzdHJpbmddOiBhbnk7XG4gICAgfSB7XG4gICAgICAgIHJldHVybiBjZm5JZGVudGl0eVByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuZXhwb3J0IG5hbWVzcGFjZSBDZm5JZGVudGl0eSB7XG4gICAgLyoqXG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1waW5wb2ludGVtYWlsLWlkZW50aXR5LW1haWxmcm9tYXR0cmlidXRlcy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBNYWlsRnJvbUF0dHJpYnV0ZXNQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBgQ2ZuSWRlbnRpdHkuTWFpbEZyb21BdHRyaWJ1dGVzUHJvcGVydHkuQmVoYXZpb3JPbk14RmFpbHVyZWBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtaWRlbnRpdHktbWFpbGZyb21hdHRyaWJ1dGVzLmh0bWwjY2ZuLXBpbnBvaW50ZW1haWwtaWRlbnRpdHktbWFpbGZyb21hdHRyaWJ1dGVzLWJlaGF2aW9yb25teGZhaWx1cmVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGJlaGF2aW9yT25NeEZhaWx1cmU/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBgQ2ZuSWRlbnRpdHkuTWFpbEZyb21BdHRyaWJ1dGVzUHJvcGVydHkuTWFpbEZyb21Eb21haW5gXG4gICAgICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1waW5wb2ludGVtYWlsLWlkZW50aXR5LW1haWxmcm9tYXR0cmlidXRlcy5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWlkZW50aXR5LW1haWxmcm9tYXR0cmlidXRlcy1tYWlsZnJvbWRvbWFpblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWFpbEZyb21Eb21haW4/OiBzdHJpbmc7XG4gICAgfVxufVxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBNYWlsRnJvbUF0dHJpYnV0ZXNQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTWFpbEZyb21BdHRyaWJ1dGVzUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuSWRlbnRpdHlfTWFpbEZyb21BdHRyaWJ1dGVzUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7XG4gICAgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2JlaGF2aW9yT25NeEZhaWx1cmUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYmVoYXZpb3JPbk14RmFpbHVyZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWFpbEZyb21Eb21haW4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubWFpbEZyb21Eb21haW4pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiTWFpbEZyb21BdHRyaWJ1dGVzUHJvcGVydHlcIicpO1xufVxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpJZGVudGl0eS5NYWlsRnJvbUF0dHJpYnV0ZXNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1haWxGcm9tQXR0cmlidXRlc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpJZGVudGl0eS5NYWlsRnJvbUF0dHJpYnV0ZXNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuSWRlbnRpdHlNYWlsRnJvbUF0dHJpYnV0ZXNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBwcm9wZXJ0aWVzO1xuICAgIH1cbiAgICBDZm5JZGVudGl0eV9NYWlsRnJvbUF0dHJpYnV0ZXNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgQmVoYXZpb3JPbk14RmFpbHVyZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5iZWhhdmlvck9uTXhGYWlsdXJlKSxcbiAgICAgICAgTWFpbEZyb21Eb21haW46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWFpbEZyb21Eb21haW4pLFxuICAgIH07XG59XG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuSWRlbnRpdHlNYWlsRnJvbUF0dHJpYnV0ZXNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBDZm5JZGVudGl0eS5NYWlsRnJvbUF0dHJpYnV0ZXNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIHByb3BlcnRpZXM7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzIHx8IHt9O1xuICAgIHJldHVybiB7XG4gICAgICAgIGJlaGF2aW9yT25NeEZhaWx1cmU6IHByb3BlcnRpZXMuQmVoYXZpb3JPbk14RmFpbHVyZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5CZWhhdmlvck9uTXhGYWlsdXJlKSA6IHVuZGVmaW5lZCxcbiAgICAgICAgbWFpbEZyb21Eb21haW46IHByb3BlcnRpZXMuTWFpbEZyb21Eb21haW4gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTWFpbEZyb21Eb21haW4pIDogdW5kZWZpbmVkLFxuICAgIH07XG59XG5leHBvcnQgbmFtZXNwYWNlIENmbklkZW50aXR5IHtcbiAgICAvKipcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtaWRlbnRpdHktdGFncy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBUYWdzUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogYENmbklkZW50aXR5LlRhZ3NQcm9wZXJ0eS5LZXlgXG4gICAgICAgICAqIEBzZWUgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1waW5wb2ludGVtYWlsLWlkZW50aXR5LXRhZ3MuaHRtbCNjZm4tcGlucG9pbnRlbWFpbC1pZGVudGl0eS10YWdzLWtleVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkga2V5Pzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogYENmbklkZW50aXR5LlRhZ3NQcm9wZXJ0eS5WYWx1ZWBcbiAgICAgICAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXBpbnBvaW50ZW1haWwtaWRlbnRpdHktdGFncy5odG1sI2Nmbi1waW5wb2ludGVtYWlsLWlkZW50aXR5LXRhZ3MtdmFsdWVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHZhbHVlPzogc3RyaW5nO1xuICAgIH1cbn1cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgVGFnc1Byb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBUYWdzUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuSWRlbnRpdHlfVGFnc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTO1xuICAgIH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdrZXknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMua2V5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd2YWx1ZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52YWx1ZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJUYWdzUHJvcGVydHlcIicpO1xufVxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpQaW5wb2ludEVtYWlsOjpJZGVudGl0eS5UYWdzYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBUYWdzUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlBpbnBvaW50RW1haWw6OklkZW50aXR5LlRhZ3NgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuSWRlbnRpdHlUYWdzUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgQ2ZuSWRlbnRpdHlfVGFnc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBLZXk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMua2V5KSxcbiAgICAgICAgVmFsdWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudmFsdWUpLFxuICAgIH07XG59XG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuSWRlbnRpdHlUYWdzUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogQ2ZuSWRlbnRpdHkuVGFnc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlIHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gcHJvcGVydGllcztcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgfHwge307XG4gICAgcmV0dXJuIHtcbiAgICAgICAga2V5OiBwcm9wZXJ0aWVzLktleSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXkpIDogdW5kZWZpbmVkLFxuICAgICAgICB2YWx1ZTogcHJvcGVydGllcy5WYWx1ZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5WYWx1ZSkgOiB1bmRlZmluZWQsXG4gICAgfTtcbn1cbiJdfQ==