"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3EventSource = void 0;
const notifs = require("../../aws-s3-notifications"); // Automatically re-written from '@aws-cdk/aws-s3-notifications'
/**
 * Use S3 bucket notifications as an event source for AWS Lambda.
 */
class S3EventSource {
    constructor(bucket, props) {
        this.bucket = bucket;
        this.props = props;
    }
    bind(target) {
        const filters = this.props.filters || [];
        for (const event of this.props.events) {
            this.bucket.addEventNotification(event, new notifs.LambdaDestination(target), ...filters);
        }
    }
}
exports.S3EventSource = S3EventSource;
//# sourceMappingURL=data:application/json;base64,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